/*****************************************************************************
;
;   (C) Unpublished Work of ADMtek Incorporated.  All Rights Reserved.
;
;       THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL,
;       PROPRIETARY AND TRADESECRET INFORMATION OF ADMTEK INCORPORATED.
;       ACCESS TO THIS WORK IS RESTRICTED TO (I) ADMTEK EMPLOYEES WHO HAVE A
;       NEED TO KNOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR ASSIGNMENTS
;       AND (II) ENTITIES OTHER THAN ADMTEK WHO HAVE ENTERED INTO APPROPRIATE
;       LICENSE AGREEMENTS.  NO PART OF THIS WORK MAY BE USED, PRACTICED,
;       PERFORMED, COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,
;       ABBRIDGED, CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED, RECAST,
;       TRANSFORMED OR ADAPTED WITHOUT THE PRIOR WRITTEN CONSENT OF ADMTEK.
;       ANY USE OR EXPLOITATION OF THIS WORK WITHOUT AUTHORIZATION COULD
;       SUBJECT THE PERPERTRATOR TO CRIMINAL AND CIVIL LIABILITY.
;
;------------------------------------------------------------------------------
;
;    Project : ADM5120
;    Creator : daniell@admtek.com.tw
;    File    : net/am5120sw/if5120.h
;	 Date    : 2003.5.14
;    Abstract: ADM5120 Switch driver
;
;Modification History:
;
;*****************************************************************************/

#ifndef __NET_IF5120_H__
#define __NET_IF5120_H__

#include <asm/am5120/adm5120.h>
#include <asm/am5120/mx.h>

/*********************  MII Phy Reg Access  *****************/
#define PHY_ADDR_MASK					0x0000000f
#define PHY_REG_MASK					0x00001f00
#define PHY_WRITE_CMD					0x00002000
#define PHY_READ_CMD					0x00004000

#define PHY_REG_SHIFT					8

#define PHY_WRITE_OK					0x00000001
#define PHY_READ_OK						0x00000002
#define PHY_DATA_MASK					0xffff0000
#define PHY_DATA_SHIFT					16

#define	MII_PHY_CTRL_REG				0
#define	MII_PHY_STATUS_REG				1
#define MII_PHY_ID0_REG					2
#define MII_PHY_ID1_REG					3
#define MII_PHY_ANAR_REG				4
#define MII_PHY_ANLPAR_REG				5
#define MII_PHY_LINK_REG				0x10

#define MII_PHY_FORCE_LINK				0x03

/******************  Tx/Rx Desc  ******************/
#define HWDESC_ALIGN					16

// Common
#define OWN_BIT							0x80000000
#define END_OF_RING						0x10000000
#define BUF_ADDR_MASK					0x00ffffff
#define BUF2_EN							0x80000000

#define BUF1_LEN_MASK					0x000007ff
#define PKT_LEN_MASK					0x07ff0000
#define PKT_LEN_SHIFT					16

// RxDesc Only
#define RX_SRC_PORT_MASK				0x00007000
#define RX_SRC_PORT_SHIFT				12

#define RX_FRAME_TYPE_MASK				0x00000030
#define RX_FRAME_UC						0
#define RX_FRAME_MC						0x00000010
#define RX_FRAME_BC						0x00000020

#define RX_PKT_IPSUM_ERR				0x00000008
#define RX_PKT_VLAN_TAG					0x00000004

#define RX_PKT_TYPE_MASK				0x00000003
#define RX_PKT_IP						0x00000000
#define RX_PKT_PPPOE					0x00000001

#define RX_PKT_FLAG_MASK				0x0000007F

// TxDesc Only
#define TX_ADD_IPSUM					0x80000000
#define TX_DEST_VLAN_MASK				0x0000003F
#define TX_DEST_PORT_MASK				0x00003F00

/*****************  VLAN  *******************/
#define MAX_VLAN_GROUP					6
#define VLAN_PORT_MASK					0x7f

// Vlan status
#define VLAN_NOT_DEFINED				0
#define VLAN_DISABLED					1
#define VLAN_ENABLED					2

#define VLAN_NONE						0x00
#define VLAN0_ID						0x01
#define VLAN1_ID						0x02
#define VLAN2_ID						0x04
#define VLAN3_ID						0x08
#define VLAN4_ID						0x10
#define VLAN5_ID						0x20

#define VLAN_ALL						0x3f

/********************  Interrupts  *****************/
#define RX_H_INT						(RX_H_DONE_INT | RX_H_DESC_FULL_INT)
#define RX_L_INT						(RX_L_DONE_INT | RX_L_DESC_FULL_INT)
#define TX_H_INT						SEND_H_DONE_INT
#define TX_L_INT						SEND_L_DONE_INT
#define LINK_INT						PORT_STATUS_CHANGE_INT

#define PORT_INT						PORT_STATUS_CHANGE_INT
#define WATCHDOG0_INT					WATCHDOG0_EXPR_INT
#define WATCHDOG1_INT					WATCHDOG1_EXPR_INT

/********************  Switch Ports  ***************/
#define CPU_PORT						6
#define CPU_PORT_MASK					(0x1 << CPU_PORT)
#define GMII_PORT						5
#define IF5120_LAST_PORT				GMII_PORT
#define NUM_IF5120_PORTS				(IF5120_LAST_PORT+1)		// Excluding the cpu port
#define IF5120_PORT_MASK				0x3f						// Excluding the cpu port
#define PORT_VLAN_MASK					0x3f
#define IF5120_PORT_NUM					7

// Port status
#define PORT_DISABLED					0
#define PORT_ENABLED					1

/********************  Switch Config  ***************/
#define DEF_CPUPORT_CFG					(SW_CPU_PORT_DISABLE | SW_PADING_CRC | SW_DIS_UN_MASK)
#define DEF_PORTS_CFG					( SW_EN_BP_MASK | SW_EN_MC_MASK | SW_DISABLE_PORT_MASK)

/*************************************************************/
#define ETH_MAC_LEN						6
#define ETH_VLANTAG_LEN					4
#define ETH_CRC_LEN						4			// Ethernet CRC Length

#define TX_SMALL_BUF_SIZE				256
#define TX_LARGE_BUF_SIZE				1536
#define TX_BUF_SIZE						1536

#define RX_BUF_SIZE						1680
#define RX_BUF_REV_SIZE					130
#define DEF_RX_BUF_SIZE					(RX_BUF_SIZE - RX_BUF_REV_SIZE)

#define SMALL_PKT_LEN					TX_SMALL_BUF_SIZE
#define MAX_PKT_LEN						1514

#define MIN_ETH_FRAME_LEN				60

/****************  PSEUDO-NIC Control Flags *************************/
#define IF_TX_PRIORITY_H				0x0001
#define IF_PROMISC_MODE					0x0002
#define IF_ATTACH_BRIDGE				0x0010
#define IF_BRIDGE_HOSTIF				0x0020
#define IF_CTRL_FLAG_MASK				0x0033
#define IF_MAC_ALIAS					0x0100


/****************  driver data structure ****************************/
#define AM5120SW_IFNUM	2

/* tx hardware descriptor */
typedef struct am5120sw_tx_desc_s 
{
	unsigned long buf1cntl;
	unsigned long buf2cntl;
	unsigned long buf1len;
	unsigned long pktcntl;
} TXDESC_T, *PTXDESC_T;

/* tx driver descriptor */
typedef struct am5120sw_tx_drv_desc_s
{
	struct sk_buff *skb;
} TX_DRV_DESC_T, *PTX_DRV_DESC_T;

/* Tx engine */
typedef struct am5120sw_tx_eng_s 
{
	PTXDESC_T hwDesc;
	PTX_DRV_DESC_T drvDesc;
	int numDesc;
	int idxHead;
	int idxTail;
	unsigned long txTrig;
} TX_ENG_T, *PTX_ENG_T;

/* rx descriptor */
typedef struct am5120sw_rx_desc_s 
{
	unsigned long buf1cntl;
	unsigned long buf2cntl;
	unsigned long buf1len;
	unsigned long status;
} RXDESC_T, *PRXDESC_T;

/* rx driver descriptor */
typedef struct am5120sw_rx_drv_desc_s
{
	struct sk_buff *skb;
} RX_DRV_DESC_T, *PRX_DRV_DESC_T;

/* Rx engine */
typedef struct am5120sw_rx_eng_s 
{
	PRXDESC_T hwDesc;
	PRX_DRV_DESC_T drvDesc;
	int numDesc;
	int idx;
} RX_ENG_T, *PRX_ENG_T;

/* port status */
typedef struct port_status_s 
{
	unsigned long status;
	unsigned long vlanId;
	unsigned long ifUnit;
} PORT_CFG_T, *PPORT_CFG_T;

/* switch context */
typedef struct am5120sw_context_s 
{
	TX_ENG_T txH, txL;
	RX_ENG_T rxH, rxL;

	PORT_CFG_T port[NUM_IF5120_PORTS];

	/* Vlan group of IF unit */
	unsigned long vlanGrp[MAX_VLAN_GROUP];

	unsigned long intMask;
	unsigned long intStatus;
	unsigned long linkStatus;

	int ifCnt;
	int actIfCnt;
	
	/* tx drv descriptor pool */
	unsigned char *txDrvDescPool;

	/* rx drv descriptor pool */
	unsigned char *rxDrvDescPool;

	/* Hardware descriptor pool */
	unsigned char *hwDescPool;

	spinlock_t lock;

} SW_CONTEXT_T, *PSW_CONTEXT_T;

/* net device private data */
typedef struct am5120sw_priv_s 
{
	struct net_device_stats stats;
	
	spinlock_t lock;

	/* interface unit */
	int unit;

	int status;
	int priority;
	int csum_flags;

	/* interface flags */
	int iflags; //Daniel+ 2003.8.4

	/* for fill tx descriptor */
	unsigned long vlanId;

} SW_PRIV_T, *PSW_PRIV_T;


#define MEM_KSEG0_BASE					0x80000000
#define MEM_KSEG1_BASE					0xA0000000
#define MEM_SEG_MASK					0xE0000000
#define KVA2PA(_addr)					((unsigned long)(_addr) & ~MEM_SEG_MASK)

#define MIPS_KSEG0A(_addr)				(KVA2PA(_addr) | MEM_KSEG0_BASE)
#define MIPS_KSEG1A(_addr)				(KVA2PA(_addr) | MEM_KSEG1_BASE)

#define PA2VA(_addr)					(KVA2PA(_addr) | MEM_KSEG1_BASE)
#define PA2CACHEVA(_addr)				(KVA2PA(_addr) | MEM_KSEG0_BASE)


#define AM5120SW_BOARD_CFG_ADDR			0x1fc08000
#define AM5120SW_BOARD_CFG_SIZE			0x8000
#define AM5120SW_IFNUM					2
#define AM5120_IFNUM_MAX				6
#define AM5120SW_DEFAULT_MAC0			"\x00\x50\xfc\x11\x22\x33"
#define AM5120SW_DEFAULT_MAC1			"\x00\x50\xfc\x33\x22\x11"
#define AM5120SW_IF0					"eth0"
#define AM5120SW_IF1					"eth1"



#endif /* __NET_TULIP_H__ */





