/*****************************************************************************
;
;   (C) Unpublished Work of ADMtek Incorporated.  All Rights Reserved.
;
;       THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL,
;       PROPRIETARY AND TRADESECRET INFORMATION OF ADMTEK INCORPORATED.
;       ACCESS TO THIS WORK IS RESTRICTED TO (I) ADMTEK EMPLOYEES WHO HAVE A
;       NEED TO KNOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR ASSIGNMENTS
;       AND (II) ENTITIES OTHER THAN ADMTEK WHO HAVE ENTERED INTO APPROPRIATE
;       LICENSE AGREEMENTS.  NO PART OF THIS WORK MAY BE USED, PRACTICED,
;       PERFORMED, COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,
;       ABBRIDGED, CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED, RECAST,
;       TRANSFORMED OR ADAPTED WITHOUT THE PRIOR WRITTEN CONSENT OF ADMTEK.
;       ANY USE OR EXPLOITATION OF THIS WORK WITHOUT AUTHORIZATION COULD
;       SUBJECT THE PERPERTRATOR TO CRIMINAL AND CIVIL LIABILITY.
;
;------------------------------------------------------------------------------
;
;    Project : ADM5120
;    Creator : daniell@admtek.com.tw
;    File    : arch/mips/am5120/setup.c
;	 Date    : 2003.3.4
;    Abstract: 
;
;Modification History:
;
;*****************************************************************************/

#include <linux/config.h>
#include <linux/init.h>
#include <linux/delay.h>
#include <linux/irq.h>
#include <linux/interrupt.h>
#include <linux/serial.h>
#include <linux/types.h>
#include <linux/string.h>	/* for memset */

#include <asm-mips/reboot.h>
#include <asm-mips/io.h>
#include <asm-mips/time.h>
#include <asm-mips/pgtable.h>
#include <asm-mips/processor.h>
#include <asm-mips/system.h>


extern struct rtc_ops am5120_rtc_ops;
extern struct rtc_ops *rtc_ops;

void  mips_timer_setup(struct irqaction *irq);
void  mips_time_init(void);



void am5120_restart(char *command)
{
        set_cp0_status(ST0_BEV | ST0_ERL);
        change_cp0_config(CONF_CM_CMASK, CONF_CM_UNCACHED);
        flush_cache_all();
        write_32bit_cp0_register(CP0_WIRED, 0);
        __asm__ __volatile__("jr\t%0"::"r"(0xbfc00000));
}

void am5120_halt(void)
{
        printk(KERN_NOTICE "\n** You can safely turn off the power\n");
        while (1);
}

void am5120_power_off(void)
{
        am5120_halt();
}


#if 0
static void __init am5120_time_init(void)
{
	/* 100 (CPU clock) MHz divided by 8 */
    mips_counter_frequency = 100000000 / 8;
}
#endif


#if 0
extern int setup_irq(unsigned int irq, struct irqaction *irqaction);

static void __init am5120_timer_setup(struct irqaction *irq)
{
	unsigned int count;

#if 0
    setup_irq(0, irq);

    /* to generate the first CPU timer interrupt */
    count = read_32bit_cp0_register(CP0_COUNT);
    write_32bit_cp0_register(CP0_COMPARE, count + 1000);
#endif
}
#endif


void __init am5120_setup(void)
{
	printk("am5120_setup() starts.\n");

    board_time_init = mips_time_init;//am5120_time_init;
    board_timer_setup = mips_timer_setup;//am5120_timer_setup;

    _machine_restart = am5120_restart;
    _machine_halt = am5120_halt;
    _machine_power_off = am5120_power_off;

	rtc_ops = &am5120_rtc_ops;
    //Jeffrey
    set_io_port_base(KSEG1);
    //set_io_port_base(KSEG1ADDR(0x11500000));
}


const char *get_system_type(void)
{
	return "ADM5120 Demo Board";
}
