/*
 * Licensed under GNU GPL version 2 Copyright Lance Wu 
 * Version: 0.0.1
 *
 * 2003.05.21
 * 	- MSN Messenger File Transfer
 *
 */

#include <linux/config.h>
#include <linux/module.h>

/*
#include <asm/uaccess.h>
#include <linux/proc_fs.h>
*/

#include <linux/ip.h>
#include <net/tcp.h>
#include <linux/ctype.h>

#include <linux/netfilter.h>
#include <linux/netfilter_ipv4/ip_tables.h>
#include <linux/netfilter_ipv4/ip_conntrack_helper.h>
#include "ip_conntrack_msn.h"

#include <net/checksum.h>

MODULE_AUTHOR("Lance Wu ");
MODULE_DESCRIPTION("Netfilter connection tracking module for MSN Messenger");
MODULE_LICENSE("GPL");

#define MAX_PORTS 8
static u_int16_t ports[MAX_PORTS];
static u_int16_t ports_c = 0;
#ifdef MODULE_PARM
MODULE_PARM(ports, "1-" __MODULE_STRING(MAX_PORTS) "i");
MODULE_PARM_DESC(ports, "port numbers of MSN Messenger servers");
#endif

#if 0
#define DEBUGP(format, args...) printk(__FILE__ ":" __FUNCTION__ ": " \
				       format, ## args)
#else
#define DEBUGP(format, args...)
#endif

/*
static u_int16_t Search_AV_Port(const char* data,size_t len)
{
	char* ptr;
	char  port[6]={0};
	unsigned int found_port=0;
	int i,j;

    const char AV_Keyword[] = "IP-Address: ";
    const int  AV_Keyword_len = 12;

    const unsigned int AV_Port_range_start = 5004;
    const unsigned int AV_Port_range_end = 65535;

    for( i=0; i<(len-AV_Keyword_len); i++ )
    {
	    if( !memcmp(data+i,AV_Keyword,AV_Keyword_len) )
		{
			DEBUGP("AV string match!!\n");
			
		    ptr = (char*)(data+i+AV_Keyword_len);

			DEBUGP("ip= ");
			for( j=0; *(ptr+j) != ':'; j++ )
				DEBUGP("%c",*(ptr+j));
			DEBUGP("\n");
			
		    while( *ptr == ' ' )
			    ptr++;
			while( *ptr != ':' )
			{
				if( (*ptr == '\r') || (*ptr == '\n') )
				{
					DEBUGP("port not found!!\n");
					return 0;
				}
				ptr++;
			}
			ptr++;
	        for( j=0; j<5; j++ )
	        {
		        if( (*(ptr+j) == '\r') || (*(ptr+j) == '\n') || (*(ptr+j) < '0') || (*(ptr+j) > '9') )
		        {
			        port[j] = 0;
			        break;
			    }
                else
                {
                    port[j] = *(ptr+j);
                    found_port = found_port*10 + (port[j] - '0');
																															                }
            }
			DEBUGP("Port= %s\n",port);
			
            if( (found_port < AV_Port_range_start) || (found_port > AV_Port_range_end ) )
	            return 0;
            return found_port;
        }
	}
    return 0;
}
*/

static u_int16_t Search_FT_Port(const char* data,size_t len)
{
	char* ptr;
	char  port[6]={0};
	u_int16_t found_port=0;
	int i,j;
	
	const char FT_Keyword[] = "Port:";
	const int  FT_Keyword_len = 5;

	const u_int16_t FT_Port_range_start = 6891;
	const u_int16_t FT_Port_range_end = 6900;
	
	if( len < FT_Keyword_len )
		return 0;
	
	for( i=0; i<(len-FT_Keyword_len); i++ )
	{
		if( !memcmp(data+i,FT_Keyword,FT_Keyword_len) )
		{
			ptr = (char*)(data+i+FT_Keyword_len);
			while( *ptr == ' ' )
				ptr++;
			for( j=0; j<5; j++ )
			{
				if( (*(ptr+j) == '\r') || (*(ptr+j) == '\n') || (*(ptr+j) < '0') || (*(ptr+j) > '9') )
				{
					port[j] = 0;
					break;
				}
				else
				{
					port[j] = *(ptr+j);
					found_port = found_port*10 + (port[j] - '0');
				}
			}
		
			if( (found_port < FT_Port_range_start) || (found_port > FT_Port_range_end ) )
				return 0;
			return found_port;
		}
	}
	
	return 0;
}

static int msn_help(const struct iphdr *iph, size_t len,
	struct ip_conntrack *ct,
	enum ip_conntrack_info ctinfo)
{
	struct tcphdr *tcph = (void *)iph + iph->ihl * 4;
	const char* data = (const char*)tcph + tcph->doff * 4;
	unsigned int tcplen = len - iph->ihl * 4;
	unsigned int datalen = tcplen - tcph->doff * 4;
	struct ip_conntrack_expect exp;
	int dir = CTINFO2DIR(ctinfo);
	u_int16_t port;
	
//	DEBUGP("\nctinfo= %d\n",ctinfo);
				
	DEBUGP("\nfrom %u.%u.%u.%u:%u to %u.%u.%u.%u:%u\n",
					NIPQUAD(iph->saddr),ntohs(tcph->source),
					NIPQUAD(iph->daddr),ntohs(tcph->dest));
//	DEBUGP("datalen= %d\n",datalen);

//	if( ctinfo != IP_CT_ESTABLISHED && ctinfo != IP_CT_ESTABLISHED+IP_CT_IS_REPLY )
//	{
//		DEBUGP("ctinfo incorrect\n");
//		return NF_ACCEPT;
//	}

	DEBUGP("ctinfo= %d,dir= %d\n",ctinfo,dir);
/*
	if( ctinfo == IP_CT_ESTABLISHED )
		DEBUGP("IP_CT_ESTABLISHED\n");
	if( ctinfo == IP_CT_RELATED )
		DEBUGP("IP_CT_RELATED\n");
	if( ctinfo == IP_CT_NEW )
		DEBUGP("IP_CT_NEW\n");
	if( ctinfo == IP_CT_IS_REPLY )
		DEBUGP("IP_CT_IS_REPLY\n");
	if( ctinfo == IP_CT_NUMBER )
		DEBUGP("IP_CT_NUMBER\n");

	if( dir == IP_CT_DIR_ORIGINAL )
		DEBUGP("IP_CT_DIR_ORIGINAL\n");
	if( dir == IP_CT_DIR_REPLY )
		DEBUGP("IP_CT_DIR_REPLY\n");
	if( dir == IP_CT_DIR_MAX )
		DEBUGP("IP_CT_DIR_MAX\n");
*/	
	if( (ctinfo != IP_CT_ESTABLISHED) || (dir != IP_CT_DIR_ORIGINAL) )
		return NF_ACCEPT;
	
	if( tcplen < sizeof(struct tcphdr) || tcplen < tcph->doff*4 )
	{
		DEBUGP("tcplen= %u\n",(unsigned)tcplen);
		return NF_ACCEPT;
	}

	if( tcp_v4_check(tcph, tcplen, iph->saddr, iph->daddr, csum_partial((char*)tcph, tcplen, 0)))
	{
		DEBUGP("cksum error\n");
		return NF_ACCEPT;
	}

	if( datalen < 4 )
	{
		DEBUGP("datalen < 4\n");
		return NF_ACCEPT;
	}
	DEBUGP("datalen= %d\n",datalen);
	
    memset(&exp,0,sizeof(exp));
	
	port = Search_FT_Port(data,datalen);
			
	/*
	if( port == 0 )
	{
		port = Search_AV_Port(data,datalen);
		if( port == 0 )
			return NF_ACCEPT;
        DEBUGP("ip_conntrack_msn: find MSN Messenger Audio & Video port [%d] ",port);
        DEBUGP("from %u.%u.%u.%u:%u to %u.%u.%u.%u:%u\n",
			        NIPQUAD(iph->saddr),ntohs(tcph->source),
			        NIPQUAD(iph->daddr),ntohs(tcph->dest));
        exp.tuple = ((struct ip_conntrack_tuple)
		                    {{ 0, {0}},
		                     { ct->tuplehash[!dir].tuple.dst.ip, {htons(port)},
		                     IPPROTO_UDP }});
        exp.mask.dst.ip = 0xffffffff;
        exp.mask.dst.u.udp.port = 0xffff;
        exp.mask.dst.protonum = 0xffff;
        exp.expectfn = NULL;																
	}
	else
	{
	*/
		DEBUGP("ip_conntrack_msn: find MSN Messenger File Transfer port [%d] ",port);
    	DEBUGP("from %u.%u.%u.%u:%u to %u.%u.%u.%u:%u\n",
					                    NIPQUAD(iph->saddr),ntohs(tcph->source),
					                    NIPQUAD(iph->daddr),ntohs(tcph->dest));
	    exp.tuple = ((struct ip_conntrack_tuple)
						{{ 0, {0}},
						 { ct->tuplehash[!dir].tuple.dst.ip, {htons(port)},
						 IPPROTO_TCP }});
	    exp.mask.dst.ip = 0xffffffff;
	    exp.mask.dst.u.tcp.port = 0xffff;
	    exp.mask.dst.protonum = 0xffff;
	    exp.expectfn = NULL;
//	}
		
//	DEBUGP("!dir");
//	DUMP_TUPLE_RAW(&(ct->tuplehash[!dir].tuple));
//	DEBUGP("dir");
//	DUMP_TUPLE_RAW(&(ct->tuplehash[!dir].tuple));

	ip_conntrack_expect_related(ct, &exp);
	
	return NF_ACCEPT;
}

static struct ip_conntrack_helper msn[MAX_PORTS];
static char msn_names[MAX_PORTS][10];

static void fini(void)
{
	int i;

	for (i = 0 ; i < ports_c; i++) 
	{
		DEBUGP("unregistering helper for port %d\n",ports[i]);
		ip_conntrack_helper_unregister(&msn[i]);
	} 
}

static int __init init(void)
{
	int i, ret;
	char *tmpname;

	if (!ports[0])
		ports[0]=MSN_PORT;

	for (i = 0 ; (i < MAX_PORTS) && ports[i] ; i++) {
		/* Create helper structure */
		memset(&msn[i], 0, sizeof(struct ip_conntrack_helper));

		msn[i].tuple.dst.protonum = IPPROTO_TCP;
		msn[i].tuple.src.u.tcp.port = htons(ports[i]);
		msn[i].mask.dst.protonum = 0xFFFF;
		msn[i].mask.src.u.tcp.port = 0xFFFF;
		msn[i].max_expected = 1;
		msn[i].timeout = 0;
		msn[i].flags = IP_CT_HELPER_F_REUSE_EXPECT;
		msn[i].me = THIS_MODULE;
		msn[i].help = msn_help;

		tmpname = &msn_names[i][0];
		if (ports[i] == MSN_PORT)
			sprintf(tmpname, "msn");
		else
			sprintf(tmpname, "msn-%d", i);
		msn[i].name = tmpname;

		//DEBUGP("MSN port #%d: %d\n", i, ports[i]);

		ret=ip_conntrack_helper_register(&msn[i]);
		if (ret) {
			DEBUGP("ERROR registering helper for port %d\n",
				ports[i]);
			fini();
			return(ret);
		}
		ports_c++;
	}
	return(0);
}

module_init(init);
module_exit(fini);
