/*
 * Licensed under GNU GPL version 2 Copyright Lance Wu
 * Version: 0.0.1
 *
 * 2003.05.21
 * 	- MSN Messenger File Transfer
 *
 * This module currently supports DNAT:
 * iptables -t nat -A PREROUTING -d x.x.x.x -j DNAT --to-dest x.x.x.y
 *
 * and SNAT:
 * iptables -t nat -A POSTROUTING { -j MASQUERADE , -j SNAT --to-source x.x.x.x }
 *
 */

#include <linux/module.h>
#include <linux/netfilter_ipv4.h>
#include <linux/ip.h>
#include <linux/tcp.h>

#include <linux/netfilter.h>
#include <linux/netfilter_ipv4/ip_tables.h>
#include <linux/netfilter_ipv4/ip_conntrack_helper.h>
#include "ip_conntrack_msn.h"
#include <linux/netfilter_ipv4/ip_nat_helper.h>
#include <linux/netfilter_ipv4/ip_nat_rule.h>

MODULE_AUTHOR("Lance Wu");
MODULE_DESCRIPTION("Netfilter NAT helper for MSN Messenger");
MODULE_LICENSE("GPL");

#define MAX_PORTS 8

static u_int16_t ports[MAX_PORTS];
static u_int16_t ports_c = 0;
#ifdef MODULE_PARM
MODULE_PARM(ports,"1-" __MODULE_STRING(MAX_PORTS) "i");
MODULE_PARM_DESC(ports, "port numbers of MSN Messenger servers");
#endif

#if 0
#define DEBUGP(format, args...) printk(__FILE__ ":" \
				       format, ## args)
#else
#define DEBUGP(format, args...)
#endif

static unsigned int 
msn_nat_help(struct ip_conntrack *ct,
	      struct ip_conntrack_expect *exp,
	      struct ip_nat_info *info,
	      enum ip_conntrack_info ctinfo,
	      unsigned int hooknum,
	      struct sk_buff **pskb)
{
	int dir = CTINFO2DIR(ctinfo);
	struct iphdr *iph = (*pskb)->nh.iph;
	struct tcphdr *tcph = (void *)iph + iph->ihl * 4;
	
//	struct tftphdr *tftph = (void *)udph + 8;
	struct ip_conntrack_tuple repl;
/*
#define NF_IP_PRE_ROUTING       0
#define NF_IP_LOCAL_IN          1
#define NF_IP_FORWARD           2
#define NF_IP_LOCAL_OUT         3
#define NF_IP_POST_ROUTING      4
#define NF_IP_NUMHOOKS          5
*/	
	DEBUGP("hooknum= %d, dir= %d\n",hooknum,dir);
	
	return NF_ACCEPT;
}

static unsigned int 
msn_nat_expected(struct sk_buff **pskb,
		  unsigned int hooknum,
		  struct ip_conntrack *ct, 
		  struct ip_nat_info *info) 
{
	const struct ip_conntrack *master = ct->master->expectant;
	const struct ip_conntrack_tuple *orig = 
			&master->tuplehash[IP_CT_DIR_ORIGINAL].tuple;
	struct ip_nat_multi_range mr;
	u_int32_t newdstip, newsrcip, newip;
    struct iphdr *iph = (*pskb)->nh.iph;
    struct tcphdr *tcph = (void *)iph + iph->ihl*4;

#if 0
	const struct ip_conntrack_tuple *repl =
			&master->tuplehash[IP_CT_DIR_REPLY].tuple;
//	struct iphdr *iph = (*pskb)->nh.iph;
	struct tcphdr *tcph = (void *)iph + iph->ihl*4;
#endif

	IP_NF_ASSERT(info);
	IP_NF_ASSERT(master);
	IP_NF_ASSERT(!(info->initialized & (1 << HOOK2MANIP(hooknum))));

//	printk("ip_nat_msn: from %u.%u.%u.%u:%u to %u.%u.%u.%u:%u ",
//                      NIPQUAD(iph->saddr), ntohs(tcph->source),
//		NIPQUAD(iph->daddr), ntohs(tcph->dest));

//	DEBUGP("orig:\n");
//	DUMP_TUPLE_RAW(orig);
//	DEBUGP("repl:\n");
//	DUMP_TUPLE_RAW(repl);

	newdstip = orig->src.ip;
	newsrcip = orig->dst.ip;

	if( HOOK2MANIP(hooknum) == IP_NAT_MANIP_SRC )
		newip = newsrcip;
	else
		newip = newdstip;
	
//	printk("nat_expected: IP to %u.%u.%u.%u\n",NIPQUAD(newip));

	mr.rangesize = 1;
	mr.range[0].flags = IP_NAT_RANGE_MAP_IPS;
	mr.range[0].min_ip = mr.range[0].max_ip = newip;

	return ip_nat_setup_info(ct,&mr,hooknum);
//	return 0;
}

static struct ip_nat_helper msn[MAX_PORTS];
static char msn_names[MAX_PORTS][10];

static void fini(void)
{
	int i;

	for (i = 0 ; i < ports_c; i++) {
		DEBUGP("unregistering helper for port %d\n", ports[i]);
		ip_nat_helper_unregister(&msn[i]);
	}
}

static int __init init(void)
{
	int i, ret;
	char *tmpname;

	if (!ports[0])
		ports[0] = MSN_PORT;

	for (i = 0 ; (i < MAX_PORTS) && ports[i] ; i++) {
		memset(&msn[i], 0, sizeof(struct ip_nat_helper));

		msn[i].tuple.dst.protonum = IPPROTO_TCP;
		msn[i].tuple.src.u.tcp.port = htons(ports[i]);
		msn[i].mask.dst.protonum = 0xFFFF;
		msn[i].mask.src.u.tcp.port = 0xFFFF;
		msn[i].help = msn_nat_help;
		msn[i].flags = 0;
		msn[i].me = THIS_MODULE;
		msn[i].expect = msn_nat_expected;

		tmpname = &msn_names[i][0];
		if (ports[i] == MSN_PORT)
			sprintf(tmpname, "msn");
		else
			sprintf(tmpname, "msn-%d", i);
		msn[i].name = tmpname;
		
//		printk("ip_nat_msn: registering for port %d: name %s\n",
//			ports[i], msn[i].name);
		ret = ip_nat_helper_register(&msn[i]);

		if (ret) {
			DEBUGP("ip_nat_msn: unable to register for port %d\n",
				ports[i]);
			fini();
			return ret;
		}
		ports_c++;
	}
	return ret;
}

module_init(init);
module_exit(fini);
