/*
 * Licensed under GNU GPL version 2 Copyright Lance Wu 
 * Version: 0.0.1
 *
 * 2003.08.21
 * 	- NEW Starcraft module
 *
 */

#include <linux/config.h>
#include <linux/module.h>

#include <linux/ip.h>
#include <net/tcp.h>
#include <net/udp.h>
#include <linux/ctype.h>

#include <linux/netfilter.h>
#include <linux/netfilter_ipv4/ip_tables.h>
#include <linux/netfilter_ipv4/ip_conntrack_helper.h>
#include "ip_conntrack_sc.h"

#include <net/checksum.h>

MODULE_AUTHOR("Lance Wu ");
MODULE_DESCRIPTION("Netfilter connection tracking module for Starcraft");
MODULE_LICENSE("GPL");

#if 0
#define DEBUGP(format, args...) printk(__FUNCTION__ ": " \
				       format, ## args)
#else
#define DEBUGP(format, args...)
#endif

static struct ip_conntrack_helper starcraft;
static char sc_names[10];

SC_INFO sc_info[MAX_CLIENTS];
u_int16_t sc_info_count;
//u_int32_t sc_server;
u_int32_t sc_gateway;

int record_client(u_int32_t ip, u_int32_t battle)
{
	u_int16_t i;
	
	for( i=0; i<MAX_CLIENTS; i++ )
	{
		if( sc_info[i].ip == ip )
		{
			if( sc_info[i].battle_net != battle )
			{
	            sc_info[i].battle_net = battle;
	            DEBUGP("modify ip-%d: %u.%u.%u.%u BattleNet-> %u.%u.%u.%u port-> %u\n",
				                            i,
				                            NIPQUAD(sc_info[i].ip),
				                            NIPQUAD(sc_info[i].battle_net),
											sc_info[i].port);
			    return 1;
            }
            return 0;
		}
        if( sc_info[i].ip == 0 )
		{
	        sc_info[i].ip = ip;
	        sc_info[i].battle_net = battle;
	        DEBUGP("record ip-%d: %u.%u.%u.%u BattleNet: %u.%u.%u.%u port: %u\n",
			                            i,
			                            NIPQUAD(sc_info[i].ip),
			                            NIPQUAD(sc_info[i].battle_net),
										sc_info[i].port);
	        return 1;
        }
    }
	
    sc_info[sc_info_count].ip = ip;
    sc_info[sc_info_count].battle_net = battle;
	
    DEBUGP("change ip-%d: %u.%u.%u.%u BattleNet: %u.%u.%u.%u port -> %u\n",
			                sc_info_count,
			                NIPQUAD(sc_info[sc_info_count].ip),
			                NIPQUAD(sc_info[sc_info_count].battle_net),
							sc_info[sc_info_count].port);
	
    sc_info_count++;
    if( sc_info_count == MAX_CLIENTS )
	    sc_info_count = 0;
	return 1;
}

/*
int IsUsedBattle( u_int32_t ip, u_int32_t battle )
{    
	int i;
			         
	for( i=0; i<MAX_CLIENTS; i++ )
	{        
		if( sc_info[i].ip == 0 )
			return 0;           
        if( sc_info[i].battle_net == battle )
        {                       
	        if( sc_info[i].ip == ip )
		        return 0;
		    return 1;
        }   
    }   
    return 0;
}
*/  
/*
int record_port( u_int32_t ip, u_int16_t port )
{                           
	int i;                  
			                            
    for( i=0; i<MAX_CLIENTS; i++ )
    {   
	    if( sc_info[i].ip == ip )
	    {
		    if( sc_info[i].port != port )
		    {
			    sc_info[i].port = port;
			    DEBUGP("record ip-%d: %u.%u.%u.%u port %u\n",
                                     i,
                                     NIPQUAD(sc_info[i].ip),
                                     sc_info[i].port);
			}
            return 1;
        }
        if( sc_info[i].ip == 0 )
	        return 0;
	}

	return 0;
}
*/
/*	
u_int32_t find_battle_by_client( u_int32_t ip )
{
	int i;

	for( i=0; i<MAX_CLIENTS; i++ )
	{
	    if( sc_info[i].ip == ip )
		    return sc_info[i].battle_net;
		if( sc_info[i].ip == 0 )
		    return 0;
	}

	return 0;
}
*/

static int sc_help(const struct iphdr *iph, size_t len,
		    struct ip_conntrack *ct,
		    enum ip_conntrack_info ctinfo)
{
    struct tcphdr *tcph = (void *)iph + iph->ihl * 4;
//  struct udphdr *udph = (void *)iph + iph->ihl * 4;
    unsigned int tcplen = len - iph->ihl * 4;
//	const unsigned char* data = (const unsigned char*)tcph + tcph->doff * 4;
	unsigned int datalen = tcplen - tcph->doff * 4;
//	unsigned int udplen = udph->len;
//  struct ip_conntrack_expect exp;
    int dir = CTINFO2DIR(ctinfo);
//    unsigned int port;
//	int found=0;
//	int i,x;

    DEBUGP("\n");
   	DEBUGP("ctinfo= %d, dir= %d, protocol= %s\n",
		    ctinfo,dir, (iph->protocol == IPPROTO_TCP)?"TCP":"UDP");
    DEBUGP("from %u.%u.%u.%u:%u to %u.%u.%u.%u:%u\n",
   	        NIPQUAD(iph->saddr),ntohs(tcph->source),
       	    NIPQUAD(iph->daddr),ntohs(tcph->dest));
	
    if( iph->protocol == IPPROTO_TCP )
    {
		/*
	    if( IsUsedBattle( iph->saddr, iph->daddr) == 1 )
	    {
		    DEBUGP("BattleNet [%u.%u.%u.%u] is using by another ip, DROP...\n",NIPQUAD(iph->daddr));
			DEBUGP("\n");
			return NF_DROP;
		}
		*/

		if( (datalen != 0) && (ctinfo == IP_CT_ESTABLISHED) && (dir == IP_CT_DIR_ORIGINAL) )
		{
			if( sc_gateway == 0 )
			{
				sc_gateway = ct->tuplehash[IP_CT_DIR_REPLY].tuple.dst.ip;
				DEBUGP("GW: %u.%u.%u.%u\n", NIPQUAD(sc_gateway));
	        }
	
			record_client(iph->saddr, iph->daddr);
/*			
			if( datalen >= 20 )
			{
				if( (*data == 0xff) && ( *(data+1) == 0x1c ) && ( datalen > 24 ))
				{
//					sc_server = iph->saddr;
					DEBUGP("Create Server [%s] in %u.%u.%u.%u\n",data+24, NIPQUAD(iph->saddr) );
	            }
	        }				
*/
		}
	}   

	
	DEBUGP("\n");

	return NF_ACCEPT;
}

static void fini(void)
{
//	int i;

	ip_conntrack_helper_unregister( &starcraft );
	DEBUGP("unregistering helper for starcraft modules\n");
}

static int __init init(void)
{
	int i, ret;
	char *tmpname;

//    sc_server = 0;
    sc_gateway = 0;
    sc_info_count = 0;
    memset(sc_info,0, sizeof(SC_INFO) * MAX_CLIENTS);

	for( i=0; i<MAX_CLIENTS; i++ )
		sc_info[i].port = SC_PORT + i;
					
	memset( &starcraft, 0, sizeof(struct ip_conntrack_helper) );
	
//	starcraft.tuple.dst.protonum = IPPROTO_UDP;
//	starcraft.mask.dst.protonum = 0xFFFF;
	starcraft.tuple.src.u.all = htons( SC_PORT );
	starcraft.mask.src.u.all = htons(0xFF00);
	
	starcraft.max_expected = 1;
	starcraft.timeout = 0;
	starcraft.flags = IP_CT_HELPER_F_REUSE_EXPECT;
	starcraft.me = THIS_MODULE;
	starcraft.help = sc_help;

	tmpname = &sc_names[0];
	sprintf(tmpname, "starcraft");

	ret = ip_conntrack_helper_register( &starcraft );
		
	if( ret  ) 
	{
		DEBUGP("ERROR registering helper for starcraft\n");
		fini();
		return(ret);
	}
	DEBUGP("register helper for starcraft SUCCESS!!\n");
	
	return(0);
}

module_init(init);
module_exit(fini);
