/*
 * Licensed under GNU GPL version 2 Copyright Lance Wu
 * Version: 0.0.1
 *
 * 2003.08.21
 * 	- NEW Starcraft module
 *
 */

#include <linux/module.h>
#include <linux/netfilter_ipv4.h>
#include <linux/ip.h>
#include <linux/tcp.h>
#include <linux/udp.h>

#include <linux/netfilter.h>
#include <linux/netfilter_ipv4/ip_tables.h>
#include <linux/netfilter_ipv4/ip_conntrack_helper.h>
#include <linux/netfilter_ipv4/ip_nat_helper.h>
#include <linux/netfilter_ipv4/ip_nat_rule.h>

#include <net/checksum.h>

#include "ip_conntrack_sc.h"

MODULE_AUTHOR("Lance Wu");
MODULE_DESCRIPTION("Netfilter NAT helper for Starcraft");
MODULE_LICENSE("GPL");

#if 0
#define DEBUGP(format, args...) printk(__FUNCTION__ ": "\
				       format, ## args)
#else
#define DEBUGP(format, args...)
#endif

extern SC_INFO sc_info[MAX_CLIENTS];
//extern u_int32_t sc_server;
extern u_int32_t sc_gateway;

u_int32_t find_ip_by_port(u_int16_t port)
{
	int i;

	for( i=0; i<MAX_CLIENTS; i++ )
	{
	    if( sc_info[i].ip == 0 )
		    return 0;
		if( sc_info[i].port == port )
	        return sc_info[i].ip;
	}

	return 0;
}

u_int16_t find_port_by_ip(u_int32_t ip)
{
	int i;

	for( i=0; i<MAX_CLIENTS; i++ )
	{
	    if( sc_info[i].ip == 0 )
		    return 0;
		if( sc_info[i].ip == ip )
	        return sc_info[i].port;
	}

	return 0;
}

/*
u_int32_t find_client_by_battle( u_int32_t ip )
{
	int i;
		    
	for( i=0; i<MAX_CLIENTS; i++ )
	{
		if( sc_info[i].battle_net == ip )
			return sc_info[i].ip; 
    }       
				    
    return 0;
}
*/

static unsigned int 
sc_nat_help(struct ip_conntrack *ct,
	      struct ip_conntrack_expect *exp,
	      struct ip_nat_info *info,
	      enum ip_conntrack_info ctinfo,
	      unsigned int hooknum,
	      struct sk_buff **pskb)
{
	int dir = CTINFO2DIR(ctinfo);
	struct iphdr *iph = (*pskb)->nh.iph;
	struct tcphdr *tcph = (void *)iph + iph->ihl * 4;
	struct udphdr *udph = (void *)iph + iph->ihl * 4;
//	struct ip_conntrack_tuple repl;
	unsigned int datalen = (*pskb)->len - iph->ihl * 4 - tcph->doff * 4;
	
	u_int16_t newport;
	struct ip_nat_multi_range mr;
	u_int32_t newip;

	DEBUGP("\n");
	
    DEBUGP("from %u.%u.%u.%u:%u to %u.%u.%u.%u:%u \n",
	    NIPQUAD(iph->saddr), ntohs(udph->source),
		NIPQUAD(iph->daddr), ntohs(udph->dest));
	
	DEBUGP("hooknum= %d, protocol= %s\n",hooknum,(iph->protocol == IPPROTO_TCP)?"TCP":"UDP");

	if( iph->protocol == IPPROTO_TCP )
	{
		DEBUGP("TCP datalen= %u\n",datalen);
		
	    if( (datalen > 20) && (ctinfo == IP_CT_IS_REPLY) && (dir == IP_CT_DIR_REPLY) )
	    {
//			unsigned int matchoff;
//			unsigned int matchlen;					  
			const unsigned char* data = (const unsigned char*)tcph + tcph->doff * 4;
		
	    	if( (*data == 0xff) && ( *(data+1) == 0x09 ) )
		    {
			    DEBUGP("\n");
			    DEBUGP("ctinfo= %d, dir= %d, protocol= %s\n",
 								ctinfo,dir, (iph->protocol == IPPROTO_TCP)?"TCP":"UDP");
			
	            if( *(data+4) == 1 )
    	        {
	    	        DEBUGP("Battle.Net answer server in %u.%u.%u.%u port: %u\n",
							            *(data+20),*(data+21),*(data+22),*(data+23),
                	                    ntohs( *(unsigned int*)(data+18) ));
					if( find_port_by_ip( *(u_int32_t*)(data+20) ) )
					{
//						matchoff = 20;
//						matchlen = 4;

						DEBUGP("It's local ip, must change ip to %u.%u.%u.%u\n",NIPQUAD(sc_gateway));
//					    return ip_nat_mangle_tcp_packet(pskb, ct, ctinfo, matchoff,
//										                    matchlen, (unsigned char*)&sc_gateway, 4);
					    return ip_nat_mangle_tcp_packet(pskb, ct, ctinfo, 20, 4, (unsigned char*)&sc_gateway, 4);
					}
				}
			}
		}
	}

	if( (iph->protocol == IPPROTO_UDP) )
	{
//	    DEBUGP("IP_CT_DIR_ORIGINAL:\n");
//	    DUMP_TUPLE_RAW(&(ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple));
//	    DEBUGP("IP_CT_DIR_REPLY:\n");
//	    DUMP_TUPLE_RAW(&(ct->tuplehash[IP_CT_DIR_REPLY].tuple));

		switch(hooknum)
		{

		case NF_IP_PRE_ROUTING: // hooknum == 0
	        // check iph->saddr is client ip or not
			
			// BattleNet -> GW , mr to client by battle
			/*
			newip = find_client_by_battle(iph->saddr);
			if( (newip != 0) && (iph->daddr == sc_gateway) )
			{
				memset( &mr, 0, sizeof( struct ip_nat_multi_range ) );
				mr.rangesize = 1;
                mr.range[0].flags = IP_NAT_RANGE_MAP_IPS;
                mr.range[0].min_ip = mr.range[0].max_ip = newip;
                mr.range[0].flags |= IP_NAT_RANGE_PROTO_SPECIFIED;
                mr.range[0].min = mr.range[0].max
				                = ((union ip_conntrack_manip_proto)
	                                { htons( SC_PORT ) });
	            DEBUGP("BattleNet->GW, mr to %u.%u.%u.%u port %u\n",NIPQUAD(newip),SC_PORT);
                return ip_nat_setup_info(ct,&mr,hooknum);
			}
			*/
			
			// someone -> GW ,  mr to client by port
//	        if( (find_battle_by_client(iph->saddr) == 0) && (iph->daddr == sc_gateway) )
	        if( (iph->daddr == sc_gateway) )
    	    {
	    	    newip = find_ip_by_port( ntohs(udph->dest) );
			
//		        if( (newip != 0) && (newip != iph->daddr) && (find_port_by_ip(iph->daddr) == 0) )
		        if( newip != 0 )
	            {
	                memset( &mr, 0, sizeof( struct ip_nat_multi_range ) );
	                mr.rangesize = 1;
                    mr.range[0].flags = IP_NAT_RANGE_MAP_IPS;
                    mr.range[0].min_ip = mr.range[0].max_ip = newip;
                    mr.range[0].flags |= IP_NAT_RANGE_PROTO_SPECIFIED;
                    mr.range[0].min = mr.range[0].max
					                = ((union ip_conntrack_manip_proto)
	                                    { htons( SC_PORT ) });
	                DEBUGP("Someone->GW, mr to %u.%u.%u.%u port %u\n",NIPQUAD(newip),SC_PORT);

                    return ip_nat_setup_info(ct,&mr,hooknum);
//                    ip_nat_setup_info(ct,&mr,hooknum);
//					return NF_DROP;
                }
			}

            break;

		case NF_IP_POST_ROUTING: // hooknum == 4   
//			if( find_battle_by_client(ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.src.ip) && (iph->saddr == sc_gateway) )
			if( iph->saddr == sc_gateway )
			{
//				DEBUGP("Is client!!\n");

				newport = find_port_by_ip(ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.src.ip);
				if( newport != 0 )
				{
					if( newport != udph->source )
					{
						DEBUGP("send by %u.%u.%u.%u , so port must be %u !!\n",
										NIPQUAD(ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.src.ip),
										newport);
						udph->source = htons(newport);
						udph->check = 0;
					}
				}
				else
				{
					newport = find_port_by_ip(ct->tuplehash[IP_CT_DIR_REPLY].tuple.src.ip);
					if( newport != 0 )
					{
						if( newport != udph->source )
						{
							DEBUGP("reply by %u.%u.%u.%u , so port must be %u !!\n",
											NIPQUAD(ct->tuplehash[IP_CT_DIR_REPLY].tuple.src.ip),
											newport);
							udph->source = htons(newport);
							udph->check = 0;
						}
					}
				}
//				record_port( ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.src.ip, ntohs(udph->source) );
			}
			else
			{
				newport = find_port_by_ip(iph->saddr);
				if( newport != 0 )
				{
					if( find_port_by_ip(iph->daddr) )
					{
						newip = sc_gateway;
						memset( &mr, 0, sizeof( struct ip_nat_multi_range ) );
						mr.rangesize = 1;
        		        mr.range[0].flags = IP_NAT_RANGE_MAP_IPS;
            		    mr.range[0].min_ip = mr.range[0].max_ip = newip;
	        	    	DEBUGP("client->client, mr to %u.%u.%u.%u \n",NIPQUAD(newip));
					
//	                	return ip_nat_setup_info(ct,&mr,hooknum);
	                	ip_nat_setup_info(ct,&mr,hooknum);
						return NF_DROP;
					}
				}

				if( iph->saddr == ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.src.ip )
				{
					if( udph->source != ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.src.u.all )
					{
						DEBUGP("port incorrect! change back...(%u -> %u)\n",
										ntohs(udph->source),
										ntohs(ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.src.u.all) );
						
						udph->source = ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.src.u.all;
						udph->check = 0;
					}
				}
			}
			break;
		}
	}		
	
	DEBUGP("\n");
	return NF_ACCEPT;
}

static unsigned int 
sc_nat_expected(struct sk_buff **pskb,
		  unsigned int hooknum,
		  struct ip_conntrack *ct, 
		  struct ip_nat_info *info) 
{
//	const struct ip_conntrack *master = ct->master->expectant;
//	const struct ip_conntrack_tuple *orig = 
//			&master->tuplehash[IP_CT_DIR_ORIGINAL].tuple;
//	struct ip_nat_multi_range mr;
//	u_int32_t newdstip, newsrcip, newip;
//  struct iphdr *iph = (*pskb)->nh.iph;
//  struct tcphdr *tcph = (void *)iph + iph->ihl*4;
//  struct udphdr *udph = (void *)iph + iph->ihl*4;
//	struct ip_ct_ftp_expect *exp_ftp_info;
//	u_int16_t newport;
//	int x;
#if 1
//	const struct ip_conntrack_tuple *repl =
//			&master->tuplehash[IP_CT_DIR_REPLY].tuple;
//	struct iphdr *iph = (*pskb)->nh.iph;
//	struct tcphdr *tcph = (void *)iph + iph->ihl*4;
#endif

	IP_NF_ASSERT(info);
	IP_NF_ASSERT(master);
	IP_NF_ASSERT(!(info->initialized & (1 << HOOK2MANIP(hooknum))));

//	if( hooknum != NF_IP_PRE_ROUTING )
//		return NF_ACCEPT;
			
	DEBUGP("\n");
    DEBUGP("hooknum= %d protocol= %s\n",hooknum, (iph->protocol == IPPROTO_TCP)?"TCP":"UDP");
	DEBUGP("%u.%u.%u.%u:%u - %u.%u.%u.%u:%u \n",
			NIPQUAD(iph->saddr), ntohs(udph->source),
			NIPQUAD(iph->daddr), ntohs(udph->dest) );
/*	
	DEBUGP("orig:\n");
	DUMP_TUPLE_RAW(orig);
	DEBUGP("repl:\n"); 
	DUMP_TUPLE_RAW(repl);

    if( hooknum == NF_IP_PRE_ROUTING ) // hooknum == 0 
    {
	    newip = find_client_by_battle(iph->saddr);
	    if( newip != 0 )
	    {
		    DEBUGP("nat_expected: IP to %u.%u.%u.%u port: 6112\n",NIPQUAD(newip));
		    DEBUGP("\n");
			
            mr.rangesize = 1;
            mr.range[0].flags = IP_NAT_RANGE_MAP_IPS;
            mr.range[0].min_ip = mr.range[0].max_ip = newip;
            mr.range[0].flags |= IP_NAT_RANGE_PROTO_SPECIFIED;
            mr.range[0].min = mr.range[0].max
					        = ((union ip_conntrack_manip_proto)
						        { htons( SC_PORT ) });
	        return ip_nat_setup_info(ct,&mr,hooknum);
		}

		newip = find_battle_by_client(iph->saddr);
		if( newip != 0 )
		{
	        DEBUGP("Is client\n");

			if( iph->daddr == sc_gateway )
			{
				newip = find_ip_by_port( ntohs(udph->dest) );
				if( newip != 0 )
				{
					DEBUGP("nat_expected: IP to %u.%u.%u.%u port: 6112\n",NIPQUAD(newip));
		            mr.rangesize = 1;
        		    mr.range[0].flags = IP_NAT_RANGE_MAP_IPS;
		            mr.range[0].min_ip = mr.range[0].max_ip = newip;
        		    mr.range[0].flags |= IP_NAT_RANGE_PROTO_SPECIFIED;
		            mr.range[0].min = mr.range[0].max
							        = ((union ip_conntrack_manip_proto)
								        { htons( SC_PORT ) });
			        return ip_nat_setup_info(ct,&mr,hooknum);
				}
			}
			
//	        DEBUGP("\n");
//	        return NF_ACCEPT;
        }
		
        newip = find_ip_by_port(ntohs(udph->dest));
        if( newip != 0 )
        {
	        DEBUGP("nat_expected: IP to client %u.%u.%u.%u port: 6112\n",NIPQUAD(newip));
	        DEBUGP("\n");
            mr.rangesize = 1;
            mr.range[0].flags = IP_NAT_RANGE_MAP_IPS;
            mr.range[0].min_ip = mr.range[0].max_ip = newip;
            mr.range[0].flags |= IP_NAT_RANGE_PROTO_SPECIFIED;
            mr.range[0].min = mr.range[0].max
				            = ((union ip_conntrack_manip_proto)
					            { htons( SC_PORT ) });
            return ip_nat_setup_info(ct,&mr,hooknum);
        }

        if( sc_server )
		{
			DEBUGP("nat_expected: IP to server %u.%u.%u.%u port: 6112\n",NIPQUAD(newip));
			DEBUGP("\n");
            mr.rangesize = 1;
            mr.range[0].flags = IP_NAT_RANGE_MAP_IPS;
            mr.range[0].min_ip = mr.range[0].max_ip = newip;
            mr.range[0].flags |= IP_NAT_RANGE_PROTO_SPECIFIED;
            mr.range[0].min = mr.range[0].max
				            = ((union ip_conntrack_manip_proto)
					            { htons( SC_PORT ) });
            return ip_nat_setup_info(ct,&mr,hooknum);
        }
				
	}

	if( hooknum == NF_IP_POST_ROUTING )
	{
		if( find_battle_by_client(iph->saddr) && find_battle_by_client(iph->daddr) )
		{
			newport = find_port_by_ip(iph->saddr);
			if( newport == 0 )
				newport = SC_PORT;
			DEBUGP("nat_expected: src ip %u.%u.%u.%u port %u\n",NIPQUAD(sc_gateway),newport);
			DEBUGP("\n");
            mr.rangesize = 1;
            mr.range[0].flags = IP_NAT_RANGE_MAP_IPS;
            mr.range[0].min_ip = mr.range[0].max_ip = sc_gateway;
            mr.range[0].flags |= IP_NAT_RANGE_PROTO_SPECIFIED;
            mr.range[0].min = mr.range[0].max
				            = ((union ip_conntrack_manip_proto)
					            { htons( newport ) });
            return ip_nat_setup_info(ct,&mr,hooknum);
		}
	}
	
//	DEBUGP("orig:\n");
//	DUMP_TUPLE_RAW(orig);
//	DEBUGP("repl:\n"); 
//	DUMP_TUPLE_RAW(repl);
*/
	DEBUGP("\n");
	
	return NF_ACCEPT;
}

static struct ip_nat_helper sc_helper;
static char sc_names[10];

static void fini(void)
{
	ip_nat_helper_unregister( &sc_helper );
	DEBUGP("unregister starcraft!!\n");
}

static int __init init(void)
{
//	int i;
	int ret;
	char *tmpname;

	memset( &sc_helper, 0, sizeof(struct ip_nat_helper));

	sc_helper.tuple.src.u.all = htons( SC_PORT );
	sc_helper.mask.src.u.all = htons(0xFF00);

//	sc_helper.tuple.dst.protonum = IPPROTO_UDP;
//	sc_helper.mask.dst.protonum = 0xFFFF;
			
	sc_helper.help = sc_nat_help;
	sc_helper.flags = IP_NAT_HELPER_F_ALWAYS;
	sc_helper.me = THIS_MODULE;
	sc_helper.expect = sc_nat_expected;

	tmpname = &sc_names[0];
	sprintf(tmpname, "sc_helper");
	sc_helper.name = tmpname;
		
	ret = ip_nat_helper_register( &sc_helper );

	if( ret ) 
	{
		DEBUGP("unable to register starcraft\n");
		fini();
		return ret;
	}
	DEBUGP("register starcraft SUCCESS!!\n");

	return ret;
}

module_init(init);
module_exit(fini);
