/*
 * Licensed under GNU GPL version 2 Copyright Lance Wu 
 * Version: 0.0.1
 *
 * 2003.06.23
 * 	- Port trigger
 *
 */

#include <linux/config.h>
#include <linux/module.h>

//#include <asm/uaccess.h>
#include <linux/proc_fs.h>

#include <linux/ip.h>
#include <net/tcp.h>
#include <net/udp.h>
#include <linux/ctype.h>

#include <linux/netfilter.h>
#include <linux/netfilter_ipv4/ip_tables.h>
#include <linux/netfilter_ipv4/ip_conntrack_helper.h>
#include "ip_conntrack_trigger.h"

#include <net/checksum.h>

MODULE_AUTHOR("Lance Wu ");
MODULE_DESCRIPTION("Netfilter connection tracking module for trigger port");
MODULE_LICENSE("GPL");

#if 0
#define DEBUGP(format, args...) printk(__FUNCTION__ ": " \
				       format, ## args)
#else
#define DEBUGP(format, args...)
#endif

static struct ip_conntrack_helper trigger[MAX_TRIGGER_LIST];
static char trigger_names[MAX_TRIGGER_LIST][15];

//static TRIGGER_LIST trigger_list[MAX_TRIGGER_LIST];
//static int          trigger_list_count;

TRIGGER_LIST trigger_list[MAX_TRIGGER_LIST];
int          trigger_list_count;

int proc_match(int len, const char *name,struct proc_dir_entry * de)
{
    if( !de || !de->low_ino )
        return 0;
    if( de->namelen != len )
        return 0;
    return !memcmp( name, de->name, len );
}

unsigned int string_to_uint(unsigned char* buf)
{
	unsigned char* ptr = buf;
	unsigned int data = 0 ;

	while( (*ptr >= '0') && (*ptr <= '9') )
	{
		data = data * 10;
		data += (*ptr - '0');
		ptr++;
	}
	
	return data;
}

static int next_line( unsigned char** ppbuf, __u32* pbuflen, unsigned char** ppline, __u32* plinelen )
{
    char* pbuf = *ppbuf;
    __u32 buflen = *pbuflen;
    __u32 linelen = 0;

    do
    {
	    while( *pbuf != '\r' && *pbuf != '\n' )
	    {
	        if( buflen <= 1 )
            {
	            return 0;
	        }
            pbuf++;
            linelen++;
            buflen--;
        }
//        if( buflen > 1 && *pbuf == '\r' && *(pbuf+1) == '\n' )
//        if( buflen > 1 && *pbuf == '\n' )
//        {
//	        pbuf++;
//	        buflen--;
//        }
        pbuf++;
        buflen--;
    }
    while( buflen > 0 && (*pbuf == ' ' || *pbuf == '\t') );

    *ppline = *ppbuf;
    *plinelen = linelen;
    *ppbuf = pbuf;
    *pbuflen = buflen;
	
    return linelen;
}


static int trigger_help(const struct iphdr *iph, size_t len,
		    struct ip_conntrack *ct,
		    enum ip_conntrack_info ctinfo)
{
//    struct tcphdr *tcph = (void *)iph + iph->ihl * 4;
    struct udphdr *udph = (void *)iph + iph->ihl * 4;
//    unsigned int tcplen = len - iph->ihl * 4;
    struct ip_conntrack_expect exp;
	struct ip_ct_ftp_expect *exp_ftp_info = &exp.help.exp_ftp_info;
    int dir = CTINFO2DIR(ctinfo);
    unsigned int port;
	int found=0;
	int i,x;


	if( dir != IP_CT_DIR_ORIGINAL )
	{
		return NF_ACCEPT;
	}

	if( ctinfo != 0 )
		return NF_ACCEPT;

	if( trigger_list_count == 0 )
	{
//		DEBUGP("trigger_list_count == 0\n");
		return NF_ACCEPT;
	}


	DEBUGP("\n");
	DEBUGP("ctinfo= %d\n",ctinfo);
//	DEBUGP("from %u.%u.%u.%u:%u to %u.%u.%u.%u:%u\n",
//			NIPQUAD(iph->saddr),ntohs(tcph->source),
//			NIPQUAD(iph->daddr),ntohs(tcph->dest));

//	return NF_ACCEPT;
	
//	DEBUGP("i= %d\n",trigger_list_count );
		
	for( i=0; i<trigger_list_count; i++ )
	{
		if( (trigger_list[i].int_proto != 0) && (trigger_list[i].int_proto != iph->protocol) )
		{
			continue;
		}
		port = ntohs( udph->dest );
//		DEBUGP("port= %u\n",port);
		for( x=0; x<MAX_INT_PORT_RANGE; x++ )
		{
            if( (port >= trigger_list[i].int_port[x].start) && (port <= trigger_list[i].int_port[x].end) )
   	        {   
//		        DEBUGP("dest= %d , range= %d - %d (%d,%d)\n",
//   			        port,trigger_list[i].int_port[x].start,trigger_list[i].int_port[x].end,i,x);
               	break;
            }
			else
   	        {   
//		        DEBUGP("no dest= %d , range= %d - %d (%d,%d)\n",
//   			        port,trigger_list[i].int_port[x].start,trigger_list[i].int_port[x].end,i,x);
            }
		}
        if( x != MAX_INT_PORT_RANGE )
			break;
		continue;
	}
	
	if( i == trigger_list_count )
		return NF_ACCEPT;
	
    DEBUGP("%u.%u.%u.%u:%u - %u.%u.%u.%u:%u\n",
					NIPQUAD(iph->saddr),ntohs(udph->source),
					NIPQUAD(iph->daddr),ntohs(udph->dest));
	DEBUGP("use list[%d]: port %d - %d proto %d (dir= %d, x= %d)\n",
					i,trigger_list[i].int_port[x].start,trigger_list[i].int_port[x].end,trigger_list[i].int_proto,
					dir,x);
	DEBUGP("dir src: %u.%u.%u.%u\n",NIPQUAD(ct->tuplehash[dir].tuple.src.ip));
    DEBUGP("dir dst: %u.%u.%u.%u\n",NIPQUAD(ct->tuplehash[dir].tuple.dst.ip));
    DEBUGP("!dir src: %u.%u.%u.%u\n",NIPQUAD(ct->tuplehash[!dir].tuple.src.ip));
    DEBUGP("!dir dst: %u.%u.%u.%u\n",NIPQUAD(ct->tuplehash[!dir].tuple.dst.ip));
			
	DEBUGP("\n");

	memset(&exp,0,sizeof(exp));
	
    exp.tuple = ((struct ip_conntrack_tuple)
		    {{ 0, {0}},
			 { ct->tuplehash[!dir].tuple.dst.ip, {0},
              trigger_list[i].ext_proto }});

/*
    exp.tuple = ((struct ip_conntrack_tuple)
		    {{ ct->tuplehash[!dir].tuple.src.ip, {0}},
			 { ct->tuplehash[!dir].tuple.dst.ip, {0},
              trigger_list[i].ext_proto }});
*/	
    exp.mask.dst.ip = 0xffffffff;

//    exp.mask.dst.u.udp.port = 0xffff;
	if( trigger_list[i].ext_proto != 0 )
	    exp.mask.dst.protonum = 0xffff;
    exp.expectfn = NULL;											

	exp_ftp_info->len = i;

	ip_conntrack_expect_related(ct, &exp);

	return NF_ACCEPT;
}

static void fini(void)
{
	int i;

	for( i=0; i<trigger_list_count; i++ )
	{
		ip_conntrack_helper_unregister( &trigger[i] );
		DEBUGP("unregistering helper for trigger %d\n",i);
	}
}

static int parse_port( unsigned char* buffer , TRIGGER_LIST* trigger, int type )
{
	int i=0,range;
	int is_range=0,is_end=0;
	unsigned char* ptr1=buffer;
	unsigned char* ptr2;
	unsigned char* ptr3;
//	PORT_RANGE	tmp[5]={0};
	
	if( !type )
		memset( trigger, 0, sizeof(TRIGGER_LIST) );

	while( *ptr1 == ' ' )
		ptr1++;
	ptr2 = ptr1;

	if( type )
		range = MAX_EXT_PORT_RANGE;
	else
		range = MAX_INT_PORT_RANGE;
	
	while( i < range )
	{
		while( (*ptr2 >= '0') && (*ptr2 <= '9') )
			ptr2++;
		switch( (char)*ptr2 )
		{
		case '\0':
			if( ptr1 == ptr2 )
				return 0;
			if( is_range )
			{
				if( type )
				{
					trigger->ext_port[i].start = string_to_uint(ptr1);
					trigger->ext_port[i].end = string_to_uint(ptr3);
				}
				else
                {
                    trigger->int_port[i].start = string_to_uint(ptr1);
                    trigger->int_port[i].end = string_to_uint(ptr3);
                }       
			}
			else
			{
                if( type )
                {
                    trigger->ext_port[i].start = trigger->ext_port[i].end = string_to_uint(ptr1);
                }       
                else
                {
                    trigger->int_port[i].start = trigger->int_port[i].end = string_to_uint(ptr1);
                }								
			}
			if( is_end )
				goto PORT_OK;
			i++;
			ptr2++;
			ptr1 = ptr2;
			is_range = 0;
			break;
		case ',':
			*ptr2 = '\0';
			break;
		case '-':
			is_range = 1;
			*ptr2 = '\0';
			ptr2++;
			ptr3 = ptr2 ;
			break;
		case ':':
			if( ptr1 != ptr2 )
			{
				*ptr2 = '\0';
				is_end = 1;
			}
			else
			{
				if( i == 0 )
					return 0;
				else
					goto PORT_OK;
			}
			break;
		default:
			DEBUGP("parse error \n");
			return 0;
		}
	}
	
PORT_OK:
//	if( type )
//		memcpy( trigger->ext_port, tmp, sizeof(tmp) );
//	else
//		memcpy( trigger->int_port, tmp, sizeof(tmp) );
	return 1;
}

static int parse_data( unsigned char* buffer , int buflen)
{
	TRIGGER_LIST	temp;
    unsigned char* pdata    = NULL;
    int   datalen  = 0;
    unsigned char* pline;
    int linelen,x;
	char* cp;
	char* cp1;

	pdata = buffer;
	datalen = buflen;
	trigger_list_count = 0;
	
	while( next_line( &pdata, &datalen, &pline, &linelen ) )
	{
		if( linelen == 0 )
			break;
		pline[linelen] = '\0';
//		DEBUGP("linelen= %d [%s]\n",linelen,pline);
		
		// internal port range
		if( (cp = strchr(pline, ':') ) == NULL)
		{
			DEBUGP("parse data [internal port] error!!\n");
			return 0;
		}

		if( !parse_port(pline,&temp,0) )
		{
            DEBUGP("parse port [internal port] error!!\n");
            return 0;
		}
/*
		else
		{
			for( x=0; x<MAX_INT_PORT_RANGE; x++ )
			{
				DEBUGP("int port %d: %d - %d\n",x,
								temp.int_port[x].start,
								temp.int_port[x].end);
			}
		}
*/
        pline = cp+1;

		// internal protocol
        if( (cp = strchr(pline, ':') ) == NULL)
        {
            DEBUGP("parse data [internal protocol] error!!\n");
            return 0;
        }
		*cp = '\0';
		if( !memcmp(pline,"TCP",3) )
		{
//			DEBUGP("internal protocol: %s\n",pline);
			temp.int_proto = IPPROTO_TCP;
		}
		else
		{
			if( !memcmp(pline,"UDP",3) )
			{
//				DEBUGP("internal protocol: %s\n",pline);
				temp.int_proto = IPPROTO_UDP;
			}
			else
			{
				if( !memcmp(pline,"ALL",3) )
				{
//					DEBUGP("internal protocol: %s\n",pline);
					temp.int_proto = 0;
				}
				else
				{
                    DEBUGP("parse data [internal protocol] error!!\n");
					return 0;
				}
			}
		}
		pline = cp+1;
		
        // external port range
        if( (cp = strchr(pline, ':') ) == NULL)
        {
	        DEBUGP("parse data [external port] error!!\n");
	        return 0;
	    }       
        if( !parse_port(pline,&temp,1) )
        {
	        DEBUGP("parse port [external port] error!!\n");
	        return 0;
	    }
/*
        else
        {
	        for( x=0; x<MAX_EXT_PORT_RANGE; x++ )
	        {
		        DEBUGP("ext port %d: %d - %d\n",x,
				        temp.ext_port[x].start,
				        temp.ext_port[x].end);
            }
        }						
*/
        pline = cp+1;

        // internal protocol
		if( *pline == '\n' )
		{
	        DEBUGP("parse data [external protocol] error!!\n");
    	    return 0;          
		}
		
        if( !memcmp(pline,"TCP",3) )
		{
//	        DEBUGP("external protocol: %s\n",pline);
			temp.ext_proto = IPPROTO_TCP;
		}
		else
		{
		    if( !memcmp(pline,"UDP",3) )
			{
//			    DEBUGP("external protocol: %s\n",pline);
				temp.ext_proto = IPPROTO_UDP;
			}
			else
			{
	        	if( !memcmp(pline,"ALL",3) )
				{
//    	        	DEBUGP("external protocol: %s\n",pline);
					temp.ext_proto = 0;
				}
				else
				{
					DEBUGP("parse data [external protocol] error!!\n");
			        return 0;
				}
			}
		}

		memcpy( &trigger_list[trigger_list_count], &temp, sizeof(TRIGGER_LIST) );
		
		trigger_list_count++;
	}
					
	return 0;
}

static int read_trigger_procfile(void)
{
	struct proc_dir_entry* de;
	unsigned char buffer[MAX_BUF_SIZE];
	char* start;
	int eof=0;
	int len=0;
	
    de = &proc_root;

    for( de=de->subdir; de; de=de->next )
    {
//		DEBUGP("debug: %s , len= %d\n",de->name, de->namelen);
		
        if( proc_match( strlen(TRIGGER_PORT_FILENAME), TRIGGER_PORT_FILENAME, de) )
        {
	        DEBUGP("found procfile...[%s]\n",TRIGGER_PORT_FILENAME);
			start = NULL;
            if( (len = de->read_proc( buffer, &start, 0, MAX_BUF_SIZE, &eof, de->data )) )
			{
				buffer[len] = '\0';
//				DEBUGP("filedata= %s\n",buffer);
				parse_data( buffer, len );
//				printk("int= %d - %d, ext= %d - %d\n",trigger_list[0].int_port[0].start,
//								trigger_list[0].int_port[0].end,
//								trigger_list[0].ext_port[0].start,
//								trigger_list[0].ext_port[0].end);
				return 0;
			}
			break;
		}
	}
    if( !de )
	    DEBUGP("procfile [%s] not found!!\n", TRIGGER_PORT_FILENAME);
	
	return 0;
}

static int __init init(void)
{
	int i, ret;
	char *tmpname;

	trigger_list_count = 0;
	memset( trigger_list, 0, sizeof(TRIGGER_LIST) * MAX_TRIGGER_LIST );
	
	read_trigger_procfile();

	for( i=0; i<trigger_list_count; i++ )
	{
		memset( &trigger[i], 0, sizeof(struct ip_conntrack_helper) );
		if( trigger_list[i].int_proto )
		{
			trigger[i].tuple.dst.protonum = trigger_list[i].int_proto;
			trigger[i].mask.dst.protonum = 0xFFFF;
		}
		if( trigger_list[i].int_port[0].start != trigger_list[i].int_port[0].end )
			trigger[i].tuple.src_range = htons(trigger_list[i].int_port[0].end);
		trigger[i].tuple.src.u.all = htons(trigger_list[i].int_port[0].start);
		trigger[i].mask.src.u.all = 0xFFFF;
		trigger[i].max_expected = 1;
		trigger[i].timeout = 0;
		trigger[i].flags = IP_CT_HELPER_F_REUSE_EXPECT;
//		trigger[i].flags = 0;
		trigger[i].me = THIS_MODULE;
		trigger[i].help = trigger_help;

		tmpname = &trigger_names[i][0];
		sprintf(tmpname, "trigger-%d",i);

		ret = ip_conntrack_helper_register( &trigger[i] );
		
		if( ret || (trigger_list_count==0 ) ) 
		{
			DEBUGP("ERROR registering helper for trigger port\n");
			fini();
			return(ret);
		}
		DEBUGP("register helper for trigger %d  port %d - %d SUCCESS!!\n",
						i,
						trigger_list[i].int_port[0].start,
						trigger_list[i].int_port[0].end );
	}
	
	return(0);
}

module_init(init);
module_exit(fini);
