/*
 * Licensed under GNU GPL version 2 Copyright Lance Wu
 * Version: 0.0.1
 *
 * 2003.06.24
 * 	- Trigger port
 *
 */

#include <linux/module.h>
#include <linux/netfilter_ipv4.h>
#include <linux/ip.h>
#include <linux/tcp.h>
#include <linux/udp.h>

#include <linux/netfilter.h>
#include <linux/netfilter_ipv4/ip_tables.h>
#include <linux/netfilter_ipv4/ip_conntrack_helper.h>
#include "ip_conntrack_trigger.h"
#include <linux/netfilter_ipv4/ip_nat_helper.h>
#include <linux/netfilter_ipv4/ip_nat_rule.h>

MODULE_AUTHOR("Lance Wu");
MODULE_DESCRIPTION("Netfilter NAT helper for trigger port");
MODULE_LICENSE("GPL");

//#define MAX_PORTS 8

//static int ports[MAX_PORTS];
//static int ports_c = 0;
//#ifdef MODULE_PARM
//MODULE_PARM(ports,"1-" __MODULE_STRING(MAX_PORTS) "i");
//MODULE_PARM_DESC(ports, "port numbers of MSN Messenger servers");
//#endif

#if 0
#define DEBUGP(format, args...) printk(__FUNCTION__ ": "\
				       format, ## args)
#else
#define DEBUGP(format, args...)
#endif

extern TRIGGER_LIST trigger_list[MAX_TRIGGER_LIST];
extern int trigger_list_count;

static unsigned int 
trigger_nat_help(struct ip_conntrack *ct,
	      struct ip_conntrack_expect *exp,
	      struct ip_nat_info *info,
	      enum ip_conntrack_info ctinfo,
	      unsigned int hooknum,
	      struct sk_buff **pskb)
{
	int dir = CTINFO2DIR(ctinfo);
	struct iphdr *iph = (*pskb)->nh.iph;
	struct tcphdr *tcph = (void *)iph + iph->ihl * 4;
	struct udphdr *udph = (void *)iph + iph->ihl * 4;
	struct ip_conntrack_tuple repl;
	int i;
	unsigned int port;
	
/*
#define NF_IP_PRE_ROUTING       0
#define NF_IP_LOCAL_IN          1
#define NF_IP_FORWARD           2
#define NF_IP_LOCAL_OUT         3
#define NF_IP_POST_ROUTING      4
#define NF_IP_NUMHOOKS          5
*/	


//	if( (dir != IP_CT_DIR_ORIGINAL) && (hooknum != NF_IP_PRE_ROUTING) )
//	{
//		return NF_ACCEPT;
//	}
	
//	DEBUGP("\nhooknum= %d, dir= %d\n",hooknum,dir);
//    DEBUGP("from %u.%u.%u.%u:%u to %u.%u.%u.%u:%u \n\n",
//	    NIPQUAD(iph->saddr), ntohs(tcph->source),
//		NIPQUAD(iph->daddr), ntohs(tcph->dest));
	
    if (!((hooknum == NF_IP_POST_ROUTING && dir == IP_CT_DIR_ORIGINAL)
		          || (hooknum == NF_IP_PRE_ROUTING && dir == IP_CT_DIR_REPLY)))
		return NF_ACCEPT;

    if (!exp) {
        DEBUGP("no conntrack expectation to modify\n");
        return NF_ACCEPT;
    }

    repl = ct->tuplehash[IP_CT_DIR_REPLY].tuple;
    DEBUGP("\n");
//    DUMP_TUPLE(&ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple);
    DUMP_TUPLE(&ct->tuplehash[IP_CT_DIR_REPLY].tuple);
//    DEBUGP("expecting: ");
//    DUMP_TUPLE_RAW(&repl);
//    DUMP_TUPLE_RAW(&exp->mask);
	DEBUGP("\n");
    ip_conntrack_change_expect(exp, &repl);
																	
    return NF_ACCEPT;
}

static unsigned int 
trigger_nat_expected(struct sk_buff **pskb,
		  unsigned int hooknum,
		  struct ip_conntrack *ct, 
		  struct ip_nat_info *info) 
{
	const struct ip_conntrack *master = ct->master->expectant;
	const struct ip_conntrack_tuple *orig = 
			&master->tuplehash[IP_CT_DIR_ORIGINAL].tuple;
	struct ip_nat_multi_range mr;
	u_int32_t newdstip, newsrcip, newip;
    struct iphdr *iph = (*pskb)->nh.iph;
    struct tcphdr *tcph = (void *)iph + iph->ihl*4;
	struct ip_ct_ftp_expect *exp_ftp_info;
	unsigned int port;
	int x;
#if 1
	const struct ip_conntrack_tuple *repl =
			&master->tuplehash[IP_CT_DIR_REPLY].tuple;
//	struct iphdr *iph = (*pskb)->nh.iph;
//	struct tcphdr *tcph = (void *)iph + iph->ihl*4;
#endif

	IP_NF_ASSERT(info);
	IP_NF_ASSERT(master);
	IP_NF_ASSERT(!(info->initialized & (1 << HOOK2MANIP(hooknum))));

	exp_ftp_info = &ct->master->help.exp_ftp_info;

	if( hooknum != NF_IP_PRE_ROUTING )
		return NF_ACCEPT;
			
	DEBUGP("\n");
    DEBUGP("hooknum= %d\n",hooknum);
	DEBUGP("%u.%u.%u.%u:%u - %u.%u.%u.%u:%u (List[%d])\n",
			NIPQUAD(iph->saddr), ntohs(tcph->source),
			NIPQUAD(iph->daddr), ntohs(tcph->dest),
			exp_ftp_info->len);

	if( (trigger_list[exp_ftp_info->len].ext_proto != 0) && (trigger_list[exp_ftp_info->len].ext_proto != iph->protocol) )
	{
		DEBUGP("protocol mismatch!!\n");
		return NF_DROP;
	}

	port = ntohs( tcph->dest );
	for( x=0; x<MAX_EXT_PORT_RANGE; x++ )
	{
		if( (trigger_list[exp_ftp_info->len].ext_port[x].start <= port) && 
						(trigger_list[exp_ftp_info->len].ext_port[x].end >= port) )
		break;
	}

	if( x == MAX_EXT_PORT_RANGE )
    {
	    DEBUGP("port range mismatch!!\n");
	    return NF_DROP;
	}

	DEBUGP("orig:\n");
	DUMP_TUPLE_RAW(orig);
	DEBUGP("repl:\n");
	DUMP_TUPLE_RAW(repl);


	newdstip = orig->src.ip;
	newsrcip = orig->dst.ip;

	if( HOOK2MANIP(hooknum) == IP_NAT_MANIP_SRC )
		newip = newsrcip;
	else
		newip = newdstip;
/*	
	if( (((unsigned char *)&newip)[0] == 100 ) &&
		(((unsigned char *)&newip)[1] == 0 ) &&
		(((unsigned char *)&newip)[2] == 0 ) &&
		(((unsigned char *)&newip)[3] == 123 ) )
	{
		DEBUGP("change...\n");
		((unsigned char *)&newip)[0] = 100;
		((unsigned char *)&newip)[1] = 0;
		((unsigned char *)&newip)[2] = 0;
		((unsigned char *)&newip)[3] = 120;
	}
*/

	DEBUGP("nat_expected: IP to %u.%u.%u.%u\n",NIPQUAD(newip));

	mr.rangesize = 1;
	mr.range[0].flags = IP_NAT_RANGE_MAP_IPS;
	mr.range[0].min_ip = mr.range[0].max_ip = newip;

	return ip_nat_setup_info(ct,&mr,hooknum);

//	return 0;
}

static struct ip_nat_helper trigger[MAX_TRIGGER_LIST][MAX_EXT_PORT_RANGE];
static char trigger_names[MAX_TRIGGER_LIST][MAX_EXT_PORT_RANGE][15];

static void fini(void)
{
	int i,j;

	for( i=0; i<trigger_list_count; i++ )
	{
		for( j=0; j<MAX_EXT_PORT_RANGE; j++ )
		{
			if( trigger_list[i].ext_port[j].start == 0 )
				break;
			ip_nat_helper_unregister(&trigger[i][j]);
			DEBUGP("unregister trigger[%d][%d]!!\n",i,j);
		}
	}
}

static int __init init(void)
{
	int i, j, ret;
	char *tmpname;

	for( i=0; i<trigger_list_count; i++ )
	{
		for( j=0; j<MAX_EXT_PORT_RANGE; j++ )
		{
			memset( &trigger[i][j], 0, sizeof(struct ip_nat_helper));

			if( trigger_list[i].ext_port[j].start == 0 )
				break;

			trigger[i][j].tuple.src.u.all = htons( trigger_list[i].ext_port[j].start );
			if( trigger_list[i].ext_port[j].start != trigger_list[i].ext_port[j].end )
			{
				trigger[i][j].tuple.src_range = htons( trigger_list[i].ext_port[j].end );
			}
			trigger[i][j].mask.src.u.all = 0xFFFF;

			if( trigger_list[i].ext_proto != 0 )
			{
				trigger[i][j].tuple.dst.protonum = trigger_list[i].ext_proto;
				trigger[i][j].mask.dst.protonum = 0xFFFF;
			}
			
			trigger[i][j].help = trigger_nat_help;
			trigger[i][j].flags = IP_NAT_HELPER_F_STANDALONE;
			trigger[i][j].me = THIS_MODULE;
			trigger[i][j].expect = trigger_nat_expected;

			tmpname = &trigger_names[i][j][0];
			sprintf(tmpname, "trigger-%d%d",i,j);
			trigger[i][j].name = tmpname;
		
			DEBUGP("registering trigger[%d][%d] (%d - %d)\n",
							i,j,
							trigger_list[i].ext_port[j].start,
							trigger_list[i].ext_port[j].end);
		
			ret = ip_nat_helper_register(&trigger[i][j]);

			if( ret ) 
			{
				DEBUGP("unable to register trigger\n");
				fini();
				return ret;
			}
		}
	}

	return ret;
}

module_init(init);
module_exit(fini);
