/*
 * Licensed under GNU GPL version 2 Copyright Lance Wu 
 * Version: 0.0.1
 *
 * 2003.07.02
 * 	- URL blocking
 *
 */

#include <linux/config.h>
#include <linux/module.h>

#include <linux/proc_fs.h>

#include <linux/ip.h>
#include <net/tcp.h>
//#include <net/udp.h>
#include <linux/ctype.h>

#include <linux/netfilter.h>
#include <linux/netfilter_ipv4/ip_tables.h>
#include <linux/netfilter_ipv4/ip_conntrack_helper.h>
#include "ip_conntrack_urlblock.h"

#include <net/checksum.h>

MODULE_AUTHOR("Lance Wu ");
MODULE_DESCRIPTION("Netfilter connection tracking module for URL blocking");
MODULE_LICENSE("GPL");

#if 0
//#define DEBUGP(format, args...) printk(__FILE__ ":" __FUNCTION__ ": " \
//				       format, ## args)
#define DEBUGP printk
#else
#define DEBUGP(format, args...)
#endif

static struct ip_conntrack_helper url;
static char url_names[10];

char		 url_list[MAX_URL_LIST][MAX_URL_LEN];
int          url_count;


int proc_match(int len, const char *name,struct proc_dir_entry * de)
{
    if( !de || !de->low_ino )
        return 0;
    if( de->namelen != len )
        return 0;
    return !memcmp( name, de->name, len );
}

static int find_host(char* buf, unsigned int buflen )
{
	char* ptr1;
	char* ptr2;
	const char header[] = "GET / HTTP";
	const char item[] = "Host: ";
	unsigned int slen=0;
//	int i=0;
//	char buffer[100]={0};
	
	ptr1 = ptr2 = buf;
	
	if( !memcmp( ptr1, header, strlen(header) ) )
	{
//		DEBUGP("find header!!\n");

		while( *ptr2 != '\r' )
			ptr2++;
		while( (*ptr2 == '\r') || (*ptr2 == '\n') )
			ptr2++;
		slen += (ptr2 - ptr1);
		if( slen >= buflen )
			return 0;
		ptr1 = ptr2;

		while( memcmp( ptr1, item, strlen(item) ) )
		{
	        while( *ptr2 != '\r' )
	            ptr2++;
			while( (*ptr2 == '\r') || (*ptr2 == '\n') )
	        	ptr2++;
	        slen += (ptr2 - ptr1);
	        if( slen > buflen )
	            return 0;
	        ptr1 = ptr2;													
		}
//		DEBUGP("find item!!\n");
		
		return ( ptr1 - buf + strlen(item) );
	}

	return 0;
}

static int url_help(const struct iphdr *iph, size_t len,
		    struct ip_conntrack *ct,
		    enum ip_conntrack_info ctinfo)
{
    struct tcphdr *tcph = (void *)iph + iph->ihl * 4;
	const char* data = (const char*)tcph + tcph->doff * 4;
    unsigned int tcplen = len - iph->ihl * 4;
//    struct ip_conntrack_expect exp;
//	struct ip_ct_ftp_expect *exp_ftp_info = &exp.help.exp_ftp_info;
    int dir = CTINFO2DIR(ctinfo);
//    unsigned int port;
//	int found=0;
//	int i,x;
    unsigned int datalen = tcplen - tcph->doff * 4;
	int offset = 0;
//    unsigned char* pline;
//    int linelen;		

	if( (dir != IP_CT_DIR_ORIGINAL) || (url_count == 0) )
	{
		return NF_ACCEPT;
	}

//	DEBUGP("dir= %s\n",(dir == IP_CT_DIR_ORIGINAL)?"ORIGINAL":"REPLY");

//	DEBUGP("from %u.%u.%u.%u:%u to %u.%u.%u.%u:%u\n",
//			NIPQUAD(iph->saddr),ntohs(tcph->source),
//			NIPQUAD(iph->daddr),ntohs(tcph->dest));
	
	if( datalen == 0 )
	{
		return NF_ACCEPT;
	}

	if( (offset = find_host( data, datalen )) != 0 )
	{
		int i=0,j;
		char buffer[MAX_URL_LEN]={0};
		char* pdata;

		pdata = data + offset;
		
		while( (*pdata != '\r') && (*pdata != '\n') )
		{
			buffer[i] = *pdata;
			i++;
			pdata++;
		}
//		DEBUGP("Host: %s\n",buffer);

		for( i=0; i<MAX_URL_LIST; i++ )
		{
			if( url_list[i][0] == 0 )
				continue;
			for( j=0; j<MAX_URL_LEN; j++ )
			{
				if( buffer[j] == url_list[i][0] )
				{
					if( !memcmp(&buffer[j], url_list[i], strlen(url_list[i])) )
					{
//						DEBUGP("match: list-%d [%s]\n",i,url_list[i]);
						return NF_DROP;
					}
				}
			}
		}

	}
	
	return NF_ACCEPT;
}

static void fini(void)
{
	DEBUGP("unregistering helper for URL blocking\n");
	ip_conntrack_helper_unregister( &url );
}

static int parse_data( unsigned char* buffer , int buflen)
{
	int j=0;
	char* ptr = buffer;
	
	url_count = 0;
	
	while( *ptr != '\0' )
	{
		if( (*ptr == '\r') || (*ptr) == '\n' )
		{
//			DEBUGP("end string\n");
			url_count++;
			j = 0;
			if( url_count == MAX_URL_LIST )
				return 1;
			while( (*ptr == '\r') || (*ptr == '\n') )
				ptr++;
		}
		url_list[url_count][j] = *ptr;
		ptr++;
		j++;
		if( j == (MAX_URL_LEN-1) )
		{
			return 1;
		}
	}
		
	return 1;
}

static int read_url_procfile(void)
{
	struct proc_dir_entry* de;
	unsigned char buffer[MAX_BUF_SIZE];
	char* start;
	int eof=0;
	int len=0;
	
    de = &proc_root;

    for( de=de->subdir; de; de=de->next )
    {
//		DEBUGP("debug: %s , len= %d\n",de->name, de->namelen);
		
        if( proc_match( strlen(URL_FILENAME), URL_FILENAME, de) )
        {
	        DEBUGP("found procfile...[%s]\n",URL_FILENAME);
			start = NULL;
            if( (len = de->read_proc( buffer, &start, 0, MAX_BUF_SIZE, &eof, de->data )) )
			{
				buffer[len] = '\0';
//				DEBUGP("len= %d filedata= %s\n",len,buffer);
				parse_data( buffer, len );
				{
					int i;
					DEBUGP("url_count= %d\n",url_count);
					for( i=0; i< url_count; i++ )
					{
						DEBUGP("data %d = %s\n",i,url_list[i]);
					}
				}
				return 0;
			}
			break;
		}
	}
    if( !de )
	    DEBUGP("procfile [%s] not found!!\n", URL_FILENAME);
	
	return 0;
}


static int __init init(void)
{
	int i, ret;
//	char *tmpname;

	url_count = 0;
	memset( url_list, 0, sizeof(url_list) );

//	url_count = 1;
//	memcpy( url_list[0], "pchome", strlen("pchome") );
	
	read_url_procfile();
	
	memset( &url, 0, sizeof(struct ip_conntrack_helper) );
	
    url.tuple.dst.protonum = IPPROTO_TCP;
    url.tuple.src.u.tcp.port = htons( HTTP_PORT );
    url.mask.dst.protonum = 0xFFFF;
    url.mask.src.u.tcp.port = 0xFFFF;
	url.max_expected = 1;
	url.timeout = 0;
	url.flags = IP_CT_HELPER_F_REUSE_EXPECT;
	url.me = THIS_MODULE;
	url.help = url_help;

//	tmpname = &url_names[0];
	sprintf(url_names, "url");
	
	ret = ip_conntrack_helper_register( &url );
	if( ret || (url_count==0 ) ) 
	{
		DEBUGP("ERROR registering helper for URL blocking\n");
		fini();
		return(ret);
	}
	DEBUGP("register helper for URL blocking SUCCESS!!\n");
	
	return(0);
}

module_init(init);
module_exit(fini);
