

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <linux/types.h>
#include <linux/stat.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <sys/select.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <stdarg.h>
#include <netdb.h>
#include "diagd.h"

unsigned char AscToHex(unsigned char Ch);

//This is a uniqe header for ourselves
const unsigned char COMM_SIGN[SIGN_LEN] =
                    {0xc6,0x52,0x46,0x31,0xc8,0x9c,0xc4,0xe2};

int main(int argc, char *argv[])
{
    int arg;
	int use_daemon = 0;
	unsigned int port = DEFAULT_PORT;
	unsigned int eth_count = 1;
	unsigned char run = 1;
	unsigned char* ptr = 0;

    for (arg = 1;arg<argc;arg++)
    {
        if ( argv[arg][0] == '-' )
        {
        	switch( argv[arg][1] )
			{
			case 'd':
				use_daemon = 1;
				break;
			case 'p':
				port = atoi( argv[arg+1] );
				arg++;
				break;
			case 'r':
				read_data();
				exit(0);
			case 'c':
				eth_count = atoi( argv[arg+1] );
				arg++;
				run = 0;
				break;
			case 'm':
				ptr = argv[arg+1];
				arg++;
				run = 0;
				break;
#ifdef __NOUSED__
			case 'R':
				if( !strcmp(argv[arg],"-Reset") )
				{
					reset_default();
					exit(0);
				}
#endif				
			case 'h':
				printf("Usage: diagd [-p PORT][-h][-d]\n");
				printf("\t-p PORT               : use PORT to listen command, default = 31727\n");
				printf("\t-d                    : run in daemon mode\n");
				printf("\t-r                    : read flash\n");
				printf("\t-m AA:BB:CC:DD:EE:FF  : set MAC address (will reset NICs = 1)\n");
				printf("\t-c COUNT              : set COUNT of NICs , begin from eth0\n");
				printf("\t-Reset                : Reset to default\n");
				printf("\t-h                    : help\n");
				exit(0);
			default:
			    break;
			}
		}
	}
	
    //If run = 0 then it is setting "Count" & "Mac"
	if( run == 0 )
	{
    	//eth_count is not possiable to be set 0 !
		if( (ptr != 0) || (eth_count != 0) )
		{
        	//Set MAC and NIC information to file
			if( set_mac( ptr, eth_count ) == 0 )
				printf("Set MAC address %s ,count %d ok!!\n",(ptr==0)?"not define":(char *)ptr,eth_count);
			else
				printf("Set MAC address %s ,count %d fail!!\n",(ptr==0)?"not define":(char *)ptr,eth_count);
		}
		return 0;
	}

    printf("setting: port: %d \n",port);

	if( agent(port,use_daemon) == -1 )
		perror("Diagd return failure !!\n");
	else
		printf("Diagd return success !!\n");

	return 0;
}

int agent(unsigned int port,int use_daemon)
{
    int Socket;
	int cSocket;
    int iRet;
    int addr_len;
    fd_set stReadFds;
    unsigned char szBuff[BUFFER_SIZE];
    struct sockaddr_in recvAddr;

	if( use_daemon )
	{
		printf("running in daemon mode\n");
    	if( daemon(0,0) < 0 )
    	{
	    	printf("daemon fail\n");
	    	return -1;
    	}
	}

    Socket = init_sock(port);
    if( Socket == -1 )
	    return -1;

    FD_ZERO(&stReadFds);
    FD_SET(Socket,&stReadFds);
    addr_len = sizeof(recvAddr);

    printf("agent running in port: %d\n",port);

	set_mac(0,0);

    while(1)
    {
		memset(szBuff,0,BUFFER_SIZE);
		printf("start listen...\n");

		if( listen(Socket,5) == -1 )
		{
			printf("listen fail !!\n");
			goto SOCKET_FAIL;
		}

		cSocket = accept(Socket,(struct sockaddr *)&recvAddr,&addr_len);
		if( cSocket == -1 )
		{
			printf("accept fail !!\n");
			goto CLIENT_FAIL;
		}

		iRet = recv(cSocket,szBuff,BUFFER_SIZE,0);
		if( iRet > 0 )
		{
			printf("recv %d bytes\n",iRet);
			dispatch(cSocket,szBuff,iRet);
		}
		else
			printf("recv fail!! relisten...\n");
		close( cSocket );
	}

	close( Socket );

	return 0;

CLIENT_FAIL:
	close( cSocket );
SOCKET_FAIL:
	close( Socket );
	return -1;
}



int init_sock(int port)
{
	int sock;
	int addr_len;
	struct sockaddr_in sock_address;

    //Create a socket
    if( (sock = socket(AF_INET,SOCK_STREAM,0)) < 0 )
	{
	    printf("socket fail (%s)\n",strerror(errno));
        return -1;
    }

    sock_address.sin_family = AF_INET;
    sock_address.sin_addr.s_addr = htonl(INADDR_ANY);
    //sock_address.sin_addr.s_addr = htonl(0x7f000001);
    sock_address.sin_port = htons(port);
    addr_len = sizeof(sock_address);

	//printf("sin_family:%d sin_port:%d addr: %u port= %u\n", sock_address.sin_family, sock_address.sin_port, sock_address.sin_addr.s_addr,port);
    if( (bind(sock,(struct sockaddr *)&sock_address,addr_len)) < 0 )
    {
		printf("bind fail (%s)\n",strerror(errno));
        return -1;
    }

    return sock;
}

Command command[]={
		{GET_INFO,get_info},
		{WRITE_ID,write_id},
//		{UPGRADE_UI,upgrade_ui},
		{UPGRADE_FW,upgrade_fw},
//		{RESET_DEFAULT,reset_default},
		{SET_DOMAIN,set_domain},
//		{UPGRADE_BOOT,upgrade_boot},
//		{UPGRADE_FIRMWARE,upgrade_firmware},
//		{EARSE_CONFIG,earse_config},
//		{TEST_PRINTER,test_printer},
		{0}
};


int dispatch(int sock, unsigned char buffer[], int len)
{
	int i;
	CommandHeader* ch;

	if( len < sizeof(CommandHeader) )
	{
		printf("recv packet size too small!! (%d - %d)\n",len,sizeof(CommandHeader));
		return -1;
	}
	ch = (CommandHeader*)buffer;
	if( memcmp(ch->signature,COMM_SIGN,SIGN_LEN) )
	{
		printf("signature mismatch!!\n");
		return -1;
	}
	if( (ch->command[1] != REQUEST) && ((ch->command[1]+ch->cksum[1])!=0xff) )
	{
		printf("Isn't REQUEST command  or checksum error!!\n");
		return -1;
	}
	if( (ch->command[0] + ch->cksum[0]) != 0xff )
	{
		printf("command checksum error!!\n");
		return -1;
	}

	for( i=0; command[i].index != 0; i++ )
	{
		if( command[i].index == ch->command[0] )
		{
			int data_len;
			data_len = ch->data_len[0] * 256 + ch->data_len[1];
			if( command[i].func(sock,buffer+sizeof(CommandHeader),data_len) < 0 )
			{
				printf("call function return error!!\n");
				return -1;
			}
			else
				break;
		}
	}

	// we no support...
	if( command[i].index == 0 )
	{
		printf("Unknow command!!\n");
    	if( send_ack(sock,ch->command[0],(unsigned char*)FAIL,sizeof(FAIL)) == -1 )
			printf("send FAIL(we no support) fail!!\n");
		return -1;
	}

	printf("dispatch ok!!\n");
	return 0;
}


int send_ack(int sock, unsigned char command, unsigned char* data, int len)
{
	int buf_len = 0;
	unsigned char buffer[BUFFER_SIZE];

	memcpy(buffer,COMM_SIGN,SIGN_LEN);
	buf_len += SIGN_LEN;

	buffer[buf_len++] = command;
	buffer[buf_len++] = ACK;
	buffer[buf_len++] = 0xff - command;
	buffer[buf_len++] = 0xff - ACK;

	buffer[buf_len++] = len / 256;
	buffer[buf_len++] = len % 256;

	memcpy( buffer+buf_len, data, len );
	buf_len += len;

	if( send( sock, buffer, buf_len, 0 ) == -1 )
	{
		printf("send data fail\n");
		return -1;
	}

	return 0;
}

int get_info(int sock, unsigned char buffer[], int len)
{
	int buf_len = 0;
	unsigned char buff[12];
	DiagdFlash data;
	//unsigned char strMac[7]={0};

	printf("command is GET_INFO\n");

	/*if( OpenDiagdFlash() == -1 )
	{
		printf("open flash fail!!\n");
		return -1;
	}*/

	if( ReadDiagdFlash(&data,sizeof(data)) != 0 )
	{
		printf("read flash fail!!\n");
		//CloseDiagdFlash();
		return -1;
	}
	//CloseDiagdFlash();

	memset(buff,0,sizeof(buff));

	printf("Model[0]=%d\n", data.model[0]);
    buff[buf_len++] = data.model[0];

#ifdef _7206APB_
	buff[buf_len++] = data.model[1] = 51;
#elif defined(_6104WB_)
	buff[buf_len++] = data.model[1] = 52;
#elif defined(_6104WG_)
	buff[buf_len++] = data.model[1] = 53;
#elif defined(_6104K_)
	buff[buf_len++] = data.model[1] = 54;
#elif defined(_7206GA_)
	buff[buf_len++] = data.model[1] = 55;
#elif defined(_7207APB_)
	buff[buf_len++] = data.model[1] = 56;
#elif defined(_6104WBB_)
	buff[buf_len++] = data.model[1] = 57; 
#elif defined(_6104KPS_)
	buff[buf_len++] = data.model[1] = 58;
#elif defined(_6104IPC_)
	buff[buf_len++] = data.model[1] = 59;
#elif defined(_6104KP_)
	buff[buf_len++] = data.model[1] = 60;
#elif defined(_6104HS_)
	buff[buf_len++] = data.model[1] = 61;
#elif defined(_7207APS_)
	buff[buf_len++] = data.model[1] = 62;
#endif

	printf("Model: 0x%02X - 0x%02X\n",data.model[0],data.model[1]);

	buff[buf_len++] = data.version[0];
	buff[buf_len++] = data.version[1];
	//printf("Version: %d.%02d\n",data.version[0],data.version[1]);

	buff[buf_len++] = data.nic[0];
	buff[buf_len++] = data.nic[1];
	buff[buf_len++] = data.nic[2];
	buff[buf_len++] = data.nic[3];
	buff[buf_len++] = data.nic[4];
	buff[buf_len++] = data.nic[5];
	printf("NIC: %02X-%02X-%02X-%02x-%02X-%02X\n",data.nic[0],data.nic[1],data.nic[2],data.nic[3],data.nic[4],data.nic[5]);	
	//strncpy(strMac, data.nic, 6);
	//sprintf(strMac, "%6.0f", strtod(strMac, NULL)+1);
	//strcpy(data.nicgw, strMac);
    printf("NIC(GW): %02X-%02X-%02X-%02x-%02X-%02X\n",data.nicgw[0],data.nicgw[1],data.nicgw[2],data.nicgw[3],data.nicgw[4],data.nicgw[5]);

	buff[buf_len++] = data.channel[0];
	buff[buf_len++] = data.channel[1];
	printf("Wireless Channel Domain: %d\n",data.domain);

	if( send_ack(sock,GET_INFO,buff,buf_len) == -1 )
	{
		printf("send data fail!!\n");
		return -1;
	}

	return 0;
}

int write_id(int sock, unsigned char buffer[], int len)
{
	DiagdFlash data;
//	unsigned char strTmp[10];
	unsigned char str1[10];
//	unsigned char str2[10];
//	double dtmp;

    printf("command is WRITE_ID\n");

	if( len < (sizeof(data.nic)+8+8) )
	{
		printf("data len mismatch!!\n");
		goto WRITE_FAIL;
	}

	/*if( OpenDiagdFlash() == -1 )
    {
        printf("open flash fail!!\n");
        goto WRITE_FAIL;
    }*/

	if( ReadDiagdFlash(&data,sizeof(data)) != 0 )
    {
        printf("read data fail!!\n");
		//CloseDiagdFlash();
        goto WRITE_FAIL;
    }

	memcpy(data.nic,buffer,sizeof(data.nic));

#ifdef HOME_GATEWAY
	memcpy(str1, buffer, sizeof(data.nicgw));
	AddMac(str1);
	memcpy(data.nicgw, str1, 6);
#endif	
		
	memset(buffer+sizeof(data.nic),UNUSED_PATTERN,8);
	memcpy(data.serial,buffer+sizeof(data.nic),8);
	memcpy(data.h_version,buffer+sizeof(data.nic)+8,8);

	if( WriteDiagdFlash(&data, (DO_ELAN_MAC_ADDR|DO_WLAN_MAC_ADDR|DO_HW_WLAN_ADDR|DO_HW_NIC0_ADDR|DO_HW_NIC1_ADDR)) == -1 )
	{
		printf("write data fail!!\n");
		//CloseDiagdFlash();
		goto WRITE_FAIL;
	}
	//CloseDiagdFlash();

	if( send_ack(sock,WRITE_ID,(unsigned char*)PASS,sizeof(PASS)) == -1 )
	{
		printf("send WRITE_ID (pass) fail!!\n");
		return -1;
	}

	return 0;

WRITE_FAIL:
	if( send_ack(sock,WRITE_ID,(unsigned char*)FAIL,sizeof(FAIL)) == -1 )
		printf("send WRITE_ID (fail) fail!!\n");
	return -1;
}

#ifdef __NOUSED__
int upgrade_ui(int sock, unsigned char buffer[], int len)
{

    printf("command is UPGRADE_UI\n");

    if( send_ack(sock,UPGRADE_UI,(unsigned char*)PASS,sizeof(PASS)) == -1 )
	{
		printf("send UPGRADE_UI (pass) fail!!\n");
		return -1;
	}

	return 0;
}
#endif

int upgrade_fw(int sock, unsigned char buffer[], int len)
{
    char buff[100];

    printf("command is UPGRADE_FW\n");

    // Lance 2003.08.06
#ifdef HOME_GATEWAY
	sprintf(buff,"tftp gw get %d.%d.%d.%d:/%s",buffer[0],buffer[1],buffer[2],buffer[3],buffer+4);
#else
	sprintf(buff,"tftp ap get %d.%d.%d.%d:/%s",buffer[0],buffer[1],buffer[2],buffer[3],buffer+4);
#endif

    printf("use command '%s'\n",buff);
    if(system(buff)==-1){
		printf("TFTP transmission failed!\n");
		return -1;
	}

    if( send_ack(sock,UPGRADE_FW,(unsigned char*)PASS,sizeof(PASS)) == -1 )
	{
		printf("send UPGRADE_FW (pass) fail!!\n");
		return -1;
	}

	return 0;
}

/*
int reset_default(int sock, unsigned char buffer[], int len)
{
    printf("command is RESET_DEFAULT\n");

    if( send_ack(sock,RESET_DEFAULT,(unsigned char*)PASS,sizeof(PASS)) == -1 )
	{
		printf("reset default fail!!\n");
		return -1;
	}

	return 0;
}
*/

int set_domain(int sock, unsigned char buffer[], int len)
{
    DiagdFlash data;

    printf("command is SET_DOMAIN\n");

	if( len != 2 )
    {
        printf("data len mismatch!!\n");
        goto SET_FAIL;
    }

    /*if( OpenDiagdFlash() == -1 )
    {
	    printf("open flash fail!!\n");
	    goto SET_FAIL;
    }*/

	if( ReadDiagdFlash(&data,sizeof(data)) != 0 )
    {
        printf("read data fail!!\n");
        //CloseDiagdFlash();
        goto SET_FAIL;
    }
	
	printf("Channel[0]: %d\n", buffer[0]);
	printf("Channel[1]: %d\n", buffer[1]);

	if(buffer[0]==1){
		if(buffer[1]==11) data.domain = DOMAIN_FCC;
		if(buffer[1]==13) data.domain = DOMAIN_EISI;
		if(buffer[1]==14) data.domain = DOMAIN_MKK;
	} else if(buffer[0]==10){
		if(buffer[1]==11) data.domain = DOMAIN_SPAIN;
		if(buffer[1]==13) data.domain = DOMAIN_FRANCE;
	} else if(buffer[0]==14){
		if(buffer[1]==14) data.domain = DOMAIN_MKK;		
	} else {
		printf("Wrong channel range received!\n");
		data.domain = 0;
	}
	
	data.channel[0] = buffer[0];
	data.channel[1] = buffer[1];

    if( WriteDiagdFlash(&data, DO_HW_REG_DOMAIN) == -1 )
    {
        printf("write data fail!!\n");
        //CloseDiagdFlash();
        goto SET_FAIL;
    }
    //CloseDiagdFlash();

    if( send_ack(sock,SET_DOMAIN,(unsigned char*)PASS,sizeof(PASS)) == -1 )
	{
		printf("send SET_DOMAIN (pass) fail!!\n");
        return -1;
	}

	return 0;

SET_FAIL:
    if( send_ack(sock,SET_DOMAIN,(unsigned char*)FAIL,sizeof(FAIL)) == -1 )
        printf("send SET_DOMAIN (fail) fail!!\n");
    return -1;
}

#ifdef __NOUSED__
int upgrade_boot(int sock, unsigned char buffer[], int len)
{
    printf("command is UPGRADE_BOOT\n");

    if( send_ack(sock,UPGRADE_BOOT,(unsigned char*)PASS,sizeof(PASS)) == -1 )
	{
		printf("upgrade boot fail!!\n");
        return -1;
	}

	return 0;
}


int upgrade_firmware(int sock, unsigned char buffer[], int len)
{
    printf("command is UPGRADE_FIRMWARE\n");

    if( send_ack(sock,UPGRADE_FIRMWARE,(unsigned char*)PASS,sizeof(PASS)) == -1 )
	{
		printf("upgrade firmware fail!!\n");
        return -1;
	}

	return 0;
}


int earse_config(int sock, unsigned char buffer[], int len)
{
    printf("command is EARSE_CONFIG\n");

    if( send_ack(sock,EARSE_CONFIG,(unsigned char*)PASS,sizeof(PASS)) == -1 )
	{
		printf("earse config fail!!\n");
        return -1;
	}

	return 0;
}

int test_printer(int sock, unsigned char buffer[], int len)
{
    printf("command is TEST_PRINTER\n");

	// no support...
    if( send_ack(sock,TEST_PRINTER,(unsigned char*)FAIL,sizeof(FAIL)) == -1 )
	{
		printf("test printer fail!!\n");
		return -1;
	}

	return 0;
}
#endif

//Read information to a specified sturcture
void read_data(void)
{
	int buf_len;
	unsigned char buffer[92] = {0};
	DiagdFlash data;

	printf("read flash...\n");

	buf_len = sizeof(buffer);

	/*if( OpenDiagdFlash() == -1 )
	{
		printf("open flash fail!!\n");
		return;
	}*/

    if( ReadDiagdFlash(&data,sizeof(data)) != 0 )
    {
        printf("read flash (DIAGD) fail!!\n");
		//CloseDiagdFlash();
        return;
    }
	//CloseDiagdFlash();

    //There are following information contained in structure DiagdFlash
	printf("DIAGD struct:\n");
	printf("SIGNATURE: %02X %02X %02X %02X %02X %02X %02X %02X\n",
					data.signature[0],data.signature[1],data.signature[2],data.signature[3],
					data.signature[4],data.signature[5],data.signature[6],data.signature[7]);
	//printf("Model: 0x%02X , 0x%02X\n",data.model[0],data.model[1]);
	//printf("Version: %d.%d\n",data.version[0],data.version[1]);
	printf("NIC: %02X-%02X-%02X-%02X-%02X-%02X\n",data.nic[0],data.nic[1],data.nic[2],data.nic[3],data.nic[4],data.nic[5]);
	printf("NIC(GW): %02X-%02X-%02X-%02X-%02X-%02X\n",data.nicgw[0],data.nicgw[1],data.nicgw[2],data.nicgw[3],data.nicgw[4],data.nicgw[5]);
	//printf("NICs: %d\n",data.eth_count);
	printf("Domain: %d\n",data.domain);
	//printf("Serial: %s\n",data.serial);
	printf("Hardware Version: %s\n",data.h_version);
}


int set_mac(char* address, unsigned int count)
{
	int i,j;
	unsigned char val;
	unsigned char c;
	//char buffer[1024];
	//unsigned char m_addr[20], m_addrgw[20];
	DiagdFlash data;
	//unsigned long lmaddr = 0, lmaddrgw = 0;
	int IsChange = 0;
	unsigned char strMac[6]={0};
	
	//if( OpenDiagdFlash() == -1 )
    //{
    //    printf("open flash fail!!\n");
    //    return -1;
    //}

    
    if( ReadDiagdFlash(&data,sizeof(data)) != 0 )
	{
	    printf("read flash (DIAGD) fail!!\n");
	    //CloseDiagdFlash();
	    return -1;
	}
	
	if( count != 0 )
	{
		data.eth_count = count;
		IsChange = 1;
	}


	if( address != 0 )
	{
		for( i=0; i<6; i++ )
		{
			val = 0;
			if( i && (*address == ':'))
				address++;
	        for (j=0 ; j<2 ; j++) {
    	        c = *address;
        	    if (c >= '0' && c <= '9') {
            	    c -= '0';
	            } else if (c >= 'a' && c <= 'f') {
    	            c -= ('a' - 10);
        	    } else if (c >= 'A' && c <= 'F') {
            	    c -= ('A' - 10);
	            } else if (j && (c == ':' || c == 0)) {
    	            break;
        	    } else {
					printf("address data error, must be AA:BB:CC:DD:EE:FF !!\n");
            	    return -1;
	            }
	            ++address;
    	        val <<= 4;
        	    val += c;
			}
			data.nic[i] = val;//Set MAC to according nic
		}
		IsChange = 1;
#ifdef HOME_GATEWAY
		//Save nicgw[] as nic[]+1
		strncpy(strMac, data.nic, 6);
		AddMac(strMac);
		strncpy(data.nicgw, strMac, 6);
#endif
	}
	
	if( IsChange == 1 )
		WriteDiagdFlash(&data, DO_ELAN_MAC_ADDR|DO_WLAN_MAC_ADDR|DO_HW_NIC0_ADDR|DO_HW_WLAN_ADDR|DO_HW_NIC1_ADDR);

	//CloseDiagdFlash();

//===>Following section is not used in this case...
//
//	lmaddr = (data.nic[3]<<16) + (data.nic[4]<<8) + data.nic[5];
//
//#ifdef HOME_GATEWAY
//	    lmaddrgw = (data.nicgw[3]<<16) + (data.nicgw[4]<<8) + data.nicgw[5];
//#endif
//	
//	system("echo \"#!/bin/sh\" > /etc/diagd.def");
//
//	sprintf(buffer,"echo COUNT=%d >> /etc/diagd.def",data.eth_count);
//	system(buffer);
//
//	for( i=0; i<data.eth_count; i++ )
//	{
//		if( data.eth_count == 1 )
//			sprintf(buffer,"echo ETH0=eth0 >> /etc/diagd.def");
//		else
//			sprintf(buffer,"echo ETH%d=eth0.%d >> /etc/diagd.def",i,i+1);
//		system(buffer);
//	
//		sprintf(m_addr,"%02X:%02X:%02X:%02X:%02X:%02X",
//					data.nic[0],data.nic[1],data.nic[2],
//					*(((unsigned char*)&lmaddr)+2),*(((unsigned char*)&lmaddr)+1),*(unsigned char*)&lmaddr);
//		sprintf(buffer,"echo ETH%d_MAC=%s >> /etc/diagd.def",i,m_addr);
//		system(buffer);
//	
//#ifdef HOME_GATEWAY
//        sprintf(m_addrgw,"%02X:%02X:%02X:%02X:%02X:%02X",
//					data.nicgw[0],data.nicgw[1],data.nicgw[2],
//					*(((unsigned char*)&lmaddrgw)+2),*(((unsigned char*)&lmaddrgw)+1),*(unsigned char*)&lmaddrgw);
//		sprintf(buffer,"echo ETH%d_MAC=%s >> /etc/diagd.def",i,m_addrgw);
//		system(buffer);
//#endif
//
//		// Create LAN ( WAN ) MAC address info file
//		if( data.eth_count == 1 )
//			sprintf(buffer,"echo %s > /var/info/lan_mac_address",m_addr);
//		else
//		{
//			/*if( i == 0 )
//				sprintf(buffer,"echo %s > /var/info/lan_mac_address",m_addr);
//			else
//				sprintf(buffer,"echo %s > /var/info/wan-%d_mac_address",i,m_addr,i);
//			*/
//			if( i == 0 ){
//				sprintf(buffer,"echo %s > /var/info/lan_mac_address",m_addr);
//#ifdef HOME_GATEWAY
//				sprintf(buffer,"echo %s > /var/info/wan-%d_mac_address",m_addrgw,i);
//#endif
//			}
//		}
//		system(buffer);
//
//		lmaddr++;
//	}
//
//	// Create Hardware Version info file
//	sprintf(buffer,"echo %s > /var/info/hardware_version",data.h_version);
//	system(buffer);
//
//	// Create Serial info file
//	sprintf(buffer,"echo %s > /var/info/serial",data.serial);
//	system(buffer);
//
//	// Create firmware version info file
//	{
//		int fd;
//		unsigned char ver[9] = {0};
//
//		if( (fd = open("/dev/mtd3", O_RDWR)) < 0 )
//			sprintf(buffer,"echo OPEN_FAIL > /var/info/kernel-1_version");
//		else
//		{
//		    if( read(fd, ver, 8)< 0 )
//		    {
//                sprintf(buffer,"echo READ_FAIL > /var/info/kernel-1_version");
//		    }
//			else
//	            sprintf(buffer,"echo %s > /var/info/kernel-1_version",ver);
//		}
//		close(fd);
//		system(buffer);
//
//		memset(ver,0,9);
//
//        if( (fd = open("/dev/mtd4", O_RDWR)) < 0 )
//	        sprintf(buffer,"echo OPEN_FAIL > /var/info/kernel-2_version");
//	    else
//	    {
//		    if( read(fd, ver, 8)< 0 )
//		    {
//			    sprintf(buffer,"echo READ_FAIL > /var/info/kernel-2_version");
//			}
//	        else
//	            sprintf(buffer,"echo %s > /var/info/kernel-2_version",ver);
//	    }
//	    close(fd);
//		system(buffer);
//
//	}
//
//	// Create BootCode version info file
//	{
//		int fd;
//		unsigned char ver[6] = {0};
//
//       if( (fd = open("/dev/mtd0", O_RDWR)) < 0 )
//	        sprintf(buffer,"echo OPEN_FAIL > /var/info/bootcode_version");
//	    else
//	    {
//			lseek(fd,0x17e00,SEEK_SET);
//		    if( read(fd, ver, 5) < 0 )
//		    {
//			    sprintf(buffer,"echo READ_FAIL > /var/info/bootcode_version");
//			}
//			else
//	            sprintf(buffer,"echo %s > /var/info/bootcode_version",ver);
//	    }
//	    close(fd);
//	    system(buffer);
//	}
//
//	// Create Boot info file
//    {
//		int fd;
//		unsigned char ver[3] = {0};
//
//        if( (fd = open("/dev/mtd0", O_RDWR)) < 0 )
//		{
//	        sprintf(buffer,"echo OPEN_FAIL > /var/info/runcode");
//	        system(buffer);
//            sprintf(buffer,"echo OPEN_FAIL > /var/info/kernel-1_stat");
//            system(buffer);
//            sprintf(buffer,"echo OPEN_FAIL > /var/info/kernel-2_stat");
//            system(buffer);
//		}
//	    else
//	    {
//		    lseek(fd,0x18000,SEEK_SET);
//		    if( read(fd, ver, 3)< 0 )
//		    {
//            	sprintf(buffer,"echo READ_FAIL > /var/info/runcode");
//			    system(buffer);
//				sprintf(buffer,"echo READ_FAIL > /var/info/kernel-1_stat");
//				system(buffer);
//				sprintf(buffer,"echo READ_FAIL > /var/info/kernel-2_stat");
//				system(buffer);
//			}
//            else
//			{
//            	sprintf(buffer,"echo %s > /var/info/runcode",ver[0]==0?"Kernel-1":"Kernel-2");
//			    system(buffer);
//				sprintf(buffer,"echo %s > /var/info/kernel-1_stat",ver[1]==0?"OK":"ERR");
//				system(buffer);
//				sprintf(buffer,"echo %s > /var/info/kernel-2_stat",ver[2]==0?"OK":"ERR");
//				system(buffer);
//			}
//		}
//        close(fd);
//	}
//
//	// Create channel range file
//	{
//		unsigned char rang[3] = {0};
//		//rang[0] = data.channel[0];
//		rang[0] = UNUSED_PATTERN;
//		//rang[1] = data.channel[1];
//		rang[1] = UNUSED_PATTERN;
//
//		sprintf(buffer,"echo %s > /var/info/channel_range",rang);
//		system(buffer);
//	}

	return 0;
}

int ReadDiagdFlash(DiagdFlash * stcFlash, unsigned int size)
{
	unsigned char buff[200];
	//unsigned char compare1[20], compare2[20], compare3[20];
	FILE *fptr;
	int i=0, j=0;
	unsigned char capbuf[255];
	//unsigned char tmp;
			
	printf("Read Diagd Flash is called!\n");

	//===> 0
	sprintf(buff,"/bin/flash get ELAN_MAC_ADDR >> %s", TMP_FILE);
	system(buff);
	
	//===> 1
	sprintf(buff,"/bin/flash get WLAN_MAC_ADDR >> %s", TMP_FILE);
	system(buff);

	//===> 2
	sprintf(buff,"/bin/flash get HW_NIC0_ADDR >> %s", TMP_FILE);
	system(buff);

	//===> 3
	sprintf(buff,"/bin/flash get HW_WLAN_ADDR >> %s", TMP_FILE);
	system(buff);

	//===> 4
	sprintf(buff,"/bin/flash get HW_REG_DOMAIN >> %s", TMP_FILE);
	system(buff);

	//===> 5
	sprintf(buff,"/bin/flash get HW_NIC1_ADDR >> %s", TMP_FILE);
	system(buff);

	//Read tempory file for flash infomation
    //printf("Start!\n");
	if((fptr=fopen(TMP_FILE, "r")) == NULL){
		printf("Temporary file %s access error. System can't read file.", TMP_FILE);
		return 0;
	}
	
    i = 0;
    while(EOF != fscanf(fptr, "%s", capbuf)){
    	//printf("Get => %s\n", capbuf);
		if(!memcmp(capbuf, STR_HWN0MAC, j = sizeof(STR_HWN0MAC)-1)){
			++j;
			//printf("Result => %s\n", &capbuf[j]);
			
			stcFlash->nic[0] = AscToHex(capbuf[j++])*0x10 + AscToHex(capbuf[j++]);
			stcFlash->nic[1] = AscToHex(capbuf[j++])*0x10 + AscToHex(capbuf[j++]);
			stcFlash->nic[2] = AscToHex(capbuf[j++])*0x10 + AscToHex(capbuf[j++]);
			stcFlash->nic[3] = AscToHex(capbuf[j++])*0x10 + AscToHex(capbuf[j++]);
			stcFlash->nic[4] = AscToHex(capbuf[j++])*0x10 + AscToHex(capbuf[j++]);
			stcFlash->nic[5] = AscToHex(capbuf[j++])*0x10 + AscToHex(capbuf[j++]);

			printf("MAC: %02X %02X %02X %02X %02X %02X\n", stcFlash->nic[0], stcFlash->nic[1], stcFlash->nic[2], stcFlash->nic[3], stcFlash->nic[4], stcFlash->nic[5]);
		
		}
		
		//The others (STR_ELMAC, STR_WLMAC, STR_HWN0MAC, STR_HWWMAC) are the smae data in flash
		//so, read one is just fine.
        
		if(!memcmp(capbuf, STR_DMN, j = sizeof(STR_DMN)-1)){
			++j;
			//printf("Result => %s\n", &capbuf[j]);
			stcFlash->domain = AscToHex(capbuf[j]);
			printf("Domain: %d\n", stcFlash->domain);

			switch(stcFlash->domain){
				case DOMAIN_FCC:
					stcFlash->channel[0]=1;
					stcFlash->channel[1]=11;
					break;

				case DOMAIN_IC:
					//stcFlash->channel[0]=1;
					//stcFlash->channel[1]=11;
					break;
					
				case DOMAIN_EISI:
					stcFlash->channel[0]=1;
					stcFlash->channel[1]=13;
					break;
					
				case DOMAIN_SPAIN:
					stcFlash->channel[0]=10;
					stcFlash->channel[1]=11;
					break;
					
				case DOMAIN_FRANCE:
					stcFlash->channel[0]=10;
					stcFlash->channel[1]=13;
					break;
					
				case DOMAIN_MKK:
					stcFlash->channel[0]=1;
					stcFlash->channel[1]=14;
					break;

				default:
					stcFlash->channel[0]=0;
					stcFlash->channel[1]=0;
			}			
			printf("Channel: %d ~ %d\n", stcFlash->channel[0], stcFlash->channel[1]);
		}

#ifdef HOME_GATEWAY
		if(!memcmp(capbuf, STR_HWN1MAC, j = sizeof(STR_HWN1MAC)-1)){
			++j;
			printf("Result => %s\n", &capbuf[j]);
				
			stcFlash->nicgw[0] = AscToHex(capbuf[j++])*0x10 + AscToHex(capbuf[j++]);
			stcFlash->nicgw[1] = AscToHex(capbuf[j++])*0x10 + AscToHex(capbuf[j++]);
			stcFlash->nicgw[2] = AscToHex(capbuf[j++])*0x10 + AscToHex(capbuf[j++]);
			stcFlash->nicgw[3] = AscToHex(capbuf[j++])*0x10 + AscToHex(capbuf[j++]);
			stcFlash->nicgw[4] = AscToHex(capbuf[j++])*0x10 + AscToHex(capbuf[j++]);
			stcFlash->nicgw[5] = AscToHex(capbuf[j++])*0x10 + AscToHex(capbuf[j++]);
				
			printf("WAN MAC: %02X %02X %02X %02X %02X %02X\n", stcFlash->nicgw[0], stcFlash->nicgw[1], stcFlash->nicgw[2], stcFlash->nicgw[3], stcFlash->nicgw[4], stcFlash->nicgw[5]);
		}
#endif
    }

	fclose(fptr);

	sprintf(buff,"rm %s",TMP_FILE);
	system(buff);

	printf("Reach Model & Version!\n");

	//Read Model from /web/set.css
	//The format must be 2 digits
	if((fptr=fopen(MOD_FILE, "r")) == NULL){
		printf("Temporary file %s access error. System can't read file.", MOD_FILE);
		return 0;
	}

	printf("Reach Model\n");
    while(EOF != fscanf(fptr, "%s", capbuf)){
		if(!memcmp(capbuf, STR_MODEL, j = sizeof(STR_MODEL)-1)){
			j++;
			stcFlash->model[0] = AscToHex(capbuf[j++])*0x10 + AscToHex(capbuf[j++]);
			printf("Model[0]: %x\n", stcFlash->model[0]);
		}			
	}
	fclose(fptr);

	//Read firmware version from /etc/version
    if((fptr=fopen(VER_FILE, "r")) == NULL){
		printf("Temporary file %s access error. System can't read file.", VER_FILE);
		return 0;	
	}
    
	printf("Reach Version\n");
	while(EOF != fscanf(fptr, "%s", capbuf)){
		if(strlen(capbuf)!=0){
			unsigned char * pptr, * ptr;
			unsigned char PreDigi;
			unsigned char PostDigi;
			unsigned char Big=0, Little=0;

			printf("Version:%s\n", capbuf);
			pptr = strchr(capbuf, '.');
			PreDigi = (void *)pptr - (void *)capbuf;
			PostDigi = strlen(capbuf) - PreDigi - 1;

			ptr = capbuf;
			for(i=0; i<PreDigi; i++){
				Big *= 10;
				Big += AscToHex(*(ptr++));
			}
			printf("Big:%d\n", Big);

			ptr = pptr + 1;
			for(i=0; i<PostDigi; i++){
				Little *=10;
				Little += AscToHex(*(ptr++));
			}		
			printf("Little:%d\n", Little);
			
			stcFlash->version[1] = Little;
			stcFlash->version[0] = Big;
		}
	}
	fclose(fptr);
			
	return 0;		
}

int WriteDiagdFlash(DiagdFlash * stcFlash, unsigned int flag){

	unsigned char buff[200]={0};
	unsigned char tmp[20]={0};
    printf("!Write Diagd Flash is called!\n");

	//===>LAN MAC releatived
	if(flag & DO_ELAN_MAC_ADDR){
		memcpy(tmp, stcFlash->nic, 6);
    	sprintf(buff, "/bin/flash set ELAN_MAC_ADDR 000000000000");
		//sprintf(buff, "/bin/flash set ELAN_MAC_ADDR %02X%02X%02X%02X%02X%02X", tmp[0], tmp[1], tmp[2], tmp[3], tmp[4], tmp[5]);
		system(buff);
    	printf("%s\n", buff);
	}
	
	if(flag & DO_WLAN_MAC_ADDR){
	    memcpy(tmp, stcFlash->nic, 6);
		sprintf(buff, "/bin/flash set WLAN_MAC_ADDR 000000000000");
		//sprintf(buff, "/bin/flash set WLAN_MAC_ADDR %02X%02X%02X%02X%02X%02X", tmp[0], tmp[1], tmp[2], tmp[3], tmp[4], tmp[5]);
		system(buff);
	    printf("%s\n", buff);
	}
	
	if(flag & DO_HW_NIC0_ADDR){
    	memcpy(tmp, stcFlash->nic, 6);
		sprintf(buff, "/bin/flash set HW_NIC0_ADDR %02X%02X%02X%02X%02X%02X", tmp[0], tmp[1], tmp[2], tmp[3], tmp[4], tmp[5]);
		system(buff);
	    printf("%s\n", buff);
	}

#ifdef HOME_GATEWAY
    //===>WAN MAC releatived

	if(flag & DO_HW_NIC1_ADDR){
		memcpy(tmp, stcFlash->nicgw, 6);
		sprintf(buff, "/bin/flash set HW_NIC1_ADDR %02X%02X%02X%02X%02X%02X", tmp[0], tmp[1], tmp[2], tmp[3], tmp[4], tmp[5]);
		system(buff);
		printf("%s\n", buff);
	}
#endif
	
	if(flag & DO_HW_WLAN_ADDR){
	    memcpy(tmp, stcFlash->nic, 6);
		sprintf(buff, "/bin/flash set HW_WLAN_ADDR %02X%02X%02X%02X%02X%02X", tmp[0], tmp[1], tmp[2], tmp[3], tmp[4], tmp[5]);
		system(buff);
    	printf("%s\n", buff);
	}
	
	if(flag & DO_HW_REG_DOMAIN){
		sprintf(buff, "/bin/flash set HW_REG_DOMAIN %X", stcFlash->domain);
		system(buff);
		printf("%s\n", buff);
	}
	
	//sprintf(buff, "/bin/flash set HW_BOARD_ID %s", stcFlash->h_version);
	//system(buff);
    //

	sleep(3);

	return 0;
}

unsigned char AscToHex(unsigned char Ch){
	if(Ch >= '0' && Ch <='9')
		Ch -= '0';
	else if(Ch >= 'A' && Ch <= 'F')
		Ch -= 0x37;
	else if(Ch >= 'a' && Ch <= 'f')
		Ch -= 0x57;

	return Ch;
}

void AddMac(unsigned char * Num)
{
    //printf("===>Add1:%02X%02X%02X%02X%02X%02X\n", *(Num+0),*(Num+1),*(Num+2),*(Num+3),*(Num+4),*(Num+5));

	if(++*(Num+5)==0){
		if(++*(Num+4)==0){
			if(++*(Num+3)==0){
				printf("No more number to write!\n");
			}
		}
	}

    //printf("===>Add2:%02X%02X%02X%02X%02X%02X\n", *(Num+0),*(Num+1),*(Num+2),*(Num+3),*(Num+4),*(Num+5));
	
}

#ifdef __NOUSED__
int reset_default(void)
{
    if( OpenDiagdFlash() == -1 )
    {
	    printf("open flash fail!!\n");
	    return 0;
	}

	if( ResetDiagdFlash() == -1 )
	{
		printf("reset flash fail!!\n");
		return 0;
	}

    CloseDiagdFlash();

	printf("reset flash ok!!\n");

	return 0;
}
#endif
