#ifndef _DIAGD_H_
#define _DIAGD_H_

#define SIGN_LEN			8
#define	UNUSED_PATTERN		0

#define DOMAIN_FCC			1
#define DOMAIN_IC			2
#define DOMAIN_EISI			3
#define DOMAIN_SPAIN		4
#define DOMAIN_FRANCE		5
#define	DOMAIN_MKK			6

#define DO_ELAN_MAC_ADDR	0x01
#define DO_WLAN_MAC_ADDR	0x02
#define DO_HW_NIC0_ADDR		0x04
#define DO_HW_WLAN_ADDR		0x08
#define DO_HW_REG_DOMAIN	0x10
#define DO_HW_NIC1_ADDR		0x20

#define STR_ELMAC       "ELAN_MAC_ADDR"
#define STR_WLMAC       "WLAN_MAC_ADDR"
#define STR_HWWMAC      "HW_WLAN_ADDR"
#define STR_HWN0MAC     "HW_NIC0_ADDR"
#define STR_HWN1MAC		"HW_NIC1_ADDR"
#define STR_DMN         "HW_REG_DOMAIN"
#define STR_MODEL		"Model"

#define TMP_FILE			"/tmp/__diagdtmp__"
#define VER_FILE			"/etc/version"
#define MOD_FILE			"/web/set.css"

const unsigned int DEFAULT_PORT = 31727;
const unsigned int BUFFER_SIZE = 1500;

const unsigned char REQUEST = 0;
const unsigned char ACK = 1;

const unsigned char PASS[] = "PASS";
const unsigned char FAIL[] = "FAIL";

typedef struct _tagCommandHeader{
	unsigned char signature[SIGN_LEN];
	unsigned char command[2];
	unsigned char cksum[2];
	unsigned char data_len[2];
}CommandHeader;

typedef struct _tagDiagdFlash{
	unsigned char eth_count;
	unsigned char nic[6];
	unsigned char nicgw[6];
	unsigned char h_version[8];
	unsigned char serial[32];
	unsigned char channel[3];
    unsigned char model[2];
    unsigned char version[2];
	unsigned char domain;
	unsigned char signature[SIGN_LEN];
}DiagdFlash;

enum{
	GET_INFO = 0x01,
	WRITE_ID = 0x02,
	UPGRADE_UI = 0x03,
	UPGRADE_FW = 0x04,
	RESET_DEFAULT = 0x05,
	SET_DOMAIN = 0x06,
	UPGRADE_BOOT = 0x07,
	UPGRADE_FIRMWARE = 0x08,
	EARSE_CONFIG = 0x09,
	TEST_PRINTER = 0xD1
};

typedef struct _tagCommand{
	unsigned char index;
	int (*func)(int sock,unsigned char buff[],int len);
}Command;

void read_data(void);

int agent(unsigned int port,int use_daemon);
int init_sock(int port);
int dispatch(int sock, unsigned char buffer[], int len);

int send_ack(int sock, unsigned char command, unsigned char* data, int len);

int get_info(int sock, unsigned char buffer[], int len);
int write_id(int sock, unsigned char buffer[], int len);
//int upgrade_ui(int sock, unsigned char buffer[], int len);
int upgrade_fw(int sock, unsigned char buffer[], int len);
//int reset_default(int sock, unsigned char buffer[], int len);
int set_domain(int sock, unsigned char buffer[], int len);
//int upgrade_boot(int sock, unsigned char buffer[], int len);
//int upgrade_firmware(int sock, unsigned char buffer[], int len);
//int earse_config(int sock, unsigned char buffer[], int len);
//int test_printer(int sock, unsigned char buffer[], int len);
int reset_default(void);

//
const unsigned char DEFINE_FILE[] = "/etc/daigd-define";

int write_define(void);
//

int set_mac(char* address,unsigned int count);

int ReadDiagdFlash(DiagdFlash *, unsigned int);
int WriteDiagdFlash(DiagdFlash *, unsigned int);
void AddMac(unsigned char *);


#endif
