#!/bin/sh

SCRIPT_FILE="DoIT.sh"
. ../target.def 

if [ -f libpcap-0.7.2/bpf_filter.c ]; then
	echo "libpcap ok"
else
	tar xzvf libpcap-0.7.2.tgz
fi

if [ -f gmp-4.1/gmp-mparam.h ]; then
	echo "gmp ok"
else
	tar xzvf gmp-4.1.tgz
fi

if [ $# -gt 2 ]; then
	echo "usage $0 [make|clean|config] [ap|gw|ga]"
	exit 1
fi

case "$1" in
	"make")
		export MAKING=1
		export MAKECLEAR=0
		MAKING_IMG=1
		;;
	"clean")
		export MAKING=0
		export MAKECLEAR=1
		MAKING_IMG=0
		;;
	"config")
		export MAKING=0
		export MAKECLEAR=1
		export MAKCONFIG=1
		MAKING_IMG=0
		;;
    *)
        echo "usage $0 [make|clean|config] [ap|gw|ga]"
        exit 1
        ;;								
esac

if [ $# = 2 ]; then
	case "$2" in
		"ap")
			TYPE=ap
			;;
		"gw")
			TYPE=gw
			;;
		"ga")
			TYPE=ga
			;;
		*)
			echo "usage $0 [make|clean|config] [ap|gw|ga]"
			exit 1
			;;
	esac
fi								

if [ "$TYPE" = "" ]; then
	if [ "$1" != "clean" ]; then
		echo "usage $0 [make|clean|config] [ap|gw|ga]"
		exit 1
	fi
fi

for DIR in $(ls); do
    if [ -d $DIR ]; then
		cd $DIR
		if [ -f $SCRIPT_FILE ]; then
		    echo ""
			echo "******************** Compiling $DIR ********************"
			echo ""
			./$SCRIPT_FILE $TYPE
			if [ $? = 0 ]; then
				echo ""
				echo "******************** End compile $DIR ********************"
				echo ""
			else
                echo ""
                echo "******************** compile ERROR in $DIR !! ********************"
                echo ""
				exit 1
			fi
		fi
		cd ..
	fi
done

if [ "$MAKING_IMG" = "1" ]; then
	echo ""
	echo "******************** Making appimg ********************"
	echo ""
	cd $AP_PATH/mkimg

	case "$MODEL" in
		"-D_6104WG_")
				echo "******************** Making appimg 6104WG ********************"
				./mk6104wg
				;;
        "-D_6104IPC_")
                echo "******************** Making appimg 6104WG ********************"
				./mk6104ipc
				;;
		"-D_6104K_")
				echo "******************** Making appimg 6104K ********************"
				./mk6104k
				;;
		"-D_6104WB_")
				echo "******************** Making appimg 6104WB ********************"
				./mk6104wb
				;;
        "-D_7206APB_")
	            echo "******************** Making appimg 7206APB ********************"
 	            ./mk7206apb
	            ;;
        "-D_7206APG_")
				echo "******************** Making appimg 7206APG ********************"
	            ./mk7206APG
	            ;;
		"-D_7206GA_")
				echo "******************** Making appimg 7206GA ********************"
				./mk7206ga
				;;
        "-D_7207APB_")
	            echo "******************** Making appimg 7207APB ********************"
 	            ./mk7207apb
	            ;;
        "-D_6104WBB_")
	            echo "******************** Making appimg 6104WBB ********************"
 	            ./mk6104wbb
	            ;;
        "-D_6104KPS_")
	            echo "******************** Making appimg 6104KPS ********************"
 	            ./mk6104kps
	            ;;
        "-D_6104KP_")
	            echo "******************** Making appimg 6104KP ********************"
 	            ./mk6104kp
	            ;;
        "-D_7207APS_")
	            echo "******************** Making appimg 7207APS ********************"
 	            ./mk7207aps
	            ;;
		*)
				echo "******************** Model not found  ********************"
				exit 1
				;;
	esac

	if [ $? = 0 ]; then
		echo ""
		echo "******************** Make appimg OK !! ********************"
		echo ""
	else
		echo ""
	    echo "******************** Make appimg FAIL !! ********************"
		echo ""
		exit 1
	fi
fi

echo ""
echo "******************** Script finished !! ********************"
echo ""


