#!/bin/sh

. ../../target.def

if [ -f gmp-mparam.h ]; then
	echo "ok"
else
	ln -s ./mpn/mips32/gmp-mparam.h gmp-mparam.h
fi

if [ "$#" = "1" ]; then
    case "$1" in
        "clean")
            MAKECLEAR=1
            MAKING=0
            ;;
        "make")
            MAKECLEAR=0
            MAKING=1
			;;
        "ap")
            echo "AP dosn't need this!!"
            exit 0
            ;;													
        "ga")
            echo "GA dosn't need this!!"
            exit 0
            ;;													
		"config")
			if [ "$PLATFORM" = "-D_ADM5120_" ]; then
				./configure CC=mipsel-uclibc-gcc --build=mips-linux --host=mipsel
			else 
				./configure CC=mips-uclibc-gcc --build=mips-linux --host=mips
			fi
			if [ $? != 0 ]; then
				exit 1
			fi
			;;
    esac
fi																							

if [ "$MAKECLEAR" = "1" ]; then
	make clean
    if [ "$?" != "0" ]; then
	    exit 1
	fi					
fi

if [ "$MAKCONFIG" = "1" ]; then
	if [ "$PLATFORM" = "-D_ADM5120_" ]; then
#		./configure CC=mipsel-uclibc-gcc --build=mipsel-linux --host=mips
		./configure CC=mipsel-uclibc-gcc --build=mips-linux --host=mipsel
	else 
		./configure CC=mips-uclibc-gcc --build=mips-linux --host=mips
	fi
    
	if [ "$?" != "0" ]; then
		exit 1
	fi
	exit 0
fi

if [ "$MAKING" = "1" ]; then
	make
    if [ "$?" != "0" ]; then
	    exit 1
	fi					
fi
