/*
 *      Include file of form handler
 *
 *      Authors: David Hsu	<davidhsu@realtek.com.tw>
 *
 *      $Id: apform.h,v 1.7 2004/03/12 01:47:46 erwin Exp $
 *
 */

#ifndef _INCLUDE_APFORM_H
#define _INCLUDE_APFORM_H

#if HAVE_STDBOOL_H
# include <stdbool.h>
#else
typedef enum {false = 0, true = 1} bool;
#endif

#define noNO_ACTION

#ifdef HOME_GATEWAY

// gateway mode (wlan0+eth0)
//#define WAN_IF	T("eth0")
//#define BRIDGE_IF	T("wlan0")

//#define WAN_IF		T("eth1")
//#define BRIDGE_IF 	T("eth0")


// gateway mode (wlan0+eth0+eth1)
#define WAN_IF		T("eth1")
	#ifdef __i386__		//Erwin 2004.01.30
		#define BRIDGE_IF	T("eth0")
	#else
		#define BRIDGE_IF	T("br0")
	#endif

#else

// bridge mode (wlan0+eth0)
#define BRIDGE_IF	T("br0")
#endif

#define ELAN_IF		T("eth0")

#ifdef _6104WG_
#define WLAN_IF     T("eth2")
#else 
#define WLAN_IF     T("wlan0")
#endif

#define PPPOE_IF	T("ppp0")


#ifdef __i386__
  #define _CONFIG_SCRIPT_PATH	T(".")
  #define _LITTLE_ENDIAN_
#else
  #define _CONFIG_SCRIPT_PATH	T("/bin")
#endif

//#define _UPMIBFILE_SCRIPT_PROG  T("mibfile_run.sh")
#define _CONFIG_SCRIPT_PROG	T("init.sh")
#define _WLAN_SCRIPT_PROG	T("wlan.sh")
#define _PPPOE_SCRIPT_PROG	T("pppoe.sh")
#define _FIREWALL_SCRIPT_PROG	T("firewall.sh")
#define _PPPOE_DC_SCRIPT_PROG	T("disconnect.sh")
#define _IAPPAUTH_SCRIPT_PROG	T("iappauth.sh")
#define _RADIUS_SCRIPT_PROG	T("Radiusd.sh")

#ifdef WLAN_WPA
#define _WPA_SCRIPT_PROG	T("wpa.sh")
#endif

///////////////////////////////////////////////////////////////////////////
static bool _is_hex(char c)
{
    return (((c >= '0') && (c <= '9')) ||
            ((c >= 'A') && (c <= 'F')) ||
            ((c >= 'a') && (c <= 'f')));
}

// Validate digit
static bool _isdigit(char c)
{
    return ((c >= '0') && (c <= '9'));
}

static int __inline__ string_to_hex(char_t *string, unsigned char *key, int len)
{
	char tmpBuf[4];
	int idx, ii=0;
	for (idx=0; idx<len; idx+=2) {
		tmpBuf[0] = string[idx];
		tmpBuf[1] = string[idx+1];
		tmpBuf[2] = 0;
		if ( !_is_hex(tmpBuf[0]) || !_is_hex(tmpBuf[1]))
			return 0;

		key[ii++] = (unsigned char) strtol(tmpBuf, (char**)NULL, 16);
	}
	return 1;
}

static int __inline__ string_to_dec(char_t *string, int *val)
{
	int idx;
	int len = strlen(string);

	for (idx=0; idx<len; idx++) {
		if ( !_isdigit(string[idx]))
			return 0;
	}

	*val = strtol(string, (char**)NULL, 10);
	return 1;
}

#define ERR_MSG(msg) { \
	websHeader(wp); \
   	websWrite(wp, T("<head><link rel=\"stylesheet\" href=\"/set.css\"></head>\n")); \
   	websWrite(wp, T("<body class=\"background\"><blockquote><h4 class=\"textcolor\">%s</h4>\n"), msg); \
	websWrite(wp, T("<form><input type=\"button\" onclick=\"history.go (-1)\" value=\"&nbsp;&nbsp;OK&nbsp;&nbsp\" name=\"OK\"></form></blockquote></body>")); \
   	websFooter(wp); \
	websDone(wp, 200); \
}

///////////////////////////////////////////////////////////////////////////////////////////

/*#define KO_MSG(url) { \
	websHeader(wp); \
	websWrite(wp, T("<body onLoad=parent.main.location.replace(\"%s\")>"), url);\
   	websFooter(wp); \
	websDone(wp, 200); \
}
*/
#define REPLACE_MSG(url) { \
	websHeader(wp); \
	websWrite(wp, T("<body onLoad=document.location.replace(\"%s\")>"), url);\
   	websFooter(wp); \
	websDone(wp, 200); \
}

#define REPLACE1_MSG(url) { \
	websHeader(wp); \
	websWrite(wp, T("<body onLoad=parent.lFrame.location.replace(\"%s\")>"), url);\
   	websFooter(wp); \
	websDone(wp, 200); \
}
///////////////////////////////////////////////////////////////////////////////////////////
#define PROC_MSG() { }
/*#define PROC_MSG() { \
	websHeader(wp); \
	websWrite(wp, "<HEAD></HEAD>"); \
	websWrite(wp, "<BODY style='background-color:#EEEEEE'><br><blockquote>"); \
	websWrite(wp, "<h4 style='position:absolute; top:50px; left:50px;background-color:#EEEEEE'>Your data is being processed now.</h4>"); \
}*/
/*#define PROC_MSG() { \
	websHeader(wp); \
   	websWrite(wp, T("<head><link rel='stylesheet' href='/set.css'></head>\n")); \
   	websWrite(wp, T("<body class='background'><blockquote><br><h4 class='textcolor' style='position:absolute; top:50px; left:50px;'>Your data is being processed now.</h4>")); \
}
*/
/*#define OK_MSG(url) { \
   	websWrite(wp, T("<br><h4 style='position:absolute; top:50px; left:50px;background-color:#EEEEEE '>Change setting successfully!&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</h4>\n")); \
	if (url[0]) websWrite(wp, T("<form><br><br><input type=button value=\"  OK  \" OnClick=window.location.replace(\"%s\") ></form></blockquote></body>"), url);\
	else websWrite(wp, T("<form><br><br><input type=button value=\"  OK  \" OnClick=window.close() ></form></blockquote></body>"));\
   	websFooter(wp); \
	websDone(wp, 200); \
}
*/
/*#define REPLACE1_MSG(url) { \
	websWrite(wp, T("<script>parent.lFrame.location.replace(\"%s\");</script>"), url);\
   	websFooter(wp); \
	websDone(wp, 200); \
}*/
/*#define OK_MSG1(msg, url) { \
   	websWrite(wp, T("<br><h4 style='position:absolute; top:50px; left:50px;background-color:#EEEEEE'>%s&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</h4>\n"), msg); \
	if (url[0]) websWrite(wp, T("<form><br><br><input type=button value=\"  OK  \" OnClick=window.location.replace(\"%s\") ></form></blockquote></body>"), url);\
	else websWrite(wp, T("<form><br><br><input type=button value=\"  OK  \" OnClick=window.close() ></form></blockquote></body>"));\
   	websFooter(wp); \
	websDone(wp, 200); \
}*/
//////////////////////////////////////////////////////////////////////////////////////////////
#define OK_MSG(url) { \
	websHeader(wp); \
   	websWrite(wp, T("<head><link rel=\"stylesheet\" href=\"/set.css\"></head>\n")); \
   	websWrite(wp, T("<body class=\"background\"><blockquote><h4 class=\"textcolor\">Change setting successfully!</h4>\n")); \
	if (url[0]) websWrite(wp, T("<form><input type=button value=\"  OK  \" OnClick=window.location.replace(\"%s\")></form></blockquote></body>"), url);\
	else websWrite(wp, T("<form><input type=button value=\"  OK  \" OnClick=window.close()></form></blockquote></body>"));\
   	websFooter(wp); \
	websDone(wp, 200); \
}

#define OK_MSG1(msg, url) { \
	websHeader(wp); \
   	websWrite(wp, T("<head><link rel='stylesheet' href='/set.css'></head>\n")); \
   	websWrite(wp, T("<body class='background'><blockquote><h4 class='textcolor'>%s</h4>\n"),msg); \
	if (url) websWrite(wp, T("<form><input type=button value=\"  OK  \" OnClick=window.location.replace(\"%s\")></form></blockquote></body>"), url);\
	else websWrite(wp, T("<form><input type=button value=\"  OK  \" OnClick=window.close()></form></blockquote></body>"));\
   	websFooter(wp); \
	websDone(wp, 200); \
}

#define REJECT_MSG() { \
	websHeader(wp); \
   	websWrite(wp, T("<body onLoad='window.close();'></body>\n")); \
   	websFooter(wp); \
	websDone(wp, 200); \
}

//////////////////////////////////////////////////////////////////////////

/* Routines exported in fmmgmt.c */
extern void formPasswordSetup(webs_t wp, char_t *path, char_t *query);
extern void formUpload(webs_t wp, char_t * path, char_t * query);
extern void formSaveConfig(webs_t wp, char_t *path, char_t *query);
extern void formSecLog(webs_t wp, char_t *path, char_t *query);
extern void formSysLog(webs_t wp, char_t *path, char_t *query);
extern void formDebug(webs_t wp, char_t *path, char_t *query);
extern void set_user_profile();
extern void formStats(webs_t wp, char_t *path, char_t *query);
extern void formWdsWep(webs_t wp, char_t *path, char_t *query);
////////////////////////////////////////////////////////////////////////////////////////

#ifdef HOME_GATEWAY
// Lance
extern void formUSBStorage(webs_t wp, char_t *path, char_t *query);
// End-Lance

extern void formSYSSetup(webs_t wp, char_t *path, char_t *query);
extern void formTimeZoneSetup(webs_t wp, char_t *path, char_t *query);
extern void formReManagementSetup(webs_t wp, char_t *path, char_t *query);

extern void formStcIpSetup(webs_t wp, char_t *path, char_t *query);
extern void formDynIpSetup(webs_t wp, char_t *path, char_t *query);
extern void formPPPoESetup(webs_t wp, char_t *path, char_t *query);
extern void formPPTPSetup(webs_t wp, char_t *path, char_t *query);
extern void formL2TPSetup(webs_t wp, char_t *path, char_t *query);
extern void formTELBPSetup(webs_t wp, char_t *path, char_t *query);
extern void formDDNSSetup(webs_t wp, char_t *path, char_t *query);
extern void formDDNSTemp(webs_t wp, char_t *path, char_t *query);

extern void formWlEnable(webs_t wp, char_t *path, char_t *query);

extern void formVirtualSv(webs_t wp, char_t *path, char_t *query);
extern int virtualSvList(int eid, webs_t wp, int argc, char_t **argv);
extern void formUPNPSetup(webs_t wp, char_t *path, char_t *query);
extern void formALGSetup(webs_t wp, char_t *path, char_t *query);

extern void formNatEnable(webs_t wp, char_t *path, char_t *query);
extern void formFwEnable(webs_t wp, char_t *path, char_t *query);
extern int ACPCList(int eid, webs_t wp, int argc, char_t **argv);
extern void formPreventionSetup(webs_t wp, char_t *path, char_t *query);
extern int DMZList(int eid, webs_t wp, int argc, char_t **argv);
extern int StcRoutList(int eid, webs_t wp, int argc, char_t **argv);
extern int URLBList(int eid, webs_t wp, int argc, char_t **argv);
extern void formPSSetup(webs_t wp, char_t *path, char_t *query); // Lance 2004.2.9

#endif
extern void formReboot();
extern void formAccept(webs_t wp, char_t *path, char_t *query);
extern void formLicence(webs_t wp, char_t *path, char_t *query);
//////////////////////////////////////////////////////////////////////////////////////////////
/* Routines exported in fmget.c */
extern int getIndex(int eid, webs_t wp, int argc, char_t **argv);
extern int getInfo(int eid, webs_t wp, int argc, char_t **argv);
extern int isConnectPPP();

/* Routines exported in fmwlan.c */
extern void formWlanSetup(webs_t wp, char_t *path, char_t *query);
extern void formWlanTemp(webs_t wp, char_t *path, char_t *query);
extern int wlAcList(int eid, webs_t wp, int argc, char_t **argv);
extern void formWlAc(webs_t wp, char_t *path, char_t *query);
extern void formAdvanceSetup(webs_t wp, char_t *path, char_t *query);
extern int wirelessClientList(int eid, webs_t wp, int argc, char_t **argv);
extern void formWirelessTbl(webs_t wp, char_t *path, char_t *query);
extern void formWep(webs_t wp, char_t *path, char_t *query);
extern void formWlSiteSurvey(webs_t wp, char_t *path, char_t *query);
int wlSiteSurveyTbl(int eid, webs_t wp, int argc, char_t **argv);
#ifdef WLAN_WPA
extern void formWlEncrypt(webs_t wp, char_t *path, char_t *query);
#endif

#ifndef HOME_GATEWAY	// Radius server
extern void formRadius(webs_t wp, char_t *path, char_t *query);
extern int RadiusCltList(int eid, webs_t wp, int argc, char_t **argv);
extern int RadiusUsrList(int eid, webs_t wp, int argc, char_t **argv);
#endif

/* Routines exported in fmtcpip.c */
extern void formTcpipSetup(webs_t wp, char_t *path, char_t *query);
extern int isDhcpClientExist(char *name);

#ifdef HOME_GATEWAY
extern void formWanTcpipSetup(webs_t wp, char_t *path, char_t *query);
extern void formReflashClientTbl(webs_t wp, char_t *path, char_t *query);
extern int dhcpClientList(int eid, webs_t wp, int argc, char_t **argv);

/* Routines exported in fmfwall.c */
extern void formPortFw(webs_t wp, char_t *path, char_t *query);
//#endif
extern void formFilter(webs_t wp, char_t *path, char_t *query);
//#ifdef HOME_GATEWAY
extern int portFwList(int eid, webs_t wp, int argc, char_t **argv);
extern int portFilterList(int eid, webs_t wp, int argc, char_t **argv);
extern int ipFilterList(int eid, webs_t wp, int argc, char_t **argv);
extern int macFilterList(int eid, webs_t wp, int argc, char_t **argv);
extern void formDMZ(webs_t wp, char_t *path, char_t *query);
extern void formTriggerPort(webs_t wp, char_t *path, char_t *query);
extern int triggerPortList(int eid, webs_t wp, int argc, char_t **argv);
#endif

#endif // _INCLUDE_APFORM_H
