/*
 *      Header file of AP mib
 *      Authors: David Hsu	<davidhsu@realtek.com.tw>
 *
 *      $Id: apmib.h,v 1.14 2004/03/12 01:47:46 erwin Exp $
 *
 */


#ifndef INCLUDE_APMIB_H
#define INCLUDE_APMIB_H

// WLAN MIB id
#define MIB_WLAN_SSID					1
#define MIB_WLAN_CHAN_NUM				2
#define MIB_WLAN_WEP					3
#define MIB_WLAN_WEP64_KEY1				4
#define MIB_WLAN_WEP64_KEY2				5
#define MIB_WLAN_WEP64_KEY3				6
#define MIB_WLAN_WEP64_KEY4				7
#define MIB_WLAN_WEP128_KEY1			8
#define MIB_WLAN_WEP128_KEY2			9
#define MIB_WLAN_WEP128_KEY3			10
#define MIB_WLAN_WEP128_KEY4			11
#define MIB_WLAN_WEP_KEY_TYPE			12
#define MIB_WLAN_WEP_DEFAULT_KEY		13
#define MIB_WLAN_FRAG_THRESHOLD			14
#define MIB_WLAN_SUPPORTED_RATE			15
#define MIB_WLAN_BEACON_INTERVAL		16
#define MIB_WLAN_PREAMBLE_TYPE			17
#define MIB_WLAN_BASIC_RATE				18
#define MIB_WLAN_RTS_THRESHOLD			19
#define MIB_WLAN_AUTH_TYPE				20
#define MIB_WLAN_HIDDEN_SSID			21
#define MIB_WLAN_DISABLED				22
#define MIB_ALIAS_NAME					23
#define MIB_ELAN_MAC_ADDR				24
#define MIB_WLAN_MAC_ADDR				25

#ifdef WLAN_WPA
#define MIB_WLAN_ENCRYPT				26
#define MIB_WLAN_ENABLE_SUPP_NONWPA		27
#define MIB_WLAN_SUPP_NONWPA			28
#define MIB_WLAN_WPA_AUTH				29
#define MIB_WLAN_WPA_CIPHER_SUITE		30
#define MIB_WLAN_WPA_PSK				31
#define MIB_WLAN_WPA_GROUP_REKEY_TIME	32
#define MIB_WLAN_RS_IP					33
#define MIB_WLAN_RS_PORT				34
#define MIB_WLAN_RS_PASSWORD			35
#define MIB_WLAN_ENABLE_1X				36
#define MIB_WLAN_WPA_PSK_FORMAT			37
#endif

#define MIB_WLAN_INACTIVITY_TIME		38
#define MIB_WLAN_RATE_ADAPTIVE_ENABLED	39

// access control MIB id
#define MIB_WLAN_AC_ENABLED				40
#define MIB_WLAN_AC_NUM					41
#define MIB_WLAN_AC_ADDR				42
#define MIB_WLAN_AC_ADDR_ADD			43
#define MIB_WLAN_AC_ADDR_DEL			44
#define MIB_WLAN_AC_ADDR_DELALL			45

// web access control MIB
#define MIB_SUPER_NAME					46
#define MIB_SUPER_PASSWORD				47
#define MIB_USER_NAME					48
#define	MIB_USER_PASSWORD				49

#ifdef HOME_GATEWAY
#define MIB_WAN_MAC_ADDR				50
#endif

#define MIB_DHCP_CLIENT_START			51
#define MIB_DHCP_CLIENT_END				52

#ifdef HOME_GATEWAY
#define MIB_WAN_IP_ADDR					53
#define MIB_WAN_SUBNET_MASK				54
#define MIB_WAN_DEFAULT_GATEWAY			55
#define MIB_WAN_DHCP					56
#define MIB_WAN_DNS_MODE				57
#define MIB_WAN_DNS1					58
#define MIB_WAN_DNS2					59
#define MIB_WAN_DNS3					60
#define MIB_PPP_USER					61
#define MIB_PPP_PASSWORD				62
#define MIB_PPP_IDLE_TIME				63
#define MIB_PPP_CONNECT_TYPE			64

#define MIB_PORTFW_ENABLED				65
#define MIB_PORTFW_NUM					66
#define MIB_PORTFW						67
#define MIB_PORTFW_ADD					68
#define MIB_PORTFW_DEL					69
#define MIB_PORTFW_DELALL				70

#define MIB_IPFILTER_ENABLED			71
#define MIB_IPFILTER_NUM				72
#define MIB_IPFILTER					73
#define MIB_IPFILTER_ADD				74
#define MIB_IPFILTER_DEL				75
#define MIB_IPFILTER_DELALL				76

#define MIB_MACFILTER_ENABLED			77

#endif
#define MIB_MACFILTER_NUM				78
#ifdef HOME_GATEWAY

#define MIB_MACFILTER					79
#define MIB_MACFILTER_ADD				80
#define MIB_MACFILTER_DEL				81
#define MIB_MACFILTER_DELALL			82

#define MIB_PORTFILTER_ENABLED			83
#define MIB_PORTFILTER_NUM				84
#define MIB_PORTFILTER					85
#define MIB_PORTFILTER_ADD				86
#define MIB_PORTFILTER_DEL				87
#define MIB_PORTFILTER_DELALL			88

#define MIB_TRIGGERPORT_ENABLED			89
#define MIB_TRIGGERPORT_NUM				90
#define MIB_TRIGGERPORT					91
#define MIB_TRIGGERPORT_ADD				92
#define MIB_TRIGGERPORT_DEL				93
#define MIB_TRIGGERPORT_DELALL			94

#define MIB_DMZ_ENABLED					95
#define MIB_DMZ_HOST					96
#endif

// IP MIB id
#define MIB_IP_ADDR						100
#define MIB_SUBNET_MASK					101
#define MIB_DEFAULT_GATEWAY				102
#define MIB_DHCP						103
#define MIB_STP_ENABLED					104

#define MIB_WLAN_DTIM_PERIOD			105
#define MIB_WLAN_MODE					106
#define MIB_WLAN_NETWORK_TYPE			107	
//----------------------------------------------------------------------------------
#define	MIB_DHCPGATEWAYIP_ADDR			108
#define MIB_DHCPNAMESERVER_ADDR			109
#define MIB_DOMAIN_NAME					110
#define MIB_LAN_LEASETIME				111

// Lance 2003.11.14
#define MIB_WLAN_WDS_NUM                132
#define MIB_WLAN_WDS                    133
#define MIB_WLAN_WDS_ADD                134
#define MIB_WLAN_WDS_DEL                135
#define MIB_WLAN_WDS_DELALL             136

//

//-----------------------------------------------------------------------------------

// Hardware setting MIB
#define MIB_HW_BOARD_VER				200
#define MIB_HW_NIC0_ADDR				201
#define MIB_HW_NIC1_ADDR				202
#define MIB_HW_WLAN_ADDR				203
#define MIB_HW_REG_DOMAIN				204
#define MIB_HW_RF_TYPE					205
#define MIB_HW_TX_POWER					206
#define MIB_HW_ANT_DIVERSITY			207
#define MIB_HW_TX_ANT					208
#define MIB_HW_CS_THRESHOLD				209
#define MIB_HW_CCA_MODE					210
#define MIB_HW_PHY_TYPE					211

#define MIB_HW_LED_TYPE					212

//-------------------------------------Time Zone--------------------------------------------------
#define MIB_TIME_ZONE_SEL				213
#define MIB_START_MONTH					214
#define MIB_START_DAY					215
#define MIB_END_MONTH					216
#define MIB_END_DAY						217
#define MIB_TIMESERVER_ADDR				218
#define MIB_DAYLIGHT_ENABLE				219
//---------------------------------Remote Management Host Address------------------------------
#define MIB_REMANHOST_ADDR				220
#define MIB_REMANG_ENABLE				221
#define MIB_DYNIP_HOSTNAME				222

#define MIB_PPTPIP_ADDR					225
#define MIB_PPTPIPMAKE_ADDR				226
#define MIB_PPTPDFGATEWAY				227
#define MIB_PPTPGATEWAY					228
#define MIB_PPTP_USER					229
#define MIB_PPTP_PASSWORD				230
#define MIB_PPTP_IDLE_TIME				231

#define MIB_PPP_SERVNAME				232
#define MIB_PPP_MTU						233
#define MIB_PAUTORECONNECT				234

#define MIB_NAT_ENABLE					235
#define MIB_FIREWALL_ENABLE				236

#define MIB_UPNP_ENABLE					237

#define MIB_VSER_ENABLED				238
#define MIB_VSER_NUM					239
#define MIB_VSER						240
#define MIB_VSER_DEL					241
#define MIB_VSER_DELALL					242
#define MIB_VSER_ADD					243

#define MIB_WAN_MODE					244

#define MIB_DMZ_NUM						245
#define MIB_DMZ							246
#define MIB_DMZ_ADD						247
#define MIB_DMZ_DEL						248
#define MIB_DMZ_DELALL					249

#define MIB_POD_ENABLED					250
#define MIB_PING_ENABLED				251
//#define MIB_RIP_ENABLED					252

#define MIB_URLB_ENABLED				253
#define MIB_URLB_NUM					254
#define MIB_URLB						255
#define MIB_URLB_ADD					256
#define MIB_URLB_DEL					257
#define MIB_URLB_DELALL					258

#define MIB_ACPC_ENABLED				259
#define MIB_ACPC_NUM					260
#define MIB_ACPC						261
#define MIB_ACPC_ADD					262
#define MIB_ACPC_DEL					263
#define MIB_ACPC_DELALL					264

#define MIB_TELBPIP_ADDR				265
#define MIB_TELBP_USER					266
#define MIB_TELBP_PASSWORD				267
#define MIB_TELBP_ENABLED				268
#define MIB_TELBP_STATE					269
#define MIB_SYS_MODE					270
#define MIB_PPTP_IPMODE					271

#define MIB_DDNS_NAME					272
#define MIB_DDNS_ACCOUNT				273
#define MIB_DDNS_PASS					274
#define MIB_DDNS_ENABLE					275
#define MIB_DDNS_PVIDSEL				276
#define MIB_REMAN_PORT					277
#define MIB_PPTP_CONNECT_TYPE			278

#define MIB_L2TP_IPMODE					279
#define MIB_L2TP_IP_ADDR				280
#define MIB_L2TP_MAKEADDR				281
#define MIB_L2TP_DEFGATEWAY				282
#define MIB_L2TP_GATEWAY				283
#define MIB_L2TP_USER					284
#define MIB_L2TP_PASSWORD				285
#define MIB_L2TP_IDLE_TIME				286
#define MIB_L2TP_CONNECT_TYPE			287

#define MIB_PPTP_CONNT_ID				289
#define MIB_PPTP_BEZEQ_ENABLE			290

#define MIB_APP_LAYER_GATEWAY			291

#define MIB_SCAN_ENABLED				292
#define MIB_SYN_ENABLED					293

#define MIB_DHIS_HOSTID					294
#define MIB_DHIS_ISADDR					295
#define MIB_DHIS_PASSWORD				296
#define MIB_DHIS_AUTH_P1				297
#define MIB_DHIS_AUTH_P2				298
#define MIB_DHIS_AUTH_Q1				299
#define MIB_DHIS_AUTH_Q2				300
#define MIB_DHIS_SELECT					301

#define MIB_DDNS_TEMPSEL				302
#define MIB_DHIS_TEMPSEL				303

#define MIB_WLAN_ENABLE_MAC_AUTH		304
#define MIB_WLAN_RS_RETRY				305
#define MIB_WLAN_RS_INTERVAL_TIME		306
#define MIB_WLAN_ACCOUNT_RS_ENABLED		307
#define MIB_WLAN_ACCOUNT_RS_IP			308
#define MIB_WLAN_ACCOUNT_RS_PORT		309
#define MIB_WLAN_ACCOUNT_RS_PASSWORD	310
#define MIB_WLAN_ACCOUNT_UPDATE_ENABLED	311
#define MIB_WLAN_ACCOUNT_UPDATE_DELAY	312
#define MIB_WLAN_ACCOUNT_RS_RETRY		313
#define MIB_WLAN_ACCOUNT_RS_INTERVAL_TIME 314
#define MIB_WLAN_IAPP_DISABLED			315
#define MIB_AP_MODE						316
#define MIB_WL_LINKMAC1					317
#define MIB_WL_LINKMAC2					318
#define MIB_WL_LINKMAC3					319
#define MIB_WL_LINKMAC4					320
#define MIB_WL_LINKMAC5					321
#define MIB_WL_LINKMAC6					322

#define MIB_SECURITY_MODE				323
#define MIB_CLIENT_IP_DISABLED			324
#define MIB_AP_MODE_TEMP				325

#define MIB_SROUT_ENABLED				326
#define MIB_SROUT_NUM					327
#define MIB_SROUT						328
#define MIB_SROUT_ADD					329
#define MIB_SROUT_DEL					330
#define MIB_SROUT_DELALL				331

#ifndef HOME_GATEWAY	// Radius server
#define MIB_RSER_ENABLED				332
#define MIB_RSER_CLT_NUM				333
#define MIB_RSER_CLT					334
#define MIB_RSER_CLT_ADD				335
#define MIB_RSER_CLT_DEL				336
#define MIB_RSER_CLT_DELALL				337

#define MIB_RSER_USR_NUM				328
#define MIB_RSER_USR					329
#define MIB_RSER_USR_ADD				340
#define MIB_RSER_USR_DEL				341
#define MIB_RSER_USR_DELALL				342
#endif
#define MIB_1X_MODE						252	//Special number

#define MIB_POD_PACK					343
#define MIB_POD_TIME					344
#define MIB_POD_BUR						345
#define MIB_SYN_PACK					346
#define MIB_SYN_TIME					347
#define MIB_SYN_BUR						348
#define MIB_SCAN_NUM					349

#define MIB_PPTP_MTU					350
#define MIB_L2TP_MTU					351

#define MIB_WLAN_SET_TX					352

#define MIB_WLAN_WDS_WEP				353
#define MIB_WLAN_WDS_WEP64_KEY1			354
#define MIB_WLAN_WDS_WEP64_KEY2			355
#define MIB_WLAN_WDS_WEP64_KEY3			356
#define MIB_WLAN_WDS_WEP64_KEY4			357
#define MIB_WLAN_WDS_WEP128_KEY1		358
#define MIB_WLAN_WDS_WEP128_KEY2		359
#define MIB_WLAN_WDS_WEP128_KEY3		360
#define MIB_WLAN_WDS_WEP128_KEY4		361
#define MIB_WLAN_WDS_WEP_KEY_TYPE		362
#define MIB_WLAN_WDS_WEP_DEFAULT_KEY	363

#define MIB_WLAN_TRAN_RATE				364
#define MIB_WLAN_RATE_MODE				365
#define MIB_WLAN_CTS					366
#define MIB_WLAN_BURST					367
#define MIB_WLAN_WEP152_KEY1			368
#define MIB_WLAN_WEP152_KEY2			369
#define MIB_WLAN_WEP152_KEY3			370
#define MIB_WLAN_WEP152_KEY4			371

#define MIB_DMZ_EDIT					372

#define MIB_PS_ENABLE					373	// Lance 2004.2.9
#define MIB_PS_NAME						374	// Lance 2004.2.10
#define MIB_PS_IPPENABLE				375 // Lance 2004.2.16
#define MIB_PS_LPRENABLE				376 // Lance 2004.2.16
#define MIB_PS_PORT1NAME				377 // Lance 2004.2.16
#define MIB_PS_PORT2NAME				378 // Lance 2004.2.16

#define MIB_LICENCE						379
#define MIB_MACFILTER_PERMIT_ENABLED	380
//---------------------------------------------------------------------------------------------

// MIB value and constant
#define MAX_SSID_LEN					33
#define WEP64_KEY_LEN					5
#define WEP128_KEY_LEN					13
#define WEP152_KEY_LEN					16
#define MAX_NAME_LEN					31
#define COMMENT_LEN						17
#define MAX_CHAN_NUM					14

#ifdef WLAN_WPA
#define MAX_PSK_LEN						64
#define MAX_RS_PASS_LEN					32
#endif

#define TX_RATE_1M			0x01
#define TX_RATE_2M			0x02
#define TX_RATE_5M			0x04
#define TX_RATE_11M			0x08

#define MAX_WLAN_AC_NUM			20

//#ifdef HOME_GATEWAY
#define MAX_FILTER_NUM			20
//#endif

#define MAXFNAME			60

#ifdef __mips__
#define FLASH_DEVICE_NAME				("/dev/mtd")

#ifdef _ADM5120_
#define HW_SETTING_OFFSET				0x8000				// size 0x400
#define DEFAULT_SETTING_OFFSET			0x8400				// offset of config.bin
#define DEFAULT_SETTING_FILE			("/etc/config.bin")
#define CURRENT_SETTING_OFFSET			0xA000
#define CODE_IMAGE_OFFSET				0x30000
#define WEB_PAGE_OFFSET					0x10000

#else
#define HW_SETTING_OFFSET				0x6000				// size 0x400
#define DEFAULT_SETTING_OFFSET			0x6400				// offset of config.bin
#define DEFAULT_SETTING_FILE			("/etc/config.bin")
#define CURRENT_SETTING_OFFSET			0x8000
#define CODE_IMAGE_OFFSET				0x30000
#define WEB_PAGE_OFFSET					0x10000
#endif

#define HW_SETTING_OFFSET_IN_FILE		0
#define DF_SETTING_OFFSET_IN_FILE		HW_SETTING_LEN

#else

#define FLASH_DEVICE_NAME				"setting.bin"
#define HW_SETTING_OFFSET				0
#define DEFAULT_SETTING_OFFSET			HW_SETTING_LEN
#ifdef HOME_GATEWAY
#define DEFAULT_SETTING_FILE			"config-gw-pc.bin"
#else
#define DEFAULT_SETTING_FILE			"config-ap-pc.bin"
#endif
#define CURRENT_SETTING_OFFSET			(HW_SETTING_LEN + DF_SETTING_LEN)
#define CODE_IMAGE_OFFSET				0
#define WEB_PAGE_OFFSET					0

#define HW_SETTING_OFFSET_IN_FILE		0
#define DF_SETTING_OFFSET_IN_FILE		HW_SETTING_LEN

#endif

#define HW_SETTING_LEN					(0x400)
#define DF_SETTING_LEN					(0x1c00)

#ifndef WIN32
#define __PACK__			__attribute__ ((packed))
#else
#define __PACK__
#endif


/* Config/fw image file header */

typedef enum { HW_SETTING=1, DEFAULT_SETTING=2, CURRENT_SETTING=4 } CONFIG_DATA_T;
// update tag
#define HW_SETTING_HEADER_TAG		((char *)"HS")
#define DEFAULT_SETTING_HEADER_TAG	((char *)"DS")
#define CURRENT_SETTING_HEADER_TAG	((char *)"CS")
// force tag
#define HW_SETTING_HEADER_FORCE_TAG	((char *)"HF")
#define DEFAULT_SETTING_HEADER_FORCE_TAG ((char *)"DF")
#define CURRENT_SETTING_HEADER_FORCE_TAG ((char *)"CF")
// upgrade
#define HW_SETTING_HEADER_UPGRADE_TAG	((char *)"HU")
#define DEFAULT_SETTING_HEADER_UPGRADE_TAG ((char *)"DU")
#define CURRENT_SETTING_HEADER_UPGRADE_TAG ((char *)"CU")

#define TAG_LEN					2
#define HW_SETTING_VER			1	// hw setting version
#define DEFAULT_SETTING_VER		8	// default setting version  Erwin Modify // Lance 2003.11.05
#define CURRENT_SETTING_VER		DEFAULT_SETTING_VER // current setting version

#define FW_HEADER				((char *)"CSYS")

// Lance 2003.08.06
#ifdef _7206APB_
	#define WEB_HEADER				((char *)"WEBP")	// 7206APB

#elif defined(_6104WG_)
	#define WEB_HEADER				((char *)"WBGW")

#elif defined(_6104IPC_)
	#define WEB_HEADER				((char *)"WBIP")

#elif defined(_6104K_)
	#define WEB_HEADER				((char *)"WB4K")

#elif defined(_6104WB_)
	#define WEB_HEADER				((char *)"WBWB")

#elif defined(_7206APG_)
	#define WEB_HEADER				((char *)"WBGW")

#elif defined(_7207APB_)
	#define WEB_HEADER				((char *)"WB7P")	// 7207APB

#elif defined(_7206GA_)
    #define WEB_HEADER              ((char *)"WBGA")    // 7206GA

#elif defined(_6104WBB_)
    #define WEB_HEADER              ((char *)"WBWB")    // 6104WBB

#elif defined(_6104KPS_)
    #define WEB_HEADER              ((char *)"WBPS")    // 6104KPS

#elif defined(_6104KP_)
    #define WEB_HEADER              ((char *)"WBKP")    // 6104KP

#elif defined(_6104HS_)
    #define WEB_HEADER              ((char *)"WBHS")    // 6104HS

#elif defined(_7207APS_)
    #define WEB_HEADER              ((char *)"EWAS")    // 7207APS
#endif

// End Lance 2003.08.06
#define SIGNATURE_LEN			4

/* wlan driver ioctl id */
#define SIOCGIWRTLSTAINFO   		0x8B30	// get station table information
#define SIOCGIWRTLSTANUM		0x8B31	// get the number of stations in table
#define SIOCGIWRTLSCANREQ		0x8B33	// scan request
#define SIOCGIWRTLGETBSSDB		0x8B34	// get bss data base
#define SIOCGIWRTLJOINREQ		0x8B35	// join request
#define SIOCGIWRTLJOINREQSTATUS		0x8B36	// get status of join request
#define SIOCGIWRTLGETBSSINFO		0x8B37	// get currnet bss info

#define MAX_STA_NUM			64	// max support sta number

/* flag of sta info */
#define STA_INFO_FLAG_AUTH_OPEN     	0x01
#define STA_INFO_FLAG_AUTH_WEP      	0x02
#define STA_INFO_FLAG_ASOC          	0x04
#define STA_INFO_FLAG_ASLEEP        	0x08


#ifdef WLAN_WPA
typedef enum { ENCRYPT_DISABLED=0, ENCRYPT_WEP=1, ENCRYPT_1X=2, ENCRYPT_WSK=3, ENCRYPT_PSK=4, ENCRYPT_ARS=5 } ENCRYPT_T;// Erwin Modify 01.09
typedef enum { SUPP_NONWPA_NONE=0,SUPP_NONWPA_WEP=1,SUPP_NONWPA_1X=2} SUPP_NONWAP_T;
typedef enum { WPA_AUTH_AUTO=1, WPA_AUTH_PSK=2 } WPA_AUTH_T;
typedef enum { WPA_CIPHER_TKIP=1, WPA_CIPHER_AES=2 } WPA_CIPHER_T;
#endif

typedef enum { WEP_DISABLED=0, WEP64=1, WEP128=2, WEP152=3 } WEP_T;
typedef enum { KEY_ASCII=0, KEY_HEX } KEY_TYPE_T;
typedef enum { LONG_PREAMBLE=0, SHORT_PREAMBLE=1 } PREAMBLE_T;
typedef enum { DHCP_DISABLED=0, DHCP_CLIENT=1, DHCP_SERVER=2, PPPOE=3} DHCP_T;
typedef enum { FCC=1, IC, ETSI, SPAIN, FRANCE, MKK } REG_DOMAIN_T;
typedef enum { AUTH_OPEN=0, AUTH_SHARED, AUTH_BOTH } AUTH_TYPE_T;
typedef enum { DNS_AUTO=0, DNS_MANUAL } DNS_TYPE_T;
typedef enum { CONTINUOUS=0, CONNECT_ON_DEMAND, MANUAL } PPP_CONNECT_TYPE_T;
typedef enum { RF_INTERSIL=1, RF_RFMD=2, RF_PHILIP=3, RF_MAXIM=4 } RF_TYPE_T;
typedef enum { LED_TX_RX=0, LED_LINK_TXRX=1, LED_LINKTXRX=2 } LED_TYPE_T;
typedef enum { AP_MODE=0, CLIENT_MODE=1, WDS_MODE=2 } WLAN_MODE_T;
typedef enum { INFRASTRUCTURE=0, ADHOC=1 } NETWORK_TYPE_T;


#ifdef HOME_GATEWAY
typedef enum { PROTO_BOTH=3, PROTO_TCP=1, PROTO_UDP=2 } PROTO_TYPE_T;
#endif

#ifndef _LITTLE_ENDIAN_
#define DWORD_SWAP(v) ( (((v&0xff)<<24)&0xff000000) | ((((v>>8)&0xff)<<16)&0xff0000) | \
				                ((((v>>16)&0xff)<<8)&0xff00) | (((v>>24)&0xff)&0xff) )
#define WORD_SWAP(v) ((unsigned short)(((v>>8)&0xff) | ((v<<8)&0xff00)))
#else
#define DWORD_SWAP(v) (v)
#define WORD_SWAP(v) (v)
#endif

/* scramble saved configuration data */
#define ENCODE_DATA(data,len) { \
	int i; \
	for (i=0; i<len; i++) \
		data[i] = ~ ( data[i] + 0x38); \
}

#define DECODE_DATA(data,len) { \
	int i; \
	for (i=0; i<len; i++) \
		data[i] = ~data[i] - 0x38;	\
}

/* Do checksum and verification for configuration data */
#ifndef WIN32
static inline unsigned char CHECKSUM(unsigned char *data, int len)
#else
__inline unsigned char CHECKSUM(unsigned char *data, int len)
#endif
{
	int i;
	unsigned char sum=0;

	for (i=0; i<len; i++)
		sum += data[i];

	sum = ~sum + 1;
	return sum;
}
#ifndef WIN32
static inline int CHECKSUM_OK(unsigned char *data, int len)
#else
__inline int CHECKSUM_OK(unsigned char *data, int len)
#endif
{
	int i;
	unsigned char sum=0;

	for (i=0; i<len; i++)
		sum += data[i];

	if (sum == 0)
		return 1;
	else
		return 0;
}


/* WLAN sta info structure */
typedef struct wlan_sta_info {
        unsigned short  aid;
        unsigned char   addr[6];
        unsigned long   tx_packets;
        unsigned long   rx_packets;
	unsigned long	expired_time;  // 10 mini-sec
	unsigned short  flag;
        unsigned char   txOperaRates;
} WLAN_STA_INFO_T, *WLAN_STA_INFO_Tp;

typedef struct wlan_ipn_sta {
		short           aid;         // STA's unique AID (1 .. 2007) or 0 if not yet assigned 
		unsigned char   addr[6];      // address of associated station 
		unsigned char   auth_state;  // station status 
		unsigned char   ps_state;    // station power save status 
		unsigned long assoc_time;
} WLAN_IPN_STA_T, *WLAN_IPN_STA_Tp;


#ifdef WIN32
#pragma pack(1)
#endif

typedef struct macfilter_entry {
	unsigned char macAddr[6] __PACK__;
	unsigned char comment[COMMENT_LEN] __PACK__;
} MACFILTER_T, *MACFILTER_Tp;

typedef struct URLB_entry {
	unsigned char URLBAddr[34] __PACK__;
} URLB_T, *URLB_Tp;

typedef struct edit_entry {
	char *selEntry;
	char *editEntry;
} EDIT_T, *EDIT_Tp;
#ifdef HOME_GATEWAY
///////////////////////////////////////////////////////////////////////////////////////
typedef struct portfw_entry {
	unsigned char ipAddr[4] __PACK__;
	unsigned short fromPort __PACK__;
	unsigned short toPort __PACK__;
	unsigned char protoType __PACK__;
	unsigned char comment[COMMENT_LEN] __PACK__;
} PORTFW_T, *PORTFW_Tp;

typedef struct ipfilter_entry {	//no use
	unsigned char ipAddr[4] __PACK__;
	unsigned char protoType __PACK__;
	unsigned char comment[COMMENT_LEN] __PACK__;
} IPFILTER_T, *IPFILTER_Tp;

typedef struct portfilter_entry {	//no use
	unsigned short fromPort __PACK__;
	unsigned short toPort __PACK__;
	unsigned char protoType __PACK__;
	unsigned char comment[COMMENT_LEN] __PACK__;
} PORTFILTER_T, *PORTFILTER_Tp;

typedef struct triggerport_entry {
	unsigned short tri_fromPort __PACK__;	// trigger-from port
	unsigned short tri_toPort __PACK__;	// trigger-to port
	unsigned char tri_protoType __PACK__;	// trigger proto type
	unsigned short  inc_fromPort[5][2] __PACK__;	// incomming-from port
	unsigned short inc_toPort __PACK__;	// incoming-to port
	unsigned char inc_protoType __PACK__;	// incoming proto type
	unsigned char comment[COMMENT_LEN] __PACK__;	// comment
} TRIGGERPORT_T, *TRIGGERPORT_Tp;

typedef struct ACPC_entry {
	unsigned long serindex __PACK__;
	unsigned char sipAddr[4] __PACK__;
	unsigned char eipAddr[4] __PACK__;
	unsigned char protoType __PACK__;
	unsigned char comment[COMMENT_LEN] __PACK__;
	unsigned short  Port[5][2] __PACK__;	
} ACPC_T, *ACPC_Tp;

typedef struct dmz_entry {
	unsigned char type __PACK__;
	unsigned char session __PACK__;
	unsigned char pipAddr[4] __PACK__;
	unsigned char cipAddr[4] __PACK__;
} DMZ_T, *DMZ_Tp;


typedef struct srout_entry {
	unsigned char ipAddr[4] __PACK__;	// ststic routing destination lan ip
	unsigned char maskAddr[4] __PACK__;	// static routing subnet mask
	unsigned char gatewayAddr[4] __PACK__;	// static routing default gateway
	unsigned short hopCount __PACK__;	// static routing hop count
	unsigned char interface __PACK__;	// static routing interface
} SROUT_T, *SROUT_Tp;
#endif

#ifndef HOME_GATEWAY
typedef struct rserclt_entry {
	unsigned char ipAddr[4] __PACK__;
	unsigned char password[17] __PACK__;
} RSER_CLT_T, *RSER_CLT_Tp;

typedef struct rserusr_entry {
	unsigned char username[33] __PACK__;
	unsigned char password[17] __PACK__;
} RSER_USR_T, *RSER_USR_Tp;
#endif

#ifdef WLAN_WDS
typedef MACFILTER_T WDS_T;
typedef MACFILTER_Tp WDS_Tp;
#endif

typedef struct hw_setting {
	unsigned char boardVer __PACK__;	// h/w board version
	unsigned char nic0Addr[6] __PACK__;
	unsigned char nic1Addr[6] __PACK__;
	unsigned char wlanAddr[6] __PACK__;
	unsigned char txPower[MAX_CHAN_NUM] __PACK__; // Tx power for each channel
	unsigned char regDomain __PACK__; // regulation domain
	unsigned char rfType __PACK__; // RF module type
	unsigned char antDiversity __PACK__; // rx antenna diversity on/off
	unsigned char txAnt __PACK__; // select tx antenna
	unsigned char csThreshold __PACK__;
	unsigned char ccaMode __PACK__;	// 0, 1, 2
	unsigned char phyType __PACK__; // for Philip RF module only (0 - analog, 1 - digital)
	unsigned char ledType __PACK__; // LED type, see LED_TYPE_T for definition
	unsigned char Reserved[976] __PACK__;
} HW_SETTING_T, *HW_SETTING_Tp;


typedef struct config_setting {
//**************************************** WLAN stuffs ****************************************
	unsigned char ssid[MAX_SSID_LEN]__PACK__ ; // SSID
	unsigned char channel __PACK__ ;// current channel
	unsigned char elanMacAddr[6] __PACK__ ; // Ethernet Lan MAC address
	unsigned char wlanMacAddr[6] __PACK__ ; // WLAN MAC address
	unsigned char wep __PACK__ ; // WEP flag, 0 - disabled, 1 - 64bits, 2 128 bits
	unsigned char wep64Key1[WEP64_KEY_LEN] __PACK__ ;
	unsigned char wep64Key2[WEP64_KEY_LEN] __PACK__ ;
	unsigned char wep64Key3[WEP64_KEY_LEN] __PACK__ ;
	unsigned char wep64Key4[WEP64_KEY_LEN] __PACK__ ;
	unsigned char wep128Key1[WEP128_KEY_LEN] __PACK__ ;
	unsigned char wep128Key2[WEP128_KEY_LEN] __PACK__ ;
	unsigned char wep128Key3[WEP128_KEY_LEN] __PACK__ ;
	unsigned char wep128Key4[WEP128_KEY_LEN] __PACK__ ;
	unsigned char wepDefaultKey __PACK__ ;
	unsigned char wepKeyType __PACK__ ;
	unsigned short fragThreshold __PACK__ ;
	unsigned short rtsThreshold __PACK__ ;
	unsigned short supportedRates __PACK__ ;
	unsigned short basicRates __PACK__ ;
	unsigned short beaconInterval __PACK__ ;
	unsigned char preambleType __PACK__; // preamble type, 0 - long preamble, 1 - short preamble
	unsigned char authType __PACK__; //authentication type, 0- open-system,1 - shared-key, 2 - both
	unsigned char acEnabled __PACK__; // enable/disable WLAN access control
	unsigned char acNum __PACK__; // WLAN access control entry number
	MACFILTER_T acAddrArray[MAX_WLAN_AC_NUM] __PACK__; // WLAN access control array

	unsigned char hiddenSSID __PACK__ ;
	unsigned char wlanDisabled __PACK__; // enabled/disabled wlan interface
	unsigned char aliasName[MAX_NAME_LEN] __PACK__; // device logical name
	unsigned long inactivityTime __PACK__; // wlan client inactivity time
	unsigned char rateAdaptiveEnabled __PACK__; // enable/disable rate adaptive

//**************************************** LAN stuffs ****************************************
	unsigned char ipAddr[4] __PACK__;
	unsigned char subnetMask[4] __PACK__;
	unsigned char defaultGateway[4] __PACK__;
	unsigned char dhcp __PACK__; // DHCP flag, 0 - disabled, 1 - client, 2 - server
	unsigned char stpEnabled __PACK__; // Spanning tree protocol flag, 0 - disabled, 1 - enabled

	// Supervisor of web server account
	unsigned char superName[MAX_NAME_LEN] __PACK__ ; // supervisor name
	unsigned char superPassword[MAX_NAME_LEN] __PACK__; // supervisor assword

	// web server account
	unsigned char userName[MAX_NAME_LEN] __PACK__; // supervisor name
	unsigned char userPassword[MAX_NAME_LEN] __PACK__; // supervisor assword

	unsigned char DhcpGatewayIPAddr[4] __PACK__;
	unsigned char DhcpNameServerIPAddr[4] __PACK__;
	unsigned char DomainNames[MAX_NAME_LEN] __PACK__; // Dhcp domain name
	unsigned char dhcpClientStart[4] __PACK__; // DHCP client start address
	unsigned char dhcpClientEnd[4] __PACK__; // DHCP client end address
	unsigned long  leaseTime __PACK__;
	
	unsigned char dtimPeriod __PACK__; // DTIM period
	unsigned char wlanMode __PACK__; // wireless mode - AP, Ethernet bridge, WDS
	unsigned char networkType __PACK__; // adhoc or Infrastructure
#ifdef WLAN_WPA
	unsigned char encrypt __PACK__; // encrypt type, defined as ENCRYPT_t
	unsigned char enableSuppNonWpa __PACK__; // enable/disable nonWPA client support
	unsigned char suppNonWpa __PACK__; // which kind of non-wpa client is supported (wep/1x)
	unsigned char wpaAuth __PACK__; // WPA authentication type (auto or psk)
	unsigned char wpaCipher __PACK__; // WPA unicast cipher suite
	unsigned char wpaPSK[MAX_PSK_LEN+1] __PACK__; // WPA pre-shared key
	unsigned long wpaGroupRekeyTime __PACK__; // group key rekey time in second
	unsigned char rsIpAddr[4] __PACK__; // radius server IP address
	unsigned short rsPort __PACK__; // radius server port number
	unsigned char rsPassword[MAX_RS_PASS_LEN] __PACK__; // radius server password
	unsigned char enable1X __PACK__; // enable/disable 802.1x
	unsigned char wpaPSKFormat __PACK__; // PSK format 0 - passphrase, 1 - hex
	unsigned char accountRsEnabled __PACK__; // enable/disable accounting server
	unsigned char accountRsIpAddr[4] __PACK__; // accounting radius server IP address
	unsigned short accountRsPort __PACK__; // accounting radius server port number
	unsigned char accountRsPassword[MAX_RS_PASS_LEN] __PACK__; // accounting radius server password
	unsigned char accountRsUpdateEnabled __PACK__; // enable/disable accounting server update
	unsigned short accountRsUpdateDelay __PACK__; // account server update delay time in sec
	unsigned char macAuthEnabled __PACK__; // mac authentication enabled/disabled
	unsigned char rsMaxRetry __PACK__; // radius server max try
	unsigned short rsIntervalTime __PACK__; // radius server timeout
	unsigned char accountRsMaxRetry __PACK__; // accounting radius server max try
	unsigned short accountRsIntervalTime __PACK__; // accounting radius server timeout
#endif
	
#ifdef HOME_GATEWAY	
//**************************************** System stuffs ****************************************
	unsigned short sysMode __PACK__;
	unsigned short TimeZoneSel __PACK__;	
	unsigned short startMonth __PACK__;
	unsigned short startDay __PACK__;
	unsigned short endMonth __PACK__;
	unsigned short endDay __PACK__;
	unsigned char  TimeServerAddr[4] __PACK__;//TimeServerAddr Address Setting
	unsigned char  DayLightEnable __PACK__ ;//DayLightEnable Setting
	
	unsigned char  reManHostAddr[4] __PACK__;//Remote Management Host Address Setting
	unsigned short reManPort __PACK__;
	unsigned char  reMangEnable __PACK__ ;

//**************************************** WAN stuffs ****************************************
	unsigned char  wanMode __PACK__ ;
	unsigned char wanDhcp __PACK__; // DHCP flag for WAN port, 0 - disabled, 1 - DHCP client
	unsigned char wanIpAddr[4] __PACK__;
	unsigned char wanSubnetMask[4] __PACK__;
	unsigned char wanDefaultGateway[4] __PACK__;
	DNS_TYPE_T dnsMode __PACK__;
	unsigned char dns1[4], dns2[4], dns3[4] __PACK__;

	unsigned char wanMacAddr[6] __PACK__ ; // MAC address of WAN port in used
	unsigned char  dynIPHostName[MAX_NAME_LEN] __PACK__; // Dynamic IP Host Name
	
	unsigned char pppUserName[65] __PACK__;
	unsigned char pppPassword[65] __PACK__;
	unsigned short pppIdleTime __PACK__;
	unsigned char pppConnectType __PACK__;
	unsigned char  pppServName[MAX_NAME_LEN] __PACK__;
	unsigned short pppMTU __PACK__ ;
	unsigned char  pAutoReconnect __PACK__ ;//DayLightEnable Setting //no use
	
	unsigned char  pptpIpMode __PACK__; 
	unsigned char  pptpIPAddr[4] __PACK__;
	unsigned char  pptpIPMaskAddr[4] __PACK__;
	unsigned char  pptpDfGateway[4] __PACK__;	//Disabled
	unsigned char  pptpGateway[4] __PACK__;
	unsigned char  pptpUserName[65] __PACK__;
	unsigned char  pptpPassword[65] __PACK__;
	unsigned short pptpIdleTime __PACK__;
	unsigned char  pptpConnectType __PACK__;
	unsigned char  pptpConntID[MAX_NAME_LEN] __PACK__;
	unsigned char  pptpBEZEQEnable __PACK__;
	unsigned short pptpMTU __PACK__ ;
	
	unsigned char  L2TPIpMode __PACK__; 
	unsigned char  L2TPIPAddr[4] __PACK__;
	unsigned char  L2TPMaskAddr[4] __PACK__;
	unsigned char  L2TPDefGateway[4] __PACK__;	//Disabled
	unsigned char  L2TPGateway[MAX_NAME_LEN] __PACK__;
	unsigned char  L2TPUserName[65] __PACK__;
	unsigned char  L2TPPassword[65] __PACK__;
	unsigned short L2TPIdleTime __PACK__;
	unsigned char  L2TPConnectType __PACK__;
	unsigned short L2TPMTU __PACK__ ;

	unsigned char  telBPIPAddr[4] __PACK__;
	unsigned char  telBPUserName[65] __PACK__;
	unsigned char  telBPPassword[65] __PACK__;
	unsigned char  telBPEnabled __PACK__ ;
	unsigned char  telBPState __PACK__ ;	//no use
	
	unsigned char  ddnsName[MAX_NAME_LEN] __PACK__;
	unsigned char  ddnsAccount[MAX_NAME_LEN] __PACK__;
	unsigned char  ddnsPass[MAX_NAME_LEN] __PACK__;
	unsigned char  ddnsEnable __PACK__ ;
	unsigned char  ddnspvidSel[10] __PACK__ ;

	unsigned long  dhisHostID __PACK__;
	unsigned char  dhisISAddr[MAX_NAME_LEN] __PACK__;
	unsigned char  dhispass[MAX_NAME_LEN] __PACK__;
	unsigned char  dhisAuthP1[51] __PACK__;
	unsigned char  dhisAuthP2[51] __PACK__;
	unsigned char  dhisAuthQ1[51] __PACK__;
	unsigned char  dhisAuthQ2[51] __PACK__;
	unsigned char  dhisSelect __PACK__ ;
	
	unsigned char  ddnsTempSel[10] __PACK__ ;
	unsigned char  dhisTempSel __PACK__ ;
//**************************************** NAT stuffs ****************************************
	unsigned char portFwEnabled __PACK__;
	unsigned char portFwNum __PACK__; // number of port-forwarding entry existed
	PORTFW_T portFwArray[MAX_FILTER_NUM] __PACK__; // port-forwarding array

	unsigned char ipFilterEnabled __PACK__;
	unsigned char ipFilterNum __PACK__; // number of ip-filter entry existed
	IPFILTER_T ipFilterArray[1] __PACK__; // ip-filter array Erwin Modify

	unsigned char portFilterEnabled __PACK__;
	unsigned char portFilterNum __PACK__; // number of port-filter entry existed
	PORTFILTER_T portFilterArray[1] __PACK__; // ip-filter array Erwin Modify

	unsigned char macFilterEnabled __PACK__;
	unsigned char macFilterNum __PACK__; // number of mac filter entry existed
	MACFILTER_T macFilterArray[MAX_FILTER_NUM] __PACK__; // mac-filter array

	unsigned char triggerPortEnabled __PACK__;
	unsigned char triggerPortNum __PACK__; // number of trigger port entry existed
	TRIGGERPORT_T triggerPortArray[MAX_FILTER_NUM] __PACK__; // trigger port array

	unsigned char sroutEnabled __PACK__;	// enabled of static routing
	unsigned char sroutNum __PACK__; // number of static routing
	SROUT_T sroutArray[MAX_FILTER_NUM] __PACK__; // static routing array

	unsigned char  upnpEnable __PACK__ ;
	
	unsigned char  vserEnabled __PACK__ ;
	unsigned char  vserNum __PACK__; // number of port-forwarding entry existed
	PORTFW_T vserArray[MAX_FILTER_NUM] __PACK__; // port-forwarding array
	
	unsigned char  natEnable __PACK__ ;
	unsigned char  FirewallEnable __PACK__ ;
	
	unsigned long  appLayerGateway __PACK__;
//**************************************** FireWall stuffs ****************************************
	unsigned char  ACPCEnabled __PACK__ ;
	unsigned char  ACPCNum __PACK__; // number of port-forwarding entry existed
	ACPC_T ACPCArray[MAX_FILTER_NUM] __PACK__; // port-forwarding array
	
	unsigned char  URLBEnabled __PACK__ ;
	unsigned char  URLBNum __PACK__; // number of port-forwarding entry existed
	URLB_T URLBArray[MAX_FILTER_NUM] __PACK__; // port-forwarding array

	unsigned char  podEnable __PACK__ ;
	unsigned char  pingEnable __PACK__ ;
	unsigned char  scanEnable __PACK__ ;
	unsigned char  synEnable __PACK__ ;

	unsigned short podPack __PACK__;
	unsigned char podTime __PACK__; 
	unsigned short podBur __PACK__;
	unsigned short synPack __PACK__;
	unsigned char synTime __PACK__; 
	unsigned short synBur __PACK__;
	unsigned long  scanNum __PACK__;

	unsigned char dmzEnabled __PACK__;
	unsigned char dmzHost[4] __PACK__; // DMZ host
	unsigned char  DMZNum __PACK__; // number of port-forwarding entry existed
	DMZ_T DMZArray[MAX_FILTER_NUM] __PACK__; // port-forwarding array

#endif
//**************************************** WDS stuffs ****************************************
	unsigned char iappDisabled __PACK__; // disable IAPP
	unsigned char apMode __PACK__; // select AP mode type
	unsigned char apModeTemp __PACK__; // select AP mode type Temp buffer
	unsigned char wlLinkMac1[6] __PACK__ ; // MAC address of WireLess PoP in used
	unsigned char wlLinkMac2[6] __PACK__ ; // MAC address of WAN port PoMP in used
	unsigned char wlLinkMac3[6] __PACK__ ; // MAC address of WAN port PoMP in used
	unsigned char wlLinkMac4[6] __PACK__ ; // MAC address of WAN port PoMP in used
	unsigned char wlLinkMac5[6] __PACK__ ; // MAC address of WAN port PoMP in used
	unsigned char wlLinkMac6[6] __PACK__ ; // MAC address of WAN port PoMP in used

	unsigned char wdsWep __PACK__ ; // WEP flag, 0 - disabled, 1 - 64bits, 2 128 bits
	unsigned char wdsWep64Key1[WEP64_KEY_LEN] __PACK__ ;
	unsigned char wdsWep64Key2[WEP64_KEY_LEN] __PACK__ ;
	unsigned char wdsWep64Key3[WEP64_KEY_LEN] __PACK__ ;
	unsigned char wdsWep64Key4[WEP64_KEY_LEN] __PACK__ ;
	unsigned char wdsWep128Key1[WEP128_KEY_LEN] __PACK__ ;
	unsigned char wdsWep128Key2[WEP128_KEY_LEN] __PACK__ ;
	unsigned char wdsWep128Key3[WEP128_KEY_LEN] __PACK__ ;
	unsigned char wdsWep128Key4[WEP128_KEY_LEN] __PACK__ ;
	unsigned char wdsWepDefaultKey __PACK__ ;
	unsigned char wdsWepKeyType __PACK__ ;

	unsigned char secMode __PACK__; // select security mode type
	unsigned char clIpDisabled __PACK__; // select get IP address type 0 - use ip 1-  automatically
	unsigned short sel1xMode __PACK__;	// selsect Radius type, 0-internal, 1--external
	unsigned char  wlanSetTx __PACK__;
//******************************wireless setting for inprocomm ******************************
	unsigned char  wlanTranRate[5] __PACK__;
	unsigned char  wlanRateMode __PACK__;
	unsigned char  wlanCts __PACK__;
	unsigned char  wlanBurst __PACK__;

	unsigned char wep152Key1[WEP152_KEY_LEN] __PACK__ ;
	unsigned char wep152Key2[WEP152_KEY_LEN] __PACK__ ;
	unsigned char wep152Key3[WEP152_KEY_LEN] __PACK__ ;
	unsigned char wep152Key4[WEP152_KEY_LEN] __PACK__ ;

#ifndef HOME_GATEWAY	// Radius server
	unsigned char rserEnabled __PACK__;	// enabled of radius server
	unsigned char rserCltNum __PACK__; // number of radius server client
	RSER_CLT_T rserCltArray[16] __PACK__; // radius server array client

	unsigned char rserUsrNum __PACK__; // number of radius server user
	RSER_USR_T rserUsrArray[96] __PACK__; // radius server array user
#endif

	unsigned char  psEnable __PACK__ ; // Lance 2004.2.9
	unsigned char  psIPPEnable __PACK__ ; // Lance 2004.2.16
	unsigned char  psLPREnable __PACK__ ; // Lance 2004.2.16
	unsigned char  psName[48] __PACK__ ; // Lance 2004.2.10
	unsigned char  psPort1Name[48] __PACK__ ; // Lance 2004.2.16
	unsigned char  psPort2Name[48] __PACK__ ; // Lance 2004.2.16
	unsigned char  licence __PACK__ ;
#ifdef HOME_GATEWAY	
	unsigned char  macFtPermitEnabled __PACK__ ;
	unsigned char  Reserved[17] __PACK__;  // Lance 2003.11.05
#else
	unsigned char  Reserved[695] __PACK__;
#endif
//-----------------------------------------------------------------------------------------------
} APMIB_T, *APMIB_Tp;

/* Config file header */
typedef struct param_header {
	unsigned char signature[SIGNATURE_LEN] __PACK__;  // Tag + version
	unsigned short len __PACK__;
} PARAM_HEADER_T, *PARAM_HEADER_Tp;

/* Firmware image file header */
typedef struct img_header {
	unsigned char signature[SIGNATURE_LEN] __PACK__;
	unsigned long startAddr __PACK__;
	unsigned long len __PACK__;
} IMG_HEADER_T, *IMG_HEADER_Tp;

/* Web page file header */
typedef IMG_HEADER_T WEB_HEADER_T;
typedef IMG_HEADER_Tp WEB_HEADER_Tp;

typedef struct _file_entry {
	char name[MAXFNAME] __PACK__;
	unsigned long size __PACK__;
} FILE_ENTRY_T, *FILE_ENTRY_Tp;

#ifdef WIN32
#pragma pack()
#endif

//////////////////////////////////////////////////////////
int apmib_init(void);
int apmib_reinit(void);
char *apmib_hwconf(void);
char *apmib_csconf(void);
char *apmib_dsconf(void);
int apmib_get(int id, void *value);
int apmib_getDef(int id, void *value);
int apmib_set(int id, void *value);
int apmib_setDef(int id, void *value);
int apmib_update(CONFIG_DATA_T type);
int apmib_updateDef(void);
int apmib_updateFlash(CONFIG_DATA_T type, char *data, int len, int force, int ver);

extern APMIB_Tp pMib, pMibDef;
extern HW_SETTING_Tp pHwSetting;
extern PARAM_HEADER_T hsHeader, dsHeader, csHeader;
#endif // INCLUDE_APMIB_H
extern void dump_mem(void *ptr, int size);
