/*
 *      Tool to convert ELF image to be the AP downloadable binary
 *
 *      Authors: David Hsu	<davidhsu@realtek.com.tw>
 *
 *      $Id: cvimg.c,v 1.1.1.1 2003/12/30 10:08:38 lance Exp $
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>

#define HOME_GATEWAY

#include "apmib.h"


#define DEFAULT_START_ADDR	0x80500000

static unsigned short calculateChecksum(char *buf, int len);

/////////////////////////////////////////////////////////
int main(int argc, char** argv)
{
	char inFile[80]={0}, outFile[80]={0};
	int fh, size;
	struct stat status;
	char *buf;
	IMG_HEADER_Tp pHeader;
	unsigned long startAddr;
	unsigned short checksum;

	// parse input arguments
	if ( argc != 3 && argc != 4) {
		printf("Usage: cvimg input-filename output-filename start-addr\n");
		printf("        \"start-addr\" is optional. If not given, it will use 0x%x as default.\n",
				DEFAULT_START_ADDR);
		exit(1);
	}
	sscanf(argv[1], "%s", inFile);
	sscanf(argv[2], "%s", outFile);
	if ( argc == 4 )
		sscanf(argv[3], "%x", &startAddr);
	else
		startAddr = DEFAULT_START_ADDR;

	// check input file and allocate buffer
	if ( stat(inFile, &status) < 0 ) {
		printf("Can't stat file! [%s]\n", inFile );
		exit(1);
	}
	size = status.st_size + sizeof(IMG_HEADER_T) + sizeof(checksum);
	if (size%2)
		size++; // pad

	buf = malloc(size);
	if (buf == NULL) {
		printf("Malloc buffer failed!\n");
		exit(1);
	}
	memset(buf, '\0', size);
	pHeader = (IMG_HEADER_Tp)buf;
	buf += sizeof(IMG_HEADER_T);

	// Read data and generate header
	fh = open(inFile, O_RDONLY);
	if ( fh == -1 ) {
		printf("Open input file error!\n");
		free( pHeader );
		exit(1);
	}
	lseek(fh, 0L, SEEK_SET);
	if ( read(fh, buf, status.st_size) != status.st_size) {
		printf("Read file error!\n");
		close(fh);
		free(pHeader);
		exit(1);
	}
	close(fh);

	memcpy(pHeader->signature, FW_HEADER, SIGNATURE_LEN);
	pHeader->len = DWORD_SWAP(size-sizeof(IMG_HEADER_T));
	pHeader->startAddr = DWORD_SWAP(startAddr);
	checksum = WORD_SWAP(calculateChecksum(buf, status.st_size));
	*((unsigned short *)&buf[size-sizeof(IMG_HEADER_T)-sizeof(checksum)]) = checksum;

	// Write image to output file
	fh = open(outFile, O_RDWR|O_CREAT|O_TRUNC);
	if ( fh == -1 ) {
		printf("Create output file error! [%s]\n", outFile);
		free(pHeader);
		exit(1);
	}
	write(fh, pHeader, size);
	close(fh);
	printf("Generate image successfully, length=%d, checksum=0x%x\n", DWORD_SWAP(pHeader->len), checksum);
	free(pHeader);
}

static unsigned short calculateChecksum(char *buf, int len)
{
	int i, j;
	unsigned short sum=0, tmp;

	j = (len/2)*2;

	for (i=0; i<j; i+=2) {
		tmp = *((unsigned short *)(buf + i));
		sum += WORD_SWAP(tmp);
	}

	if ( len % 2 ) {
		tmp = buf[len-1];
		sum += WORD_SWAP(tmp);
	}
	return ~sum+1;
}
