/*
 *      Web server handler routines for firewall
 *
 *      Authors: David Hsu	<davidhsu@realtek.com.tw>
 *
 *      $Id: fmfwall.c,v 1.8 2004/02/23 07:07:37 erwin Exp $
 *
 */

/*-- System inlcude files --*/
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <sys/wait.h>

#include "../webs.h"
#include "apform.h"
#include "apmib.h"
#include "utility.h"



#ifdef HOME_GATEWAY

/////////////////////////////////////////////////////////////////////////////
void formVirtualSv(webs_t wp, char_t *path, char_t *query)
{
	char_t *submitUrl, *strAddPort, *strDelPort, *strVal, *strDelAllPort;
	char_t *strIp, *strFrom, *strTo, *strComment;
	char tmpBuf[100];
	int entryNum, intVal, i;
	PORTFW_T entry;
	struct in_addr curIpAddr, curSubnet;
	unsigned long v1, v2, v3;

	strAddPort = websGetVar(wp, T("addPortFw"), T(""));
	strDelPort = websGetVar(wp, T("deleteSelPortFw"), T(""));
	strDelAllPort = websGetVar(wp, T("deleteAllPortFw"), T(""));

	memset(&entry, '\0', sizeof(entry));

		strVal = websGetVar(wp, T("enabled"), T(""));
		if ( !gstrcmp(strVal, T("ON")))
			intVal = 1;
		else
			intVal = 0;
		if ( apmib_set( MIB_VSER_ENABLED, (void *)&intVal) == 0) {//MIB_PORTFW_ENABLED
			strcpy(tmpBuf, T("Set enabled flag error!"));
			goto setErr_portfw;
		}
		
	/* Add new port-forwarding table */
	if (strAddPort[0]) {
		strIp = websGetVar(wp, T("ip"), T(""));
		strFrom = websGetVar(wp, T("fromPort"), T(""));
		strTo = websGetVar(wp, T("toPort"), T(""));
		strComment = websGetVar(wp, T("comment"), T(""));
		
		if (!strIp[0] && !strFrom[0] && !strTo[0] && !strComment[0])
			goto setOk_portfw;

		if (!strIp[0]) {
			strcpy(tmpBuf, T("Error! No ip address to set."));
			goto setErr_portfw;
		}
		
		inet_aton(strIp, (struct in_addr *)&entry.ipAddr);
		getInAddr(BRIDGE_IF, IP_ADDR, (void *)&curIpAddr);
		getInAddr(BRIDGE_IF, SUBNET_MASK, (void *)&curSubnet);
		v1 = *((unsigned long *)entry.ipAddr);
		v2 = *((unsigned long *)&curIpAddr);
		v3 = *((unsigned long *)&curSubnet);
		if ( (v1 & v3) != (v2 & v3) ) {
			strcpy(tmpBuf, T("Invalid IP address! It should be set within the current subnet."));
			goto setErr_portfw;
		}

		if ( !strFrom[0] ) { // if port-forwarding, from port must exist
			strcpy(tmpBuf, T("Error! No private-port value to be set."));
			goto setErr_portfw;
		}
		if ( !string_to_dec(strFrom, &intVal) || intVal<1 || intVal>65535) {
			strcpy(tmpBuf, T("Error! Invalid value of private-port."));
			goto setErr_portfw;
		}
		entry.fromPort = (unsigned short)intVal;

		if ( !strTo[0] )
			entry.toPort = entry.fromPort;
		else {
			if ( !string_to_dec(strTo, &intVal) || intVal<1 || intVal>65535) {
				strcpy(tmpBuf, T("Error! Invalid value of public-port."));
				goto setErr_portfw;
			}
		}
		entry.toPort = (unsigned short)intVal;

/*		if ( entry.fromPort  > entry.toPort ) {
			strcpy(tmpBuf, T("Error! Invalid port range."));
			goto setErr_portfw;
		}
*/
		strVal = websGetVar(wp, T("protocol"), T(""));
		if (strVal[0]) {
			if ( strVal[0] == '0' )
				entry.protoType = PROTO_BOTH;
			else if ( strVal[0] == '1' )
				entry.protoType = PROTO_TCP;
			else if ( strVal[0] == '2' )
				entry.protoType = PROTO_UDP;
			else {
				strcpy(tmpBuf, T("Error! Invalid protocol type."));
				goto setErr_portfw;
			}
		}
		else {
			strcpy(tmpBuf, T("Error! Protocol type cannot be empty."));
			goto setErr_portfw;
		}

		if ( strComment[0] ) {
			if (strlen(strComment) > COMMENT_LEN-1) {
				strcpy(tmpBuf, T("Error! Comment length too long."));
				goto setErr_portfw;
			}
			strcpy(entry.comment, strComment);
		}
		if ( !apmib_get(MIB_VSER_NUM, (void *)&entryNum)) {//MIB_PORTFW_NUM
			strcpy(tmpBuf, T("Get entry number error!"));
			goto setErr_portfw;
		}

		if ( (entryNum + 1) > MAX_FILTER_NUM) {
			strcpy(tmpBuf, T("Cannot add new entry because table is full!"));
			goto setErr_portfw;
		}

		// Check if there is any port overlapped
		for (i=1; i<=entryNum; i++) {
			PORTFW_T checkEntry;
			*((char *)&checkEntry) = (char)i;
			if ( !apmib_get(MIB_VSER, (void *)&checkEntry)) {//MIB_PORTFW
				strcpy(tmpBuf, T("Get table entry error!"));
				goto setErr_portfw;
			}
			if (entry.toPort == checkEntry.toPort ) {
				strcpy(tmpBuf, T("Setting port range has overlapped with used port numbers!"));
				goto setErr_portfw;
			}
/*			if ( ( (entry.fromPort <= checkEntry.fromPort &&
					entry.toPort >= checkEntry.fromPort) ||
			       (entry.fromPort >= checkEntry.fromPort &&
				entry.fromPort <= checkEntry.toPort)
			     )&&
			       (entry.protoType & checkEntry.protoType) ) {
				strcpy(tmpBuf, T("Setting port range has overlapped with used port numbers!"));
				goto setErr_portfw;
			}
*/		}

		// set to MIB. try to delete it first to avoid duplicate case
		apmib_set(MIB_VSER_DEL, (void *)&entry);//MIB_PORTFW_DEL
		if ( apmib_set(MIB_VSER_ADD, (void *)&entry) == 0) {//MIB_PORTFW_ADD
			strcpy(tmpBuf, T("Add table entry error!"));
			goto setErr_portfw;
		}
	}

	/* Delete entry */
	if (strDelPort[0]) {
		if ( !apmib_get(MIB_VSER_NUM, (void *)&entryNum)) {
			strcpy(tmpBuf, T("Get entry number error!"));
			goto setErr_portfw;
		}

		for (i=entryNum; i>0; i--) {
			snprintf(tmpBuf, 20, "select%d", i);

			strVal = websGetVar(wp, tmpBuf, T(""));
			if ( !gstrcmp(strVal, T("ON")) ) {
				*((char *)&entry) = (char)i;
				if ( !apmib_get(MIB_VSER, (void *)&entry)) {
					strcpy(tmpBuf, T("Get table entry error!"));
					goto setErr_portfw;
				}
				if ( !apmib_set(MIB_VSER_DEL, (void *)&entry)) {
					strcpy(tmpBuf, T("Delete table entry error!"));
					goto setErr_portfw;
				}
			}
		}
	}

	/* Delete all entry */
	if ( strDelAllPort[0]) {
		if ( !apmib_set(MIB_VSER_DELALL, (void *)&entry)) {
			strcpy(tmpBuf, T("Delete all table error!"));
			goto setErr_portfw;
		}
	}

setOk_portfw:
	apmib_update(CURRENT_SETTING);

#ifndef NO_ACTION
/*	pid = fork();
        if (pid) {
	      	waitpid(pid, NULL, 0);
	}
        else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _FIREWALL_SCRIPT_PROG);
		execl( tmpBuf, _FIREWALL_SCRIPT_PROG, NULL);
               	exit(1);
        }*/
	system("/bin/firewall.sh");
#endif

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
	if (submitUrl[0])
		websRedirect(wp, submitUrl);
	else
		websDone(wp, 200);
  	return;

setErr_portfw:
	ERR_MSG(tmpBuf);
  	return;
}
/////////////////////////////////////////////////////////////////////////////
int virtualSvList(int eid, webs_t wp, int argc, char_t **argv)
{
	int	nBytesSent=0, entryNum, i;
	PORTFW_T entry;
	char	*type, *ip, portFrom[20], portTo[20];

	if ( !apmib_get(MIB_VSER_NUM, (void *)&entryNum)) {
  		websError(wp, 400, T("Get table entry error!\n"));
		return -1;
	}
	for (i=1; i<=entryNum; i++) {
		*((char *)&entry) = (char)i;
		if ( !apmib_get(MIB_VSER, (void *)&entry))
			return -1;

		ip = inet_ntoa(*((struct in_addr *)entry.ipAddr));
		if ( !strcmp(ip, "0.0.0.0"))
			ip = "----";

		if ( entry.protoType == PROTO_BOTH )
			type = "TCP+UDP";
		else if ( entry.protoType == PROTO_TCP )
			type = "TCP";
		else
			type = "UDP";

			snprintf(portFrom, 20, "%d", entry.fromPort);
			snprintf(portTo, 20, "%d", entry.toPort);
			
		nBytesSent += websWrite(wp, T("<tr>"
		"<td align=center width=\"25%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
      		"<td align=center width=\"16%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
      		"<td align=center width=\"15%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
      		"<td align=center width=\"16%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
     		"<td align=center width=\"18%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
      		"<td align=center width=\"10%%\" class=\"table2\"><input type=\"checkbox\" name=\"select%d\" value=\"ON\"></td></tr>\n"),
				ip, portFrom, type, portTo, entry.comment, i);
	}
	return nBytesSent;
}
/////////////////////////////////////////////////////////////////////////////
void formPortFw(webs_t wp, char_t *path, char_t *query)
{
	char_t *submitUrl, *strAddPort, *strDelPort, *strVal, *strDelAllPort;
	char_t *strIp, *strFrom, *strTo, *strComment;
	char tmpBuf[100];
	int entryNum, intVal, i;
	PORTFW_T entry;
	struct in_addr curIpAddr, curSubnet;
	unsigned long v1, v2, v3;

	strAddPort = websGetVar(wp, T("addPortFw"), T(""));
	strDelPort = websGetVar(wp, T("deleteSelPortFw"), T(""));
	strDelAllPort = websGetVar(wp, T("deleteAllPortFw"), T(""));

	memset(&entry, '\0', sizeof(entry));

		strVal = websGetVar(wp, T("enabled"), T(""));
		if ( !gstrcmp(strVal, T("ON")))
			intVal = 1;
		else
			intVal = 0;
		if ( apmib_set( MIB_PORTFW_ENABLED, (void *)&intVal) == 0) {
			strcpy(tmpBuf, T("Set enabled flag error!"));
			goto setErr_portfw;
		}

	/* Add new port-forwarding table */
	if (strAddPort[0]) {
		strIp = websGetVar(wp, T("ip"), T(""));
		strFrom = websGetVar(wp, T("fromPort"), T(""));
		strTo = websGetVar(wp, T("toPort"), T(""));
		strComment = websGetVar(wp, T("comment"), T(""));
		
		if (!strIp[0] && !strFrom[0] && !strTo[0] && !strComment[0])
			goto setOk_portfw;

		if (!strIp[0]) {
			strcpy(tmpBuf, T("Error! No ip address to set."));
			goto setErr_portfw;
		}

		inet_aton(strIp, (struct in_addr *)&entry.ipAddr);
		getInAddr(BRIDGE_IF, IP_ADDR, (void *)&curIpAddr);
		getInAddr(BRIDGE_IF, SUBNET_MASK, (void *)&curSubnet);

		v1 = *((unsigned long *)entry.ipAddr);
		v2 = *((unsigned long *)&curIpAddr);
		v3 = *((unsigned long *)&curSubnet);

		if ( (v1 & v3) != (v2 & v3) ) {
			strcpy(tmpBuf, T("Invalid IP address! It should be set within the current subnet."));
			goto setErr_portfw;
		}

		if ( !strFrom[0] ) { // if port-forwarding, from port must exist
			strcpy(tmpBuf, T("Error! No from-port value to be set."));
			goto setErr_portfw;
		}
		if ( !string_to_dec(strFrom, &intVal) || intVal<1 || intVal>65535) {
			strcpy(tmpBuf, T("Error! Invalid value of from-port."));
			goto setErr_portfw;
		}
		entry.fromPort = (unsigned short)intVal;

		if ( !strTo[0] )
			entry.toPort = entry.fromPort;
		else {
			if ( !string_to_dec(strTo, &intVal) || intVal<1 || intVal>65535) {
				strcpy(tmpBuf, T("Error! Invalid value of to-port."));
				goto setErr_portfw;
			}
		}
		entry.toPort = (unsigned short)intVal;

		if ( entry.fromPort  > entry.toPort ) {
			strcpy(tmpBuf, T("Error! Invalid port range."));
			goto setErr_portfw;
		}

		strVal = websGetVar(wp, T("protocol"), T(""));
		if (strVal[0]) {
			if ( strVal[0] == '0' )
				entry.protoType = PROTO_BOTH;
			else if ( strVal[0] == '1' )
				entry.protoType = PROTO_TCP;
			else if ( strVal[0] == '2' )
				entry.protoType = PROTO_UDP;
			else {
				strcpy(tmpBuf, T("Error! Invalid protocol type."));
				goto setErr_portfw;
			}
		}
		else {
			strcpy(tmpBuf, T("Error! Protocol type cannot be empty."));
			goto setErr_portfw;
		}

		if ( strComment[0] ) {
			if (strlen(strComment) > COMMENT_LEN-1) {
				strcpy(tmpBuf, T("Error! Comment length too long."));
				goto setErr_portfw;
			}
			strcpy(entry.comment, strComment);
		}
		if ( !apmib_get(MIB_PORTFW_NUM, (void *)&entryNum)) {
			strcpy(tmpBuf, T("Get entry number error!"));
			goto setErr_portfw;
		}

		if ( (entryNum + 1) > MAX_FILTER_NUM) {
			strcpy(tmpBuf, T("Cannot add new entry because table is full!"));
			goto setErr_portfw;
		}

		// Check if there is any port overlapped
		for (i=1; i<=entryNum; i++) {
			PORTFW_T checkEntry;
			*((char *)&checkEntry) = (char)i;
			if ( !apmib_get(MIB_PORTFW, (void *)&checkEntry)) {
				strcpy(tmpBuf, T("Get table entry error!"));
				goto setErr_portfw;
			}
			if ( ( (entry.fromPort <= checkEntry.fromPort &&
					entry.toPort >= checkEntry.fromPort) ||
			       (entry.fromPort >= checkEntry.fromPort &&
				entry.fromPort <= checkEntry.toPort)
			     )&&
			       (entry.protoType & checkEntry.protoType) ) {
				strcpy(tmpBuf, T("Setting port range has overlapped with used port numbers!"));
				goto setErr_portfw;
			}
		}

		// set to MIB. try to delete it first to avoid duplicate case
		apmib_set(MIB_PORTFW_DEL, (void *)&entry);
		if ( apmib_set(MIB_PORTFW_ADD, (void *)&entry) == 0) {
			strcpy(tmpBuf, T("Add table entry error!"));
			goto setErr_portfw;
		}
	}

	/* Delete entry */
	if (strDelPort[0]) {
		if ( !apmib_get(MIB_PORTFW_NUM, (void *)&entryNum)) {
			strcpy(tmpBuf, T("Get entry number error!"));
			goto setErr_portfw;
		}

		for (i=entryNum; i>0; i--) {
			snprintf(tmpBuf, 20, "select%d", i);

			strVal = websGetVar(wp, tmpBuf, T(""));
			if ( !gstrcmp(strVal, T("ON")) ) {
				*((char *)&entry) = (char)i;
				if ( !apmib_get(MIB_PORTFW, (void *)&entry)) {
					strcpy(tmpBuf, T("Get table entry error!"));
					goto setErr_portfw;
				}
				if ( !apmib_set(MIB_PORTFW_DEL, (void *)&entry)) {
					strcpy(tmpBuf, T("Delete table entry error!"));
					goto setErr_portfw;
				}
			}
		}
	}

	/* Delete all entry */
	if ( strDelAllPort[0]) {
		if ( !apmib_set(MIB_PORTFW_DELALL, (void *)&entry)) {
			strcpy(tmpBuf, T("Delete all table error!"));
			goto setErr_portfw;
		}
	}

setOk_portfw:
	apmib_update(CURRENT_SETTING);

#ifndef NO_ACTION
/*	pid = fork();
        if (pid) {
	      	waitpid(pid, NULL, 0);
	}
        else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _FIREWALL_SCRIPT_PROG);
		execl( tmpBuf, _FIREWALL_SCRIPT_PROG, NULL);
               	exit(1);
        }*/
	system("/bin/firewall.sh");
#endif

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
	if (submitUrl[0])
		websRedirect(wp, submitUrl);
	else
		websDone(wp, 200);
  	return;

setErr_portfw:
	ERR_MSG(tmpBuf);
  	return;
}


/////////////////////////////////////////////////////////////////////////////
void formFilter(webs_t wp, char_t *path, char_t *query)
{
	char_t *strAddIp, *strAddPort, *strAddMac, *strDelPort, *strDelIp, *strDelMac;
	char_t *strAddURLB, *strDelURLB, *strDelAllURLB, *strURLB;	// for URL blocking
	char_t *strAddDMZ, *strDelDMZ, *strDelAllDMZ, *strsIp;		// for dmz
	char_t *strAddACPC, *strDelACPC, *strDelAllACPC;			// for ip filter
	char_t *strAddSRout, *strDelSRout, *strDelAllSRout;			// for static routing
	char_t *strDelAllPort, *strDelAllIp, *strDelAllMac, *strVal, *submitUrl, *strComment;
	char_t *strFrom, *strTo;
	char tmpBuf[100];
	int entryNum, intVal, i;
	IPFILTER_T ipEntry;
	DMZ_T dmzEntry;		// for dmz
	URLB_T URLBEntry;	// for URL blocking
	ACPC_T ACPCEntry;	// for ip filter
	SROUT_T sroutEntry;	// for static routing	
	PORTFILTER_T portEntry;
	MACFILTER_T macEntry;
	struct in_addr curIpAddr, curSubnet;
	void *pEntry;
	unsigned long v1, v2, v3, v4;
	int num_id, get_id, add_id, del_id, delall_id, enable_id;
	
/*#ifndef NO_ACTION
	int pid;
#endif*/

	strAddDMZ = websGetVar(wp, T("addDMZ"), T(""));
	strDelDMZ = websGetVar(wp, T("delSelDMZ"), T(""));
	strDelAllDMZ = websGetVar(wp, T("delAllDMZ"), T(""));
	
	strAddIp = websGetVar(wp, T("addFilterIp"), T(""));
	strDelIp = websGetVar(wp, T("deleteSelFilterIp"), T(""));
	strDelAllIp = websGetVar(wp, T("deleteAllFilterIp"), T(""));

	strAddPort = websGetVar(wp, T("addFilterPort"), T(""));
	strDelPort = websGetVar(wp, T("deleteSelFilterPort"), T(""));
	strDelAllPort = websGetVar(wp, T("deleteAllFilterPort"), T(""));

	strAddMac = websGetVar(wp, T("addFilterMac"), T(""));
	strDelMac = websGetVar(wp, T("deleteSelFilterMac"), T(""));
	strDelAllMac = websGetVar(wp, T("deleteAllFilterMac"), T(""));

	strAddURLB = websGetVar(wp, T("addURLB"), T(""));
	strDelURLB = websGetVar(wp, T("deleteSelURLB"), T(""));
	strDelAllURLB = websGetVar(wp, T("deleteAllURLB"), T(""));
	
	strAddACPC = websGetVar(wp, T("addACPC"), T(""));
	strDelACPC = websGetVar(wp, T("deleteSelACPC"), T(""));
	strDelAllACPC = websGetVar(wp, T("deleteAllACPC"), T(""));
	
	strAddSRout = websGetVar(wp, T("addSRout"), T(""));
	strDelSRout = websGetVar(wp, T("delSelSRout"), T(""));
	strDelAllSRout = websGetVar(wp, T("delAllSRout"), T(""));
	
	if (strAddIp[0] || strDelIp[0] || strDelAllIp[0]) {
		num_id = MIB_IPFILTER_NUM;
		get_id = MIB_IPFILTER;
		add_id = MIB_IPFILTER_ADD;
		del_id = MIB_IPFILTER_DEL;
		delall_id = MIB_IPFILTER_DELALL;
		enable_id = MIB_IPFILTER_ENABLED;
		memset(&ipEntry, '\0', sizeof(ipEntry));
		pEntry = (void *)&ipEntry;
	}
	else if (strAddDMZ[0] || strDelDMZ[0] || strDelAllDMZ[0]) {
		num_id = MIB_DMZ_NUM;
		get_id = MIB_DMZ;
		add_id = MIB_DMZ_ADD;
		del_id = MIB_DMZ_DEL;
		delall_id = MIB_DMZ_DELALL;
		enable_id = MIB_DMZ_ENABLED;
		memset(&dmzEntry, '\0', sizeof(dmzEntry));
		pEntry = (void *)&dmzEntry;
	}
	else if (strAddPort[0] || strDelPort[0] || strDelAllPort[0]) {
		num_id = MIB_PORTFILTER_NUM;
		get_id = MIB_PORTFILTER;
		add_id = MIB_PORTFILTER_ADD;
		del_id = MIB_PORTFILTER_DEL;
		delall_id = MIB_PORTFILTER_DELALL;
		enable_id = MIB_PORTFILTER_ENABLED;
		memset(&portEntry, '\0', sizeof(portEntry));
		pEntry = (void *)&portEntry;
	}
	else if (strAddACPC[0] || strDelACPC[0] || strDelAllACPC[0]) {
		num_id = MIB_ACPC_NUM;
		get_id = MIB_ACPC;
		add_id = MIB_ACPC_ADD;
		del_id = MIB_ACPC_DEL;
		delall_id = MIB_ACPC_DELALL;
		enable_id = MIB_ACPC_ENABLED;
		memset(&ACPCEntry, '\0', sizeof(ACPCEntry));
		pEntry = (void *)&ACPCEntry;
	}
	else if (strAddURLB[0] || strDelURLB[0] || strDelAllURLB[0]) {
		num_id = MIB_URLB_NUM;
		get_id = MIB_URLB;
		add_id = MIB_URLB_ADD;
		del_id = MIB_URLB_DEL;
		delall_id = MIB_URLB_DELALL;
		enable_id = MIB_URLB_ENABLED;
		memset(&URLBEntry, '\0', sizeof(URLBEntry));
		pEntry = (void *)&URLBEntry;
	}
	else if (strAddSRout[0] || strDelSRout[0] || strDelAllSRout[0]) {
		num_id = MIB_SROUT_NUM;
		get_id = MIB_SROUT;
		add_id = MIB_SROUT_ADD;
		del_id = MIB_SROUT_DEL;
		delall_id = MIB_SROUT_DELALL;
		enable_id = MIB_SROUT_ENABLED;
		memset(&sroutEntry, '\0', sizeof(sroutEntry));
		pEntry = (void *)&sroutEntry;
	}
	else {
		num_id = MIB_MACFILTER_NUM;
		get_id = MIB_MACFILTER;
		add_id = MIB_MACFILTER_ADD;
		del_id = MIB_MACFILTER_DEL;
		delall_id = MIB_MACFILTER_DELALL;
		enable_id = MIB_MACFILTER_ENABLED;
		memset(&macEntry, '\0', sizeof(macEntry));
		pEntry = (void *)&macEntry;
	}

	if ( !apmib_get(num_id, (void *)&entryNum)) {
		strcpy(tmpBuf, T("Get entry number error!"));
		goto setErr_filter;
	}
	if ( (entryNum + 1) > MAX_FILTER_NUM) {
		strcpy(tmpBuf, T("Cannot add new entry because table is full!"));
		goto setErr_filter;
	}

	// Set enable flag
	if (strAddACPC[0] ||strAddURLB[0] || strAddDMZ[0] || 
				strAddIp[0] || strAddPort[0] || strAddMac[0] || strAddSRout[0]) {
		strVal = websGetVar(wp, T("enabled"), T(""));
		if ( !gstrcmp(strVal, T("ON")))
			intVal = 1;
		else
			intVal = 0;

		if ( apmib_set(enable_id, (void *)&intVal) == 0) {
			strcpy(tmpBuf, T("Set enabled flag error!"));
			goto setErr_filter;
		}
	}

	strComment = websGetVar(wp, T("comment"), T(""));
	
//*********************************** Add URL Blocking ***********************************
	if (strAddURLB[0]) {
		strURLB = websGetVar(wp, T("URLB"), T(""));
		if (!strURLB[0])
			goto setOk_filter;
		
		if ( strURLB[0] ) {
			if (strlen(strURLB) > 32) {
				strcpy(tmpBuf, T("Error! Comment length too long."));
				goto setErr_filter;
			}
			else 
			{  // Lance 2003.11.06
				int i;
				for( i=0; i<32; i++ )
					strURLB[i] = tolower(strURLB[i]);

				strcpy(URLBEntry.URLBAddr, strURLB);
			}
		}
	}

//*************************************** Add DMZ ****************************************
	if ( strAddDMZ[0] ) {
		char_t *strType, *strSession, *strPbIp, *strClIp;
		
		strType = websGetVar(wp, T("dmzType"), T(""));
		strSession = websGetVar(wp, T("session"), T(""));
		strPbIp = websGetVar(wp, T("pip"), T(""));
		strClIp = websGetVar(wp, T("cip"), T(""));
		
		if (!strType[0] && !strSession[0] && !strPbIp[0] && !strClIp[0] )
			goto setOk_filter;

		if (!strClIp[0]) {
			strcpy(tmpBuf, T("Error! No ip address to set."));
			goto setErr_filter;
		}
		inet_aton(strClIp, (struct in_addr *)&dmzEntry.cipAddr);
		getInAddr(BRIDGE_IF, IP_ADDR, (void *)&curIpAddr);
		getInAddr(BRIDGE_IF, SUBNET_MASK, (void *)&curSubnet);

		v1 = *((unsigned long *)dmzEntry.cipAddr);
		v2 = *((unsigned long *)&curIpAddr);
		v3 = *((unsigned long *)&curSubnet);

		if ( (v1 & v3) != (v2 & v3) ) {
			strcpy(tmpBuf, T("Invalid IP address! It should be set within the current subnet."));
			goto setErr_filter;
		}
		if (strType[0] == '0') 	// type of dmz is dynamic ip
			dmzEntry.type = 0;
		else
			dmzEntry.type = 1;
		
		if (strSession[0] == '1')
			dmzEntry.session = 1;
		else
			dmzEntry.session = 0;

		if (!strcmp( strPbIp, "" ))
			strPbIp = "0.0.0.0";		
		inet_aton(strPbIp, (struct in_addr *)&dmzEntry.pipAddr);
		for (i=1; i<=entryNum; i++) {	// Check if there is any ip overlapped
			DMZ_T checkEntry;
			*((char *)&checkEntry) = (char)i;
			if ( !apmib_get(get_id, (void *)&checkEntry)) {
				strcpy(tmpBuf, T("Get table entry error!"));
				goto setErr_filter;
			}
			if (!memcmp(&checkEntry.pipAddr, &dmzEntry.pipAddr, 4)) {
				strcpy(tmpBuf, T("Setting public ip has overlapped with used ip address!"));
				goto setErr_filter;
			}
		}
	}
//*********************************** Add Static Routing ***********************************
	if (strAddSRout[0]) {
		char_t *strIp, *strMask, *strGateway, *strCount, *strFace;
		int k;
		FILE *fp;
		char wanAddr[3][20];
		
		strIp = websGetVar(wp, T("sroutIp"), T(""));
		strMask = websGetVar(wp, T("sroutMask"), T(""));
		strGateway = websGetVar(wp, T("sroutGateway"), T(""));
		strCount = websGetVar(wp, T("sroutCount"), T(""));
		strFace = websGetVar(wp, T("sroutFace"), T(""));

		if (!strIp[0] && !strMask[0] && !strGateway[0] && !strCount[0] && !strFace[0] )
			goto setOk_filter;

		if (!strIp[0] || !strMask[0] || !strGateway[0]) {
			strcpy(tmpBuf, T("Error! input argument is not enough"));
			goto setErr_filter;
		}
		
		inet_aton(strIp, (struct in_addr *)&sroutEntry.ipAddr);
		inet_aton(strMask, (struct in_addr *)&sroutEntry.maskAddr);
		inet_aton(strGateway, (struct in_addr *)&sroutEntry.gatewayAddr);
		
		v1 = *((unsigned long *)&sroutEntry.ipAddr);	//check IP 
		v2 = *((unsigned long *)&sroutEntry.maskAddr);
		v3 = v1 & v2 ;
			
		memcpy(&sroutEntry.ipAddr, &v3, 4);
		if ( v3 != v1) {
			sprintf(tmpBuf, "Invalid IP address! It should be %d.%d.%d.%d.",
			sroutEntry.ipAddr[0],sroutEntry.ipAddr[1],sroutEntry.ipAddr[2],sroutEntry.ipAddr[3]);
			goto setErr_filter;
		}
		
		// compare type gateway address with interface ip address
		if ( strFace[0] == '1' ) {
			system("wan-status.sh");
			if ((fp = fopen("/var/run/wanstat","r"))!=NULL) {
				for ( k=0 ; k<3 ; k++)
					fgets(wanAddr[k], 20, fp);
				fclose(fp);
			}
			inet_aton(wanAddr[1], (struct in_addr *)&curIpAddr);
			inet_aton(wanAddr[2], (struct in_addr *)&curSubnet);
			
			v1 = *((unsigned long *)&sroutEntry.gatewayAddr);
			v2 = *((unsigned long *)&curIpAddr);
			v3 = *((unsigned long *)&curSubnet);
			if ( (v1 & v3) != (v2 & v3) ) {
				strcpy(tmpBuf, T("Invalid IP address! It should be set within the WAN subnet."));
				goto setErr_filter;
			}
		} else {
			getInAddr(BRIDGE_IF, IP_ADDR, (void *)&curIpAddr);
			getInAddr(BRIDGE_IF, SUBNET_MASK, (void *)&curSubnet);
		
			v1 = *((unsigned long *)&sroutEntry.gatewayAddr);
			v2 = *((unsigned long *)&curIpAddr);
			v3 = *((unsigned long *)&curSubnet);
			if ( (v1 & v3) != (v2 & v3) ) {
				strcpy(tmpBuf, T("Invalid IP address! It should be set within the LAN subnet."));
				goto setErr_filter;
			}
		}
		
		if ( !string_to_dec(strCount, &intVal) || intVal<0 || intVal>255) {
			strcpy(tmpBuf, T("Error! Invalid value of Hop Count."));
			goto setErr_filter;
		}
		sroutEntry.hopCount = (unsigned short)intVal;
		if (strFace[0]){
			if ( strFace[0] == '0' )
				sroutEntry.interface = 0;
			else
				sroutEntry.interface = 1;
		}
	}
	
//****************************** Add access control Ip filter ******************************
	if (strAddACPC[0]) {
		strVal = websGetVar(wp, T("sipaddr"), T(""));
		strsIp = websGetVar(wp, T("eipaddr"), T(""));
		if (!strVal[0] && !strComment[0])
			goto setOk_filter;

		if (!strVal[0]) {
			strcpy(tmpBuf, T("Error! No ip address to set."));
			goto setErr_filter;
		}
	if ( !strsIp[0])
		strsIp=strVal;
	
		inet_aton(strVal, (struct in_addr *)&ACPCEntry.sipAddr);
		inet_aton(strsIp, (struct in_addr *)&ACPCEntry.eipAddr);
		getInAddr(BRIDGE_IF, IP_ADDR, (void *)&curIpAddr);
		getInAddr(BRIDGE_IF, SUBNET_MASK, (void *)&curSubnet);

		v1 = *((unsigned long *)ACPCEntry.sipAddr);
		v4 = *((unsigned long *)ACPCEntry.eipAddr);
		v2 = *((unsigned long *)&curIpAddr);
		v3 = *((unsigned long *)&curSubnet);
		if ( ((v1 & v3) != (v2 & v3)) || ((v4 & v3) != (v2 & v3))) {
			strcpy(tmpBuf, T("Invalid IP address! It should be set within the current subnet."));
			goto setErr_filter;
		}

//------------------------------------------------------------------------------------
{	
	char *ptr, *ptr2, *ptr3;
	int	i;
	
	ptr = websGetVar(wp, T("Port"), T(""));
	for (i=0;i<5; i++)	{
		if ((ptr2 = strchr(ptr, ',')) != NULL) {
			*ptr2 = '\0';
			ptr2 ++;
		}
		
		if ((ptr3 = strchr(ptr, '-')) != NULL) {
			*ptr3 = '\0';
			ptr3 ++;
					
			if ((!(ACPCEntry.Port[i][0] = atoi(ptr))) || (ACPCEntry.Port[i][0] < 1) || (ACPCEntry.Port[i][0] >65536)) {
				strcpy(tmpBuf, T("Error! Invalid value of  form-port."));
				goto setErr_filter;
			}
			if ((!(ACPCEntry.Port[i][1]=atoi(ptr3))) || (ACPCEntry.Port[i][1] < 1) || (ACPCEntry.Port[i][1] >65536))  {
				strcpy(tmpBuf, T("Error! Invalid value of  to-port."));
				goto setErr_filter;
			}
			if (ACPCEntry.Port[i][1] < ACPCEntry.Port[i][0]) {
				strcpy(tmpBuf, T("Invalid port range! 1st port value should be less than 2nd value"));
				goto setErr_filter;
			}
		}
		else 
				ACPCEntry.Port[i][0]=ACPCEntry.Port[i][1]=atol(ptr);
/*				if (i>0)	
					if (ACPCEntry.Port[i-1][1] > ACPCEntry.Port[i][1])  {
						strcpy(tmpBuf, T("Error!"));
						goto setErr_filter;
					}*/
		if( ptr2 == NULL)
			break;
		ptr = ptr2;
	}
}	
//------------------------------------------------------------------------------------
{
  char_t *strIndex;
  unsigned long longVal;
 
		strIndex = websGetVar(wp, T("serindex"), T(""));
		longVal=strtoul(strIndex,NULL,0);
		ACPCEntry.serindex = longVal;
}
//-------------------------------------------------------------------------------------------
	}

//*********************************** Add Ip filter ***********************************
	if (strAddIp[0]) {
		strVal = websGetVar(wp, T("ip"), T(""));
		if (!strVal[0] && !strComment[0])
			goto setOk_filter;

		if (!strVal[0]) {
			strcpy(tmpBuf, T("Error! No ip address to set."));
			goto setErr_filter;
		}
		inet_aton(strVal, (struct in_addr *)&ipEntry.ipAddr);
		getInAddr(BRIDGE_IF, IP_ADDR, (void *)&curIpAddr);
		getInAddr(BRIDGE_IF, SUBNET_MASK, (void *)&curSubnet);

		v1 = *((unsigned long *)ipEntry.ipAddr);
		v2 = *((unsigned long *)&curIpAddr);
		v3 = *((unsigned long *)&curSubnet);

		if ( (v1 & v3) != (v2 & v3) ) {
			strcpy(tmpBuf, T("Invalid IP address! It should be set within the current subnet."));
			goto setErr_filter;
		}
	}

	/* Add port filter */
	if (strAddPort[0]) {
		strFrom = websGetVar(wp, T("fromPort"), T(""));
		strTo = websGetVar(wp, T("toPort"), T(""));
		if (!strFrom[0] && !strTo[0] && !strComment[0])
			goto setOk_filter;

		if (!strFrom[0]) { // if port-forwarding, from port must exist
			strcpy(tmpBuf, T("Error! No from-port value to be set."));
			goto setErr_filter;
		}
		if ( !string_to_dec(strFrom, &intVal) || intVal<1 || intVal>65535) {
			strcpy(tmpBuf, T("Error! Invalid value of from-port."));
			goto setErr_filter;
		}
		portEntry.fromPort = (unsigned short)intVal;

		if ( !strTo[0] )
			portEntry.toPort = portEntry.fromPort;
		else {
			if ( !string_to_dec(strTo, &intVal) || intVal<1 || intVal>65535) {
				strcpy(tmpBuf, T("Error! Invalid value of to-port."));
				goto setErr_filter;
			}
			portEntry.toPort = (unsigned short)intVal;
		}

		if ( portEntry.fromPort  > portEntry.toPort ) {
			strcpy(tmpBuf, T("Error! Invalid port range."));
			goto setErr_filter;
		}
	}

	if (strAddACPC[0] || strAddPort[0] || strAddIp[0]) {
		strVal = websGetVar(wp, T("protocol"), T(""));
		if (strVal[0]) {
			if ( strVal[0] == '0' ) {
				if (strAddPort[0])
					portEntry.protoType = PROTO_BOTH;
				else if (strAddIp[0])
					ipEntry.protoType = PROTO_BOTH;
				else
					ACPCEntry.protoType = PROTO_BOTH;
			}
			else if ( strVal[0] == '1' ) {
				if (strAddPort[0])
					portEntry.protoType = PROTO_TCP;
				else if (strAddIp[0])
					ipEntry.protoType = PROTO_TCP;
				else
					ACPCEntry.protoType = PROTO_TCP;
			}
			else if ( strVal[0] == '2' ) {
				if (strAddPort[0])
					portEntry.protoType = PROTO_UDP;
				else if (strAddIp[0])
					ipEntry.protoType = PROTO_UDP;
				else
					ACPCEntry.protoType = PROTO_UDP;
			}
			else {
				strcpy(tmpBuf, T("Error! Invalid protocol type."));
				goto setErr_filter;
			}
		}
		else {
			strcpy(tmpBuf, T("Error! Protocol type cannot be empty."));
			goto setErr_filter;
		}
	}

	if (strAddMac[0]) {
		strVal = websGetVar(wp, T("mac"), T(""));
		if (!strVal[0] && !strComment[0])
			goto setOk_filter;

		if ( !strVal[0] ) {
			strcpy(tmpBuf, T("Error! No mac address to set."));
			goto setErr_filter;
		}
		if (strlen(strVal)!=12 || !string_to_hex(strVal, macEntry.macAddr, 12)) {
			strcpy(tmpBuf, T("Error! Invalid MAC address."));
			goto setErr_filter;
		}
	}

	if (strAddACPC[0] ||strAddURLB[0] || strAddDMZ[0] || strAddIp[0] || strAddPort[0] || strAddMac[0] || strAddSRout[0]) {
	//printf("\nstrComment=%d  getComment=%d\n",strlen(strComment),(COMMENT_LEN-1));
		if ( strComment[0] ) {
			if (strlen(strComment) > COMMENT_LEN-1) {
				strcpy(tmpBuf, T("Error! Comment length too long."));
				goto setErr_filter;
			}
			if (strAddIp[0])
				strcpy(ipEntry.comment, strComment);
			else if (strAddPort[0])
				strcpy(portEntry.comment, strComment);
			else if (strAddMac[0])
				strcpy(macEntry.comment, strComment);
			else if (strAddACPC[0])
				strcpy(ACPCEntry.comment, strComment);
		}
		if ( !apmib_get(num_id, (void *)&entryNum)) {
			strcpy(tmpBuf, T("Get entry number error!"));
			goto setErr_filter;
		}
		if ( (entryNum + 1) > MAX_FILTER_NUM) {
			strcpy(tmpBuf, T("Cannot add new entry because table is full!"));
			goto setErr_filter;
		}
		// set to MIB. try to delete it first to avoid duplicate case
		apmib_set(del_id, pEntry);
		if ( apmib_set(add_id, pEntry) == 0) {
			strcpy(tmpBuf, T("Add table entry error!"));
			goto setErr_filter;
		}
	}


	/* Delete entry */
	if (strDelACPC[0] || strDelURLB[0] || strDelDMZ[0] || strDelPort[0] || strDelIp[0] || strDelMac[0] || strDelSRout[0]) {
		if ( !apmib_get(num_id, (void *)&entryNum)) {
			strcpy(tmpBuf, T("Get entry number error!"));
			goto setErr_filter;
		}
		for (i=entryNum; i>0; i--) {
			snprintf(tmpBuf, 20, "select%d", i);

			strVal = websGetVar(wp, tmpBuf, T(""));
			if ( !gstrcmp(strVal, T("ON")) ) {

				*((char *)pEntry) = (char)i;
				if ( !apmib_get(get_id, pEntry)) {
					strcpy(tmpBuf, T("Get table entry error!"));
					goto setErr_filter;
				}
				if ( !apmib_set(del_id, pEntry)) {
					strcpy(tmpBuf, T("Delete table entry error!"));
					goto setErr_filter;
				}
			}
		}
	}

	/* Delete all entry */
	if (strDelAllACPC[0] || strDelAllURLB[0] || strDelAllDMZ[0] || strDelAllPort[0] || strDelAllIp[0] || strDelAllMac[0] || strDelAllSRout[0]) {
		if ( !apmib_set(delall_id, pEntry)) {
			strcpy(tmpBuf, T("Delete all table error!"));
			goto setErr_filter;
		}
	}
setOk_filter:
	apmib_update(CURRENT_SETTING);

#ifndef NO_ACTION
/*	pid = fork();
        if (pid) {
	      	waitpid(pid, NULL, 0);
	}
        else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _FIREWALL_SCRIPT_PROG);
		execl( tmpBuf, _FIREWALL_SCRIPT_PROG, NULL);
               	exit(1);
        }*/
	system("/bin/firewall.sh");
#endif

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
	if (submitUrl[0])
		websRedirect(wp, submitUrl);
	else
		websDone(wp, 200);
  	return;
setErr_filter:
	ERR_MSG(tmpBuf);
  	return;
}
/////////////////////////////////////////////////////////////////////////////
void formTriggerPort(webs_t wp, char_t *path, char_t *query)
{
	char_t *strAddPort, *strDelAllPort, *strDelPort, *strVal, *submitUrl;
	char_t *strTriFrom, *strTriTo, *strIncFrom, *strIncTo, *strComment;
	char tmpBuf[100];
	int entryNum, intVal, i;
	TRIGGERPORT_T entry;
/*#ifndef NO_ACTION
	int pid;
#endif*/

//	char *ptr, *ptr2, *ptr3;
//	int	i;

	memset(&entry, '\0', sizeof(entry));

		strVal = websGetVar(wp, T("enabled"), T(""));
		if ( !gstrcmp(strVal, T("ON")))
			intVal = 1;
		else
			intVal = 0;
		if ( apmib_set(MIB_TRIGGERPORT_ENABLED, (void *)&intVal) == 0) {
			strcpy(tmpBuf, T("Set enabled flag error!"));
			goto setErr_triPort;
		}

	/* Add port filter */
	strAddPort = websGetVar(wp, T("addPort"), T(""));
	if (strAddPort[0]) {
		strTriFrom = websGetVar(wp, T("triFromPort"), T(""));
		strTriTo = websGetVar(wp, T("triToPort"), T(""));
		strIncFrom = websGetVar(wp, T("incFromPort"), T(""));
		strIncTo = websGetVar(wp, T("incToPort"), T(""));
		strComment = websGetVar(wp, T("comment"), T(""));

		if (!strTriFrom[0] && !strTriTo[0] && !strIncFrom[0] &&
					!strIncTo[0] && !strComment[0])
			goto setOk_triPort;

		// get trigger port range and protocol
		if (!strTriFrom[0]) { // from port must exist
			strcpy(tmpBuf, T("Error! No from-port value to be set."));
			goto setErr_triPort;
		}
		if ( !string_to_dec(strTriFrom, &intVal) || intVal<1 || intVal>65535) {
			strcpy(tmpBuf, T("Error! Invalid value of trigger from-port."));
			goto setErr_triPort;
		}
		entry.tri_fromPort = (unsigned short)intVal;

		if ( !strTriTo[0] )
			entry.tri_toPort = entry.tri_fromPort;
		else {
			if ( !string_to_dec(strTriTo, &intVal) || intVal<1 || intVal>65535) {
				strcpy(tmpBuf, T("Error! Invalid value of trigger to-port."));
				goto setErr_triPort;
			}
			entry.tri_toPort = (unsigned short)intVal;
		}

		if ( entry.tri_fromPort  > entry.tri_toPort) {
			strcpy(tmpBuf, T("Error! Invalid trigger port range."));
			goto setErr_triPort;
		}
		if ( (entry.tri_fromPort<=6112)&&(entry.tri_toPort>=6112) ) {////////////////
			strcpy(tmpBuf, T("Error! 6112 port will conflict with Starcraft game."));
			goto setErr_triPort;
		}

		strVal = websGetVar(wp, T("triProtocol"), T(""));
		if (strVal[0]) {
			if ( strVal[0] == '0' ) {
				if (strAddPort[0])
					entry.tri_protoType = PROTO_BOTH;
				else
					entry.tri_protoType = PROTO_BOTH;
			}
			else if ( strVal[0] == '1' ) {
				if (strAddPort[0])
					entry.tri_protoType = PROTO_TCP;
				else
					entry.tri_protoType = PROTO_TCP;
			}
			else if ( strVal[0] == '2' ) {
				if (strAddPort[0])
					entry.tri_protoType = PROTO_UDP;
				else
					entry.tri_protoType = PROTO_UDP;
			}
			else {
				strcpy(tmpBuf, T("Error! Invalid trigger-port protocol type."));
				goto setErr_triPort;
			}
		}
		else {
			strcpy(tmpBuf, T("Error! trigger-port protocol type cannot be empty."));
			goto setErr_triPort;
		}
/////////////////////////////////////////////////////////////////////////////////////////////
{
	char *ptr, *ptr2, *ptr3;
	int	i;
	
	ptr = strIncFrom;
	//while(1)
	for (i=0;i<5; i++)	{
		if ((ptr2 = strchr(ptr, ',')) != NULL) {
			*ptr2 = '\0';
			ptr2 ++;
		}
		
		if ((ptr3 = strchr(ptr, '-')) != NULL) {
			*ptr3 = '\0';
			ptr3 ++;
					
			if ((!(entry.inc_fromPort[i][0] = atoi(ptr))) || (entry.inc_fromPort[i][0] < 1) || (entry.inc_fromPort[i][0] >65536)) {
				strcpy(tmpBuf, T("Error! Invalid value of  form-port."));
				goto setErr_triPort;
			}
			if ((!(entry.inc_fromPort[i][1]=atoi(ptr3))) || (entry.inc_fromPort[i][1] < 1) || (entry.inc_fromPort[i][1] >65536))  {
				strcpy(tmpBuf, T("Error! Invalid value of  to-port."));
				goto setErr_triPort;
			}
			if (entry.inc_fromPort[i][0] > entry.inc_fromPort[i][1]) {
				strcpy(tmpBuf, T("Invalid port range! 1st port value should be less than 2nd value"));
				goto setErr_triPort;
			}
		}
		else 
				entry.inc_fromPort[i][0]=entry.inc_fromPort[i][1]=atol(ptr);
				if (i>0)	
					if (entry.inc_fromPort[i-1][1] > entry.inc_fromPort[i][1])  {
						strcpy(tmpBuf, T("Error!"));
						goto setErr_triPort;
					}
	if ((entry.inc_fromPort[i][0]<=6112) && (entry.inc_fromPort[i][1]>=6112))	 {
			strcpy(tmpBuf, T("Error! 6112 port will conflict with Starcraft game."));
			goto setErr_triPort;
		}
	//					printf("ERROR Port[%d]>Port[%d]\n",i,(i+1));
	//	printf("TTT%d-%d\n",entry.inc_fromPort[i][0],entry.inc_fromPort[i][1]);
		if( ptr2 == NULL)
			break;
		ptr = ptr2;
	}
}
//////////////////////////////////////////////////////////////////////////////////////////////
		strVal = websGetVar(wp, T("incProtocol"), T(""));
		if (strVal[0]) {
			if ( strVal[0] == '0' ) {
				if (strAddPort[0])
					entry.inc_protoType = PROTO_BOTH;
				else
					entry.inc_protoType = PROTO_BOTH;
			}
			else if ( strVal[0] == '1' ) {
				if (strAddPort[0])
					entry.inc_protoType = PROTO_TCP;
				else
					entry.inc_protoType = PROTO_TCP;
			}
			else if ( strVal[0] == '2' ) {
				if (strAddPort[0])
					entry.inc_protoType = PROTO_UDP;
				else
					entry.inc_protoType = PROTO_UDP;
			}
			else {
				strcpy(tmpBuf, T("Error! Invalid incoming-port protocol type."));
				goto setErr_triPort;
			}
		}
		else {
			strcpy(tmpBuf, T("Error! incoming-port protocol type cannot be empty."));
			goto setErr_triPort;
		}

		// get comment
		if ( strComment[0] ) {
			if (strlen(strComment) > COMMENT_LEN-1) {
				strcpy(tmpBuf, T("Error! Comment length too long."));
				goto setErr_triPort;
			}
			strcpy(entry.comment, strComment);
		}

		// get entry number to see if it exceeds max
		if ( !apmib_get(MIB_TRIGGERPORT_NUM, (void *)&entryNum)) {
			strcpy(tmpBuf, T("Get entry number error!"));
			goto setErr_triPort;
		}
		if ( (entryNum + 1) > MAX_FILTER_NUM) {
			strcpy(tmpBuf, T("Cannot add new entry because table is full!"));
			goto setErr_triPort;
		}
		
		// Check if there is any port overlapped
		for (i=1; i<=entryNum; i++) {
			TRIGGERPORT_T checkEntry;
			*((char *)&checkEntry) = (char)i;
			if ( !apmib_get(MIB_TRIGGERPORT, (void *)&checkEntry)) {
				strcpy(tmpBuf, T("Get table entry error!"));
				goto setErr_triPort;
			}
			if ( ( (entry.tri_fromPort <= checkEntry.tri_fromPort &&
					entry.tri_toPort >= checkEntry.tri_fromPort) ||
			       (entry.tri_fromPort >= checkEntry.tri_fromPort &&
				entry.tri_fromPort <= checkEntry.tri_toPort)
			     )&&
			       (entry.tri_protoType & checkEntry.tri_protoType) ) {
				strcpy(tmpBuf, T("Trigger port range has overlapped with used port numbers!"));
				goto setErr_triPort;
			}
		}

		// set to MIB. try to delete it first to avoid duplicate case
		apmib_set(MIB_TRIGGERPORT_DEL, (void *)&entry);
		if ( apmib_set(MIB_TRIGGERPORT_ADD, (void *)&entry) == 0) {
			strcpy(tmpBuf, T("Add table entry error!"));
			goto setErr_triPort;
		}
	}
	/* Delete entry */
	strDelPort = websGetVar(wp, T("deleteSelPort"), T(""));
	if (strDelPort[0]) {
		if ( !apmib_get(MIB_TRIGGERPORT_NUM, (void *)&entryNum)) {
			strcpy(tmpBuf, T("Get entry number error!"));
			goto setErr_triPort;
		}
		for (i=entryNum; i>0; i--) {
			snprintf(tmpBuf, 20, "select%d", i);

			strVal = websGetVar(wp, tmpBuf, T(""));
			if ( !gstrcmp(strVal, T("ON")) ) {

				*((char *)&entry) = (char)i;
				if ( !apmib_get(MIB_TRIGGERPORT, (void *)&entry)) {
					strcpy(tmpBuf, T("Get table entry error!"));
					goto setErr_triPort;
				}
				if ( !apmib_set(MIB_TRIGGERPORT_DEL, (void *)&entry)) {
					strcpy(tmpBuf, T("Delete table entry error!"));
					goto setErr_triPort;
				}
			}
		}
	}
//}
	/* Delete all entry */
	strDelAllPort = websGetVar(wp, T("deleteAllPort"), T(""));
	if ( strDelAllPort[0]) {
		if ( !apmib_set(MIB_TRIGGERPORT_DELALL, (void *)&entry)) {
			strcpy(tmpBuf, T("Delete all table error!"));
			goto setErr_triPort;
		}
	}

setOk_triPort:
	apmib_update(CURRENT_SETTING);

#ifndef NO_ACTION
/*	pid = fork();
        if (pid) {
	      	waitpid(pid, NULL, 0);
	}
        else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _FIREWALL_SCRIPT_PROG);
		execl( tmpBuf, _FIREWALL_SCRIPT_PROG, NULL);
               	exit(1);
        }*/
	system("/bin/firewall.sh");
#endif

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
	if (submitUrl[0])
		websRedirect(wp, submitUrl);
	else
		websDone(wp, 200);
  	return;

setErr_triPort:
	ERR_MSG(tmpBuf);
  	return;
}



/////////////////////////////////////////////////////////////////////////////
void formDMZ(webs_t wp, char_t *path, char_t *query)
{
	char_t *submitUrl, *strSave, *strVal, *strEnabled;
	char tmpBuf[100];
	int intVal;
	struct in_addr ipAddr, curIpAddr, curSubnet;
	unsigned long v1, v2, v3;
/*#ifndef NO_ACTION
	int pid;
#endif*/
	strSave = websGetVar(wp, T("save"), T(""));
	strEnabled = websGetVar(wp, T("enabled"), T(""));
//	if (strEnabled[0]) {
		if ( !gstrcmp(strEnabled, T("ON")))
			intVal = 1;
		else
			intVal = 0;
		
		if ( apmib_set(MIB_DMZ_ENABLED, (void *)&intVal) == 0) {
			strcpy(tmpBuf, T("Set enabled flag error!"));
			goto setErr_dmz;
		}

		strVal = websGetVar(wp, T("ip"), T(""));
		if (!strVal[0]) {
			goto setOk_dmz;
		}
		inet_aton(strVal, &ipAddr);
		getInAddr(BRIDGE_IF, IP_ADDR, (void *)&curIpAddr);
		getInAddr(BRIDGE_IF, SUBNET_MASK, (void *)&curSubnet);

		v1 = *((unsigned long *)&ipAddr);
		v2 = *((unsigned long *)&curIpAddr);
		v3 = *((unsigned long *)&curSubnet);
		if (v1) {
			if ( (v1 & v3) != (v2 & v3) ) {
				strcpy(tmpBuf, T("Invalid IP address! It should be set within the current subnet."));
				goto setErr_dmz;
			}
		}
		if ( apmib_set(MIB_DMZ_HOST, (void *)&ipAddr) == 0) {
			strcpy(tmpBuf, T("Set DMZ MIB error!"));
			goto setErr_dmz;
		}
//	}
	PROC_MSG();
setOk_dmz:
	apmib_update(CURRENT_SETTING);

#ifndef NO_ACTION
/*	pid = fork();
        if (pid) {
	      	waitpid(pid, NULL, 0);
	}
        else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _FIREWALL_SCRIPT_PROG);
		execl( tmpBuf, _FIREWALL_SCRIPT_PROG, NULL);
               	exit(1);
        }*/
	system("/bin/firewall.sh");
#endif

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
	if (submitUrl[0])
		websRedirect(wp, submitUrl);
	else
		websDone(wp, 200);
  	return;

	
//	OK_MSG(submitUrl);

//  	return;

setErr_dmz:
	ERR_MSG(tmpBuf);
}


/////////////////////////////////////////////////////////////////////////////
int portFwList(int eid, webs_t wp, int argc, char_t **argv)
{
	int	nBytesSent=0, entryNum, i;
	PORTFW_T entry;
	char	*type, portRange[20], *ip;

	if ( !apmib_get(MIB_PORTFW_NUM, (void *)&entryNum)) {
  		websError(wp, 400, T("Get table entry error!\n"));
		return -1;
	}

/*	nBytesSent += websWrite(wp, T("<tr>"
      	"<td align=center width=\"35%%\" class=\"stable\"><font size=\"2\">Private IP</font></td>\n"
      	"<td align=center width=\"20%%\" class=\"stable\"><font size=\"2\">Type</font></td>\n"
      	"<td align=center width=\"20%%\" class=\"stable\"><font size=\"2\">Port Range</font></td>\n"
	"<td align=center width=\"20%%\" class=\"stable\"><font size=\"2\"><b>Comment</b></font></td>\n"
      	"<td align=center width=\"5%%\" class=\"stable\"><font size=\"2\"><b>Select</b></font></td></tr>\n"));
*/
	for (i=1; i<=entryNum; i++) {
		*((char *)&entry) = (char)i;
		if ( !apmib_get(MIB_PORTFW, (void *)&entry))
			return -1;

		ip = inet_ntoa(*((struct in_addr *)entry.ipAddr));
		if ( !strcmp(ip, "0.0.0.0"))
			ip = "----";

		if ( entry.protoType == PROTO_BOTH )
			type = "TCP+UDP";
		else if ( entry.protoType == PROTO_TCP )
			type = "TCP";
		else
			type = "UDP";

		if ( entry.fromPort == 0)
			strcpy(portRange, "----");
		else if ( entry.fromPort == entry.toPort )
			snprintf(portRange, 20, "%d", entry.fromPort);
		else
			snprintf(portRange, 20, "%d-%d", entry.fromPort, entry.toPort);

		nBytesSent += websWrite(wp, T("<tr>"
		"<td align=center width=\"35%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
		"<td align=center width=\"20%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
		"<td align=center width=\"20%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
		"<td align=center width=\"20%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
		"<td align=center width=\"5%%\" class=\"table2\"><input type=\"checkbox\" name=\"select%d\" value=\"ON\"></td></tr>\n"),
				ip, type, portRange, entry.comment, i);
	}
	return nBytesSent;
}


/////////////////////////////////////////////////////////////////////////////
int portFilterList(int eid, webs_t wp, int argc, char_t **argv)
{
	int	nBytesSent=0, entryNum, i;
	PORTFILTER_T entry;
	char	*type, portRange[20];

	if ( !apmib_get(MIB_PORTFILTER_NUM, (void *)&entryNum)) {
  		websError(wp, 400, T("Get table entry error!\n"));
		return -1;
	}

	nBytesSent += websWrite(wp, T("<tr>"
      	"<td align=center width=\"30%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Port Range</b></font></td>\n"
      	"<td align=center width=\"25%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Protocol</b></font></td>\n"
	"<td align=center width=\"30%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Comment</b></font></td>\n"
      	"<td align=center width=\"15%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Select</b></font></td></tr>\n"));

	for (i=1; i<=entryNum; i++) {
		*((char *)&entry) = (char)i;
		if ( !apmib_get(MIB_PORTFILTER, (void *)&entry))
			return -1;

		if ( entry.protoType == PROTO_BOTH )
			type = "TCP+UDP";
		else if ( entry.protoType == PROTO_TCP )
			type = "TCP";
		else
			type = "UDP";

		if ( entry.fromPort == 0)
			strcpy(portRange, "----");
		else if ( entry.fromPort == entry.toPort )
			snprintf(portRange, 20, "%d", entry.fromPort);
		else
			snprintf(portRange, 20, "%d-%d", entry.fromPort, entry.toPort);

		nBytesSent += websWrite(wp, T("<tr>"
			"<td align=center width=\"30%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
   			"<td align=center width=\"25%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
     			"<td align=center width=\"30%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
      			"<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><input type=\"checkbox\" name=\"select%d\" value=\"ON\"></td></tr>\n"),
				portRange, type, entry.comment, i);
	}
	return nBytesSent;
}


/////////////////////////////////////////////////////////////////////////////
int StcRoutList(int eid, webs_t wp, int argc, char_t **argv)
{
	int	nBytesSent=0, entryNum, i;
	SROUT_T entry;
	char *ip, *mask, *gateway, *interface, ipBuf[20], maskBuf[20];

	if ( !apmib_get(MIB_SROUT_NUM, (void *)&entryNum)) {
  		websError(wp, 400, T("Get table entry error!\n"));
		return -1;
	}

/*	nBytesSent += websWrite(wp, T("<tr>"
	"<td align=center width='25%%' class='stable'><font size='2'>Destination LAN IP</font></td>\n"
	"<td align=center width='25%%' class='stable'><font size='2'>Subnet Mask</font></td>\n"
	"<td align=center width='25%%' class='stable'><font size='2'>Default Gateway</font></td>\n"
	"<td align=center width='10%%' class='stable'><font size='2'>Hop Count</font></td>\n"
	"<td align=center width='10%%' class='stable'><font size='2'>Interface</font></td>\n"
	"<td align=center width='5%%' class='stable'><font size='2'>Select</font></td></tr>\n"));
*/
	for (i=1; i<=entryNum; i++) {
		*((char *)&entry) = (char)i;
		if ( !apmib_get(MIB_SROUT, (void *)&entry))
			return -1;

		ip = inet_ntoa(*((struct in_addr *)entry.ipAddr));
		if ( !strcmp(ip, "0.0.0.0"))
			ip = "----";
		sprintf(ipBuf," %s", ip);

		mask = inet_ntoa(*((struct in_addr *)entry.maskAddr));
		if ( !strcmp(mask, "0.0.0.0"))
			mask = "----";
		sprintf(maskBuf," %s", mask);

		gateway = inet_ntoa(*((struct in_addr *)entry.gatewayAddr));
		if ( !strcmp(gateway, "0.0.0.0"))
			gateway = "----";
		
		if ( entry.interface ==0 )
			interface = "LAN";
		else
			interface = "WAN";
		
		nBytesSent += websWrite(wp, T("<tr>"
		"<td align=center width='25%%' class='table2'><font size='2'>%s</td>\n"
		"<td align=center width='25%%' class='table2'><font size='2'>%s</td>\n"
		"<td align=center width='25%%' class='table2'><font size='2'>%s</td>\n"
		"<td align=center width='10%%' class='table2'><font size='2'>%d</td>\n"
		"<td align=center width='10%%' class='table2'><font size='2'>%s</td>\n"
		"<td align=center width='5%%' class='table2'><input type='checkbox' name='select%d' value='ON'></td></tr>\n"),
				ipBuf, maskBuf, gateway, entry.hopCount, interface, i);
	}
	return nBytesSent;
}

/////////////////////////////////////////////////////////////////////////////
int DMZList(int eid, webs_t wp, int argc, char_t **argv)
{
	int	nBytesSent=0, entryNum, i;
	DMZ_T entry;
	char	 *pIp, *cIp, buf[20];

	int k, l;
	FILE *fp;
	char staTbl[7][20], staFile[15]={"/tmp/w1.ip"};

	if ((fp = fopen( staFile ,"r")) != NULL) {
		for (k=0; k<7; k++) {
			fgets(staTbl[k], 20, fp);
			for(l=0; l<20; l++) {
				if(staTbl[k][l]=='\n') {
					staTbl[k][l]='\0';
					break;
				}
			}
		}
		fclose(fp);
	}

	if ( !apmib_get(MIB_DMZ_NUM, (void *)&entryNum)) {
  		websError(wp, 400, T("Get table entry error!\n"));
		return -1;
	}


	for (i=1; i<=entryNum; i++) {
		*((char *)&entry) = (char)i;
		if ( !apmib_get(MIB_DMZ, (void *)&entry))
			return -1;

		pIp = inet_ntoa(*((struct in_addr *)entry.pipAddr));
		if ( !strcmp(pIp, "0.0.0.0")) {
			if (fopen( staFile ,"r") == NULL)
				pIp = "----";
			else
				pIp = staTbl[entry.session-1];
		}
		sprintf(buf," %s", pIp);

		cIp = inet_ntoa(*((struct in_addr *)entry.cipAddr));
		if ( !strcmp(cIp, "0.0.0.0"))
			cIp = "----";
		
		nBytesSent += websWrite(wp, T("<tr>"
		"<td align=center width=\"40%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
		"<td align=center width=\"40%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
		"<td align=center width=\"20%%\" class=\"table2\"><input type=\"checkbox\" name=\"select%d\" value=\"ON\"></td></tr>\n"),
				buf, cIp, i);
	}
	return nBytesSent;
}


/////////////////////////////////////////////////////////////////////////////
int ACPCList(int eid, webs_t wp, int argc, char_t **argv)
{
	int	nBytesSent=0, entryNum, i;
	ACPC_T entry;
	char	*type, *sip, *eip;
	char	Range[100], Index[20], tmpRange[20];
	char	serName[500], buf[20];
	
	if ( !apmib_get(MIB_ACPC_NUM, (void *)&entryNum)) {
  		websError(wp, 400, T("Get table entry error!\n"));
		return -1;
	}

/*	nBytesSent += websWrite(wp, T("<tr>"
      	"<td align=center width=\"8%%\" class=\"stable\"><font size=\"2\">Client PC Description</font></td>\n"
      	"<td align=center width=\"15%%\" class=\"stable\"><font size=\"2\">Client PC IP Address</font></td>\n"
      	"<td align=center width=\"48%%\" class=\"stable\"><font size=\"2\">Client Service</font></td>\n"
      	"<td align=center width=\"8%%\" class=\"stable\"><font size=\"2\">Protocol</font></td>\n"
      	"<td align=center width=\"16%%\" class=\"stable\"><font size=\"2\"> Port Range</font></td>\n"
      	"<td align=center width=\"5%%\" class=\"stable\"><font size=\"2\">Select</font></td></tr>\n"));
*/
	for (i=1; i<=entryNum; i++) {
		*((char *)&entry) = (char)i;
		if ( !apmib_get(MIB_ACPC, (void *)&entry))
			return -1;

		sip = inet_ntoa(*((struct in_addr *)entry.sipAddr));
		if ( !strcmp(sip, "0.0.0.0"))
			sip = "----";
			sprintf(buf,"%s", sip);
		
		eip = inet_ntoa(*((struct in_addr *)entry.eipAddr));
		if ( !strcmp(sip,eip)) {
			eip = "";
			strcat(buf,eip);
		}
		else {
			strcat(buf,"-");
			strcat(buf,eip);
		}
		
		if ( entry.protoType == PROTO_BOTH )
			type = "TCP+UDP";
		else if ( entry.protoType == PROTO_TCP )
			type = "TCP";
		else
			type = "UDP";
//---------------------------------------------------------------------------------------
			snprintf(Index, 20, "%lu", entry.serindex);
		memset(serName,0,sizeof(serName));
		if (entry.serindex & 1 ) strncat(serName,"WWW",3); 
		if (entry.serindex & 2 ) strncat(serName,", E-mail Sending",16); 
		if (entry.serindex & 4 ) strncat(serName,", News Forums",13); 
		if (entry.serindex & 8 ) strncat(serName,", E-mail Receiving",18); 
		if (entry.serindex & 16 ) strncat(serName,", Secure HTTP",13); 
		if (entry.serindex & 32 ) strncat(serName,", File Transfer",15); 
		if (entry.serindex & 64 ) strncat(serName,", MSN Messenger",15); 
		if (entry.serindex & 128 ) strncat(serName,", Telnet Service",16); 
		if (entry.serindex & 256 ) strncat(serName,", AIM",5); 
		if (entry.serindex & 512 ) strncat(serName,", NetMeeting",12); 
		if (entry.serindex & 1024 ) strncat(serName,", DNS",5); 
		if (entry.serindex & 2048 ) strncat(serName,", SNMP",6); 
		if (entry.serindex & 4096 ) strncat(serName,", VPN-PPTP",10); 
		if (entry.serindex & 8192 ) strncat(serName,", VPN-L2TP",10); 
		if (entry.serindex & 16384 ) strncat(serName,", TCP",5); 
		if (entry.serindex & 32768 ) strncat(serName,", UDP",5); 
		if (serName[0]== ',') serName[0]= ' ';
//------------------------------------------------------------------------------------------
{
		int j;

		memset(Range,0,sizeof(Range));
		for (j=0 ; j<5 ; j++)
		{
			if ( entry.Port[j][0] != 0)
			{
				if ( entry.Port[j][0] == entry.Port[j][1] )
					snprintf(tmpRange, 20, "%d", entry.Port[j][0]);
				else
					snprintf(tmpRange, 20, "%d-%d", entry.Port[j][0], entry.Port[j][1]);
				if(j != 0)
					strcat(Range, ", ");
				strcat(Range, tmpRange);
			}
		}
}
//-----------------------------------------------------------------------------------------

			
		nBytesSent += websWrite(wp, T("<tr>"
	"<td align=center width=\"10%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
	"<td align=center width=\"15%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
	"<td align=center width=\"50%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
	"<td align=center width=\"8%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
	"<td align=center width=\"12%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
	"<td align=center width=\"5%%\" class=\"table2\"><input type=\"checkbox\" name=\"select%d\" value=\"ON\"></td></tr>\n"),
		entry.comment, buf, serName, type, Range, i);
	}
	return nBytesSent;
}


/////////////////////////////////////////////////////////////////////////////
int ipFilterList(int eid, webs_t wp, int argc, char_t **argv)
{
	int	nBytesSent=0, entryNum, i;
	IPFILTER_T entry;
	char	*type, *ip;

	if ( !apmib_get(MIB_IPFILTER_NUM, (void *)&entryNum)) {
  		websError(wp, 400, T("Get table entry error!\n"));
		return -1;
	}

	nBytesSent += websWrite(wp, T("<tr>"
      	"<td align=center width=\"30%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Local IP Address</b></font></td>\n"
      	"<td align=center width=\"25%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Protocol</b></font></td>\n"
      	"<td align=center width=\"25%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Comment</b></font></td>\n"
      	"<td align=center width=\"20%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Select</b></font></td></tr>\n"));

	for (i=1; i<=entryNum; i++) {
		*((char *)&entry) = (char)i;
		if ( !apmib_get(MIB_IPFILTER, (void *)&entry))
			return -1;

		ip = inet_ntoa(*((struct in_addr *)entry.ipAddr));
		if ( !strcmp(ip, "0.0.0.0"))
			ip = "----";

		if ( entry.protoType == PROTO_BOTH )
			type = "TCP+UDP";
		else if ( entry.protoType == PROTO_TCP )
			type = "TCP";
		else
			type = "UDP";

		nBytesSent += websWrite(wp, T("<tr>"
			"<td align=center width=\"30%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
      			"<td align=center width=\"25%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
      			"<td align=center width=\"25%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
      			"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><input type=\"checkbox\" name=\"select%d\" value=\"ON\"></td></tr>\n"),
				ip, type, entry.comment, i);
	}
	return nBytesSent;
}


/////////////////////////////////////////////////////////////////////////////
int URLBList(int eid, webs_t wp, int argc, char_t **argv)
{
	int nBytesSent=0, entryNum, i;
	URLB_T entry;

	if ( !apmib_get(MIB_URLB_NUM, (void *)&entryNum)) {
  		websError(wp, 400, T("Get table entry error!\n"));
		return -1;
	}

/*	nBytesSent += websWrite(wp, T("<tr>"
      	"<td align=center width=\"70%%\" class=\"stable\"><font size=\"2\">URL/Keyword</font></td>\n"
      	"<td align=center width=\"20%%\" class=\"stable\"><font size=\"2\"><b>Select</b></font></td></tr>\n"));
*/
	for (i=1; i<=entryNum; i++) {
		*((char *)&entry) = (char)i;
		if ( !apmib_get(MIB_URLB, (void *)&entry))
			return -1;


		nBytesSent += websWrite(wp, T("<tr>"
		"<td align=center width=\"70%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
		"<td align=center width=\"20%%\" class=\"table2\"><input type=\"checkbox\" name=\"select%d\" value=\"ON\"></td></tr>\n"),
				entry.URLBAddr, i);
	}
	return nBytesSent;
}

/////////////////////////////////////////////////////////////////////////////
int macFilterList(int eid, webs_t wp, int argc, char_t **argv)
{
	int nBytesSent=0, entryNum, i;
	MACFILTER_T entry;
	char tmpBuf[100];

	if ( !apmib_get(MIB_MACFILTER_NUM, (void *)&entryNum)) {
  		websError(wp, 400, T("Get table entry error!\n"));
		return -1;
	}

/*	nBytesSent += websWrite(wp, T("<tr>"
      	"<td align=center width=\"50%%\" class=\"stable\"><font size=\"2\">Client PC MAC Address</font></td>\n"
      	"<td align=center width=\"30%%\" class=\"stable\"><font size=\"2\">Comment</font></td>\n"
      	"<td align=center width=\"20%%\" class=\"stable\"><font size=\"2\">Select</font></td></tr>\n"));
*/
	for (i=1; i<=entryNum; i++) {
		*((char *)&entry) = (char)i;
		if ( !apmib_get(MIB_MACFILTER, (void *)&entry))
			return -1;

		snprintf(tmpBuf, 100, T("%02x:%02x:%02x:%02x:%02x:%02x"),
			entry.macAddr[0], entry.macAddr[1], entry.macAddr[2],
			entry.macAddr[3], entry.macAddr[4], entry.macAddr[5]);

		nBytesSent += websWrite(wp, T("<tr>"
			"<td align=center width=\"50%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
      			"<td align=center width=\"30%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
       			"<td align=center width=\"20%%\" class=\"table2\"><input type=\"checkbox\" name=\"select%d\" value=\"ON\"></td></tr>\n"),
				tmpBuf, entry.comment, i);
	}
	return nBytesSent;
}

/////////////////////////////////////////////////////////////////////////////
int triggerPortList(int eid, webs_t wp, int argc, char_t **argv)
{

	int	nBytesSent=0, entryNum, i;
	TRIGGERPORT_T entry;
	char	*triType, triPortRange[20], *incType, Range[100], tmpRange[20];

	if ( !apmib_get(MIB_TRIGGERPORT_NUM, (void *)&entryNum)) {
  		websError(wp, 400, T("Get table entry error!\n"));
		return -1;
	}

/*	nBytesSent += websWrite(wp, T("<tr>"
      	"<td align=center width=\"16%%\" class=\"stable\"><font size=\"2\"><b>Trigger Port</b></font></td>\n"
      	"<td align=center width=\"12%%\" class=\"stable\"><font size=\"2\"><b>Trigger Type</b></font></td>\n"
     	"<td align=center width=\"40%%\" class=\"stable\"><font size=\"2\"><b>Public Port</b></font></td>\n"
      	"<td align=center width=\"12%%\" class=\"stable\"><font size=\"2\"><b>Public Type</b></font></td>\n"
	"<td align=center width=\"15%%\" class=\"stable\"><font size=\"2\"><b>Comment</b></font></td>\n"
      	"<td align=center width=\"5%%\" class=\"stable\"><font size=\"2\"><b>Select</b></font></td></tr>\n"));
*/

#if 0
	nBytesSent += websWrite(wp, T("<tr>"
	"<td align=center width=\"25%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Trigger-port Range</b></font></td>\n"
      	"<td align=center width=\"15%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Trigger-port Protocol</b></font></td>\n")
	"<td align=center width=\"25%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Incoming-port Range</b></font></td>\n"
      	"<td align=center width=\"15%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Incoming-port Protocol</b></font></td>\n"	
	"<td align=center width=\"14%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Comment</b></font></td>\n"
      	"<td align=center width=\"6%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Select</b></font></td></tr>\n"));

#endif
	for (i=1; i<=entryNum; i++) {
		*((char *)&entry) = (char)i;
		if ( !apmib_get(MIB_TRIGGERPORT, (void *)&entry))
			return -1;

		if ( entry.tri_protoType == PROTO_BOTH )
			triType = "TCP+UDP";
		else if ( entry.tri_protoType == PROTO_TCP )
			triType = "TCP";
		else
			triType = "UDP";

		if ( entry.tri_fromPort == 0)
			strcpy(triPortRange, "----");
		else if ( entry.tri_fromPort == entry.tri_toPort )
			snprintf(triPortRange, 20, "%d", entry.tri_fromPort);
		else
			snprintf(triPortRange, 20, "%d-%d", entry.tri_fromPort, entry.tri_toPort);

		if ( entry.inc_protoType == PROTO_BOTH )
			incType = "TCP+UDP";
		else if ( entry.inc_protoType == PROTO_TCP )
			incType = "TCP";
		else
			incType = "UDP";
//------------------------------------------------------------------------
{
		int j;

		memset(Range,0,sizeof(Range));
		for (j=0 ; j<5 ; j++)
		{
			if ( entry.inc_fromPort[j][0] != 0)
			{
				if ( entry.inc_fromPort[j][0] == entry.inc_fromPort[j][1] )
					snprintf(tmpRange, 20, "%d", entry.inc_fromPort[j][0]);
				else
					snprintf(tmpRange, 20, "%d-%d", entry.inc_fromPort[j][0], entry.inc_fromPort[j][1]);
				if(j != 0)
					strcat(Range, ",");
				strcat(Range, tmpRange);
			}
		}
		
		nBytesSent += websWrite(wp, T("<tr>"
		"<td align=center width=\"16%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
		"<td align=center width=\"12%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
		"<td align=center width=\"40%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
		"<td align=center width=\"12%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
		"<td align=center width=\"15%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
		"<td align=center width=\"5%%\" class=\"table2\"><input type=\"checkbox\" name=\"select%d\" value=\"ON\"></td></tr>\n"),
				triPortRange, triType, Range, incType, entry.comment, i);
}
	}
	return nBytesSent;
}

#endif // HOME_GATEWAY

