/*
 *      Web server handler routines for get info and index (getinfo(), getindex())
 *
 *      Authors: David Hsu	<davidhsu@realtek.com.tw>
 *
 *      $Id: fmget.c,v 1.18 2004/03/12 10:36:12 erwin Exp $
 *
 */

#include <string.h>
#include <stdlib.h>
#include <time.h>

#include "../webs.h"
#include "apmib.h"
#include "apform.h"
#include "utility.h"

#define FW_VERSION	fwVersion

extern char *fwVersion;	// defined in version.c
#ifdef HOME_GATEWAY
char staTbl[7][30];
#endif
/////////////////////////////////////////////////////////////////////////////
int getInfo(int eid, webs_t wp, int argc, char_t **argv)
{
	char_t	*name;
	struct in_addr	intaddr;
	struct sockaddr hwaddr;
	unsigned char *pMacAddr;
	unsigned long sec, mn, hr, day, longVal;
	unsigned char buffer[100];
	int intVal;
 	struct user_net_device_stats stats;
	DHCP_T dhcp;
	bss_info bss;
#ifdef HOME_GATEWAY
	char_t *iface;
#endif
   	if (ejArgs(argc, argv, T("%s"), &name) < 1) {
   		websError(wp, 400, T("Insufficient args\n"));
   		return -1;
   	}

   	if ( !strcmp(name, T("uptime"))) 
	{
		FILE* fpt;
		char buffer[100]={0};
		int i;
        if ((fpt = fopen("/proc/uptime","r"))!=NULL)
        {
	        fgets(buffer,100, fpt);
			for( i=0; i<100; i++ )
			{
				if( buffer[i] == '.' )
					buffer[i] = 0;
				if( (buffer[i] == 0) || (buffer[i] == ' ') )
					break;
			}
			fclose(fpt);
			sec = atoi(buffer);
		}   
		else
			sec = (unsigned long) time(NULL);
	
		day = sec / 86400;

#ifdef _RTL8181_     // busybox 1.02 don't need this
//        day -= 10957; 		// day counted from 1970-2000
#endif
		sec %= 86400;
		hr = sec / 3600;
		sec %= 3600;
		mn = sec / 60;
		sec %= 60;

		return websWrite(wp, T("%dday:%dh:%dm:%ds"),
							day, hr, mn, sec);
	}
   	else if ( !strcmp(name, T("clientnum"))) {
		apmib_get( MIB_WLAN_DISABLED, (void *)&intVal);
		if (intVal == 1)	// disable
			intVal = 0;
		else {
			if ( getWlStaNum(WLAN_IF, &intVal) < 0)
			intVal = 0;
		}
		sprintf(buffer, "%d", intVal );
		return websWrite(wp, buffer);
	}
//#if defined(_6104IPC_) | defined(_7207APS_)
   	else if ( !strcmp(name, T("ipnClientNum"))) {
		apmib_get( MIB_WLAN_DISABLED, (void *)&intVal);
		if (intVal == 1)	// disable
			intVal = 0;
		else {
			WLAN_IPN_STA_Tp pInfo;
			char *buff;
			int i;
			intVal=0;

			buff = calloc(1, sizeof(WLAN_IPN_STA_T) * (MAX_STA_NUM+1));
			if ( buff == 0 ) {
				printf("Allocate buffer failed!\n");
			}
			if ( getInprocommWlSta(WLAN_IF,  (WLAN_IPN_STA_Tp)buff ) < 0 ) {
				printf("Read wlan sta info failed!\n");
			}
			for (i=0; i<=MAX_STA_NUM; i++) {
				pInfo = (WLAN_IPN_STA_Tp)&buff[i*sizeof(WLAN_IPN_STA_T)];
				if (pInfo->aid)
					intVal++;
			}
		}
		sprintf(buffer, "%d", intVal );
		return websWrite(wp, buffer);
	}
//#endif
//************************************ Status and Information ************************************
	else if ( !strcmp(name, T("fwVersion"))) {
		FILE *fp;
		if ((fp = fopen("/etc/version","r"))!=NULL) {
			fgets(buffer, 30, fp);
			fclose(fp);
   			return websWrite(wp, buffer);
		}else {
   			return websWrite(wp, "final version");
		}
	}
   	if ( !strcmp(name, T("systime")) ) {		//Erwin Add 09.23 
		FILE* fpt;
		char *rdptr, buffer[100]={0};
		system("date +%D > timetmp.txt");	
		system("date +%T >> timetmp.txt");	
        if ((fpt = fopen("./timetmp.txt","r"))!=NULL)
        {
			fread(buffer, 1, 100, fpt);
			if ( (rdptr = strchr(buffer, '\n'))!=NULL)
				*rdptr = ' ';
			fclose(fpt);
			system("rm -f ./timetmp.txt");
		}
   		return websWrite(wp, buffer);
	}
//************************************ Wireless basic Setting *************************************
	else if ( !strcmp(name, T("name")) ) {
		buffer[0]='\0';
		if ( !apmib_get(MIB_ALIAS_NAME,  (void *)buffer) )
			return -1;
   		return websWrite(wp, buffer);
	}
   	else if ( !strcmp(name, T("ssid"))) {
		if ( !apmib_get( MIB_WLAN_SSID,  (void *)buffer) )
			return -1;

   		return websWrite(wp, buffer);
	}
//************************************ Wireless Information *************************************
	else if ( !strcmp(name, T("bssid_drv"))) {
		if ( getWlBssInfo(WLAN_IF, &bss) < 0)
			return websWrite(wp, "bssid_drv");		//Erwin Modify 04.09
//			return -1;
		return websWrite(wp, T("%02x:%02x:%02x:%02x:%02x:%02x"), bss.bssid[0], bss.bssid[1],
				bss.bssid[2], bss.bssid[3], bss.bssid[4], bss.bssid[5]);
	}
	else if ( !strcmp(name, T("ssid_drv"))) {
		if ( getWlBssInfo(WLAN_IF, &bss) < 0)
			return websWrite(wp, "ssid_drv");		//Erwin Modify 04.09
//			return -1;
		return websWrite(wp, T("%s"), bss.ssid);
	}
	else if ( !strcmp(name, T("state_drv"))) {
		char *pMsg;
		if ( getWlBssInfo(WLAN_IF, &bss) < 0)
			return websWrite(wp, "state_drv");		//Erwin Modify 04.09
//			return -1;
		switch (bss.state) {
		case STATE_DISABLED:
			pMsg = T("Disabled");
			break;
		case STATE_IDLE:
			pMsg = T("Idle");
			break;
		case STATE_STARTED:
			pMsg = T("Started");
			break;
		case STATE_CONNECTED:
			pMsg = T("Connected");
			break;
		case STATE_SCANNING:
			pMsg = T("Scanning");
			break;
		default:
			pMsg=NULL;
		}
		return websWrite(wp, T("%s"), pMsg);
	}
	else if ( !strcmp(name, T("channel_drv"))) {
		if ( getWlBssInfo(WLAN_IF, &bss) < 0)
			return websWrite(wp, "channel_drv");		//Erwin Modify 04.09
//			return -1;

		if (bss.channel)
			sprintf(buffer, "%d", bss.channel);
		else
			buffer[0] = '\0';

		return websWrite(wp, T("%s"), buffer);
	}
   	else if ( !strcmp(name, T("channel"))) {
		if ( !apmib_get( MIB_WLAN_CHAN_NUM,  (void *)&intVal) )
			return -1;
		if (intVal==0)
			sprintf(buffer, "%s", "auto" );
		else	
			sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
   	else if ( !strcmp(name, T("wep"))) {
   		WEP_T wep;
		if ( !apmib_get( MIB_WLAN_WEP,  (void *)&wep) )
			return -1;

		if ( wep == WEP_DISABLED )
			strcpy( buffer, T("Disabled") );
		else if ( wep == WEP64 )
			strcpy( buffer, T("64bits") );
		else if ( wep == WEP128)
			strcpy( buffer, T("128bits") );
   		return websWrite(wp, buffer);
   	}
  	else if ( !strcmp(name, T("ip"))) {
		if ( getInAddr(BRIDGE_IF, IP_ADDR, (void *)&intaddr ) )
			return websWrite(wp, T("%s"), inet_ntoa(intaddr) );
		else
			return websWrite(wp, T("0.0.0.0"));
	}


#ifdef HOME_GATEWAY
	else if ( !strcmp(name, T("hostpassword")) ) {	//no use
		buffer[0]='\0';
		if ( !apmib_get(MIB_USER_PASSWORD,  (void *)buffer) )
			return -1;
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("sysMode"))) {	//no use
		if ( !apmib_get( MIB_SYS_MODE, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
//**************************************** Time Zone ****************************************
	else if ( !strcmp(name, T("TimeZoneSel"))) {
		if ( !apmib_get( MIB_TIME_ZONE_SEL, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("startMonth"))) {
		if ( !apmib_get( MIB_START_MONTH, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("startDay"))) {
		if ( !apmib_get( MIB_START_DAY, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("endMonth"))) {
		if ( !apmib_get( MIB_END_MONTH, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("endDay"))) {
		if ( !apmib_get( MIB_END_DAY, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("TimeServerAddr"))) {
		if ( !apmib_get(MIB_TIMESERVER_ADDR,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
//************************************** Remote Management **************************************
	else if ( !strcmp(name, T("reManHostAddr"))) {
		if ( !apmib_get(MIB_REMANHOST_ADDR,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
	else if ( !strcmp(name, T("reManPort"))) {
		if ( !apmib_get( MIB_REMAN_PORT, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}	
//**************************************** Dynamic Ip ****************************************
	else if ( !strcmp(name, T("dynIPHostName")) ) {
		buffer[0]='\0';
		if ( !apmib_get(MIB_DYNIP_HOSTNAME,  (void *)buffer) )
			return -1;
		return websWrite(wp, T("%s"), buffer);
	}
	else if ( !strcmp(name, T("wanMac"))) {
		if ( !apmib_get(MIB_WAN_MAC_ADDR,  (void *)buffer) )
			return -1;
		return websWrite(wp, T("%02x%02x%02x%02x%02x%02x"), buffer[0], buffer[1],
						buffer[2], buffer[3], buffer[4], buffer[5]);
	}
	else if ( !strcmp(name, T("cloneMac"))) {
		int i;
		FILE *fp;
		char *ptr;
		char buf[100]={0},macaddr[20]={0},comment[50]={0};
		sprintf(comment,"cat /proc/net/arp | grep %s >abc.txt",wp->ipaddr);
		system(comment);
		if ((fp = fopen("abc.txt","r"))!=NULL)
		{
			fgets(buf,100, fp);
			for (i=0;i<=1;i++) {
				if ((ptr = strchr(buf, ' ')) != NULL) 
					while (*ptr == ' ' ) ptr++;
				sprintf(buf,"%s",ptr);
			}
			fclose(fp);
			system("rm -f abc.txt");
			snprintf(macaddr, 18, "%s", ptr);
		}
		for (i=0;i<=5;i++) {
			if ((ptr = strchr(macaddr, ':')) != NULL) {
				*ptr='\0';
				ptr++;
				strcat(macaddr,ptr);
			}
		}
		if (!strcmp(macaddr,"(null)"))
			return websWrite(wp, T("%s"), "000000000000");
		else
			return websWrite(wp, T("%s"), macaddr);
	}
//**************************************** Static Ip ****************************************
	else if ( !strcmp(name, T("wan-ip-rom"))) {
		if ( !apmib_get( MIB_WAN_IP_ADDR,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
   	else if ( !strcmp(name, T("wan-mask-rom"))) {
		if ( !apmib_get( MIB_WAN_SUBNET_MASK,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
   	else if ( !strcmp(name, T("wan-gateway-rom"))) {
		if ( !apmib_get( MIB_WAN_DEFAULT_GATEWAY,  (void *)buffer) )
			return -1;
		if (!memcmp(buffer, "\x0\x0\x0\x0", 4))
			return websWrite(wp, T("0.0.0.0"));
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
//**************************************** PPPoE Setting ****************************************
   	else if ( !strcmp(name, T("pppServName"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_PPP_SERVNAME,  (void *)buffer) )
			return -1;
		return websWrite(wp, T("%s"), buffer);
	}
	else if ( !strcmp(name, T("pppMTU"))) {
		if ( !apmib_get( MIB_PPP_MTU, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
   	else if ( !strcmp(name, T("pppUserName"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_PPP_USER,  (void *)buffer) )
			return -1;
		return websWrite(wp, T("%s"), buffer);
	}
  	else if ( !strcmp(name, T("pppPassword"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_PPP_PASSWORD,  (void *)buffer) )
			return -1;
		return websWrite(wp, T("%s"), buffer);
	}
   	else if ( !strcmp(name, T("wan-ppp-idle"))) {
		if ( !apmib_get( MIB_PPP_IDLE_TIME,  (void *)&intVal) )
			return -1;

		sprintf(buffer, "%d", intVal/60 );
   		return websWrite(wp, buffer);
	}
//**************************************** PPTP Setting ****************************************
	else if ( !strcmp(name, T("pptpIPAddr"))) {
		if ( !apmib_get(MIB_PPTPIP_ADDR,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
	else if ( !strcmp(name, T("pptpIPMaskAddr"))) {
		if ( !apmib_get(MIB_PPTPIPMAKE_ADDR,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
	else if ( !strcmp(name, T("pptpDfGateway"))) {
		if ( !apmib_get(MIB_PPTPDFGATEWAY,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
	else if ( !strcmp(name, T("pptpGateway"))) {
		if ( !apmib_get(MIB_PPTPGATEWAY,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
   	else if ( !strcmp(name, T("pptpUserName"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_PPTP_USER,  (void *)buffer) )
			return -1;
		return websWrite(wp, T("%s"), buffer);
	}
  	else if ( !strcmp(name, T("pptpPassword"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_PPTP_PASSWORD,  (void *)buffer) )
			return -1;
		return websWrite(wp, T("%s"), buffer);
	}
   	else if ( !strcmp(name, T("wan-pptp-idle"))) {
		if ( !apmib_get( MIB_PPTP_IDLE_TIME,  (void *)&intVal) )
			return -1;

		sprintf(buffer, "%d", intVal/60 );
   		return websWrite(wp, buffer);
	}
   	else if ( !strcmp(name, T("pptpConntID"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_PPTP_CONNT_ID,  (void *)buffer) )
			return -1;
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("pptpMTU"))) {
		if ( !apmib_get( MIB_PPTP_MTU, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
//**************************************** L2TP Setting ****************************************
	else if ( !strcmp(name, T("L2TPIPAddr"))) {
		if ( !apmib_get(MIB_L2TP_IP_ADDR,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
	else if ( !strcmp(name, T("L2TPMaskAddr"))) {
		if ( !apmib_get(MIB_L2TP_MAKEADDR,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
	else if ( !strcmp(name, T("L2TPDefGateway"))) {
		if ( !apmib_get(MIB_L2TP_DEFGATEWAY,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
  	else if ( !strcmp(name, T("L2TPGateway"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_L2TP_GATEWAY,  (void *)buffer) )
			return -1;
   		return websWrite(wp, buffer);
	}



	
/*	else if ( !strcmp(name, T("L2TPGateway"))) {
		if ( !apmib_get(MIB_L2TP_GATEWAY,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}*/
   	else if ( !strcmp(name, T("L2TPUserName"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_L2TP_USER,  (void *)buffer) )
			return -1;
		return websWrite(wp, T("%s"), buffer);
	}
  	else if ( !strcmp(name, T("L2TPPassword"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_L2TP_PASSWORD,  (void *)buffer) )
			return -1;
		return websWrite(wp, T("%s"), buffer);
	}
   	else if ( !strcmp(name, T("L2TPIdleTime"))) {
		if ( !apmib_get( MIB_L2TP_IDLE_TIME,  (void *)&intVal) )
			return -1;

		sprintf(buffer, "%d", intVal/60 );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("L2TPMTU"))) {
		if ( !apmib_get( MIB_L2TP_MTU, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
//************************************** TelStra Big Pond **************************************
	else if ( !strcmp(name, T("telBPIPAddr"))) {
		if ( !apmib_get(MIB_TELBPIP_ADDR,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
   	else if ( !strcmp(name, T("telBPUserName"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_TELBP_USER,  (void *)buffer) )
			return -1;
		return websWrite(wp, T("%s"), buffer);
	}
  	else if ( !strcmp(name, T("telBPPassword"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_TELBP_PASSWORD,  (void *)buffer) )
			return -1;
		return websWrite(wp, T("%s"), buffer);
	}
//*********************************** Application layer gateway ***********************************
	else if ( !strcmp(name, T("appLayerGateway"))) {
		if ( !apmib_get( MIB_APP_LAYER_GATEWAY, (void *)&longVal) )
			return -1;
		sprintf(buffer, "%lu", longVal );
   		return websWrite(wp, buffer);
	}
//**************************************** DDNS Setting ****************************************
   	else if ( !strcmp(name, T("ddnsName"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_DDNS_NAME,  (void *)buffer) )
			return -1;
   		return websWrite(wp, buffer);
	}
   	else if ( !strcmp(name, T("ddnspvidSel"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_DDNS_PVIDSEL,  (void *)buffer) )
			return -1;
   		return websWrite(wp, buffer);
	}
   	else if ( !strcmp(name, T("ddnsAccount"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_DDNS_ACCOUNT,  (void *)buffer) )
			return -1;
   		return websWrite(wp, buffer);
	}
  	else if ( !strcmp(name, T("ddnsPass"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_DDNS_PASS,  (void *)buffer) )
			return -1;
   		return websWrite(wp, buffer);
	}
   	else if ( !strcmp(name, T("ddnsTempSel"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_DDNS_TEMPSEL,  (void *)buffer) )
			return -1;
   		return websWrite(wp, buffer);
	}
//************************************** DDNS DHIS Setting **************************************
	else if ( !strcmp(name, T("dhisHostID"))) {
		if ( !apmib_get( MIB_DHIS_HOSTID, (void *)&longVal) )
			return -1;
		sprintf(buffer, "%lu", longVal );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("dhisISAddr"))) {
		if ( !apmib_get(MIB_DHIS_ISADDR,  (void *)buffer) )
			return -1;
// 		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) ); // Lance 2003.11.05
   		return websWrite(wp, buffer);
	}
  	else if ( !strcmp(name, T("dhispass"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_DHIS_PASSWORD,  (void *)buffer) )
			return -1;
   		return websWrite(wp, buffer);
	}
  	else if ( !strcmp(name, T("dhisAuthP1"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_DHIS_AUTH_P1,  (void *)buffer) )
			return -1;
   		return websWrite(wp, buffer);
	}
  	else if ( !strcmp(name, T("dhisAuthP2"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_DHIS_AUTH_P2,  (void *)buffer) )
			return -1;
   		return websWrite(wp, buffer);
	}
  	else if ( !strcmp(name, T("dhisAuthQ1"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_DHIS_AUTH_Q1,  (void *)buffer) )
			return -1;
   		return websWrite(wp, buffer);
	}
  	else if ( !strcmp(name, T("dhisAuthQ2"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_DHIS_AUTH_Q2,  (void *)buffer) )
			return -1;
   		return websWrite(wp, buffer);
	}
//**************************************** DoS ****************************************
	else if ( !strcmp(name, T("podPack"))) {
		if ( !apmib_get( MIB_POD_PACK, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("podBur"))) {
		if ( !apmib_get( MIB_POD_BUR, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("synPack"))) {
		if ( !apmib_get( MIB_SYN_PACK, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("synBur"))) {
		if ( !apmib_get( MIB_SYN_BUR, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("scanNum"))) {
		if ( !apmib_get( MIB_SCAN_NUM, (void *)&longVal) )
			return -1;
		sprintf(buffer, "%lu", longVal );
   		return websWrite(wp, buffer);
	}
#endif
//////////////////////////////////////////////////////////////////////////////////////////////
   	else if ( !strcmp(name, T("mask"))) {
		if ( getInAddr(BRIDGE_IF, SUBNET_MASK, (void *)&intaddr ))
			return websWrite(wp, T("%s"), inet_ntoa(intaddr) );
		else
			return websWrite(wp, T("0.0.0.0"));
	}
   	else if ( !strcmp(name, T("gateway"))) {
#ifdef HOME_GATEWAY
		DHCP_T dhcp;
  		apmib_get( MIB_DHCP, (void *)&dhcp);
		if ( dhcp == DHCP_SERVER ) {
		// if DHCP server, default gateway is set to LAN IP
			if ( getInAddr(BRIDGE_IF, IP_ADDR, (void *)&intaddr ) )
				return websWrite(wp, T("%s"), inet_ntoa(intaddr) );
			else
				return websWrite(wp, T("0.0.0.0"));
		}
		else
#endif

		if ( getDefaultRoute(BRIDGE_IF, &intaddr) )
			return websWrite(wp, T("%s"), inet_ntoa(intaddr) );
		else
			return websWrite(wp, T("0.0.0.0"));
	}
//**************************************** LAN Setting****************************************
	else if ( !strcmp(name, T("ip-rom"))) {
		if ( !apmib_get( MIB_IP_ADDR,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
   	else if ( !strcmp(name, T("mask-rom"))) {
		if ( !apmib_get( MIB_SUBNET_MASK,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
	else if ( !strcmp(name, T("gateway-rom"))) {	
		if ( !apmib_get( MIB_DEFAULT_GATEWAY,  (void *)buffer) )
			return -1;
		if (!memcmp(buffer, "\x0\x0\x0\x0", 4))
			return websWrite(wp, T("0.0.0.0"));
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
   	else if ( !strcmp(name, T("dhcpRangeStart"))) {
		if ( !apmib_get( MIB_DHCP_CLIENT_START,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
  	else if ( !strcmp(name, T("dhcpRangeEnd"))) {
		if ( !apmib_get( MIB_DHCP_CLIENT_END,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
	else if ( !strcmp(name, T("leaseTime"))) {
		if ( !apmib_get( MIB_LAN_LEASETIME, (void *)&longVal) )
			return -1;
		sprintf(buffer, "%lu", longVal );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("DhcpGatewayIP"))) {
		if ( !apmib_get(MIB_DHCPGATEWAYIP_ADDR,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}

	else if ( !strcmp(name, T("DhcpNameServerIP"))) {
		if ( !apmib_get(MIB_DHCPNAMESERVER_ADDR,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
   	if ( !strcmp(name, T("DomainName")) ) {
		buffer[0]='\0';
		if ( !apmib_get(MIB_DOMAIN_NAME,  (void *)buffer) )
			return -1;
   		return websWrite(wp, buffer);
	}
//***************************************************************************

												
 	else if ( !strcmp(name, T("dhcp-current")) ) {
   		if ( !apmib_get( MIB_DHCP, (void *)&dhcp) )
			return -1;

		if (dhcp==DHCP_CLIENT) {
			if (!isDhcpClientExist(BRIDGE_IF) &&
					!getInAddr(BRIDGE_IF, IP_ADDR, (void *)&intaddr))
				return websWrite(wp, T("Getting IP from DHCP server..."));
			if (isDhcpClientExist(BRIDGE_IF))
				return websWrite(wp, T("DHCP"));
		}
		return websWrite(wp, T("Fixed IP"));
	}

#ifdef  HOME_GATEWAY
  	else if ( !strcmp(name, T("wan-ip"))) {
  		if ( !apmib_get( MIB_WAN_DHCP, (void *)&dhcp) )
			return -1;
		if ( dhcp == PPPOE) {
			iface = PPPOE_IF;
			if ( !isConnectPPP() )
				iface = NULL;
		}
		else
			iface = WAN_IF;
		if ( iface && getInAddr(iface, IP_ADDR, (void *)&intaddr ) )
			return websWrite(wp, T("%s"), inet_ntoa(intaddr) );
		else
			return websWrite(wp, T("0.0.0.0"));
	}
   	else if ( !strcmp(name, T("wan-mask"))) {
		if ( !apmib_get( MIB_WAN_DHCP, (void *)&dhcp) )
			return -1;
		if ( dhcp == PPPOE) {
			iface = PPPOE_IF;
			if ( !isConnectPPP() )
				iface = NULL;
		}
		else
			iface = WAN_IF;

		if ( iface && getInAddr(iface, SUBNET_MASK, (void *)&intaddr ))
			return websWrite(wp, T("%s"), inet_ntoa(intaddr) );
		else
			return websWrite(wp, T("0.0.0.0"));
	}
   	else if ( !strcmp(name, T("wan-gateway"))) {
		if ( !apmib_get( MIB_WAN_DHCP, (void *)&dhcp) )
			return -1;
		if ( dhcp == PPPOE) {
			iface = PPPOE_IF;
			if ( !isConnectPPP() )
				iface = NULL;
		}
		else
			iface = WAN_IF;
		if ( iface && getDefaultRoute(iface, &intaddr) )
			return websWrite(wp, T("%s"), inet_ntoa(intaddr) );
		else
			return websWrite(wp, T("0.0.0.0"));
	}
	else if ( !strcmp(name, T("wan-hwaddr"))) {
		if ( getInAddr(WAN_IF, HW_ADDR, (void *)&hwaddr ) ) {
			pMacAddr = hwaddr.sa_data;
			return websWrite(wp, T("%02x:%02x:%02x:%02x:%02x:%02x"), pMacAddr[0], pMacAddr[1],
				pMacAddr[2], pMacAddr[3], pMacAddr[4], pMacAddr[5]);
		}
		else
			return websWrite(wp, T("00:00:00:00:00:00"));
	}
//**************************************** DDNS Setting ****************************************
  	else if ( !strcmp(name, T("wan-dns1"))) {
		if ( !apmib_get( MIB_WAN_DNS1,  (void *)buffer) )
			return -1;
		if (!memcmp(buffer, "\x0\x0\x0\x0", 4))
			return websWrite(wp, T(""));
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
  	else if ( !strcmp(name, T("wan-dns2"))) {
		if ( !apmib_get( MIB_WAN_DNS2,  (void *)buffer) )
			return -1;
		if (!memcmp(buffer, "\x0\x0\x0\x0", 4))
			return websWrite(wp, T(""));
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
  	else if ( !strcmp(name, T("wan-dns3"))) {
		if ( !apmib_get( MIB_WAN_DNS3,  (void *)buffer) )
			return -1;
		if (!memcmp(buffer, "\x0\x0\x0\x0", 4))
			return websWrite(wp, T(""));
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
 	else if ( !strcmp(name, T("wanDhcp-current")) ) {
   		if ( !apmib_get( MIB_WAN_DHCP, (void *)&dhcp) )
			return -1;
		if ( dhcp == DHCP_CLIENT) {
		 	if (!isDhcpClientExist(WAN_IF))
				return websWrite(wp, T("Getting IP from DHCP server..."));
			else
				return websWrite(wp, T("DHCP"));
		}
		else if ( dhcp == DHCP_DISABLED )
			return websWrite(wp, T("Fixed IP"));
		else if ( dhcp ==  PPPOE ) {
			if ( isConnectPPP())
				return websWrite(wp, T("PPPoE Connected"));
			else
				return websWrite(wp, T("PPPoE Disconnected"));
		}
	}
 	else if ( !strcmp(name, T("dmzHost"))) {
		if ( !apmib_get( MIB_DMZ_HOST,  (void *)buffer) )
			return -1;
		if (!memcmp(buffer, "\x0\x0\x0\x0", 4))
			return websWrite(wp, T(""));
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
//**************************************** System Log ****************************************
	else if ( !strcmp(name, T("syslog"))) {
		FILE *fp1;
		system("/bin/syslog.sh");
		if ((fp1 = fopen("/var/log/syslog","r"))!=NULL) {
			while (fgets(buffer, 100, fp1) > 0)
				websWrite(wp, T("%s"), buffer);
		fclose(fp1);
		}
		return 0;
	}
//**************************************** Security Log ****************************************
	else if ( !strcmp(name, T("seclog"))) {
		FILE *fp1;
		system("/bin/seclog.sh");
		if ((fp1 = fopen("/var/log/security","r"))!=NULL) {
			while (fgets(buffer, 100, fp1) > 0)
				websWrite(wp, T("%s"), buffer);
		fclose(fp1);
		}
		return 0;
	}
//************************************** Internet Connection **************************************
	else if ( !strcmp(name, T("sta-current"))) {
		int k;
		FILE *fp1;
		system("wan-status.sh");
		if ((fp1 = fopen("/var/run/wanstat","r"))!=NULL) {
			for (k=0;k<7;k++) {
				fgets(staTbl[k], 30, fp1);
			}
		fclose(fp1);
		}
		return websWrite(wp, T("%s"), staTbl[0]);
	}else if ( !strcmp(name, T("sta-ip"))) //Erwin modify 17.09
		return websWrite(wp, T("%s"), staTbl[1]);
	else if ( !strcmp(name, T("sta-mask"))) 
		return websWrite(wp, T("%s"), staTbl[2]);
	else if ( !strcmp(name, T("sta-gateway"))) {
		if ( getDefaultRoute(BRIDGE_IF, &intaddr) )
			return websWrite(wp, T("%s"), inet_ntoa(intaddr) );
		else
			return websWrite(wp, T("0.0.0.0"));
	}
	else if ( !strcmp(name, T("sta-mac"))) 
		return websWrite(wp, T("%s"), staTbl[3]);
	else if ( !strcmp(name, T("sta-dns1"))) 
		return websWrite(wp, T("%s"), staTbl[4]);
	else if ( !strcmp(name, T("sta-dns2"))) 
		return websWrite(wp, T("%s"), staTbl[5]);
	//-----------------------------------------------------------------------------
#endif
	else if ( !strcmp(name, T("hwaddr"))) {
		if ( getInAddr(BRIDGE_IF, HW_ADDR, (void *)&hwaddr ) ) {
			pMacAddr = hwaddr.sa_data;
			return websWrite(wp, T("%02x:%02x:%02x:%02x:%02x:%02x"), pMacAddr[0], pMacAddr[1],
				pMacAddr[2], pMacAddr[3], pMacAddr[4], pMacAddr[5]);
		}
		else
			return websWrite(wp, T("00:00:00:00:00:00"));
	}
	else if ( !strcmp(name, T("bridgeMac"))) {
		if ( !apmib_get(MIB_ELAN_MAC_ADDR,  (void *)buffer) )
			return -1;
		return websWrite(wp, T("%02x%02x%02x%02x%02x%02x"), buffer[0], buffer[1],
						buffer[2], buffer[3], buffer[4], buffer[5]);
	}

	/* Advance setting stuffs */
//******************************wireless setting for inprocomm ******************************	
  	else if ( !strcmp(name, T("wlanTranRate"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_WLAN_TRAN_RATE,  (void *)buffer) )
			return -1;
   		return websWrite(wp, buffer);
	}
//*********************************** Wireless Advance Setting ***********************************
	else if ( !strcmp(name, T("fragThreshold"))) {
		if ( !apmib_get( MIB_WLAN_FRAG_THRESHOLD, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("rtsThreshold"))) {
		if ( !apmib_get( MIB_WLAN_RTS_THRESHOLD, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("beaconInterval"))) {
		if ( !apmib_get( MIB_WLAN_BEACON_INTERVAL, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("dtimPeriod"))) {
		if ( !apmib_get( MIB_WLAN_DTIM_PERIOD, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("model"))) {
#ifdef _6104WB_
  	return websWrite(wp, "0");
#elif _6104WG_
  	return websWrite(wp, "1");
#elif _6104K_
	return websWrite(wp, "2");
#elif _6104WBB_
	return websWrite(wp, "3");
#endif
	}
// TODO: Following counter need to get from driver in the future
	else if ( !strcmp(name, T("lanTxPacketNum"))) {
		if ( getStats(ELAN_IF, &stats) < 0)
			stats.tx_packets = 0;
		sprintf(buffer, "%d", (int)stats.tx_packets);
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("lanRxPacketNum"))) {
		if ( getStats(ELAN_IF, &stats) < 0)
			stats.rx_packets = 0;
		sprintf(buffer, "%d", (int)stats.rx_packets);
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("wlanTxPacketNum"))) {
		if ( getStats(WLAN_IF, &stats) < 0)
			stats.tx_packets = 0;
		sprintf(buffer, "%d", (int)stats.tx_packets);
   		return websWrite(wp, buffer);

	}
	else if ( !strcmp(name, T("wlanRxPacketNum"))) {
		if ( getStats(WLAN_IF, &stats) < 0)
			stats.rx_packets = 0;
		sprintf(buffer, "%d", (int)stats.rx_packets);
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("bssid"))) {
		apmib_get( MIB_WLAN_DISABLED, (void *)&intVal);
		if ( intVal == 0 &&  getInAddr(WLAN_IF, HW_ADDR, (void *)&hwaddr ) ) {
			pMacAddr = hwaddr.sa_data;
			return websWrite(wp, T("%02x:%02x:%02x:%02x:%02x:%02x"), pMacAddr[0], pMacAddr[1],
				pMacAddr[2], pMacAddr[3], pMacAddr[4], pMacAddr[5]);
		}
		else
			return websWrite(wp, T("00:00:00:00:00:00"));
	}
//************************************** Wireless WDS **************************************
	else if ( !strcmp(name, T("wlLinkMac1"))) {
		if ( !apmib_get(MIB_WL_LINKMAC1,  (void *)buffer) )
			return -1;
		return websWrite(wp, T("%02x%02x%02x%02x%02x%02x"), buffer[0], buffer[1],
						buffer[2], buffer[3], buffer[4], buffer[5]);
	}
	else if ( !strcmp(name, T("wlLinkMac2"))) {
		if ( !apmib_get(MIB_WL_LINKMAC2,  (void *)buffer) )
			return -1;
		return websWrite(wp, T("%02x%02x%02x%02x%02x%02x"), buffer[0], buffer[1],
						buffer[2], buffer[3], buffer[4], buffer[5]);
	}
	else if ( !strcmp(name, T("wlLinkMac3"))) {
		if ( !apmib_get(MIB_WL_LINKMAC3,  (void *)buffer) )
			return -1;
		return websWrite(wp, T("%02x%02x%02x%02x%02x%02x"), buffer[0], buffer[1],
						buffer[2], buffer[3], buffer[4], buffer[5]);
	}
	else if ( !strcmp(name, T("wlLinkMac4"))) {
		if ( !apmib_get(MIB_WL_LINKMAC4,  (void *)buffer) )
			return -1;
		return websWrite(wp, T("%02x%02x%02x%02x%02x%02x"), buffer[0], buffer[1],
						buffer[2], buffer[3], buffer[4], buffer[5]);
	}
	else if ( !strcmp(name, T("wlLinkMac5"))) {
		if ( !apmib_get(MIB_WL_LINKMAC5,  (void *)buffer) )
			return -1;
		return websWrite(wp, T("%02x%02x%02x%02x%02x%02x"), buffer[0], buffer[1],
						buffer[2], buffer[3], buffer[4], buffer[5]);
	}
	else if ( !strcmp(name, T("wlLinkMac6"))) {
		if ( !apmib_get(MIB_WL_LINKMAC6,  (void *)buffer) )
			return -1;
		return websWrite(wp, T("%02x%02x%02x%02x%02x%02x"), buffer[0], buffer[1],
						buffer[2], buffer[3], buffer[4], buffer[5]);
	}
//-----------------------------------------------------------------------------------------
#ifdef HOME_GATEWAY
	else if ( !strcmp(name, T("wanTxPacketNum"))) {
		if ( getStats(WAN_IF, &stats) < 0)
			stats.tx_packets = 0;
		sprintf(buffer, "%d", (int)stats.tx_packets);
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("wanRxPacketNum"))) {
		if ( getStats(WAN_IF, &stats) < 0)
			stats.rx_packets = 0;
		sprintf(buffer, "%d", (int)stats.rx_packets);
   		return websWrite(wp, buffer);
	}
	// Lance 2004.2.10
    else if ( !strcmp(name, T("PSName")) ) {
        buffer[0]='\0';
        if ( !apmib_get(MIB_PS_NAME,  (void *)buffer) )
            return -1;
        return websWrite(wp, buffer);
    }
	// Lance 2004.2.16
    else if ( !strcmp(name, T("PS_Port1Name")) ) {
        buffer[0]='\0';
        if ( !apmib_get(MIB_PS_PORT1NAME,  (void *)buffer) )
            return -1;
        return websWrite(wp, buffer);
    }
    else if ( !strcmp(name, T("PS_Port2Name")) ) {
        buffer[0]='\0';
        if ( !apmib_get(MIB_PS_PORT2NAME,  (void *)buffer) )
            return -1;
        return websWrite(wp, buffer);
    }
#endif


#ifdef WLAN_WPA
	else if ( !strcmp(name, T("rsIp"))) {
		if ( !apmib_get( MIB_WLAN_RS_IP,  (void *)buffer) )
			return -1;
		if (!memcmp(buffer, "\x0\x0\x0\x0", 4))
			return websWrite(wp, T(""));
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
	else if ( !strcmp(name, T("rsPort"))) {
		if ( !apmib_get( MIB_WLAN_RS_PORT, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
 	else if ( !strcmp(name, T("rsPassword"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_WLAN_RS_PASSWORD,  (void *)buffer) )
			return -1;
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("accountRsIp"))) {
		if ( !apmib_get( MIB_WLAN_ACCOUNT_RS_IP,  (void *)buffer) )
			return -1;
		if (!memcmp(buffer, "\x0\x0\x0\x0", 4))
			return websWrite(wp, T(""));
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
	else if ( !strcmp(name, T("accountRsPort"))) {
		if ( !apmib_get( MIB_WLAN_ACCOUNT_RS_PORT, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("accountRsPassword"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_WLAN_ACCOUNT_RS_PASSWORD,  (void *)buffer) )
			return -1;
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("groupRekeyTime"))) {
		if ( !apmib_get( MIB_WLAN_WPA_GROUP_REKEY_TIME, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("groupRekeyTimeDay"))) {
		if ( !apmib_get( MIB_WLAN_WPA_GROUP_REKEY_TIME, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal/86400 );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("groupRekeyTimeHr"))) {
		if ( !apmib_get( MIB_WLAN_WPA_GROUP_REKEY_TIME, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", (intVal%86400)/3600 );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("groupRekeyTimeMin"))) {
		if ( !apmib_get( MIB_WLAN_WPA_GROUP_REKEY_TIME, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", ((intVal%86400)%3600)/60 );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("groupRekeyTimeSec"))) {
		if ( !apmib_get( MIB_WLAN_WPA_GROUP_REKEY_TIME, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", ((intVal%86400)%3600)%60 );
   		return websWrite(wp, buffer);
	}
 	else if ( !strcmp(name, T("pskValue"))) {
		int i;
		buffer[0]='\0';
		if ( !apmib_get(MIB_WLAN_WPA_PSK,  (void *)buffer) )
			return -1;
		for (i=0; i<strlen(buffer); i++)
			buffer[i]='*';
		buffer[i]='\0';
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("accountRsUpdateDelay"))) {
		if ( !apmib_get( MIB_WLAN_ACCOUNT_UPDATE_DELAY, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("rsInterval"))) {
		if ( !apmib_get( MIB_WLAN_RS_INTERVAL_TIME, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("accountRsInterval"))) {
		if ( !apmib_get( MIB_WLAN_ACCOUNT_RS_INTERVAL_TIME, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
#endif

 	return -1;
}

/////////////////////////////////////////////////////////////////////////////
int getIdValue(id, eid) {
	char_t buffer[50];
	int val;
	if ( !apmib_get( id, (void *)&val) )
		return -1;
	sprintf(buffer, "%d", val);
	ejSetResult(eid, buffer);
	return 0;
}
/////////////////////////////////////////////////////////////////////////////
int getIndex(int eid, webs_t wp, int argc, char_t **argv)
{
	char_t *name, buffer[50];
	int chan, val;
	REG_DOMAIN_T domain;
	WEP_T wep;
	DHCP_T dhcp;

   	if (ejArgs(argc, argv, T("%s"), &name) < 1) {
   		websError(wp, 400, T("Insufficient args\n"));
   		return -1;
   	}

   	if ( !strcmp(name, T("dhcp")) ) {
 		if ( !apmib_get( MIB_DHCP, (void *)&dhcp) )
			return -1;
		sprintf(buffer, "%d", (int)dhcp);
		ejSetResult(eid, buffer);
		return 0;
	}

	else if ( !strcmp(name, T("Edimax"))) {
		if ( getIdValue( MIB_WLAN_WDS_WEP, eid ) == 0 )
			return 0;
		else
			return -1;
	}
  	else if ( !strcmp(name, T("dhcp-current")) ) {
   		if ( !apmib_get( MIB_DHCP, (void *)&dhcp) )
			return -1;
		if ( dhcp == DHCP_CLIENT && !isDhcpClientExist(BRIDGE_IF))
			dhcp = DHCP_DISABLED;
		sprintf(buffer, "%d", (int)dhcp);
		ejSetResult(eid, buffer);
		return 0;
	}
 	else if ( !strcmp(name, T("stp")) ) {
   		if ( !apmib_get( MIB_STP_ENABLED, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
   	if ( !strcmp(name, T("licence")) ) {
 		if ( !apmib_get( MIB_LICENCE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", (int)val);
		ejSetResult(eid, buffer);
		return 0;
	}
//**************************************** WEP of WDS ****************************************	
	else if ( !strcmp(name, T("wdsWep"))) {
		if ( !apmib_get( MIB_WLAN_WDS_WEP, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("wdsDefaultKeyId"))) {
		if ( !apmib_get( MIB_WLAN_WDS_WEP_DEFAULT_KEY, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", ++val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("wdsKeyType")) ) {
		if ( !apmib_get( MIB_WLAN_WDS_WEP_KEY_TYPE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", (int)val) ;
		 ejSetResult(eid, buffer);
		return 0;
	}
//******************************wireless setting for inprocomm ******************************	
	else if ( !strcmp(name, T("wlanRateMode")) ) {
		if ( !apmib_get( MIB_WLAN_RATE_MODE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", (int)val) ;
		 ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("wlanCts")) ) {
		if ( !apmib_get( MIB_WLAN_CTS, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", (int)val) ;
		 ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("wlanBurst")) ) {
		if ( !apmib_get( MIB_WLAN_BURST, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", (int)val) ;
		 ejSetResult(eid, buffer);
		return 0;
	}
//********************************************************************************************
#ifdef HOME_GATEWAY
	else if ( !strcmp(name, T("wanDhcp")) ) {
		if ( !apmib_get( MIB_WAN_DHCP, (void *)&dhcp) )
			return -1;
		sprintf(buffer, "%d", (int)dhcp);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("wanDhcp-current")) ) {
		if ( !apmib_get( MIB_WAN_DHCP, (void *)&dhcp) )
			return -1;
		if ( dhcp == DHCP_CLIENT && !isDhcpClientExist(WAN_IF))
			dhcp = DHCP_DISABLED;
		sprintf(buffer, "%d", (int)dhcp);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("wanDNS")) ) {
		DNS_TYPE_T dns;
		if ( !apmib_get( MIB_WAN_DNS_MODE, (void *)&dns) )
			return -1;
		sprintf(buffer, "%d", (int)dns);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("wanMode"))) {
		if ( !apmib_get( MIB_WAN_MODE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
//************************************** PPPoE Setting **************************************
	else if ( !strcmp(name, T("pppConnectType")) ) {
		PPP_CONNECT_TYPE_T type;
		if ( !apmib_get( MIB_PPP_CONNECT_TYPE, (void *)&type) )
			return -1;
		sprintf(buffer, "%d", (int)type);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("pppConnectStatus")) ) {
		sprintf(buffer, "%d", isConnectPPP());
		ejSetResult(eid, buffer);
		return 0;
	}
//*************************************** PPTP Setting ***************************************
	else if ( !strcmp(name, T("pptpIpMode"))) {
		if ( !apmib_get( MIB_PPTP_IPMODE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("pptpConnectType")) ) {
		PPP_CONNECT_TYPE_T type;
		if ( !apmib_get( MIB_PPTP_CONNECT_TYPE, (void *)&type) )
			return -1;
		sprintf(buffer, "%d", (int)type);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("pptpBEZEQEnable")) ) {
		PPP_CONNECT_TYPE_T type;
		if ( !apmib_get( MIB_PPTP_BEZEQ_ENABLE, (void *)&type) )
			return -1;
		sprintf(buffer, "%d", (int)type);
		ejSetResult(eid, buffer);
		return 0;
	}
//*************************************** L2TP Setting ***************************************
	else if ( !strcmp(name, T("L2TPIpMode"))) {
		if ( !apmib_get( MIB_L2TP_IPMODE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("L2TPConnectType")) ) {
		PPP_CONNECT_TYPE_T type;
		if ( !apmib_get( MIB_L2TP_CONNECT_TYPE, (void *)&type) )
			return -1;
		sprintf(buffer, "%d", (int)type);
		ejSetResult(eid, buffer);
		return 0;
	}
//*************************************** Telstra Big Pond ***************************************
	else if ( !strcmp(name, T("telBPEnabled"))) {
		if ( !apmib_get( MIB_TELBP_ENABLED, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("telBPState"))) {		//no use
		if ( !apmib_get( MIB_TELBP_STATE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
//************************************** Port Forwarding **************************************
	else if ( !strcmp(name, T("portFwEnabled"))) {
		if ( !apmib_get( MIB_PORTFW_ENABLED, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("portFwNum")) ) {
		if ( !apmib_get( MIB_PORTFW_NUM, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
//******************************************************************************************
	else if ( !strcmp(name, T("ipFilterNum")) ) {	//no use
		if ( !apmib_get( MIB_IPFILTER_NUM, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("portFilterNum")) ) {	//no sue
		if ( !apmib_get( MIB_PORTFILTER_NUM, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
#endif
//**************************************  MAC Filter **************************************
	else if ( !strcmp(name, T("macFilterNum")) ) {
		if ( !apmib_get( MIB_MACFILTER_NUM, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("macFtPermitEnabled")) ) {
		if ( !apmib_get( MIB_MACFILTER_PERMIT_ENABLED, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
#ifdef HOME_GATEWAY
//************************************** Special Application **************************************
	else if ( !strcmp(name, T("triggerPortEnabled"))) {
		if ( !apmib_get( MIB_TRIGGERPORT_ENABLED, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("triggerPortNum")) ) {
		if ( !apmib_get( MIB_TRIGGERPORT_NUM, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("ipFilterEnabled"))) {	//no use
		if ( !apmib_get( MIB_IPFILTER_ENABLED, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("portFilterEnabled"))) {	//no use
		if ( !apmib_get( MIB_PORTFILTER_ENABLED, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("macFilterEnabled"))) {
		if ( !apmib_get( MIB_MACFILTER_ENABLED, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("dmzEnabled"))) {
		if ( !apmib_get( MIB_DMZ_ENABLED, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
//************************************** Static Routing **************************************
	else if ( !strcmp(name, T("sroutEnabled"))) {
		if ( !apmib_get( MIB_SROUT_ENABLED, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("sroutNum")) ) {
		if ( !apmib_get( MIB_SROUT_NUM, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("machType"))) {
		#ifdef _6104WB_
			ejSetResult(eid, "0");
		#elif _6104WG_
			ejSetResult(eid, "1");
		#elif _6104K_
			ejSetResult(eid, "2");
		#elif _6104WBB_
			ejSetResult(eid, "3");
		#elif _6104KPS_
			ejSetResult(eid, "4");
		#elif _6104IPC_
			ejSetResult(eid, "5");
		// Lance 2004.2.12
		#elif _6104KP_
			ejSetResult(eid, "6"); 
		#elif _6104HS_
			ejSetResult(eid, "6"); 
		// End - Lance
		#endif
			return 0;
	}
#else
//************************************** RADIUS Server **************************************
	else if ( !strcmp(name, T("rserEnabled"))) {
		if ( !apmib_get( MIB_RSER_ENABLED, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("rserCltNum")) ) {
		if ( !apmib_get( MIB_RSER_CLT_NUM, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("rserUsrNum")) ) {
		if ( !apmib_get( MIB_RSER_USR_NUM, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
#endif
//************************************** Wireless Setting **************************************
	else if ( !strcmp(name, T("1xMode"))) {
		if ( !apmib_get( MIB_1X_MODE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("apMachType"))) {
		#ifdef _7206APB_
			ejSetResult(eid, "0");
		#elif _7207APB_
			ejSetResult(eid, "1");
		#elif _7207APS_
			ejSetResult(eid, "2");
		#endif
			return 0;
	}
	else if ( !strcmp(name, T("vsionType"))) {
		#ifdef _planet_
			ejSetResult(eid, "3");
		#else
			ejSetResult(eid, "6");
		#endif
			return 0;
	}
	else if ( !strcmp(name, T("l2tpGwMode"))) {
		#ifdef _edimax_
			ejSetResult(eid, "1");
		#else
			ejSetResult(eid, "0");
		#endif
			return 0;
	}
	else if ( !strcmp(name, T("channel")) ) {
		if ( !apmib_get( MIB_WLAN_CHAN_NUM, (void *)&chan) )
			return -1;
		sprintf(buffer, "%d", chan);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("regDomain")) ) {
		if ( !apmib_get( MIB_HW_REG_DOMAIN, (void *)&domain) )
			return -1;
		sprintf(buffer, "%d", (int)domain);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("wep")) ) {
		if ( !apmib_get( MIB_WLAN_WEP, (void *)&wep) )
			return -1;
		sprintf(buffer, "%d", (int)wep);
		ejSetResult(eid, buffer);
   	    	return 0;
	}
	else if ( !strcmp(name, T("defaultKeyId")) ) {
		if ( !apmib_get( MIB_WLAN_WEP_DEFAULT_KEY, (void *)&val) )
			return -1;
		val++;
		sprintf(buffer, "%d", (int)val) ;
		 ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("wlanSetTx")) ) {
		if ( !apmib_get( MIB_WLAN_SET_TX, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
//----------------------------------------------------------------------------------------
/*	else if ( !strcmp(name, T("LeaseTime")) ) {
		if ( !apmib_get( MIB_LEASE_TIME, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", (int)val) ;
		 ejSetResult(eid, buffer);
		return 0;
	}
	*/
//---------------------------------------------------------------------------------------------
	else if ( !strcmp(name, T("keyType")) ) {
		if ( !apmib_get( MIB_WLAN_WEP_KEY_TYPE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", (int)val) ;
		 ejSetResult(eid, buffer);
		return 0;
	}
  	else if ( !strcmp(name, T("authType"))) {
		if ( !apmib_get( MIB_WLAN_AUTH_TYPE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", (int)val) ;
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("operRate"))) {
		if ( !apmib_get( MIB_WLAN_SUPPORTED_RATE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", (int)val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("basicRate"))) {
		if ( !apmib_get( MIB_WLAN_BASIC_RATE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", (int)val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("preamble"))) {
		if ( !apmib_get( MIB_WLAN_PREAMBLE_TYPE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("hiddenSSID"))) {
		if ( !apmib_get( MIB_WLAN_HIDDEN_SSID, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("wmFilterNum"))) {
		if ( !apmib_get( MIB_WLAN_AC_NUM, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("wlanDisabled"))) {
		if ( !apmib_get( MIB_WLAN_DISABLED, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("wlanAcNum")) ) {
		if ( !apmib_get( MIB_WLAN_AC_NUM, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("wlanAcEnabled"))) {
		if ( !apmib_get( MIB_WLAN_AC_ENABLED, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("rateAdaptiveEnabled"))) {
		if ( !apmib_get( MIB_WLAN_RATE_ADAPTIVE_ENABLED, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("wlanMode"))) {
		if ( !apmib_get( MIB_WLAN_MODE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}

	else if ( !strcmp(name, T("netType"))) {
		if ( !apmib_get( MIB_WLAN_NETWORK_TYPE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("iappDisabled"))) {
		if ( !apmib_get( MIB_WLAN_IAPP_DISABLED, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
//-----------------------------------Erwin Add 28.08----------------------------------------------
	else if ( !strcmp(name, T("apMode"))) {
		if ( !apmib_get( MIB_AP_MODE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("apModeTemp"))) {
		if ( !apmib_get( MIB_AP_MODE_TEMP, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("secMode"))) {
		if ( !apmib_get( MIB_SECURITY_MODE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("clIpDisabled"))) {
		if ( !apmib_get( MIB_CLIENT_IP_DISABLED, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
#ifdef HOME_GATEWAY
//**************************************** Time Zone ****************************************
	else if ( !strcmp(name, T("DayLightEnable"))) {
		if ( !apmib_get( MIB_DAYLIGHT_ENABLE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
//*************************************** Remote Managemen ***************************************
	else if ( !strcmp(name, T("reMangEnable"))) {
		if ( !apmib_get( MIB_REMANG_ENABLE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("pAutoReconnect"))) {	//no use
		if ( !apmib_get( MIB_PAUTORECONNECT, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
//*************************************** UPnP Setting ***************************************
	else if ( !strcmp(name, T("upnpEnable"))) {
		if ( !apmib_get( MIB_UPNP_ENABLE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
//********************************** PrinterServer Setting **********************************
// Lance 2004.2.9
	else if ( !strcmp(name, T("PSEnable"))) {
		if ( !apmib_get( MIB_PS_ENABLE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
// Lance 2004.2.16
	else if ( !strcmp(name, T("PS_IPPEnable"))) {
		if ( !apmib_get( MIB_PS_IPPENABLE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("PS_LPREnable"))) {
		if ( !apmib_get( MIB_PS_LPRENABLE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
// End - Lance
//*************************************** NAT Setting ***************************************
	else if ( !strcmp(name, T("natEnable"))) {
		if ( !apmib_get( MIB_NAT_ENABLE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
//*************************************** Firewall Setting ***************************************
	else if ( !strcmp(name, T("FirewallEnable"))) {
		if ( !apmib_get( MIB_FIREWALL_ENABLE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
//*************************************** Virtual Server***************************************
	else if ( !strcmp(name, T("virtSVEnabled"))) {
		if ( !apmib_get( MIB_VSER_ENABLED, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("vserNum")) ) {
		if ( !apmib_get( MIB_VSER_NUM, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
//**************************************** DMZ ****************************************
	else if ( !strcmp(name, T("dmzNum")) ) {
		if ( !apmib_get( MIB_DMZ_NUM, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
//**************************************** URL Blocking ****************************************
	else if ( !strcmp(name, T("URLBEnabled"))) {
		if ( !apmib_get( MIB_URLB_ENABLED, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("URLBNum")) ) {
		if ( !apmib_get( MIB_URLB_NUM, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
//**************************************** DoS ****************************************
	else if ( !strcmp(name, T("podEnable")) ) {
		if ( !apmib_get( MIB_POD_ENABLED, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("pingEnable")) ) {
		if ( !apmib_get( MIB_PING_ENABLED, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("scanEnable")) ) {
		if ( !apmib_get( MIB_SCAN_ENABLED, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("synEnable")) ) {
		if ( !apmib_get( MIB_SYN_ENABLED, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("podTime")) ) {
		if ( !apmib_get( MIB_POD_TIME, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("synTime")) ) {
		if ( !apmib_get( MIB_SYN_TIME, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
//*************************************** Access Contral Ip ***************************************
	else if ( !strcmp(name, T("ACPCEnabled"))) {
		if ( !apmib_get( MIB_ACPC_ENABLED, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("ACPCNum")) ) {
		if ( !apmib_get( MIB_ACPC_NUM, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("sysMode"))) {	//no use
		if ( !apmib_get( MIB_SYS_MODE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
//*************************************** DDNS Setting ***************************************
	else if ( !strcmp(name, T("ddnsEnable"))) {
		if ( !apmib_get( MIB_DDNS_ENABLE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("dhisSelect"))) {
		if ( !apmib_get( MIB_DHIS_SELECT, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("dhisTempSel"))) {
		if ( !apmib_get( MIB_DHIS_TEMPSEL, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
#endif
//----------------------------------------------------------------------------------------------
#ifdef WLAN_WPA
	else if ( !strcmp(name, T("encrypt"))) {
		if ( !apmib_get( MIB_SECURITY_MODE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("enable1X"))) {
		if ( !apmib_get( MIB_WLAN_ENABLE_1X, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("enableSuppNonWpa"))) {
		if ( !apmib_get( MIB_WLAN_ENABLE_SUPP_NONWPA, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("suppNonWpa"))) {
		if ( !apmib_get( MIB_WLAN_SUPP_NONWPA, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("wpaAuth"))) {
		if ( !apmib_get( MIB_WLAN_WPA_AUTH, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("wpaCipher"))) {
		if ( !apmib_get( MIB_WLAN_WPA_CIPHER_SUITE, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("pskFormat"))) {
		if ( !apmib_get( MIB_WLAN_WPA_PSK_FORMAT, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}

	else if ( !strcmp(name, T("accountRsEnabled"))) {
		if ( !apmib_get( MIB_WLAN_ACCOUNT_RS_ENABLED, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("accountRsUpdateEnabled"))) {
		if ( !apmib_get( MIB_WLAN_ACCOUNT_UPDATE_ENABLED, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("enableMacAuth"))) {
		if ( !apmib_get( MIB_WLAN_ENABLE_MAC_AUTH, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("rsRetry")) ) {
		if ( !apmib_get( MIB_WLAN_RS_RETRY, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("accountRsRetry")) ) {
		if ( !apmib_get( MIB_WLAN_ACCOUNT_RS_RETRY, (void *)&val) )
			return -1;
		sprintf(buffer, "%d", val);
		ejSetResult(eid, buffer);
		return 0;
	}
#endif

	else
		return -1;
}

#ifdef HOME_GATEWAY
/////////////////////////////////////////////////////////////////////////////
int isConnectPPP()
{
	struct stat status;

	if ( stat("/etc/ppp/link", &status) < 0)
		return 0;

	return 1;
}
#endif
