/*
 *      Web server handler routines for management (password, save config, f/w update)
 *
 *      Authors: David Hsu	<davidhsu@realtek.com.tw>
 *
 *      $Id: fmmgmt.c,v 1.7 2004/02/23 07:07:37 erwin Exp $
 *
 */

#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>

#include "../webs.h"
#include "../um.h"
#include "apmib.h"
#include "apform.h"
#include "utility.h"

#define DEFAULT_GROUP		T("administrators")
#define ACCESS_URL		T("/")

static char superName[MAX_NAME_LEN]={0}, superPass[MAX_NAME_LEN]={0};
static char userName[MAX_NAME_LEN]={0}, userPass[MAX_NAME_LEN]={0};

////////////////////////////////////////////////////////////////////////////////
#ifdef _LITTLE_ENDIAN_
static void swap_mib_word_value(APMIB_Tp pMib)
{
	pMib->fragThreshold = WORD_SWAP(pMib->fragThreshold);
	pMib->rtsThreshold = WORD_SWAP(pMib->rtsThreshold);
	pMib->supportedRates = WORD_SWAP(pMib->supportedRates);
	pMib->basicRates = WORD_SWAP(pMib->basicRates);
	pMib->beaconInterval = WORD_SWAP(pMib->beaconInterval);
	pMib->inactivityTime = DWORD_SWAP(pMib->inactivityTime);
	pMib->leaseTime = DWORD_SWAP(pMib->leaseTime);

#ifdef WLAN_WPA
	pMib->wpaGroupRekeyTime = DWORD_SWAP(pMib->wpaGroupRekeyTime);
	pMib->rsPort = WORD_SWAP(pMib->rsPort);
	pMib->accountRsPort = WORD_SWAP(pMib->accountRsPort);
	pMib->accountRsUpdateDelay = WORD_SWAP(pMib->accountRsUpdateDelay);
	pMib->rsIntervalTime = WORD_SWAP(pMib->rsIntervalTime);
	pMib->accountRsIntervalTime = WORD_SWAP(pMib->accountRsIntervalTime);
#endif

#ifdef HOME_GATEWAY
{
	int i,j;
	pMib->TimeZoneSel = WORD_SWAP(pMib->TimeZoneSel);
	pMib->startMonth = WORD_SWAP(pMib->startMonth);
	pMib->startDay = WORD_SWAP(pMib->startDay);
	pMib->endMonth = WORD_SWAP(pMib->endMonth);
	pMib->endDay = WORD_SWAP(pMib->endDay);
	pMib->reManPort = WORD_SWAP(pMib->reManPort);
	pMib->pppMTU = WORD_SWAP(pMib->pppMTU);
	pMib->L2TPMTU = WORD_SWAP(pMib->L2TPMTU);
	pMib->pptpMTU = WORD_SWAP(pMib->pptpMTU);
	pMib->pppIdleTime = WORD_SWAP(pMib->pppIdleTime);
	pMib->pptpIdleTime = WORD_SWAP(pMib->pptpIdleTime);
	pMib->L2TPIdleTime = WORD_SWAP(pMib->L2TPIdleTime);
	pMib->appLayerGateway = DWORD_SWAP(pMib->appLayerGateway);
	pMib->dhisHostID = DWORD_SWAP(pMib->dhisHostID);
	pMib->podPack = WORD_SWAP(pMib->podPack);
	pMib->podBur = WORD_SWAP(pMib->podBur);
	pMib->synPack = WORD_SWAP(pMib->synPack);
	pMib->synBur = WORD_SWAP(pMib->synBur);
	pMib->scanNum = WORD_SWAP(pMib->scanNum);
//////////////////////////////////////////////////////////////////////////////////////////////
	for (i=0; i<pMib->vserNum; i++) {
		pMib->vserArray[i].fromPort = WORD_SWAP(pMib->vserArray[i].fromPort);
		pMib->vserArray[i].toPort = WORD_SWAP(pMib->vserArray[i].toPort);
	}
	for (i=0; i<pMib->portFwNum; i++) {
		pMib->portFwArray[i].fromPort = WORD_SWAP(pMib->portFwArray[i].fromPort);
		pMib->portFwArray[i].toPort = WORD_SWAP(pMib->portFwArray[i].toPort);
	}
	for (i=0; i<pMib->portFilterNum; i++) {	//no use
		pMib->portFilterArray[i].fromPort = WORD_SWAP(pMib->portFilterArray[i].fromPort);
		pMib->portFilterArray[i].toPort = WORD_SWAP(pMib->portFilterArray[i].toPort);
	}
	for (i=0; i<pMib->triggerPortNum; i++) {
		pMib->triggerPortArray[i].tri_fromPort = WORD_SWAP(pMib->triggerPortArray[i].tri_fromPort);
		pMib->triggerPortArray[i].tri_toPort = WORD_SWAP(pMib->triggerPortArray[i].tri_toPort);
		for (j=0; j<=4; j++) {
			pMib->triggerPortArray[i].inc_fromPort[j][0] = WORD_SWAP(pMib->triggerPortArray[i].inc_fromPort[j][0]);
			pMib->triggerPortArray[i].inc_fromPort[j][1] = WORD_SWAP(pMib->triggerPortArray[i].inc_fromPort[j][1]);
		}
		pMib->triggerPortArray[i].inc_toPort = WORD_SWAP(pMib->triggerPortArray[i].inc_toPort);
	}
	for (i=0; i<pMib->ACPCNum; i++) {
		pMib->ACPCArray[i].serindex = DWORD_SWAP(pMib->ACPCArray[i].serindex);
		for (j=0; j<=4; j++) {
			pMib->ACPCArray[i].Port[j][0] = WORD_SWAP(pMib->ACPCArray[i].Port[j][0]);
			pMib->ACPCArray[i].Port[j][1] = WORD_SWAP(pMib->ACPCArray[i].Port[j][1]);
		}
	}
	for (i=0; i<pMib->sroutNum; i++) {
		pMib->sroutArray[i].hopCount = WORD_SWAP(pMib->sroutArray[i].hopCount);
	}
}
#endif

}
#endif

///////////////////////////////////////////////////////////////////
static void reset_user_profile()
{
	struct stat status;
	umClose();

	if ( stat(T("umconfig.txt"), &status) == 0) // file existed
               	unlink(T("umconfig.txt"));

	umOpen();
	umRestore(T("umconfig.txt"));

	set_user_profile();
}


/////////////////////////////////////////////////////////////////////////////
static int fwChecksumOk(char_t *data, int len)
{
	unsigned short sum=0;
	int i;

	for (i=0; i<len; i+=2) {
#ifdef _LITTLE_ENDIAN_
		sum += WORD_SWAP( *((unsigned short *)&data[i]) );
#else
		sum += *((unsigned short *)&data[i]);
#endif

	}
	return( (sum==0) ? 1 : 0);
}


///////////////////////////////////////////////////////////////////////////////
void formAccept(webs_t wp, char_t *path, char_t *query)
{
    char_t  *submitUrl;
	printf("\nkillall processes\n");
	#ifndef __i386__		//Erwin
		system("killall auth upnpd udhcpc iwcontrol diagd cleanlog.sh udhcpd");
	#endif

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
	if (submitUrl[0])
		websRedirect(wp, submitUrl);
	else
		websDone(wp, 200);
  	return;
}
///////////////////////////////////////////////////////////////////////////////
void formReboot(webs_t wp)
{
    char tmpBuf[200];
    char_t  *submitUrl;
	submitUrl = websGetVar(wp, T("submit-url"), T(""));
	sprintf(tmpBuf, T("Reboot successfully !<br><br>Please wait a while for rebooting...")); 
#ifdef _ADM5120_	
	system("/bin/reboot.sh");
#else
	OK_MSG1(tmpBuf, submitUrl);
	kill(1,SIGTERM);
#endif
}
//////////////////////////////////////////////////////////////////////////////////////////////
void formSysLog(webs_t wp, char_t *path, char_t *query)
{
	char_t *strSave, *strClear, *submitUrl;
	FILE *fp;
	unsigned char tempbuf[100];
	int rdSize;
	
	// Save system log to file
	strSave = websGetVar(wp, T("send"), T(""));
	if (strSave[0]) {
	   
		websWrite(wp, "HTTP/1.0 200 OK\n");
		websWrite(wp, "Content-Type: application/octet-stream;\n");
		websWrite(wp, "Content-Disposition: attachment;filename=\"syslog.txt\" \n");
		websWrite(wp, "Pragma: no-cache\n");
		websWrite(wp, "Cache-Control: no-cache\n");
		websWrite(wp, "\n");

		if ((fp = fopen("/var/log/syslog","r"))!=NULL) {
			while ((rdSize = fread(tempbuf, 1, 100, fp)) !=0 )
				websWriteDataNonBlock(wp, tempbuf, rdSize);
			fclose(fp);
		}
		websDone(wp, 200);
		return;
	}

	// clear security log file
	strClear = websGetVar(wp, T("reset"), T(""));
	if (strClear[0]) {
		system("/bin/syslog.sh clean");

		submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
		REPLACE_MSG(submitUrl);
		return;
	}
}
//////////////////////////////////////////////////////////////////////////////////////////////
void formSecLog(webs_t wp, char_t *path, char_t *query)
{
	char_t *strSave, *strClear, *submitUrl;
	FILE *fp;
	unsigned char tempbuf[100];
	int rdSize;
	
	// Save security log to file
	strSave = websGetVar(wp, T("send"), T(""));
	if (strSave[0]) {
	   
		websWrite(wp, "HTTP/1.0 200 OK\n");
		websWrite(wp, "Content-Type: application/octet-stream;\n");
		websWrite(wp, "Content-Disposition: attachment;filename=\"security.txt\" \n");
		websWrite(wp, "Pragma: no-cache\n");
		websWrite(wp, "Cache-Control: no-cache\n");
		websWrite(wp, "\n");

		if ((fp = fopen("/var/log/security","r"))!=NULL) {
			while ((rdSize = fread(tempbuf, 1, 100, fp)) !=0 )
				websWriteDataNonBlock(wp, tempbuf, rdSize);
			fclose(fp);
		}
		websDone(wp, 200);
		return;
	}

	// clear security log file
	strClear = websGetVar(wp, T("reset"), T(""));
	if (strClear[0]) {
		system("/bin/seclog.sh clean");

		submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
		REPLACE_MSG(submitUrl);
		return;
	}
}
//////////////////////////////////////////////////////////////////////////////////////////////
void formDebug(webs_t wp, char_t *path, char_t *query)
{
	char_t *strPass;
	FILE *fp;
	unsigned char buffer[100];
	int rdSize;
	char tmpBuf[200];
	
			
	strPass = websGetVar(wp, T("password"), T(""));
	if (strcmp(strPass,"report.txt")) // Lance 2003.11.05
	{
		strcpy(tmpBuf, T("ERROR: Invalid value of Command !"));
       	goto setErr_debug;
	}
	
	system("/bin/savelog.sh");
   
	websWrite(wp, "HTTP/1.0 200 OK\n");
	websWrite(wp, "Content-Type: application/octet-stream;\n");
	websWrite(wp, "Content-Disposition: attachment;filename=\"report.txt\" \n"); // Lance 003.11.05
	websWrite(wp, "Pragma: no-cache\n");
	websWrite(wp, "Cache-Control: no-cache\n");
	websWrite(wp, "\n");

	if ((fp = fopen("/var/run/syslog","r"))!=NULL) {
		while ((rdSize = fread(buffer, 1, 100, fp)) !=0 )
			websWriteDataNonBlock(wp, buffer, rdSize);
		fclose(fp);
	}
	websDone(wp, 200);
	return;
		
setErr_debug:
	ERR_MSG(tmpBuf);
	return;
}

// Lance
void formUSBStorage(webs_t wp, char_t *path, char_t *query)
{
	char_t *strRequest;
	char tmpBuf[200];

	strRequest = websGetVar(wp, T("sub_dir"), T(""));

	if( strRequest[0] )
	{
	    sprintf(tmpBuf,"/bin/storage.sh %s", strRequest);
		system(tmpBuf);
	}
	else
		system("/bin/storage.sh");

	REPLACE_MSG("/storage.html");
}
// End-Lance

//////////////////////////////////////////////////////////////////////////////////////////////
void formSaveConfig(webs_t wp, char_t *path, char_t *query)
{
	char_t *strRequest;
	char *buf, *ptr=NULL;
	PARAM_HEADER_Tp pHeader;
	unsigned char checksum;
	int len, status=0, ver, force, len1;
	char tmpBuf[200];
#ifndef NO_ACTION
	int pid;
#endif
	CONFIG_DATA_T type=0;

	len1 = sizeof(PARAM_HEADER_T) + sizeof(APMIB_T) + sizeof(checksum) + 100;  // 100 for expansion
	len = csHeader.len;
#ifdef _LITTLE_ENDIAN_
	len  = WORD_SWAP(len);
#endif
	len += sizeof(PARAM_HEADER_T) + 100;
	if (len1 > len)
		len = len1;

	buf = malloc(len);
	if ( buf == NULL ) {
		strcpy(tmpBuf, "Allocate buffer failed!");
		goto back;
	}

	strRequest = websGetVar(wp, T("save-cs"), T(""));
	if (strRequest[0])
		type |= CURRENT_SETTING;

	strRequest = websGetVar(wp, T("save"), T(""));
	if (strRequest[0])
		type |= CURRENT_SETTING;

	strRequest = websGetVar(wp, T("save-hs"), T(""));
	if (strRequest[0])
		type |= HW_SETTING;

	strRequest = websGetVar(wp, T("save-ds"), T(""));
	if (strRequest[0])
		type |= DEFAULT_SETTING;

	strRequest = websGetVar(wp, T("save-all"), T(""));
	if (strRequest[0])
		type |= HW_SETTING | DEFAULT_SETTING | CURRENT_SETTING;

	if (type) {
		websWrite(wp, "HTTP/1.0 200 OK\n");
		websWrite(wp, "Content-Type: application/octet-stream;\n");
		websWrite(wp, "Content-Disposition: attachment;filename=\"config.bin\" \n");
		websWrite(wp, "Pragma: no-cache\n");
		websWrite(wp, "Cache-Control: no-cache\n");
		websWrite(wp, "\n");

		if (type & HW_SETTING) {
			pHeader = (PARAM_HEADER_Tp)buf;
			len = pHeader->len = hsHeader.len;
			memcpy(&buf[sizeof(PARAM_HEADER_T)], pHwSetting, pHeader->len-1);

#ifdef _LITTLE_ENDIAN_
			pHeader->len  = WORD_SWAP(pHeader->len);
#endif
			memcpy(pHeader->signature, hsHeader.signature, SIGNATURE_LEN);
			ptr = (char *)&buf[sizeof(PARAM_HEADER_T)];
			checksum = CHECKSUM(ptr, len-1);
			buf[sizeof(PARAM_HEADER_T)+len-1] = checksum;

			ptr = &buf[sizeof(PARAM_HEADER_T)];
			ENCODE_DATA(ptr,  len);
			websWriteDataNonBlock(wp, buf, len+sizeof(PARAM_HEADER_T));
		}

		if (type & DEFAULT_SETTING) {
			pHeader = (PARAM_HEADER_Tp)buf;
			len = pHeader->len = dsHeader.len;
			memcpy(&buf[sizeof(PARAM_HEADER_T)], pMibDef, len-1);

#ifdef _LITTLE_ENDIAN_
			pHeader->len  = WORD_SWAP(pHeader->len);
			swap_mib_word_value((APMIB_Tp)&buf[sizeof(PARAM_HEADER_T)]);
#endif
			memcpy(pHeader->signature, dsHeader.signature, SIGNATURE_LEN);
			ptr = (char *)&buf[sizeof(PARAM_HEADER_T)];
			checksum = CHECKSUM(ptr, len-1);
			buf[sizeof(PARAM_HEADER_T)+len-1] = checksum;

			ptr = &buf[sizeof(PARAM_HEADER_T)];
			ENCODE_DATA(ptr,  len);
			websWriteDataNonBlock(wp, buf, len+sizeof(PARAM_HEADER_T));
		}

		if (type & CURRENT_SETTING) {
			pHeader = (PARAM_HEADER_Tp)buf;
			len = pHeader->len = csHeader.len;
			memcpy(&buf[sizeof(PARAM_HEADER_T)], pMib, len-1);

#ifdef _LITTLE_ENDIAN_
			pHeader->len  = WORD_SWAP(pHeader->len);
			swap_mib_word_value((APMIB_Tp)&buf[sizeof(PARAM_HEADER_T)]);
#endif
			memcpy(pHeader->signature, csHeader.signature, SIGNATURE_LEN);
			ptr = (char *)&buf[sizeof(PARAM_HEADER_T)];
			checksum = CHECKSUM(ptr, len-1);
			buf[sizeof(PARAM_HEADER_T)+len-1] = checksum;

			ptr = &buf[sizeof(PARAM_HEADER_T)];
			ENCODE_DATA(ptr,  len);
			websWriteDataNonBlock(wp, buf, len+sizeof(PARAM_HEADER_T));
		}
		websDone(wp, 200);
		free(buf);
		return;
	}

	strRequest = websGetVar(wp, T("load"), T(""));
	if (strRequest[0]) {
		len = 0;
		status = 1;
		type = 0;
		while (len < wp->lenPostData) {

			pHeader = (PARAM_HEADER_Tp)&wp->postData[len];

#ifdef _LITTLE_ENDIAN_
			pHeader->len = WORD_SWAP(pHeader->len);
#endif
			len += sizeof(PARAM_HEADER_T);

			if ( sscanf(&pHeader->signature[TAG_LEN], "%02d", &ver) != 1)
				ver = -1;

			force = -1;
			if ( !memcmp(pHeader->signature, CURRENT_SETTING_HEADER_TAG, TAG_LEN) )
				force = 1; // update
			else if ( !memcmp(pHeader->signature, CURRENT_SETTING_HEADER_FORCE_TAG, TAG_LEN))
				force = 2; // force
			else if ( !memcmp(pHeader->signature, CURRENT_SETTING_HEADER_UPGRADE_TAG, TAG_LEN))
				force = 0; // upgrade

			if ( force >= 0 ) {
#if 0
				if ( !force && (ver < CURRENT_SETTING_VER || // version is less than current
					(pHeader->len < (sizeof(APMIB_T)+1)) ) { // length is less than current
					status = 0;
					break;
				}
#endif
				ptr = &wp->postData[len];
				DECODE_DATA(ptr, pHeader->len);
				if ( !CHECKSUM_OK(ptr, pHeader->len)) {
					status = 0;
					break;
				}
#ifdef _LITTLE_ENDIAN_
				swap_mib_word_value((APMIB_Tp)ptr);
#endif
				apmib_updateFlash(CURRENT_SETTING, ptr, pHeader->len-1, force, ver);
				len += pHeader->len;
				type |= CURRENT_SETTING;
				continue;
			}


			if ( !memcmp(pHeader->signature, DEFAULT_SETTING_HEADER_TAG, TAG_LEN) )
				force = 1;	// update
			else if ( !memcmp(pHeader->signature, DEFAULT_SETTING_HEADER_FORCE_TAG, TAG_LEN) )
				force = 2;	// force
			else if ( !memcmp(pHeader->signature, DEFAULT_SETTING_HEADER_UPGRADE_TAG, TAG_LEN) )
				force = 0;	// upgrade

			if ( force >= 0 ) {
#if 0
				if ( (ver < DEFAULT_SETTING_VER) || // version is less than current
					(pHeader->len < (sizeof(APMIB_T)+1)) ) { // length is less than current
					status = 0;
					break;
				}
#endif
				ptr = &wp->postData[len];
				DECODE_DATA(ptr, pHeader->len);
				if ( !CHECKSUM_OK(ptr, pHeader->len)) {
					status = 0;
					break;
				}

#ifdef _LITTLE_ENDIAN_
				swap_mib_word_value((APMIB_Tp)ptr);
#endif
				apmib_updateFlash(DEFAULT_SETTING, ptr, pHeader->len-1, force, ver);
				len += pHeader->len;
				type |= DEFAULT_SETTING;
				continue;
			}


			if ( !memcmp(pHeader->signature, HW_SETTING_HEADER_TAG, TAG_LEN) )
				force = 1;	// update
			else if ( !memcmp(pHeader->signature, HW_SETTING_HEADER_FORCE_TAG, TAG_LEN) )
				force = 2;	// force
			else if ( !memcmp(pHeader->signature, HW_SETTING_HEADER_UPGRADE_TAG, TAG_LEN) )
				force = 0;	// upgrade

			if ( force >= 0 ) {
#if 0
				if ( (ver < HW_SETTING_VER) || // version is less than current
					(pHeader->len < (sizeof(HW_SETTING_T)+1)) ) { // length is less than current
					status = 0;
					break;
				}
#endif
				ptr = &wp->postData[len];
				DECODE_DATA(ptr, pHeader->len);
				if ( !CHECKSUM_OK(ptr, pHeader->len)) {
					status = 0;
					break;
				}
				apmib_updateFlash(HW_SETTING, ptr, pHeader->len-1, force, ver);
				len += pHeader->len;
				type |= HW_SETTING;
				continue;
			}
		}

		if (status == 0 || type == 0) // checksum error
			strcpy(tmpBuf, "Invalid configuration file!");
		else {
			if (type) { // upload success
				if (apmib_reinit() ==0) {
					strcpy(tmpBuf,T("Re-initialize AP MIB failed!\n"));
					goto back;
				}
				reset_user_profile();  // re-initialize user password

#ifndef NO_ACTION
				/* restart system init script */
				pid = fork();
        			if (pid)
					waitpid(pid, NULL, 0);
        			else if (pid == 0) {
					snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG);
#ifdef HOME_GATEWAY
					execl( tmpBuf, _CONFIG_SCRIPT_PROG, "gw", "all", NULL);
#else
					execl( tmpBuf, _CONFIG_SCRIPT_PROG, "ap", "all", NULL);
#endif

                			exit(1);
        			}
#endif
			}
			strcpy(tmpBuf, "Update successfully!");
		}

back:
		ERR_MSG(tmpBuf);

		free(buf);
		return;
	}

	strRequest = websGetVar(wp, T("reset"), T(""));
	if (strRequest[0]) {
		
		system("/bin/flash default");
/*
		if ( !apmib_updateDef() ) {
			free(ptr);
			strcpy(tmpBuf, "Write default to current setting failed!\n");
			goto back;
		}
*/
		if (apmib_reinit() ==0) {
			free(ptr);
			strcpy(tmpBuf, "Re-initialize AP MIB failed!\n");
			goto back;
		}
		reset_user_profile();  // re-initialize user password

#ifndef NO_ACTION
		/* restart system init script */
		pid = fork();
       		if (pid == 0) {
			snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG);
#ifdef HOME_GATEWAY
			execl( tmpBuf, _CONFIG_SCRIPT_PROG, "gw", "all", NULL);
#else
			execl( tmpBuf, _CONFIG_SCRIPT_PROG, "ap", "all", NULL);
#endif
               		exit(1);
       		}
		else
			waitpid(pid, NULL, 0);
#endif
		strcpy(tmpBuf, "Reload setting successfully!");
		ERR_MSG(tmpBuf);

		free(ptr);
	}
}

///////////////////////////////////////////////////////////////////////////////
void formUpload(webs_t wp, char_t * path, char_t * query)
{
#ifdef __mips__
    int fh;
#else
    FILE *       fp;
    char_t *     bn = NULL;
#endif
    int		 len;
    int          locWrite;
    int          numLeft;
    int          numWrite;
    IMG_HEADER_Tp pHeader;
    char tmpBuf[200];
    char_t *strRequest, *submitUrl, *strVal;
    int flag, startAddr=-1, startAddrWeb=-1;
#ifndef NO_ACTION
    int pid;
#endif

	
    strRequest = websGetVar(wp, T("save"), T(""));
    if (strRequest[0]) {
	int fh=0;
	char *buf=NULL;

#ifdef __mips__
	char *filename=FLASH_DEVICE_NAME;
	int imageLen=-1;
	IMG_HEADER_T header;

	strVal = websGetVar(wp, T("readAddr"), T(""));
	if ( strVal[0] )
		startAddr = strtol( strVal, (char **)NULL, 16);

	strVal = websGetVar(wp, T("size"), T(""));
	if ( strVal[0] )
		imageLen = strtol( strVal, (char **)NULL, 16);

	fh = open(filename, O_RDONLY);
	if ( fh == -1 ) {
      		strcpy(tmpBuf, T("Open file failed!"));
		goto ret_err;
	}
	if (startAddr==-1 || imageLen==-1) {
		// read system image
		lseek(fh, CODE_IMAGE_OFFSET, SEEK_SET); // Lance 2003.06.15
		if ( read(fh, &header, sizeof(header)) != sizeof(header)) {
     			strcpy(tmpBuf, T("Read image header error!"));
			goto ret_err;
		}
		if ( memcmp(header.signature, FW_HEADER, SIGNATURE_LEN) ) {  // Lance 2003.06.15
				printf("upgrade fail: Invalid file format! ( %s should be %s )\n",
								header.signature,
								FW_HEADER);
       			strcpy(tmpBuf, T("Invalid file format!"));
			goto ret_err;
	    	}
		startAddr = CODE_IMAGE_OFFSET; // Lance 2003.06.15
		imageLen =  sizeof(header) + header.len;
	}

	buf = malloc(0x10000);
	if ( buf == NULL) {
       		strcpy(tmpBuf, T("Allocate buffer failed!"));
		goto ret_err;
	}

	lseek(fh, startAddr, SEEK_SET);

	websWrite(wp, "HTTP/1.0 200 OK\n");
	websWrite(wp, "Content-Type: application/octet-stream;\n");
	websWrite(wp, "Content-Disposition: attachment;filename=\"apcode.bin\" \n");
	websWrite(wp, "Pragma: no-cache\n");
	websWrite(wp, "Cache-Control: no-cache\n");
	websWrite(wp, "\n");

	while (imageLen > 0) {
		int blocksize=0x10000;
		if (imageLen < blocksize)
			blocksize=imageLen;

		if ( read(fh, buf, blocksize) != blocksize) {
	     		strcpy(tmpBuf, T("Read image error!"));
			goto ret_err;
		}
		websWriteBlock(wp, (char *)buf, blocksize);
		imageLen -= blocksize;
	}

	{
    	unsigned short checksum, checksum_org;
		unsigned long readLen = 0;
		unsigned char readBuf[1024];
		unsigned long i;
		int _flashfd;
		
		if((_flashfd = open(FLASH_DEVICE_NAME, O_RDWR))<0)
		{
			strcpy(tmpBuf, T("Upgrade failed!"));
			goto ret_err;
		}

		for(i=0; i < 0x40000; i+=0x10000)
		{
			lseek(_flashfd, 0x10000 + i, SEEK_SET);
			read(_flashfd, readBuf, 12);
			
			if(memcmp(readBuf, "CSYS", 4))
				continue;
			readLen = *((unsigned long *)&readBuf[8]);
			
			printf("\n\nFound CSYS image in %lx, Len = %lx\n", 0x10000 + i, readLen);
			break;
		}

		if ( i == 0x40000)
		{
			close(_flashfd);
			strcpy(tmpBuf, T("Upgrade failed!"));
			goto ret_err;
		}
		
		checksum = 0;
		for(i=0 ;i < (readLen); i += 2)
		{
			read(_flashfd, readBuf, 2);
			checksum += *(unsigned short*)readBuf;
		}

		checksum_org = *(unsigned short*)readBuf;

		printf("\n checksum_org = %lx, checksum=%lx\n", checksum_org, checksum);
		if(checksum != 0)
		{
         	strcpy(tmpBuf, T("Upgrade failed!"));
			goto ret_err;
		}
	}
	
	websDone(wp, 200);
#else
	struct stat status;
	char *filename="apcode.bin";
	if ( stat(filename, &status) < 0 ) {
       		strcpy(tmpBuf, T("Stat file failed!"));
		goto ret_err;
	}
	buf = malloc(status.st_size);
	if ( buf == NULL) {
       		strcpy(tmpBuf, T("Allocate buffer failed!"));
		goto ret_err;
	}

	fh = open(filename, O_RDONLY);
	if ( fh == -1 ) {
      		strcpy(tmpBuf, T("Open file failed!"));
		goto ret_err;
	}
	lseek(fh, CODE_IMAGE_OFFSET, SEEK_SET); // Lance 2003.06.15

	if ( read(fh, buf, status.st_size) != status.st_size) {
      		strcpy(tmpBuf, T("Read file failed!"));
		goto ret_err;
	}
	websWriteBlock(wp, (char *)buf, status.st_size);
	websDone(wp, 200);
#endif
	goto ret_ok;

ret_err:
	ERR_MSG(tmpBuf);
ret_ok:
	if (fh>0)
		close(fh);
	if (buf)
		free(buf);
	return;
   }

    // assume as firmware upload
    strVal = websGetVar(wp, T("writeAddrCode"), T(""));
    if ( strVal[0] ) {
	if ( !memcmp(strVal, "0x", 2))
		startAddr = strtol( &strVal[2], (char **)NULL, 16);
    }
    strVal = websGetVar(wp, T("writeAddrWebPages"), T(""));
    if ( strVal[0] ) {
	if ( !memcmp(strVal, "0x", 2))
		startAddrWeb = strtol( &strVal[2], (char **)NULL, 16);
    }
    submitUrl = websGetVar(wp, T("submit-url"), T(""));
    locWrite = 0;
    numLeft = wp->lenPostData;
    pHeader = (IMG_HEADER_Tp) wp->postData;

    // check header and checksum
    if (!memcmp(wp->postData, FW_HEADER, SIGNATURE_LEN)) // Lance 2003.06.15
    	flag = 1;
    else if (!memcmp(wp->postData, WEB_HEADER, SIGNATURE_LEN))
    	flag = 2;
    else {
		printf("upgrade fail: Invalid file format! ( %s should be %s or %s )\n",
						wp->postData,
						WEB_HEADER,FW_HEADER);
       	strcpy(tmpBuf, T("<b>Invalid file format!"));
	goto ret_upload;
    }

    len = pHeader->len;
#ifdef _LITTLE_ENDIAN_
    len  = DWORD_SWAP(len);
#endif
#if 0
    if (len != numLeft - sizeof(IMG_HEADER_T) ) {
       	sprintf(tmpBuf, T("Image length mismatched!,len=%d"), len);
	goto ret_upload;
    }
#endif
    if ( flag == 1 ) {
    	if ( !fwChecksumOk(&wp->postData[sizeof(IMG_HEADER_T)], len)) {
      		sprintf(tmpBuf, T("<b>Image checksum mismatched! len=0x%x, checksum=0x%x</b><br>"), len,
			*((unsigned short *)&wp->postData[len-2]) );
		goto ret_upload;
	}
    }
    else {
    	char *ptr = &wp->postData[sizeof(IMG_HEADER_T)];
    	if ( !CHECKSUM_OK(ptr, len) ) {
     		sprintf(tmpBuf, T("<b>Image checksum mismatched! len=0x%x</b><br>"), len);
		goto ret_upload;
	}
    }

#ifdef __mips__
    fh = open(FLASH_DEVICE_NAME, O_RDWR);
    if ( fh == -1 ) {
#else
    if (flag == 1)
    	bn = "apcode.bin";
    else
    	bn = "web.gz.up";

    if ((fp = fopen((bn == NULL ? "upldForm.bin" : bn), "w+b")) == NULL) {
#endif
       	strcpy(tmpBuf, T("File open failed!"));
    } else {

#ifdef __mips__
	if (flag == 1) {
		if ( startAddr == -1)
			startAddr = CODE_IMAGE_OFFSET;
	}
	else {
		if ( startAddrWeb == -1)
			startAddr = WEB_PAGE_OFFSET;
		else
			startAddr = startAddrWeb;
	}

	lseek(fh, startAddr, SEEK_SET);

	numWrite = write(fh, &(wp->postData[locWrite]), numLeft);
#else
	numWrite = fwrite(&(wp->postData[locWrite]), sizeof(*(wp->postData)), numLeft, fp);
#endif
	if (numWrite < numLeft) {
#ifdef __mips__
		sprintf(tmpBuf, T("File write failed.<br> locWrite=%d numLeft=%d numWrite=%d Size=%d bytes."), locWrite, numLeft, numWrite, wp->lenPostData);
#else
                sprintf(tmpBuf, T("File write failed.<br> ferror=%d locWrite=%d numLeft=%d numWrite=%d Size=%d bytes."), ferror(fp), locWrite, numLeft, numWrite, wp->lenPostData);
#endif
	}
	locWrite += numWrite;
 	numLeft -= numWrite;
#ifdef __mips__
	close(fh);
#else
	fclose(fp);
#endif
	if (numLeft == 0)
		sprintf(tmpBuf, T("Update successfully (size = %d bytes)!<br><br>Please wait a while for rebooting..."), wp->lenPostData);
	else
		sprintf(tmpBuf, T("numLeft=%d locWrite=%d Size=%d bytes."), numLeft, locWrite, wp->lenPostData);
    }
	PROC_MSG();
    OK_MSG1(tmpBuf, submitUrl);

#ifndef NO_ACTION

#ifdef _ADM5120_
    system("/bin/reboot.sh Reboot");
#else
    pid = find_pid_by_name("init");
    kill(pid, SIGTERM);
#endif
#endif

    return;

ret_upload:
    ERR_MSG(tmpBuf);
}
////////////////////////////////////////////////////////////////////////////////
/*void formPassword(webs_t wp, char_t *path, char_t *query)
{
	char_t *submitUrl, *strOPassword, *strNPassword;
	char tmpBuf[100];

	strOPassword = websGetVar(wp, T("oldpass"), T(""));
	apmib_get(MIB_USER_PASSWORD, (void *)tmpBuf);
	strNPassword = websGetVar(wp, T("newpass"), T(""));
	
	printf("\noldpass=%s\n",strOPassword);
	printf("\nMIB_USER_PASSWORD=%s\n",tmpBuf);
	printf("\nnewpass=%s\n",strNPassword);
	
	if ( strOPassword[0] || strNPassword[0])
	{
		if ( ! strcmp(strOPassword,tmpBuf )) {
        	  if ( umUserExists("admin"))
        	       umDeleteUser("admin");
	                                        
         	  if ( umAddUser("admin", strNPassword, DEFAULT_GROUP, FALSE, FALSE) ) {
           	       strcpy(tmpBuf, T("ERROR: Password setting failed !"));
            	       goto setErr_pass;
	      	  }
		}
		else{
        	     strcpy(tmpBuf, T("ERROR: Password is not matched !"));
        	     goto setErr_pass;
		}
	}
	// Retrieve next page URL 
	apmib_update(CURRENT_SETTING);
		
	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page

	OK_MSG(submitUrl);
	return;

setErr_pass:
	ERR_MSG(tmpBuf);
}*/
/////////////////////////////////////////////////////////////////////////////
void formPasswordSetup(webs_t wp, char_t *path, char_t *query)
{
	char_t *submitUrl, *strUser, *strPassword, *userid, *nextUserid, *strOPassword;
	char tmpBuf[100];
	
//	strUser = websGetVar(wp, T("username"), T(""));
	strUser = "admin";
	strPassword = websGetVar(wp, T("newpass"), T(""));
/*	if ( strUser[0] && !strPassword[0] ) {
		strcpy(tmpBuf, T("ERROR: Password cannot be empty."));
		goto setErr_pass;
	}
*/
	strOPassword = websGetVar(wp, T("oldpass"), T(""));
	apmib_get(MIB_USER_PASSWORD, (void *)tmpBuf);	
//	printf("\noldpass=\"%s\" MIB_USER_PASSWORD=\"%s\" newpass=\"%s\"\n",strOPassword,tmpBuf,strPassword);
	if (  strcmp(strOPassword,tmpBuf )) { 
		strcpy(tmpBuf, T("ERROR: Password is not matched !"));
        goto setErr_pass;
	}
	if ( strUser[0] ) {
		// Check if user name is the same as supervisor name 
		if ( !apmib_get(MIB_SUPER_NAME, (void *)tmpBuf)) {
			strcpy(tmpBuf, T("ERROR: Get supervisor name MIB error!"));
			goto setErr_pass;
		}
		if ( !strcmp(strUser, tmpBuf)) {
			strcpy(tmpBuf, T("ERROR: Cannot use the same user name as supervisor."));
			goto setErr_pass;
		}

		// Check if supervisor account exist. if not, create it 
		if ( !umGroupExists(DEFAULT_GROUP) )
			if ( umAddGroup(DEFAULT_GROUP, (short)PRIV_ADMIN, AM_BASIC, FALSE, FALSE) ) {
				strcpy(tmpBuf, T("ERROR: Unable to add group."));
				goto setErr_pass;
			}
		if ( !umAccessLimitExists(ACCESS_URL) )
			if ( umAddAccessLimit(ACCESS_URL, AM_FULL, (short)0, DEFAULT_GROUP) ) {
				strcpy(tmpBuf, T("ERROR: Unable to add access limit."));
				goto setErr_pass;
			}
		if ( !umUserExists(superName)) 
			if ( umAddUser(superName, superPass, DEFAULT_GROUP, FALSE, FALSE) ) {
				strcpy(tmpBuf, T("ERROR: Unable to add supervisor account."));
				goto setErr_pass;
			}
		
		// Add new one 
		if ( umUserExists(strUser)) 
			umDeleteUser(strUser);

		if ( umAddUser(strUser, strPassword, DEFAULT_GROUP, FALSE, FALSE) ) {
			strcpy(tmpBuf, T("ERROR: Unable to add user account."));
			goto setErr_pass;
		}
	}
	else {
		// Set NULL account, delete supervisor from DB 
		umDeleteAccessLimit("/");
		umDeleteUser(superName);
		umDeleteGroup(DEFAULT_GROUP);
	}

	/* Delete current user account */
	userid = umGetFirstUser();
	while (userid) {
		if ( gstrcmp(userid, superName) && gstrcmp(userid, strUser)) {
			nextUserid = umGetNextUser(userid);
			if ( umDeleteUser(userid) ) {
				strcpy(tmpBuf, T("ERROR: Unable to delete user account."));
				goto setErr_pass;
			}
			userid = nextUserid;
			continue;
		}
		userid = umGetNextUser(userid);
	}

	if (umCommit(NULL) != 0) {
		strcpy(tmpBuf, T("ERROR: Unable to save user configuration."));
		goto setErr_pass;
	}

	/* Set user account to MIB */
	if ( !apmib_set(MIB_USER_NAME, (void *)strUser) ) {
		strcpy(tmpBuf, T("ERROR: Set user name to MIB database failed."));
		goto setErr_pass;
	}

	if ( !apmib_set(MIB_USER_PASSWORD, (void *)strPassword) ) {
		strcpy(tmpBuf, T("ERROR: Set user password to MIB database failed."));
		goto setErr_pass;
	}

	/* Retrieve next page URL */
	apmib_update(CURRENT_SETTING);
		
	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page

	PROC_MSG();
	OK_MSG(submitUrl);
	return;

setErr_pass:
	ERR_MSG(tmpBuf);
}

////////////////////////////////////////////////////////////////////
void set_user_profile()
{
	/* first time load, get mib */
	if ( !apmib_get( MIB_SUPER_NAME, (void *)superName ) ||
		!apmib_get( MIB_SUPER_PASSWORD, (void *)superPass ) ||
			!apmib_get( MIB_USER_NAME, (void *)userName ) ||
				!apmib_get( MIB_USER_PASSWORD, (void *)userPass ) ) {
		error(E_L, E_LOG, T("Get user account MIB failed"));
		return;
	}

	/* Create umconfig.txt if necessary */
	if ( userName[0] ) {
		/* Create supervisor */
		if ( !umGroupExists(DEFAULT_GROUP) )
			if ( umAddGroup(DEFAULT_GROUP, (short)PRIV_ADMIN, AM_BASIC, FALSE, FALSE) ) {
				error(E_L, E_LOG, T("ERROR: Unable to add group."));
				return;
			}
		if ( !umAccessLimitExists(ACCESS_URL) )
			if ( umAddAccessLimit(ACCESS_URL, AM_FULL, (short)0, DEFAULT_GROUP) ) {
				error(E_L, E_LOG, T("ERROR: Unable to add access limit."));
				return;
			}
		if ( !umUserExists(superName))
			if ( umAddUser(superName, superPass, DEFAULT_GROUP, FALSE, FALSE) ) {
				error(E_L, E_LOG, T("ERROR: Unable to add supervisor account."));
				return;
			}

		/* Create user */
		if ( umUserExists(userName))
			umDeleteUser(userName);

		if ( umAddUser(userName, userPass, DEFAULT_GROUP, FALSE, FALSE) ) {
			error(E_L, E_LOG, T("ERROR: Unable to add user account."));
			return;
		}
	}
}

/////////////////////////////////////////////////////////////////////////////
void formStats(webs_t wp, char_t *path, char_t *query)
{
	char_t *submitUrl;

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page

	if (submitUrl[0])
		websRedirect(wp, submitUrl);
}
