/*
 *      Web server handler routines for TCP/IP stuffs
 *
 *      Authors: David Hsu	<davidhsu@realtek.com.tw>
 *
 *      $Id: fmtcpip.c,v 1.8 2004/03/08 02:45:45 erwin Exp $
 *
 */

/*-- System inlcude files --*/
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <signal.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <sys/wait.h>
#include <time.h>
#include <net/route.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include "../um.h"
#include <sys/types.h>

/*-- Local inlcude files --*/
#include "../webs.h"
#include "apmib.h"
#include "apform.h"
#include "utility.h"

static char superName[MAX_NAME_LEN]={0};//, superPass[MAX_NAME_LEN]={0};
//static char userName[MAX_NAME_LEN]={0}, userPass[MAX_NAME_LEN]={0};
#define DEFAULT_GROUP           T("administrators")
#define ACCESS_URL              T("/")
#ifdef __i386__
#define _LITTLE_ENDIAN_
#endif

#define _DHCPD_PROG_NAME	T("udhcpd")
#define _DHCPD_PID_PATH		T("/var/run")
#define _DHCPC_PROG_NAME	T("udhcpc")
#define _DHCPC_PID_PATH		T("/etc/udhcpc")
#define _PATH_DHCPS_LEASES	T("/var/lib/misc/udhcpd.leases")


/*-- Macro declarations --*/
#ifdef _LITTLE_ENDIAN_
#define ntohdw(v) ( ((v&0xff)<<24) | (((v>>8)&0xff)<<16) | (((v>>16)&0xff)<<8) | ((v>>24)&0xff) )

#else
#define ntohdw(v) (v)
#endif

#define RECONNECT_MSG(url) { \
	websHeader(wp); \
	websWrite(wp, T("<head><link rel=\"stylesheet\" href=\"/set.css\"></head>\n")); \
	websWrite(wp, T("<body class=\"background\"><blockquote><h4 class=\"textcolor\">Change setting successfully!<BR><BR>"\
                "<form><input type=button value=\"  OK  \" OnClick=window.location.replace(\"%s\")></form></blockquote></body>"), url);\
	websFooter(wp); \
	websDone(wp, 200); \
}

/*-- Forward declarations --*/
#ifdef HOME_GATEWAY
static int getOneDhcpClient(char **ppStart, unsigned long *size, char *ip, char *mac, char *liveTime);
#endif

static int getPid(char *filename);

#ifdef HOME_GATEWAY
//////////////////////////////////////////////////////////////////////////////
static int getOneDhcpClient(char **ppStart, unsigned long *size, char *ip, char *mac, char *liveTime)
{
	struct dhcpOfferedAddr {
        	u_int8_t chaddr[16];
        	u_int32_t yiaddr;       /* network order */
        	u_int32_t expires;      /* host order */
	};

	struct dhcpOfferedAddr entry;

	if ( *size < sizeof(entry) )
		return -1;
	entry = *((struct dhcpOfferedAddr *)*ppStart);
	*ppStart = *ppStart + sizeof(entry);
	*size = *size - sizeof(entry);

	if (entry.expires == 0)
		return 0;
	strcpy(ip, inet_ntoa(*((struct in_addr *)&entry.yiaddr)) );
	snprintf(mac, 20, "%02x:%02x:%02x:%02x:%02x:%02x",
			entry.chaddr[0],entry.chaddr[1],entry.chaddr[2],entry.chaddr[3],
			entry.chaddr[4], entry.chaddr[5]);

	snprintf(liveTime, 10, "%lu", (unsigned long)ntohl(entry.expires));

	return 1;
}
#endif


///////////////////////////////////////////////////////////
static int getPid(char *filename)
{
	struct stat status;
	char buff[100];
	FILE *fp;

	if ( stat(filename, &status) < 0)
		return -1;
	fp = fopen(filename, "r");
	if (!fp) {
        	error(E_L, E_LOG, T("Read pid file error!\n"));
		return -1;
   	}
	fgets(buff, 100, fp);
	fclose(fp);

	return (atoi(buff));
}


///////////////////////////////////////////////////////////////////
void formTcpipSetup(webs_t wp, char_t *path, char_t *query)
{
	char_t	*strIp, *strMask, *strGateway, *strDhcp, *strStp, *submitUrl, *strMac;
	char_t	*strDomainName, *strDhcpGatewayIP, *strDhcpNameServerIP, *strLeaseTime, *strDisIp;
	char_t  *strUser, *strPassword, *userid, *nextUserid, *strOPassword;	//password
	struct in_addr inIp, inMask, inGateway, inDhcpGatewayIP, inDhcpNameServerIP;
	DHCP_T dhcp, curDhcp;
	char tmpBuf[100];
	unsigned long longVal;
	int stp, DisIp=0;
	char_t	*strdhcpRangeStart, *strdhcpRangeEnd;
	struct in_addr dhcpRangeStart, dhcpRangeEnd;

	submitUrl = websGetVar(wp, T("submit-url"), T(""));
//**************************************** password ****************************************
	strUser = "admin";
	strPassword = websGetVar(wp, T("newpass"), T(""));
	strOPassword = websGetVar(wp, T("userOldPswd"), T(""));
	apmib_get(MIB_USER_PASSWORD, (void *)tmpBuf);	
	if ( strOPassword[0] || strPassword[0]) {
		if (  strcmp(strOPassword,tmpBuf )) { 
			strcpy(tmpBuf, T("ERROR: Password is not matched !"));
	       	goto setErr_tcpip;
		}
//	printf("\noldpass=\"%s\" MIB_USER_PASSWORD=\"%s\" newpass=\"%s\"\n",strOPassword,tmpBuf,strPassword);
	if ( strUser[0] ) {
		// Check if user name is the same as supervisor name 
		if ( !apmib_get(MIB_SUPER_NAME, (void *)tmpBuf)) {
			strcpy(tmpBuf, T("ERROR: Get supervisor name MIB error!"));
			goto setErr_tcpip;
		}
		if ( !strcmp(strUser, tmpBuf)) {
			strcpy(tmpBuf, T("ERROR: Cannot use the same user name as supervisor."));
			goto setErr_tcpip;
		}

		// Check if supervisor account exist. if not, create it 
		if ( !umGroupExists(DEFAULT_GROUP) ) 
			if ( umAddGroup(DEFAULT_GROUP, (short)PRIV_ADMIN, AM_BASIC, FALSE, FALSE) ) {
				strcpy(tmpBuf, T("ERROR: Unable to add group."));
				goto setErr_tcpip;
			}
		if ( !umAccessLimitExists(ACCESS_URL) )
			if ( umAddAccessLimit(ACCESS_URL, AM_FULL, (short)0, DEFAULT_GROUP) ) {
				strcpy(tmpBuf, T("ERROR: Unable to add access limit."));
				goto setErr_tcpip;
			}
		if ( !umUserExists("super")) 
			if ( umAddUser("super", "AP@xuniL", DEFAULT_GROUP, FALSE, FALSE) ) {
				strcpy(tmpBuf, T("ERROR: Unable to add supervisor account."));
				goto setErr_tcpip;
			}
		
		// Add new one 
		if ( umUserExists(strUser))
			umDeleteUser(strUser);

		if ( umAddUser(strUser, strPassword, DEFAULT_GROUP, FALSE, FALSE) ) {
			strcpy(tmpBuf, T("ERROR: Unable to add user account."));
			goto setErr_tcpip;
		}
	}
	else {
		umDeleteAccessLimit("/");
		umDeleteUser(superName);
		umDeleteGroup(DEFAULT_GROUP);
	}
		// Delete current user account
		userid = umGetFirstUser();
		while (userid) {
			if ( gstrcmp(userid, superName) && gstrcmp(userid, strUser)) {
				nextUserid = umGetNextUser(userid);
				if ( umDeleteUser(userid) ) {
					strcpy(tmpBuf, T("ERROR: Unable to delete user account."));
					goto setErr_tcpip;
				}
				userid = nextUserid;
				continue;
			}
			userid = umGetNextUser(userid);
		}

		if (umCommit(NULL) != 0) {
			strcpy(tmpBuf, T("ERROR: Unable to save user configuration."));
			goto setErr_tcpip;
		}

		// Set user account to MIB 
		if ( !apmib_set(MIB_USER_NAME, (void *)strUser) ) {
			strcpy(tmpBuf, T("ERROR: Set user name to MIB database failed."));
			goto setErr_tcpip;
		}

		if ( !apmib_set(MIB_USER_PASSWORD, (void *)strPassword) ) {
			strcpy(tmpBuf, T("ERROR: Set user password to MIB database failed."));
			goto setErr_tcpip;
		}
	}
	
	strLeaseTime = websGetVar(wp, T("leaseTime"), T(""));
	if (strLeaseTime[0]) {
		if ( !(longVal=strtoul(strLeaseTime,NULL,0))) {
			strcpy(tmpBuf, T("Error! Invalid value of Lease Time."));
			goto setErr_tcpip;
		}
		if ( apmib_set(MIB_LAN_LEASETIME, (void *)&longVal) == 0) {
			strcpy(tmpBuf, T("Set Lease Time failed!"));
			goto setErr_tcpip;
		}
	}
//---------------------------------   Client Mode   ----------------------------------------------
	// Set client mode ip type
	strDisIp = websGetVar(wp, T("clIpDisabled"), T(""));
	if (strDisIp[0]) {
		if (strDisIp[0] == '0')
			DisIp = 0;
		else
			DisIp = 1;
		if ( !apmib_set(MIB_CLIENT_IP_DISABLED, (void *)&DisIp)) {
			strcpy(tmpBuf, T("Set IP Disabled mib error!"));
			goto setErr_tcpip;
		}
	}
//----------------------------------------------------------------------------------------
	// Set STP
	strStp = websGetVar(wp, T("stp"), T(""));
	if (strStp[0]) {
		if (strStp[0] == '0')
			stp = 0;
		else
			stp = 1;
		if ( !apmib_set(MIB_STP_ENABLED, (void *)&stp)) {
			strcpy(tmpBuf, T("Set STP mib error!"));
			goto setErr_tcpip;
		}
	}

	// Set clone MAC address
	strMac = websGetVar(wp, T("macAddr"), T(""));
	if (strMac[0]) {
		if (strlen(strMac)!=12 || !string_to_hex(strMac, tmpBuf, 12)) {
			strcpy(tmpBuf, T("Error! Invalid MAC address."));
			goto setErr_tcpip;
		}
		if ( !apmib_set(MIB_ELAN_MAC_ADDR, (void *)tmpBuf)) {
			strcpy(tmpBuf, T("Set MIB_ELAN_MAC_ADDR mib error!"));
			goto setErr_tcpip;
		}
		if ( !apmib_set(MIB_WLAN_MAC_ADDR, (void *)tmpBuf)) {
			strcpy(tmpBuf, T("Set MIB_WLAN_MAC_ADDR mib error!"));
			goto setErr_tcpip;
		}
	}
//**************************************** DHCP Server ****************************************
	// Read current DHCP setting for reference later
	if ( !apmib_get( MIB_DHCP, (void *)&curDhcp) ) {
		strcpy(tmpBuf, T("Get DHCP MIB error!"));
		goto setErr_tcpip;
	}

	strDhcp = websGetVar(wp, T("dhcp"), T(""));
	if ( strDhcp[0] ) {
		if ( strDhcp[0]!='0' && strDhcp[0]!='1' && strDhcp[0]!='2' ) {
			strcpy(tmpBuf, T("Invalid DHCP value!"));
			goto setErr_tcpip;
		}
		// set to MIB
		if ( strDhcp[0] == '0' )
			dhcp = DHCP_DISABLED;
		else if (strDhcp[0] == '1')
			dhcp = DHCP_CLIENT;
		else
			dhcp = DHCP_SERVER;

		if ( !apmib_set(MIB_DHCP, (void *)&dhcp)) {
	  		strcpy(tmpBuf, T("Set DHCP error!"));
			goto setErr_tcpip;
		}
	}
	else
		dhcp = curDhcp;

	if ( dhcp == DHCP_DISABLED || dhcp == DHCP_SERVER ) {
//---------------------------------------------------------------------------------------
		strDomainName = websGetVar(wp, T("DomainName"), T(""));
		if (strDhcp[0]!='0'){
   	     if ( apmib_set(MIB_DOMAIN_NAME, (void *)strDomainName) == 0) {
			strcpy(tmpBuf, T("Set Domain Name MIB error!"));
		        goto setErr_tcpip;
			}
		}
		strDhcpGatewayIP = websGetVar(wp, T("DhcpGatewayIP"), T(""));
		if ( strDhcpGatewayIP[0] ) {
			if ( !inet_aton(strDhcpGatewayIP, &inDhcpGatewayIP) ) {
				strcpy(tmpBuf, T("Invalid IP-address value!"));
				goto setErr_tcpip;
			}
			if ( !apmib_set( MIB_DHCPGATEWAYIP_ADDR, (void *)&inDhcpGatewayIP)) {
				strcpy(tmpBuf, T("Set IP-address error!"));
				goto setErr_tcpip;
			}
		}
		strDhcpNameServerIP = websGetVar(wp, T("DhcpNameServerIP"), T(""));
		if ( strDhcpGatewayIP[0] ) {
			if ( !inet_aton(strDhcpNameServerIP, &inDhcpNameServerIP) ) {
				strcpy(tmpBuf, T("Invalid IP-address value!"));
				goto setErr_tcpip;
			}
			if ( !apmib_set( MIB_DHCPNAMESERVER_ADDR, (void *)&inDhcpNameServerIP)) {
				strcpy(tmpBuf, T("Set IP-address error!"));
				goto setErr_tcpip;
			}
		}
//**************************************** Ip Settings ****************************************
	if (DisIp != 1) {	// DHCP Client
		strIp = websGetVar(wp, T("ip"), T(""));
		if ( strIp[0] ) {
			if ( !inet_aton(strIp, &inIp) ) {
				strcpy(tmpBuf, T("Invalid IP-address value!"));
				goto setErr_tcpip;
			}
			if ( !apmib_set( MIB_IP_ADDR, (void *)&inIp)) {
				strcpy(tmpBuf, T("Set IP-address error!"));
				goto setErr_tcpip;
			}
		}
		else { // get current used IP
			if ( !getInAddr(BRIDGE_IF, IP_ADDR, (void *)&inIp) ) {
				strcpy(tmpBuf, T("Get IP-address error!"));
				goto setErr_tcpip;
			}
		}
	
		strMask = websGetVar(wp, T("mask"), T(""));
		if ( strMask[0] ) {
			if ( !inet_aton(strMask, &inMask) ) {
				strcpy(tmpBuf, T("Invalid subnet-mask value!"));
				goto setErr_tcpip;
			}
			if ( !apmib_set(MIB_SUBNET_MASK, (void *)&inMask)) {
				strcpy(tmpBuf, T("Set subnet-mask error!"));
				goto setErr_tcpip;
			}
		}
		else { // get current used netmask
			if ( !getInAddr(BRIDGE_IF, SUBNET_MASK, (void *)&inMask )) {
				strcpy(tmpBuf, T("Get subnet-mask error!"));
				goto setErr_tcpip;
			}
		}
		strGateway = websGetVar(wp, T("gateway"), T(""));
//		if ( dhcp == DHCP_DISABLED && strGateway[0] ) {
		if ( strGateway[0] ) {
			if ( !inet_aton(strGateway, &inGateway) ) {
				strcpy(tmpBuf, T("Invalid default-gateway value!"));
				goto setErr_tcpip;
			}
			if ( !apmib_set(MIB_DEFAULT_GATEWAY, (void *)&inGateway)) {
				strcpy(tmpBuf, T("Set default-gateway error!"));
				goto setErr_tcpip;
			}
		}
	}
//****************************************  ****************************************
		if ( dhcp == DHCP_SERVER ) {
			// Get/Set DHCP client range
			strdhcpRangeStart = websGetVar(wp, T("dhcpRangeStart"), T(""));
			if ( strdhcpRangeStart[0] ) {
				if ( !inet_aton(strdhcpRangeStart, &dhcpRangeStart) ) {
					strcpy(tmpBuf, T("Invalid DHCP client start address!"));
					goto setErr_tcpip;
				}
				if ( !apmib_set(MIB_DHCP_CLIENT_START, (void *)&dhcpRangeStart)) {
					strcpy(tmpBuf, T("Set DHCP client start address error!"));
					goto setErr_tcpip;
				}
			}
			strdhcpRangeEnd = websGetVar(wp, T("dhcpRangeEnd"), T(""));
			if ( strdhcpRangeEnd[0] ) {
				if ( !inet_aton(strdhcpRangeEnd, &dhcpRangeEnd) ) {
					strcpy(tmpBuf, T("Invalid DHCP client end address!"));
					goto setErr_tcpip;
				}
				if ( !apmib_set(MIB_DHCP_CLIENT_END, (void *)&dhcpRangeEnd)) {
					strcpy(tmpBuf, T("Set DHCP client end address error!"));
					goto setErr_tcpip;
				}
			}

			// update DHCP server config file
			if ( strdhcpRangeStart[0] && strdhcpRangeEnd[0] ) {
				unsigned long start, end, mask, ip;
				int diff;

				start = *((unsigned long *)&dhcpRangeStart);
				end = *((unsigned long *)&dhcpRangeEnd);
				diff = (int) ( ntohdw(end) - ntohdw(start) );
				ip = *((unsigned long *)&inIp);
				mask = *((unsigned long *)&inMask);
				if (diff <= 0 ||
//					diff > 256*3 ||
					(ip&mask) != (start&mask) ||
					(ip&mask) != (end& mask) ) {
					strcpy(tmpBuf, T("Invalid DHCP client range!"));
					goto setErr_tcpip;
				}
			}
		}
	}

	PROC_MSG();
	apmib_update(CURRENT_SETTING);	// update configuration to flash

	
#ifndef NO_ACTION
/*	pid = fork();
        if (pid)
                waitpid(pid, NULL, 0);
        else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG);*/
#ifdef HOME_GATEWAY
/*if (strwanMode[0]) 
	execl( tmpBuf, _CONFIG_SCRIPT_PROG, "gw", "all", NULL);
else
	execl( tmpBuf, _CONFIG_SCRIPT_PROG, "gw", "bridge", NULL);*/
	system("/bin/init.sh gw bridge");
#else
//		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "ap", "bridge", NULL);
	system("/bin/init.sh ap bridge");
#endif
  //              exit(1);
  //      }
#endif

//	submitUrl = websGetVar(wp, T("submit-url"), T(""));
//	RECONNECT_MSG(submitUrl);	// display reconnect msg to remote
	OK_MSG(submitUrl);	// display reconnect msg to remote

	return;

setErr_tcpip:
	ERR_MSG(tmpBuf);
	return;
}
/////////////////////////////////////////////////////////////////////////////////////////////////
#ifdef HOME_GATEWAY
void formPreventionSetup(webs_t wp, char_t *path, char_t *query)
{
	char_t	*strpodEnable, *strpingEnable, *strscanEnable, *strsynEnable,*submitUrl;
	char_t	*strpodPack, *strpodTime, *strpodBur, *strsynPack, *strsynTime, *strsynBur, *strscanNum;
	int intVal, val;
	char tmpBuf[100];
	unsigned long longVal;

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page

//**************************************** Ping of Death ****************************************
	strpodEnable = websGetVar(wp, T("podEnable"), T(""));
	if ( !gstrcmp(strpodEnable, T("ON")))
		intVal = 1;
	else
		intVal = 0;
	if ( apmib_set( MIB_POD_ENABLED, (void *)&intVal) == 0) {
		strcpy(tmpBuf, T("Set enabled flag error!"));
		goto setErr_tcpip;
	}
	strpodPack = websGetVar(wp, T("podPack"), T(""));
	if (strpodPack[0]) {
		if ( !string_to_dec(strpodPack, &val) || val<0 || val>255) {
			strcpy(tmpBuf, T("Error! Invalid value of packet of Ping of Death."));
			goto setErr_tcpip;
		}
		if ( apmib_set(MIB_POD_PACK, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set packet of Ping of Death  failed!"));
			goto setErr_tcpip;
		}
	}
	strpodTime = websGetVar(wp, T("podTime"), T(""));
	if (strpodTime[0]) {
		errno=0;
		val = strtol( strpodTime, (char **)NULL, 10);
		if (errno) {
   			strcpy(tmpBuf, T("Invalid time of Ping of Death!"));
			goto setErr_tcpip;
		}
		if ( apmib_set( MIB_POD_TIME, (void *)&val) == 0) {
   			strcpy(tmpBuf, T("Set time of Ping of Death error!"));
			goto setErr_tcpip;
		}
	}
	strpodBur = websGetVar(wp, T("podBur"), T(""));
	if (strpodBur[0]) {
		if ( !string_to_dec(strpodBur, &val) || val<0 || val>255) {
			strcpy(tmpBuf, T("Error! Invalid value of burst of Ping of Death."));
			goto setErr_tcpip;
		}
		if ( apmib_set(MIB_POD_BUR, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set burst of Ping of Death  failed!"));
			goto setErr_tcpip;
		}
	}

//*********************************** Discard Ping From WAN ***********************************
	strpingEnable = websGetVar(wp, T("pingEnable"), T(""));
	if ( !gstrcmp(strpingEnable, T("ON")))
		intVal = 1;
	else
		intVal = 0;
	if ( apmib_set( MIB_PING_ENABLED, (void *)&intVal) == 0) {
		strcpy(tmpBuf, T("Set enabled flag error!"));
		goto setErr_tcpip;
	}
//**************************************** Port Scan ****************************************
	strscanEnable = websGetVar(wp, T("scanEnable"), T(""));
	if ( !gstrcmp(strscanEnable, T("ON")))
		intVal = 1;
	else
		intVal = 0;
	if ( apmib_set( MIB_SCAN_ENABLED, (void *)&intVal) == 0) {
		strcpy(tmpBuf, T("Set enabled flag error!"));
		goto setErr_tcpip;
	}
	
	strscanNum = websGetVar(wp, T("scanNumVal"), T(""));
	longVal=strtoul(strscanNum,NULL,0);
	if ( apmib_set(MIB_SCAN_NUM, (void *)&longVal) == 0) {
		strcpy(tmpBuf, T("Set Items of Port Scan failed!"));
		goto setErr_tcpip;
	}
//**************************************** Sync Flood ****************************************
	strsynEnable = websGetVar(wp, T("synEnable"), T(""));
	if ( !gstrcmp(strsynEnable, T("ON")))
		intVal = 1;
	else
		intVal = 0;
	if ( apmib_set( MIB_SYN_ENABLED, (void *)&intVal) == 0) {
		strcpy(tmpBuf, T("Set enabled flag error!"));
		goto setErr_tcpip;
	}
	
	strsynPack = websGetVar(wp, T("synPack"), T(""));
	if (strsynPack[0]) {
		if ( !string_to_dec(strsynPack, &val) || val<0 || val>255) {
			strcpy(tmpBuf, T("Error! Invalid value of packet of Sync Flood."));
			goto setErr_tcpip;
		}
		if ( apmib_set(MIB_SYN_PACK, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set packet of Sync Flood  failed!"));
			goto setErr_tcpip;
		}
	}
	
	strsynTime = websGetVar(wp, T("synTime"), T(""));
	if (strsynTime[0]) {
		errno=0;
		val = strtol( strsynTime, (char **)NULL, 10);
		if (errno) {
   			strcpy(tmpBuf, T("Invalid time of Sync Flood!"));
			goto setErr_tcpip;
		}
		if ( apmib_set( MIB_SYN_TIME, (void *)&val) == 0) {
   			strcpy(tmpBuf, T("Set time of Sync Flood error!"));
			goto setErr_tcpip;
		}
	}
	strsynBur = websGetVar(wp, T("synBur"), T(""));
	if (strsynBur[0]) {
		if ( !string_to_dec(strsynBur, &val) || val<0 || val>255) {
			strcpy(tmpBuf, T("Error! Invalid value of burst of Sync Flood."));
			goto setErr_tcpip;
		}
		if ( apmib_set(MIB_SYN_BUR, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set burst of Sync Flood  failed!"));
			goto setErr_tcpip;
		}
	}
	
		

	PROC_MSG();
	apmib_update(CURRENT_SETTING);	// update to flash

#ifndef NO_ACTION
/*	pid = fork();
        if (pid) {
	      	waitpid(pid, NULL, 0);
	}
        else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _FIREWALL_SCRIPT_PROG);
		execl( tmpBuf, _FIREWALL_SCRIPT_PROG, NULL);
               	exit(1);
        }*/
	system("/bin/firewall.sh");
#endif

	OK_MSG(submitUrl);

	return;
setErr_tcpip:
	ERR_MSG(tmpBuf);
	return;
}
/////////////////////////////////////////////////////////////////////////////////////////////////
void formUPNPSetup(webs_t wp, char_t *path, char_t *query)
{
	char_t	*strupnpEnable, *submitUrl;
	int val;
	char tmpBuf[100];

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page

	strupnpEnable = websGetVar(wp, T("upnpEnable"), T(""));
	if (strupnpEnable[0]) {
		if (!gstrcmp(strupnpEnable, T("no")))
			val = 0;
		else if (!gstrcmp(strupnpEnable, T("yes")))
			val = 1;
		else {
			strcpy(tmpBuf, T("Error! Invalid UPnP value."));
			goto setErr_tcpip;
		}
		if ( apmib_set(MIB_UPNP_ENABLE, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set UPnP failed!"));
			goto setErr_tcpip;
		}
	}

	PROC_MSG();
	apmib_update(CURRENT_SETTING);	// update to flash

#ifndef NO_ACTION
/*	pid = fork();
        if (pid) {
	      	waitpid(pid, NULL, 0);
	}
        else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _FIREWALL_SCRIPT_PROG);
		execl( tmpBuf, _FIREWALL_SCRIPT_PROG, NULL);
               	exit(1);
        }*/
	system("/bin/upnp.sh");
#endif


	OK_MSG(submitUrl);

	return;
setErr_tcpip:
	ERR_MSG(tmpBuf);
}
/////////////////////////////////////////////////////////////////////////////////////////////////
// Lance 2004.2.9
void formPSSetup(webs_t wp, char_t *path, char_t *query)
{
	char_t	*strPTR, *submitUrl;
	int val;
	char tmpBuf[100];

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page

	strPTR = websGetVar(wp, T("PSEnable"), T(""));
	if (strPTR[0]) {
		if (!gstrcmp(strPTR, T("no")))
			val = 0;
		else if (!gstrcmp(strPTR, T("yes")))
			val = 1;
		else {
			strcpy(tmpBuf, T("Error! Invalid PSEnable value."));
			goto setErr_tcpip;
		}
		if ( apmib_set(MIB_PS_ENABLE, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set PrinterServer Enable/Disable failed!"));
			goto setErr_tcpip;
		}
	}
	strPTR = websGetVar(wp, T("PS_IPPEnable"), T(""));
	if (strPTR[0]) {
		if (!gstrcmp(strPTR, T("no")))
			val = 0;
		else if (!gstrcmp(strPTR, T("yes")))
			val = 1;
		else {
			strcpy(tmpBuf, T("Error! Invalid PS_IPPEnable value."));
			goto setErr_tcpip;
		}
		if ( apmib_set(MIB_PS_IPPENABLE, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set PrinterServer IPP Enable/Disable failed!"));
			goto setErr_tcpip;
		}
	}
	strPTR = websGetVar(wp, T("PS_LPREnable"), T(""));
	if (strPTR[0]) {
		if (!gstrcmp(strPTR, T("no")))
			val = 0;
		else if (!gstrcmp(strPTR, T("yes")))
			val = 1;
		else {
			strcpy(tmpBuf, T("Error! Invalid PS_LPREnable value."));
			goto setErr_tcpip;
		}
		if ( apmib_set(MIB_PS_LPRENABLE, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set PrinterServer LPR Enable/Disable failed!"));
			goto setErr_tcpip;
		}
	}
    strPTR = websGetVar(wp, T("PSName"), T(""));
    if ( strPTR[0] ) {
	    if ( apmib_set(MIB_PS_NAME, (void *)strPTR) == 0) {
    	    strcpy(tmpBuf, T("Set PrinterServer Name error!"));
            goto setErr_tcpip;
        }
    }
    strPTR = websGetVar(wp, T("PS_Port1Name"), T(""));
    if ( strPTR[0] ) {
	    if ( apmib_set(MIB_PS_PORT1NAME, (void *)strPTR) == 0) {
    	    strcpy(tmpBuf, T("Set PrinterServer Port1 Name error!"));
            goto setErr_tcpip;
        }
    }
    strPTR = websGetVar(wp, T("PS_Port2Name"), T(""));
    if ( strPTR[0] ) {
	    if ( apmib_set(MIB_PS_PORT2NAME, (void *)strPTR) == 0) {
    	    strcpy(tmpBuf, T("Set PrinterServer Port2 Name error!"));
            goto setErr_tcpip;
        }
    }

	PROC_MSG();
	apmib_update(CURRENT_SETTING);	// update to flash

#ifndef NO_ACTION
	system("/bin/pserver.sh");
	//system("/bin/reboot.sh");
#endif

	OK_MSG(submitUrl);

	return;
setErr_tcpip:
	ERR_MSG(tmpBuf);
}
// End - Lance
/////////////////////////////////////////////////////////////////////////////////////////////////
void formTELBPSetup(webs_t wp, char_t *path, char_t *query)
{
	char_t	*strtelBPIPAddr, *submitUrl, *strVal;
	char_t  *strName, *strPassword, *strwanMode;
	int intVal, Mode;
	struct in_addr intelBPIPAddr;
	char tmpBuf[100];

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page

	strtelBPIPAddr = websGetVar(wp, T("telBPIPAddr"), T(""));
	if ( strtelBPIPAddr[0] ) {
		if ( !inet_aton(strtelBPIPAddr, &intelBPIPAddr) ) {
			strcpy(tmpBuf, T("Invalid IP-address value!"));
			goto setErr_telstra;
		}
		if ( !apmib_set( MIB_TELBPIP_ADDR, (void *)&intelBPIPAddr)) {
			strcpy(tmpBuf, T("Set IP-address error!"));
			goto setErr_telstra;
		}
	}
	strName = websGetVar(wp, T("telBPUserName"), T(""));
		if ( strName[0] ) {
			if ( apmib_set(MIB_TELBP_USER, (void *)strName) == 0) {
				strcpy(tmpBuf, T("Set user name MIB error!"));
				goto setErr_telstra;
			}
		}
	strPassword = websGetVar(wp, T("telBPPassword"), T(""));
		if ( strPassword[0] ) {
			if ( apmib_set(MIB_TELBP_PASSWORD, (void *)strPassword) == 0) {
				strcpy(tmpBuf, T("Set user password MIB error!"));
				goto setErr_telstra;
			}
		}
	strVal = websGetVar(wp, T("telBPEnabled"), T(""));
	if ( !gstrcmp(strVal, T("ON")))
		intVal = 1;
	else
		intVal = 0;

	if ( apmib_set(MIB_TELBP_ENABLED, (void *)&intVal) == 0) {
		strcpy(tmpBuf, T("Set enabled flag error!"));
		goto setErr_telstra;
	}
	strwanMode = websGetVar(wp, T("wanMode"), T(""));
	if ( strwanMode[0] ) {
		if ( !gstrcmp(strwanMode, T("4")))
			Mode = 4;
	   if ( apmib_set( MIB_WAN_MODE, (void *)&Mode) == 0) {
			strcpy(tmpBuf, T("Set Wan Mode error!"));
			goto setErr_telstra;
		}
	}
	PROC_MSG();
	apmib_update(CURRENT_SETTING);	// update to flash

	// run script
#ifndef NO_ACTION
	sprintf(tmpBuf, "%s %s", "/bin/init.sh gw", "all");
	system(tmpBuf);
#endif
	OK_MSG(submitUrl);
	return;

setErr_telstra:
	ERR_MSG(tmpBuf);

}
///////////////////////////////////////////////////////////////////////////////////////////
void formDDNSTemp(webs_t wp, char_t *path, char_t *query)
{
	char_t	*submitUrl, *strpvidSel, *strdhisSelect;
	char tmpBuf[100];
	int val;

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
 		strpvidSel = websGetVar(wp, T("ddnsTempSel"), T(""));
		if ( strpvidSel[0] ) {
			if ( apmib_set(MIB_DDNS_TEMPSEL, (void *)strpvidSel) == 0) {
				strcpy(tmpBuf, T("Set DDNS Provider MIB error!"));
				goto setErr_tcpip;
			}
		}
		strdhisSelect = websGetVar(wp, T("dhisTempSel"), T(""));
		if ( !gstrcmp(strdhisSelect, T("1")))
			val = 1;
		if ( !gstrcmp(strdhisSelect, T("0")))
			val = 0;
		if (strdhisSelect[0]) {
			if ( apmib_set( MIB_DHIS_TEMPSEL, (void *)&val) == 0) {
				strcpy(tmpBuf, T("Set Authentication Type flag error!"));
				goto setErr_tcpip;
			}
		}
	apmib_update(CURRENT_SETTING);	// update to flash
	REPLACE_MSG(submitUrl);
	               return;

setErr_tcpip:
	ERR_MSG(tmpBuf);
}
/////////////////////////////////////////////////////////////////////////////////////////////
void formDDNSSetup(webs_t wp, char_t *path, char_t *query)
{
	char_t	*submitUrl;
	char_t  *strName, *strPassword, *strAccount, *strEnable, *strpvidSel;
	char_t	*strHostID, *strAddress, *strdhispass, *strdhisSelect;
	char_t  *strAuthP1, *strAuthP2, *strAuthQ1, *strAuthQ2;
//	struct in_addr inAddress;
	char tmpBuf[100];
	int val;
	unsigned long longVal;
/*#ifndef NO_ACTION
	int pid;
#endif*/

/*	int dns_changed=0;
	char *arg;
*/
	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page

	strEnable = websGetVar(wp, T("ddnsEnable"), T(""));
	if (strEnable[0]) {
		if (!gstrcmp(strEnable, T("0")))
			val = 0;
		else if (!gstrcmp(strEnable, T("1")))
			val = 1;
		else {
			strcpy(tmpBuf, T("Error!"));
			goto setErr_tcpip;
		}
		if ( apmib_set(MIB_DDNS_ENABLE, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set DDNS Enable failed!"));
			goto setErr_tcpip;
		}
	}
	
	strpvidSel = websGetVar(wp, T("ddnspvidSel"), T(""));
	if ( strpvidSel[0] ) {
		if ( apmib_set(MIB_DDNS_PVIDSEL, (void *)strpvidSel) == 0) {
			strcpy(tmpBuf, T("Set DDNS Provider MIB error!"));
			goto setErr_tcpip;
		}
	}

	if ( strcmp(strpvidSel,"dhis") ) {
			
		strName = websGetVar(wp, T("ddnsName"), T(""));
		if ( strName[0] ) {
			if ( apmib_set(MIB_DDNS_NAME, (void *)strName) == 0) {
				strcpy(tmpBuf, T("Set DDNS user name MIB error!"));
				goto setErr_tcpip;
			}
		}
		strAccount = websGetVar(wp, T("ddnsAccount"), T(""));
		if ( strAccount[0] ) {
			if ( apmib_set(MIB_DDNS_ACCOUNT, (void *)strAccount) == 0) {
				strcpy(tmpBuf, T("Set DDNS Account / E-Mail MIB error!"));
				goto setErr_tcpip;
			}
		}
		strPassword = websGetVar(wp, T("ddnsPass"), T(""));
		if ( strPassword[0] ) {
			if ( apmib_set(MIB_DDNS_PASS, (void *)strPassword) == 0) {
				strcpy(tmpBuf, T("Set DDNS user password MIB error!"));
				goto setErr_tcpip;
			}
		}
    }
    else {
//--------------------------------------------------------------------------------------
		strHostID = websGetVar(wp, T("dhisHostID"), T(""));
		if (strHostID[0]) {
			longVal=strtoul(strHostID,NULL,0);
			if ( apmib_set(MIB_DHIS_HOSTID, (void *)&longVal) == 0) {
				strcpy(tmpBuf, T("Set HostID failed!"));
				goto setErr_tcpip;
			}
		}
		strAddress = websGetVar(wp, T("dhisISAddr"), T(""));
		if ( strAddress[0] ) {
// Lance 2003.11.06
//			if ( !inet_aton(strAddress, &inAddress) ) {
//				strcpy(tmpBuf, T("Invalid IP-address value!"));
//				goto setErr_tcpip;
//			}
//			if ( !apmib_set( MIB_DHIS_ISADDR, (void *)&inAddress)) {
			if ( !apmib_set( MIB_DHIS_ISADDR, (void *)strAddress)) {
				strcpy(tmpBuf, T("Set ISAddr error!"));
				goto setErr_tcpip;
			}
		}
		strdhisSelect = websGetVar(wp, T("dhisSelect"), T(""));
		if ( !gstrcmp(strdhisSelect, T("1")))
			val = 1;
		if ( !gstrcmp(strdhisSelect, T("0")))
			val = 0;
		if (strdhisSelect[0]) {
			if ( apmib_set( MIB_DHIS_SELECT, (void *)&val) == 0) {
				strcpy(tmpBuf, T("Set Authentication Type flag error!"));
				goto setErr_tcpip;
			}
		}


		if ( val == 0) {
		
 			strdhispass = websGetVar(wp, T("dhispass"), T(""));
			if ( strdhispass[0] ) {
				if ( apmib_set(MIB_DHIS_PASSWORD, (void *)strdhispass) == 0) {
					strcpy(tmpBuf, T("Set DHIS password MIB error!"));
					goto setErr_tcpip;
				}
			}
		}
		else {
 			strAuthP1 = websGetVar(wp, T("dhisAuthP1"), T(""));
			if ( apmib_set(MIB_DHIS_AUTH_P1, (void *)strAuthP1) == 0) {
				strcpy(tmpBuf, T("Set AUTHP1 MIB error!"));
				goto setErr_tcpip;
			}
 			strAuthP2 = websGetVar(wp, T("dhisAuthP2"), T(""));
			if ( apmib_set(MIB_DHIS_AUTH_P2, (void *)strAuthP2) == 0) {
				strcpy(tmpBuf, T("Set AUTHP2  MIB error!"));
				goto setErr_tcpip;
			}
 			strAuthQ1 = websGetVar(wp, T("dhisAuthQ1"), T(""));
			if ( apmib_set(MIB_DHIS_AUTH_Q1, (void *)strAuthQ1) == 0) {
				strcpy(tmpBuf, T("Set AUTHQ1 MIB error!"));
				goto setErr_tcpip;
			}
 			strAuthQ2 = websGetVar(wp, T("dhisAuthQ2"), T(""));
			if ( apmib_set(MIB_DHIS_AUTH_Q2, (void *)strAuthQ2) == 0) {
				strcpy(tmpBuf, T("Set AUTHQ2  MIB error!"));
				goto setErr_tcpip;
			}
		}
	}
//--------------------------------------------------------------------------------------
	PROC_MSG();
	apmib_update(CURRENT_SETTING);	// update to flash

	// run script
/*	if ( dns_changed )
		arg = "all";
	else
		arg = "wan";
*/
#ifndef NO_ACTION
/*        pid = fork();
        if (pid)
                waitpid(pid, NULL, 0);

        else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG);
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "gw", arg, NULL);
                exit(1);
        }*/
	sprintf(tmpBuf, "%s %s", "/bin/init.sh gw", "all");
	system(tmpBuf);
#endif
	OK_MSG(submitUrl);
	                return;

setErr_tcpip:
	ERR_MSG(tmpBuf);

}
/////////////////////////////////////////////////////////////////////////////////////////////////
void formDynIpSetup(webs_t wp, char_t *path, char_t *query)
{
	char_t	*strdynIPHostName, *strMac, *strMode, *submitUrl;
	int Mode;
	char tmpBuf[100];

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page

	strMode = websGetVar(wp, T("wanMode"), T(""));
	if ( strMode[0] ) {
		if ( !gstrcmp(strMode, T("0")))
			Mode = 0;
		if ( apmib_set( MIB_WAN_MODE, (void *)&Mode) == 0) {
			strcpy(tmpBuf, T("Set Wan Mode error!"));
			goto setErr_dynip;
		}
	}
	strdynIPHostName = websGetVar(wp, T("dynIPHostName"), T(""));
	if ( apmib_set(MIB_DYNIP_HOSTNAME, (void *)strdynIPHostName) == 0) {
		strcpy(tmpBuf, T("Set AP Host Name MIB error!"));
		goto setErr_dynip;
	}
	// Set clone MAC address
	strMac = websGetVar(wp, T("macAddr"), T(""));
	if (strMac[0]) {
		if (strlen(strMac)!=12 || !string_to_hex(strMac, tmpBuf, 12)) {
			strcpy(tmpBuf, T("Error! Invalid MAC address."));
			goto setErr_dynip;
		}
		if ( !apmib_set(MIB_WAN_MAC_ADDR, (void *)tmpBuf)) {
			strcpy(tmpBuf, T("Set MIB_WAN_MAC_ADDR mib error!"));
			goto setErr_dynip;
		}
	}

	PROC_MSG();
	apmib_update(CURRENT_SETTING);	// update to flash

#ifndef NO_ACTION
	sprintf(tmpBuf, "%s/%s %s %s", _CONFIG_SCRIPT_PATH , _CONFIG_SCRIPT_PROG, "gw", "all");
	system(tmpBuf);
#endif


	OK_MSG(submitUrl);
	return;
setErr_dynip:
	ERR_MSG(tmpBuf);
}
/////////////////////////////////////////////////////////////////////////////////////////////////
void formStcIpSetup(webs_t wp, char_t *path, char_t *query)
{
	char_t	*strIp, *strMask, *strGateway, *strDNS, *strMode, *submitUrl;
	struct in_addr inIp, inMask, inGateway, dns1;
	int Mode;
	char tmpBuf[100];

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
	strMode = websGetVar(wp, T("wanMode"), T(""));
	if ( strMode[0] ) {
		if ( !gstrcmp(strMode, T("1")))
			Mode = 1;
		if ( apmib_set( MIB_WAN_MODE, (void *)&Mode) == 0) {
			strcpy(tmpBuf, T("Set Wan Mode error!"));
			goto setErr_stcip;
		}
	}
	strIp = websGetVar(wp, T("ip"), T(""));
	if ( strIp[0] ) {
		if ( !inet_aton(strIp, &inIp) ) {
			strcpy(tmpBuf, T("Invalid IP-address value!"));
			goto setErr_stcip;
		}
		if ( !apmib_set(MIB_WAN_IP_ADDR, (void *)&inIp)) {
			strcpy(tmpBuf, T("Set IP-address error!"));
			goto setErr_stcip;
		}
	}
	strMask = websGetVar(wp, T("mask"), T(""));
	if ( strMask[0] ) {
		if ( !inet_aton(strMask, &inMask) ) {
			strcpy(tmpBuf, T("Invalid subnet-mask value!"));
			goto setErr_stcip;
		}
		if ( !apmib_set(MIB_WAN_SUBNET_MASK, (void *)&inMask)) {
			strcpy(tmpBuf, T("Set subnet-mask error!"));
			goto setErr_stcip;
		}
	}
	strGateway = websGetVar(wp, T("gateway"), T(""));
	if ( strGateway[0] ) {
		if ( !inet_aton(strGateway, &inGateway) ) {
			strcpy(tmpBuf, T("Invalid default-gateway value!"));
			goto setErr_stcip;
		}
		if ( !apmib_set(MIB_WAN_DEFAULT_GATEWAY, (void *)&inGateway)) {
			strcpy(tmpBuf, T("Set default-gateway error!"));
			goto setErr_stcip;
		}
	}
	strDNS = websGetVar(wp, T("dns1"), T(""));
	if ( strDNS[0] ) {
		if ( !inet_aton(strDNS, &dns1) ) {
			strcpy(tmpBuf, T("Invalid DNS address value!"));
			goto setErr_stcip;
		}
		if ( !apmib_set(MIB_WAN_DNS1, (void *)&dns1)) {
			strcpy(tmpBuf, T("Set DNS MIB error!"));
			goto setErr_stcip;
		}
	}
	else {
		if ( !apmib_get(MIB_WAN_DNS1, (void *)&dns1) ) {
			strcpy(tmpBuf, T("Get DNS1 MIB error!"));
			goto setErr_stcip;
		}
	}

	PROC_MSG();
	apmib_update(CURRENT_SETTING);	// update to flash

#ifndef NO_ACTION
	sprintf(tmpBuf, "%s/%s %s %s", _CONFIG_SCRIPT_PATH , _CONFIG_SCRIPT_PROG, "gw", "all");
	system(tmpBuf);
#endif
	OK_MSG(submitUrl);
	return;
setErr_stcip:
	ERR_MSG(tmpBuf);
}
//////////////////////////////////////////////////////////////////////////////////////////////
void formL2TPSetup(webs_t wp, char_t *path, char_t *query)
{
	char_t	*strIPAddr, *strIPMaskAddr, *strDfGateway, *strGateway, *strMac, *submitUrl;
	char_t  *strName, *strPassword, *strType, *strIpMode, *strConnect, *strwanMode, *strMTU, *strHostName;
	struct in_addr inIPAddr, inIPMaskAddr, inDfGateway;
	char tmpBuf[100];
	int val, Mode;
	int buttonState=0;

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
        strConnect = websGetVar(wp, T("L2TPConnect"), T(""));
	if (strConnect[0]) 
		buttonState = 1;

        strConnect = websGetVar(wp, T("L2TPDisconnect"), T(""));
	if (strConnect[0]) 
		buttonState = 2;

	strIpMode = websGetVar(wp, T("L2TPIpMode"), T(""));
	if (strIpMode[0]) {
		if (!gstrcmp(strIpMode, T("0")))
			val = 0;
		else if (!gstrcmp(strIpMode, T("1")))
			val = 1;
		else {
			strcpy(tmpBuf, T("Error!"));
			goto setErr_l2tp;
		}
		if ( apmib_set(MIB_L2TP_IPMODE, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set IP Mode failed!"));
			goto setErr_l2tp;
		}
	}
	//Obtain an IP address automatically
	if (!gstrcmp(strIpMode, T("0"))) {
		strHostName = websGetVar(wp, T("HostName"), T(""));
		if ( apmib_set(MIB_DYNIP_HOSTNAME, (void *)strHostName) == 0) {
			strcpy(tmpBuf, T("Set L2TP Host Name MIB error!"));
			goto setErr_l2tp;
		}
		strMac = websGetVar(wp, T("Mac"), T(""));
		if (strMac[0]) {
			if (strlen(strMac)!=12 || !string_to_hex(strMac, tmpBuf, 12)) {
				strcpy(tmpBuf, T("Error! Invalid MAC address."));
				goto setErr_l2tp;
			}
			if ( !apmib_set(MIB_WAN_MAC_ADDR, (void *)tmpBuf)) {
				strcpy(tmpBuf, T("Set MIB_WAN_MAC_ADDR mib error!"));
				goto setErr_l2tp;
			}
		}
	}


	
	
	strIPAddr = websGetVar(wp, T("L2TPIPAddr"), T(""));
	if ( strIPAddr[0] ) {
		if ( !inet_aton(strIPAddr, &inIPAddr) ) {
			strcpy(tmpBuf, T("Invalid IP-address value!"));
			goto setErr_l2tp;
		}
		if ( !apmib_set( MIB_L2TP_IP_ADDR, (void *)&inIPAddr)) {
			strcpy(tmpBuf, T("Set IP-address error!"));
			goto setErr_l2tp;
		}
	}
	strIPMaskAddr = websGetVar(wp, T("L2TPMaskAddr"), T(""));
	if ( strIPMaskAddr[0] ) {
		if ( !inet_aton(strIPMaskAddr, &inIPMaskAddr) ) {
			strcpy(tmpBuf, T("Invalid IP-address value!"));
			goto setErr_l2tp;
		}
		if ( !apmib_set( MIB_L2TP_MAKEADDR, (void *)&inIPMaskAddr)) {
			strcpy(tmpBuf, T("Set IP-address error!"));
			goto setErr_l2tp;
		}
	}
	strDfGateway = websGetVar(wp, T("L2TPDefGateway"), T(""));
	if ( strDfGateway[0] ) {
		if ( !inet_aton(strDfGateway, &inDfGateway) ) {
			strcpy(tmpBuf, T("Invalid IP-address value!"));
			goto setErr_l2tp;
		}
		if ( !apmib_set( MIB_L2TP_DEFGATEWAY, (void *)&inDfGateway)) {
			strcpy(tmpBuf, T("Set IP-address error!"));
			goto setErr_l2tp;
		}
	}
	strGateway = websGetVar(wp, T("L2TPGateway"), T(""));
	if ( strGateway[0] ) {
		if ( apmib_set( MIB_L2TP_GATEWAY, (void *)strGateway) == 0) {
			strcpy(tmpBuf, T("Set L2TP gateway error!"));
			goto setErr_l2tp;
		}
	}
	
	strName = websGetVar(wp, T("L2TPUserName"), T(""));
	if ( strName[0] ) {
		if ( apmib_set( MIB_L2TP_USER, (void *)strName) == 0) {
			strcpy(tmpBuf, T("Set L2TP user name MIB error!"));
			goto setErr_l2tp;
		}
	}
	strPassword = websGetVar(wp, T("L2TPPassword"), T(""));
	if ( strPassword[0] ) {
		if ( apmib_set( MIB_L2TP_PASSWORD, (void *)strPassword) == 0) {
			strcpy(tmpBuf, T("Set L2TP user password MIB error!"));
			goto setErr_l2tp;
		}
	}

	strMTU = websGetVar(wp, T("L2TPMTU"), T(""));
	if (strMTU[0]) {
		if ( !string_to_dec(strMTU, &val) || val< 512 || val >1492) {
			strcpy(tmpBuf, T("Error! Invalid value of MTU."));
			goto setErr_l2tp;
		}
		if ( apmib_set(MIB_L2TP_MTU, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set MTU failed!"));
			goto setErr_l2tp;
		}
	}
	
	strType = websGetVar(wp, T("L2TPConnectType"), T(""));
	if ( strType[0] ) {
		PPP_CONNECT_TYPE_T type;
		if ( strType[0] == '0' )
			type = CONTINUOUS;
		else if ( strType[0] == '1' )
			type = CONNECT_ON_DEMAND;
		else if ( strType[0] == '2' )
			type = MANUAL;
		else {
			strcpy(tmpBuf, T("Invalid L2TP type value!"));
			goto setErr_l2tp;
		}
		if ( apmib_set( MIB_L2TP_CONNECT_TYPE, (void *)&type) == 0) {
			strcpy(tmpBuf, T("Set L2TP type MIB error!"));
			goto setErr_l2tp;
		}
		if (type != CONTINUOUS) {
			char_t *strTime;
			strTime = websGetVar(wp, T("L2TPIdleTime"), T(""));
			if ( strTime[0] ) {
				int time;
				time = strtol(strTime, (char**)NULL, 10) * 60;
				if ( apmib_set(MIB_L2TP_IDLE_TIME, (void *)&time) == 0) {
					strcpy(tmpBuf, T("Set L2TP idle time MIB error!"));
					goto setErr_l2tp;
				}
			}
		}
	}
	strwanMode = websGetVar(wp, T("wanMode"), T(""));
	if ( strwanMode[0] ) {
		if ( !gstrcmp(strwanMode, T("6")))
			Mode = 6;
		if ( apmib_set( MIB_WAN_MODE, (void *)&Mode) == 0) {
			strcpy(tmpBuf, T("Set Wan Mode error!"));
			goto setErr_l2tp;
		}
	}
//*******************************************************************************
	if ( buttonState == 1 ) { // connect button is pressed
		int wait_time=30;

		PROC_MSG();
		apmib_update(CURRENT_SETTING);	// update to flash
	#ifndef NO_ACTION
//		sprintf(tmpBuf, "%s %s", "/bin/init.sh gw", "all");
//		system(tmpBuf);
		system("/bin/l2tp.sh connect"); // Lance 2004.2.3
		while (wait_time-- >0) {
			if (isConnectPPP())
				break;
			sleep(1);
		}
		if (isConnectPPP())
			strcpy(tmpBuf, T("Connected to server successfully.\n"));
		else
			strcpy(tmpBuf, T("Connect to server failed!\n"));

		OK_MSG1(tmpBuf, submitUrl);
	#endif
		return;
	}

	if ( buttonState == 2 ) { // disconnect button is pressed

		PROC_MSG();
		apmib_update(CURRENT_SETTING);	// update to flash
	#ifndef NO_ACTION
//		sprintf(tmpBuf, "%s %s", "/bin/init.sh gw", "all");
//		system(tmpBuf);
		system("/bin/disconnect.sh all"); // Lance 2004.2.3
		strcpy(tmpBuf, T("L2TP disconnected.\n"));
		OK_MSG1(tmpBuf, submitUrl);
	#endif
		return;
	}
	PROC_MSG();
	apmib_update(CURRENT_SETTING);	// update to flash

	// run script

#ifndef NO_ACTION
	sprintf(tmpBuf, "%s %s", "/bin/init.sh gw", "all");
	system(tmpBuf);
#endif
	OK_MSG(submitUrl);
	return;

setErr_l2tp:
	ERR_MSG(tmpBuf);

}
/////////////////////////////////////////////////////////////////////////////////////////////
void formPPPoESetup(webs_t wp, char_t *path, char_t *query)
{
	char_t	*strName, *strPassword, *strpppServName, *strpppMTU, *submitUrl;
	char_t  *strType, *strConnect, *strwanMode;
	char tmpBuf[100];
	int val, Mode;
	int buttonState=0;

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
    strConnect = websGetVar(wp, T("pppConnect"), T(""));
	if (strConnect[0])
		buttonState = 1;
	
    strConnect = websGetVar(wp, T("pppDisconnect"), T(""));
	if (strConnect[0])
		buttonState = 2;

	strwanMode = websGetVar(wp, T("wanMode"), T(""));
	if ( strwanMode[0] ) {
		if ( !gstrcmp(strwanMode, T("2")))
			Mode = 2;
		if ( apmib_set( MIB_WAN_MODE, (void *)&Mode) == 0) {
			strcpy(tmpBuf, T("Set Wan Mode error!"));
			goto setErr_ppp;
		}
	}
	strpppServName = websGetVar(wp, T("pppServName"), T(""));
	if (Mode == 2) {
		if ( apmib_set(MIB_PPP_SERVNAME, (void *)strpppServName) == 0) {
			strcpy(tmpBuf, T("Set PPP user name MIB error!"));
			goto setErr_ppp;
		}
	}
		
	strpppMTU = websGetVar(wp, T("pppMTU"), T(""));
	if (strpppMTU[0]) {
		if ( !string_to_dec(strpppMTU, &val) || val< 512 || val >1492) {
			strcpy(tmpBuf, T("Error! Invalid value of MTU."));
			goto setErr_ppp;
		}
		if ( apmib_set(MIB_PPP_MTU, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set MTU failed!"));
			goto setErr_ppp;
		}
	}

	strName = websGetVar(wp, T("pppUserName"), T(""));
	if ( strName[0] ) {
		if ( apmib_set(MIB_PPP_USER, (void *)strName) == 0) {
			strcpy(tmpBuf, T("Set PPP user name MIB error!"));
			goto setErr_ppp;
		}
	}

	strPassword = websGetVar(wp, T("pppPassword"), T(""));
	if ( strPassword[0] ) {
		if ( apmib_set(MIB_PPP_PASSWORD, (void *)strPassword) == 0) {
			strcpy(tmpBuf, T("Set PPP user password MIB error!"));
			goto setErr_ppp;
		}
	}

	strType = websGetVar(wp, T("pppConnectType"), T(""));
	if ( strType[0] ) {
		PPP_CONNECT_TYPE_T type;
		if ( strType[0] == '0' )
			type = CONTINUOUS;
		else if ( strType[0] == '1' )
			type = CONNECT_ON_DEMAND;
		else if ( strType[0] == '2' )
			type = MANUAL;
		else {
			strcpy(tmpBuf, T("Invalid PPP type value!"));
			goto setErr_ppp;
		}
		if ( apmib_set(MIB_PPP_CONNECT_TYPE, (void *)&type) == 0) {
			strcpy(tmpBuf, T("Set PPP type MIB error!"));
			goto setErr_ppp;
		}
		if (type != CONTINUOUS) {
			char_t *strTime;
			strTime = websGetVar(wp, T("pppIdleTime"), T(""));
			if ( strTime[0] ) {
				int time;
				time = strtol(strTime, (char**)NULL, 10) * 60;
				if ( apmib_set(MIB_PPP_IDLE_TIME, (void *)&time) == 0) {
					strcpy(tmpBuf, T("Set PPP idle time MIB error!"));
					goto setErr_ppp;
				}
			}
		}
	}
//**************************************************************************************
	if ( buttonState == 1 ) { // connect button is pressed
		int wait_time=30;

		apmib_update(CURRENT_SETTING);	// update to flash
	#ifndef NO_ACTION
		sprintf(tmpBuf, "%s/%s %s %s", _CONFIG_SCRIPT_PATH , _CONFIG_SCRIPT_PROG, "gw", "all");
		system(tmpBuf);
		while (wait_time-- >0) {
			if (isConnectPPP())
				break;
			sleep(1);
		}
		if (isConnectPPP())
			strcpy(tmpBuf, T("Connected to server successfully.\n"));
		else
			strcpy(tmpBuf, T("Connect to server failed!\n"));

		OK_MSG1(tmpBuf, submitUrl);
	#endif
		return;
	}

	if ( buttonState == 2 ) { // disconnect button is pressed

		apmib_update(CURRENT_SETTING);	// update to flash
	#ifndef NO_ACTION
		sprintf(tmpBuf, "%s/%s %s %s", _CONFIG_SCRIPT_PATH , _CONFIG_SCRIPT_PROG, "gw", "all");
		system(tmpBuf);
		strcpy(tmpBuf, T("PPPoE disconnected.\n"));
		OK_MSG1(tmpBuf, submitUrl);
	#endif
		return;
	}
	apmib_update(CURRENT_SETTING);	// update to flash

#ifndef NO_ACTION
	sprintf(tmpBuf, "%s/%s %s %s", _CONFIG_SCRIPT_PATH , _CONFIG_SCRIPT_PROG, "gw", "all");
	system(tmpBuf);
#endif
	OK_MSG(submitUrl);
	return;

setErr_ppp:
	ERR_MSG(tmpBuf);

}
////////////////////////////////////////////////////////////////////////////////
void formPPTPSetup(webs_t wp, char_t *path, char_t *query)
{
	char_t	*strpptpIPAddr, *strpptpIPMaskAddr, *strpptpDfGateway, *strpptpGateway, *submitUrl;
	char_t  *strName, *strPassword, *strType, *strIpMode, *strConnect;
	char_t  *strConntID, *strBEZEQEnable, *strwanMode, *strMTU;
	char_t  *strHostName, *strMac;
	struct in_addr inpptpIPAddr, inpptpIPMaskAddr, inpptpDfGateway, inpptpGateway;
	char tmpBuf[100];
	int val, Mode;
	int buttonState=0;

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
        strConnect = websGetVar(wp, T("pptpConnect"), T(""));
	if (strConnect[0]) 
		buttonState = 1;

        strConnect = websGetVar(wp, T("pptpDisconnect"), T(""));
	if (strConnect[0]) 
		buttonState = 2;

	strIpMode = websGetVar(wp, T("pptpIpMode"), T(""));
	if (strIpMode[0]) {
		if (!gstrcmp(strIpMode, T("0")))
			val = 0;
		else if (!gstrcmp(strIpMode, T("1")))
			val = 1;
		else {
			strcpy(tmpBuf, T("Error!"));
			goto setErr_pptp;
		}
		if ( apmib_set(MIB_PPTP_IPMODE, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set IP Mode failed!"));
			goto setErr_pptp;
		}
	}
	//Obtain an IP address automatically
	if (!gstrcmp(strIpMode, T("0"))) {
		strHostName = websGetVar(wp, T("HostName"), T(""));
		if ( apmib_set(MIB_DYNIP_HOSTNAME, (void *)strHostName) == 0) {
			strcpy(tmpBuf, T("Set L2TP Host Name MIB error!"));
			goto setErr_pptp;
		}
		strMac = websGetVar(wp, T("Mac"), T(""));
		if (strMac[0]) {
			if (strlen(strMac)!=12 || !string_to_hex(strMac, tmpBuf, 12)) {
				strcpy(tmpBuf, T("Error! Invalid MAC address."));
				goto setErr_pptp;
			}
			if ( !apmib_set(MIB_WAN_MAC_ADDR, (void *)tmpBuf)) {
				strcpy(tmpBuf, T("Set MIB_WAN_MAC_ADDR mib error!"));
				goto setErr_pptp;
			}
		}
	}
	
	strpptpIPAddr = websGetVar(wp, T("pptpIPAddr"), T(""));
	if ( strpptpIPAddr[0] ) {
		if ( !inet_aton(strpptpIPAddr, &inpptpIPAddr) ) {
			strcpy(tmpBuf, T("Invalid IP-address value!"));
			goto setErr_pptp;
		}
		if ( !apmib_set( MIB_PPTPIP_ADDR, (void *)&inpptpIPAddr)) {
			strcpy(tmpBuf, T("Set IP-address error!"));
			goto setErr_pptp;
		}
	}
	strpptpIPMaskAddr = websGetVar(wp, T("pptpIPMaskAddr"), T(""));
	if ( strpptpIPMaskAddr[0] ) {
		if ( !inet_aton(strpptpIPMaskAddr, &inpptpIPMaskAddr) ) {
			strcpy(tmpBuf, T("Invalid IP-address value!"));
			goto setErr_pptp;
		}
		if ( !apmib_set( MIB_PPTPIPMAKE_ADDR, (void *)&inpptpIPMaskAddr)) {
			strcpy(tmpBuf, T("Set IP-address error!"));
			goto setErr_pptp;
		}
	}
	strpptpDfGateway = websGetVar(wp, T("pptpDfGateway"), T(""));
	if ( strpptpDfGateway[0] ) {
		if ( !inet_aton(strpptpDfGateway, &inpptpDfGateway) ) {
			strcpy(tmpBuf, T("Invalid IP-address value!"));
			goto setErr_pptp;
		}
		if ( !apmib_set( MIB_PPTPDFGATEWAY, (void *)&inpptpDfGateway)) {
			strcpy(tmpBuf, T("Set IP-address error!"));
			goto setErr_pptp;
		}
	}
	strpptpGateway = websGetVar(wp, T("pptpGateway"), T(""));
	if ( strpptpGateway[0] ) {
		if ( !inet_aton(strpptpGateway, &inpptpGateway) ) {
			strcpy(tmpBuf, T("Invalid IP-address value!"));
			goto setErr_pptp;
		}
		if ( !apmib_set( MIB_PPTPGATEWAY, (void *)&inpptpGateway)) {
			strcpy(tmpBuf, T("Set IP-address error!"));
			goto setErr_pptp;
		}
	}
	strName = websGetVar(wp, T("pptpUserName"), T(""));
		if ( strName[0] ) {
			if ( apmib_set(MIB_PPTP_USER, (void *)strName) == 0) {
				strcpy(tmpBuf, T("Set PPTP user name MIB error!"));
				goto setErr_pptp;
			}
		}

	strPassword = websGetVar(wp, T("pptpPassword"), T(""));
	if ( strPassword[0] ) {
		if ( apmib_set(MIB_PPTP_PASSWORD, (void *)strPassword) == 0) {
			strcpy(tmpBuf, T("Set PPTP user password MIB error!"));
			goto setErr_pptp;
		}
	}

	strMTU = websGetVar(wp, T("pptpMTU"), T(""));
	if (strMTU[0]) {
		if ( !string_to_dec(strMTU, &val) || val< 512 || val >1492) {
			strcpy(tmpBuf, T("Error! Invalid value of MTU."));
			goto setErr_pptp;
		}
		if ( apmib_set(MIB_PPTP_MTU, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set MTU failed!"));
			goto setErr_pptp;
		}
	}
//-------------------------------------------------------------------------------------
	strType = websGetVar(wp, T("pptpConnectType"), T(""));
	if ( strType[0] ) {
		PPP_CONNECT_TYPE_T type;
		if ( strType[0] == '0' )
			type = CONTINUOUS;
		else if ( strType[0] == '1' )
			type = CONNECT_ON_DEMAND;
		else if ( strType[0] == '2' )
			type = MANUAL;
		else {
			strcpy(tmpBuf, T("Invalid PPTP type value!"));
			goto setErr_pptp;
		}
		if ( apmib_set(MIB_PPTP_CONNECT_TYPE, (void *)&type) == 0) {
			strcpy(tmpBuf, T("Set PPTP type MIB error!"));
			goto setErr_pptp;
		}
		if (type != CONTINUOUS) {
			char_t *strTime;
			strTime = websGetVar(wp, T("pptpIdleTime"), T(""));
			if ( strTime[0] ) {
				int time;
				time = strtol(strTime, (char**)NULL, 10) * 60;
				if ( apmib_set(MIB_PPTP_IDLE_TIME, (void *)&time) == 0) {
					strcpy(tmpBuf, T("Set PPTP idle time MIB error!"));
					goto setErr_pptp;
				}
			}
		}
	}
	strConntID = websGetVar(wp, T("pptpConntID"), T(""));
	if ( apmib_set(MIB_PPTP_CONNT_ID, (void *)strConntID) == 0) {
		strcpy(tmpBuf, T("Set PPTP Connection ID MIB error!"));
		goto setErr_pptp;
	}
	strBEZEQEnable = websGetVar(wp, T("pptpBEZEQEnable"), T(""));
	if ( !gstrcmp(strBEZEQEnable, T("ON")))
		val = 1;
	else
		val = 0;
	if ( apmib_set( MIB_PPTP_BEZEQ_ENABLE, (void *)&val) == 0) {
		strcpy(tmpBuf, T("Set enabled flag error!"));
		goto setErr_pptp;
	}
	strwanMode = websGetVar(wp, T("wanMode"), T(""));
	if ( strwanMode[0] ) {
		if ( !gstrcmp(strwanMode, T("3")))
			Mode = 3;
		if ( apmib_set( MIB_WAN_MODE, (void *)&Mode) == 0) {
			strcpy(tmpBuf, T("Set Wan Mode error!"));
			goto setErr_pptp;
		}
	}
//--------------------------------------------------------------------------------
	if ( buttonState == 1 ) { // connect button is pressed
		int wait_time=30;

		PROC_MSG();
		apmib_update(CURRENT_SETTING);	// update to flash
	#ifndef NO_ACTION
//		sprintf(tmpBuf, "%s %s", "/bin/init.sh gw", "all");
//		system(tmpBuf);
		system("/bin/pptp.sh connect"); // Lance 2004.2.3
		while (wait_time-- >0) {
		if (isConnectPPP())
			break;
			sleep(1);
		}
		if (isConnectPPP())
			strcpy(tmpBuf, T("Connected to server successfully.\n"));
		else
			strcpy(tmpBuf, T("Connect to server failed!\n"));

		OK_MSG1(tmpBuf, submitUrl);
	#endif
		return;
	}

	if ( buttonState == 2 ) { // disconnect button is pressed

		PROC_MSG();
		apmib_update(CURRENT_SETTING);	// update to flash
	#ifndef NO_ACTION
//		sprintf(tmpBuf, "%s %s", "/bin/init.sh gw", "all");
//		system(tmpBuf);
		system("/bin/disconnect.sh all"); // Lance 2004.2.3
		strcpy(tmpBuf, T("PPTP disconnected.\n"));
		OK_MSG1(tmpBuf, submitUrl);
	#endif
		return;
	}
	PROC_MSG();
	apmib_update(CURRENT_SETTING);	// update to flash
	// run script
#ifndef NO_ACTION
	sprintf(tmpBuf, "%s %s", "/bin/init.sh gw", "all");
	system(tmpBuf);
#endif
	OK_MSG(submitUrl);
	return;

setErr_pptp:
	ERR_MSG(tmpBuf);

}
////////////////////////////////////////////////////////////////////////////////
void formWanTcpipSetup(webs_t wp, char_t *path, char_t *query)
{
	char_t	*strIp, *strMask, *strGateway, *strDNS, *strMode, *submitUrl, *strConnect, *strMac;
	char_t  *strdynIPHostName, *strpppServName, *strpppMTU;
	int val;
	struct in_addr inIp, inMask,dns1, dns2, dns3, inGateway;
	DHCP_T dhcp, curDhcp;
	DNS_TYPE_T dns, dns_old;
	char tmpBuf[100];
	char_t *strwanMode;
	int Mode;
	int dns_changed=0;
	char *arg;
	int buttonState=0;

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
	strwanMode = websGetVar(wp, T("wanMode"), T(""));
	if (strwanMode[0]) {
		if ( !gstrcmp(strwanMode, T("0")))    Mode = 0;
		if ( !gstrcmp(strwanMode, T("1")))    Mode = 1;
        if ( !gstrcmp(strwanMode, T("2")))    Mode = 2;
		if ( apmib_set( MIB_WAN_MODE, (void *)&Mode) == 0) {
			strcpy(tmpBuf, T("Set Wan Mode error!"));
			goto setErr_tcpip;
		}
	}
//**************************************** PPPoE Setting ****************************************
        strConnect = websGetVar(wp, T("pppConnect"), T(""));
	if (strConnect[0]) {
		buttonState = 1;
		strMode = T("ppp");
		goto set_ppp;
	}
        strConnect = websGetVar(wp, T("pppDisconnect"), T(""));
	if (strConnect[0]) {
		buttonState = 2;
		strMode = T("ppp");
		goto set_ppp;
	}
	strpppServName = websGetVar(wp, T("pppServName"), T(""));
		if (Mode == 2) {
			if ( apmib_set(MIB_PPP_SERVNAME, (void *)strpppServName) == 0) {
				strcpy(tmpBuf, T("Set PPP user name MIB error!"));
				goto setErr_tcpip;
			}
		}
		
	strpppMTU = websGetVar(wp, T("pppMTU"), T(""));
	if (strpppMTU[0]) {
		if ( !string_to_dec(strpppMTU, &val) || val< 512 || val >1492) {
			strcpy(tmpBuf, T("Error! Invalid value of MTU."));
			goto setErr_tcpip;
		}
		if ( apmib_set(MIB_PPP_MTU, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set MTU failed!"));
			goto setErr_tcpip;
		}
	}
//**************************************** Dynamic Ip ****************************************
	if (Mode == 0) {
		strdynIPHostName = websGetVar(wp, T("dynIPHostName"), T(""));
		if ( apmib_set(MIB_DYNIP_HOSTNAME, (void *)strdynIPHostName) == 0) {
			strcpy(tmpBuf, T("Set AP Host Name MIB error!"));
			goto setErr_tcpip;
		}
	}
	// Set clone MAC address
	strMac = websGetVar(wp, T("macAddr"), T(""));
	if (strMac[0]) {
		if (strlen(strMac)!=12 || !string_to_hex(strMac, tmpBuf, 12)) {
			strcpy(tmpBuf, T("Error! Invalid MAC address."));
			goto setErr_tcpip;
		}
		if ( !apmib_set(MIB_WAN_MAC_ADDR, (void *)tmpBuf)) {
			strcpy(tmpBuf, T("Set MIB_WAN_MAC_ADDR mib error!"));
			goto setErr_tcpip;
		}
	}
//**************************************** DNS Setting ****************************************
	strMode = websGetVar(wp, T("dnsMode"), T(""));
	if ( strMode[0] ) {
		if (!strcmp(strMode, T("dnsAuto")))
			dns = DNS_AUTO;
		else if (!strcmp(strMode, T("dnsManual")))
			dns = DNS_MANUAL;
		else {
			strcpy(tmpBuf, T("Invalid DNS mode value!"));
			goto setErr_tcpip;
		}

		if ( !apmib_get(MIB_WAN_DNS_MODE, (void *)&dns_old)) {
	  		strcpy(tmpBuf, T("Get DNS MIB error!"));
			goto setErr_tcpip;
		}
		if (dns != dns_old)
			dns_changed = 1;

		// Set DNS to MIB
		if ( !apmib_set(MIB_WAN_DNS_MODE, (void *)&dns)) {
	  		strcpy(tmpBuf, T("Set DNS MIB error!"));
			goto setErr_tcpip;
		}

		if ( dns == DNS_MANUAL ) {
			struct in_addr dns1_old, dns2_old, dns3_old;
			if ( !apmib_get(MIB_WAN_DNS1, (void *)&dns1_old)) {
	  			strcpy(tmpBuf, T("Get DNS1 MIB error!"));
				goto setErr_tcpip;
			}
			if ( !apmib_get(MIB_WAN_DNS2, (void *)&dns2_old)) {
	  			strcpy(tmpBuf, T("Get DNS1 MIB error!"));
				goto setErr_tcpip;
			}
			if ( !apmib_get(MIB_WAN_DNS3, (void *)&dns3_old)) {
	  			strcpy(tmpBuf, T("Get DNS1 MIB error!"));
				goto setErr_tcpip;
			}

			// If DHCP server is enabled in LAN, update dhcpd.conf
			strDNS = websGetVar(wp, T("dns1"), T(""));
			if ( strDNS[0] ) {
				if ( !inet_aton(strDNS, &dns1) ) {
					strcpy(tmpBuf, T("Invalid DNS address value!"));
					goto setErr_tcpip;
				}

				if ( !apmib_set(MIB_WAN_DNS1, (void *)&dns1)) {
	  				strcpy(tmpBuf, T("Set DNS MIB error!"));
					goto setErr_tcpip;
				}
			}
			else {
				if ( !apmib_get(MIB_WAN_DNS1, (void *)&dns1) ) {
					strcpy(tmpBuf, T("Get DNS1 MIB error!"));
					goto setErr_tcpip;
				}
			}
			strDNS = websGetVar(wp, T("dns2"), T(""));
			if ( strDNS[0] ) {
				if ( !inet_aton(strDNS, &dns2) ) {
					strcpy(tmpBuf, T("Invalid DNS address value!"));
					goto setErr_tcpip;
				}
				if ( !apmib_set(MIB_WAN_DNS2, (void *)&dns2)) {
	  				strcpy(tmpBuf, T("Set DNS MIB error!"));
					goto setErr_tcpip;
				}
			}
			else {
				if ( !apmib_get(MIB_WAN_DNS2, (void *)&dns2) ) {
					strcpy(tmpBuf, T("Get DNS2 MIB error!"));
					goto setErr_tcpip;
				}
			}
			strDNS = websGetVar(wp, T("dns3"), T(""));
			if ( strDNS[0] ) {
				if ( !inet_aton(strDNS, &dns3) ) {
					strcpy(tmpBuf, T("Invalid DNS address value!"));
					goto setErr_tcpip;
				}
				if ( !apmib_set(MIB_WAN_DNS3, (void *)&dns3)) {
	  				strcpy(tmpBuf, T("Set DNS MIB error!"));
					goto setErr_tcpip;
				}
			}
			else {
				if ( !apmib_get(MIB_WAN_DNS3, (void *)&dns3) ) {
					strcpy(tmpBuf, T("Get DNS3 MIB error!"));
					goto setErr_tcpip;
				}
			}

			if ( *((long *)&dns1) != *((long *)&dns1_old) ||
				 *((long *)&dns2) != *((long *)&dns2_old) ||
				  *((long *)&dns3) != *((long *)&dns3_old) )
				dns_changed = 1;
		}
	}

	// Read current ip mode setting for reference later
	if ( !apmib_get( MIB_WAN_DHCP, (void *)&curDhcp) ) {
		strcpy(tmpBuf, T("Get WAN DHCP MIB error!"));
		goto setErr_tcpip;
	}

	strMode = websGetVar(wp, T("ipMode"), T(""));
set_ppp:
	if ( strMode[0] ) {
		if ( !strcmp(strMode, T("autoIp")))
			dhcp = DHCP_CLIENT;
		else if ( !strcmp(strMode, T("fixedIp")))
			dhcp = DHCP_DISABLED;
		else if ( !strcmp(strMode, T("ppp"))) {
			char_t	*strName, *strPassword, *strType;
			dhcp = PPPOE;
  			strName = websGetVar(wp, T("pppUserName"), T(""));
			if ( strName[0] ) {
				if ( apmib_set(MIB_PPP_USER, (void *)strName) == 0) {
					strcpy(tmpBuf, T("Set PPP user name MIB error!"));
					goto setErr_tcpip;
				}
			}

 			strPassword = websGetVar(wp, T("pppPassword"), T(""));
			if ( strPassword[0] ) {
				if ( apmib_set(MIB_PPP_PASSWORD, (void *)strPassword) == 0) {
					strcpy(tmpBuf, T("Set PPP user password MIB error!"));
					goto setErr_tcpip;
				}
			}
			strType = websGetVar(wp, T("pppConnectType"), T(""));
			if ( strType[0] ) {
				PPP_CONNECT_TYPE_T type;
				if ( strType[0] == '0' )
					type = CONTINUOUS;
				else if ( strType[0] == '1' )
					type = CONNECT_ON_DEMAND;
				else if ( strType[0] == '2' )
					type = MANUAL;
				else {
					strcpy(tmpBuf, T("Invalid PPP type value!"));
					goto setErr_tcpip;
				}
				if ( apmib_set(MIB_PPP_CONNECT_TYPE, (void *)&type) == 0) {
   					strcpy(tmpBuf, T("Set PPP type MIB error!"));
					goto setErr_tcpip;
				}
				if (type != CONTINUOUS) {
					char_t *strTime;
					strTime = websGetVar(wp, T("pppIdleTime"), T(""));
					if ( strTime[0] ) {
						int time;
 						time = strtol(strTime, (char**)NULL, 10) * 60;
						if ( apmib_set(MIB_PPP_IDLE_TIME, (void *)&time) == 0) {
   							strcpy(tmpBuf, T("Set PPP idle time MIB error!"));
							goto setErr_tcpip;
						}
					}
				}
			}
		}
		else {
			strcpy(tmpBuf, T("Invalid IP mode value!"));
			goto setErr_tcpip;
		}
		if ( !apmib_set(MIB_WAN_DHCP, (void *)&dhcp)) {
	  		strcpy(tmpBuf, T("Set DHCP error!"));
			goto setErr_tcpip;
		}

		if ( dhcp == PPPOE && buttonState == 1 ) { // connect button is pressed
			int wait_time=30;
//---------------------------------------------------------------------------------
			PROC_MSG();
			apmib_update(CURRENT_SETTING);	// update to flash
#ifndef NO_ACTION
		/*	pid = fork();
        		if (pid)
	        		waitpid(pid, NULL, 0);
			else if (pid == 0) {
				snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _PPPOE_SCRIPT_PROG);
				execl( tmpBuf, _PPPOE_SCRIPT_PROG, "connect", NULL);
       				exit(1);
			}*/
		system("/bin/pppoe.sh connect");
			while (wait_time-- >0) {
				if (isConnectPPP())
					break;
				sleep(1);
			}
			if (isConnectPPP())
				strcpy(tmpBuf, T("Connected to server successfully.\n"));
			else
				strcpy(tmpBuf, T("Connect to server failed!\n"));

			OK_MSG1(tmpBuf, submitUrl);
#endif
			return;
		}

		if ( dhcp == PPPOE && buttonState == 2 ) { // disconnect button is pressed

			PROC_MSG();
			apmib_update(CURRENT_SETTING);	// update to flash
#ifndef NO_ACTION
	/*		pid = fork();
        		if (pid)
	             		waitpid(pid, NULL, 0);
        		else if (pid == 0) {
				snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _PPPOE_DC_SCRIPT_PROG);
				execl( tmpBuf, _PPPOE_DC_SCRIPT_PROG, "all", NULL);
                		exit(1);
        		}*/
//	sprintf(tmpBuf, "%s %s", "/bin/init.sh gw", "all");
//	system(tmpBuf);
			system("/bin/disconnect.sh all"); // Lance 2004.2.3
			strcpy(tmpBuf, T("PPPoE disconnected.\n"));
			OK_MSG1(tmpBuf, submitUrl);
#endif
			return;
		}
	}
	else
		dhcp = curDhcp;

	if ( dhcp == DHCP_DISABLED ) {
		strIp = websGetVar(wp, T("ip"), T(""));
		if ( strIp[0] ) {
			if ( !inet_aton(strIp, &inIp) ) {
				strcpy(tmpBuf, T("Invalid IP-address value!"));
				goto setErr_tcpip;
			}
			if ( !apmib_set(MIB_WAN_IP_ADDR, (void *)&inIp)) {
				strcpy(tmpBuf, T("Set IP-address error!"));
				goto setErr_tcpip;
			}
		}

		strMask = websGetVar(wp, T("mask"), T(""));
		if ( strMask[0] ) {
			if ( !inet_aton(strMask, &inMask) ) {
				strcpy(tmpBuf, T("Invalid subnet-mask value!"));
				goto setErr_tcpip;
			}
			if ( !apmib_set(MIB_WAN_SUBNET_MASK, (void *)&inMask)) {
				strcpy(tmpBuf, T("Set subnet-mask error!"));
				goto setErr_tcpip;
			}
		}

		strGateway = websGetVar(wp, T("gateway"), T(""));
		if ( strGateway[0] ) {
			if ( !inet_aton(strGateway, &inGateway) ) {
				strcpy(tmpBuf, T("Invalid default-gateway value!"));
				goto setErr_tcpip;
			}
			if ( !apmib_set(MIB_WAN_DEFAULT_GATEWAY, (void *)&inGateway)) {
				strcpy(tmpBuf, T("Set default-gateway error!"));
				goto setErr_tcpip;
			}
		}
	}
	
	PROC_MSG();
	apmib_update(CURRENT_SETTING);	// update to flash

	// run script
	if ( dns_changed )
		arg = "all";
	else
		arg = "wan";

#ifndef NO_ACTION
    /*    pid = fork();
        if (pid)
                waitpid(pid, NULL, 0);

        else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG);
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "gw", arg, NULL);
                exit(1);
        }*/
	sprintf(tmpBuf, "%s %s", "/bin/init.sh gw", "all");
	system(tmpBuf);
#endif

	OK_MSG(submitUrl);

	return;
setErr_tcpip:
	ERR_MSG(tmpBuf);
}


/////////////////////////////////////////////////////////////////////////////
int dhcpClientList(int eid, webs_t wp, int argc, char_t **argv)
{
	FILE *fp;
	int nBytesSent=0;
	int element=0, ret;
	char ipAddr[40], macAddr[40], liveTime[80], *buf=NULL, *ptr, tmpBuf[100];
	struct stat status;
	int pid;
	unsigned long longVal;

	// siganl DHCP server to update lease file
	snprintf(tmpBuf, 100, "%s/%s.pid", _DHCPD_PID_PATH, _DHCPD_PROG_NAME);
	pid = getPid(tmpBuf);
	if ( pid > 0)
		kill(pid, SIGUSR1);
	usleep(1000);

	if ( stat(_PATH_DHCPS_LEASES, &status) < 0 )
		goto err;

	buf = malloc(status.st_size);
	if ( buf == NULL )
		goto err;
	fp = fopen(_PATH_DHCPS_LEASES, "r");
	if ( fp == NULL )
		goto err;

	fread(buf, 1, status.st_size, fp);
	fclose(fp);

	ptr = buf;
	while (1) {
		ret = getOneDhcpClient(&ptr, &status.st_size, ipAddr, macAddr, liveTime);

		if (ret < 0)
			break;
		if (ret == 0)
			continue;
		longVal=strtoul(liveTime,NULL,0);
		if (longVal > 2000000)
			sprintf(liveTime, "%s", "forever");
		nBytesSent += websWrite(wp,
			T("<tr class=table2 align=center><td><font size=2>%s</td><td><font size=2>%s</td><td><font size=2>%s</td></tr>"),
			ipAddr, macAddr, liveTime);
		element++;
	}
err:
	if (element == 0) {
		nBytesSent += websWrite(wp,
			T("<tr class=table2 align=center><td><font size=2>None</td><td><font size=2>----</td><td><font size=2>----</td></tr>"));
	}
	if (buf)
		free(buf);

	return nBytesSent;
}

/////////////////////////////////////////////////////////////////////////////
void formReflashClientTbl(webs_t wp, char_t *path, char_t *query)
{
	char_t *submitUrl;

	submitUrl = websGetVar(wp, T("submit-url"), T(""));
	if (submitUrl[0])
		websRedirect(wp, submitUrl);
}

#endif

//////////////////////////////////////////////////////////////////////////////
int isDhcpClientExist(char *name)
{
	char tmpBuf[100];
	struct in_addr intaddr;

	if ( getInAddr(name, IP_ADDR, (void *)&intaddr ) ) {
		snprintf(tmpBuf, 100, "%s/%s-%s.pid", _DHCPC_PID_PATH, _DHCPC_PROG_NAME, name);
		if ( getPid(tmpBuf) > 0)
			return 1;
	}
	return 0;
}



