/*
 *      Web server handler routines wlan stuffs
 *
 *      Authors: David Hsu	<davidhsu@realtek.com.tw>
 *
 *      $Id: fmwlan.c,v 1.9 2004/03/12 10:36:12 erwin Exp $
 *
 */

#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>

#include "../webs.h"
#include "apmib.h"
#include "apform.h"
#include "utility.h"

static SS_STATUS_Tp pStatus=NULL;

/////////////////////////////////////////////////////////////////////////////
static inline int isAllStar(char *data)
{
	int i;
	for (i=0; i<strlen(data); i++) {
		if (data[i] != '*')
			return 0;
	}
	return 1;
}
/////////////////////////////////////////////////////////////////////////////
void formLicence(webs_t wp, char_t *path, char_t *query)
{
	char_t *strAccept, *submitUrl;
	char tmpBuf[100];
	int val=1;
	strAccept = websGetVar(wp, T("accept"), T(""));
	if (strAccept[0]) {	
		if ( apmib_set(MIB_LICENCE, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set licence flag failed!"));
			goto setErr_licence;
		}
		apmib_update(CURRENT_SETTING);
	}

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
	if (strAccept[0]) {		//accept
		if (submitUrl[0])
			websRedirect(wp, submitUrl);
		else
			websDone(wp, 200);
	}
	else					//reject
		REJECT_MSG();
	
  	return;
	
setErr_licence:
	ERR_MSG(tmpBuf);
}
/////////////////////////////////////////////////////////////////////////////////////////
#ifdef HOME_GATEWAY
void formALGSetup(webs_t wp, char_t *path, char_t *query)
{
	char_t *strALG, *submitUrl;
	char tmpBuf[100];
	unsigned long longVal;
	
	submitUrl = websGetVar(wp, T("wlan-url"), T(""));   // hidden page
	strALG = websGetVar(wp, T("appLyGatewayValue"), T(""));
	
	longVal=strtoul(strALG,NULL,0);
	if ( apmib_set(MIB_APP_LAYER_GATEWAY, (void *)&longVal) == 0) {
		strcpy(tmpBuf, T("Set ALG failed!"));
		goto setErr_advance;
	}
	PROC_MSG();
	apmib_update(CURRENT_SETTING);

#ifndef NO_ACTION
//	sprintf(tmpBuf, "%s/%s", _CONFIG_SCRIPT_PATH, _FIREWALL_SCRIPT_PROG);
//	system(tmpBuf);
	system("/bin/firewall.sh");
#endif

	OK_MSG(submitUrl);
	return;

setErr_advance:
	ERR_MSG(tmpBuf);
	return ;
}
/////////////////////////////////////////////////////////////////////////////
void formSYSSetup(webs_t wp, char_t *path, char_t *query)
{
	char_t *strsysMode, *submitUrl;
	char tmpBuf[100];
	int val;
		strsysMode = websGetVar(wp, T("sysMode"), T(""));
	if (strsysMode[0]) {
		if ( !string_to_dec(strsysMode, &val)) {
			strcpy(tmpBuf, T("Error! Invalid value."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_SYS_MODE, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set value failed!"));
			goto setErr_advance;
		}
	}
//	apmib_update(CURRENT_SETTING);

	submitUrl = websGetVar(wp, T("wlan-url"), T(""));   // hidden page
		REPLACE1_MSG(submitUrl);

	return;
setErr_advance:
	ERR_MSG(tmpBuf);
}
/////////////////////////////////////////////////////////////////////////////
void formWlEnable(webs_t wp, char_t *path, char_t *query)
{
   	char_t *submitUrl, *strWirelessEnable;
	int val;
	char tmpBuf[100];

	strWirelessEnable = websGetVar(wp, T("wlanDisabled"), T(""));
	if (strWirelessEnable[0]) {
		if (!gstrcmp(strWirelessEnable, T("no")))
			val = 1;
		else if (!gstrcmp(strWirelessEnable, T("yes")))
			val = 0;
		else {
			strcpy(tmpBuf, T("Error!"));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_DISABLED, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set Wireless Enable failed!"));
			goto setErr_advance;
		}
	}
	PROC_MSG();
	apmib_update(CURRENT_SETTING);

#ifndef NO_ACTION
	// run script file to update WLAN parameters
	sprintf(tmpBuf, "%s %s", "/bin/wlan.sh", WLAN_IF);
	system(tmpBuf);
	sprintf(tmpBuf, "%s %s", "/bin/iappauth.sh", BRIDGE_IF);
	system(tmpBuf);
		
#endif

	submitUrl = websGetVar(wp, T("wlan-url"), T(""));   // hidden page
	REPLACE1_MSG(submitUrl);

	return;
setErr_advance:
	ERR_MSG(tmpBuf);
}
/////////////////////////////////////////////////////////////////////////////
void formNatEnable(webs_t wp, char_t *path, char_t *query)
{
   	char_t *submitUrl, *strNatEnable;
	int val;
	char tmpBuf[100];
	
	strNatEnable = websGetVar(wp, T("natEnable"), T(""));
	if (strNatEnable[0]) {
		if (!gstrcmp(strNatEnable, T("no")))
			val = 0;
		else if (!gstrcmp(strNatEnable, T("yes")))
			val = 1;
		else {
			strcpy(tmpBuf, T("Error!"));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_NAT_ENABLE, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set Firewall Enable failed!"));
			goto setErr_advance;
		}
	}
	PROC_MSG();
	apmib_update(CURRENT_SETTING);
#ifndef NO_ACTION
	system("/bin/firewall.sh");
//	sprintf(tmpBuf, "%s/%s", _CONFIG_SCRIPT_PATH, _FIREWALL_SCRIPT_PROG);
//	system(tmpBuf);
#endif

	submitUrl = websGetVar(wp, T("wlan-url"), T(""));   // hidden page
	REPLACE1_MSG(submitUrl);

	return;
setErr_advance:
	ERR_MSG(tmpBuf);
}
/////////////////////////////////////////////////////////////////////////////
void formFwEnable(webs_t wp, char_t *path, char_t *query)
{
   	char_t *submitUrl, *strFwEnable;
	int val;
	char tmpBuf[100];
	
	strFwEnable = websGetVar(wp, T("FirewallEnable"), T(""));
	if (strFwEnable[0]) {
		if (!gstrcmp(strFwEnable, T("no")))
			val = 0;
		else if (!gstrcmp(strFwEnable, T("yes")))
			val = 1;
		else {
			strcpy(tmpBuf, T("Error!"));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_FIREWALL_ENABLE, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set Firewall Enable failed!"));
			goto setErr_advance;
		}
	}
	PROC_MSG();
	apmib_update(CURRENT_SETTING);
	
#ifndef NO_ACTION
//	sprintf(tmpBuf, "%s/%s", _CONFIG_SCRIPT_PATH, _FIREWALL_SCRIPT_PROG);
//	system(tmpBuf);
	system("/bin/firewall.sh");
#endif


	submitUrl = websGetVar(wp, T("wlan-url"), T(""));   // hidden page
	REPLACE1_MSG(submitUrl);

	return;
setErr_advance:
	ERR_MSG(tmpBuf);
}
#endif
///////////////////////////////////////////////////////////////////////////////////////////
void formWlanTemp(webs_t wp, char_t *path, char_t *query)
{
	char_t	*submitUrl, *strMode;
	char tmpBuf[100];
	int mode;

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
	strMode = websGetVar(wp, T("apModeTemp"), T(""));
	if ( strMode[0] ) {
		errno=0;
		mode = strtol( strMode, (char **)NULL, 10);
		if (errno) {
   			strcpy(tmpBuf, T("Invalid WLAN Mode!"));
			goto setErr_wlan;
		}
		if ( apmib_set( MIB_AP_MODE_TEMP, (void *)&mode) == 0) {
   			strcpy(tmpBuf, T("Set WLAN Mode error!"));
			goto setErr_wlan;
		}
	}
	
/*	if ( mode==1 || mode==2) {
		if ( apmib_set( MIB_WLAN_MODE, 1) == 0) {
   			strcpy(tmpBuf, T("Set MIB_WLAN_MODE error!"));
			goto setErr_wlan;
		}
	}
*/	
	apmib_update(CURRENT_SETTING);	// update to flash
	REPLACE_MSG(submitUrl);
	               return;

setErr_wlan:
	ERR_MSG(tmpBuf);
}
/////////////////////////////////////////////////////////////////////////////
void formWlanSetup(webs_t wp, char_t *path, char_t *query)
{
   	char_t *submitUrl, *strSSID, *strChan, *strDisabled, *strAliasName;
	char_t *strMode, *strMac1, *strMac2, *strMac3, *strMac4, *strMac5, *strMac6;
	int chan, disabled, mode;
	NETWORK_TYPE_T net;
	char tmpBuf[100];

   	strAliasName = websGetVar(wp, T("name"), T(""));
	if ( apmib_set(MIB_ALIAS_NAME, (void *)strAliasName) == 0) {
		strcpy(tmpBuf, T("Set AP Name MIB error!"));
		goto setErr_wlan;
	}

	strDisabled = websGetVar(wp, T("wlanDisabled"), T(""));
	if ( !gstrcmp(strDisabled, T("ON")))
		disabled = 1;
	else
		disabled = 0;
	if ( apmib_set( MIB_WLAN_DISABLED, (void *)&disabled) == 0) {
  		strcpy(tmpBuf, T("Set disabled flag error!"));
		goto setErr_wlan;
	}

	if ( disabled )
		goto setwlan_ret;

	// no used**********************************
/*	strVal = websGetVar(wp, T("mode"), T(""));
	if ( strVal[0] ) {
		if (strVal[0]!= '0' && strVal[0]!= '1' && strVal[0]!= '2') {
  			strcpy(tmpBuf, T("Invalid mode value!"));
			goto setErr_wlan;
		}
		mode = strVal[0] - '0';

		if ( apmib_set( MIB_WLAN_MODE, (void *)&mode) == 0) {
   			strcpy(tmpBuf, T("Set MIB_WLAN_MODE error!"));
			goto setErr_wlan;
		}
	}
*/
   	strSSID = websGetVar(wp, T("ssid"), T(""));
	if ( strSSID[0] ) {
		if ( apmib_set(MIB_WLAN_SSID, (void *)strSSID) == 0) {
   	 			strcpy(tmpBuf, T("Set SSID error!"));
				goto setErr_wlan;
		}
	}

	strChan = websGetVar(wp, T("chan"), T(""));
	if ( strChan[0] ) {
		errno=0;
		chan = strtol( strChan, (char **)NULL, 10);
		if (errno) {
   			strcpy(tmpBuf, T("Invalid channel number!"));
			goto setErr_wlan;
		}
		if ( apmib_set( MIB_WLAN_CHAN_NUM, (void *)&chan) == 0) {
   			strcpy(tmpBuf, T("Set channel number error!"));
			goto setErr_wlan;
		}
	}
	//AP client mode type
/*	strVal = websGetVar(wp, T("netType"), T(""));
	if (strVal[0]) {
		if (!gstrcmp(strVal, T("infra")))
			net = INFRASTRUCTURE;
		else if (!gstrcmp(strVal, T("adhoc")))
			net = ADHOC;
		else {
			strcpy(tmpBuf, T("Error! Invalid network type value."));
			goto setErr_wlan;
		}
		if ( apmib_set(MIB_WLAN_NETWORK_TYPE, (void *)&net) == 0) {
			strcpy(tmpBuf, T("Set MIB_WLAN_NETWORK_TYPE failed!"));
			goto setErr_wlan;
		}
	}*/
//-------------------------------------Erwin Add 29.08--------------------------------------------
	strMode = websGetVar(wp, T("apMode"), T(""));
	if (strMode[0]) {
		errno=0;
		mode = strtol( strMode, (char **)NULL, 10);
		if (errno) {
   			strcpy(tmpBuf, T("Invalid WLAN Mode!"));
			goto setErr_wlan;
		}
		if ( apmib_set( MIB_AP_MODE, (void *)&mode) == 0) {
   			strcpy(tmpBuf, T("Set WLAN Mode error!"));
			goto setErr_wlan;
		}
	}

	//Erwin Add for wlan.sh Script 07.09
	
		if (strMode[0]=='1' || strMode[0]=='2')
				mode = 1;
		else
				mode = 0;
		if ( apmib_set( MIB_WLAN_MODE, (void *)&mode) == 0) {
   			strcpy(tmpBuf, T("Set MIB_WLAN_MODE error!"));
			goto setErr_wlan;
		}

	//AP client mode type
	if (mode == 1) {
		if (strMode[0]=='1')
			net = ADHOC;
		if (strMode[0]=='2')
			net = INFRASTRUCTURE;
		if ( apmib_set(MIB_WLAN_NETWORK_TYPE, (void *)&net) == 0) {
			strcpy(tmpBuf, T("Set MIB_WLAN_NETWORK_TYPE failed!"));
			goto setErr_wlan;
		}
	}
	
	strMac1 = websGetVar(wp, T("wlLinkMac1"), T(""));
	if (strMac1[0]) {
		if (strlen(strMac1)!=12 || !string_to_hex(strMac1, tmpBuf, 12)) {
			strcpy(tmpBuf, T("Error! Invalid MAC1 address."));
			goto setErr_wlan;
		}
		if ( !apmib_set(MIB_WL_LINKMAC1, (void *)tmpBuf)) {
			strcpy(tmpBuf, T("Set MIB_WL_LINKMAC1 mib error!"));
			goto setErr_wlan;
		}
	}
	strMac2 = websGetVar(wp, T("wlLinkMac2"), T(""));
	if (strMac2[0]) {
		if (strlen(strMac2)!=12 || !string_to_hex(strMac2, tmpBuf, 12)) {
			strcpy(tmpBuf, T("Error! Invalid MAC2 address."));
			goto setErr_wlan;
		}
		if ( !apmib_set(MIB_WL_LINKMAC2, (void *)tmpBuf)) {
			strcpy(tmpBuf, T("Set MIB_WL_LINKMAC2 mib error!"));
			goto setErr_wlan;
		}
	}
	strMac3 = websGetVar(wp, T("wlLinkMac3"), T(""));
	if (strMac3[0]) {
		if (strlen(strMac3)!=12 || !string_to_hex(strMac3, tmpBuf, 12)) {
			strcpy(tmpBuf, T("Error! Invalid MAC3 address."));
			goto setErr_wlan;
		}
		if ( !apmib_set(MIB_WL_LINKMAC3, (void *)tmpBuf)) {
			strcpy(tmpBuf, T("Set MIB_WL_LINKMAC3 mib error!"));
			goto setErr_wlan;
		}
	}
	strMac4 = websGetVar(wp, T("wlLinkMac4"), T(""));
	if (strMac4[0]) {
		if (strlen(strMac4)!=12 || !string_to_hex(strMac4, tmpBuf, 12)) {
			strcpy(tmpBuf, T("Error! Invalid MAC4 address."));
			goto setErr_wlan;
		}
		if ( !apmib_set(MIB_WL_LINKMAC4, (void *)tmpBuf)) {
			strcpy(tmpBuf, T("Set MIB_WL_LINKMAC4 mib error!"));
			goto setErr_wlan;
		}
	}
	strMac5 = websGetVar(wp, T("wlLinkMac5"), T(""));
	if (strMac5[0]) {
		if (strlen(strMac5)!=12 || !string_to_hex(strMac5, tmpBuf, 12)) {
			strcpy(tmpBuf, T("Error! Invalid MAC5 address."));
			goto setErr_wlan;
		}
		if ( !apmib_set(MIB_WL_LINKMAC5, (void *)tmpBuf)) {
			strcpy(tmpBuf, T("Set MIB_WL_LINKMAC5 mib error!"));
			goto setErr_wlan;
		}
	}
	strMac6 = websGetVar(wp, T("wlLinkMac6"), T(""));
	if (strMac6[0]) {
		if (strlen(strMac6)!=12 || !string_to_hex(strMac6, tmpBuf, 12)) {
			strcpy(tmpBuf, T("Error! Invalid MAC6 address."));
			goto setErr_wlan;
		}
		if ( !apmib_set(MIB_WL_LINKMAC6, (void *)tmpBuf)) {
			strcpy(tmpBuf, T("Set MIB_WL_LINKMAC6 mib error!"));
			goto setErr_wlan;
		}
	}

/*	websHeader(wp);
	websWrite(wp, "<HEAD></HEAD><BODY>");
	websWrite(wp, "<br><blockquote>");
	websWrite(wp, "<h4 style='position:absolute; top:50px; left:50px;background-color:yellow'>Your data is being processed now.</h4>");
*/
//-------------------------------------------------------------------------------------------
	PROC_MSG();
setwlan_ret:
	apmib_update(CURRENT_SETTING);

/*#ifndef NO_ACTION
	// run script file to update WLAN parameters
	pid = fork();
        if (pid)
		waitpid(pid, NULL, 0);
        else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _WLAN_SCRIPT_PROG);
		execl( tmpBuf, _WLAN_SCRIPT_PROG, WLAN_IF, NULL);
                exit(1);
        }
#endif
*/

#ifndef NO_ACTION
	#ifdef HOME_GATEWAY
		sprintf(tmpBuf, "%s/%s %s %s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG, "gw", "all");
		system(tmpBuf);
	#else
		sprintf(tmpBuf, "%s/%s %s %s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG, "ap", "all");
		system(tmpBuf);
	#endif
#endif
/*	websWrite(wp, "<h4 style='position:absolute;top:50px;left:50px;background-color:yellow'></h4>");
	websWrite(wp, "</BODY>");
   	websFooter(wp);
	websDone(wp, 200);
*/
		
	submitUrl = websGetVar(wp, T("wlan-url"), T(""));   // hidden page
	OK_MSG(submitUrl);

	return;

setErr_wlan:
	ERR_MSG(tmpBuf);
}

/////////////////////////////////////////////////////////////////////////////
void formWep(webs_t wp, char_t *path, char_t *query)
{
   	char_t *submitUrl, *wepKey;
   	char_t *strKeyLen, *strFormat, *strKeyId, *strEnabled, *str1xMode;
	char_t *strVal, *strEncrypt; //Erwin Add
	char tmpBuf[100], key[30];
	int enabled, keyLen, ret, i, intVal;
	struct in_addr inIp;	//Erwin Add
	ENCRYPT_T encrypt;		//Erwin Add
	WEP_T wep;

	
	//Set Security method Erwin Add 01.09
   	strEncrypt = websGetVar(wp, T("method"), T(""));
	if (!strEncrypt[0]) {
 		strcpy(tmpBuf, T("Error! no encryption method."));
		goto setErr_wep;
	}
	encrypt = (ENCRYPT_T) strEncrypt[0] - '0';
	if (encrypt!=ENCRYPT_DISABLED && encrypt!=ENCRYPT_WEP && encrypt!=ENCRYPT_1X &&
		encrypt!=ENCRYPT_WSK && encrypt!=ENCRYPT_PSK && encrypt!=ENCRYPT_ARS) {
		strcpy(tmpBuf, T("Invalid encryption method!"));
		goto setErr_wep;
	}
	if (apmib_set( MIB_SECURITY_MODE, (void *)&encrypt) == 0) {
  		strcpy(tmpBuf, T("Set MIB_SECURITY_MODE mib error!"));
		goto setErr_wep;
	}
	

	//Follow Realtek, Set WLAN_ENCRYPT
	if (encrypt==ENCRYPT_DISABLED || encrypt==ENCRYPT_1X)
		intVal = 0;
	else if (encrypt==ENCRYPT_WEP || encrypt==ENCRYPT_WSK)
		intVal = 1;
		else
			intVal = 2;	
	if (apmib_set( MIB_WLAN_ENCRYPT, (void *)&intVal) == 0) {
  		strcpy(tmpBuf, T("Set MIB_WLAN_ENCRYPT mib error!"));
		goto setErr_wep;
	}

	//Set 802.1x Enable Erwin Add 05.09.2003
	if (encrypt==ENCRYPT_1X || encrypt==ENCRYPT_WSK || encrypt==ENCRYPT_ARS)
		intVal = 1;
	else 
		intVal = 0;
	if ( apmib_set( MIB_WLAN_ENABLE_1X, (void *)&intVal) == 0) {
		strcpy(tmpBuf, T("Set 1x enable flag error!"));
		goto setErr_wep;
	}
	

	strEnabled = websGetVar(wp, T("wepEnabled"), T(""));
	if ( !gstrcmp(strEnabled, T("ON")))
		enabled = 1;
	else
		enabled = 0;

	if ( enabled ) {
		strKeyLen = websGetVar(wp, T("length"), T(""));
		if (!strKeyLen[0]) {
 			strcpy(tmpBuf, T("Key length must exist!"));
			goto setErr_wep;
		}
		if (strKeyLen[0]!='1' && strKeyLen[0]!='2' && strKeyLen[0]!='3') {
 			strcpy(tmpBuf, T("Invalid key length value!"));
			goto setErr_wep;
		}
		if (strKeyLen[0] == '1')
			wep = WEP64;
		else if (strKeyLen[0] == '2')
			wep = WEP128;
		else
			wep = WEP152;
	}
	else
		wep = WEP_DISABLED;

	if ( apmib_set( MIB_WLAN_WEP, (void *)&wep) == 0) {
  		strcpy(tmpBuf, T("Set WEP MIB error!"));
		goto setErr_wep;
	}

	if (wep == WEP_DISABLED)
		goto setwep_ret;

if (encrypt==ENCRYPT_WEP || encrypt==ENCRYPT_WSK) { //Erwin Modify 01.09.'03
	strFormat = websGetVar(wp, T("format"), T(""));
	if (!strFormat[0]) {
 		strcpy(tmpBuf, T("Key type must exist!"));
		goto setErr_wep;
	}

	if (strFormat[0]!='1' && strFormat[0]!='2') {
		strcpy(tmpBuf, T("Invalid key type value!"));
		goto setErr_wep;
	}

	i = strFormat[0] - '0' - 1;
	if ( apmib_set( MIB_WLAN_WEP_KEY_TYPE, (void *)&i) == 0) {
  		strcpy(tmpBuf, T("Set WEP key type error!"));
		goto setErr_wep;
	}

	if (wep == WEP64) {
		if (strFormat[0]=='1')
			keyLen = WEP64_KEY_LEN;
		else
			keyLen = WEP64_KEY_LEN*2;
	}
	else if (wep == WEP128) {
		if (strFormat[0]=='1')
			keyLen = WEP128_KEY_LEN;
		else
			keyLen = WEP128_KEY_LEN*2;
	}
	else {
		if (strFormat[0]=='1')
			keyLen = WEP152_KEY_LEN;
		else
			keyLen = WEP152_KEY_LEN*2;
	}
//********************************************************************************************
	strKeyId = websGetVar(wp, T("defaultTxKeyId"), T(""));
	if ( strKeyId[0] ) {
		if ( strKeyId[0]!='1' && strKeyId[0]!='2' && strKeyId[0]!='3' && strKeyId[0]!='4' ) {
	 		strcpy(tmpBuf, T("Invalid default tx key id!"));
   			goto setErr_wep;
		}
		i = strKeyId[0] - '0' - 1;
		if ( !apmib_set( MIB_WLAN_WEP_DEFAULT_KEY, (void *)&i ) ) {
	 		strcpy(tmpBuf, T("Set default tx key id error!"));
   			goto setErr_wep;
		}
	}

	wepKey = websGetVar(wp, T("key1"), T(""));
	if  (wepKey[0]) {
		if (strlen(wepKey) != keyLen) {
			strcpy(tmpBuf, T("Invalid key 1 length!"));
			goto setErr_wep;
		}
		if ( !isAllStar(wepKey) ) {
			if (strFormat[0] == '1') // ascii
				strcpy(key, wepKey);
			else { // hex
				if ( !string_to_hex(wepKey, key, keyLen)) {
	   				strcpy(tmpBuf, T("Invalid wep-key1 value!"));
					goto setErr_wep;
				}
			}
			if (wep == WEP64)
				ret=apmib_set(MIB_WLAN_WEP64_KEY1, (void *)key);
			else if (wep == WEP128)
				ret=apmib_set(MIB_WLAN_WEP128_KEY1, (void *)key);
			else
				ret=apmib_set(MIB_WLAN_WEP152_KEY1, (void *)key);
			if (!ret) {
	 			strcpy(tmpBuf, T("Set wep-key1 error!"));
				goto setErr_wep;
			}
		}
	}
	wepKey = websGetVar(wp, T("key2"), T(""));
	if  (wepKey[0]) {
		if (strlen(wepKey) != keyLen) {
			strcpy(tmpBuf, T("Invalid key 2 length!"));
			goto setErr_wep;
		}
		if ( !isAllStar(wepKey) ) {
			if (strFormat[0] == '1') // ascii
				strcpy(key, wepKey);
			else { // hex
				if ( !string_to_hex(wepKey, key, keyLen)) {
	   				strcpy(tmpBuf, T("Invalid wep-key2 value!"));
   					goto setErr_wep;
				}
			}
			if (wep == WEP64)
				ret=apmib_set(MIB_WLAN_WEP64_KEY2, (void *)key);
			else if (wep == WEP128)
				ret=apmib_set(MIB_WLAN_WEP128_KEY2, (void *)key);
			else
				ret=apmib_set(MIB_WLAN_WEP152_KEY2, (void *)key);
			if (!ret) {
	 			strcpy(tmpBuf, T("Set wep-key2 error!"));
				goto setErr_wep;
			}
		}
	}

	wepKey = websGetVar(wp, T("key3"), T(""));
	if  (wepKey[0]) {
		if (strlen(wepKey) != keyLen) {
			strcpy(tmpBuf, T("Invalid key 3 length!"));
			goto setErr_wep;
		}
		if ( !isAllStar(wepKey) ) {
			if (strFormat[0] == '1') // ascii
				strcpy(key, wepKey);
			else { // hex
				if ( !string_to_hex(wepKey, key, keyLen)) {
	   				strcpy(tmpBuf, T("Invalid wep-key3 value!"));
   					goto setErr_wep;
				}
			}
			if (wep == WEP64)
				ret=apmib_set(MIB_WLAN_WEP64_KEY3, (void *)key);
			else if (wep == WEP128)
				ret=apmib_set(MIB_WLAN_WEP128_KEY3, (void *)key);
			else
				ret=apmib_set(MIB_WLAN_WEP152_KEY3, (void *)key);
			if (!ret) {
	 			strcpy(tmpBuf, T("Set wep-key3 error!"));
				goto setErr_wep;
			}
		}
	}

	wepKey = websGetVar(wp, T("key4"), T(""));
	if  (wepKey[0]) {
		if (strlen(wepKey) != keyLen) {
			strcpy(tmpBuf, T("Invalid key 1 length!"));
			goto setErr_wep;
		}
		if ( !isAllStar(wepKey) ) {
			if (strFormat[0] == '1') // ascii
				strcpy(key, wepKey);
			else { // hex
				if ( !string_to_hex(wepKey, key, keyLen)) {
	   				strcpy(tmpBuf, T("Invalid wep-key4 value!"));
   					goto setErr_wep;
				}
			}
			if (wep == WEP64)
				ret=apmib_set(MIB_WLAN_WEP64_KEY4, (void *)key);
			else if (wep == WEP128)
				ret=apmib_set(MIB_WLAN_WEP128_KEY4, (void *)key);
			else
				ret=apmib_set(MIB_WLAN_WEP152_KEY4, (void *)key);
			if (!ret) {
	 			strcpy(tmpBuf, T("Set wep-key4 error!"));
				goto setErr_wep;
			}
		}
	}
}
//*********************************** RADIUS Server setting ***********************************
//#ifndef HOME_GATEWAY  // Lance 2003.11.06
	if (encrypt==ENCRYPT_WSK) {
		str1xMode = websGetVar(wp, T("sel1xMode"), T(""));
		if (!gstrcmp(str1xMode, T("ON")))
			intVal = 0;
		else  
			intVal = 1;
		if ( apmib_set(MIB_1X_MODE, (void *)&intVal) == 0) {
			strcpy(tmpBuf, T("Set 802.1x Mode failed!"));
			goto setErr_wep;
		}
		if (!str1xMode[0]) {	
			strVal = websGetVar(wp, T("radiusPort"), T(""));
			if (!strVal[0]) {
				strcpy(tmpBuf, T("No RS port number!"));
				goto setErr_wep;
			}
			if (!string_to_dec(strVal, &intVal) || intVal<=0 || intVal>65535) {
				strcpy(tmpBuf, T("Error! Invalid value of RS port number."));
				goto setErr_wep;
			}
			if ( !apmib_set(MIB_WLAN_RS_PORT, (void *)&intVal)) {
				strcpy(tmpBuf, T("Set RS port error!"));
				goto setErr_wep;
			}
			strVal = websGetVar(wp, T("radiusIP"), T(""));
			if (!strVal[0]) {
				strcpy(tmpBuf, T("No RS IP address!"));
				goto setErr_wep;
			}
			if ( !inet_aton(strVal, &inIp) ) {
				strcpy(tmpBuf, T("Invalid RS IP-address value!"));
				goto setErr_wep;
			}
			if ( !apmib_set(MIB_WLAN_RS_IP, (void *)&inIp)) {
				strcpy(tmpBuf, T("Set RS IP-address error!"));
				goto setErr_wep;
			}
			strVal = websGetVar(wp, T("radiusPass"), T(""));
			if (strlen(strVal) > (MAX_RS_PASS_LEN -1) ) {
				strcpy(tmpBuf, T("RS password length too long!"));
				goto setErr_wep;
			}
			if ( !apmib_set(MIB_WLAN_RS_PASSWORD, (void *)strVal)) {
				strcpy(tmpBuf, T("Set RS password error!"));
				goto setErr_wep;
			}
		}
	}
//#endif

	PROC_MSG();



	
setwep_ret:
	apmib_update(CURRENT_SETTING);

#ifndef NO_ACTION
	// run script file to update WLAN parameters
//	sprintf(tmpBuf, "%s/%s %s", _CONFIG_SCRIPT_PATH, _WLAN_SCRIPT_PROG, WLAN_IF);
//	sprintf(tmpBuf, "%s %s", "/bin/wlan.sh", WLAN_IF);
//	system(tmpBuf);
//    sprintf(tmpBuf, "%s %s", "/bin/iappauth.sh", BRIDGE_IF);
//	system(tmpBuf);
	#ifdef HOME_GATEWAY
		sprintf(tmpBuf, "%s %s %s", "/bin/init.sh", "gw", "bridge");
		system(tmpBuf);
	#else
		sprintf(tmpBuf, "%s %s %s", "/bin/init.sh", "ap", "bridge");
		system(tmpBuf);
	#endif
#endif
	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
	OK_MSG(submitUrl);

	return;

setErr_wep:
	ERR_MSG(tmpBuf);
}


#ifdef WLAN_WPA
/////////////////////////////////////////////////////////////////////////////
void formWlEncrypt(webs_t wp, char_t *path, char_t *query)
{
   	char_t *submitUrl, *strEncrypt, *strVal, *str1xMode;
	char tmpBuf[100];
	ENCRYPT_T encrypt;
	int enableRS=0, intVal, getPSK=0, len;
	unsigned long reKeyTime;
	SUPP_NONWAP_T suppNonWPA;
	struct in_addr inIp;

	//Set security method 
   	strEncrypt = websGetVar(wp, T("method"), T(""));
	if (!strEncrypt[0]) {
 		strcpy(tmpBuf, T("Error! no encryption method."));
		goto setErr_encrypt;
	}
	encrypt = (ENCRYPT_T) strEncrypt[0] - '0';
	if (encrypt!=ENCRYPT_DISABLED && encrypt!=ENCRYPT_WEP && encrypt!=ENCRYPT_1X &&
		encrypt!=ENCRYPT_WSK && encrypt!=ENCRYPT_PSK && encrypt!=ENCRYPT_ARS) {
		strcpy(tmpBuf, T("Invalid encryption method!"));
		goto setErr_encrypt;
	}
	if (apmib_set( MIB_SECURITY_MODE, (void *)&encrypt) == 0) {
  		strcpy(tmpBuf, T("Set MIB_SECURITY_MODE mib error!"));
		goto setErr_encrypt;
	}
	
	//Follow Realtek, Set WLAN_ENCRYPT
	if (encrypt==ENCRYPT_DISABLED || encrypt==ENCRYPT_1X)
		intVal = 0;
	else if (encrypt==ENCRYPT_WEP || encrypt==ENCRYPT_WSK)
		intVal = 1;
	else
		intVal = 2;	
	if (apmib_set( MIB_WLAN_ENCRYPT, (void *)&intVal) == 0) {
  		strcpy(tmpBuf, T("Set MIB_WLAN_ENCRYPT mib error!"));
		goto setErr_encrypt;
	}
	
	//set internal or external RADIUS
	str1xMode = websGetVar(wp, T("sel1xMode"), T(""));
	if (encrypt==ENCRYPT_1X || encrypt==ENCRYPT_WSK || encrypt==ENCRYPT_ARS) {
		if (!gstrcmp(str1xMode, T("ON")))
			intVal = 0;
		else  
			intVal = 1;
		if ( apmib_set(MIB_1X_MODE, (void *)&intVal) == 0) {
			strcpy(tmpBuf, T("Set 802.1x Mode failed!"));
			goto setErr_encrypt;
		}
	}
	
	//Set 802.1x Enable Erwin Add 05.09
	if (encrypt==ENCRYPT_1X || encrypt==ENCRYPT_WSK || encrypt==ENCRYPT_ARS || encrypt==ENCRYPT_PSK)
		intVal = 1;
	else 
		intVal = 0;
	if ( apmib_set( MIB_WLAN_ENABLE_1X, (void *)&intVal) == 0) {
		strcpy(tmpBuf, T("Set 1x enable flag error!"));
		goto setErr_encrypt;
	}
	
	// support nonWPA client
	strVal = websGetVar(wp, T("nonWpaSupp"), T(""));
	if ( !gstrcmp(strVal, T("ON")))
		intVal = 1;
	else
		intVal = 0;
	if ( apmib_set( MIB_WLAN_ENABLE_SUPP_NONWPA, (void *)&intVal) == 0) {
		strcpy(tmpBuf, T("Set MIB_WLAN_ENABLE_SUPP_NONWPA mib error!"));
		goto setErr_encrypt;
	}
	if ( intVal ) {
		suppNonWPA = SUPP_NONWPA_NONE;
		strVal = websGetVar(wp, T("nonWpaWep"), T(""));
		if ( !gstrcmp(strVal, T("ON")))
			suppNonWPA |= SUPP_NONWPA_WEP;

		strVal = websGetVar(wp, T("nonWpa1x"), T(""));
		if ( !gstrcmp(strVal, T("ON"))) {
			suppNonWPA |= SUPP_NONWPA_1X;
			enableRS = 1;
		}

		if ( apmib_set( MIB_WLAN_SUPP_NONWPA, (void *)&suppNonWPA) == 0) {
			strcpy(tmpBuf, T("Set MIB_WLAN_SUPP_NONWPA mib error!"));
			goto setErr_encrypt;
		}
	}
	
	// WPA authentication
	strVal = websGetVar(wp, T("wpaAuth"), T(""));
	if (strVal[0]) {
		if ( !gstrcmp(strVal, T("eap"))) {
			intVal = WPA_AUTH_AUTO;
			enableRS = 1;
		}
		else if ( !gstrcmp(strVal, T("psk"))) {
			intVal = WPA_AUTH_PSK;
			getPSK = 1;
		}
		else {
			strcpy(tmpBuf, T("Error! Invalid wpa authentication value."));
			goto setErr_encrypt;
		}
		if ( apmib_set(MIB_WLAN_WPA_AUTH, (void *)&intVal) == 0) {
			strcpy(tmpBuf, T("Set MIB_WLAN_AUTH_TYPE failed!"));
			goto setErr_encrypt;
		}
	}

	// cipher suite
	if (encrypt!=ENCRYPT_DISABLED && encrypt!=ENCRYPT_1X) {
		intVal = 0;
		strVal = websGetVar(wp, T("tkip"), T(""));
		if ( !gstrcmp(strVal, T("ON")))
			intVal |= WPA_CIPHER_TKIP;
		strVal = websGetVar(wp, T("aes"), T(""));
		if ( !gstrcmp(strVal, T("ON")))
			intVal |= WPA_CIPHER_AES;
		if (intVal == 0) {
			strcpy(tmpBuf, T("Invalid value of cipher suite!"));
			goto setErr_encrypt;
		}
		if ( apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal) == 0) {
			strcpy(tmpBuf, T("Set MIB_WLAN_WPA_CIPHER_SUITE failed!"));
			goto setErr_encrypt;
		}
	}

//*********************************** pre-shared key setting ***********************************
	if ( getPSK ) {
		int oldFormat, oldPskLen, i;

		strVal = websGetVar(wp, T("pskFormat"), T(""));
		if (!strVal[0]) {
 			strcpy(tmpBuf, T("Error! no psk format."));
			goto setErr_encrypt;
		}
		intVal = strVal[0] - '0';
		if (intVal != 0 && intVal != 1) {
 			strcpy(tmpBuf, T("Error! invalid psk format."));
			goto setErr_encrypt;
		}

		// remember current psk format and length to compare to default case "****"
		apmib_get(MIB_WLAN_WPA_PSK_FORMAT, (void *)&oldFormat);
		apmib_get(MIB_WLAN_WPA_PSK, (void *)tmpBuf);
		oldPskLen = strlen(tmpBuf);

		strVal = websGetVar(wp, T("pskValue"), T(""));
		len = strlen(strVal);

		if (oldFormat == intVal && len == oldPskLen ) {
			for (i=0; i<len; i++) {
				if ( strVal[i] != '*' )
					break;
			}
			if (i == len)
				goto rekey_time;
		}

		if ( apmib_set(MIB_WLAN_WPA_PSK_FORMAT, (void *)&intVal) == 0) {
			strcpy(tmpBuf, T("Set MIB_WLAN_WPA_PSK_FORMAT failed!"));
			goto setErr_encrypt;
		}

		if (intVal==1) { // hex
			if (len!=MAX_PSK_LEN || !string_to_hex(strVal, tmpBuf, MAX_PSK_LEN)) {
 				strcpy(tmpBuf, T("Error! invalid psk value."));
				goto setErr_encrypt;
			}
		}
		else { // passphras
			if (len==0 || len > (MAX_PSK_LEN-1) ) {
 				strcpy(tmpBuf, T("Error! invalid psk value."));
				goto setErr_encrypt;
			}
		}
		if ( !apmib_set(MIB_WLAN_WPA_PSK, (void *)strVal)) {
			strcpy(tmpBuf, T("Set MIB_WLAN_WPA_PSK error!"));
			goto setErr_encrypt;
		}
	}
//****************************************  ****************************************
rekey_time:
		// group key rekey time
		reKeyTime = 0;
		strVal = websGetVar(wp, T("groupKeyTimeDay"), T(""));
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, T("Error! Invalid value of rekey day."));
				goto setErr_encrypt;
			}
			reKeyTime += intVal*86400;
		}
		strVal = websGetVar(wp, T("groupKeyTimeHr"), T(""));
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, T("Error! Invalid value of rekey hr."));
				goto setErr_encrypt;
			}
			reKeyTime += intVal*3600;
		}
		strVal = websGetVar(wp, T("groupKeyTimeMin"), T(""));
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, T("Error! Invalid value of rekey min."));
				goto setErr_encrypt;
			}
			reKeyTime += intVal*60;
		}

		strVal = websGetVar(wp, T("groupKeyTimeSec"), T(""));
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, T("Error! Invalid value of rekey sec."));
				goto setErr_encrypt;
			}
			reKeyTime += intVal;
		}
/*		if ( reKeyTime == 0) {//Erwin Modify 27.08
			strcpy(tmpBuf, T("Error! Invalid value of rekey time."));
			goto setErr_encrypt;
		}
		if ( !apmib_set(MIB_WLAN_WPA_GROUP_REKEY_TIME, (void *)&reKeyTime)) {
			strcpy(tmpBuf, T("Set MIB_WLAN_WPA_GROUP_REKEY_TIME error!"));
			goto setErr_encrypt;
		}
*/		
		if (reKeyTime) {
			if ( !apmib_set(MIB_WLAN_WPA_GROUP_REKEY_TIME, (void *)&reKeyTime)) {
				strcpy(tmpBuf, T("Set MIB_WLAN_WPA_GROUP_REKEY_TIME error!"));
				goto setErr_encrypt;
			}
		}
//	}

//*********************************** RADIUS Server setting ***********************************
	if (enableRS == 1) { // if 1x enabled, get RADIUS server info
//#ifndef HOME_GATEWAY
		if (!str1xMode[0])
//#endif
		{
			strVal = websGetVar(wp, T("radiusPort"), T(""));
			if (!strVal[0]) {
				strcpy(tmpBuf, T("No RS port number!"));
				goto setErr_encrypt;
			}
			if (!string_to_dec(strVal, &intVal) || intVal<=0 || intVal>65535) {
				strcpy(tmpBuf, T("Error! Invalid value of RS port number."));
				goto setErr_encrypt;
			}
			if ( !apmib_set(MIB_WLAN_RS_PORT, (void *)&intVal)) {
				strcpy(tmpBuf, T("Set RS port error!"));
				goto setErr_encrypt;
			}
			strVal = websGetVar(wp, T("radiusIP"), T(""));
			if (!strVal[0]) {
				strcpy(tmpBuf, T("No RS IP address!"));
				goto setErr_encrypt;
			}
			if ( !inet_aton(strVal, &inIp) ) {
				strcpy(tmpBuf, T("Invalid RS IP-address value!"));
				goto setErr_encrypt;
			}
			if ( !apmib_set(MIB_WLAN_RS_IP, (void *)&inIp)) {
				strcpy(tmpBuf, T("Set RS IP-address error!"));
				goto setErr_encrypt;
			}
			strVal = websGetVar(wp, T("radiusPass"), T(""));
			if (strlen(strVal) > (MAX_RS_PASS_LEN -1) ) {
				strcpy(tmpBuf, T("RS password length too long!"));
				goto setErr_encrypt;
			}
			if ( !apmib_set(MIB_WLAN_RS_PASSWORD, (void *)strVal)) {
				strcpy(tmpBuf, T("Set RS password error!"));
				goto setErr_encrypt;
			}
		}
//---------------------------------Erwin Add 27.08------------------------------------------------
		strVal = websGetVar(wp, T("radiusRetry"), T("")); // differance "rsRetry"
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, T("Invalid RS retry value!"));
				goto setErr_encrypt;
			}
			if ( !apmib_set(MIB_WLAN_RS_RETRY, (void *)&intVal)) {
				strcpy(tmpBuf, T("Set MIB_WLAN_RS_RETRY error!"));
				goto setErr_encrypt;
			}
		}
		strVal = websGetVar(wp, T("radiusTime"), T(""));
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, T("Invalid RS time value!"));
				goto setErr_encrypt;
			}
			if ( !apmib_set(MIB_WLAN_RS_INTERVAL_TIME, (void *)&intVal)) {
				strcpy(tmpBuf, T("Set MIB_WLAN_RS_INTERVAL_TIME error!"));
				goto setErr_encrypt;
			}
		}
		strVal = websGetVar(wp, T("useAccount"), T(""));
		if ( !gstrcmp(strVal, T("ON")))
			intVal = 1;
		else
			intVal = 0;
		if ( apmib_set( MIB_WLAN_ACCOUNT_RS_ENABLED, (void *)&intVal) == 0) {
  			strcpy(tmpBuf, T("Set MIB_WLAN_ACCOUNT_RS_ENABLED mib error!"));
			goto setErr_encrypt;
		}
		if (intVal == 0)
			goto get_wepkey;

		strVal = websGetVar(wp, T("accountPort"), T(""));
		if (!strVal[0]) {
			strcpy(tmpBuf, T("No account RS port number!"));
			goto setErr_encrypt;
		}
		if (!string_to_dec(strVal, &intVal) || intVal<=0 || intVal>65535) {
			strcpy(tmpBuf, T("Error! Invalid value of account RS port number."));
			goto setErr_encrypt;
		}
		if ( !apmib_set(MIB_WLAN_ACCOUNT_RS_PORT, (void *)&intVal)) {
			strcpy(tmpBuf, T("Set account RS port error!"));
			goto setErr_encrypt;
		}
		strVal = websGetVar(wp, T("accountIP"), T(""));
		if (!strVal[0]) {
			strcpy(tmpBuf, T("No account RS IP address!"));
			goto setErr_encrypt;
		}
		if ( !inet_aton(strVal, &inIp) ) {
			strcpy(tmpBuf, T("Invalid account RS IP-address value!"));
			goto setErr_encrypt;
		}
		if ( !apmib_set(MIB_WLAN_ACCOUNT_RS_IP, (void *)&inIp)) {
			strcpy(tmpBuf, T("Set account RS IP-address error!"));
			goto setErr_encrypt;
		}
		strVal = websGetVar(wp, T("accountPass"), T(""));
		if (strlen(strVal) > (MAX_RS_PASS_LEN -1) ) {
			strcpy(tmpBuf, T("Account RS password length too long!"));
			goto setErr_encrypt;
		}
		if ( !apmib_set(MIB_WLAN_ACCOUNT_RS_PASSWORD, (void *)strVal)) {
			strcpy(tmpBuf, T("Set account RS password error!"));
			goto setErr_encrypt;
		}
		strVal = websGetVar(wp, T("accountRetry"), T(""));
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, T("Invalid account RS retry value!"));
				goto setErr_encrypt;
			}
			if ( !apmib_set(MIB_WLAN_ACCOUNT_RS_RETRY, (void *)&intVal)) {
				strcpy(tmpBuf, T("Set MIB_WLAN_ACCOUNT_RS_RETRY error!"));
				goto setErr_encrypt;
			}
		}
		strVal = websGetVar(wp, T("accountTime"), T(""));
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, T("Invalid account RS time value!"));
				goto setErr_encrypt;
			}
			if ( !apmib_set(MIB_WLAN_ACCOUNT_RS_INTERVAL_TIME, (void *)&intVal)) {
				strcpy(tmpBuf, T("Set MIB_WLAN_ACCOUNT_RS_INTERVAL_TIME error!"));
				goto setErr_encrypt;
			}
		}
		strVal = websGetVar(wp, T("accountUpdateEnabled"), T(""));
		if ( !gstrcmp(strVal, T("ON")))
			intVal = 1;
		else
			intVal = 0;
		if ( apmib_set( MIB_WLAN_ACCOUNT_UPDATE_ENABLED, (void *)&intVal) == 0) {
			strcpy(tmpBuf, T("Set MIB_WLAN_ACCOUNT_UPDATE_ENABLED mib error!"));
			goto setErr_encrypt;
		}
		strVal = websGetVar(wp, T("accountUpdateTime"), T(""));
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, T("Error! Invalid value of update time"));
				goto setErr_encrypt;
			}
			if ( !apmib_set(MIB_WLAN_ACCOUNT_UPDATE_DELAY, (void *)&intVal)) {
				strcpy(tmpBuf, T("Set MIB_WLAN_ACCOUNT_UPDATE_DELAY mib error!"));
				goto setErr_encrypt;
			}
		}

get_wepkey:
		// get 802.1x WEP key length
		strVal = websGetVar(wp, T("wepKeyLen"), T(""));
		if (strVal[0]) {
			if ( !gstrcmp(strVal, T("wep64")))
				intVal = WEP64;
			else if ( !gstrcmp(strVal, T("wep128")))
				intVal = WEP128;
			else {
				strcpy(tmpBuf, T("Error! Invalid wepkeylen value."));
				goto setErr_encrypt;
			}
			if ( apmib_set(MIB_WLAN_WEP, (void *)&intVal) == 0) {
				strcpy(tmpBuf, T("Set MIB_WLAN_WEP failed!"));
				goto setErr_encrypt;
			}
		}


//-----------------------------------------------------------------------------------------------
	}
	PROC_MSG();
	apmib_update(CURRENT_SETTING);

#ifndef NO_ACTION
//	sprintf(tmpBuf, "%s/%s %s", _CONFIG_SCRIPT_PATH, _WLAN_SCRIPT_PROG, WLAN_IF);
//	sprintf(tmpBuf, "%s %s", "/bin/wlan.sh", WLAN_IF);
//	system(tmpBuf);
//	sprintf(tmpBuf, "%s/%s %s", _CONFIG_SCRIPT_PATH, _IAPPAUTH_SCRIPT_PROG, BRIDGE_IF);
//    sprintf(tmpBuf, "%s %s", "/bin/iappauth.sh", BRIDGE_IF);
//	system(tmpBuf);
	#ifdef HOME_GATEWAY
		sprintf(tmpBuf, "%s %s %s", "/bin/init.sh", "gw", "bridge");
		system(tmpBuf);
	#else
		sprintf(tmpBuf, "%s %s %s", "/bin/init.sh", "ap", "bridge");
		system(tmpBuf);
	#endif
#endif

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
	OK_MSG(submitUrl);

	return;

setErr_encrypt:
	ERR_MSG(tmpBuf);
}
#endif
/////////////////////////////////////////////////////////////////////////////
int wlAcList(int eid, webs_t wp, int argc, char_t **argv)
{
	int nBytesSent=0, entryNum, i;
	MACFILTER_T entry;
	char tmpBuf[100];

	if ( !apmib_get(MIB_WLAN_AC_NUM, (void *)&entryNum)) {
  		websError(wp, 400, T("Get table entry error!\n"));
		return -1;
	}

/*	nBytesSent += websWrite(wp, T("<tr>"
      	"<td align=center width=\"45%%\" class=\"stable\"><font size=\"2\"><b>MAC Address</b></font></td>\n"
      	"<td align=center width=\"35%%\" class=\"stable\"><font size=\"2\"><b>Comment</b></font></td>\n"
      	"<td align=center width=\"20%%\" class=\"stable\"><font size=\"2\"><b>Select</b></font></td></tr>\n"));
*/
	for (i=1; i<=entryNum; i++) {
		*((char *)&entry) = (char)i;
		if ( !apmib_get(MIB_WLAN_AC_ADDR, (void *)&entry))
			return -1;

		snprintf(tmpBuf, 100, T("%02x:%02x:%02x:%02x:%02x:%02x"),
			entry.macAddr[0], entry.macAddr[1], entry.macAddr[2],
			entry.macAddr[3], entry.macAddr[4], entry.macAddr[5]);

		nBytesSent += websWrite(wp, T("<tr>"
			"<td align=center width=\"45%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
      			"<td align=center width=\"35%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
       			"<td align=center width=\"20%%\" class=\"table2\"><input type=\"checkbox\" name=\"select%d\" value=\"ON\"></td></tr>\n"),
				tmpBuf, entry.comment, i);
	}
	return nBytesSent;
}

/////////////////////////////////////////////////////////////////////////////
void formWlAc(webs_t wp, char_t *path, char_t *query)
{
	char_t *strAddMac, *strDelMac, *strDelAllMac, *strVal, *submitUrl, *strEnabled;
	char tmpBuf[100];
	int entryNum, i, enabled;
	MACFILTER_T macEntry;

	strAddMac = websGetVar(wp, T("addFilterMac"), T(""));
	strDelMac = websGetVar(wp, T("deleteSelFilterMac"), T(""));
	strDelAllMac = websGetVar(wp, T("deleteAllFilterMac"), T(""));
	strEnabled = websGetVar(wp, T("wlanAcEnabled"), T(""));

	if (strAddMac[0]) {
		if ( !gstrcmp(strEnabled, T("ON")))
			enabled = 1;
		else
			enabled = 0;
		if ( apmib_set( MIB_WLAN_AC_ENABLED, (void *)&enabled) == 0) {
  			strcpy(tmpBuf, T("Set enabled flag error!"));
			goto setErr_ac;
		}

		strVal = websGetVar(wp, T("mac"), T(""));
		if ( !strVal[0] ) {
//			strcpy(tmpBuf, T("Error! No mac address to set."));
			goto setac_ret;
		}
		if (strlen(strVal)!=12 || !string_to_hex(strVal, macEntry.macAddr, 12)) {
			strcpy(tmpBuf, T("Error! Invalid MAC address."));
			goto setErr_ac;
		}

		strVal = websGetVar(wp, T("comment"), T(""));
		if ( strVal[0] ) {
			if (strlen(strVal) > COMMENT_LEN-1) {
				strcpy(tmpBuf, T("Error! Comment length too long."));
				goto setErr_ac;
			}
			strcpy(macEntry.comment, strVal);
		}
		else
			macEntry.comment[0] = '\0';

		if ( !apmib_get(MIB_WLAN_AC_NUM, (void *)&entryNum)) {
			strcpy(tmpBuf, T("Get entry number error!"));
			goto setErr_ac;
		}
		if ( (entryNum + 1) > MAX_WLAN_AC_NUM) {
			strcpy(tmpBuf, T("Cannot add new entry because table is full!"));
			goto setErr_ac;
		}

		// set to MIB. try to delete it first to avoid duplicate case
		apmib_set(MIB_WLAN_AC_ADDR_DEL, (void *)&macEntry);
		if ( apmib_set(MIB_WLAN_AC_ADDR_ADD, (void *)&macEntry) == 0) {
			strcpy(tmpBuf, T("Add table entry error!"));
			goto setErr_ac;
		}
	}

	/* Delete entry */
	if (strDelMac[0]) {
		if ( !apmib_get(MIB_WLAN_AC_NUM, (void *)&entryNum)) {
			strcpy(tmpBuf, T("Get entry number error!"));
			goto setErr_ac;
		}
		for (i=entryNum; i>0; i--) {
			snprintf(tmpBuf, 20, "select%d", i);

			strVal = websGetVar(wp, tmpBuf, T(""));
			if ( !gstrcmp(strVal, T("ON")) ) {

				*((char *)&macEntry) = (char)i;
				if ( !apmib_get(MIB_WLAN_AC_ADDR, (void *)&macEntry)) {
					strcpy(tmpBuf, T("Get table entry error!"));
					goto setErr_ac;
				}
				if ( !apmib_set(MIB_WLAN_AC_ADDR_DEL, (void *)&macEntry)) {
					strcpy(tmpBuf, T("Delete table entry error!"));
					goto setErr_ac;
				}
			}
		}
	}

	/* Delete all entry */
	if ( strDelAllMac[0]) {
		if ( !apmib_set(MIB_WLAN_AC_ADDR_DELALL, (void *)&macEntry)) {
			strcpy(tmpBuf, T("Delete all table error!"));
			goto setErr_ac;
		}
	}

setac_ret:
//	apmib_get(MIB_WLAN_AC_NUM, (void *)&entryNum);//Erwin 7.30 Mac Table is empty, ENABLED is 0;
//	printf("\nWLAN_AC_NUM=\"%d\"\n",entryNum);
//	if (entryNum==0) enabled=0;
//	if ( apmib_set( MIB_WLAN_AC_ENABLED, (void *)&enabled) == 0) {
//		strcpy(tmpBuf, T("Set enabled flag error!"));
//		goto setErr_ac;
//	}
				
	PROC_MSG();
	apmib_update(CURRENT_SETTING);

#ifndef NO_ACTION
	// run script file to update WLAN parameters
	#ifdef HOME_GATEWAY
		sprintf(tmpBuf, "%s/%s %s %s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG, "gw", "bridge");
		system(tmpBuf);
	#else
		sprintf(tmpBuf, "%s/%s %s %s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG, "ap", "bridge");
		system(tmpBuf);
	#endif
#endif
	
	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
	if (submitUrl[0])
		websRedirect(wp, submitUrl);
	else
		websDone(wp, 200);
  	return;


	
//	OK_MSG( submitUrl );
//  	return;

setErr_ac:
	ERR_MSG(tmpBuf);
}


///////////////////////////////////////////////////////////////////////////////////////////
#ifdef HOME_GATEWAY
void formTimeZoneSetup(webs_t wp, char_t *path, char_t *query)
{
	char_t *submitUrl, *strTimeZoneSel, *strTimeServerAddr, *strDisabled, *strtimezoneEnable;
	char_t *strstartMonth, *strstartDay, *strendMonth, *strendDay;
	int val, disabled;
	struct in_addr inTimeServerAddr;
	char tmpBuf[100];
	
	strTimeZoneSel = websGetVar(wp, T("TimeZoneSel"), T(""));
	if (strTimeZoneSel[0]) {
		if ( !string_to_dec(strTimeZoneSel, &val) || val<0 || val>66) {
			strcpy(tmpBuf, T("Error! Invalid value of Time Zone."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_TIME_ZONE_SEL, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set Time Zone failed!"));
			goto setErr_advance;
		}
	}
		strTimeServerAddr = websGetVar(wp, T("TimeServerAddr"), T(""));
		if ( strTimeServerAddr[0] ) {
			if ( !inet_aton(strTimeServerAddr, &inTimeServerAddr) ) {
				strcpy(tmpBuf, T("Invalid IP-address value!"));
				goto setErr_advance;
			}
			if ( !apmib_set( MIB_TIMESERVER_ADDR, (void *)&inTimeServerAddr)) {
				strcpy(tmpBuf, T("Set IP-address error!"));
				goto setErr_advance;
			}
		}
	strDisabled = websGetVar(wp, T("DayLightEnable"), T(""));
	if ( !gstrcmp(strDisabled, T("ON")))
		disabled = 1;
	else
		disabled = 0;
	if ( apmib_set( MIB_DAYLIGHT_ENABLE, (void *)&disabled) == 0) {
  		strcpy(tmpBuf, T("Set Enabled flag error!"));
		goto setErr_advance;
	}
	strstartMonth = websGetVar(wp, T("startMonth"), T(""));
	if (strstartMonth[0]) {
		if ( !string_to_dec(strstartMonth, &val)) {
			strcpy(tmpBuf, T("Error! Invalid value of Start Month"));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_START_MONTH, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set Start Month failed!"));
			goto setErr_advance;
		}
	}
	strstartDay = websGetVar(wp, T("startDay"), T(""));
	if (strstartDay[0]) {
		if ( !string_to_dec(strstartDay, &val)) {
			strcpy(tmpBuf, T("Error! Invalid value of Start Day."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_START_DAY, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set Start Day failed!"));
			goto setErr_advance;
		}
	}
	strendMonth = websGetVar(wp, T("endMonth"), T(""));
	if (strendMonth[0]) {
		if ( !string_to_dec(strendMonth, &val)) {
			strcpy(tmpBuf, T("Error! Invalid value of End Month."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_END_MONTH, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set End Month failed!"));
			goto setErr_advance;
		}
	}
	strendDay = websGetVar(wp, T("endDay"), T(""));
	if (strendDay[0]) {
		if ( !string_to_dec(strendDay, &val)) {
			strcpy(tmpBuf, T("Error! Invalid value of End Day."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_END_DAY, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set End Day failed!"));
			goto setErr_advance;
		}
	}
	PROC_MSG();
	apmib_update(CURRENT_SETTING);

#ifndef NO_ACTION
	// run script file to update WLAN parameters
//	sprintf(tmpBuf, "%s/%s %s", _CONFIG_SCRIPT_PATH, _WLAN_SCRIPT_PROG, WLAN_IF);
	system("/bin/sntp.sh");
#endif
			

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page

//	websRedirect(wp, submitUrl);

	strtimezoneEnable = websGetVar(wp, T("settimezoneEnable"), T(""));
//	if ( !gstrcmp(strtimezoneEnable, T("ON"))){
	if (strtimezoneEnable[0]){
		REPLACE1_MSG(submitUrl);
  		return;
	} else {
		OK_MSG(submitUrl);
  		return;
	}

	
setErr_advance:
	ERR_MSG(tmpBuf);
}
/////////////////////////////////////////////////////////////////////////////
void formReManagementSetup(webs_t wp, char_t *path, char_t *query)
{
	char_t *submitUrl, *strreManHostAddr, *strreMangEnable, *strPort;
	int disabled, val;
	struct in_addr inreManHostAddr;
	char tmpBuf[100];
	
		strreManHostAddr = websGetVar(wp, T("reManHostAddr"), T(""));
		if ( strreManHostAddr[0] ) {
			if ( !inet_aton(strreManHostAddr, &inreManHostAddr) ) {
				strcpy(tmpBuf, T("Invalid IP-address value!"));
				goto setErr_advance;
			}
			if ( !apmib_set( MIB_REMANHOST_ADDR, (void *)&inreManHostAddr)) {
				strcpy(tmpBuf, T("Set IP-address error!"));
				goto setErr_advance;
			}
		}
	strPort = websGetVar(wp, T("reManPort"), T(""));
	if (strPort[0]) {
		if ( !string_to_dec(strPort, &val)) {
			strcpy(tmpBuf, T("Error! Invalid value of Port Number."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_REMAN_PORT, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set Port Number failed!"));
			goto setErr_advance;
		}
	}
	strreMangEnable = websGetVar(wp, T("reMangEnable"), T(""));
	if ( !gstrcmp(strreMangEnable, T("ON")))
		disabled = 1;
	else
		disabled = 0;
	if ( apmib_set( MIB_REMANG_ENABLE, (void *)&disabled) == 0) {
  		strcpy(tmpBuf, T("Set Enabled flag error!"));
		goto setErr_advance;
	}

	PROC_MSG();
	apmib_update(CURRENT_SETTING);

			
#ifndef NO_ACTION
//	sprintf(tmpBuf, "%s/%s", _CONFIG_SCRIPT_PATH, _FIREWALL_SCRIPT_PROG);
//	system(tmpBuf);
	system("/bin/firewall.sh");
#endif


	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page

//	websRedirect(wp, submitUrl);
	OK_MSG(submitUrl);
  	return;


	
setErr_advance:
	ERR_MSG(tmpBuf);
}
#endif
/////////////////////////////////////////////////////////////////////////////
void formAdvanceSetup(webs_t wp, char_t *path, char_t *query)
{
	char_t *submitUrl, *strAuth, *strFragTh, *strRtsTh, *strBeacon, *strPreamble;
	char_t *strRate, *strHiddenSSID, *strDtim, *strIapp, *strTx;
	AUTH_TYPE_T authType;
	PREAMBLE_T preamble;
	int val;
	char tmpBuf[100];
#if defined(_6104IPC_) | defined(_7207APS_)
	char_t *strTranRate, *strRateMode, *strCts, *strBurst;
#endif

	strAuth = websGetVar(wp, T("authType"), T(""));
	if (strAuth[0]) {
		if ( !gstrcmp(strAuth, T("open")))
			authType = AUTH_OPEN;
		else if ( !gstrcmp(strAuth, T("shared")))
			authType = AUTH_SHARED;
		else if ( !gstrcmp(strAuth, T("both")))
			authType = AUTH_BOTH;
		else {
			strcpy(tmpBuf, T("Error! Invalid authentication value."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_AUTH_TYPE, (void *)&authType) == 0) {
			strcpy(tmpBuf, T("Set authentication failed!"));
			goto setErr_advance;
		}
	}
	strFragTh = websGetVar(wp, T("fragThreshold"), T(""));
	if (strFragTh[0]) {
		if ( !string_to_dec(strFragTh, &val) || val<256 || val>2346) {
			strcpy(tmpBuf, T("Error! Invalid value of fragment threshold."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_FRAG_THRESHOLD, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set fragment threshold failed!"));
			goto setErr_advance;
		}
	}
	strRtsTh = websGetVar(wp, T("rtsThreshold"), T(""));
	if (strRtsTh[0]) {
		if ( !string_to_dec(strRtsTh, &val) || val<0 || val>2347) {
			strcpy(tmpBuf, T("Error! Invalid value of RTS threshold."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_RTS_THRESHOLD, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set RTS threshold failed!"));
			goto setErr_advance;
		}
	}

	strBeacon = websGetVar(wp, T("beaconInterval"), T(""));
	if (strBeacon[0]) {
		if ( !string_to_dec(strBeacon, &val) || val<20 || val>1024) {
			strcpy(tmpBuf, T("Error! Invalid value of Beacon Interval."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_BEACON_INTERVAL, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set Beacon interval failed!"));
			goto setErr_advance;
		}
	}

	strTx = websGetVar(wp, T("wlanSetTx"), T(""));
	if (strTx[0]) {
		if ( !string_to_dec(strTx, &val) || val<0 || val>66) {
			strcpy(tmpBuf, T("Error! Invalid value of TX power."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_SET_TX, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set TX power failed!"));
			goto setErr_advance;
		}
	}

	// set tx rate
	strRate = websGetVar(wp, T("txRate"), T(""));
	if ( strRate[0] ) {
		if ( strRate[0] == '0' ) { // auto
			val = 1;
			if ( apmib_set(MIB_WLAN_RATE_ADAPTIVE_ENABLED, (void *)&val) == 0) {
				strcpy(tmpBuf, T("Set rate adaptive failed!"));
				goto setErr_advance;
			}
		}
		else  {
			val = 0;
			if ( apmib_set(MIB_WLAN_RATE_ADAPTIVE_ENABLED, (void *)&val) == 0) {
				strcpy(tmpBuf, T("Set rate adaptive failed!"));
				goto setErr_advance;
			}

			if (strRate[0] == '1' )  // 11M
				val = TX_RATE_11M;
			else if (strRate[0] == '2' ) // 5.5M
				val = TX_RATE_5M;
			else if (strRate[0] == '3' ) // 2M
				val = TX_RATE_2M;
			else if (strRate[0] == '4' ) // 1M
				val = TX_RATE_1M;
			else {
				strcpy(tmpBuf, T("invalud value of tx rate!"));
				goto setErr_advance;
			}
			if ( apmib_set(MIB_WLAN_SUPPORTED_RATE, (void *)&val) == 0) {
				strcpy(tmpBuf, T("Set Tx operation rate failed!"));
				goto setErr_advance;
			}
			if ( apmib_set(MIB_WLAN_BASIC_RATE, (void *)&val) == 0) {
				strcpy(tmpBuf, T("Set Tx basic rate failed!"));
				goto setErr_advance;
			}
		}
	}
	else { // set rate in operate, basic sperately
		val = 0;
		// disable rate adaptive
		if ( apmib_set(MIB_WLAN_RATE_ADAPTIVE_ENABLED, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set rate adaptive failed!"));
			goto setErr_advance;
			}

		strRate = websGetVar(wp, T("operRate1M"), T(""));
		if ( !gstrcmp(strRate, T("1M")))
			val |= TX_RATE_1M;
		strRate = websGetVar(wp, T("operRate2M"), T(""));
		if ( !gstrcmp(strRate, T("2M")))
			val |= TX_RATE_2M;
		strRate = websGetVar(wp, T("operRate5M"), T(""));
		if ( !gstrcmp(strRate, T("5M")))
			val |= TX_RATE_5M;
		strRate = websGetVar(wp, T("operRate11M"), T(""));
		if ( !gstrcmp(strRate, T("11M")))
			val |= TX_RATE_11M;
		if ( apmib_set(MIB_WLAN_SUPPORTED_RATE, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set Tx operation rate failed!"));
			goto setErr_advance;
		}

		// set basic tx rate
		val = 0;
		strRate = websGetVar(wp, T("basicRate1M"), T(""));
		if ( !gstrcmp(strRate, T("1M")))
			val |= TX_RATE_1M;
		strRate = websGetVar(wp, T("basicRate2M"), T(""));
		if ( !gstrcmp(strRate, T("2M")))
			val |= TX_RATE_2M;
		strRate = websGetVar(wp, T("basicRate5M"), T(""));
		if ( !gstrcmp(strRate, T("5M")))
			val |= TX_RATE_5M;
		strRate = websGetVar(wp, T("basicRate11M"), T(""));
		if ( !gstrcmp(strRate, T("11M")))
			val |= TX_RATE_11M;
		if ( apmib_set(MIB_WLAN_BASIC_RATE, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set Tx basic rate failed!"));
			goto setErr_advance;
		}
	}

	// set preamble
	strPreamble = websGetVar(wp, T("preamble"), T(""));
	if (strPreamble[0]) {
		if (!gstrcmp(strPreamble, T("long")))
			preamble = LONG_PREAMBLE;
		else if (!gstrcmp(strPreamble, T("short")))
			preamble = SHORT_PREAMBLE;
		else {
			strcpy(tmpBuf, T("Error! Invalid Preamble value."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_PREAMBLE_TYPE, (void *)&preamble) == 0) {
			strcpy(tmpBuf, T("Set Preamble failed!"));
			goto setErr_advance;
		}
	}

	// set hidden SSID
	strHiddenSSID = websGetVar(wp, T("hiddenSSID"), T(""));
	if (strHiddenSSID[0]) {
		if (!gstrcmp(strHiddenSSID, T("no")))
			val = 0;
		else if (!gstrcmp(strHiddenSSID, T("yes")))
			val = 1;
		else {
			strcpy(tmpBuf, T("Error! Invalid hiddenSSID value."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_HIDDEN_SSID, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set hidden ssid failed!"));
			goto setErr_advance;
		}
	}

	strDtim = websGetVar(wp, T("dtimPeriod"), T(""));
	if (strDtim[0]) {
		if ( !string_to_dec(strDtim, &val) || val<1 || val>255) {
			strcpy(tmpBuf, T("Error! Invalid value of DTIM period."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_DTIM_PERIOD, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set DTIM period failed!"));
			goto setErr_advance;
		}
	}
	strIapp = websGetVar(wp, T("iapp"), T(""));
	if (strIapp[0]) {
		if (!gstrcmp(strIapp, T("no")))
			val = 1;
		else if (!gstrcmp(strIapp, T("yes")))
			val = 0;
		else {
			strcpy(tmpBuf, T("Error! Invalid IAPP value."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_IAPP_DISABLED, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set MIB_WLAN_IAPP_DISABLED failed!"));
			goto setErr_advance;
		}
	}

//******************************wireless setting for inprocomm ******************************	
#if defined(_6104IPC_) | defined(_7207APS_)
	strTranRate = websGetVar(wp, T("wlanTranRate"), T(""));
//	printf("\nstrTranRate=%s\n",strTranRate);
	if ( strTranRate[0] ) {
		if ( apmib_set(MIB_WLAN_TRAN_RATE, (void *)strTranRate) == 0) {
			strcpy(tmpBuf, T("Set Transmit Rate MIB error!"));
			goto setErr_advance;
		}
	}
	// set Basic Rates Mode
	strRateMode = websGetVar(wp, T("wlanRateMode"), T(""));
//	printf("\nstrRateMode=%s\n",strRateMode);
	if (strRateMode[0]) {
		if (!gstrcmp(strRateMode, T("mixed")))
			val = 0;
		else if (!gstrcmp(strRateMode, T("g_only")))
			val = 1;
		else {
			strcpy(tmpBuf, T("Error! Invalid value of Basic Rates Mode."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_RATE_MODE, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set Basic Rates Mode failed!"));
			goto setErr_advance;
		}
	}
	// set CTS Protection
	strCts = websGetVar(wp, T("wlanCts"), T(""));
//	printf("\nstrCts=%s\n",strCts);
	if (strCts[0]) {
		if (!gstrcmp(strCts, T("auto")))
			val = 0;
		else if (!gstrcmp(strCts, T("always")))
			val = 1;
		else if (!gstrcmp(strCts, T("none")))
			val = 2;
		else {
			strcpy(tmpBuf, T("Error! Invalid value of CTS Protection."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_CTS, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set CTS Protection failed!"));
			goto setErr_advance;
		}
	}
	// set Transmit Burst Mode
	strBurst = websGetVar(wp, T("wlanBurst"), T(""));
//	printf("\nstrBurst=%s\n",strBurst);
	if (strBurst[0]) {
		if (!gstrcmp(strBurst, T("no")))
			val = 0;
		else if (!gstrcmp(strBurst, T("yes")))
			val = 1;
		else {
			strcpy(tmpBuf, T("Error! Invalid value of Transmit Burst Mode."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_BURST, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set Transmit Burst Mode failed!"));
			goto setErr_advance;
		}
	}	
	// set Network Authentication
	strAuth = websGetVar(wp, T("netAuth"), T(""));
//	printf("\nstrAuth=%s\n",strAuth);
	if (strAuth[0]) {
		if ( !string_to_dec(strAuth, &val) || val<0 || val>5) {
			strcpy(tmpBuf, T("Error! Invalid value of Network Authentication."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_AUTH_TYPE, (void *)&val) == 0) {
			strcpy(tmpBuf, T("Set Network Authentication failed!"));
			goto setErr_advance;
		}
	}
#endif


	PROC_MSG();
	apmib_update(CURRENT_SETTING);

#ifndef NO_ACTION
	// run script file to update WLAN parameters
	#ifdef HOME_GATEWAY
		sprintf(tmpBuf, "%s/%s %s %s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG, "gw", "bridge");
		system(tmpBuf);
	#else
		sprintf(tmpBuf, "%s/%s %s %s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG, "ap", "bridge");
		system(tmpBuf);
	#endif
#endif

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page

//	websRedirect(wp, submitUrl);
	OK_MSG(submitUrl);
  	return;

setErr_advance:
	ERR_MSG(tmpBuf);
}

/////////////////////////////////////////////////////////////////////////////
#if defined(_6104IPC_) | defined(_7207APS_)
int wirelessClientList(int eid, webs_t wp, int argc, char_t **argv)
{
	int nBytesSent=0, i, found=0;
	WLAN_IPN_STA_Tp pInfo;
	char *buff,temp[10];
	FILE *fp;
	unsigned long txPack[MAX_STA_NUM], rxPack[MAX_STA_NUM];

	system("/bin/staclient.sh");
	if ((fp = fopen("/etc/txStaFile.tmp","r"))!=NULL) {
		for (i=0; i<MAX_STA_NUM; i++ ) {
			if (fgets(temp, 30, fp)!=NULL) 
				txPack[i] = atoi(temp);
			else
				break;
		}
		fclose(fp);
		system("rm -f /etc/txStaFile.tmp");
	}

	if ((fp = fopen("/etc/rxStaFile.tmp","r"))!=NULL) {
		for (i=0; i<MAX_STA_NUM; i++ ) {
			if (fgets(temp, 30, fp)!=NULL)
				rxPack[i] = atoi(temp);
			else
				break;
		}
		fclose(fp);
		system("rm -f /etc/rxStaFile.tmp");
	}

	buff = calloc(1, sizeof(WLAN_IPN_STA_T) * (MAX_STA_NUM+1));
	if ( buff == 0 ) {
		printf("Allocate buffer failed!\n");
		return 0;
	}

	if ( getInprocommWlSta(WLAN_IF,  (WLAN_IPN_STA_Tp)buff ) < 0 ) {
		printf("Read wlan sta info failed!\n");
		return 0;
	}

	for (i=0; i<=MAX_STA_NUM; i++) {
		pInfo = (WLAN_IPN_STA_Tp)&buff[i*sizeof(WLAN_IPN_STA_T)];
		if (pInfo->aid) {
			nBytesSent += websWrite(wp,
	   		T("<tr bgcolor=#b7b7b7><td align='center'><font size=2>%02x:%02x:%02x:%02x:%02x:%02x</td>"
//			"<td><font size=2>%lu</td>"
//	     		"<td><font size=2>%lu</td>"
//			"<td><font size=2></td>"
			"<td align='center'><font size=2>%s</td>"),
//			"<td><font size=2>%hu</td></tr>"),
			pInfo->addr[0],pInfo->addr[1],pInfo->addr[2],pInfo->addr[3],pInfo->addr[4],pInfo->addr[5],
//			txPack[i+1], rxPack[i+1],
//			pInfo->txOperaRates/2, ((pInfo->txOperaRates%2) ? ".5" : "" ),
			( (pInfo->ps_state) ? "yes" : "no"));
//			pInfo->assoc_time );
			found++;
		}
	}
	if (found == 0) {
		nBytesSent += websWrite(wp,
	   		T("<tr bgcolor=#b7b7b7><td align='center'><font size=2>None</td>"
//			"<td><font size=2>---</td>"
//	     		"<td><font size=2>---</td>"
//			"<td><font size=2>---</td>"
//			"<td><font size=2>---</td>"
			"<td align='center'><font size=2 >---</td></tr>"));
	}

	free(buff);

	return nBytesSent;
}

#else
/////////////////////////////////////////////////////////////////////////////
int wirelessClientList(int eid, webs_t wp, int argc, char_t **argv)
{
	int nBytesSent=0, i, found=0;
	WLAN_STA_INFO_Tp pInfo;
	char *buff;

	buff = calloc(1, sizeof(WLAN_STA_INFO_T) * (MAX_STA_NUM+1));
	if ( buff == 0 ) {
		printf("Allocate buffer failed!\n");
		return 0;
	}

	if ( getWlStaInfo(WLAN_IF,  (WLAN_STA_INFO_Tp)buff ) < 0 ) {
		printf("Read wlan sta info failed!\n");
		return 0;
	}

	for (i=1; i<=MAX_STA_NUM; i++) {
		pInfo = (WLAN_STA_INFO_Tp)&buff[i*sizeof(WLAN_STA_INFO_T)];
		if (pInfo->aid && (pInfo->flag & STA_INFO_FLAG_ASOC)) {
			nBytesSent += websWrite(wp,
	   		T("<tr bgcolor=#b7b7b7><td><font size=2>%02x:%02x:%02x:%02x:%02x:%02x</td>"
			"<td><font size=2>%d</td>"
	     		"<td><font size=2>%d</td>"
			"<td><font size=2>%d%s</td>"
			"<td><font size=2>%s</td>"
			"<td><font size=2>%d</td></tr>"),
			pInfo->addr[0],pInfo->addr[1],pInfo->addr[2],pInfo->addr[3],pInfo->addr[4],pInfo->addr[5],
			pInfo->tx_packets, pInfo->rx_packets,
			pInfo->txOperaRates/2, ((pInfo->txOperaRates%2) ? ".5" : "" ),
			( (pInfo->flag & STA_INFO_FLAG_ASLEEP) ? "yes" : "no"),
			pInfo->expired_time/100 );
			found++;
		}
	}
	if (found == 0) {
		nBytesSent += websWrite(wp,
	   		T("<tr bgcolor=#b7b7b7><td><font size=2>None</td>"
			"<td><font size=2>---</td>"
	     		"<td><font size=2>---</td>"
			"<td><font size=2>---</td>"
			"<td><font size=2>---</td>"
			"<td><font size=2>---</td></tr>"));
	}

	free(buff);

	return nBytesSent;
}
#endif
/////////////////////////////////////////////////////////////////////////////
void formWirelessTbl(webs_t wp, char_t *path, char_t *query)
{
	char_t *submitUrl;

	submitUrl = websGetVar(wp, T("submit-url"), T(""));
	if (submitUrl[0])
		websRedirect(wp, submitUrl);
}


/////////////////////////////////////////////////////////////////////////////
void formWlSiteSurvey(webs_t wp, char_t *path, char_t *query)
{
 	char_t *submitUrl, *refresh, *connect, *strSel;
	int status, idx;
	unsigned char res, *pMsg=NULL;
	int wait_time;
	char tmpBuf[100];

	submitUrl = websGetVar(wp, T("submit-url"), T(""));

	refresh = websGetVar(wp, T("refresh"), T(""));
	if ( refresh[0] ) {
		// issue scan request
		wait_time = 0;
		while (1) {
			if ( getWlSiteSurveyRequest(WLAN_IF,  &status) < 0 ) {
				strcpy(tmpBuf, T("Site-survey request failed!"));
				goto ss_err;
			}
			if (status != 0) {	// not ready
				if (wait_time++ > 5) {
					strcpy(tmpBuf, T("scan request timeout!"));
					goto ss_err;
				}
				sleep(1);
			}
			else
				break;
		}

		// wait until scan completely
		wait_time = 0;
		while (1) {
			res = 1;	// only request request status
			if ( getWlSiteSurveyResult(WLAN_IF, (SS_STATUS_Tp)&res) < 0 ) {
				strcpy(tmpBuf, T("Read site-survey status failed!"));
				free(pStatus);
				pStatus = NULL;
				goto ss_err;
			}
			if (res == 0xff) {   // in progress
				if (wait_time++ > 10) {
					strcpy(tmpBuf, T("scan timeout!"));
					free(pStatus);
					pStatus = NULL;
					goto ss_err;
				}
				sleep(1);
			}
			else
				break;
		}

		if (submitUrl[0])
			websRedirect(wp, submitUrl);

		return;
	}

	connect = websGetVar(wp, T("connect"), T(""));
	if ( connect[0] ) {
		strSel = websGetVar(wp, T("select"), T(""));
		if (strSel[0]) {
			unsigned char res;
			NETWORK_TYPE_T net;
			int chan;

			if (pStatus == NULL) {
				strcpy(tmpBuf, T("Please refresh again!"));
				goto ss_err;

			}
			sscanf(strSel, "sel%d", &idx);
			if ( idx >= pStatus->number ) { // invalid index
				strcpy(tmpBuf, T("Connect failed!"));
				goto ss_err;
			}
			
			// Set SSID, network type to MIB
			memcpy(tmpBuf, pStatus->bssdb[idx].bdSsIdBuf, pStatus->bssdb[idx].bdSsId.Length);
			tmpBuf[pStatus->bssdb[idx].bdSsId.Length] = '\0';
			if ( apmib_set(MIB_WLAN_SSID, (void *)tmpBuf) == 0) {
				strcpy(tmpBuf, T("Set SSID error!"));
				goto ss_err;
			}

			if ( pStatus->bssdb[idx].bdCap & cESS )
				net = INFRASTRUCTURE;
			else
				net = ADHOC;
			
			if ( apmib_set(MIB_WLAN_NETWORK_TYPE, (void *)&net) == 0) {
				strcpy(tmpBuf, T("Set MIB_WLAN_NETWORK_TYPE failed!"));
				goto ss_err;
			}
			
			// ADD Erwin 
			if (net == INFRASTRUCTURE) {
				int netVal = 2;
				if ( apmib_set(MIB_AP_MODE, (void *)&netVal) == 0) {
					strcpy(tmpBuf, T("Set MIB_AP_MODE failed!"));
					goto ss_err;
				}
			}else if (net == ADHOC) {
				int netVal = 1;
				if ( apmib_set(MIB_AP_MODE, (void *)&netVal) == 0) {
					strcpy(tmpBuf, T("Set MIB_AP_MODE failed!"));
					goto ss_err;
				}
			}
			
			if (net == ADHOC) {
				chan = pStatus->bssdb[idx].ChannelNumber;
				if ( apmib_set( MIB_WLAN_CHAN_NUM, (void *)&chan) == 0) {
   					strcpy(tmpBuf, T("Set channel number error!"));
					goto ss_err;
				}
			}

			apmib_update(CURRENT_SETTING);

			res = idx;
			wait_time = 0;
			while (1) {
				if ( getWlJoinRequest(WLAN_IF, &pStatus->bssdb[idx], &res) < 0 ) {
					strcpy(tmpBuf, T("Join request failed!"));
					goto ss_err;
				}
				if ( res == 1 ) { // wait
					if (wait_time++ > 5) {
						strcpy(tmpBuf, T("connect-request timeout!"));
						goto ss_err;
					}
					sleep(1);
					continue;
				}
				break;
			}


			if ( res == 2 ) // invalid index
				pMsg = "Connect failed!";
			else {
				wait_time = 0;
				while (1) {
					if ( getWlJoinResult(WLAN_IF, &res) < 0 ) {
						strcpy(tmpBuf, T("Get Join result failed!"));
						goto ss_err;
					}
					if ( res != 0xff ) { // completed
						if (wait_time++ > 10) {
							strcpy(tmpBuf, T("connect timeout!"));
							goto ss_err;
						}
						break;
					}
					sleep(1);
				}

				if ( res!=STATE_Bss && res!=STATE_Ibss_Idle && res!=STATE_Ibss_Active )
					pMsg = "Connect failed!";
				else
					pMsg = "Connect successfully!";
			}
			OK_MSG1(pMsg, submitUrl);
		}
	}
	return;

ss_err:
	ERR_MSG(tmpBuf);
}

/////////////////////////////////////////////////////////////////////////////
int wlSiteSurveyTbl(int eid, webs_t wp, int argc, char_t **argv)
{
	int nBytesSent=0, i;
	BssDscr *pBss;
	char tmpBuf[100], ssidbuf[40];
	WLAN_MODE_T mode;
	bss_info bss;
	if (pStatus==NULL) {
		pStatus = calloc(1, sizeof(SS_STATUS_T));
		if ( pStatus == NULL ) {
			printf("Allocate buffer failed!\n");
			return 0;
		}
	}

	pStatus->number = 0; // request BSS DB

	if ( getWlSiteSurveyResult(WLAN_IF, pStatus) < 0 ) {
		ERR_MSG("Read site-survey status failed!");
		free(pStatus);
		pStatus = NULL;
		return 0;
	}

	if ( !apmib_get( MIB_WLAN_MODE, (void *)&mode) ) {
		printf("Get MIB_WLAN_MODE MIB failed!");
		return 0;
	}

	if ( getWlBssInfo(WLAN_IF, &bss) < 0) {
		printf("Get bssinfo failed!");
		return 0;
	}

/*	nBytesSent += websWrite(wp, T("<tr>"
	"<td align=center width=\"30%%\" class=\"stable\"><font size=\"2\"><b>SSID</b></font></td>\n"
	"<td align=center width=\"20%%\" class=\"stable\"><font size=\"2\"><b>BSSID</b></font></td>\n"
	"<td align=center width=\"10%%\" class=\"stable\"><font size=\"2\"><b>Channel</b></font></td>\n"
      	"<td align=center width=\"10%%\" class=\"stable\"><font size=\"2\"><b>Type</b></font></td>\n"
      	"<td align=center width=\"10%%\" class=\"stable\"><font size=\"2\"><b>Encrypt</b></font></td>\n"
	"<td align=center width=\"10%%\" class=\"stable\"><font size=\"2\"><b>Signal</b></font></td>\n"));
	if ( mode == CLIENT_MODE )
		nBytesSent += websWrite(wp, T("<td align=center width=\"10%%\" class=\"stable\"><font size=\"2\"><b>Select</b></font></td></tr>\n"));
	else
		nBytesSent += websWrite(wp, T("</tr>\n"));
*/

	for (i=0; i<pStatus->number && pStatus->number!=0xff; i++) {
		pBss = &pStatus->bssdb[i];
		snprintf(tmpBuf, 200, T("%02x:%02x:%02x:%02x:%02x:%02x"),
			pBss->bdBssId[0], pBss->bdBssId[1], pBss->bdBssId[2],
			pBss->bdBssId[3], pBss->bdBssId[4], pBss->bdBssId[5]);

		memcpy(ssidbuf, pBss->bdSsIdBuf, pBss->bdSsId.Length);
		ssidbuf[pBss->bdSsId.Length] = '\0';

		nBytesSent += websWrite(wp, T("<tr>"
			"<td align=left width=\"20%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
			"<td align=center width=\"20%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
      			"<td align=center width=\"10%%\" class=\"table2\"><font size=\"2\">%d</td>\n"
      			"<td align=center width=\"10%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
			"<td align=center width=\"10%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
			"<td align=center width=\"10%%\" class=\"table2\"><font size=\"2\">%d</td>\n"),
			ssidbuf, tmpBuf, pBss->ChannelNumber,
			((pBss->bdCap & cIBSS) ? "Ad hoc" : "AP"),
			((pBss->bdCap & cPrivacy) ? "yes" : "no"), pBss->rssi);

		if ( mode == CLIENT_MODE )
			nBytesSent += websWrite(wp,
			T("<td align=center width=\"10%%\" class=\"table2\"><input type=\"radio\" name="
			"\"select\" value=\"sel%d\" onClick=\"enableConnect()\"></td></tr>\n"), i);
		else
			nBytesSent += websWrite(wp, T("</tr>\n"));
	}

	return nBytesSent;
}

/////////////////////////////////////////////////////////////////////////////
#ifndef HOME_GATEWAY	// Radius server
void formRadius(webs_t wp, char_t *path, char_t *query)
{
	char_t *strUsrName, *strUsrPass, *strAddUsr, *strDelUsr, *strDelAllUsr;
	char_t *strCltIp, *strCltPass, *strAddClt, *strDelClt, *strDelAllClt;
	char_t *strVal, *submitUrl;
//	char_t *strFrom, *strTo;
	char tmpBuf[100];
	int entryNum, intVal, i;
	RSER_CLT_T cltEntry;	// for radius server client
	RSER_USR_T usrEntry;	// for radius server user
//	struct in_addr curIpAddr, curSubnet;
	void *pEntry;
	int num_id, get_id, add_id, del_id, delall_id, enable_id;
	
	strAddUsr = websGetVar(wp, T("addRSerUsr"), T(""));
	strDelUsr = websGetVar(wp, T("delSelRSerUsr"), T(""));
	strDelAllUsr = websGetVar(wp, T("delAllRSerUsr"), T(""));
	
	strAddClt = websGetVar(wp, T("addRSerClt"), T(""));
	strDelClt = websGetVar(wp, T("delSelRSerClt"), T(""));
	strDelAllClt = websGetVar(wp, T("delAllRSerClt"), T(""));
	
	if (strAddUsr[0] || strDelUsr[0] || strDelAllUsr[0]) {
		num_id = MIB_RSER_USR_NUM;
		get_id = MIB_RSER_USR;
		add_id = MIB_RSER_USR_ADD;
		del_id = MIB_RSER_USR_DEL;
		delall_id = MIB_RSER_USR_DELALL;
		enable_id = MIB_RSER_ENABLED;
		memset(&usrEntry, '\0', sizeof(usrEntry));
		pEntry = (void *)&usrEntry;
	}
	else {
		num_id = MIB_RSER_CLT_NUM;
		get_id = MIB_RSER_CLT;
		add_id = MIB_RSER_CLT_ADD;
		del_id = MIB_RSER_CLT_DEL;
		delall_id = MIB_RSER_CLT_DELALL;
		enable_id = MIB_RSER_ENABLED;
		memset(&cltEntry, '\0', sizeof(cltEntry));
		pEntry = (void *)&cltEntry;
	}

	// Set enable flag
	if (strAddUsr[0]) {
		strVal = websGetVar(wp, T("enabled"), T(""));
		if ( !gstrcmp(strVal, T("ON")))
			intVal = 1;
		else
			intVal = 0;

		if ( apmib_set(enable_id, (void *)&intVal) == 0) {
			strcpy(tmpBuf, T("Set enabled flag error!"));
			goto setErr_radius;
		}
	}
//*********************************** Add Radius usr ***********************************
	if (strAddUsr[0]) {
		strUsrName = websGetVar(wp, T("rserUsrName"), T(""));
		strUsrPass = websGetVar(wp, T("rserUsrPass"), T(""));

		if (!strUsrName[0] && !strUsrPass[0])
			goto setOk_radius;
		
		if (!strUsrName[0] || !strUsrPass[0]) {
			strcpy(tmpBuf, T("Error! input argument is not enough"));
			goto setErr_radius;
		}
		
		if ( strUsrName[0] ) {
			if (strlen(strUsrName) > 32) {
				strcpy(tmpBuf, T("Error! UserName length too long."));
				goto setErr_radius;
			}
			else 
				strcpy(usrEntry.username, strUsrName);
		}
		
		if ( strUsrPass[0] ) {
			if (strlen(strUsrPass) > 16) {
				strcpy(tmpBuf, T("Error! Password length too long."));
				goto setErr_radius;
			}
			else 
				strcpy(usrEntry.password, strUsrPass);
		}
	}

//*********************************** Add Radius client ***********************************
	if (strAddClt[0]) {
		strCltIp = websGetVar(wp, T("rserCltIp"), T(""));
		strCltPass = websGetVar(wp, T("rserCltPass"), T(""));

		if (!strCltIp[0] && !strCltPass[0])
			goto setOk_radius;
		
		if (!strCltIp[0] || !strCltPass[0]) {
			strcpy(tmpBuf, T("Error! input argument is not enough"));
			goto setErr_radius;
		}
		
		inet_aton(strCltIp, (struct in_addr *)&cltEntry.ipAddr);
		
		if ( strCltPass[0] ) {
			if (strlen(strCltPass) > 16) {
				strcpy(tmpBuf, T("Error! Password length too long."));
				goto setErr_radius;
			}
			else 
				strcpy(cltEntry.password, strCltPass);
		}
	}

	if (strAddUsr[0] || strAddClt[0]) {
	
		if ( !apmib_get(num_id, (void *)&entryNum)) {
			strcpy(tmpBuf, T("Get entry number error!"));
			goto setErr_radius;
		}
		if (strAddUsr[0]) {
			if ( (entryNum + 1) > 96) {
				strcpy(tmpBuf, T("Cannot add new entry because table is full!"));
				goto setErr_radius;
			}
		}
		if (strAddClt[0]) {
			if ( (entryNum + 1) > 16) {
				strcpy(tmpBuf, T("Cannot add new entry because table is full!"));
				goto setErr_radius;
			}
		}
		// set to MIB. try to delete it first to avoid duplicate case
		apmib_set(del_id, pEntry);
		if ( apmib_set(add_id, pEntry) == 0) {
			strcpy(tmpBuf, T("Add table entry error!"));
			goto setErr_radius;
		}
	}

	// Delete entry 
	if (strDelUsr[0] || strDelClt[0]) {
		if ( !apmib_get(num_id, (void *)&entryNum)) {
			strcpy(tmpBuf, T("Get entry number error!"));
			goto setErr_radius;
		}
		for (i=entryNum; i>0; i--) {
			snprintf(tmpBuf, 20, "select%d", i);

			strVal = websGetVar(wp, tmpBuf, T(""));
			if ( !gstrcmp(strVal, T("ON")) ) {

				*((char *)pEntry) = (char)i;
				if ( !apmib_get(get_id, pEntry)) {
					strcpy(tmpBuf, T("Get table entry error!"));
					goto setErr_radius;
				}
				if ( !apmib_set(del_id, pEntry)) {
					strcpy(tmpBuf, T("Delete table entry error!"));
					goto setErr_radius;
				}
			}
		}
	}

	// Delete all entry 
	if (strDelAllUsr[0] || strDelAllClt[0]) {
		if ( !apmib_set(delall_id, pEntry)) {
			strcpy(tmpBuf, T("Delete all table error!"));
			goto setErr_radius;
		}
	}
	PROC_MSG();
setOk_radius:
	apmib_update(CURRENT_SETTING);

#ifndef NO_ACTION
//	sprintf(tmpBuf, "%s/%s %s %s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG, "ap", "all");        
	system("/bin/Radiusd.sh stop");
	system("/bin/Radiusd.sh start&");
#endif

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
	if (submitUrl[0])
		websRedirect(wp, submitUrl);
	else
		websDone(wp, 200);
  	return;
setErr_radius:
	ERR_MSG(tmpBuf);
  	return;
}
/////////////////////////////////////////////////////////////////////////////
int RadiusCltList(int eid, webs_t wp, int argc, char_t **argv)
{
	int	nBytesSent=0, entryNum, i;
	RSER_CLT_T entry;
	char	*ip;

	if ( !apmib_get(MIB_RSER_CLT_NUM, (void *)&entryNum)) {
  		websError(wp, 400, T("Get table entry error!\n"));
		return -1;
	}
	for (i=1; i<=entryNum; i++) {
		*((char *)&entry) = (char)i;
		if ( !apmib_get(MIB_RSER_CLT, (void *)&entry))
			return -1;

		ip = inet_ntoa(*((struct in_addr *)entry.ipAddr));
			
		nBytesSent += websWrite(wp, T("<tr>"
		"<td align=center width=\"80%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
   		"<td align=center width=\"20%%\" class=\"table2\"><input type=\"checkbox\" name=\"select%d\" value=\"ON\"></td></tr>\n"),
				ip, i);
	}
	return nBytesSent;
}
/////////////////////////////////////////////////////////////////////////////
int RadiusUsrList(int eid, webs_t wp, int argc, char_t **argv)
{
	int	nBytesSent=0, entryNum, i;
	RSER_USR_T entry;
//	char	*type, *ip, portFrom[20], portTo[20];

	if ( !apmib_get(MIB_RSER_USR_NUM, (void *)&entryNum)) {
  		websError(wp, 400, T("Get table entry error!\n"));
		return -1;
	}
	for (i=1; i<=entryNum; i++) {
		*((char *)&entry) = (char)i;
		if ( !apmib_get(MIB_RSER_USR, (void *)&entry))
			return -1;
			
		nBytesSent += websWrite(wp, T("<tr>"
		"<td align=center width=\"80%%\" class=\"table2\"><font size=\"2\">%s</td>\n"
   		"<td align=center width=\"20%%\" class=\"table2\"><input type=\"checkbox\" name=\"select%d\" value=\"ON\"></td></tr>\n"),
				entry.username, i);
	}
	return nBytesSent;
}
#endif
/////////////////////////////////////////////////////////////////////////////
void formWdsWep(webs_t wp, char_t *path, char_t *query)
{
   	char_t *submitUrl, *wepKey;
   	char_t *strKeyLen, *strFormat, *strKeyId, *strEnabled;
	char tmpBuf[100], key[30];
	int enabled, keyLen, ret, i;

	WEP_T wep;

	strEnabled = websGetVar(wp, T("wepEnabled"), T(""));
	if ( !gstrcmp(strEnabled, T("ON")))
		enabled = 1;
	else
		enabled = 0;

	if ( enabled ) {
		strKeyLen = websGetVar(wp, T("length"), T(""));
		if (!strKeyLen[0]) {
 			strcpy(tmpBuf, T("Key length must exist!"));
			goto setErr_wdsWep;
		}
		if (strKeyLen[0]!='1' && strKeyLen[0]!='2') {
 			strcpy(tmpBuf, T("Invalid key length value!"));
			goto setErr_wdsWep;
		}
		if (strKeyLen[0] == '1')
			wep = WEP64;
		else
			wep = WEP128;
	}
	else
		wep = WEP_DISABLED;

	if ( apmib_set( MIB_WLAN_WDS_WEP, (void *)&wep) == 0) {
  		strcpy(tmpBuf, T("Set WEP MIB error!"));
		goto setErr_wdsWep;
	}

	if (wep == WEP_DISABLED)
		goto setWdsWep_ret;

	strFormat = websGetVar(wp, T("format"), T(""));
	if (!strFormat[0]) {
 		strcpy(tmpBuf, T("Key type must exist!"));
		goto setErr_wdsWep;
	}

	if (strFormat[0]!='1' && strFormat[0]!='2') {
		strcpy(tmpBuf, T("Invalid key type value!"));
		goto setErr_wdsWep;
	}

	i = strFormat[0] - '0' - 1;
	if ( apmib_set( MIB_WLAN_WDS_WEP_KEY_TYPE, (void *)&i) == 0) {
  		strcpy(tmpBuf, T("Set WEP key type error!"));
		goto setErr_wdsWep;
	}

	if (wep == WEP64) {
		if (strFormat[0]=='1')
			keyLen = WEP64_KEY_LEN;
		else
			keyLen = WEP64_KEY_LEN*2;
	}
	else {
		if (strFormat[0]=='1')
			keyLen = WEP128_KEY_LEN;
		else
			keyLen = WEP128_KEY_LEN*2;
	}

	strKeyId = websGetVar(wp, T("defaultTxKeyId"), T(""));
	if ( strKeyId[0] ) {
		if ( strKeyId[0]!='1' && strKeyId[0]!='2' && strKeyId[0]!='3' && strKeyId[0]!='4' ) {
	 		strcpy(tmpBuf, T("Invalid default tx key id!"));
   			goto setErr_wdsWep;
		}
		i = strKeyId[0] - '0' - 1;
		if ( !apmib_set( MIB_WLAN_WDS_WEP_DEFAULT_KEY, (void *)&i ) ) {
	 		strcpy(tmpBuf, T("Set default tx key id error!"));
   			goto setErr_wdsWep;
		}
	}
				
	wepKey = websGetVar(wp, T("key1"), T(""));
	if  (wepKey[0]) {
		if (strlen(wepKey) != keyLen) {
			strcpy(tmpBuf, T("Invalid key 1 length!"));
			goto setErr_wdsWep;
		}
		if ( !isAllStar(wepKey) ) {
			if (strFormat[0] == '1') // ascii
				strcpy(key, wepKey);
			else { // hex
				if ( !string_to_hex(wepKey, key, keyLen)) {
	   				strcpy(tmpBuf, T("Invalid wep-key1 value!"));
					goto setErr_wdsWep;
				}
			}
			if (wep == WEP64)
				ret=apmib_set(MIB_WLAN_WDS_WEP64_KEY1, (void *)key);
			else
				ret=apmib_set(MIB_WLAN_WDS_WEP128_KEY1, (void *)key);
			if (!ret) {
	 			strcpy(tmpBuf, T("Set wep-key1 error!"));
				goto setErr_wdsWep;
			}
		}
	}
	wepKey = websGetVar(wp, T("key2"), T(""));
	if  (wepKey[0]) {
		if (strlen(wepKey) != keyLen) {
			strcpy(tmpBuf, T("Invalid key 2 length!"));
			goto setErr_wdsWep;
		}
		if ( !isAllStar(wepKey) ) {
			if (strFormat[0] == '1') // ascii
				strcpy(key, wepKey);
			else { // hex
				if ( !string_to_hex(wepKey, key, keyLen)) {
	   				strcpy(tmpBuf, T("Invalid wep-key2 value!"));
   					goto setErr_wdsWep;
				}
			}
			if (wep == WEP64)
				ret=apmib_set(MIB_WLAN_WDS_WEP64_KEY2, (void *)key);
			else
				ret=apmib_set(MIB_WLAN_WDS_WEP128_KEY2, (void *)key);
			if (!ret) {
	 			strcpy(tmpBuf, T("Set wep-key2 error!"));
				goto setErr_wdsWep;
			}
		}
	}

	wepKey = websGetVar(wp, T("key3"), T(""));
	if  (wepKey[0]) {
		if (strlen(wepKey) != keyLen) {
			strcpy(tmpBuf, T("Invalid key 3 length!"));
			goto setErr_wdsWep;
		}
		if ( !isAllStar(wepKey) ) {
			if (strFormat[0] == '1') // ascii
				strcpy(key, wepKey);
			else { // hex
				if ( !string_to_hex(wepKey, key, keyLen)) {
	   				strcpy(tmpBuf, T("Invalid wep-key3 value!"));
   					goto setErr_wdsWep;
				}
			}
			if (wep == WEP64)
				ret=apmib_set(MIB_WLAN_WDS_WEP64_KEY3, (void *)key);
			else
				ret=apmib_set(MIB_WLAN_WDS_WEP128_KEY3, (void *)key);
			if (!ret) {
	 			strcpy(tmpBuf, T("Set wep-key3 error!"));
				goto setErr_wdsWep;
			}
		}
	}

	wepKey = websGetVar(wp, T("key4"), T(""));
	if  (wepKey[0]) {
		if (strlen(wepKey) != keyLen) {
			strcpy(tmpBuf, T("Invalid key 1 length!"));
			goto setErr_wdsWep;
		}
		if ( !isAllStar(wepKey) ) {
			if (strFormat[0] == '1') // ascii
				strcpy(key, wepKey);
			else { // hex
				if ( !string_to_hex(wepKey, key, keyLen)) {
	   				strcpy(tmpBuf, T("Invalid wep-key4 value!"));
   					goto setErr_wdsWep;
				}
			}
			if (wep == WEP64)
				ret=apmib_set(MIB_WLAN_WDS_WEP64_KEY4, (void *)key);
			else
				ret=apmib_set(MIB_WLAN_WDS_WEP128_KEY4, (void *)key);
			if (!ret) {
	 			strcpy(tmpBuf, T("Set wep-key4 error!"));
				goto setErr_wdsWep;
			}
		}
	}

setWdsWep_ret:
	apmib_update(CURRENT_SETTING);

#ifdef HOME_GATEWAY
	sprintf(tmpBuf, "%s/%s %s %s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG, "gw", "bridge");
	system(tmpBuf);
#else
	sprintf(tmpBuf, "%s/%s %s %s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG, "ap", "bridge");
	system(tmpBuf);
#endif
		
		
	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
	OK_MSG(submitUrl);

	return;

setErr_wdsWep:
	ERR_MSG(tmpBuf);
}


/////////////////////////////////////////////////////////////////////////////
