/*
 *      MIB table declaration
 *
 *      Authors: David Hsu	<davidhsu@realtek.com.tw>
 *
 *      $Id: mibtbl.c,v 1.6 2004/03/12 01:47:46 erwin Exp $
 *
 */

/* Include files */
#include "apmib.h"
#include "mibtbl.h"

/* Global variable definitions */
mib_table_entry_T mib_table[]={
{MIB_DHCP_CLIENT_START,				"DHCP_CLIENT_START", 		IA_T, 		_OFFSET(dhcpClientStart), _SIZE(dhcpClientStart)},
{MIB_DHCP_CLIENT_END,				"DHCP_CLIENT_END",	 		IA_T,		_OFFSET(dhcpClientEnd), _SIZE(dhcpClientEnd)},
{MIB_LICENCE,						"LICENCE",					BYTE_T,			_OFFSET(licence), _SIZE(licence)},
#ifdef HOME_GATEWAY
{MIB_WAN_DHCP,						"WAN_DHCP",					BYTE_T,			_OFFSET(wanDhcp), _OFFSET(wanDhcp)},
{MIB_WAN_DNS_MODE,					"DNS_MODE",					BYTE_T,		_OFFSET(dnsMode), _SIZE(dnsMode)},
{MIB_WAN_DNS1,						"DNS1",						IA_T,		_OFFSET(dns1), _SIZE(dns1)},
{MIB_WAN_DNS2,						"DNS2", 					IA_T, 		_OFFSET(dns2), _SIZE(dns2)},
{MIB_WAN_DNS3,						"DNS3", 					IA_T,		_OFFSET(dns3), _SIZE(dns3)},
{MIB_WAN_MODE,						"WAN_MODE",					BYTE_T,			_OFFSET(wanMode), _SIZE(wanMode)},
//************************************** Dynamic Ip **************************************
{MIB_DYNIP_HOSTNAME,				"DYNIP_HOSTNAME",			STRING_T,		_OFFSET(dynIPHostName), _SIZE(dynIPHostName)},
{MIB_WAN_MAC_ADDR, 					"WAN_MAC_ADDR",				BYTE6_T, 	_OFFSET(wanMacAddr), _SIZE(wanMacAddr)},
//************************************** Static Ip **************************************
{MIB_WAN_IP_ADDR,					"WAN_IP_ADDR", 				IA_T,		_OFFSET(wanIpAddr), _SIZE(wanIpAddr)},
{MIB_WAN_SUBNET_MASK,				"WAN_SUBNET_MASK", 			IA_T, 		_OFFSET(wanSubnetMask), _SIZE(wanSubnetMask)},
{MIB_WAN_DEFAULT_GATEWAY,			"WAN_DEFAULT_GATEWAY",		IA_T,		_OFFSET(wanDefaultGateway), _SIZE(wanDefaultGateway)},
//************************************** PPPoE Setting **************************************
{MIB_PPP_USER,						"PPP_USER_NAME",			STRING_T,	_OFFSET(pppUserName), _SIZE(pppUserName)},
{MIB_PPP_PASSWORD,					"PPP_PASSWORD", 			STRING_T,	_OFFSET(pppPassword), _SIZE(pppPassword)},
{MIB_PPP_IDLE_TIME,					"PPP_IDLE_TIME",			WORD_T,		_OFFSET(pppIdleTime), _SIZE(pppIdleTime)},
{MIB_PPP_CONNECT_TYPE,				"PPP_CONNECT_TYPE",			BYTE_T,		_OFFSET(pppConnectType), _SIZE(pppConnectType)},
{MIB_PPP_SERVNAME,					"PPP_SERVNAME",				STRING_T,		_OFFSET(pppServName), _SIZE(pppServName)},
{MIB_PPP_MTU,						"PPP_MTU",	 				WORD_T,			_OFFSET(pppMTU), _SIZE(pppMTU)},
{MIB_PAUTORECONNECT,				"PAUTORECONNECT",			BYTE_T,			_OFFSET(pAutoReconnect), _SIZE(pAutoReconnect)},	//no use
//************************************** PPTP Setting **************************************
{MIB_PPTP_IPMODE,					"PPTP_IPMODE",				BYTE_T,			_OFFSET(pptpIpMode), _SIZE(pptpIpMode)},
{MIB_PPTPIP_ADDR,					"PPTP_IP_ADDR",				IA_T,			_OFFSET(pptpIPAddr), _SIZE(pptpIPAddr)},
{MIB_PPTPIPMAKE_ADDR,				"PPTP_IP_MASK_ADDR",		IA_T,			_OFFSET(pptpIPMaskAddr), _SIZE(pptpIPMaskAddr)},
{MIB_PPTPDFGATEWAY,					"PPTP_DEF_GATEWAY",			IA_T,			_OFFSET(pptpDfGateway), _SIZE(pptpDfGateway)},
{MIB_PPTPGATEWAY,					"PPTP_GATEWAY",				IA_T,			_OFFSET(pptpGateway), _SIZE(pptpGateway)},
{MIB_PPTP_USER,						"PPTP_USER_NAME",			STRING_T,		_OFFSET(pptpUserName), _SIZE(pptpUserName)},
{MIB_PPTP_PASSWORD,					"PPTP_PASSWORD", 			STRING_T,		_OFFSET(pptpPassword), _SIZE(pptpPassword)},
{MIB_PPTP_IDLE_TIME,				"PPTP_IDLE_TIME",			WORD_T,			_OFFSET(pptpIdleTime), _SIZE(pptpIdleTime)},
{MIB_PPTP_CONNECT_TYPE,				"PPTP_CONNECT_TYPE",		BYTE_T,			_OFFSET(pptpConnectType), _SIZE(pptpConnectType)},
{MIB_PPTP_CONNT_ID,					"PPTP_CONNT_ID",			STRING_T,		_OFFSET(pptpConntID), _SIZE(pptpConntID)},
{MIB_PPTP_BEZEQ_ENABLE,				"PPTP_BEZEQ_ENABLED",		BYTE_T,		_OFFSET(pptpBEZEQEnable), _SIZE(pptpBEZEQEnable)},
{MIB_PPTP_MTU,						"PPTP_MTU",	 				WORD_T,			_OFFSET(pptpMTU), _SIZE(pptpMTU)},
//************************************** L2TP Setting **************************************
{MIB_L2TP_IPMODE,					"L2TP_IPMODE",			BYTE_T,			_OFFSET(L2TPIpMode), _SIZE(L2TPIpMode)},
{MIB_L2TP_IP_ADDR,					"L2TP_IP_ADDR",			IA_T,			_OFFSET(L2TPIPAddr), _SIZE(L2TPIPAddr)},
{MIB_L2TP_MAKEADDR,					"L2TP_MASK_ADDR",		IA_T,			_OFFSET(L2TPMaskAddr), _SIZE(L2TPMaskAddr)},
{MIB_L2TP_DEFGATEWAY,				"L2TP_DEFGATEWAY",		IA_T,			_OFFSET(L2TPDefGateway), _SIZE(L2TPDefGateway)},
{MIB_L2TP_GATEWAY,					"L2TP_GATEWAY",			STRING_T,		_OFFSET(L2TPGateway), _SIZE(L2TPGateway)},
{MIB_L2TP_USER,						"L2TP_USER_NAME",		STRING_T,		_OFFSET(L2TPUserName), _SIZE(L2TPUserName)},
{MIB_L2TP_PASSWORD,					"L2TP_PASSWORD", 		STRING_T,		_OFFSET(L2TPPassword), _SIZE(L2TPPassword)},
{MIB_L2TP_IDLE_TIME,				"L2TP_IDLE_TIME",		WORD_T,			_OFFSET(L2TPIdleTime), _SIZE(L2TPIdleTime)},
{MIB_L2TP_CONNECT_TYPE,				"L2TP_CONNECT_TYPE",	BYTE_T,			_OFFSET(L2TPConnectType), _SIZE(L2TPConnectType)},
{MIB_L2TP_MTU,						"L2TP_MTU",				WORD_T,			_OFFSET(L2TPMTU), _SIZE(L2TPMTU)},
//************************************** TelStra Big Pond **************************************
{MIB_TELBPIP_ADDR,					"TELBP_IP_ADDR",		IA_T,			_OFFSET(telBPIPAddr), _SIZE(telBPIPAddr)},
{MIB_TELBP_USER,					"TELBP_USER_NAME",		STRING_T,		_OFFSET(telBPUserName), _SIZE(telBPUserName)},
{MIB_TELBP_PASSWORD,				"TELBP_PASSWORD", 		STRING_T,		_OFFSET(telBPPassword), _SIZE(telBPPassword)},
{MIB_TELBP_ENABLED,					"TELBP_ENABLED",		BYTE_T,			_OFFSET(telBPEnabled), _SIZE(telBPEnabled)},
{MIB_TELBP_STATE,					"TELBP_STATE",			BYTE_T,			_OFFSET(telBPState), _SIZE(telBPState)},
//************************************** Port Forwarding **************************************
{MIB_PORTFW_ENABLED,				"PORTFW_ENABLED",			BYTE_T,		_OFFSET(portFwEnabled), _SIZE(portFwEnabled)},
{MIB_PORTFW_NUM,					"PORTFW_TBL_NUM",			BYTE_T,		_OFFSET(portFwNum), _SIZE(portFwNum)},
{MIB_PORTFW,						"PORTFW_TBL",				PORTFW_ARRAY_T,	_OFFSET(portFwArray), _SIZE(portFwArray)},
//-------------------------------------------------------------------------------------------
{MIB_VSER,							"VSER_TBL",					VSER_ARRAY_T,	_OFFSET(vserArray), _SIZE(vserArray)},
	
{MIB_IPFILTER_ENABLED,				"IPFILTER_ENABLED",			BYTE_T,		_OFFSET(ipFilterEnabled), _SIZE(ipFilterEnabled)},
{MIB_IPFILTER_NUM,					"IPFILTER_TBL_NUM",			BYTE_T,		_OFFSET(ipFilterNum), _SIZE(ipFilterNum)},
{MIB_IPFILTER,						"IPFILTER_TBL",				IPFILTER_ARRAY_T,_OFFSET(ipFilterArray), _SIZE(ipFilterArray)},
	
{MIB_DMZ_NUM,						"DMZ_TBL_NUM",				BYTE_T,		_OFFSET(DMZNum), _SIZE(DMZNum)},
{MIB_DMZ,							"DMZ_TBL",					DMZ_ARRAY_T,	_OFFSET(DMZArray), _SIZE(DMZArray)},
//************************************** URL Blocking **************************************
{MIB_URLB_ENABLED,					"URLB_ENABLED",				BYTE_T,		_OFFSET(URLBEnabled), _SIZE(URLBEnabled)},
{MIB_URLB_NUM,						"URLB_TBL_NUM",				BYTE_T,		_OFFSET(URLBNum), _SIZE(URLBNum)},
{MIB_URLB,							"URLB_TBL",					URLB_ARRAY_T,	_OFFSET(URLBArray), _SIZE(URLBArray)},
//************************************** Access Control Ip **************************************
{MIB_ACPC_ENABLED,					"ACPC_ENABLED",				BYTE_T,		_OFFSET(ACPCEnabled), _SIZE(ACPCEnabled)},
{MIB_ACPC_NUM,						"ACPC_TBL_NUM",				BYTE_T,		_OFFSET(ACPCNum), _SIZE(ACPCNum)},
{MIB_ACPC,							"ACPC_TBL",					ACPC_ARRAY_T,	_OFFSET(ACPCArray), _SIZE(ACPCArray)},
	
{MIB_PORTFILTER_ENABLED,			"PORTFILTER_ENABLED",		BYTE_T,		_OFFSET(portFilterEnabled), _SIZE(portFilterEnabled)},
{MIB_PORTFILTER_NUM,				"PORTFILTER_TBL_NUM",		BYTE_T,		_OFFSET(portFilterNum), _SIZE(portFilterNum)},
{MIB_PORTFILTER,					"PORTFILTER_TBL",			PORTFILTER_ARRAY_T,_OFFSET(portFilterArray), _SIZE(portFilterArray)},
{MIB_MACFILTER_PERMIT_ENABLED,		"MACFILTER_PERMIT_ENABLED",	BYTE_T,		_OFFSET(macFtPermitEnabled), _SIZE(macFtPermitEnabled)},
{MIB_MACFILTER_ENABLED,				"MACFILTER_ENABLED",		BYTE_T,		_OFFSET(macFilterEnabled), _SIZE(macFilterEnabled)},
//#endif
{MIB_MACFILTER_NUM,					"MACFILTER_TBL_NUM",		BYTE_T,		_OFFSET(macFilterNum), _SIZE(macFilterNum)},
//#ifdef HOME_GATEWAY
{MIB_MACFILTER,						"MACFILTER_TBL",			MACFILTER_ARRAY_T,_OFFSET(macFilterArray), _SIZE(macFilterArray)},
//************************************** Special Application **************************************
{MIB_TRIGGERPORT_ENABLED,			"TRIGGERPORT_ENABLED",		BYTE_T,		_OFFSET(triggerPortEnabled), _SIZE(triggerPortEnabled)},
{MIB_TRIGGERPORT_NUM,				"TRIGGERPORT_TBL_NUM",		BYTE_T,		_OFFSET(triggerPortNum), _SIZE(triggerPortNum)},
{MIB_TRIGGERPORT,					"TRIGGERPORT_TBL",			TRIGGERPORT_ARRAY_T,_OFFSET(triggerPortArray), _SIZE(triggerPortArray)},
		
{MIB_DMZ_ENABLED,					"DMZ_ENABLED", 				BYTE_T,		_OFFSET(dmzEnabled), _SIZE(dmzEnabled)},
{MIB_DMZ_HOST,						"DMZ_HOST", 				IA_T,		_OFFSET(dmzHost), _SIZE(dmzHost)},
//************************************** Static Routing **************************************
{MIB_SROUT_ENABLED,					"SROUT_ENABLED",			BYTE_T,		_OFFSET(sroutEnabled), _SIZE(sroutEnabled)},
{MIB_SROUT_NUM,						"SROUT_TBL_NUM",			BYTE_T,		_OFFSET(sroutNum), _SIZE(sroutNum)},
{MIB_SROUT,							"SROUT_TBL",				SROUT_ARRAY_T,	_OFFSET(sroutArray), _SIZE(sroutArray)},
#endif

#ifndef HOME_GATEWAY
//************************************** RADIUS Server **************************************
{MIB_RSER_ENABLED,					"RSER_ENABLED",				BYTE_T,		_OFFSET(rserEnabled), _SIZE(rserEnabled)},
{MIB_RSER_CLT_NUM,					"RSER_CLT_TBL_NUM",			BYTE_T,		_OFFSET(rserCltNum), _SIZE(rserCltNum)},
{MIB_RSER_CLT,						"RSER_CLT_TBL",				RSER_CLT_ARRAY_T,	_OFFSET(rserCltArray), _SIZE(rserCltArray)},

{MIB_RSER_USR_NUM,					"RSER_USR_TBL_NUM",			BYTE_T,		_OFFSET(rserUsrNum), _SIZE(rserUsrNum)},
{MIB_RSER_USR,						"RSER_USR_TBL",				RSER_USR_ARRAY_T,	_OFFSET(rserUsrArray), _SIZE(rserUsrArray)},
#endif
	
//******************************wireless setting for inprocomm ******************************
{MIB_WLAN_TRAN_RATE,				"WLAN_TRAN_RATE",			STRING_T,	_OFFSET(wlanTranRate), _SIZE(wlanTranRate)},
{MIB_WLAN_RATE_MODE,				"WLAN_RATE_MODE",			BYTE_T,		_OFFSET(wlanRateMode), _SIZE(wlanRateMode)},
{MIB_WLAN_CTS,						"WLAN_CTS",					BYTE_T,		_OFFSET(wlanCts), _SIZE(wlanCts)},
{MIB_WLAN_BURST,					"WLAN_BURST",				BYTE_T,		_OFFSET(wlanBurst), _SIZE(wlanBurst)},

{MIB_WLAN_WEP152_KEY1,				"WEP152_KEY1", 				BYTE16_T,	_OFFSET(wep152Key1), _SIZE(wep152Key1)},
{MIB_WLAN_WEP152_KEY2,				"WEP152_KEY2", 				BYTE16_T,	_OFFSET(wep152Key2), _SIZE(wep152Key2)},
{MIB_WLAN_WEP152_KEY3,				"WEP152_KEY3", 				BYTE16_T,	_OFFSET(wep152Key3), _SIZE(wep152Key3)},
{MIB_WLAN_WEP152_KEY4,				"WEP152_KEY4", 				BYTE16_T,	_OFFSET(wep152Key4), _SIZE(wep152Key4)},
//*************************************** wireless setting ****************************************
{MIB_1X_MODE,						"DOT1X_MODE",				BYTE_T,		_OFFSET(sel1xMode), _SIZE(sel1xMode)},
{MIB_ELAN_MAC_ADDR, 				"ELAN_MAC_ADDR",			BYTE6_T, 	_OFFSET(elanMacAddr), _SIZE(elanMacAddr)},
{MIB_WLAN_MAC_ADDR, 				"WLAN_MAC_ADDR",			BYTE6_T, 	_OFFSET(wlanMacAddr), _SIZE(wlanMacAddr)},
{MIB_WLAN_SSID,						"SSID", 					STRING_T,	_OFFSET(ssid), _SIZE(ssid)},
{MIB_WLAN_CHAN_NUM,					"CHANNEL", 					BYTE_T, 	_OFFSET(channel), _SIZE(channel)},
{MIB_WLAN_WEP,						"WEP", 						BYTE_T,		_OFFSET(wep), _SIZE(wep)},
{MIB_WLAN_WEP64_KEY1,				"WEP64_KEY1", 				BYTE5_T,	_OFFSET(wep64Key1), _SIZE(wep64Key1)},
{MIB_WLAN_WEP64_KEY2,				"WEP64_KEY2", 				BYTE5_T,	_OFFSET(wep64Key2), _SIZE(wep64Key2)},
{MIB_WLAN_WEP64_KEY3,				"WEP64_KEY3", 				BYTE5_T,	_OFFSET(wep64Key3), _SIZE(wep64Key3)},
{MIB_WLAN_WEP64_KEY4,				"WEP64_KEY4", 				BYTE5_T,	_OFFSET(wep64Key4), _SIZE(wep64Key4)},
{MIB_WLAN_WEP128_KEY1,				"WEP128_KEY1", 				BYTE13_T,	_OFFSET(wep128Key1), _SIZE(wep128Key1)},
{MIB_WLAN_WEP128_KEY2,				"WEP128_KEY2", 				BYTE13_T,	_OFFSET(wep128Key2), _SIZE(wep128Key2)},
{MIB_WLAN_WEP128_KEY3,				"WEP128_KEY3", 				BYTE13_T,	_OFFSET(wep128Key3), _SIZE(wep128Key3)},
{MIB_WLAN_WEP128_KEY4,				"WEP128_KEY4", 				BYTE13_T,	_OFFSET(wep128Key4), _SIZE(wep128Key4)},
{MIB_WLAN_WEP_DEFAULT_KEY,			"WEP_DEFAULT_KEY", 			BYTE_T,		_OFFSET(wepDefaultKey), _SIZE(wepDefaultKey)},
{MIB_WLAN_WEP_KEY_TYPE,				"WEP_KEY_TYPE", 			BYTE_T,		_OFFSET(wepKeyType), _SIZE(wepKeyType)},
{MIB_WLAN_FRAG_THRESHOLD,			"FRAG_THRESHOLD", 			WORD_T,		_OFFSET(fragThreshold), _SIZE(fragThreshold)},
{MIB_WLAN_SUPPORTED_RATE,			"SUPPORTED_RATES", 			WORD_T,		_OFFSET(supportedRates), _SIZE(supportedRates)},
{MIB_WLAN_BEACON_INTERVAL,			"BEACON_INTERVAL", 			WORD_T,		_OFFSET(beaconInterval), _SIZE(beaconInterval)},
{MIB_WLAN_PREAMBLE_TYPE,			"PREAMBLE_TYPE", 			BYTE_T,		_OFFSET(preambleType), _SIZE(preambleType)},
{MIB_WLAN_BASIC_RATE,				"BASIC_RATES", 				WORD_T, 	_OFFSET(basicRates), _SIZE(basicRates)},
{MIB_WLAN_RTS_THRESHOLD,			"RTS_THRESHOLD", 			WORD_T, 	_OFFSET(rtsThreshold), _SIZE(rtsThreshold)},
{MIB_WLAN_AUTH_TYPE,				"AUTH_TYPE", 				BYTE_T,		_OFFSET(authType), _SIZE(authType)},
{MIB_WLAN_HIDDEN_SSID,				"HIDDEN_SSID", 				BYTE_T,		_OFFSET(hiddenSSID), _SIZE(hiddenSSID)},
{MIB_WLAN_DISABLED,					"WLAN_DISABLED", 			BYTE_T,		_OFFSET(wlanDisabled), _SIZE(wlanDisabled)},
{MIB_WLAN_INACTIVITY_TIME,			"INACTIVITY_TIME",			DWORD_T,	_OFFSET(inactivityTime), _SIZE(inactivityTime)},
{MIB_WLAN_RATE_ADAPTIVE_ENABLED,	"RATE_ADAPTIVE_ENABLED",	BYTE_T,		_OFFSET(rateAdaptiveEnabled), _SIZE(rateAdaptiveEnabled)},
{MIB_WLAN_DTIM_PERIOD,				"DTIM_PERIOD", 				BYTE_T,		_OFFSET(dtimPeriod), _SIZE(dtimPeriod)},
{MIB_WLAN_MODE,						"WLAN_MODE", 				BYTE_T,		_OFFSET(wlanMode), _SIZE(wlanMode)},
{MIB_WLAN_NETWORK_TYPE,				"NETWORK_TYPE",				BYTE_T,		_OFFSET(networkType), _SIZE(networkType)},
{MIB_WLAN_IAPP_DISABLED,			"IAPP_DISABLED",			BYTE_T,		_OFFSET(iappDisabled), _SIZE(iappDisabled)},
{MIB_WLAN_SET_TX,					"WLAN_SET_TX",				BYTE_T,		_OFFSET(wlanSetTx), _SIZE(wlanSetTx)},
{MIB_AP_MODE,						"AP_MODE",					BYTE_T,		_OFFSET(apMode), _SIZE(apMode)},
{MIB_AP_MODE_TEMP,					"AP_MODE_TEMP",				BYTE_T,		_OFFSET(apModeTemp), _SIZE(apModeTemp)},
{MIB_SECURITY_MODE,					"SECURITY_MODE",			BYTE_T,		_OFFSET(secMode), _SIZE(secMode)},
{MIB_CLIENT_IP_DISABLED,			"CLIENT_IP_DISABLED",		BYTE_T,		_OFFSET(clIpDisabled), _SIZE(clIpDisabled)},
//**************************************** WEP of WDS****************************************
{MIB_WLAN_WDS_WEP,					"WDS_WEP", 					BYTE_T,		_OFFSET(wdsWep), _SIZE(wdsWep)},
{MIB_WLAN_WDS_WEP64_KEY1,			"WDS_WEP64_KEY1", 			BYTE5_T,	_OFFSET(wdsWep64Key1), _SIZE(wdsWep64Key1)},
{MIB_WLAN_WDS_WEP64_KEY2,			"WDS_WEP64_KEY2", 			BYTE5_T,	_OFFSET(wdsWep64Key2), _SIZE(wdsWep64Key2)},
{MIB_WLAN_WDS_WEP64_KEY3,			"WDS_WEP64_KEY3", 			BYTE5_T,	_OFFSET(wdsWep64Key3), _SIZE(wdsWep64Key3)},
{MIB_WLAN_WDS_WEP64_KEY4,			"WDS_WEP64_KEY4", 			BYTE5_T,	_OFFSET(wdsWep64Key4), _SIZE(wdsWep64Key4)},
{MIB_WLAN_WDS_WEP128_KEY1,			"WDS_WEP128_KEY1",			BYTE13_T,	_OFFSET(wdsWep128Key1), _SIZE(wdsWep128Key1)},
{MIB_WLAN_WDS_WEP128_KEY2,			"WDS_WEP128_KEY2", 			BYTE13_T,	_OFFSET(wdsWep128Key2), _SIZE(wdsWep128Key2)},
{MIB_WLAN_WDS_WEP128_KEY3,			"WDS_WEP128_KEY3", 			BYTE13_T,	_OFFSET(wdsWep128Key3), _SIZE(wdsWep128Key3)},
{MIB_WLAN_WDS_WEP128_KEY4,			"WDS_WEP128_KEY4", 			BYTE13_T,	_OFFSET(wdsWep128Key4), _SIZE(wdsWep128Key4)},
{MIB_WLAN_WDS_WEP_DEFAULT_KEY,		"WDS_WEP_DEFAULT_KEY", 		BYTE_T,		_OFFSET(wdsWepDefaultKey), _SIZE(wdsWepDefaultKey)},
{MIB_WLAN_WDS_WEP_KEY_TYPE,			"WDS_WEP_KEY_TYPE", 		BYTE_T,		_OFFSET(wdsWepKeyType), _SIZE(wdsWepKeyType)},

{MIB_WL_LINKMAC1, 					"WL_LINKMAC1",				BYTE6_T, 	_OFFSET(wlLinkMac1), _SIZE(wlLinkMac1)},
{MIB_WL_LINKMAC2, 					"WL_LINKMAC2",				BYTE6_T, 	_OFFSET(wlLinkMac2), _SIZE(wlLinkMac2)},
{MIB_WL_LINKMAC3, 					"WL_LINKMAC3",				BYTE6_T, 	_OFFSET(wlLinkMac3), _SIZE(wlLinkMac3)},
{MIB_WL_LINKMAC4, 					"WL_LINKMAC4",				BYTE6_T, 	_OFFSET(wlLinkMac4), _SIZE(wlLinkMac4)},
{MIB_WL_LINKMAC5, 					"WL_LINKMAC5",				BYTE6_T, 	_OFFSET(wlLinkMac5), _SIZE(wlLinkMac5)},
{MIB_WL_LINKMAC6, 					"WL_LINKMAC6",				BYTE6_T, 	_OFFSET(wlLinkMac6), _SIZE(wlLinkMac6)},

#ifdef WLAN_WPA
{MIB_WLAN_ENCRYPT,					"WLAN_ENCRYPT",				BYTE_T,		_OFFSET(encrypt), _SIZE(encrypt)},
{MIB_WLAN_ENABLE_SUPP_NONWPA,		"WLAN_ENABLE_SUPP_NONWPA",	BYTE_T,	_OFFSET(enableSuppNonWpa), _SIZE(enableSuppNonWpa)},
{MIB_WLAN_SUPP_NONWPA,				"WLAN_SUPP_NONWPA", 		BYTE_T,		_OFFSET(suppNonWpa), _SIZE(suppNonWpa)},
{MIB_WLAN_WPA_AUTH,					"WLAN_WPA_AUTH", 			BYTE_T,		_OFFSET(wpaAuth), _SIZE(wpaAuth)},
{MIB_WLAN_WPA_CIPHER_SUITE,			"WLAN_WPA_CIPHER_SUITE",	BYTE_T,		_OFFSET(wpaCipher), _SIZE(wpaCipher)},
{MIB_WLAN_WPA_PSK,					"WLAN_WPA_PSK",				STRING_T,	_OFFSET(wpaPSK), _SIZE(wpaPSK)},
{MIB_WLAN_WPA_GROUP_REKEY_TIME,		"WLAN_WPA_GROUP_REKEY_TIME",DWORD_T,_OFFSET(wpaGroupRekeyTime), _SIZE(wpaGroupRekeyTime)},
{MIB_WLAN_ENABLE_MAC_AUTH,			"MAC_AUTH_ENABLED",			BYTE_T,     _OFFSET(macAuthEnabled), _SIZE(macAuthEnabled)},
{MIB_WLAN_RS_IP,					"RS_IP",					IA_T,		_OFFSET(rsIpAddr), _SIZE(rsIpAddr)},
{MIB_WLAN_RS_PORT,					"RS_PORT",					WORD_T,		_OFFSET(rsPort), _SIZE(rsPort)},
{MIB_WLAN_RS_PASSWORD,				"RS_PASSWORD",				STRING_T,	_OFFSET(rsPassword), _SIZE(rsPassword)},
{MIB_WLAN_RS_RETRY,					"RS_MAXRETRY",				BYTE_T,		_OFFSET(rsMaxRetry), _SIZE(rsMaxRetry)},
{MIB_WLAN_RS_INTERVAL_TIME,			"RS_INTERVAL_TIME",			WORD_T,		_OFFSET(rsIntervalTime), _SIZE(rsIntervalTime)},
{MIB_WLAN_ACCOUNT_RS_ENABLED,		"ACCOUNT_RS_ENABLED", 		BYTE_T,		_OFFSET(accountRsEnabled), _SIZE(accountRsEnabled)},
{MIB_WLAN_ACCOUNT_RS_IP,			"ACCOUNT_RS_IP",			IA_T,		_OFFSET(accountRsIpAddr), _SIZE(accountRsIpAddr)},
{MIB_WLAN_ACCOUNT_RS_PORT,			"ACCOUNT_RS_PORT",			WORD_T,		_OFFSET(accountRsPort), _SIZE(accountRsPort)},
{MIB_WLAN_ACCOUNT_RS_PASSWORD,		"ACCOUNT_RS_PASSWORD",		STRING_T,	_OFFSET(accountRsPassword), _SIZE(accountRsPassword)},
{MIB_WLAN_ACCOUNT_UPDATE_ENABLED,	"ACCOUNT_RS_UPDATE_ENABLED",BYTE_T,	_OFFSET(accountRsUpdateEnabled), _SIZE(accountRsUpdateEnabled)},
{MIB_WLAN_ACCOUNT_UPDATE_DELAY,		"ACCOUNT_RS_UPDATE_DELAY",	WORD_T,	_OFFSET(accountRsUpdateDelay), _SIZE(accountRsUpdateDelay)},
{MIB_WLAN_ACCOUNT_RS_RETRY,			"ACCOUNT_RS_MAXRETRY",		BYTE_T,		_OFFSET(accountRsMaxRetry), _SIZE(accountRsMaxRetry)},
{MIB_WLAN_ACCOUNT_RS_INTERVAL_TIME, "ACCOUNT_RS_INTERVAL_TIME",	WORD_T,	_OFFSET(accountRsIntervalTime), _SIZE(accountRsIntervalTime)},
//{MIB_WLAN_SUPP_NONWPA,				"WLAN_SUPP_NONWPA", 		BYTE_T,		_OFFSET(suppNonWpa), _SIZE(suppNonWpa)},
{MIB_WLAN_ENABLE_1X,				"WLAN_ENABLE_1X", 			BYTE_T,		_OFFSET(enable1X), _SIZE(enable1X)},
{MIB_WLAN_WPA_PSK_FORMAT,			"WLAN_PSK_FORMAT", 			BYTE_T,		_OFFSET(wpaPSKFormat), _SIZE(wpaPSKFormat)},
//{MIB_WLAN_RS_INTERVAL_TIME,			"MAC_AUTH_ENABLED", 		BYTE_T,		_OFFSET(macAuthEnabled), _SIZE(macAuthEnabled)},
#endif

{MIB_ALIAS_NAME,					"ALIAS_NAME",				STRING_T,	_OFFSET(aliasName), _SIZE(aliasName)},
{MIB_IP_ADDR,						"IP_ADDR", 					IA_T,		_OFFSET(ipAddr), _SIZE(ipAddr)},
//--------------------------------------------------------------------------------------------

{MIB_DHCPGATEWAYIP_ADDR,			"DHCPGATEWAYIP_ADDR",		IA_T,		_OFFSET(DhcpGatewayIPAddr), _SIZE(DhcpGatewayIPAddr)},
{MIB_DHCPNAMESERVER_ADDR,			"DHCPNAMESERVER_ADDR",		IA_T,		_OFFSET(DhcpNameServerIPAddr), _SIZE(DhcpNameServerIPAddr)},
{MIB_DOMAIN_NAME,					"DOMAIN_NAME",				STRING_T,	_OFFSET(DomainNames), _SIZE(DomainNames)},
{MIB_LAN_LEASETIME,					"LAN_LEASE_TIME",			DWORD_T,	_OFFSET(leaseTime), _SIZE(leaseTime)},
//--------------------------------------------------------------------------------------------
{MIB_SUBNET_MASK,					"SUBNET_MASK", 				IA_T,			_OFFSET(subnetMask), _SIZE(subnetMask)},
{MIB_DEFAULT_GATEWAY,				"DEFAULT_GATEWAY",			IA_T,			_OFFSET(defaultGateway), _SIZE(defaultGateway)},
{MIB_DHCP,							"DHCP", 					BYTE_T,			_OFFSET(dhcp), _SIZE(dhcp)},
{MIB_STP_ENABLED,					"STP_ENABLED",				BYTE_T,			_OFFSET(stpEnabled), _SIZE(stpEnabled)},
{MIB_WLAN_AC_NUM, 					"WLAN_MACAC_NUM",			BYTE_T,			_OFFSET(acNum), _SIZE(acNum)},
{MIB_WLAN_AC_ENABLED,				"WLAN_MACAC_ENABLED",		BYTE_T,		_OFFSET(acEnabled), _SIZE(acEnabled)},
{MIB_WLAN_AC_ADDR,					"WLAN_MACAC_ADDR",			WLAC_ARRAY_T,	_OFFSET(acAddrArray), _SIZE(acAddrArray)},
{MIB_SUPER_NAME,					"SUPER_NAME", 				STRING_T,		_OFFSET(superName), _SIZE(superName)},
{MIB_SUPER_PASSWORD,				"SUPER_PASSWORD",			STRING_T,		_OFFSET(superPassword), _SIZE(superPassword)},
{MIB_USER_NAME,						"USER_NAME",				STRING_T,		_OFFSET(userName), _SIZE(userName)},
{MIB_USER_PASSWORD,					"USER_PASSWORD",			STRING_T,		_OFFSET(userPassword), _SIZE(userPassword)},
//----------------------------------------TimeZone------------------------------------------------
#ifdef HOME_GATEWAY
{MIB_TIME_ZONE_SEL,					"TIME_ZONE_SEL",			WORD_T,			_OFFSET(TimeZoneSel), _SIZE(TimeZoneSel)},
{MIB_START_MONTH,					"START_MONTH",				WORD_T,			_OFFSET(startMonth), _SIZE(startMonth)},
{MIB_START_DAY,						"START_DAY",				WORD_T,			_OFFSET(startDay), _SIZE(startDay)},
{MIB_END_MONTH,						"END_MONTH",				WORD_T,			_OFFSET(endMonth), _SIZE(endMonth)},
{MIB_END_DAY,						"END_DAY",					WORD_T,			_OFFSET(endDay), _SIZE(endDay)},
{MIB_TIMESERVER_ADDR,				"TIMESERVER_ADDR",			IA_T,			_OFFSET(TimeServerAddr), _SIZE(TimeServerAddr)},
{MIB_DAYLIGHT_ENABLE,				"DAYLIGHT_ENABLE",			BYTE_T,			_OFFSET(DayLightEnable), _SIZE(DayLightEnable)},
//------------------------------------Remote Management Host Address-----------------------------
{MIB_REMANHOST_ADDR,				"REMANHOST_ADDR",			IA_T,			_OFFSET(reManHostAddr), _SIZE(reManHostAddr)},
{MIB_REMAN_PORT,					"REMAN_PORT",				WORD_T,			_OFFSET(reManPort), _SIZE(reManPort)},
{MIB_REMANG_ENABLE,					"REMANG_ENABLE",			BYTE_T,			_OFFSET(reMangEnable), _SIZE(reMangEnable)},
		
{MIB_UPNP_ENABLE,					"UPNP_ENABLE",			BYTE_T,			_OFFSET(upnpEnable), _SIZE(upnpEnable)},
{MIB_NAT_ENABLE,					"NAT_ENABLE",			BYTE_T,			_OFFSET(natEnable), _SIZE(natEnable)},
{MIB_FIREWALL_ENABLE,				"FIREWALL_ENABLE",		BYTE_T,			_OFFSET(FirewallEnable), _SIZE(FirewallEnable)},
	
{MIB_VSER_ENABLED,					"VSER_ENABLED",			BYTE_T,			_OFFSET(vserEnabled), _SIZE(vserEnabled)},
{MIB_VSER_NUM,						"VSER_TBL_NUM",			BYTE_T,			_OFFSET(vserNum), _SIZE(vserNum)},

{MIB_POD_ENABLED,					"POD_ENABLED",			BYTE_T,			_OFFSET(podEnable), _SIZE(podEnable)},
{MIB_PING_ENABLED,					"PING_ENABLED",			BYTE_T,			_OFFSET(pingEnable), _SIZE(pingEnable)},
{MIB_SCAN_ENABLED,					"SCAN_ENABLED",			BYTE_T,			_OFFSET(scanEnable), _SIZE(scanEnable)},
{MIB_SYN_ENABLED,					"SYN_ENABLED",			BYTE_T,			_OFFSET(synEnable), _SIZE(synEnable)},
{MIB_POD_PACK,						"POD_PACK", 			WORD_T,			_OFFSET(podPack), _SIZE(podPack)},
{MIB_POD_TIME,						"POD_TIME",				BYTE_T,			_OFFSET(podTime), _SIZE(podTime)},
{MIB_POD_BUR,						"POD_BUR", 				WORD_T,			_OFFSET(podBur), _SIZE(podBur)},
{MIB_SYN_PACK,						"SYN_PACK", 			WORD_T,			_OFFSET(synPack), _SIZE(synPack)},
{MIB_SYN_TIME,						"SYN_TIME",				BYTE_T,			_OFFSET(synTime), _SIZE(synTime)},
{MIB_SYN_BUR,						"SYN_BUR", 				WORD_T,			_OFFSET(synBur), _SIZE(synBur)},
{MIB_SCAN_NUM,						"SCAN_NUM",				INDEXDOS_T,		_OFFSET(scanNum), _SIZE(scanNum)},

{MIB_SYS_MODE,						"SYS_MODE",				WORD_T,			_OFFSET(sysMode), _SIZE(sysMode)},

{MIB_DDNS_NAME,						"DDNS_NAME",			STRING_T,		_OFFSET(ddnsName), _SIZE(ddnsName)},
{MIB_DDNS_ACCOUNT,					"DDNS_ACCOUNT",			STRING_T,		_OFFSET(ddnsAccount), _SIZE(ddnsAccount)},
{MIB_DDNS_PASS,						"DDNS_PASS", 			STRING_T,		_OFFSET(ddnsPass), _SIZE(ddnsPass)},
{MIB_DDNS_ENABLE,					"DDNS_ENABLED", 		BYTE_T,			_OFFSET(ddnsEnable), _SIZE(ddnsEnable)},
{MIB_DDNS_PVIDSEL,					"DDNS_PVID_SEL", 		STRING_T,		_OFFSET(ddnspvidSel), _SIZE(ddnspvidSel)},
{MIB_APP_LAYER_GATEWAY,				"APP_LAYER_GATEWAY",	INDEX_T,		_OFFSET(appLayerGateway), _SIZE(appLayerGateway)},

{MIB_DHIS_HOSTID,					"DHIS_HOSTID",			DWORD_T,		_OFFSET(dhisHostID), _SIZE(dhisHostID)},
// Lance 2003.11.05
//{MIB_DHIS_ISADDR,					"DHIS_ISADDR",			IA_T,			_OFFSET(dhisISAddr), _SIZE(dhisISAddr)},
{MIB_DHIS_ISADDR,					"DHIS_ISADDR",			STRING_T,		_OFFSET(dhisISAddr), _SIZE(dhisISAddr)},
//
{MIB_DHIS_PASSWORD,					"DHIS_PASSWORD",		STRING_T,		_OFFSET(dhispass), _SIZE(dhispass)},
{MIB_DHIS_AUTH_P1,					"DHIS_AUTH_P1",			STRING_T,		_OFFSET(dhisAuthP1), _SIZE(dhisAuthP1)},
{MIB_DHIS_AUTH_P2,					"DHIS_AUTH_P2",			STRING_T,		_OFFSET(dhisAuthP2), _SIZE(dhisAuthP2)},
{MIB_DHIS_AUTH_Q1,					"DHIS_AUTH_Q1",			STRING_T,		_OFFSET(dhisAuthQ1), _SIZE(dhisAuthQ1)},
{MIB_DHIS_AUTH_Q2,					"DHIS_AUTH_Q2",			STRING_T,		_OFFSET(dhisAuthQ2), _SIZE(dhisAuthQ2)},
{MIB_DHIS_SELECT,					"DHIS_SELECT",			BYTE_T,			_OFFSET(dhisSelect), _SIZE(dhisSelect)},
		
{MIB_DDNS_TEMPSEL,					"DDNS_TEMPSEL",		 	STRING_T,		_OFFSET(ddnsTempSel), _SIZE(ddnsTempSel)},
{MIB_DHIS_TEMPSEL,					"DHIS_TEMPSEL",			BYTE_T,			_OFFSET(dhisTempSel), _SIZE(dhisTempSel)},
#endif
//------------------------------------------------------------------------------------------------
// Lance 2004.2.16
{MIB_PS_ENABLE,						"PS_ENABLE",			BYTE_T,			_OFFSET(psEnable), _SIZE(psEnable)},
{MIB_PS_IPPENABLE,					"PS_IPPENABLE",			BYTE_T,			_OFFSET(psIPPEnable), _SIZE(psIPPEnable)},
{MIB_PS_LPRENABLE,					"PS_LPRENABLE",			BYTE_T,			_OFFSET(psLPREnable), _SIZE(psLPREnable)},
{MIB_PS_NAME,						"PS_NAME",				STRING_T,		_OFFSET(psName), _SIZE(psName)},
{MIB_PS_PORT1NAME,					"PS_PORT1NAME",			STRING_T,		_OFFSET(psPort1Name), _SIZE(psPort1Name)},
{MIB_PS_PORT2NAME,					"PS_PORT2NAME",			STRING_T,		_OFFSET(psPort2Name), _SIZE(psPort2Name)},
{0}
};

mib_table_entry_T hwmib_table[]={
{MIB_HW_BOARD_VER, 					"HW_BOARD_ID",			BYTE_T, 		_OFFSET_HW(boardVer), _SIZE_HW(boardVer)},
{MIB_HW_NIC0_ADDR, 					"HW_NIC0_ADDR",			BYTE6_T, 		_OFFSET_HW(nic0Addr), _SIZE_HW(nic0Addr)},
{MIB_HW_NIC1_ADDR, 					"HW_NIC1_ADDR",			BYTE6_T, 		_OFFSET_HW(nic1Addr), _SIZE_HW(nic1Addr)},
{MIB_HW_WLAN_ADDR, 					"HW_WLAN_ADDR",			BYTE6_T, 		_OFFSET_HW(wlanAddr), _SIZE_HW(wlanAddr)},
{MIB_HW_REG_DOMAIN, 				"HW_REG_DOMAIN",		BYTE_T, 		_OFFSET_HW(regDomain), _SIZE_HW(regDomain)},
{MIB_HW_RF_TYPE, 					"HW_RF_TYPE",			BYTE_T, 		_OFFSET_HW(rfType), _SIZE_HW(rfType)},
{MIB_HW_TX_POWER, 					"HW_TX_POWER",			BYTE_ARRAY_T, 	_OFFSET_HW(txPower), _SIZE_HW(txPower)},
{MIB_HW_ANT_DIVERSITY, 				"HW_ANT_DIVERSITY",		BYTE_T, 		_OFFSET_HW(antDiversity), _SIZE_HW(antDiversity)},
{MIB_HW_TX_ANT, 					"HW_TX_ANT",			BYTE_T, 		_OFFSET_HW(txAnt), _SIZE_HW(txAnt)},
{MIB_HW_CS_THRESHOLD, 				"HW_CS_THRESHOLD",		BYTE_T, 		_OFFSET_HW(csThreshold), _SIZE_HW(csThreshold)},
{MIB_HW_CCA_MODE, 					"HW_CCA_MODE",			BYTE_T, 		_OFFSET_HW(ccaMode), _SIZE_HW(ccaMode)},
{MIB_HW_PHY_TYPE, 					"HW_PHY_TYPE",			BYTE_T, 		_OFFSET_HW(phyType), _SIZE_HW(phyType)},
{MIB_HW_LED_TYPE, 					"HW_WLAN_LED_TYPE",		BYTE_T, 		_OFFSET_HW(ledType), _SIZE_HW(ledType)},
{0}
};
