#!/bin/sh
. ../../../target.def

make -f Makefile-tools clean
make -f Makefile-tools
if [ $? != 0 ]; then
	echo "make tools fail!!"
	exit 1
fi

echo "copy config and webpages to image..."
cp mgbin ../../../image/
if [ $? != 0 ]; then
    echo "copy mgbin fail!!"
	exit 1
fi

if [ "$GATEWAY" = "y" ]; then
	./cvcfg-gw -r config-gw.txt ../../../image/config-gw.bin
    if [ $? != 0 ]; then
        echo "cvcfg config-gw fail!!"
        exit 1
    fi  
	./cvcfg-gw -r config-gw.txt -op config-gw-pc.bin
	if [ $? != 0 ]; then
    	echo "cvcfg config-gw fail!!"
	    exit 1
	fi
else
	if [ "$MODEL" = "-D_7206GA_" ]; then
		./cvcfg-ap -r config-cl.txt ../../../image/config-cl.bin
	    if [ $? != 0 ]; then
    	    echo "cvcfg config-cl.txt fail!!"
        	exit 1
	    fi
		./cvcfg-ap -r config-cl.txt -op config-cl-pc.bin
		if [ $? != 0 ]; then
    		echo "cvcfg config-cl.txt fail!!"
			exit 1
		fi
	else
		./cvcfg-ap -r config-ap.txt ../../../image/config-ap.bin
    	if [ $? != 0 ]; then
        	echo "cvcfg config-ap.txt fail!!"
	        exit 1
    	fi
		./cvcfg-ap -r config-ap.txt -op config-ap-pc.bin
		if [ $? != 0 ]; then
    		echo "cvcfg config-ap.txt fail!!"
			exit 1
		fi
	fi
fi


#find ../web-ap > web-files-ap.tmp
#find ../web-gw > web-files-gw.tmp
#find ../web-gw > web-files-6104wg.tmp
#find ../web-gw > web-files-6104k.tmp

find ../web/ > web-files.tmp

#sed -e /CVS/d web-files-ap.tmp > web-files-ap.txt
#sed -e /CVS/d web-files-gw.tmp > web-files-gw.txt
#sed -e /CVS/d web-files-6104wg.tmp > web-files-6104wg.txt
#sed -e /CVS/d web-files-6104k.tmp > web-files-6104k.txt

sed -e /CVS/d web-files.tmp > web-files.txt

case "$MODEL" in
	"-D_6104WB_")
		./compweb gw web.txt ../../../image/webpages-gw.bin
		;;	
	"-D_6104WG_")
		./compweb 6104WG  web.txt ../../../image/webpages-6104wg.bin
		;;
    "-D_6104IPC_")
		./compweb 6104IPC  web.txt ../../../image/webpages-6104ipc.bin
		;;
					  
	"-D_6104K_")
		./compweb 6104K web.txt ../../../image/webpages-6104k.bin
		;;
		
	"-D_7206APB_")
		./compweb ap web.txt ../../../image/webpages-ap.bin
		;;
	"-D_7206APG_")
		./compweb 7206APG  web.txt ../../../image/webpages-ap.bin
		;;
	"-D_7207APB_")
		./compweb 7207APB web.txt ../../../image/webpages-ap.bin
		;;
	"-D_7206GA_")
		./compweb 7206GA web.txt ../../../image/webpages-ga.bin
		;;
	"-D_6104WBB_")
		./compweb 6104WBB web.txt ../../../image/webpages-6104wbb.bin
		;;	
	"-D_6104KPS_")
		./compweb 6104KPS web-files.txt ../../../image/webpages-6104kps.bin
		;;
	"-D_6104KP_")
		./compweb 6104KP web-files.txt ../../../image/webpages-6104kp.bin
		;;
	"-D_6104HS_")
		./compweb 6104HS web-files.txt ../../../image/webpages-6104hs.bin
		;;
	"-D_7207APS_")
		./compweb 7207APS web-files.txt ../../../image/webpages-7207aps.bin
		;;
esac

if [ $? != 0 ]; then
    echo "compweb web-files-ap.txt fail!!"
	exit 1
fi	


echo "end copy"
																
