#!/bin/sh

cd include
if [ -f asm/asm.h ]; then
    echo "asm ok"
else
    ln -s asm-mips asm
fi
cd ..

#if [ -f rtkload/hfload.o ]; then
#    echo "rtkload ok"
#else
#    tar xzvf rtkload.tgz
#fi

#if [ -f rtl8181/head.o ]; then
#    echo "rtl8181 ok"
#else
#    tar xzvf rtl8181.tar.gz
#fi

cd net
if [ -f core/dev.c ]; then
	echo "core ok"
else
    tar xzvf bak-core.tgz
fi
cd ..

if [ -f checkdep.o ]; then
	echo "depend ok"
else
	make dep
	echo "1" > checkdep.o
fi

rm -f net/ipv4/netfilter/*.o
make modules

if [ $? != 0 ]; then
	exit 1
fi

echo ""
echo "******************** copy modules ********************"
echo ""

rm -rf ../AP/ALG/linux
mkdir ../AP/ALG/linux

cp net/ipv4/netfilter/ip_conntrack*.o ../AP/ALG/linux
cp net/ipv4/netfilter/ip_nat*.o ../AP/ALG/linux

echo "******************** end copy ********************"

