/*
 * Carsten Langgaard, carstenl@mips.com
 * Copyright (C) 2000, 2001 MIPS Technologies, Inc.
 * Copyright (C) 2001 Ralf Baechle
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * Routines for generic manipulation of the interrupts found on the MIPS 
 * Malta board.
 * The interrupt controller is located in the South Bridge a PIIX4 device 
 * with two internal 82C95 interrupt controllers.
 */
#include <linux/config.h>
#include <linux/init.h>
#include <linux/sched.h>
#include <linux/slab.h>
#include <linux/interrupt.h>
#include <linux/kernel_stat.h>
#include <linux/random.h>
#include <linux/ioport.h>

#include <asm/irq.h>
#include <asm/io.h>
#include <asm/gt64120.h>
#include <asm/am5120/adm5120.h>



extern asmlinkage void mipsIRQ(void);
extern asmlinkage void do_IRQ(int irq, struct pt_regs *regs);
extern void set_debug_traps(void);
extern void breakpoint(void);
extern int remote_debug;
static spinlock_t mips_irq_lock = SPIN_LOCK_UNLOCKED;


void am5120_hw0_irqdispatch(struct pt_regs *regs)
{
	unsigned long flags;
	unsigned long intsrc;
	int i;

	spin_lock_irqsave(&mips_irq_lock, flags);

	intsrc = ADM5120_INTC_REG(IRQ_STATUS_REG) & IRQ_MASK;

	for (i = 0; intsrc; intsrc >>= 1, i++)
		if (intsrc & 0x1)
			do_IRQ(i, regs);

	spin_unlock_irqrestore(&mips_irq_lock, flags);
}



