/*****************************************************************************
;
;   (C) Unpublished Work of ADMtek Incorporated.  All Rights Reserved.
;
;       THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL,
;       PROPRIETARY AND TRADESECRET INFORMATION OF ADMTEK INCORPORATED.
;       ACCESS TO THIS WORK IS RESTRICTED TO (I) ADMTEK EMPLOYEES WHO HAVE A
;       NEED TO KNOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR ASSIGNMENTS
;       AND (II) ENTITIES OTHER THAN ADMTEK WHO HAVE ENTERED INTO APPROPRIATE
;       LICENSE AGREEMENTS.  NO PART OF THIS WORK MAY BE USED, PRACTICED,
;       PERFORMED, COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,
;       ABBRIDGED, CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED, RECAST,
;       TRANSFORMED OR ADAPTED WITHOUT THE PRIOR WRITTEN CONSENT OF ADMTEK.
;       ANY USE OR EXPLOITATION OF THIS WORK WITHOUT AUTHORIZATION COULD
;       SUBJECT THE PERPERTRATOR TO CRIMINAL AND CIVIL LIABILITY.
;
;------------------------------------------------------------------------------
;
;    Project : ADM5120
;    Creator : daniell@admtek.com.tw
;    File    : arch/mips/am5120/setup.c
;	 Date    : 2003.3.4
;    Abstract: 
;
;Modification History:
;
;*****************************************************************************/

#include <linux/config.h>
#include <linux/init.h>
#include <linux/delay.h>
#include <linux/irq.h>
#include <linux/interrupt.h>
#include <linux/serial.h>
#include <linux/types.h>
#include <linux/string.h>	/* for memset */

#include <asm/reboot.h>
#include <asm/io.h>
#include <asm/time.h>
#include <asm/pgtable.h>
#include <asm/processor.h>
#include <asm/system.h>
#include <asm/am5120/adm5120.h>


extern struct rtc_ops am5120_rtc_ops;
extern struct rtc_ops *rtc_ops;

void  mips_timer_setup(struct irqaction *irq);
void  mips_time_init(void);

int am5120_pci_module;


void am5120_restart(char *command)
{
    int i;

	/* Disable All ports*/
	ADM5120_SW_REG(Port_conf0_REG) |= SW_DISABLE_PORT_MASK;

	/* Disable CPU port */
	ADM5120_SW_REG(CPUp_conf_REG) |= SW_CPU_PORT_DISABLE;

	// Wait until switch DMA idle. At least 1ms is required!!!!
    for (i=0; i <1000000; i++);

    ADM5120_SW_REG(SftRest_REG) = SOFTWARE_RESET;
}


void am5120_halt(void)
{
        printk(KERN_NOTICE "\n** You can safely turn off the power\n");
        while (1);
}


void am5120_power_off(void)
{
        am5120_halt();
}


void __init am5120_setup(void)
{
	printk("am5120_setup() starts.\n");

    board_time_init = mips_time_init;
    board_timer_setup = mips_timer_setup;

    _machine_restart = am5120_restart;
    _machine_halt = am5120_halt;
    _machine_power_off = am5120_power_off;

	rtc_ops = &am5120_rtc_ops;

    //Jeffrey
    set_io_port_base(KSEG1);

	//check pci in existence or not
	if (ADM5120_SW_REG(CODE_REG) & CPU_PQFP_MODE)
	{
		printk("System no PCI BIOS\n");
		am5120_pci_module = 0;
	}
	else
	{
		printk("System has PCI BIOS\n");
		am5120_pci_module = 1;
	}
}


const char *get_system_type(void)
{
	return "ADM5120 Demo Board";
}
