/*****************************************************************************
;
;   (C) Unpublished Work of ADMtek Incorporated.  All Rights Reserved.
;
;       THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL,
;       PROPRIETARY AND TRADESECRET INFORMATION OF ADMTEK INCORPORATED.
;       ACCESS TO THIS WORK IS RESTRICTED TO (I) ADMTEK EMPLOYEES WHO HAVE A
;       NEED TO KNOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR ASSIGNMENTS
;       AND (II) ENTITIES OTHER THAN ADMTEK WHO HAVE ENTERED INTO APPROPRIATE
;       LICENSE AGREEMENTS.  NO PART OF THIS WORK MAY BE USED, PRACTICED,
;       PERFORMED, COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,
;       ABBRIDGED, CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED, RECAST,
;       TRANSFORMED OR ADAPTED WITHOUT THE PRIOR WRITTEN CONSENT OF ADMTEK.
;       ANY USE OR EXPLOITATION OF THIS WORK WITHOUT AUTHORIZATION COULD
;       SUBJECT THE PERPERTRATOR TO CRIMINAL AND CIVIL LIABILITY.
;
;------------------------------------------------------------------------------
;
;    Project : ADM5120
;    Creator : daniell@admtek.com.tw
;    File    : net/am5120sw/if5120.c
;	 Date    : 2003.5.14
;    Abstract: ADM5120 Switch driver
;
;Modification History:
;
;*****************************************************************************/

#include <linux/config.h>
#include <linux/module.h>
#include <linux/init.h>

#include <linux/sched.h>
#include <linux/kernel.h>		/* printk() */
#include <linux/slab.h>			/* kmalloc() */
#include <linux/errno.h>		/* error codes */
#include <linux/types.h>		/* size_t */
#include <linux/interrupt.h>	/* mark_bh */

#include <linux/in.h>
#include <linux/netdevice.h>    /* struct device, and other headers */
#include <linux/etherdevice.h>  /* eth_type_trans */
#include <linux/ip.h>           /* struct iphdr */
#include <linux/tcp.h>          /* struct tcphdr */
#include <linux/skbuff.h>
#include <linux/in6.h>

#include <asm/checksum.h>

#include "if5120.h"


#undef AM5120SW_DEBUG	1

#define SW_IRQ			9



extern int swdrv_init(void);
extern void swdrv_ProcessInt(int irq, void *dev_id, struct pt_regs *regs);
extern int swdrv_IfOpen(PSW_PRIV_T priv, char *mac);
extern int swdrv_IfClose(PSW_PRIV_T priv);
extern int swdrv_HwTx(struct sk_buff *skb, PSW_PRIV_T priv);

extern void EnablePromisc(int unit, unsigned long rxmode);
extern void macaddr_write(char *mac, int unit);
extern void macaddr_read(char *mac, int unit);
extern void macaddr_init(void);



int am5120sw_init(struct net_device *dev);


/* This is a load-time options */
static int timeout = 5;
static int irqEn = 0;
static int unit = 0;

/*
 * The devices
 */
struct net_device am5120sw_devs[AM5120SW_IFNUM] = {
    { name:AM5120SW_IF0, init:am5120sw_init },  /* init, nothing more */
    { name:AM5120SW_IF1, init:am5120sw_init }
};


/*
 * Open and close
 */
int am5120sw_open(struct net_device *dev)
{
	PSW_PRIV_T priv = (PSW_PRIV_T)dev->priv;
	int retval;

#ifdef AM5120SW_DEBUG
	printk("Open if: %s\n", dev->name);
#endif

	/* enable switch irq routine */
	if (!irqEn)
	{
		retval = request_irq(SW_IRQ, swdrv_ProcessInt, SA_SHIRQ,
							dev->name, dev);
		if (retval) 
			return -ENODEV;

		irqEn = 1;
	}

	if (swdrv_IfOpen(priv, dev->dev_addr))
		return -ENODEV;

	dev->irq = SW_IRQ;     
    netif_start_queue(dev);
    
	return 0;
}


int am5120sw_release(struct net_device *dev)
{
	PSW_PRIV_T priv = (PSW_PRIV_T)dev->priv;

    netif_stop_queue(dev); /* can't transmit any more */
	swdrv_IfClose(priv);
                         
    return 0;
}


/*
 * Configuration changes (passed on by ifconfig)
 */
int am5120sw_config(struct net_device *dev, struct ifmap *map)
{
	/* can't act on a running interface */
    if (dev->flags & IFF_UP) 
        return -EBUSY;

    /* ignore other fields */
    return 0;
}


/*
 * Configuration changes (passed on by ifconfig)
 * Daniel+ 2003.8.4
 */
int am5120sw_set_rx_mode(struct net_device *dev)
{
	PSW_PRIV_T priv = (PSW_PRIV_T)dev->priv;

	/* Note: do not reorder, GCC is clever about common statements. */
	if (dev->flags & IFF_PROMISC) 
	{
#ifdef AM5120SW_DEBUG
		printk (KERN_NOTICE "%s: Promiscuous mode enabled.\n", dev->name);
#endif
		priv->iflags = IF_PROMISC_MODE;
	} 
	else 
	{
#ifdef AM5120SW_DEBUG
		printk (KERN_NOTICE "%s: Promiscuous mode disabled.\n", dev->name);
#endif
		priv->iflags &= ~IF_PROMISC_MODE;
	}

	/* We can safely update without stopping the chip. */
	EnablePromisc(priv->unit, priv->iflags);
	return 0;
}

        
/*
 * Transmit a packet (called by the kernel)
 */
int am5120sw_tx(struct sk_buff *skb, struct net_device *dev)
{
    PSW_PRIV_T priv = (PSW_PRIV_T)dev->priv;
	unsigned long eflags;

    if (skb == NULL) 
		return 0;

#ifdef GPIO_MEASURE
	GPIO_TOGGLE(2);
#endif

	spin_lock_irqsave(&priv->lock, eflags);

#ifdef GPIO_MEASURE
	GPIO_TOGGLE(2);
#endif


    dev->trans_start = jiffies; /* save the timestamp */

#ifdef GPIO_MEASURE
	GPIO_TOGGLE(2);
#endif
    
    /* transmit data to hardware descriptor */
    swdrv_HwTx(skb, priv);

#ifdef GPIO_MEASURE
	GPIO_TOGGLE(2);
#endif

#ifdef GPIO_MEASURE
	GPIO_TOGGLE(2);
#endif

	spin_unlock_irqrestore(&priv->lock, eflags);

#ifdef GPIO_MEASURE
	GPIO_TOGGLE(2);
#endif
	
	return 0;
}


/*
 * Deal with a transmit timeout.
 */
void am5120sw_tx_timeout (struct net_device *dev)
{
    return;
}



/*
 * Ioctl commands 
 */
int am5120sw_ioctl(struct net_device *dev, struct ifreq *rq, int cmd)
{
    return 0;
}


/*
 * Return statistics to the caller
 */
struct net_device_stats *am5120sw_stats(struct net_device *dev)
{
    PSW_PRIV_T priv = (PSW_PRIV_T)dev->priv;
    return &priv->stats;
}


/*
 * This function is called to fix mac address
 */
int am5120sw_set_mac(struct net_device *dev, void *p)
{
	PSW_PRIV_T priv = (PSW_PRIV_T)dev->priv;
	struct sockaddr *addr = (struct sockaddr *)p;
	unsigned long flags;
	spinlock_t *lock = &((PSW_PRIV_T)dev->priv)->lock;

	if (netif_running(dev))
		return -EBUSY;

	spin_lock_irqsave(lock, flags);
	
	memcpy(dev->dev_addr, addr->sa_data,dev->addr_len);

	macaddr_write(dev->dev_addr, priv->unit); 

    spin_unlock_irqrestore(lock, flags);


	//ProgramVlanMac(priv->unit, dev->dev_addr, SW_MAC_AGE_VALID);
	
	return 0;
}


/*
 * This function is called to fill up an eth header, since arp is not
 * available on the interface
 */
int am5120sw_rebuild_header(struct sk_buff *skb)
{
    return 0;
}


int am5120sw_header(struct sk_buff *skb, struct net_device *dev,
                unsigned short type, void *daddr, void *saddr,
                unsigned int len)
{
    struct ethhdr *eth = (struct ethhdr *)skb_push(skb,ETH_HLEN);

    eth->h_proto = htons(type);
    memcpy(eth->h_source, saddr ? saddr : dev->dev_addr, dev->addr_len);
    memcpy(eth->h_dest,   daddr ? daddr : dev->dev_addr, dev->addr_len);
    return (dev->hard_header_len);
}


/*
 * The "change_mtu" method is usually not needed.
 * If you need it, it must be like this.
 */
int am5120sw_change_mtu(struct net_device *dev, int new_mtu)
{
    unsigned long flags;
    spinlock_t *lock = &((PSW_PRIV_T)dev->priv)->lock;
    
    /* check ranges */
    if ((new_mtu < 68) || (new_mtu > 1500))
        return -EINVAL;

    /*
     * Do anything you need, and the accept the value
     */
    spin_lock_irqsave(lock, flags);
    dev->mtu = new_mtu;
    spin_unlock_irqrestore(lock, flags);
    return 0; /* success */
}


/*
 * The init function (sometimes called probe).
 * It is invoked by register_netdev()
 */
int am5120sw_init(struct net_device *dev)
{
	PSW_PRIV_T priv;

	/* assign some of the fields */
    ether_setup(dev); 

    dev->open            = am5120sw_open;
    dev->stop            = am5120sw_release;
    dev->set_config      = am5120sw_config;
	dev->set_multicast_list = am5120sw_set_rx_mode;
	dev->set_mac_address = am5120sw_set_mac;
    dev->hard_start_xmit = am5120sw_tx;
    dev->do_ioctl        = am5120sw_ioctl;
    dev->get_stats       = am5120sw_stats;
    dev->change_mtu      = am5120sw_change_mtu;  
    dev->rebuild_header  = am5120sw_rebuild_header;
    dev->hard_header     = am5120sw_header;
    dev->tx_timeout     = am5120sw_tx_timeout;
    dev->watchdog_timeo = timeout;

	set_bit(__LINK_STATE_PRESENT, &dev->state);

    /*
     * Then, allocate the priv field. This encloses the statistics
     * and a few private fields.
     */
    dev->priv = kmalloc(sizeof(SW_PRIV_T), GFP_KERNEL);
    if (dev->priv == NULL) 
		return (-ENOMEM);
    
	memset(dev->priv, 0, sizeof(SW_PRIV_T));
	
	priv = (PSW_PRIV_T)dev->priv;
	priv->unit = unit++;
	
	spin_lock_init(&priv->lock);
    
	return 0;
}


/*
 * module init
 */
static int __init am5120switch_init (void)
{
    int result, i, device_present = 0;
	unsigned char *hwMac0Addr = (unsigned char *)0xbfc08007;

	printk("ADM5120 Switch Module Init\n");
	
	/* Initialize the switch device */
	if (swdrv_init() != 0)
		return (-ENODEV);
	
	/* Initialize flash memory */
//	flash_init();

//	macaddr_init();

    for (i = 0; i < AM5120SW_IFNUM;  i++)
	{
		if( i == 0 )
			memmove( am5120sw_devs[i].dev_addr, AM5120SW_DEFAULT_MAC0, 6);
		else
			memmove( am5120sw_devs[i].dev_addr, AM5120SW_DEFAULT_MAC1, 6);
		
//    	macaddr_read(am5120sw_devs[i].dev_addr, i); 
		
		if ((result = register_netdev(am5120sw_devs + i)))
		{
            printk("am5120sw: error %i registering device \"%s\"\n",
                   result, am5120sw_devs[i].name);
		}
        else 
			device_present++;
	}

	if (device_present != AM5120SW_IFNUM)
		return (-ENODEV);

	return 0;
}


/*
 * module cleanup
 */
static void __exit am5120switch_cleanup(void)
{
	int i;
   
    for (i = 0; i < AM5120SW_IFNUM; i++) 
	{
        kfree(am5120sw_devs[i].priv);
        unregister_netdev(am5120sw_devs + i);
    }
}


module_init(am5120switch_init);
module_exit(am5120switch_cleanup);


