
/******************************************************************************
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 * 
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/********************************************************************************
*
*  File Name: product.h
*     Author: Robin Bhagat 
*
*******************************************************************************
*
* Revision History:
*
*      Date    Name  Comments
*    --------  ---   ------------------------------------
*    08/12/97  RWB   Created.
*    02/09/01  LRF   Removed UART Default definitions.
*
*
*
*******************************************************************************/
/* FILE_DESC ******************************************************************
//
// Purpose:
//    This file contains the product dependent values, so that the entire
//    library can be customised by changing this simple file. 
//
//    It also includes the product's memory map header file and a
//    header file containing common product-independent definitions.
//
// Sp. Notes:
//
 ******************************************************************************/

#ifndef PRODUCT_H
#define PRODUCT_H

/*=====================*
 *  Include Files      *
 *=====================*/
#include "pubdefs.h"
#include "mem_map.h"


/*=====================*
 *  Defines            *
 *=====================*/

#define SYS_CLK_MHZ			(14)
#define SYS_CLK_KHZ			(14746)

/* Audio sysclock must be less than sysclock */
#define AUD_SYS_CLK_HZ			(11289600)

#define SYS_CLK_NS			(1000 / SYS_CLK_MHZ)


/*
** This default value is chosen since the system clock freq is 66 MHz.
** So this will provide 2000 tics per sec, if the timer clock divider is
** set to 0. If it is set to 4, 8 or 16 then the timer will provide accurate tic
** every 2ms, 4ms or 8ms respectively since all numbers are intergers.
*/




/*=====================*
 *  External Variables *
 *=====================*/

/*=====================*
 *  External Functions *
 *=====================*/


#endif /* PRODUCT_H */


