#!/bin/sh

server_ip=192.168.15.200
image_file=image_1.0.15
boot_file=uboot.bin_3.7

download_file()
{
	echo " Downloading $1 ...."
	tftp -g -r $2 $server_ip
	if [ ! -e $2 ]; then
		echo "Download $2 fail... Please check the file name"
		exit 1;
	fi
}

if [ "$3" == "" ]; then
	echo "command error, please follow below instructions to enter the commands"
	echo "    auto_upgrade.sh server_ip firmware_filename bootloader_filename";
	exit 0
fi

if [ $1 ]; then
	server_ip=$1
fi

if [ $2 ]; then
	image_file=$2
fi

if [ $3 ]; then
	boot_file=$3
fi

cd /tmp

download_file "fw_tool" "fw_tool"
download_file "boot_loader" $boot_file
download_file "firmware" $image_file

chmod +x fw_tool 
echo " Writing Bootloader ..."
./fw_tool -b $boot_file -c
# Write Firmware twice
echo " Writing Firmware 0 ..."
./fw_tool -f $image_file -p 0
echo " Writing Firmware 1 ..."
./fw_tool -f $image_file -p 1

# If we need to set MAC, set here
if [ $4 ]; then 
	echo " Setting WAN MAC address"
	cs_client set wan/0/mac $4
	# Make sure dual config
	cs_client commit
	cs_client commit
fi

echo " Learning Tamper Jumper Positions"
# ReLearn tamper settings.
cs_client set sys/learn_tamper 1
# Make sure dual config
cs_client commit
cs_client commit

echo "Done. Please reboot you system to make sure the upgrade is complete"
echo "Remember to push reset buttom more than 5 secs after rebooting"

