Summary: The PPP (Point-to-Point Protocol) daemon.
Name: ppp
Version: 2.3.11
Release: 4_MPPE_MSCHAP2
Copyright: distributable
Group: System Environment/Daemons
Source0: ftp://cs.anu.edu.au/pub/software/ppp/ppp-%{version}.tar.gz
Source1: ppp-2.3.5-pamd.conf
Patch0: ppp-2.3.6-sample.patch
Patch1: ppp-2.3.9-wtmp.patch
Patch2: ppp-2.3.11-reap.patch
Patch3: ppp-2.3.11-pam_session.patch
Patch4: ppp-2.3.11-mppe-openssl-0.9.5.patch
Patch5: ppp-2.3.11-mppe-make.patch
Patch6: ppp-2.3.11-mppe_require_option.patch
Patch7: ppp-2.3.11-mppe_require_option_docs.patch
Patch8: ppp-2.3.11-mppe_compress_bug.patch
Patch9: ppp-2.3.11-mppe_debug_bug.patch
Patch10: ppp-2.3.11-mppe_kernel2217_update.patch
BuildRoot: %{_tmppath}/%{name}-root
Requires: glibc >= 2.0.6

%description
The ppp package contains the PPP (Point-to-Point Protocol) daemon and
documentation for PPP support.  The PPP protocol provides a method for
transmitting datagrams over serial point-to-point links. PPP is
usually used to dial in to an ISP (Internet Service Provider) or other
organization over a modem and phone line.

%prep
%setup  -q
%patch0 -p1 -b .sample
%patch1 -p1 -b .wtmp
%patch2 -p1 -b .reap
%patch3 -p1 -b .pam_session
%patch4 -p1 -b .mppe
%patch5 -p1 -b .mppe_make
%patch6 -p1 -b .mppe_require_option
%patch7 -p1 -b .mppe_require_option_docs
%patch8 -p1 -b .mpee_compress_bug
%patch9 -p1 -b .mpee_debug_bug
%patch10 -p1 -b .mpee_kernel_2217

# patch 2 depends on the -lutil in patch 0
find . -type f -name "*.sample" | xargs rm -f 

%build
./configure
make RPM_OPT_FLAGS="$RPM_OPT_FLAGS"

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT

## it shouldn't be SUID root be default
#chmod 755 $RPM_BUILD_ROOT/usr/sbin/pppd

strip $RPM_BUILD_ROOT/usr/sbin/chat $RPM_BUILD_ROOT/usr/sbin/pppstats \
	$RPM_BUILD_ROOT/usr/sbin/pppd 
chmod go+r scripts/*
mkdir -p $RPM_BUILD_ROOT/etc/pam.d
install -m 644 %{SOURCE1} $RPM_BUILD_ROOT/etc/pam.d/ppp
mkdir -p $RPM_BUILD_ROOT/usr/src/linux-ppp-mppe-modules
cp linux/* include/linux/*.[ch] pppd/sha1dgst.c pppd/sha.h pppd/sha_locl.h $RPM_BUILD_ROOT/usr/src/linux-ppp-mppe-modules/

%clean
rm -rf $RPM_BUILD_ROOT

%files
%attr(0755,root,root)	/usr/sbin/chat
%attr(0755,root,root)	/usr/sbin/pppd
%attr(0755,root,daemon)	/usr/sbin/pppdump
%attr(0755,root,daemon)	/usr/sbin/pppstats
%attr(0644,root,root)	/usr/man/man8/chat.8*
%attr(0644,root,root)	/usr/man/man8/pppd.8*
%attr(0644,root,daemon)	/usr/man/man8/pppdump.8*
%attr(0644,root,daemon)	/usr/man/man8/pppstats.8*
%attr(0755,root,root)	%dir /etc/ppp
%attr(0600,root,daemon)	%config /etc/ppp/chap-secrets
%attr(0644,root,daemon)	%config /etc/ppp/options
%attr(0600,root,daemon)	%config /etc/ppp/pap-secrets
%attr(0644,root,root)	%config /etc/pam.d/ppp
%attr(-,root,root)	%doc README README.linux README.MPPE scripts sample
%attr(-,root,root)      /usr/src/linux-ppp-mppe-modules/*.c
%attr(-,root,root)      /usr/src/linux-ppp-mppe-modules/*.h
%attr(-,root,root)      /usr/src/linux-ppp-mppe-modules/*.sh
%attr(-,root,root)      /usr/src/linux-ppp-mppe-modules/*.diff


%changelog
* Wed Feb 21 2001 Tim Small <tim@digitalbrain.com>
- Merged with MPPE patches from ftp://ftp.binarix.com/pub/ppp-mppe/
- Added differing kernel source files to package

* Mon Mar 06 2000 Nalin Dahyabhai <nalin@redhat.com>
- reaper bugs verified as fixed
- check pam_open_session result code (bug #9966)

* Mon Feb 07 2000 Nalin Dahyabhai <nalin@redhat.com>
- take a shot at the wrong reaper bugs (#8153, #5290)

* Thu Feb 03 2000 Nalin Dahyabhai <nalin@redhat.com>
- free ride through the build system (release 2)

* Tue Jan 18 2000 Nalin Dahyabhai <nalin@redhat.com>
- Update to 2.3.11

* Sat Nov 06 1999 Michael K. Johnson <johnsonm@redhat.com>
- Better fix for both problems

* Fri Nov 05 1999 Michael K. Johnson <johnsonm@redhat.com>
- fix for double-dial problem
- fix for requiring a controlling terminal problem

* Sun Sep 19 1999 Preston Brown <pbrown@redhat.com>
- 2.3.10 bugfix release

* Fri Aug 13 1999 Michael K. Johnson <johnsonm@redhat.com>
- New version 2.3.9 required for kernel 2.3.13 and will be required
  for new initscripts.  auth patch removed; 2.3.9 does the same thing
  more readably than the previous patch.

* Thu Jun 24 1999 Cristian Gafton <gafton@redhat.com>
- add pppdump

* Fri Apr 09 1999 Cristian Gafton <gafton@redhat.com>
- force pppd use the glibc's logwtmp instead of implementing its own

* Wed Apr 01 1999 Preston Brown <pbrown@redhat.com>
- version 2.3.7 bugfix release

* Tue Mar 23 1999 Cristian Gafton <gafton@redhat.com>
- version 2.3.6

* Mon Mar 22 1999 Michael Johnson <johnsonm@redhat.com>
- auth patch

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 3)

* Thu Jan 07 1999 Cristian Gafton <gafton@redhat.com>
- build for glibc 2.1

* Fri Jun  5 1998 Jeff Johnson <jbj@redhat.com>
- updated to 2.3.5.

* Tue May 19 1998 Prospector System <bugs@redhat.com>
- translations modified for de

* Fri May  8 1998 Jakub Jelinek <jj@ultra.linux.cz>
- make it run with kernels 2.1.100 and above.

* Fri Apr 24 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Wed Mar 18 1998 Cristian Gafton <gafton@redhat.com>
- requires glibc 2.0.6 or later

* Wed Mar 18 1998 Michael K. Johnson <johnsonm@redhat.com>
- updated PAM patch to not turn off wtmp/utmp/syslog logging.

* Wed Jan  7 1998 Cristian Gafton <gafton@redhat.com>
- added the /etc/pam.d config file
- updated PAM patch to include session support

* Tue Jan  6 1998 Cristian Gafton <gafton@redhat.com>
- updated to ppp-2.3.3, build against glibc-2.0.6 - previous patches not
  required any more.
- added buildroot
- fixed the PAM support, which was really, completely broken and against any
  standards (session support is still not here... :-( )
- we build against running kernel and pray that it will work
- added a samples patch; updated glibc patch

* Thu Dec 18 1997 Erik Troan <ewt@redhat.com>
- added a patch to use our own route.h, rather then glibc's (which has 
  alignment problems on Alpha's) -- I only applied this patch on the Alpha,
  though it should be safe everywhere

* Fri Oct 10 1997 Erik Troan <ewt@redhat.com>
- turned off the execute bit for scripts in /usr/doc

* Fri Jul 18 1997 Erik Troan <ewt@redhat.com>
- built against glibc

* Tue Mar 25 1997 Erik Troan <ewt@redhat.com>
- Integrated new patch from David Mosberger
- Improved description

