/********************************************************************************
*
*	Copyright (c) 2002  Magic Control Technology Co.  All Rights Reserved.
*
*	FILE:
*		firewall.c
*
*	Abstract:
*		firewall configuration function
*		
*	History:
*		2002/1/29	Louis Tsai Created
*********************************************************************************/
#include "libconf.h"
#include <sys/stat.h>

//====================================================================================//
//			VSERVER configuration function		     		      //
//====================================================================================//


int VSERVER_Create_Setup_File(void)
{
	char m_proto[5],ext_if[5];
	REG_VSERVER_CONF conf;
	REG_NET_CONF netconf;
	FILE *fp;
	int i, found =0;
	NIC_INFO wan_info;
	
	if( Config_Read(MC_VSERVER_CONFIG, &conf) != SUCCESS) 
		return FAILED;

	if ( !conf.enable ) {
		unlink(VSERVER_SH_PATH);
		return SUCCESS;
	}
	
	
	if( NIC_Get_WAN_Info(&wan_info) != SUCCESS )
		return FAILED;
	if((fp=fopen(VSERVER_SH_PATH,"w")) == NULL )
		return FAILED;
	
	Config_Read(MC_NET_CONFIG, &netconf);
	switch ( netconf.public_if ) {
	case PUBIF_PPPOE:
		strcpy(ext_if,"ppp0");
		break;
	case PUBIF_DHCPC:
	case PUBIF_FIXED:
	default:
		strcpy(ext_if,"eth0");
		break;
	}
	
	fprintf(fp,"#!/bin/sh\n");
	for(i=0;i<MAX_VSERVER_RULES;i++) {
		if((conf.rule[i].redirect_ip & netconf.private_netmask) != (netconf.private_ip & netconf.private_netmask)) {
			conf.rule[i].redirect_ip = netconf.private_ip & netconf.private_netmask;	
			conf.rule[i].port_end = 0;
			conf.rule[i].port = 0;	
			found = 1;
			continue;
		}
		if((conf.rule[i].port == 0) || !(conf.rule[i].redirect_ip & ~netconf.private_netmask))
			continue;
		if( conf.rule[i].protocol == 0)   //TCP
			strcpy(m_proto,"tcp");
		else
		if( conf.rule[i].protocol == 1)   //UDP
			strcpy(m_proto,"udp");
		else
		if( conf.rule[i].protocol == 2)  { //BOTH
			strcpy(m_proto,"tcp");
			if((conf.rule[i].port == conf.rule[i].port_end) || (conf.rule[i].port>0 && !conf.rule[i].port_end)) {	
				fprintf(fp,"%s -A PREROUTING -t nat -p %s -d %s --dport %d \\\n",IPTABLES_PATH,m_proto,wan_info.ipaddr,conf.rule[i].port);
				fprintf(fp,"-j DNAT --to %s:%d\n\n",webip2str(conf.rule[i].redirect_ip),conf.rule[i].port);
			
				fprintf(fp,"%s -A FORWARD -i %s -o eth1 -p %s --dport %d -j ACCEPT\n",IPTABLES_PATH,ext_if,m_proto,conf.rule[i].port);
			}
			else {
				fprintf(fp,"%s -A PREROUTING -t nat -p %s -d %s --dport %d:%d \\\n",IPTABLES_PATH,m_proto,wan_info.ipaddr,conf.rule[i].port, conf.rule[i].port_end);
				fprintf(fp,"-j DNAT --to %s:%d-%d\n\n",webip2str(conf.rule[i].redirect_ip),conf.rule[i].port,conf.rule[i].port_end);
			
				fprintf(fp,"%s -A FORWARD -i %s -o eth1 -p %s --dport %d:%d -j ACCEPT\n",IPTABLES_PATH,ext_if,m_proto,conf.rule[i].port, conf.rule[i].port_end);
			}
			strcpy(m_proto,"udp");
		}
		if((conf.rule[i].port == conf.rule[i].port_end) || (conf.rule[i].port>0 && !conf.rule[i].port_end)) {	
			fprintf(fp,"%s -A PREROUTING -t nat -p %s -d %s --dport %d \\\n",IPTABLES_PATH,m_proto,wan_info.ipaddr,conf.rule[i].port);
			fprintf(fp,"-j DNAT --to %s:%d\n\n",webip2str(conf.rule[i].redirect_ip),conf.rule[i].port);
		
			fprintf(fp,"%s -A FORWARD -i %s -o eth1 -p %s --dport %d -j ACCEPT\n",IPTABLES_PATH,ext_if,m_proto,conf.rule[i].port);
		}
		else {
			fprintf(fp,"%s -A PREROUTING -t nat -p %s -d %s --dport %d:%d \\\n",IPTABLES_PATH,m_proto,wan_info.ipaddr,conf.rule[i].port, conf.rule[i].port_end);
			fprintf(fp,"-j DNAT --to %s:%d-%d\n\n",webip2str(conf.rule[i].redirect_ip),conf.rule[i].port,conf.rule[i].port_end);
			
			fprintf(fp,"%s -A FORWARD -i %s -o eth1 -p %s --dport %d:%d -j ACCEPT\n",IPTABLES_PATH,ext_if,m_proto,conf.rule[i].port, conf.rule[i].port_end);
		}
	}
	fclose(fp);	
	if(found) Config_Write(MC_VSERVER_CONFIG, &conf) ;
	// chmod +x /sbin/vserver.sh
	chmod(VSERVER_SH_PATH,0711); 
	
	return SUCCESS;
}


BOOL VSERVER_Is_Enable()
{
	REG_VSERVER_CONF vconf;
	
	Config_Read(MC_VSERVER_CONFIG, &vconf);
	return vconf.enable;
	
}

#if 0
//====================================================================================//
//			URL Access configuration function		     	      //
//====================================================================================//
int URL_ACCESS_Create_Setup_File(void)
{
	int i;
	FILE *fp;
	REG_URL_ACCESS_CONF conf;
	
	if( Config_Read(MC_URL_ACCESS_CONFIG, &conf) != SUCCESS )
		return FAILED;
	
	if ( !conf.enable ) {
		unlink(URL_ACCESS_SH_PATH);
		return SUCCESS;
	}

	if((fp=fopen(URL_ACCESS_SH_PATH,"w")) == NULL )
		return FAILED;
		
	fprintf(fp,"#!/bin/sh\n");
	for(i=0;i<MAX_URL_ACCESS_RULES;i++) {
		if(strcasecmp(conf.url[i],"")!=0)
			fprintf(fp,"%s -A FORWARD -p tcp -d %s --dport 80 -j DROP \n",IPTABLES_PATH,conf.url[i]);
	}
	fclose(fp);
	
	// chmod +x /sbin/url.sh
	chmod(URL_ACCESS_SH_PATH,0711);  
	
	return SUCCESS;
}

BOOL URL_ACCESS_Is_Enable()
{
	REG_URL_ACCESS_CONF conf;
	
	Config_Read(MC_URL_ACCESS_CONFIG, &conf);
	return conf.enable;
}
#endif

//====================================================================================//
//			IP Access configuration function		     	      //
//====================================================================================//
int IP_ACCESS_Create_Setup_File(void)
{
	int i,j;
	FILE *fp;
	
	REG_IP_ACCESS_CONF conf;
	
	if( Config_Read(MC_IP_ACCESS_CONFIG, &conf) != SUCCESS )
		return FAILED;
	
	if ( !conf.enable ) {
		unlink(IP_ACCESS_SH_PATH);
		return SUCCESS;
	}
	if((fp=fopen(IP_ACCESS_SH_PATH,"w")) == NULL )
		return FAILED;
	
	
	fprintf(fp,"#!/bin/sh\n");
#ifdef SG100
	fprintf(fp,"iptables -I FORWARD 1 -p tcp --dport 1863 -j REJECT\n");
	fprintf(fp,"iptables -I FORWARD 1 -p tcp -d messenger.hotmail.com -j REJECT\n");
#endif
	for(i=0;i<MAX_IP_ACCESS_GROUPS;i++) {
		if(strcasecmp("0.0.0.0",webip2str(conf.rule[i].ip)) == 0 ) continue;
		
		if (conf.rule[i].block_range_start!= 0 && conf.rule[i].block_range_end !=0) {
			if(conf.rule[i].proto == 0 || conf.rule[i].proto == 2)
				fprintf(fp,"%s -I FORWARD 1 -p tcp -s %s/%d  --dport %d:%d -j DROP\n",IPTABLES_PATH,webip2str(conf.rule[i].ip),conf.rule[i].CIDR_mask_no,conf.rule[i].block_range_start,conf.rule[i].block_range_end);
			if(conf.rule[i].proto == 1 || conf.rule[i].proto == 2)
				fprintf(fp,"%s -I FORWARD 1 -p udp -s %s/%d  --dport %d:%d -j DROP\n",IPTABLES_PATH,webip2str(conf.rule[i].ip),conf.rule[i].CIDR_mask_no,conf.rule[i].block_range_start,conf.rule[i].block_range_end);
		}
		
		for(j=0;j<4;j++) {
			if( conf.rule[i].block_port[j]	!= 0 ) {
				if(conf.rule[i].proto == 0 || conf.rule[i].proto == 2)	
					fprintf(fp,"%s -I FORWARD 1 -p tcp -s %s/%d  --dport %d -j DROP\n",IPTABLES_PATH,webip2str(conf.rule[i].ip),conf.rule[i].CIDR_mask_no, conf.rule[i].block_port[j]);
				if(conf.rule[i].proto == 1 || conf.rule[i].proto == 2)	
					fprintf(fp,"%s -I FORWARD 1 -p udp -s %s/%d  --dport %d -j DROP\n",IPTABLES_PATH,webip2str(conf.rule[i].ip),conf.rule[i].CIDR_mask_no, conf.rule[i].block_port[j]);
			}
		}
		
	}
		
	fclose(fp);
	
	// chmod +x /sbin/ip.sh
	chmod(IP_ACCESS_SH_PATH,S_IXGRP | S_IXUSR | S_IXOTH );
	
	return SUCCESS;
}

BOOL IP_ACCESS_Is_Enable()
{
	REG_IP_ACCESS_CONF conf;
	
	Config_Read(MC_IP_ACCESS_CONFIG, &conf);
	return conf.enable;
}


//====================================================================================//
//			IP Access configuration function		     	      //
//====================================================================================//
BOOL ANTIHACK_Is_Enable()
{
	REG_ANTIHACK_CONF conf;
	
	Config_Read(MC_ANTIHACK_CONFIG, &conf);
	
	return conf.enable;
}

int ANTIHACK_Create_Setup_File(void)
{
	REG_ANTIHACK_CONF reg_conf;
	FILE *fp;
	REG_NET_CONF netconf;
	char wandev[5];
	
	if( Config_Read(MC_ANTIHACK_CONFIG, &reg_conf) != SUCCESS )
		return FAILED;

	if ( !reg_conf.enable ) {
		unlink(ANTIHACK_SH_PATH);
		return SUCCESS;
	}
	
	if(PPPOE_Is_Enable()) 
		strcpy(wandev,"ppp0");
	else
		strcpy(wandev,"eth0");
	
	Config_Read(MC_NET_CONFIG, &netconf);
	
	if((fp=fopen(ANTIHACK_SH_PATH,"w")) == NULL )
		return FAILED;
		
	fprintf(fp,"#!/bin/sh\n");
	if(reg_conf.EN_IP_SPOOF) 
		fprintf(fp,"%s -A INPUT -s %s/%s -i %s -j DROP\n",IPTABLES_PATH,webip2str(netconf.private_ip),webip2str(netconf.private_netmask),wandev);
	
	if(reg_conf.EN_PORT_SCAN) {
		fprintf(fp,"%s -A INPUT -i %s -p tcp --tcp-flags SYN,ACK,FIN,RST RST -m limit --limit 1/s -j ACCEPT\n",IPTABLES_PATH,wandev);
		fprintf(fp,"%s -A INPUT -i %s -p tcp --tcp-flags SYN,ACK,FIN,RST RST -j DROP\n",IPTABLES_PATH,wandev);
	}
	
	if(reg_conf.EN_PING_DEATH){
		fprintf(fp,"%s -A INPUT -i %s -p icmp --icmp-type echo-request -m limit --limit 1/s -j ACCEPT\n",IPTABLES_PATH,wandev);
		fprintf(fp,"%s -A INPUT -i %s -p icmp --icmp-type echo-request -j DROP\n",IPTABLES_PATH,wandev);
	}
	
	if(reg_conf.EN_SYNFLOOD) {
		fprintf(fp,"%s -A INPUT -i %s -p tcp --syn -m limit --limit %d/s -j ACCEPT\n",IPTABLES_PATH,wandev,reg_conf.syn_limit);
		fprintf(fp,"%s -A INPUT -i %s -p tcp --syn -j DROP\n",IPTABLES_PATH,wandev);
	}
	
	if(reg_conf.EN_ICMPFLOOD) {
		fprintf(fp,"%s -A INPUT -i %s -p icmp -m limit --limit %d/s -j ACCEPT\n",IPTABLES_PATH,wandev,reg_conf.icmp_limit);
		fprintf(fp,"%s -A INPUT -i %s -p icmp -j DROP\n",IPTABLES_PATH,wandev);
	}
	
	if(reg_conf.EN_UDPFLOOD) {
		fprintf(fp,"%s -A INPUT -i %s -p udp -m limit --limit %d/s -j ACCEPT\n",IPTABLES_PATH,wandev,reg_conf.udp_limit);
		//fprintf(fp,"%s -A INPUT -i %s -p udp -j DROP\n",IPTABLES_PATH,wandev);
	}
	
	fclose(fp);
	
	// chmod +x /sbin/ip.sh
	chmod(ANTIHACK_SH_PATH,0711 );
	
	return SUCCESS;
}
