#include "libconf.h"
#include <ctype.h>
#include <dirent.h>

#define READ_BUF_SIZE   50

static pid_t* find_pid_by_name( char* pidName)
{
    DIR *dir;
    struct dirent *next;
    pid_t* pidList=NULL;
    int i=0;
    
    dir = opendir("/proc");
    if (!dir)
        printf("Cannot open /proc");
        
    while ((next = readdir(dir)) != NULL) {
        FILE *status;
        char filename[READ_BUF_SIZE];
        char buffer[READ_BUF_SIZE];
        char name[READ_BUF_SIZE];

        /* If it isn't a number, we don't want it */
        if (!isdigit(*next->d_name))
            continue;

	sprintf(filename, "/proc/%s/status", next->d_name);
        if (! (status = fopen(filename, "r")) ) {
            continue;
        }
        if (fgets(buffer, READ_BUF_SIZE-1, status) == NULL) {
            fclose(status);
            continue;
        }
        fclose(status);

        /* Buffer should contain a string like "Name:   binary_name" */
        sscanf(buffer, "%*s %s", name);
        if (strcmp(name, pidName) == 0) {
            pidList=realloc( pidList, sizeof(pid_t) * (i+2));
            pidList[i++]=strtol(next->d_name, NULL, 0);
        }
    }

    if (pidList)
        pidList[i]=0;
    return pidList;
}

int mct_killall(char *appname, int sig)
{
	int all_found = TRUE;
	pid_t myPid=getpid();
	pid_t* pidList;

            pidList = find_pid_by_name(appname);
            if (!pidList) {
                all_found = FALSE;
                printf( "%s: no process killed", appname);
            }
    
            for(; pidList && *pidList!=0; pidList++) {
                if (*pidList==myPid)
                    continue;
                if (kill(*pidList, sig) != 0)
                    printf( "Could not kill pid '%d',sig=%d\n", *pidList,sig);
            }	
	
	
}

