/********************************************************************************
*
*	Copyright (c) 2002  Magic Control Technology Co.  All Rights Reserved.
*
*	FILE:
*		nic.c
*
*	Abstract:
*		 network inforamtion function
*		
*	History:
*		2002/1/24	Louis Tsai Added
*********************************************************************************/
#include <asm/mconfig.h>
#include "libconf.h"

// modified by Ethan on 12/04/2002 to meet uclibc requirement
#define SA_LEN(x)	6

char *webip2str(unsigned long ip)
{
	static int index=0;
	static char buf[6][32];

	index = (index + 1) % 6;
	sprintf(buf[index], "%d.%d.%d.%d",
		(unsigned int) (ip & 0xff),
		(unsigned int) ((ip >> 8) & 0xff),
		(unsigned int) ((ip >> 16) & 0xff),
		(unsigned int) ((ip >> 24) & 0xff));

	return buf[index];
}

/***********************************************************/
/*  	local function used to parse proc file 	           */
/***********************************************************/

int get_default_gw(char *dev, struct sockaddr_in *gw)
{
        char			str[256];
        FILE			*fptr;
        struct sockaddr_in	sin;
        int			cnt=0;
	char			route_file[]={"/proc/net/route"};
	char			seps[] = " \t\n";
	char			*token;

        fptr=fopen(route_file, "r");
        fgets(str, 256, fptr);
        while (fgets(str, 256, fptr) != NULL)
	{
                token = strtok(str, seps);
                if(token == NULL)
                        continue;

		/* check if our device name? */
                if(strcmp(token, dev))
                        continue;
                token = strtok(NULL, seps);

		/* check if destinition is 0.0.0.0 */
                sin.sin_addr.s_addr = (uint32_t)strtoul(token, NULL, 16);
		if (sin.sin_addr.s_addr!=0)
			continue;

		/* get default gw address */
                token = strtok(NULL, seps);
                sin.sin_addr.s_addr = (uint32_t)strtoul(token, NULL, 16);
                gw->sin_addr.s_addr = sin.sin_addr.s_addr;
                cnt++;
        }
        fclose(fptr);
	if (cnt==0)
		return NIC_FAIL;
	else
		return SUCCESS;
}

int nic_get_info(char *ifdev_name, NIC_INFO *pif)
{
        char 			*inbuf=NULL;
        struct ifconf		ifc;
        struct ifreq		ifreq, *ifrp;
        struct ifreq		ifrm;
        int			i, siz, len=8192;
        char			ifrbuf[8192];
        unsigned char	*ptr;
        struct sockaddr_in	*sin;
	int			s;
	char			name[30];
	struct sockaddr_in	netmask;
	struct sockaddr_in	broadcast;
	struct sockaddr_in	gw;

	/* reset to default */
	strcpy(pif->ipaddr, "");
	strcpy(pif->netmask, "");
	strcpy(pif->gateway, "");
	strcpy(pif->broadcast, "");
	strcpy(pif->dev,ifdev_name);
	
        memset(&ifrm, 0, sizeof(struct ifreq));
        strcpy(ifrm.ifr_name, pif->dev);

	s=socket(AF_INET, SOCK_DGRAM, 0);
        if (s<0)
                return NIC_FAIL;

        while (1)
	{
                ifc.ifc_len=len;
                ifc.ifc_buf=inbuf=calloc(1, len);
                if (inbuf==NULL)
                        return NIC_FAIL;
                if (ioctl(s, SIOCGIFCONF, &ifc)<0)
			goto nic_get_info_fail;
                if ((ifc.ifc_len+sizeof(ifreq))<len)
                        break;
                len *= 2;
        }

        ifrp = ifc.ifc_req;
        ifreq.ifr_name[0] = '\0';
        for (i = 0; i < ifc.ifc_len; )
	{
                ifrp = (struct ifreq *)((caddr_t)ifc.ifc_req + i);
                memcpy(ifrbuf, ifrp, sizeof(*ifrp));
#ifndef HOST_TEST
                siz = SA_LEN(&(((struct ifreq *)ifrbuf)->ifr_addr));
#else
		siz = sizeof(struct sockaddr);
#endif
                
                if (siz < sizeof(ifrp->ifr_addr))
                        siz = sizeof(ifrp->ifr_addr);
                siz += sizeof(ifrp->ifr_name);
                i += siz;
                /* avoid alignment issue */
                if (sizeof(ifrbuf) < siz)
			goto nic_get_info_fail;
                memcpy(ifrbuf, ifrp, siz);
                ifrp = (struct ifreq *)ifrbuf;

//printf("ifrm.ifr_name = %s ifrp->ifr_name = %s \n",ifrm.ifr_name,ifrp->ifr_name);

                if (strncmp(ifrm.ifr_name, ifrp->ifr_name, sizeof(ifrp->ifr_name)))
                        continue;
        
                strncpy(name, ifrp->ifr_name, sizeof(ifrp->ifr_name));
                sin = (struct sockaddr_in *)&ifrp->ifr_addr;
                // IP Address

                sprintf(pif->ipaddr, "%s", inet_ntoa(sin->sin_addr));
		// Broadcast Address
                if (ioctl(s, SIOCGIFBRDADDR, (caddr_t)ifrp) < 0)
			goto nic_get_info_fail;
                broadcast.sin_addr = ((struct sockaddr_in *)&(ifrp->ifr_addr))->sin_addr;
                sprintf(pif->broadcast, "%s", inet_ntoa(broadcast.sin_addr));
		// Netmask address
                if (ioctl(s, SIOCGIFNETMASK, (caddr_t)ifrp) < 0)
			goto nic_get_info_fail;
                netmask.sin_addr = ((struct sockaddr_in *)&(ifrp->ifr_addr))->sin_addr;
                sprintf(pif->netmask, "%s", inet_ntoa(netmask.sin_addr));
                // Gateway Address
                if (get_default_gw(ifrp->ifr_name, &gw)==SUCCESS)
                        sprintf(pif->gateway, "%s", inet_ntoa(gw.sin_addr));
		else
			sprintf(pif->gateway, "0.0.0.0");
		
		break;
        }
  
        strcpy(ifrp->ifr_name, ifdev_name);
        if (ioctl(s, SIOCGIFHWADDR, (caddr_t)ifrp) < 0)
		goto nic_get_info_fail;
        // MAC Address
        ptr = &(ifrp->ifr_hwaddr.sa_data[0]);
        sprintf(pif->hwaddr, "%.2X:%.2X:%.2X:%.2X:%.2X:%.2X", ptr[0], ptr[1], ptr[2], ptr[3], ptr[4], ptr[5]);
        free(inbuf);
        if (ioctl(s, SIOCGIFFLAGS, &ifrm) < 0)
                return NIC_FAIL;
        if (!( ifrm.ifr_flags & 1))
                return NIC_FAIL;
        return SUCCESS;
  
nic_get_info_fail:
	free(inbuf);
	return NIC_FAIL;
}

/***********************************************************/
/*  get external network interface information		   */
/***********************************************************/

int NIC_Get_WAN_Info(NIC_INFO *info)
{
	int ret;
	if( PPPOE_Is_Enable() )
		ret = nic_get_info("ppp0", info);
	else
		ret = nic_get_info("eth0", info);
	return ret;
}

/***********************************************************/
/*  get internal network interface information		   */
/***********************************************************/

int NIC_Get_LAN_Info(NIC_INFO *info)
{
	return nic_get_info("eth1",info);
}


/***********************************************************/
/*  Get the routing information from /proc/net/route and   */
/*  put into link list memory buffer, please remember to   */
/*  use NIC_Free_Route_Info() to relase it .		   */
/***********************************************************/

NIC_ROUTE_INFO *NIC_Get_Route_Info(int *list_cnt)
{
	char buff[256];
	int  nl = 0 ;
	struct in_addr dest;
	struct in_addr gw;
	struct in_addr mask;
	int flgs, ref, use, metric;
	char flags[4];
	unsigned long int d,g,m;

	char sdest[16], sgw[16];
	NIC_ROUTE_INFO *start,*info,*pre;

	FILE *fp = fopen("/proc/net/route", "r");
	
	info = (NIC_ROUTE_INFO *) malloc(sizeof(NIC_ROUTE_INFO));
	start = info;
	while( fgets(buff, sizeof(buff), fp) != NULL ) {
		if(nl) {
			int ifl = 0;
			while(buff[ifl]!=' ' && buff[ifl]!='\t' && buff[ifl]!='\0')
				ifl++;
			buff[ifl]=0;    /* interface */
			sscanf(buff+ifl+1, "%lx%lx%d%d%d%d%lx",&d, &g, &flgs, &ref, &use, &metric, &m);	
			ifl = 0;        /* parse flags */
			if(flgs&1)
				flags[ifl++]='U';
			if(flgs&2)
				flags[ifl++]='G';
			if(flgs&4)
				flags[ifl++]='H';
			flags[ifl]=0;
			dest.s_addr = d;
			gw.s_addr   = g;
			mask.s_addr = m;
			strcpy(sdest,  (dest.s_addr==0 ? "default" :
					inet_ntoa(dest)));
			strcpy(sgw,    (gw.s_addr==0   ? "*"       :
					inet_ntoa(gw)));
			
			strcpy(info->ifdev , buff);
			strcpy(info->netmask , inet_ntoa(mask));
			strcpy(info->gateway , sgw );
			strcpy(info->desti, sdest );
			
			info->next = (NIC_ROUTE_INFO *) malloc(sizeof(NIC_ROUTE_INFO));
			pre  = info;
			info = info->next;	
		}
	nl++;
	}
	
	pre->next = NULL;
	free(info);

	*list_cnt = nl - 1;
	if(nl == 0 ) 
		return NULL;
	else
		return start;
}

/***********************************************************/
/*  free memory got from NIC_Get_Route_Info()		   */
/***********************************************************/

void NIC_Free_Route_Info(NIC_ROUTE_INFO *info)
{
	NIC_ROUTE_INFO *tmp;
	while(info !=NULL) {
		tmp = info->next;	
		free(info);
		info=tmp;
	}
}

int MCT_Set_Hosts_File()
{
	NIC_INFO info;
	
	if( NIC_Get_WAN_Info(&info) == SUCCESS) {
		FILE *fp;
		REG_NET_CONF netconf;
		
		Config_Read(MC_NET_CONFIG, &netconf);
		fp = fopen(HOSTS_PATH,"w");
		if(fp == NULL ) return FAILED;	
		fprintf(fp,"127.0.0.1\tlocalhost\n");
		fprintf(fp,"%s\t%s\n", info.ipaddr, netconf.hostname);
		fprintf(fp,"%s\t%s\n", webip2str(netconf.private_ip), netconf.hostname);
		fclose(fp);
	}
	else {
		FILE *fp;
		REG_NET_CONF netconf;
		
		Config_Read(MC_NET_CONFIG, &netconf);
		fp = fopen(HOSTS_PATH,"w");
		if(fp == NULL ) return FAILED;	
		fprintf(fp,"127.0.0.1\tlocalhost\n");
		fprintf(fp,"%s\t%s\n", webip2str(netconf.private_ip), netconf.hostname);
		fclose(fp);
	}
		
	return SUCCESS;
	
}

int MCT_Update_Resolv_File()
{
	FILE *fp;
	REG_NET_CONF netconf;
	
	Config_Read(MC_NET_CONFIG, &netconf);

	fp = fopen(DNS_CONF_PATH,"w");
	if(fp == NULL ) return FAILED;
	
	if( netconf.dns0 != 0 )
		fprintf(fp, "nameserver %s\n", webip2str(netconf.dns0));
	if( netconf.dns1 != 0 )
		fprintf(fp, "nameserver %s\n", webip2str(netconf.dns1));	
	if( netconf.dns2 != 0 )
		fprintf(fp, "nameserver %s\n", webip2str(netconf.dns2));
	
	fclose(fp);
	
	return SUCCESS;
}

int MCT_Clean_Resolv_File()
{
	FILE *fp;
	
	fp = fopen(DNS_CONF_PATH,"w");
	if(fp == NULL ) return FAILED;	
	fclose(fp);
	
	return SUCCESS;
}
//====================================================================================//
//			PPTP/ADSL configuration function		     		      //
//====================================================================================//
void PPTPC_Create_Setup_File()
{
	REG_NET_CONF netconf;
	FILE *fp;
	
	Config_Read(MC_NET_CONFIG, &netconf);	

	fp = fopen(PPTPC_OPTIONS_PATH, "w");
	if( fp == NULL ) return FAILED;
	
	fprintf(fp,"name %s\n",netconf.pptp_username);
	fprintf(fp,"noauth\n");
	fprintf(fp,"noipdefault\n");
	fprintf(fp,"defaultroute\n");
	fprintf(fp,"mtu 1492\n");
	fprintf(fp,"mru 2400\n");
	
	
	fclose(fp);
	//Create /etc/ppp/pap-secrests
	fp = fopen(PPPOE_PAP_PATH,"w");
	fprintf(fp,"\"%s\"	*	\"%s\"\n", netconf.pptp_username, netconf.pptp_password);
	fclose(fp);
	
	//Create /etc/ppp/chap-secrests
	fp = fopen(PPPOE_CHAP_PATH,"w");
	fprintf(fp,"\"%s\"	*	\"%s\"\n", netconf.pptp_username, netconf.pptp_password);
	fclose(fp);
}

//====================================================================================//
//			PPPOE configuration function		     		      //
//====================================================================================//

BOOL PPPOE_Is_Enable()
{
	REG_NET_CONF netconf;
	Config_Read(MC_NET_CONFIG, &netconf);
	return (netconf.public_if == PUBIF_PPPOE) ? TRUE : FALSE;
}

int PPPOE_Get_Status(void)
{ 
	NIC_INFO info;
	if( nic_get_info("ppp0",&info) == SUCCESS ) {
		int pppd_pid;
		pppd_pid = MCT_Getpid("pppoe");

		if(pppd_pid == -1) 
			return PPPOE_LINKDOWN;
		else
			return PPPOE_LINKUP;
	}
	else
		return PPPOE_LINKDOWN;
/*			
	
*/
}

unsigned long PPPOE_Get_Connection_Time()
{
	int pppd_pid;
	
	pppd_pid = MCT_Getpid("pppoe");
	
	if(pppd_pid != -1) 
		return MCT_Get_Process_Life_Time(pppd_pid);
	else
		return 0;
}

int PPPOE_Create_Setup_File()
{
	REG_NET_CONF netconf;
	FILE *fp;
	
	Config_Read(MC_NET_CONFIG, &netconf);	

	fp = fopen(PPPOE_CONF_PATH, "w");
	if( fp == NULL ) return FAILED;
	
	//Create /etc/ppp/pppoe.conf
	fprintf(fp,"ETH=eth0\n");
	fprintf(fp,"USER=%s\n", netconf.username);
/*	
	if( netconf.demand && netconf.idle > 0)
		fprintf(fp,"DEMAND=%d\n", netconf.idle*60);
	else
*/
		fprintf(fp,"DEMAND=no\n");
		
	fprintf(fp,"USEPEERDNS=yes\n");
	fprintf(fp,"CONNECT_TIMEOUT=60\n");
	fprintf(fp,"CONNECT_POLL=6\n");
	fprintf(fp,"PING=\".\"\n");
	fprintf(fp,"CF_BASE=`basename $CONFIG`\n");
	fprintf(fp,"PIDFILE=\"/var/run/$CF_BASE-adsl.pid\"\n");
	fprintf(fp,"SYNCHRONOUS=no\n");
	fprintf(fp,"CLAMPMSS=1412\n");
	fprintf(fp,"LCP_INTERVAL=20\nLCP_FAILURE=3\n");
	fprintf(fp,"PPPOE_TIMEOUT=80\nFIREWALL=NONE\n");
	fprintf(fp,"PPPOE_EXTRA=\"\"\nPPPD_EXTRA=\"\"\n");
	fprintf(fp,"DEVICE=ppp0\nBOOT=no\n");
	
	fclose(fp);
	//Create /etc/ppp/pap-secrests
	fp = fopen(PPPOE_PAP_PATH,"w");
	fprintf(fp,"\"%s\"	*	\"%s\"\n", netconf.username, netconf.password);
	fclose(fp);
	
	//Create /etc/ppp/chap-secrests
	//fp = fopen(PPPOE_CHAP_PATH,"w");
	//fprintf(fp,"\"%s\"	*	\"%s\"\n",info.user_name,info.password);
	//fclose(fp);
	
	return SUCCESS;
}

void PPPOE_Start_Connection()
{
	if(!PPPOE_Get_Status())
		system("/usr/sbin/adsl-start");		
}


void PPPOE_Stop_Connection()
{
	if(PPPOE_Get_Status())
		system("/usr/sbin/adsl-stop");	
}

//====================================================================================//
//			IP Alias configuration function		     		      //
//====================================================================================//

int IPALIAS_Create_Setup_File()
{
	FILE *fp;
	REG_IPALIAS_CONF ipaliasconf;
	char str_ip[20],str_nm[20];
	
	Config_Read(MC_IPALIAS_CONFIG, &ipaliasconf);
	if ( ipaliasconf.alias_ip0 == 0 && ipaliasconf.alias_ip1 == 0 && ipaliasconf.alias_ip2 == 0 ) {
		unlink(IPALIAS_SH_PATH);
		return SUCCESS;
	}
	
	if((fp=fopen(IPALIAS_SH_PATH,"w")) == NULL )
		return FAILED;
		
	fprintf(fp,"#!/bin/sh\n");
	if(ipaliasconf.alias_ip0 != 0 ) {
		struct in_addr tmp;
		
		tmp.s_addr = ipaliasconf.alias_ip0;
		sprintf(str_ip,"%s",inet_ntoa(tmp));
		
		tmp.s_addr = ipaliasconf.alias_netmask0;
		sprintf(str_nm,"%s",inet_ntoa(tmp));		      
		
		fprintf(fp,"/sbin/ifconfig eth1:1 %s netmask %s\n",str_ip,str_nm);
	}
	
	if(ipaliasconf.alias_ip1 != 0 ) {
		struct in_addr tmp;
		
		tmp.s_addr = ipaliasconf.alias_ip1;
		sprintf(str_ip,"%s",inet_ntoa(tmp));
		
		tmp.s_addr = ipaliasconf.alias_netmask1;
		sprintf(str_nm,"%s",inet_ntoa(tmp));		      
		
		fprintf(fp,"/sbin/ifconfig eth1:2 %s netmask %s\n",str_ip,str_nm);
	}
	
	if(ipaliasconf.alias_ip2 != 0 ) {
		struct in_addr tmp;
		
		tmp.s_addr = ipaliasconf.alias_ip2;
		sprintf(str_ip,"%s",inet_ntoa(tmp));
		
		tmp.s_addr = ipaliasconf.alias_netmask2;
		sprintf(str_nm,"%s",inet_ntoa(tmp));		      
		
		fprintf(fp,"/sbin/ifconfig eth1:3 %s netmask %s\n",str_ip,str_nm);
	}
	
	
	
	fclose(fp);
	
	chmod(IPALIAS_SH_PATH,0711 );
	return 1;
}

int Multi_NAT_Create_Setup_File()
{
	FILE *fp;
	REG_MNAT_CONF mnatconf;
	REG_NET_CONF netconf;
	char in_ip[20],ext_ip_start[20],ext_ip_end[20];
	struct in_addr tmp;
		
	Config_Read(MC_MNAT_CONFIG, &mnatconf);
	Config_Read(MC_NET_CONFIG, &netconf);

	if ( mnatconf.mnat_in_ipstart0 == 0 && mnatconf.mnat_in_ipstart1 == 0 ) {
		unlink(MNAT_SH_PATH);
		return SUCCESS;
	}
	
	if((fp=fopen(MNAT_SH_PATH,"w")) == NULL )
		return FAILED;
		
	fprintf(fp,"#!/bin/sh\n");
#if 0
	fprintf(fp,"echo \"enabling forwarding\"\n");
	fprintf(fp,"echo \"1\" > /proc/sys/net/ipv4/ip_forward\n");
	fprintf(fp,"echo \"enabling DynamicAddr..\"\n");
	fprintf(fp,"echo \"1\" > /proc/sys/net/ipv4/ip_dynaddr\n");
	fprintf(fp,"echo \"clearing any existing rules and setting default policy..\"\n");
	fprintf(fp,"/sbin/iptables -P INPUT ACCEPT\n");
	fprintf(fp,"/sbin/iptables -F INPUT\n");
	fprintf(fp,"/sbin/iptables -P OUTPUT ACCEPT\n");
	fprintf(fp,"/sbin/iptables -F OUTPUT\n");
	fprintf(fp,"/sbin/iptables -P FORWARD ACCEPT\n");
	fprintf(fp,"/sbin/iptables -F FORWARD\n");
	fprintf(fp,"/sbin/iptables -t nat -F\n");
#endif
	
	if (mnatconf.mnat_in_ipstart0 != 0) {
		int i,start,end,cnt=4;
		//setup output interface first
		start = (mnatconf.mnat_ext_ipstart0 >> 24) & 0xff ;
		end  =  mnatconf.mnat_ext_end0 ;
		
		if(end <= start) return -1; // conflict range
		
		for(i=start; i<=end; i++) {
			tmp.s_addr = ( mnatconf.mnat_ext_ipstart0 & 0x00ffffff ) | (i<<24);
			sprintf(ext_ip_start,"%s",inet_ntoa(tmp));	      
			fprintf(fp,"/sbin/ifconfig eth0:%d %s\n",cnt++,ext_ip_start);
		}
		
		tmp.s_addr = mnatconf.mnat_ext_ipstart0;
		sprintf(ext_ip_start,"%s",inet_ntoa(tmp));
		tmp.s_addr =( mnatconf.mnat_ext_ipstart0 & 0x00ffffff ) | (mnatconf.mnat_ext_end0<<24) ;
		sprintf(ext_ip_end,"%s",inet_ntoa(tmp));
		tmp.s_addr = mnatconf.mnat_in_ipstart0 ;
		sprintf(in_ip,"%s",inet_ntoa(tmp));
		
		
		
		if(netconf.public_if == PUBIF_PPPOE)//external interface is ppp0
			fprintf(fp,"/sbin/iptables -t nat -A POSTROUTING -s %s/%d -o ppp0 \\\n-j SNAT --to %s-%s\n",
				in_ip,mnatconf.mnat_in_nm0,ext_ip_start,ext_ip_end);
		else
			fprintf(fp,"/sbin/iptables -t nat -A POSTROUTING -s %s/%d -o eth0 \\\n-j SNAT --to %s-%s\n",
				in_ip,mnatconf.mnat_in_nm0,ext_ip_start,ext_ip_end);
		
		
	}
	
	if (mnatconf.mnat_in_ipstart1 != 0) {
		int i,start,end,cnt=4;
		//setup output interface first
		start = (mnatconf.mnat_ext_ipstart1 >> 24) & 0xff ;
		end  =  mnatconf.mnat_ext_end1 ;
		
		if(end <= start) return -1; // conflict range
		
		for(i=start; i<=end; i++) {
			tmp.s_addr = ( mnatconf.mnat_ext_ipstart1 & 0x00ffffff ) | (i<<24);
			sprintf(ext_ip_start,"%s",inet_ntoa(tmp));	      
			fprintf(fp,"/sbin/ifconfig eth0:%d %s\n",cnt++,ext_ip_start);
		}
		
		tmp.s_addr = mnatconf.mnat_ext_ipstart1;
		sprintf(ext_ip_start,"%s",inet_ntoa(tmp));
		tmp.s_addr =( mnatconf.mnat_ext_ipstart1 & 0x00ffffff ) | (mnatconf.mnat_ext_end1<<24) ;
		sprintf(ext_ip_end,"%s",inet_ntoa(tmp));
		tmp.s_addr = mnatconf.mnat_in_ipstart1 ;
		sprintf(in_ip,"%s",inet_ntoa(tmp));
		
		if(netconf.public_if == PUBIF_PPPOE)//external interface is ppp0
			fprintf(fp,"iptables -t nat -A POSTROUTING -s %s/%d -o ppp0 \\\n-j SNAT --to %s-%s\n",
				in_ip,mnatconf.mnat_in_nm1,ext_ip_start,ext_ip_end);
		else
			fprintf(fp,"iptables -t nat -A POSTROUTING -s %s/%d -o eth0 \\\n-j SNAT --to %s-%s\n",
				in_ip,mnatconf.mnat_in_nm1,ext_ip_start,ext_ip_end);
	}
	
	fclose(fp);
	
	chmod(MNAT_SH_PATH, 0711);
	return 1;
	
	
}

//====================================================================================//
//			DDNS configuration function		     		      //
//====================================================================================//
void DDNS_Create_Setup_File()
{
	REG_DDNS_CONF ddnsconf;
	REG_NET_CONF netconf;
	
	FILE *fp;
	
	Config_Read(MC_DDNS_CONFIG,&ddnsconf);
	Config_Read(MC_NET_CONFIG, &netconf);

	fp = fopen(DDNS_CONF_PATH, "w");
	if( fp == NULL ) return FAILED;
	
	switch(ddnsconf.service_type) 
	{
	case DDNS_DHS:
		fprintf(fp,"service-type=dhs\n");
		break;
	case DDNS_DYNDNS:
		fprintf(fp,"service-type=dyndns\n");
		fprintf(fp,"max-interval=2073600\n");
		break;
	case DDNS_DYNS:
		fprintf(fp,"service-type=dyns\n");
		break;
	case DDNS_EASYDNS:
		fprintf(fp,"service-type=easydns\n");
		break;
	case DDNS_JUSTLINUX:
		fprintf(fp,"service-type=justlinux\n");
		break;
	case DDNS_ODS:
		fprintf(fp,"service-type=ods\n");
		break;
	case DDNS_PGPOW:
		fprintf(fp,"service-type=pgpow\n");
		break;
	case DDNS_TZO:
		fprintf(fp,"service-type=tzo\n");
		fprintf(fp,"max-interval=2073600\n");
		break;
	}
	
	
	fprintf(fp,"user=%s:%s\n",ddnsconf.username,ddnsconf.password);
	fprintf(fp,"host=%s\n",ddnsconf.hostname);
	
	
	if(netconf.public_if == PUBIF_PPPOE || netconf.public_if== PUBIF_PPTPC)
		fprintf(fp,"interface=ppp0\n");
	else
		fprintf(fp,"interface=eth0\n");
	
	
	fprintf(fp,"cache-file=/tmp/ez-ipupdate.cache\n");
	
	fclose(fp);
}

//==================================================
//Big Pond Advancd Cable Modem Authentication toool
//=================================================

int gen_bpaconf()
{
	REG_BPA_CONF bpaconf;

	Config_Read(MC_BPA_CONFIG,&bpaconf);
	if(bpaconf.enable) {
		FILE *fp;
		fp = fopen(BPA_CONF_PATH, "w");

		if(fp == NULL)	return FAILED;
		fprintf(fp,"username = %s\n",bpaconf.username);
		fprintf(fp,"password = %s\n",bpaconf.passwd);
		fclose(fp);
	}
	
	return 0;	
}
