/********************************************************************************
*
*	Copyright (c) 2002  Magic Control Technology Co.  All Rights Reserved.
*
*	FILE:
*		testlib.c
*
*	Abstract: 
*		test program for mlinux lib
*
*	HISTORY:
*		2002/1/22	Louis Tsai Created
*********************************************************************************/

#include <stdio.h>
#include <string.h>
#include "libconf.h"

char * time2asc(time_t louis)
{
	
	static char *buffer= NULL;
	struct tm *t;
	
	
	if(buffer != NULL ) free( buffer);
	
	buffer = (char *) malloc(64);
	t = gmtime (&louis);
	sprintf (buffer,"%d %d/%02d/%02d %02d:%02d:%02d",
		 t -> tm_wday, t -> tm_year + 1900,
		 t -> tm_mon + 1, t -> tm_mday,
		 t -> tm_hour, t -> tm_min, t -> tm_sec);
	
	return buffer;
}

int main()
{
	LOG_SYS log;
	int i;
	REG_SYS_CONF	sys_conf;
	
//	Init_Flash_Data();
	
	printf("read system configuration data\n");
	read_config(MC_SYS_CONFIG, &sys_conf);
	printf("version = %04x, model name = \"%s\"\n", sys_conf.version, sys_conf.model_name);
	
	MCT_Add_Logs("1",0);
	MCT_Add_Logs("2",1);
	MCT_Add_Logs("3",2);
	
	MCT_Get_Logs(&log);
	
	for(i=0;i<log.count;i++) printf("%s %s\n",ctime(&log.date[i]),log.msg[i]);
	
	
	
	
/*	
	
	NIC_INFO nic_info;
	NIC_CONF nic_conf,nic2_conf;
	NIC_ROUTE_INFO *route_info,*tmp;
	NIC_PPPOE_CONF pppoe_conf,pppoe1_conf;
	
	DHCP_CONF dhcp_conf,dhcp1_conf;
	DHCP_LEASE lease;
	
	int i,j,cnt;
	
	
	strcpy(nic_conf.hostname,"MCT");
	strcpy(nic_conf.public_ip,"192.168.1.105");
	strcpy(nic_conf.public_netmask,"255.255.255.0");
	strcpy(nic_conf.private_ip,"172.16.1.1");
	strcpy(nic_conf.private_netmask,"255.255.255.0");
	strcpy(nic_conf.gw,"192.168.1.1");
	nic_conf.valid_dns =4;
	for(i=0;i<4;i++) strcpy(nic_conf.dns[i],"168.95.1.1");
	
	NIC_Conf_Set_Info(&nic_conf);
	NIC_Conf_Get_Info(&nic2_conf);
	
	printf("%s %s %s %s %s\n",nic2_conf.hostname,nic2_conf.public_ip,nic2_conf.public_netmask,nic2_conf.private_ip,nic2_conf.private_netmask);
	
	
	NIC_Get_WAN_Info(&nic_info);
	printf("WAN ==> IP= %s MAC=%s GW=%s\n",nic_info.ipaddr,nic_info.hwaddr,nic_info.gateway);
	NIC_Get_LAN_Info(&nic_info);
	printf("LAN ==> IP= %s MAC=%s GW=%s\n",nic_info.ipaddr,nic_info.hwaddr,nic_info.gateway);
	
	route_info= NIC_Get_Route_Info(&cnt);
	
	tmp = route_info ; 
	for(i=0;i<cnt;i++) {
		printf("ifdev=%s des=%s genmask=%s gw=%s \n",route_info->ifdev,route_info->desti,route_info->netmask,route_info->gateway);
		route_info = route_info->next;
	}
	
	
	NIC_Free_Route_Info(tmp);
	
	
	strcpy(pppoe_conf.user_name,"louis@hinet.net");
	strcpy(pppoe_conf.password,"1234");
	
	PPPOE_Conf_Set(&pppoe_conf);
	PPPOE_Conf_Get(&pppoe1_conf);
	
	printf("%s %s\n",pppoe1_conf.user_name,pppoe1_conf.password);
	
	PPPOE_Create_Setup_File();
*/
/*	
	//========================= DHCP ================================//
	
	strcpy(dhcp_conf.wins,"172.16.1.3");
	strcpy(dhcp_conf.domain_name,"mct.com.tw");
	dhcp_conf.max_lease_time 	= 3600;
	dhcp_conf.default_lease_time 	= 7200;
	dhcp_conf.valid_ip_range_count 	= 1;
	
	strcpy(dhcp_conf.range_list[0].start , "172.16.3.1");
	strcpy(dhcp_conf.range_list[0].end , "172.16.3.100");
	
	DHCP_Conf_Set(&dhcp_conf);
	DHCP_Conf_Get(&dhcp1_conf);
	
	printf("======== DHCP CONF ========\n");
	printf("wins = %s\n",dhcp1_conf.wins);
	printf("domain_name = %s\n",dhcp1_conf.domain_name);
	printf("max_lease= %d\n",dhcp1_conf.max_lease_time);
	printf("default_lease= %d\n",dhcp1_conf.default_lease_time );
	printf("rang list %s %s\n",dhcp1_conf.range_list[0].start,dhcp1_conf.range_list[0].end );
	
	
	DHCP_Save_Leases_To_Flash();
	DHCP_Get_Leases_From_Flash(&lease);
	
	for(i=0;i<lease.lease_count;i++) {
		printf("ip = %s\n", lease.item[i].ip);	
		printf("hostname = %s\n",lease.item[i].hostname);
		printf("start time = %s\n",time2asc(lease.item[i].start));
		printf("end time   = %s\n",time2asc(lease.item[i].end));
		for(j=0;j<6;j++) 
			printf("%x:",lease.item[i].mac[j]);
		printf("\n-----------------------------------\n");
	}
	
	DHCP_Create_Setup_File();
	
	//========================= FIREWALL ================================//
	{
		FIRE_VSERVER_CONF v_conf;
		
		v_conf.rule_count = 1;
		v_conf.rule[0].protocol = 2;
		v_conf.rule[0].port 	= 80;
		strcpy(v_conf.rule[0].redirect_ip,"172.16.3.4");
		VSERVER_Conf_Set(&v_conf);
		VSERVER_Create_Setup_File();
		
	}
	{
		REG_URL_ACCESS_CONF u_conf;
	
		u_conf.url_count =2 ;
		strcpy(	u_conf.url[0],"www.yahoo.com.tw");
		strcpy(	u_conf.url[1],"www.sina.com.tw");
		URL_ACCESS_Conf_Set(&u_conf);
		URL_ACCESS_Create_Setup_File();
	}
	{
		FIRE_IP_ACCESS_CONF i_conf;
		
		i_conf.ip_group = 1;
		strcpy(i_conf.rule[0].ip,"172.16.1.5");
		i_conf.rule[0].CIDR_mask_no = 24;
		i_conf.rule[0].proto = 2;	//TCP & UDP
		i_conf.rule[0].block_range_start = 101 ;
		i_conf.rule[0].block_range_end   = 999;
		i_conf.rule[0].block_port[0] = 34;
		i_conf.rule[0].block_port[1] = 35;
		i_conf.rule[0].block_port[2] = 36;
		i_conf.rule[0].block_port[3] = 37;
		
		IP_ACCESS_Conf_Set(&i_conf);
		IP_ACCESS_Create_Setup_File();
	}
	{
		REG_ANTIHACK_CONF a_conf;
		a_conf.EN_SYNFLOOD 	= TRUE;
		a_conf.EN_ICMPFLOOD 	= TRUE;
		a_conf.EN_UDPFLOOD 	= TRUE;
		a_conf.EN_PING_DEATH 	= TRUE;
		a_conf.EN_IP_SPOOF 	= TRUE;
		a_conf.EN_PORT_SCAN	= TRUE;
		
		a_conf.syn_limit 	= 1;
		a_conf.icmp_limit	= 1;
		a_conf.udp_limit	= 1;
		
		ANTIHACK_Conf_Set(&a_conf);
		ANTIHACK_Create_Setup_File();
	}	
	//===================IPSEC CONFIGURATION==========================//
	{
		
		IPSEC_CONF	ipse_conf;
		
		ipse_conf.conn_count = 1 ;
		strncpy(ipse_conf.host_id,"vpn1",IPSEC_ID_SIZE);
		
		strncpy(ipse_conf.conn[0].name,"vpn1-vpn2",CONN_NAME_SIZE );
		strcpy(ipse_conf.conn[0].remote_gw,"192.168.1.105");
		strcpy(ipse_conf.conn[0].remote_nm,"255.255.255.0");	
		strcpy(ipse_conf.conn[0].remote_subnet,"172.16.2.0");
		ipse_conf.conn[0].remote_type = IPSEC_REMOTE_DYNAMICIP ;
		
		strcpy(ipse_conf.conn[0].secret_key,"aaaaaaaa");
		strcpy(ipse_conf.conn[0].remote_id,"vpn2");
		ipse_conf.conn[0].keylife = 1200;
		ipse_conf.conn[0].bootup  = TRUE;
		
		IPSEC_Conf_Set(&ipse_conf);
		IPSEC_Create_Setup_File();
	}
	
	
	//samba printer
	{
		REG_SAMBA_CONF smb_conf;
		
		strcpy(smb_conf.workgroup,"SOFTWARE");
		strcpy(smb_conf.printer_name,"HP");
		strcpy(smb_conf.server_string,"public printer");
		
		SMBPRN_Conf_Set(&smb_conf);
		SMBPRN_Create_Setup_File();
	}
*/
	return 1;
}

