/********************************************************************************
*
*	Copyright (c) 2002  Magic Control Technology Co.  All Rights Reserved.
*
*	FILE:
*		share.c
*
*	Abstract:
*		 samba configuration function
*		
*	History:
*		2002/11/15	Louis Tsai Created
*		2004/01/28	Matthew		add Shares_Change_Name
*********************************************************************************/
#include "libconf.h"
#include "hd_ctl.h"
#include <dirent.h>
#include <sys/stat.h>

int update_money_symbol_string(char *input, char *output, int size)
{
	int i,o_count = 0;
	if(strchr(input,'$') == NULL ) return 0;
	
	for(i=0;i<strlen(input);i++) {	
		if(input[i] == '$') {
			if((o_count+2) > size) return 0;
			output[o_count++] =0x5c ;
			output[o_count++] ='$';
		}
		else {
			if((o_count+1) > size) return 0;
			output[o_count++] = input[i];
		}
	}
	output[o_count] = '\0';
	return o_count;
}

int Shares_Add_Default_Setting(void)
{
	LA_SHARES shares_info;
	
	Config_Read(MC_SHARE,&shares_info);
	
	shares_info.cifs_enable=1;
	shares_info.mac_enable=1;
	
	strcpy(shares_info.shadata[0].name,DEF_SHARE_FOLDER);
	bitstr_mask(shares_info.shadata[0].w_users,0);  // add writing privilege to admin
	bitstr_mask(shares_info.shadata[0].w_users,1);  // add writing privilege to guest
	shares_info.count++;
	
	Config_Write(MC_SHARE,&shares_info);
	
	return 0;
}

int Shares_Info_Updated(LA_SHARE_DATA *sha_data,int new_flag)
{
	LA_SHARES shares_info;
	int i;
	Config_Read(MC_SHARE,&shares_info);
	
	
	if(new_flag) {
		int empty_index=0;
		for(i=0;i<shares_info.count;i++) {
			if(!strcasecmp(shares_info.shadata[i].name,sha_data->name))
				return 	ERR_DUPLICATED_SHARE;
		}
		empty_index = shares_info.count++;
		shares_info.shadata[empty_index] = *sha_data;	
	}
	else{
		int found=0;
		for(i=0;i<shares_info.count;i++) {
			if(!strcasecmp(shares_info.shadata[i].name,sha_data->name)) {
				/* avoid case-sensitive */
				strcpy(sha_data->name,shares_info.shadata[i].name);
				shares_info.shadata[i] = *sha_data;
				found = 1;	
			}
		}
		if(!found) return ERR_NOT_FOUND;
	}
	
	Config_Write(MC_SHARE,&shares_info);
	return SUCCESS;
}

int Shares_Remove_From_System(char *share_name_list[MAX_SHARENAME_LEN],int cnt)
{
	LA_SHARES shares_info;
	int i,j=0;
	Config_Read(MC_SHARE,&shares_info);
	for(i=0;i<cnt;i++){
		for(j=0;j<shares_info.count;j++) {
#ifdef W3S
			if(!strcasecmp(share_name_list[i],"www")) continue;
#endif
			if(!strcasecmp(shares_info.shadata[j].name,share_name_list[i])) {
				char cmd_line[80], tmpstr[30];
				//note: this line need to be modified when we have multiple hds
				//Louis Tsai 2002/11/22
				if(!update_money_symbol_string(share_name_list[i], tmpstr, 30)) 
					sprintf(cmd_line,"/bin/rm -rf %s/%s",HD_Get_Sharing_Path(0),share_name_list[i]);
				else
					sprintf(cmd_line,"/bin/rm -rf %s/%s",HD_Get_Sharing_Path(0),tmpstr);
				system(cmd_line);
				shares_info.shadata[j] = shares_info.shadata[shares_info.count-1];
				shares_info.count--;
				break;
			}
		}
	}
	
	Config_Write(MC_SHARE,&shares_info);
		
	return SUCCESS;
}

int Shares_Remove_All(void)
{
	LA_SHARES shares_info;
	Config_Read(MC_SHARE,&shares_info);
	
	shares_info.count = 0;
	
	
	Config_Write(MC_SHARE,&shares_info);
		
	return SUCCESS;
}



int Shares_Get_All_Info(LA_SHARES *sha_info)
{
	return Config_Read(MC_SHARE,sha_info);
}




int Shares_Updated_Conf_File()
{
	FILE *fp;
	LA_SHARES sha_info;
	REG_NET_CONF netconf;
	NIC_INFO wan_info;
	
	int i=0,j=0,k=0;
	char tmp_line[12000],cmd_line[80];
	DIR *dp;
	
	Config_Read(MC_SHARE,&sha_info);
	Config_Read(MC_NET_CONFIG, &netconf);	
	if( NIC_Get_WAN_Info(&wan_info) != SUCCESS )
		memset(&wan_info,0,sizeof(NIC_INFO));
		
	if((fp=fopen(SAMBA_CONF_PATH,"w")) == NULL )
		return FAILED;

	fprintf(fp,"[global]\n");
	fprintf(fp,"workgroup = %s \n",sha_info.workgrp_name);
	fprintf(fp,"server string = %s \n",sha_info.computer_des);
	fprintf(fp,"security = user\n");
	fprintf(fp,"null passwords = Yes\n");
	fprintf(fp,"encrypt passwords = Yes\n");
	fprintf(fp,"smb passwd file=/etc/samba/smbpasswd\n");
//	fprintf(fp,"max log size = 10\n");
	fprintf(fp,"name resolve order = bcast wins\n");
	fprintf(fp,"os level = 31\n");
	fprintf(fp,"socket options = TCP_NODELAY\n");
//	fprintf(fp,"preferred master = Yes\n");
	fprintf(fp,"config file = /etc/samba/smb.conf\n");
	fprintf(fp,"guest account = guest \n");
	fprintf(fp,"directory mask = 0777\n");
	fprintf(fp,"create mask = 0777\n");
#ifndef CONFIG_ONLY_NAS
//	if(!wan_info.ipaddr)
//	As security issue, close the wan port on windows file sharing!
	if(1) {
		fprintf(fp,"bind interfaces only = yes\n");
		fprintf(fp,"interfaces = %s/%s\n\n",webip2str(netconf.private_ip),webip2str(netconf.private_netmask));
	}
	else
		fprintf(fp,"interfaces = %s/%s %s/%s\n\n",webip2str(netconf.private_ip),webip2str(netconf.private_netmask),wan_info.ipaddr,wan_info.netmask);
#else
	fprintf(fp,"interfaces = %s/%s \n\n",wan_info.ipaddr,wan_info.netmask);
	system("/bin/echo \"\" > /etc/resolv.conf");
#endif
	fprintf(fp,"client code page = 950\n");
/* below lines be used to share usb printer */
	{	
		int lpfd=0;
		
		lpfd = open("/dev/usblp0",O_RDWR);
		if( lpfd != -1 ) {
			fprintf(fp,"[PortA]\n");
	   		fprintf(fp,"printing = bsd\n");	
	   		fprintf(fp,"path = /mnt/HDA/spool\n");	//need to be modified 
	   		fprintf(fp,"browsable = yes\n");
	   		fprintf(fp,"public = yes\n");
 	   		fprintf(fp,"guest ok = yes\n");
	   		fprintf(fp,"printable = yes\n");
	   		fprintf(fp,"write list = @everyone\n");
	   		close(lpfd);
		}
		
		lpfd = open("/dev/usblp1",O_RDWR);
		if( lpfd != -1 ) {
			fprintf(fp,"[PortB]\n");
	   		fprintf(fp,"printing = bsd\n");	
	   		fprintf(fp,"path = /mnt/HDA/spool\n"); //need to be modified 
	   		fprintf(fp,"browsable = yes\n");
	   		fprintf(fp,"public = yes\n");
 	   		fprintf(fp,"guest ok = yes\n");
	   		fprintf(fp,"printable = yes\n");
	   		fprintf(fp,"write list = @everyone\n");
	   		close(lpfd);
		}
		
	}
	fprintf(fp,"\n");
	for(i=0;i<sha_info.count;i++) {
		fprintf(fp,"[%s]\n",sha_info.shadata[i].name);	
		fprintf(fp,"comment = %s\n",sha_info.shadata[i].name);
		fprintf(fp,"browsable = yes\n");
//!!!!!! should be modified when we have multiple hds	louistsai 2003/2/21
		
		if(strstr(sha_info.shadata[i].name,"USBCDROM") != NULL) {
			fprintf(fp,"path = /mnt/USBCDROM\n");
			
			sprintf(cmd_line,"/bin/mkdir -p /mnt/USBCDROM");
				
			system(cmd_line);
			
			sprintf(cmd_line,"/bin/chmod -R 777 /mnt/USBCDROM");
			system(cmd_line);
		}
		else if (strstr(sha_info.shadata[i].name,"USBHD") != NULL)  {
			fprintf(fp,"path = /mnt/%s\n", sha_info.shadata[i].name);
			
			sprintf(cmd_line,"/bin/mkdir -p /mnt/%s", sha_info.shadata[i].name);
				
			system(cmd_line);
			
			sprintf(cmd_line,"/bin/chmod -R 777 /mnt/%s", sha_info.shadata[i].name);
			system(cmd_line);
		}
		else {
			fprintf(fp,"path = %s/%s\n",HD_Get_Sharing_Path(0),sha_info.shadata[i].name);
		
			sprintf(cmd_line,"%s/%s",HD_Get_Sharing_Path(0),sha_info.shadata[i].name);
		
			if((dp=opendir(cmd_line)) == NULL && HD_Is_Initial(0) && HD_Get_Action_Flag(0) == HD_READY ) {
				char tmpstr[30];
				if(!update_money_symbol_string(sha_info.shadata[i].name, tmpstr, 30)) 
					sprintf(cmd_line,"/bin/mkdir -p %s/%s",HD_Get_Sharing_Path(0),sha_info.shadata[i].name);
				else
					sprintf(cmd_line,"/bin/mkdir -p %s/%s",HD_Get_Sharing_Path(0),tmpstr);
				
				system(cmd_line);
			
				sprintf(cmd_line,"/bin/chmod 777 %s",HD_Get_Mounting_Path(0));
				system(cmd_line);
			
			
				if(!update_money_symbol_string(sha_info.shadata[i].name, tmpstr, 30))
					sprintf(cmd_line,"/bin/chmod 777 %s/%s",HD_Get_Sharing_Path(0), sha_info.shadata[i].name);
				else 
					sprintf(cmd_line,"/bin/chmod 777 %s/%s",HD_Get_Sharing_Path(0), tmpstr);
			
				system(cmd_line);
			}	
			
			
		}

		if(bitstr_get(sha_info.shadata[i].r_users,1) ||
		   bitstr_get(sha_info.shadata[i].w_users,1) )
		fprintf(fp,"guest ok = yes\n");
		//read list
		strcpy(tmp_line,"");
		for(j=0;j<LA_MAX_USERS/32;j++) {
			if(sha_info.shadata[i].r_users[j] == 0) continue;
			for(k=0;k<32;k++) {
				if(bitstr_get(sha_info.shadata[i].r_users,j*32+k)){
					char uname[MAX_USERNAME_LEN];
					User_Get_Name(uname,j*32+k);
					strcat(tmp_line,uname);
					strcat(tmp_line,",");
				}
			}
		}
		for(j=0;j<MAX_GROUPS/32;j++) {
			if(sha_info.shadata[i].r_grps[j] == 0) continue;
			for(k=0;k<32;k++) {
				if(bitstr_get(sha_info.shadata[i].r_grps,j*32+k)){
					char gname[MAX_GROUPNAME_LEN];
					Group_Get_Name(gname,j*32+k);
					strcat(tmp_line,"@");
					strcat(tmp_line,gname);
					strcat(tmp_line,",");
				}
			}
		}
		tmp_line[strlen(tmp_line)-1] = '\0';
		fprintf(fp,"read list= %s\n",tmp_line);
		
		//write list
		strcpy(tmp_line,"");
		for(j=0;j<LA_MAX_USERS/32;j++) {
			if(sha_info.shadata[i].w_users[j] == 0) continue;
			for(k=0;k<32;k++) {
				if(bitstr_get(sha_info.shadata[i].w_users,j*32+k)){
					char uname[MAX_USERNAME_LEN];
					User_Get_Name(uname,j*32+k);
					strcat(tmp_line,uname);
					strcat(tmp_line,",");
				}
			}
		}
		for(j=0;j<MAX_GROUPS/32;j++) {
			if(sha_info.shadata[i].w_grps[j] == 0) continue;
			for(k=0;k<32;k++) {
				if(bitstr_get(sha_info.shadata[i].w_grps,j*32+k)){
					char gname[MAX_GROUPNAME_LEN];
					Group_Get_Name(gname,j*32+k);
					strcat(tmp_line,"@");
					strcat(tmp_line,gname);
					strcat(tmp_line,",");
				}
			}
		}
		tmp_line[strlen(tmp_line)-1] = '\0';
		fprintf(fp,"write list= %s\n\n",tmp_line);	
	}
	
	fclose(fp);
	mct_killall("smbd",1);
//return SUCCESS;
//	strcpy(cmd_line,"/bin/killall -1 smbd");
//	strcpy(cmd_line,"/bin/kill -1 111");
//	system(cmd_line);
	
	return SUCCESS;
}

BOOL Shares_Check_Guest_Have_Access_Right(void)
{
	LA_SHARES sha_info;
	LA_GROUPS grpconf;
	int i,j,k;
	int uid;
	
	Config_Read(MC_SHARE,&sha_info);
	Config_Read(MC_GROUP,&grpconf);
		

	for(i=0;i<sha_info.count;i++) {
		if(bitstr_get(sha_info.shadata[i].r_users,1))
			return 1;
		for(j=0;j<MAX_GROUPS/32;j++) {
			if(sha_info.shadata[i].r_grps[j] == 0) continue;
			for(k=0;k<32;k++) {
				if(bitstr_get(sha_info.shadata[i].r_grps,j*32+k)){
					if(bitstr_get(grpconf.grpdata[j*32+k].members,1))
						return 1;
				}
			}
		}
		if(bitstr_get(sha_info.shadata[i].w_users,1))
			return 1;
		for(j=0;j<MAX_GROUPS/32;j++) {
			if(sha_info.shadata[i].w_grps[j] == 0) continue;
			for(k=0;k<32;k++) {
				if(bitstr_get(sha_info.shadata[i].w_grps,j*32+k)){
					if(bitstr_get(grpconf.grpdata[j*32+k].members,1))
						return 1;
				}
			}
		}
	}
	return 0;
}

int Shares_Get_User_Privilege(char *share_name,char *username)
{
	LA_SHARES sha_info;
	int i,j,k;
	int uid;
	
	if((uid=User_Get_UID(username)) < 0) return SHARE_NOACCESS;
	Config_Read(MC_SHARE,&sha_info);
	
//	if( bitstr_get(sha_info.shadata[i].r_users,1)|| 
//	    bitstr_get(sha_info.shadata[i].w_users,1) )
//			return 1;
	
	for(i=0;i<sha_info.count;i++) {
		if(!strcasecmp(sha_info.shadata[i].name,share_name)){
			LA_GROUPS grpconf;
			Config_Read(MC_GROUP,&grpconf);
			if(bitstr_get(sha_info.shadata[i].r_users,uid))
				return SHARE_READONLY;
			for(j=0;j<MAX_GROUPS/32;j++) {
				if(sha_info.shadata[i].r_grps[j] == 0) continue;
				for(k=0;k<32;k++) {
					if(bitstr_get(sha_info.shadata[i].r_grps,j*32+k)){
						if(bitstr_get(grpconf.grpdata[j*32+k].members,uid))
							return SHARE_READONLY;
					}
				}
			}
			if(bitstr_get(sha_info.shadata[i].w_users,uid))
				return SHARE_READWRITE;
			for(j=0;j<MAX_GROUPS/32;j++) {
				if(sha_info.shadata[i].w_grps[j] == 0) continue;
				for(k=0;k<32;k++) {
					if(bitstr_get(sha_info.shadata[i].w_grps,j*32+k)){
						if(bitstr_get(grpconf.grpdata[j*32+k].members,uid))
							return SHARE_READWRITE;
					}
				}
			}
			break;
		}
	}
	return SHARE_NOACCESS;
}


int Shares_Check_User_Privilege(char *share_name,char *username,int read_only)
{
	LA_SHARES sha_info;
	int i,j,k;
	int uid;
	
	if((uid=User_Get_UID(username)) < 0) return 0;
	Config_Read(MC_SHARE,&sha_info);
	
	/*if guest have r/w privilege, then anyone also have r/w privilege*/
//	if( bitstr_get(sha_info.shadata[i].r_users,1)|| 
//	    bitstr_get(sha_info.shadata[i].w_users,1) )
//			return 1;
	
	for(i=0;i<sha_info.count;i++) {
		if(!strcasecmp(sha_info.shadata[i].name,share_name)){
			GROUPS grpconf;
			Config_Read(MC_GROUP,&grpconf);
			if(read_only) {
				if(bitstr_get(sha_info.shadata[i].r_users,uid))
					return 1;
				for(j=0;j<MAX_GROUPS/32;j++) {
					if(sha_info.shadata[i].r_grps[j] == 0) continue;
					for(k=0;k<32;k++) {
						if(bitstr_get(sha_info.shadata[i].r_grps,j*32+k)){
							if(bitstr_get(grpconf.grpdata[j*32+k].members,uid))
								return 1;
						}
					}
				}
			}
			else {
				if(bitstr_get(sha_info.shadata[i].w_users,uid))
					return 1;
				for(j=0;j<MAX_GROUPS/32;j++) {
					if(sha_info.shadata[i].w_grps[j] == 0) continue;
					for(k=0;k<32;k++) {
						if(bitstr_get(sha_info.shadata[i].w_grps,j*32+k)){
							if(bitstr_get(grpconf.grpdata[j*32+k].members,uid))
								return 1;
						}
					}
				}
			}
			break;
		}
	}
	return 0;
}

int Shares_Change_Name(char *pOldShareName, char *pNewShareName)
{
	int retValue = SUCCESS;
	LA_SHARES shareInfo;
	int i;
	
	memset(&shareInfo, 0x00, sizeof(LA_SHARES));
	Config_Read(MC_SHARE,&shareInfo);		
	
	for(i=0; i<shareInfo.count; i++) {
		if(!strcasecmp(shareInfo.shadata[i].name,"www"))	{
			retValue = ERR_CHANGE_WWW_SHARE_NAME;
			goto labelFinish;
		}

		if(strcasecmp(shareInfo.shadata[i].name, pOldShareName) == 0)	{
			strcpy(shareInfo.shadata[i].name, pNewShareName);
			Config_Write(MC_SHARE, &shareInfo);
			retValue = SUCCESS;
			goto labelFinish;
		}	

	}
	
labelFinish:
	return(retValue);	
}	

int Shares_Add_From_Formated_HD(void)
{
	DIR *dp;
    	struct dirent *entry;
    	struct stat statbuf;
    	LA_SHARES shares_info;
    	int i,found = 0;
	
	Config_Read(MC_SHARE,&shares_info);
	
	
    	if((dp = opendir(HD_Get_Sharing_Path(0))) == NULL) return -1;
    	chdir(HD_Get_Sharing_Path(0));
    	while((entry = readdir(dp)) != NULL) {
        	lstat(entry->d_name,&statbuf);
        	if(S_ISDIR(statbuf.st_mode)) {
            		/* Found a directory, but ignore . and .. */
            		if(strcmp(".",entry->d_name) == 0 || 
               	   	strcmp("..",entry->d_name) == 0 ||
	           	strcmp("lost+found",entry->d_name) == 0)
                		continue;
                	found = 0;
                	for(i=0;i<shares_info.count;i++) {
				if(!strcasecmp(shares_info.shadata[i].name,entry->d_name)) {
					found = 1;
					break;
				}
			}
			if(!found) {
				strcpy(shares_info.shadata[shares_info.count].name,entry->d_name);
				bitstr_mask(shares_info.shadata[shares_info.count].w_users,1);  // add writing privilege to guest 
				shares_info.count++;
				shares_info.cifs_enable = 1;
			}
		}
    	}
    	
    	Config_Write(MC_SHARE,&shares_info);
    	chdir("..");
    	closedir(dp);
}


int NFS_Create_Exports()
{
	LA_SHARES sha_info;
	REG_NFS_CONF nfsconf;
	int i,j,k,m;
	int uid,found=0;
	FILE *fp;
	
	Config_Read(MC_NFS_CONFIG,&nfsconf);
	Config_Read(MC_SHARE,&sha_info);

//printf("enter NFS\n");	
	if((fp=fopen("/etc/exports","w")) == NULL )
		return FAILED;
	
	
	
	for(m=0; m< nfsconf.count; m++) {
		uid =  nfsconf.nfs_item[m].local_uid;	
//printf("uid=%d\n",uid);	
		for(i=0;i<sha_info.count;i++) {
			LA_GROUPS grpconf;
			Config_Read(MC_GROUP,&grpconf);
//printf("NFS count=%d\n",nfsconf.count);	
//printf("%d %d\n",bitstr_get(sha_info.shadata[i].r_users,uid), bitstr_get(sha_info.shadata[i].w_users,uid));		
			if(bitstr_get(sha_info.shadata[i].r_users,uid) || bitstr_get(sha_info.shadata[i].w_users,uid)) {
				fprintf(fp,"/%s\t%s/%d(rw,no_root_squash)\n",sha_info.shadata[i].name,
								webip2str(nfsconf.nfs_item[m].remote_ip),
								nfsconf.nfs_item[m].mask_no);
				
				continue;	
			}
			
			found = 0;
			for(j=0;j<MAX_GROUPS/32;j++) {
				if(sha_info.shadata[i].r_grps[j] != 0) {
					for(k=0;k<32;k++) {
						if(bitstr_get(sha_info.shadata[i].r_grps,j*32+k)){
							if(bitstr_get(grpconf.grpdata[j*32+k].members,uid)) {
								found = 1;
								break;
							}
						}
					}
				}
				if(sha_info.shadata[i].w_grps[j] != 0) {
					for(k=0;k<32;k++) {
						if(bitstr_get(sha_info.shadata[i].w_grps,j*32+k)){
							if(bitstr_get(grpconf.grpdata[j*32+k].members,uid)) {
								found = 1;
								break;
							}
						}
					}
				}
				if(found) {
					fprintf(fp,"/%s\t%s/%d(rw,no_root_squash)\n",sha_info.shadata[i].name,
								webip2str(nfsconf.nfs_item[m].remote_ip),
								nfsconf.nfs_item[m].mask_no);				
					break;	
				}
			}
		}
	}
	
	fclose(fp);
	return 0;
}


#ifdef W3S

void W3S_Add_Shared_Folder(void)
{
	LA_SHARES shares_info;
	int i;
	
	Config_Read(MC_SHARE,&shares_info);		
	
	for(i=0;i<shares_info.count;i++) {
		if(!strcasecmp(shares_info.shadata[i].name,"www"))
			return;
	}
	
	strcpy(shares_info.shadata[shares_info.count].name,"www");
	bitstr_mask(shares_info.shadata[shares_info.count].w_users,0);  // add writing privilege to admin
	bitstr_mask(shares_info.shadata[shares_info.count].w_users,1);  // add writing privilege to guest 
	shares_info.count++;
	
	Config_Write(MC_SHARE,&shares_info);
	Shares_Updated_Conf_File();
	
	
}	

void W3S_Remove_Shared_Folder(void)
{
	LA_SHARES shares_info;
	int j=0;
	Config_Read(MC_SHARE,&shares_info);
	for(j=0;j<shares_info.count;j++) {
		if(!strcasecmp(shares_info.shadata[j].name,"www")) {
			shares_info.shadata[j] = shares_info.shadata[shares_info.count-1];
			shares_info.count--;
			break;
		}
	}
	Config_Write(MC_SHARE,&shares_info);
	Shares_Updated_Conf_File();
}

#endif
#ifdef UPNP_MMS

void Upnp_MMS_Add_Shared_Folder(void)
{
	LA_SHARES shares_info;
	int i;
	
	Config_Read(MC_SHARE,&shares_info);		
	
	for(i=0;i<shares_info.count;i++) {
		if(!strcasecmp(shares_info.shadata[i].name,"UPnPMedia"))
			return;
	}
	
	strcpy(shares_info.shadata[shares_info.count].name,"UPnPMedia");
	bitstr_mask(shares_info.shadata[shares_info.count].w_users,0);  // add writing privilege to admin
	bitstr_mask(shares_info.shadata[shares_info.count].w_users,1);  // add writing privilege to guest 
	shares_info.count++;
	
	Config_Write(MC_SHARE,&shares_info);
	Shares_Updated_Conf_File();
	
	
}	

void Upnp_MMS_Remove_Shared_Folder(void)
{
	LA_SHARES shares_info;
	int j=0;
	Config_Read(MC_SHARE,&shares_info);
	for(j=0;j<shares_info.count;j++) {
		if(!strcasecmp(shares_info.shadata[j].name,"UPnPMedia")) {
			shares_info.shadata[j] = shares_info.shadata[shares_info.count-1];
			shares_info.count--;
			break;
		}
	}
	Config_Write(MC_SHARE,&shares_info);
	Shares_Updated_Conf_File();
}

#endif
