/********************************************************************************
*
*	Copyright (c) 2002  Magic Control Technology Co.  All Rights Reserved.
*
*	FILE:
*		smbprn.c
*
*	Abstract:
*		 samba printer configuration function
*		
*	History:
*		2002/2/1	Louis Tsai Created
*********************************************************************************/
#include "libconf.h"

int SMBPRN_Conf_Set(REG_SAMBA_CONF *conf)
{
	if( Config_Write(MC_SAMBA_CONFIG,(void *)conf) == 0 )
		return SUCCESS;
	else
		return ERR_WRITE_CONFIG;	
}

int SMBPRN_Conf_Get(REG_SAMBA_CONF *conf)
{
	if( Config_Read(MC_SAMBA_CONFIG,(void *)conf) != 0 )
		return ERR_READ_CONFIG;
	else
		return SUCCESS;
}

int SMBPRN_Set_Enable(BOOL enable)
{
	REG_SYS_CONF sys;
	
	if( Config_Read(MC_SYS_CONFIG,(void *)&sys) != 0 )
		return ERR_READ_CONFIG;
	
	sys.EN_PRINER= enable;
	
	if( Config_Write(MC_SYS_CONFIG,(void *)&sys) == 0 )
		return SUCCESS;
	else
		return ERR_WRITE_CONFIG;
	
	
}

int SMBPRN_Create_Setup_File(void)
{
	REG_SAMBA_CONF conf;
	FILE *fp;
	
	if(SMBPRN_Conf_Get(&conf) != SUCCESS) {
		return FAILED;
	}
	
	if((fp=fopen(SAMBA_CONF_PATH,"w")) == NULL )
		return FAILED;
	
	fprintf(fp,"[global]\n");
	fprintf(fp,"workgroup = %s \n",conf.workgroup);
	fprintf(fp,"server string = %s \n",conf.server_string);
	fprintf(fp,"null passwords = Yes\n");
	fprintf(fp,"max log size = 10\n");
	fprintf(fp,"name resolve order = bcast wins\n");
	fprintf(fp,"os level = 31\n");
	fprintf(fp,"preferred master = Yes\n");
	fprintf(fp,"config file = /etc/samba/smb.conf\n");
	fprintf(fp,"guest account = nobody \n");
	fprintf(fp,"directory mask = 0777\n");
	fprintf(fp,"create mask = 0664\n");
	fprintf(fp,"printing = bsd\n");
	fprintf(fp,"printcap name = /etc/printcap\n");
	fprintf(fp,"load printers = yes\n");
	fprintf(fp,"interfaces = eth0 eth1\n\n");
	fprintf(fp,"[printers]\n");
	fprintf(fp,"path = /var/spool/lpd/samba\n");
	fprintf(fp,"browsable = no\n");
	fprintf(fp,"public = yes\n");
	fprintf(fp,"guest ok = yes\n");
	fprintf(fp,"printable = yes\n");
	fprintf(fp,"writable = yes\n");
	
	fclose(fp);
	
	if((fp=fopen(PRINTCAP_PATH,"w")) == NULL )
		return FAILED;
		
	fprintf(fp,"%s:\\\n",conf.printer_name);
	fprintf(fp,"\t:sd=/var/spool/lpd/samba:\\\n");
	fprintf(fp,"\t:lp=/dev/lp0:\\\n");
	fprintf(fp,"\t:mx#0:\\\n");
	fprintf(fp,"\t:sh:\n\n");
	
	fclose(fp);
	
	return SUCCESS;
}

