/********************************************************************************
*
*	Copyright (c) 2002  Magic Control Technology Co.  All Rights Reserved.
*
*	FILE:
*		usrgrp.c
*
*	Abstract:
*		 user & group management function
*		
*	History:
*		2002/11/04	Louis Tsai Created
*		2004/01/27	Matthew, Add User_Chagne_Name method
*		2004/01/28	Matthew, Add Group_Chagne_Name method
*********************************************************************************/
#include "libconf.h"
#include "hd_ctl.h"
#include <error.h>



int bitstr_get(__u32 *bits, int pos)
{
	return ((bits[pos/32]>>(pos%32)) & 0x0000001);
}

void bitstr_mask(__u32 *bits, int pos)
{
	bits[pos/32] |= 0x1 << (pos%32);
}

void bitstr_unmask(__u32 *bits, int pos)
{
	bits[pos/32] &= ~(0x1 << (pos%32));
}

void bitstr_clean(__u32 *bits)
{
	memset((void*)bits,0,(LA_MAX_USERS/32)*4);
}

int User_Add_To_System(char *username,char *passwd,char *group)
{
//	USERSHARE_BLOCK usershare_conf;
	
	LA_USERS 	userconf;
	LA_GROUPS	groupconf;
	
	int i=0,j=0,mi=0,mj=0,found_hole=0,found_grp=0;
	unsigned int bit_value=0;
	
	//Config_Read(MC_USERSHARE,&usershare_conf);
	
	
//	if(Group_Get_Amount_Of_Members(group) >= LA_MAX_GRP_MEMBERS) 
//		return ERR_OVERFLOW;	
	
	Config_Read(MC_USER, &userconf);
	Config_Read(MC_GROUP, &groupconf);
	

	for(i=0;i<LA_MAX_USERS/32;i++) {
		if(userconf.bitstr[i] == 0xffffffff ) continue;
		for(j=0;j<32;j++) {
			bit_value = ( userconf.bitstr[i] >> j ) & 0x00000001 ; 
			if(bit_value) {
				if(!strcasecmp(userconf.usrdata[i*32+j].name,username)) return ERR_DUPLICATED_USER;	
			}
			
			if(!bit_value && !found_hole) {
				mi = i; mj = j; //find empty hole
				found_hole = 1;
			}
		}
	}
	if(found_hole) {
		strcpy(userconf.usrdata[mi*32+mj].name,username);
		strcpy(userconf.usrdata[mi*32+mj].password,passwd);		
		userconf.usrdata[mi*32+mj].uid = mi*32+mj;
/*Let each new user can login with pptp client,louistsai 2003/3/31*/
		bitstr_mask(userconf.pptp_on,mi*32+mj);
		userconf.bitstr[mi] |= 0x00000001 << mj;
	}
	else	
		return ERR_OVERFLOW;	
	
	for(i=0;i<MAX_GROUPS/32;i++) {
		if(groupconf.bitstr[i] == 0 ) continue;
		for(j=0;j<32;j++) {
			bit_value = ( groupconf.bitstr[i] >> j ) & 0x00000001 ; 
			if(bit_value && !strcasecmp(groupconf.grpdata[i*32+j].name,group)) {
				int adduser_uid = userconf.usrdata[mi*32+mj].uid ;
				
				if(bitstr_get(groupconf.grpdata[i*32+j].members,adduser_uid))
					return ERR_DUPUSER_IN_GROUP;
				
				bitstr_mask(groupconf.grpdata[i*32+j].members,adduser_uid);
				
				found_grp = 1; i=8;
				break;
			}
		}
	}	
	
	Config_Write(MC_USER, &userconf);
	Config_Write(MC_GROUP, &groupconf);
//	Config_Write(MC_USERSHARE,&usershare_conf);
#ifdef QMAIL
	//maybe we will change the mail volume to another hd. Currently, we use the first hd as mail volume!
	//if the first hd have been initialized, we should create the home directory and build "Maildir" on it.
	if(HD_Is_Initial(0) && (HD_Get_Action_Flag(0) == HD_READY)) Build_User_Maildir(username);
#endif 
	return SUCCESS;
}

#ifdef QMAIL
void Build_User_Maildir(char *username)
{
	char cmdline[120];
	sprintf(cmdline,"/bin/mkdir -p %s/home/%s", HD_Get_Mounting_Path(0), username);
	system(cmdline);
	sprintf(cmdline,"/bin/chmod 755 %s/home/%s", HD_Get_Mounting_Path(0), username);
	system(cmdline);
	sprintf(cmdline,"/sbin/maildirmake %s/home/%s/Maildir", HD_Get_Mounting_Path(0), username);
	system(cmdline);	
}

void Change_Owner_On_Maildir(char *username)
{
	char cmdline[120];
	sprintf(cmdline,"/bin/chown -R %s %s/home/%s", username, HD_Get_Mounting_Path(0), username);
	system(cmdline);
}	

void Check_User_Maildir_On_Boot(void)
{
	LA_USERS userconf;
	int i=0,j=0;
	unsigned int bit_value=0;
	DIR *dp;
	
	
	if(!HD_Is_Initial(0) || (HD_Get_Action_Flag(0) != HD_READY)) return;
	if(!HD_Check_Mount(HD_Get_Mounting_Path(0)) ) return;

	Config_Read(MC_USER,&userconf);
	
	for(i=0;i<LA_MAX_USERS/32;i++) {
		if(userconf.bitstr[i] == 0 ) continue; //empty buffer
		for(j=0;j<32;j++) {
			bit_value = ( userconf.bitstr[i] >> j ) & 0x00000001 ; 
			if(bit_value) {
				char dirname[128];
				sprintf(dirname,"%s/home/%s",HD_Get_Mounting_Path(0),userconf.usrdata[i*32+j].name);	
				if((dp=opendir(dirname)) == NULL ) {
					Build_User_Maildir(userconf.usrdata[i*32+j].name);
					Change_Owner_On_Maildir(userconf.usrdata[i*32+j].name);
				}
				else
					closedir(dp);
			}
		}
	}
	
	
}

void Check_Qmail_Sysdir_On_Boot(void)
{
	DIR *dp;
	char cmdline[80],dirname[128];
	if(!HD_Is_Initial(0) || (HD_Get_Action_Flag(0) != HD_READY) ) return;
	if(!HD_Check_Mount(HD_Get_Mounting_Path(0)) ) return;
	
	sprintf(dirname,"%s/qmail",HD_Get_Mounting_Path(0));
	if((dp=opendir(dirname)) == NULL ) {
		sprintf(cmdline,"/bin/cp -af /sbin/varqmail.tgz /mnt/HDA");
		system(cmdline);
		
		sprintf(cmdline,"/bin/gzip -d /mnt/HDA/varqmail.tgz");
		system(cmdline);
		
		sprintf(cmdline,"/bin/tar vxf %s/varqmail",HD_Get_Mounting_Path(0));	
		system(cmdline);
	
		sprintf(cmdline,"/bin/rm -f %s/varqmail",HD_Get_Mounting_Path(0));	
		system(cmdline);
	}
	else
		closedir(dp);
}

#endif

int User_Remove_From_System(char *username)
{
	int uid = -1;
	int i=0,j=0;
	
	LA_USERS	users;
	LA_GROUPS	groups;
	LA_SHARES	shares;	

//	USERSHARE_BLOCK usershare_conf;
	unsigned int bit_value=0;
	
	Config_Read(MC_USER, &users);
	Config_Read(MC_GROUP, &groups);
	Config_Read(MC_SHARE, &shares);
	
	
	
	
//	Config_Read(MC_USERSHARE,&usershare_conf);
	
	if((uid = User_Get_UID(username)) < 0 ) return uid;
	if(uid ==0 || uid == 1) return ERR_DEL_RESERVED_USER;
	
	Remove_NFS_User(uid);
	users.bitstr[uid/32] &= ~(0x00000001 << (uid%32)) ;

/*remove user pptp privilege,louistsai 2003/3/31*/
	bitstr_unmask(users.pptp_on,uid);

	for(i=0;i<MAX_GROUPS/8;i++) {
		if(groups.bitstr[i] == 0 ) continue;
		for(j=0;j<32;j++) {
			bit_value = (groups.bitstr[i] >> j ) & 0x00000001 ; 
			if(bit_value) {
				if(bitstr_get(groups.grpdata[i*32+j].members,uid))
					bitstr_unmask(groups.grpdata[i*32+j].members,uid);
			}
		}
	}	
	
	for(i=0;i<shares.count;i++) {
		if(bitstr_get(shares.shadata[i].r_users,uid))
			bitstr_unmask(shares.shadata[i].r_users,uid);
			
		if(bitstr_get(shares.shadata[i].w_users,uid))
			bitstr_unmask(shares.shadata[i].w_users,uid);
			
	}
	
	Config_Write(MC_USER, &users);
	Config_Write(MC_GROUP, &groups);
	Config_Write(MC_SHARE, &shares);

	return SUCCESS;
}

int User_Get_All_Info(LA_USER_DATA *userlist,int list_cnt)
{
	LA_USERS userconf;
	int i=0,j=0,user_cnt=0;
	unsigned int bit_value=0;
	
	Config_Read(MC_USER,&userconf);
	if(userlist == NULL ) return FAILED; 
	
	for(i=0;i<LA_MAX_USERS/32;i++) {
		if(userconf.bitstr[i] == 0 ) continue;
		
		for(j=0;j<32;j++) {
			bit_value = ( userconf.bitstr[i] >> j ) & 0x00000001 ; 
			if(bit_value) {
				*(userlist+user_cnt) = userconf.usrdata[i*32+j];
				user_cnt++;
				
			}
		}
	}
	return user_cnt;
}

int User_Change_Passwd(char *username,char *passwd)
{
	LA_USERS userconf;
	int i=0,j=0;
	unsigned int bit_value=0;
	
	Config_Read(MC_USER,&userconf);
	
	for(i=0;i<LA_MAX_USERS/32;i++) {
		if(userconf.bitstr[i] == 0 ) continue; //empty buffer
		for(j=0;j<32;j++) {
			bit_value = ( userconf.bitstr[i] >> j ) & 0x00000001 ; 
			if(bit_value && !strcasecmp(username,userconf.usrdata[i*32+j].name)) {
				if((i*32+j) == 1) return ERR_CHANGE_GUEST_PASS;
				strcpy(userconf.usrdata[i*32+j].password,passwd);
				Config_Write(MC_USER,&userconf);
				return SUCCESS;	
			}
		}
	}
	
	
	return ERR_NOT_FOUND;
}

int User_Change_Name(char *pOldUserName, char *pNewUserName)
{
	LA_USERS userConf;
	unsigned int bitValue = 0;
	int i;
	int j;
	int retValue = SUCCESS;

	memset(&userConf, 0x00, sizeof(LA_USERS));
	Config_Read(MC_USER, &userConf);

	for(i=0; i<LA_MAX_USERS/32; i++)	{
		if(userConf.bitstr[i] == 0)
			continue;

		for(j=0; j<32; j++)	{
			bitValue = (userConf.bitstr[i] >> j) & 0x00000001;

			if(bitValue && !strcasecmp(pOldUserName, userConf.usrdata[i*32 + j].name))	{
				if((i * 32 + j) == 1)	{
					retValue = ERR_CHANGE_GUEST_NAME;
					goto labelFinish;
				}

				strcpy(userConf.usrdata[i*32 + j].name, pNewUserName);
				Config_Write(MC_USER, &userConf);
				retValue = SUCCESS;
				goto labelFinish;
			}
		}
	}

labelFinish:
	return(retValue);
}

BOOL User_Check_Passwd(char *username,char *passwd)
{
	LA_USERS userconf;
	int i=0,j=0;
	unsigned int bit_value=0;
	
	Config_Read(MC_USER,&userconf);
	
	for(i=0;i<LA_MAX_USERS/32;i++) {
		if(userconf.bitstr[i] == 0 ) continue; //empty buffer
		for(j=0;j<32;j++) {
			bit_value = ( userconf.bitstr[i] >> j ) & 0x00000001 ; 
			if(bit_value && !strcasecmp(username,userconf.usrdata[i*32+j].name)) {
				if(strcasecmp(userconf.usrdata[i*32+j].password,passwd)==0) 
					return 1;
			}
		}
	}
	
	
	return 0;
}	

int User_Get_Name(char *username , int uid)
{
	LA_USERS userconf;
	unsigned int bit_value=0;
	
	Config_Read(MC_USER,&userconf);
	bit_value = (userconf.bitstr[uid/32] >> (uid%32)) & 0x00000001;
	if(bit_value) {
		strcpy(username,userconf.usrdata[uid].name);
		return SUCCESS;	
	}
	else
		return ERR_NOT_FOUND;
}

int User_Get_UID(char *username)
{
	LA_USERS userconf;
	int i=0,j=0;
	unsigned int bit_value=0;
	
	Config_Read(MC_USER,&userconf);
	
	for(i=0;i<LA_MAX_USERS/32;i++) {
		if(userconf.bitstr[i] == 0 ) continue; //empty buffer
		for(j=0;j<32;j++) {
			bit_value = ( userconf.bitstr[i] >> j ) & 0x00000001 ; 
			if(bit_value && !strcasecmp(username,userconf.usrdata[i*32+j].name))
				return i*32+j;
		}
	}
	
	
	return ERR_NOT_FOUND;
}

int Group_Get_Name(char *grpname , int gid)
{
	LA_GROUPS grpconf;
	unsigned int bit_value=0;
	
	Config_Read(MC_GROUP,&grpconf);
	
	bit_value = (grpconf.bitstr[gid/32] >> (gid%32)) & 0x00000001;
	if(bit_value) {
		strcpy(grpname,grpconf.grpdata[gid].name);
		return SUCCESS;	
	}
	else
		return ERR_NOT_FOUND;
}

int Group_Get_GID(char *groupname)
{
	LA_GROUPS grpconf;
	int i=0,j=0;
	unsigned int bit_value=0;
	
	Config_Read(MC_GROUP,&grpconf);
	
	for(i=0;i<MAX_GROUPS/32;i++) {
		if(grpconf.bitstr[i] == 0 ) continue; //empty buffer
		for(j=0;j<32;j++) {
			bit_value = ( grpconf.bitstr[i] >> j ) & 0x00000001 ; 
			if(bit_value && !strcasecmp(groupname,grpconf.grpdata[i*32+j].name))
				return i*32+j;
		}
	}
	
	return ERR_NOT_FOUND;
	
}

int Group_Get_All_Info(LA_GROUP_DATA *grplist,int list_cnt)
{
	LA_GROUPS grpconf;
	int i=0,j=0,grp_cnt=0;
	unsigned int bit_value=0;
	
	Config_Read(MC_GROUP,&grpconf);
	if(grplist == NULL ) return FAILED; 
	
	for(i=0;i<MAX_GROUPS/32;i++) {
		if(grpconf.bitstr[i] == 0 ) continue;
		
		for(j=0;j<32;j++) {
			bit_value = ( grpconf.bitstr[i] >> j ) & 0x00000001 ; 
			if(bit_value) {
				*(grplist+grp_cnt) = grpconf.grpdata[i*32+j];
				grp_cnt++;
				
			}
		}
	}
	return grp_cnt;
}


int Group_Add_To_System(char *grpname)
{
	LA_GROUPS grpconf;
	int i=0,j=0;
	unsigned int bit_value=0;
	
	if(Group_Get_GID(grpname)>0) return ERR_DUPLICATED_GROUP;
	
	Config_Read(MC_GROUP,&grpconf);
	for(i=0;i<MAX_GROUPS/32;i++) {
		if(grpconf.bitstr[i] == 0xffffffff ) continue;
		
		for(j=0;j<32;j++) {
			bit_value = ( grpconf.bitstr[i] >> j ) & 0x00000001 ; 
			if(!bit_value) {
				grpconf.bitstr[i] |= 0x00000001 << j;
				grpconf.grpdata[i*32+j].gid = i*32+j;
				strcpy(grpconf.grpdata[i*32+j].name,grpname);
				//grpconf.grpdata[i*32+j].nr_members = 0;
				//memset((void*)grpconf.grpdata[i*32+j].members,0,MAX_USERS);
				bitstr_clean(grpconf.grpdata[i*32+j].members);
				Config_Write(MC_GROUP,&grpconf);
				return SUCCESS;
			}
		}
	}
	
	return ERR_OVERFLOW;
}

int Group_Remove_From_System(char *grpname)
{
	int gid = -1;
	int i=0;

	LA_GROUPS	groups;
	LA_SHARES	shares;	
	
	Config_Read(MC_GROUP, &groups);
	Config_Read(MC_SHARE, &shares);
	
	
	if((gid = Group_Get_GID(grpname)) < 0 ) return gid;
	if(gid == 0 ) return ERR_DEL_RESERVED_GROUP;
	
	groups.bitstr[gid/32] &= ~(0x00000001 << (gid%32)) ;
	
	
	for(i=0;i<shares.count;i++) {
		if(bitstr_get(shares.shadata[i].r_grps,gid))
			bitstr_unmask(shares.shadata[i].r_grps,gid);
			
		if(bitstr_get(shares.shadata[i].w_grps,gid))
			bitstr_unmask(shares.shadata[i].w_grps,gid);
		
	}
	
	Config_Write(MC_GROUP, &groups);
	Config_Write(MC_SHARE, &shares);
	
	return SUCCESS;
	
}

int Group_Get_Amount_Of_Members(char *grpname)
{
	int gid,j,k,count=0;
	LA_GROUPS	grpconf;
	
	
	if((gid=Group_Get_GID(grpname))<0) return gid;
	
	Config_Read(MC_GROUP,&grpconf);
	for(j=0;j<LA_MAX_USERS/32;j++) {
		if(grpconf.grpdata[gid].members[j] == 0 ) continue;
		for(k=0;k<32;k++) {	
			if(bitstr_get(grpconf.grpdata[gid].members,j*32+k))
				count++;
		}
	}
	
	return count;
}

int User_Belong_Group_ID(char *username)
{
	int uid;
	int i=0,j=0;	
	LA_GROUPS grpconf;
	unsigned int bit_value=0;
	
	if((uid=User_Get_UID(username))<0) return uid;
	
	Config_Read(MC_GROUP,&grpconf);
	
	for(i=0;i<MAX_GROUPS/32;i++) {
		if(grpconf.bitstr[i] == 0 ) continue;
		
		for(j=0;j<32;j++) {
			bit_value = ( grpconf.bitstr[i] >> j ) & 0x00000001 ; 
			if(bit_value) {
				if(bitstr_get(grpconf.grpdata[i*32+j].members,uid))
					return i*32+j;
			}
		}
	}
	return -1;
	
}

int User_Add_To_Group(char *username,char *grpname)
{
	int uid,gid;
	LA_GROUPS grpconf;
	
//	if(Group_Get_Amount_Of_Members(grpname) >= LA_MAX_GRP_MEMBERS) 
//		return ERR_OVERFLOW;	
	
	if((uid=User_Get_UID(username))<0) return uid;
	if((gid=Group_Get_GID(grpname))<0) return gid;
	
	Config_Read(MC_GROUP,&grpconf);
	if(bitstr_get(grpconf.grpdata[gid].members,uid))
		return ERR_DUPUSER_IN_GROUP;
				
	bitstr_mask(grpconf.grpdata[gid].members,uid);
	
	Config_Write(MC_GROUP,&grpconf);
	
	return SUCCESS;
}

int User_Remove_From_Group(char *username,char *grpname)
{
	int uid,gid;
	LA_GROUPS grpconf;
	
	if((uid=User_Get_UID(username))<0) return uid;
	if((gid=Group_Get_GID(grpname))<0) return gid;
	
	Config_Read(MC_GROUP,&grpconf);
	if(bitstr_get(grpconf.grpdata[gid].members,uid)){
		bitstr_unmask(grpconf.grpdata[gid].members,uid);
		return SUCCESS;	
	}
	
	return ERR_USER_NOT_IN_GROUP;
}

int Update_Passwd_File()
{
	FILE *fp,*smbfp;
	LA_USERS userconf;
	int i=0,j=0;
	unsigned int bit_value=0;
	
	if((fp=fopen(PASSWD_PATH,"w")) == NULL )
		return FAILED;	
	if((smbfp=fopen(SMBPASSWD_PATH,"w")) == NULL )
		return FAILED;	
	
	
	Config_Read(MC_USER,&userconf);
	
	for(i=0;i<LA_MAX_USERS/32;i++) {
		if(userconf.bitstr[i] == 0 ) continue;
		
		for(j=0;j<32;j++) {
			bit_value = ( userconf.bitstr[i] >> j ) & 0x00000001 ; 
			if(bit_value) {
				if(userconf.usrdata[i*32+j].uid == 1) {
#ifndef QMAIL
					fprintf(fp,"%s::%d:0:::\n",userconf.usrdata[i*32+j].name,
								    userconf.usrdata[i*32+j].uid);
#else
					fprintf(fp,"%s::%d:0::/mnt/HDA/home/%s:\n",userconf.usrdata[i*32+j].name,
								    		   userconf.usrdata[i*32+j].uid,
								    		   userconf.usrdata[i*32+j].name);	
#endif
				}
				else
#ifndef QMAIL
					fprintf(fp,"%s:x:%d:0:::\n",userconf.usrdata[i*32+j].name,
								    userconf.usrdata[i*32+j].uid);
#else
					fprintf(fp,"%s:x:%d:0::/mnt/HDA/home/%s:\n",userconf.usrdata[i*32+j].name,
								    		   userconf.usrdata[i*32+j].uid,
								    		   userconf.usrdata[i*32+j].name);

#endif
				fprintf(smbfp,"%s:%d:NO PASSWORDXXXXXXXXXXXXXXXXXXXXX:NO PASSWORDXXXXXXXXXXXXXXXXXXXXX:::\n",userconf.usrdata[i*32+j].name,
							    userconf.usrdata[i*32+j].uid);
			}
		}
	}
#ifdef QMAIL
	fprintf(fp,"alias:x:2001:2000::/var/qmail/alias:/bin/bash\n");
	fprintf(fp,"qmaild:x:2002:2000::/var/qmail:/bin/bash\n");
	fprintf(fp,"qmaill:x:2003:2000::/var/qmail:/bin/bash\n");
	fprintf(fp,"qmailp:x:2004:2000::/var/qmail:/bin/bash\n");
	fprintf(fp,"qmailq:x:2005:2001::/var/qmail:/bin/bash\n");
	fprintf(fp,"qmailr:x:2006:2001::/var/qmail:/bin/bash\n");
	fprintf(fp,"qmails:x:2007:2001::/var/qmail:/bin/bash\n");
#endif
	fclose(smbfp);
	fclose(fp);
/*
	for(i=0;i<LA_MAX_USERS/32;i++) {
		if(userconf.bitstr[i] == 0 ) continue;
		for(j=0;j<32;j++) {
			bit_value = ( userconf.bitstr[i] >> j ) & 0x00000001 ; 
			if(bit_value && strcasecmp(userconf.usrdata[i*32+j].password,"")) {
				char cmd_line[80];
				sprintf(cmd_line,"%s %s %s",SMBPASSWD_APP_PATH,
							    userconf.usrdata[i*32+j].name,
							    userconf.usrdata[i*32+j].password);
							
				system(cmd_line);
			}
		}
	}
	
*/	
	return SUCCESS;
	
}

int Update_Smbpasswd_File()
{
	LA_USERS userconf;
	int i=0,j=0;
	unsigned int bit_value=0;
		
	Config_Read(MC_USER,&userconf);
	for(i=0;i<LA_MAX_USERS/32;i++) {
		if(userconf.bitstr[i] == 0 ) continue;
		for(j=0;j<32;j++) {
			bit_value = ( userconf.bitstr[i] >> j ) & 0x00000001 ; 
			if(bit_value && strcasecmp(userconf.usrdata[i*32+j].password,"")) {
				char cmd_line[80];
				sprintf(cmd_line,"%s %s %s",SMBPASSWD_APP_PATH,
							    userconf.usrdata[i*32+j].name,
							    userconf.usrdata[i*32+j].password);
							
				system(cmd_line);
			}
		}
	}
	return SUCCESS;
}

int Update_Group_File()
{
	
	int fd;
	LA_GROUPS grpconf;
	int i=0,j=0,k=0,l=0,ret;
	unsigned int bit_value=0;

	
	if((fd=open("/etc/group",O_RDWR|O_TRUNC)) == -1 )
		return FAILED;	

//for(i=0;i<2048;i++) write(fd,"hello,",6);

	Config_Read(MC_GROUP,&grpconf);

	for(i=0;i<MAX_GROUPS/32;i++) {
		if(grpconf.bitstr[i] == 0 ) continue;
		for(j=0;j<32;j++) {
			bit_value = ( grpconf.bitstr[i] >> j ) & 0x00000001 ; 
			if(bit_value) {
				char name[MAX_USERNAME_LEN];
				char tmpbuf[256];
				sprintf(tmpbuf,"%s:x:%d:",grpconf.grpdata[i*32+j].name,
						      grpconf.grpdata[i*32+j].gid);			
				write(fd,tmpbuf,strlen(tmpbuf));
				
				for(k=0;k<LA_MAX_USERS/32;k++) {
					if(grpconf.grpdata[i*32+j].members[k] == 0) continue;
					for(l=0;l<32;l++) {	
						if(bitstr_get(grpconf.grpdata[i*32+j].members,k*32+l)){
							User_Get_Name(name,k*32+l);
							sprintf(tmpbuf,"%s,",name);
							write(fd,tmpbuf,strlen(tmpbuf));
						}
					}
				}
				lseek(fd,-1,SEEK_CUR);
				write(fd,"\n",strlen("\n"));
			}
		}
	}
#ifdef QMAIL
	write(fd,"nofiles:x:2000:\n",strlen("nofiles:x:2000:\n"));
	write(fd,"qmail:x:2001:\n",strlen("qmail:x:2001:\n"));
#endif

	close(fd);

	return SUCCESS;
	
}

int Users_Remove_From_System(int *uid_list,int cnt)
{
	int uid = -1;
	int i=0,j=0,mm=0;
	unsigned int bit_value=0;
	
	LA_USERS	users;
	LA_GROUPS	groups;
	LA_SHARES	shares;	

	Config_Read(MC_USER, &users);
	Config_Read(MC_GROUP, &groups);
	Config_Read(MC_SHARE, &shares);
	
	
	for(mm=0;mm<cnt;mm++) {
	uid = uid_list[mm];	
	if(uid ==0 || uid == 1) continue;
	
	Remove_NFS_User(uid);
	
	users.bitstr[uid/32] &= ~(0x00000001 << (uid%32)) ;
	
	for(i=0;i<MAX_GROUPS/32;i++) {
		if(groups.bitstr[i] == 0 ) continue;
		for(j=0;j<32;j++) {
			bit_value = ( groups.bitstr[i] >> j ) & 0x00000001 ; 
			if(bit_value) {
				if(bitstr_get(groups.grpdata[i*32+j].members,uid)) {
#ifdef QMAIL
					if(HD_Is_Initial(0)&&(HD_Get_Action_Flag(0) == HD_READY)) {
						char cmdline[80],username[MAX_USERNAME_LEN];
						User_Get_Name(username,uid);
						sprintf(cmdline,"/bin/rm -rf %s/home/%s", HD_Get_Mounting_Path(0), username);	
						system(cmdline);
					}
#endif
					bitstr_unmask(groups.grpdata[i*32+j].members,uid);
				}
			}
		}
	}	
	
	for(i=0;i<shares.count;i++) {
		if(bitstr_get(shares.shadata[i].r_users,uid))
			bitstr_unmask(shares.shadata[i].r_users,uid);
			
		if(bitstr_get(shares.shadata[i].w_users,uid))
			bitstr_unmask(shares.shadata[i].w_users,uid);
		
	}
	}//end for mm
	Config_Write(MC_USER, &users);
	Config_Write(MC_GROUP, &groups);
	Config_Write(MC_SHARE, &shares);
	
	return SUCCESS;	
}

int Groups_Remove_From_System(int *gid_list,int cnt)
{
	
	int gid = -1;
	int i=0,mm=0;
	
	LA_GROUPS	groups;
	LA_SHARES	shares;	

	Config_Read(MC_GROUP, &groups);
	Config_Read(MC_SHARE, &shares);
	
	
	
	for(mm=0;mm<cnt;mm++) {
	gid = gid_list[mm];
	if(gid == 0 ) continue;
	groups.bitstr[gid/32] &= ~(0x00000001 << (gid%32)) ;
	
	for(i=0;i<shares.count;i++) {
		if(bitstr_get(shares.shadata[i].r_grps,gid))
			bitstr_unmask(shares.shadata[i].r_grps,gid);
			
		if(bitstr_get(shares.shadata[i].w_grps,gid))
			bitstr_unmask(shares.shadata[i].w_grps,gid);
		
	}
	}//end for mm
	Config_Write(MC_GROUP, &groups);
	Config_Write(MC_SHARE, &shares);
	
	return SUCCESS;
}

int Group_Members_Update(char *grpname,int *mem_id_list, int cnt,int new_flag)
{
	
	if(new_flag) {
		LA_GROUPS grpconf;
		int i=0,j=0,k=0;
		unsigned int bit_value=0;
	
		if(Group_Get_GID(grpname)>0) return ERR_DUPLICATED_GROUP;
	
		Config_Read(MC_GROUP,&grpconf);
		for(i=0;i<MAX_GROUPS/32;i++) {
			if(grpconf.bitstr[i] == 0xffffffff ) continue;
		
			for(j=0;j<32;j++) {
				bit_value = ( grpconf.bitstr[i] >> j ) & 0x00000001 ; 
				if(!bit_value) {
					grpconf.bitstr[i] |= 0x00000001 << j;
					grpconf.grpdata[i*32+j].gid = i*32+j;
					strcpy(grpconf.grpdata[i*32+j].name,grpname);
					//grpconf.grpdata[i*32+j].nr_members = 0;
					//memset((void*)grpconf.grpdata[i*32+j].members,0,MAX_USERS);
					bitstr_clean(grpconf.grpdata[i*32+j].members);
					if(cnt>=0){
						//grpconf.grpdata[i*32+j].nr_members = cnt;
						for(k=0;k<cnt;k++) 
							bitstr_mask(grpconf.grpdata[i*32+j].members,mem_id_list[k]);
					}
					Config_Write(MC_GROUP,&grpconf);
					return SUCCESS;
				}
			}		
		}
		return ERR_OVERFLOW;
	}
	else {
	
		int gid,i=0,j=0,k=0,l=0,found=0;
		LA_GROUPS grpconf;
		LA_GROUP_DATA old_grpdata;
		if((gid=Group_Get_GID(grpname))<0) return gid;
	
		Config_Read(MC_GROUP,&grpconf);
		old_grpdata = grpconf.grpdata[gid];
		
		if(cnt>=0) {
			bitstr_clean(grpconf.grpdata[gid].members);
			for(i=0;i<cnt;i++) {
				if(gid == 0 && (mem_id_list[i] == 0 || mem_id_list[i] == 1)) 
					continue;
				bitstr_mask(grpconf.grpdata[gid].members,mem_id_list[i]);
			}
			if(!gid) { 
				bitstr_mask(grpconf.grpdata[0].members,0);
				bitstr_mask(grpconf.grpdata[0].members,1);
			}
		}
		
		
//for(i=0;i<5;i++) printf("grpname=%s\n",grpconf.grpdata[i].name);	
		Config_Write(MC_GROUP,&grpconf);
	
		return SUCCESS;
	}
}

int Group_Change_Name(char *pOldGroupName, char *pNewGroupName)
{
	LA_GROUPS groupConfig;
	int i;
	int j;
	unsigned int bitValue = 0;
	int retValue = SUCCESS;

	memset(&groupConfig, 0x00, sizeof(LA_GROUPS));	
	Config_Read(MC_GROUP,&groupConfig);

	for(i=0; i<MAX_GROUPS/32; i++) {
		if(groupConfig.bitstr[i] == 0)
			continue;

		for(j=0; j<32; j++) {
			bitValue = (groupConfig.bitstr[i] >> j) & 0x00000001;

			if(bitValue != 0 && 
				!strcasecmp(pOldGroupName, groupConfig.grpdata[i*32 + j].name))	{
				strcpy(groupConfig.grpdata[i*32 + j].name, pNewGroupName);
				Config_Write(MC_GROUP, &groupConfig);
				retValue = SUCCESS;
				goto labelFinish;
			}
		}
	}

labelFinish:
	return retValue;
}
