/********************************************************************************
*
*	Copyright (c) 2002  Magic Control Technology Co.  All Rights Reserved.
*
*	FILE:
*		getcfg.c
*
*	Abstract: 
*		get config data
*
*	HISTORY:
*		2002/3/7	Louis Tsai Created
*********************************************************************************/

#include <stdio.h>
#include <string.h>
#include <sys/time.h>
#include "libconf.h"
#include "hd_ctl.h"

void usage()
{
	char usage[]={"usage: getcfg data_name\n"
		      "List avarible data_name as below,\n"
		      "sethostip->set the hostname and ipaddress on /etc/hosts\n"
		      "wanif	->wan interface(dhcpc,pppoe,fixed) \n"
		      "wanip	->fixed publc ip\n"
		      "wangw	->wan gateway\n"
		      "wannm	->wan network mask\n"
		      "hostname ->get hostname\n"	
		      };
	
	printf("%s",usage);
	
}

#if defined(NAS)
static int check_share_exist(char *name)
{
	LA_SHARES shares_info;
	int i;
	
	Config_Read(MC_SHARE,&shares_info);		
	
	for(i=0;i<shares_info.count;i++) {
		if(!strcasecmp(shares_info.shadata[i].name,name))
			return 1;
	}
	return 0;
}

static void add_share_folder(char *name) 
{
	
	LA_SHARES shares_info;
	int i;
	
	Config_Read(MC_SHARE,&shares_info);		
	
	for(i=0;i<shares_info.count;i++) {
		if(!strcasecmp(shares_info.shadata[i].name,name))
			return;
	}
	
	strcpy(shares_info.shadata[shares_info.count].name,name);
	bitstr_mask(shares_info.shadata[shares_info.count].w_grps,0);  // add writing privilege for everyone
	shares_info.count++;
	if(!shares_info.cifs_enable) {
		shares_info.cifs_enable = 1;
		strcpy(shares_info.workgrp_name,"WORKGROUP");
		strcpy(shares_info.computer_des,"NAS");
	}
	
	Config_Write(MC_SHARE,&shares_info);
	Shares_Updated_Conf_File();
}

static int check_hd_in_partable(char *name)
{
	FILE *tmpfp;
	//check usb attached hd
	// step 1: scan current partition table
	system("/bin/cat /proc/partitions > /tmp/part.tmp");
	if((tmpfp=fopen("/tmp/part.tmp","r"))!=NULL) {
		char tmpline[80],parname[30];
		int major_num,minor_num;
		unsigned long blocks_num;
		fgets(tmpline,80,tmpfp);
		fgets(tmpline,80,tmpfp);
		while(fgets(tmpline,80,tmpfp)!=NULL) {
			sscanf(tmpline,"%d %d %ld %s",&major_num,&minor_num,&blocks_num,parname);
			if(major_num == 8) {
				if(strlen(parname)==3) {
					char mtname[80];
					sprintf(mtname,"USBHD%c",'A'+minor_num/16);
					if (!strncmp(mtname,name,6)) 
					{	
						fclose(tmpfp);	
						unlink("/tmp/part.tmp");
						return 1;
					}
				}
			}
		}
		fclose(tmpfp);	
		unlink("/tmp/part.tmp");
	}
	return 0;
}

static void add_usbhd_share_folder()
{
	FILE *tmpfp;
	//check usb attached hd
	// step 1: scan current partition table
	system("/bin/cat /proc/partitions > /tmp/part.tmp");
	if((tmpfp=fopen("/tmp/part.tmp","r"))!=NULL) {
		char tmpline[80],parname[30];
		int major_num=0,minor_num=0,thumb_usb_storage=0,first_line=1;
		unsigned long blocks_num=0,total_blocks=0;
		fgets(tmpline,80,tmpfp);
		fgets(tmpline,80,tmpfp);
		while(fgets(tmpline,80,tmpfp)!=NULL) {
			sscanf(tmpline,"%d %d %ld %s",&major_num,&minor_num,&blocks_num,parname);
			
			
			if(major_num == 8) {
				if(strlen(parname)==3) {
					if(thumb_usb_storage && !first_line) {
						char cmdline[200];
						sprintf(cmdline,"USBHD%c",'A'+minor_num/16);
						if(check_share_exist(cmdline)) continue;
sprintf(tmpline,"/bin/echo \"%d %d %ld %s\" >>/tmp/test2",major_num,minor_num,blocks_num,parname);
system(tmpline);
						sprintf(cmdline,"/bin/mkdir -p /mnt/USBHD%c",'A'+minor_num/16);
						system(cmdline);
						sprintf(cmdline,"/bin/mount -t vfat -o sync -o uid=0 -o gid=0 -o umask=000 /dev/sd%c /mnt/USBHD%c",'a'+minor_num/16,'A'+minor_num/16);	
						if(!system(cmdline)) {
							sprintf(cmdline,"USBHD%c",'A'+minor_num/16);
	   						add_share_folder(cmdline);
						}	
						thumb_usb_storage = 0;
					}
					total_blocks = blocks_num;
					first_line=0;
				}
				else if(!thumb_usb_storage){
					if(blocks_num>total_blocks) thumb_usb_storage=1;
					else {
						char cmdline[200];
						sprintf(cmdline,"USBHD%c%d",'A'+minor_num/16,'A'+minor_num%16);
						if(check_share_exist(cmdline)) continue;
sprintf(tmpline,"/bin/echo \"%d %d %ld %s\" >>/tmp/test2",major_num,minor_num,blocks_num,parname);
system(tmpline);
						sprintf(cmdline,"/bin/mkdir -p /mnt/USBHD%c%d",'A'+minor_num/16,minor_num%16);
						system(cmdline);
						sprintf(cmdline,"/bin/mount -t vfat -o sync -o uid=0 -o gid=0 -o umask=000 /dev/sd%c%d /mnt/USBHD%c%d",'a'+minor_num/16,minor_num%16,'A'+minor_num/16,minor_num%16);	
						if(!system(cmdline)) {
							sprintf(cmdline,"USBHD%c%d",'A'+minor_num/16,minor_num%16);
	   						add_share_folder(cmdline);
						}	
					}
				}
			}
		}
		fclose(tmpfp);	
		unlink("/tmp/part.tmp");
	}	
}
#endif

int main(int argc,char **argv)
{
	REG_NET_CONF netconf;
	
	int ret;
	
	
	if(strcasecmp(argv[0],"fwver")==0) {
		unsigned short	version;	
		Config_Read(MC_GET_FWVER, &version);
		printf("Firmware Version: %d.%02x\n", version>>8, version & 0xff);
		return 0;
	}
	if(argc < 2) {
		usage();
		return -1;
	}
	ret=Config_Read(MC_NET_CONFIG, &netconf);	
//printf("ret=%d\n",ret);		
//printf("%s %s \n",argv[0],argv[1]);
	if(strcasecmp(argv[1],"sethostip") == 0 )
		MCT_Set_Hosts_File();
	else if(strcasecmp(argv[1],"wanip") == 0 ) {
	
		printf("%s",webip2str(netconf.public_ip));
		
	}
	else if(strcasecmp(argv[1],"routed_enable") == 0 ) {
		REG_ROUTE_CONF	routeconf;
		Config_Read(MC_ROUTE_CONFIG, &routeconf);
		return routeconf.enable;
	}
#if 0
	else if ( strcasecmp(argv[1], "genpdnsconf") == 0 )
		PDNS_Create_Setup_File();
#endif
	else if(strcasecmp(argv[1],"cleanresolv") == 0 )
		MCT_Clean_Resolv_File();
	else if(strcasecmp(argv[1],"updateresolv") == 0 )
		MCT_Update_Resolv_File();
#ifdef IPSEC
	else if(strcasecmp(argv[1],"getpptpconf") == 0 )
		PPTP_Create_Setup_File();
	else if(strcasecmp(argv[1],"pptp_enable") == 0 )
		return PPTP_Is_Enable();
	else if(strcasecmp(argv[1],"gen_ipsecconf") == 0 )
		IPSEC_Create_Setup_File();
	else if(strcasecmp(argv[1],"ipsec_enable") == 0 )
		return IPSEC_Is_Enable();
#endif
#ifdef ROUTER
	else if(strcasecmp(argv[1],"gen_filter_rule") == 0 ){
		VSERVER_Create_Setup_File();
		IP_ACCESS_Create_Setup_File();
		ANTIHACK_Create_Setup_File();
	}
#endif
	else if(strcasecmp(argv[1],"gen_pppoe_conf") == 0 )
		PPPOE_Create_Setup_File();
	else if(strcasecmp(argv[1],"pppoe_mtu") == 0) {
		 int pppoe_mtu;
		 Config_Read(MC_PPPOE_MTU, &pppoe_mtu);
		 if(pppoe_mtu <=0 || pppoe_mtu > 1492 ) printf("1492");
		 else  printf("%d",pppoe_mtu);
	}
	else if(strcasecmp(argv[1],"gen_pptpc_conf") == 0 )
		PPTPC_Create_Setup_File();
	else if(strcasecmp(argv[1],"get_pptpc_myip") == 0 ){
		REG_NET_CONF netconf;
		Config_Read(MC_NET_CONFIG, &netconf);
		printf("%s",webip2str(netconf.my_ip));
	}
	else if(strcasecmp(argv[1],"dhcps_enable") == 0 ){
		REG_DHCP_CONF dhcpconf;
		Config_Read(MC_DHCP_CONFIG, &dhcpconf);
		return dhcpconf.enable;
	}
#ifdef DDNS
	else if(strcasecmp(argv[1],"gen_ddns_conf") == 0 )
		DDNS_Create_Setup_File();
	else if(strcasecmp(argv[1],"ddns_enable") == 0 ){
		REG_DDNS_CONF ddnsconf;
		Config_Read(MC_DDNS_CONFIG,&ddnsconf);
		return ddnsconf.enable;
	}
#endif
#ifdef SNMP
	else if(strcasecmp(argv[1],"snmp_enable") == 0 ){
		REG_SNMP_CONF snmpconf;
		Config_Read(MC_SNMP_CONFIG,&snmpconf);
		return snmpconf.enable;
	}
#endif
	else if(strcasecmp(argv[1],"get_pptpc_serverip") == 0 ){
		REG_NET_CONF netconf;
		Config_Read(MC_NET_CONFIG, &netconf);
		printf("%s",webip2str(netconf.remote_ip));
		
	}	
	else if(strcasecmp(argv[1],"wanif") == 0 ) {
		return netconf.public_if;
	}
	else if(strcasecmp(argv[1],"wangw") == 0 ) 
		printf("%s",webip2str(netconf.gateway));
	else if(strcasecmp(argv[1],"wannm") == 0 )
		printf("%s",webip2str(netconf.public_netmask));
	else if(strcasecmp(argv[1],"lanip") == 0 )
		printf("%s",webip2str(netconf.private_ip));
	else if(strcasecmp(argv[1],"lannm") == 0 )
		printf("%s",webip2str(netconf.private_netmask));
	else if(strcasecmp(argv[1],"hostname") == 0 )
		printf("%s",netconf.hostname);
	else if(strcasecmp(argv[1],"waninfo") == 0 ) {
		NIC_INFO waninfo;
		int ret;
		
		ret = NIC_Get_WAN_Info(&waninfo);
		printf("%s",ret,waninfo.ipaddr);
	
	} 
	else if ( strcasecmp(argv[1], "nat") == 0 ) {
		return netconf.enable_nat;
	} 
	else if( strcasecmp(argv[1], "bpa_enable") == 0) {
		REG_BPA_CONF bpaconf;
		Config_Read(MC_BPA_CONFIG, &bpaconf);
		return bpaconf.enable;
	}	
	else if( strcasecmp(argv[1], "gen_bpaconf") == 0) 
		gen_bpaconf();
		
#if 0
	else if (strcasecmp(argv[1],"initlog") == 0 ) {
		MCT_Init_Logs();
		MCT_Add_Logs("test1",LEVEL_NORMAL);
		MCT_Add_Logs("test2",LEVLE_WARNING);
		MCT_Add_Logs("test3",LEVEL_URGRNT);
	}
#endif
	else if ( strcasecmp(argv[1],"gen_ipalias_conf") == 0 )
		IPALIAS_Create_Setup_File();
	else if ( strcasecmp(argv[1],"gen_mnat_conf") == 0 )
		Multi_NAT_Create_Setup_File();
#if defined(NAS)
	else if ( strcasecmp(argv[1],"gen_passwd") == 0 )
		Update_Passwd_File();
	else if ( strcasecmp(argv[1],"gen_group") == 0 )
		Update_Group_File();
	else if ( strcasecmp(argv[1],"gen_smbpass") == 0 )
		Update_Smbpasswd_File();
	else if ( strcasecmp(argv[1],"gen_samba_conf") == 0 )
		Shares_Updated_Conf_File();
	else if ( strcasecmp(argv[1],"nfs_enable") == 0){
		REG_NFS_CONF nfsconf;
		Config_Read(MC_NFS_CONFIG,&nfsconf);
		return nfsconf.enable;
	}
	else if( strcasecmp(argv[1],"gen_exports") == 0)
		NFS_Create_Exports();
	else if ( strcasecmp(argv[1],"add_nfs_user") == 0)
	{
		Add_NFS_Config("louis",0,NFSIP_SINGLE,inet_addr("192.168.1.101"),32);		
	}
	else if ( strcasecmp(argv[1],"del_nfs_user") == 0)
	{
		printf("enter del_nfs\n");
		Clean_NFS_Users();
	}
	else if ( strcasecmp(argv[1],"load_nfs_user") == 0) {
		NFS_USER_EX nfsuser[20];
		int count = 20,i;
		
		Load_All_NFS_Users(nfsuser,&count);
		printf("count=%d\n",count);
		for(i=0;i<count;i++) {
			printf("%s %d %d\n",nfsuser[i].username,nfsuser[i].uid,nfsuser[i].type);
		}	
	}
	else if ( strcasecmp(argv[1],"hdinit") == 0) {
//printf("flag=%d\n",HD_Get_Action_Flag(0));
		if(HD_Get_Action_Flag(0) == HD_READY) {
			char cmdline[80];
			REG_IDESMART_CONF idesmart_conf;
			
//			sprintf(cmdline,"/sbin/e2fsck %s",HD_Get_Partition_Path(0));
//			system(cmdline);
			sprintf(cmdline,"%s -p %s",MKDIR,HD_Get_Mounting_Path(0));
			system(cmdline);
			sprintf(cmdline,"%s -t ext3 %s %s",MOUNT,HD_Get_Partition_Path(0),HD_Get_Mounting_Path(0));
			system(cmdline);
			Config_Read(MC_IDESMART_CONFIG,&idesmart_conf);
			
			HD_Enable_SMART(0,idesmart_conf.enable);
			HD_Set_Standby_Timeout(0,idesmart_conf.stimer);	
			Shares_Add_From_Formated_HD();
			
			if(HD_Check_Mount(HD_Get_Mounting_Path(0))) {
				sprintf(cmdline,"/bin/cp -af /etc/samba/codepage950.tgz /mnt/HDA");
				system(cmdline);
		
				sprintf(cmdline,"/bin/gzip -d /mnt/HDA/codepage950.tgz");
				system(cmdline);
		
				chdir(HD_Get_Mounting_Path(0));
		
				sprintf(cmdline,"/bin/tar vxf %s/codepage950",HD_Get_Mounting_Path(0));	
				system(cmdline);
		
				sprintf(cmdline,"/bin/rm -f %s/codepage950",HD_Get_Mounting_Path(0));	
				system(cmdline);

			}
		}
		else {
			REG_NFS_CONF nfsconf;
			LA_SHARES sha_info;
			REG_MAIL_CONF mailconf;
			REG_W3S_CONF w3s_conf;
			
			HD_Remove_Label(0);
			
			Shares_Get_All_Info(&sha_info);
			sha_info.cifs_enable = 0;
			sha_info.mac_enable  = 0;
			sha_info.ftp_enable  = 0;
			Config_Write(MC_SHARE,&sha_info);
			
			Config_Read(MC_NFS_CONFIG,&nfsconf);
			nfsconf.enable = 0;
			Config_Write(MC_NFS_CONFIG,&nfsconf);
			
			Config_Read(MC_MAIL_CONFIG,&mailconf);
			mailconf.enable = 0;
			Config_Write(MC_MAIL_CONFIG,&mailconf);
			
			Config_Read(MC_W3S_CONFIG,&w3s_conf);
			w3s_conf.enable = 0;
			Config_Write(MC_W3S_CONFIG,&w3s_conf);
			
		}
		add_usbhd_share_folder();
	}
	else if ( strcasecmp(argv[1],"hd_get_flag") == 0) {
		printf("flag=%d\n",HD_Get_Action_Flag(0));
	}
	else if ( strcasecmp(argv[1],"hd_set_flag") == 0) {
		HD_Add_Label(0);
		HD_Set_Action_Flag(0,atoi(argv[2]));
	}
	else if ( strcasecmp(argv[1],"hd_init") == 0) {
		HD_Remove_Label(0); //added this to force initializing hd everytime . REMOVE IT ........
		HD_Initialization(0);
	}
	else if ( strcasecmp(argv[1],"cmbr") == 0)
		 HD_Clear_MBR(0);
	else if ( strcasecmp(argv[1],"fwbackup") == 0 ){
		printf("before fwbackup\n");
		printf("ret = %d\n",FW_Backup_To_HD(0));
		}
	else if ( strcasecmp(argv[1],"atalk_enable") == 0 ){
		LA_SHARES sha_info;
		Config_Read(MC_SHARE,&sha_info);
		return sha_info.mac_enable;
	}
	else if ( strcasecmp(argv[1],"ftp_enable") == 0 ){
		LA_SHARES sha_info;
		Config_Read(MC_SHARE,&sha_info);
		return sha_info.ftp_enable;
	}
	else if ( strcasecmp(argv[1],"cifs_enable") == 0 ){
		LA_SHARES sha_info;
		Config_Read(MC_SHARE,&sha_info);
		return sha_info.cifs_enable;
	}
	else if ( strcasecmp(argv[1],"atalk_gen_wname") == 0) {
		LA_SHARES sha_info;
		Config_Read(MC_SHARE,&sha_info);
		printf("%s:Workstation@%s",netconf.hostname,sha_info.applezone);	
	}
	else if ( strcasecmp(argv[1],"atalk_gen_aname") == 0) {
		LA_SHARES sha_info;
		Config_Read(MC_SHARE,&sha_info);
		printf("%s:netatalk@%s",netconf.hostname,sha_info.applezone);
	}
	else if (strcasecmp(argv[1],"hdpm") == 0) {
		if(HD_Get_Power_State(0) == HDPS_ACTIVE) 
			printf("hd active\n");
		else
			printf("hd sleeping\n");
		
	}
	else if(strcasecmp(argv[1],"addusers") == 0) {
		int i,count;
		char name[20];
		count = atoi(argv[2]);
		for(i=0;i<count;i++) {
			sprintf(name,"mct%.3d",i);
			User_Add_To_System(name,"1234","everyone");
			printf("Add %s user to system\n",name);
		}	
	//	Update_Passwd_File();
	//	Update_Group_File();
	}
	else if(strcasecmp(argv[1],"defusr") == 0) {
		Config_Write(MC_DEFAULT_USR_GRP_SHARE,NULL);
	}	
#if defined(QMAIL)
	else if(!strcasecmp(argv[1],"checkmaildir"))
		Check_User_Maildir_On_Boot();
	else if(!strcasecmp(argv[1],"checkqmailsysdir"))
		Check_Qmail_Sysdir_On_Boot();
	else if(!strcasecmp(argv[1],"update_mailcfg")) {
		Update_Mailser_Config_Files();
	}
	else if(!strcasecmp(argv[1],"mail_enable")) {
		REG_MAIL_CONF mailconf;
		Config_Read(MC_MAIL_CONFIG, &mailconf);
		return mailconf.enable;
	}
#endif	
#if defined(W3S)
	else if(!strcasecmp(argv[1],"w3s_enable")) {
		REG_W3S_CONF w3s_conf;	
		LA_SHARES sha_info;
	
		Config_Read(MC_SHARE, &sha_info);
		Config_Read(MC_W3S_CONFIG,&w3s_conf);
		
		if(!sha_info.cifs_enable || !HD_Is_Initial(0) || (HD_Get_Action_Flag(0) != HD_READY) ) {
			w3s_conf.enable = 0;
			Config_Write(MC_W3S_CONFIG,&w3s_conf);
		}
		
		
		if(w3s_conf.enable) 
			W3S_Add_Shared_Folder();
		else
			W3S_Remove_Shared_Folder();
		
		return w3s_conf.enable;
	}
#endif
	else if(!strcasecmp(argv[1],"upnp_nas_enable")) {
		int en_upnp_nas;
		Config_Read(MC_UPNP_DEVICE_CONFIG, &en_upnp_nas);
		return en_upnp_nas;
	}
#ifdef UPNP_MMS
	else if(!strcasecmp(argv[1],"upnp_mms_enable")) {
		int en_upnp_media;
		Config_Read(MC_UPNP_MMS_CONFIG, &en_upnp_media);
		if(en_upnp_media) 
			Upnp_MMS_Add_Shared_Folder();
		else		  
			Upnp_MMS_Remove_Shared_Folder();
		return en_upnp_media;
	}
#endif
#endif  
	else if(!strcasecmp(argv[1],"grok")) {
		int fd,i;
			if ((fd = open("/dev/sda", O_RDWR)) < 0) {
				printf("cannot open /dev/sda\n");
				return 0;
			}
			if ((i = ioctl(fd, BLKRRPART)) != 0) {
       			 } else {
               			 if((i = ioctl(fd, BLKRRPART)) != 0);
        		}
			close(fd);
	}
	else if(!strcasecmp(argv[1],"mctkill")) {
		mct_killall(argv[2],atoi(argv[3]));
	}
	else if(!strcasecmp(argv[1],"start_hbled")){
		Config_Write(MC_START_HEARTBEAT,NULL);
	}
	else if(!strcasecmp(argv[1],"settimezone")){
		struct timeval tv; 
		struct timezone tz;
		gettimeofday(&tv,&tz);
		printf("time_zone_off=%d type_of_dst=%d\n",tz.tz_minuteswest,tz.tz_dsttime);
		if(argc == 3) {
			tz.tz_minuteswest = atoi(argv[2]);
			settimeofday(&tv,&tz);
		}
	}
	else if(!strcasecmp(argv[1],"ddns_option")){
		REG_DDNS_CONF ddnsconf;
		Config_Read(MC_DDNS_CONFIG,&ddnsconf);
		if(ddnsconf.service_type == 8 ) {
			char cmdline[128];
			sprintf(cmdline,"/sbin/dhrpc %s %s %s &",ddnsconf.username,
						         ddnsconf.password,
						         ddnsconf.hostname);
			system(cmdline);
		}
		return ddnsconf.service_type;
	}

	return 0;
}       


