
#include <unistd.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <netinet/in.h>
#include <linux/socket.h>
#include <asm/mconfig.h>

typedef struct {
	char	*cmd;
	void	(*func)(void);
} CMD_FUNC;

#define EXT_ITF		"eth0"
#define INT_ITF		"eth1"

static REG_NET_CONF	net_conf;
int			sockfd;

void set_network_flags(struct ifreq *ifr, unsigned int flags)
{
	ioctl(sockfd, SIOCGIFFLAGS, ifr); 
	ifr->ifr_flags |= flags;
	ioctl(sockfd, SIOCSIFFLAGS, ifr);
}

void clear_network_flags(struct ifreq *ifr, unsigned int flags)
{
	ioctl(sockfd, SIOCGIFFLAGS, ifr);
	ifr->ifr_flags &= ~flags;
	ioctl(sockfd, SIOCSIFFLAGS, ifr);
}

void network_start(void)
{
	struct ifreq		ifr;
	struct sockaddr_in	sa;
	unsigned long		ip;

	strcpy(ifr.ifr_name, INT_ITF);

	sa.sin_family = AF_INET;
	sa.sin_port = 0;
	ip = sa.sin_addr.s_addr = net_conf.private_ip;

	printf("Internal interface: %d.%d.%d.%d\n", ip & 0xff, (ip>>8) & 0xff, (ip>>16) & 0xff, (ip>>24) & 0xff);
	memcpy((char *) &ifr.ifr_addr, (char *) &sa, sizeof(struct sockaddr_in));
	ioctl(sockfd, SIOCSIFADDR, &ifr);

	set_network_flags(&ifr, IFF_UP|IFF_RUNNING);
}



CMD_FUNC cmd_func[] = {
	{ "start", network_start },
//	{ "stop", network_stop },
//	{ "restart", network_restart },
};

int main(int argc, char *argv[])
{
	int	i;
	char	*inst;

	if ( argc != 2 ) {
		printf("%s: invalid argument\n", argv[0]);	
		return 1;
	}

	inst = argv[1];
	for (i = 0; i < sizeof(cmd_func)/sizeof(CMD_FUNC); i++) {
		if ( strcmp(cmd_func[i].cmd, inst) == 0 ) 
			break;
	}

	if ( i == sizeof(cmd_func)/sizeof(CMD_FUNC) ) {
		printf("%s: invalid argument \"%s\"\n", argv[0], inst);
		return 1;
	} else {
		sockfd = socket(AF_INET, SOCK_DGRAM, 0);
		read_config(MC_NET_CONFIG, &net_conf);
		cmd_func[i].func();
		close(sockfd);
	}

	return 0;
}

