/*
 *  linux/arch/mips/toshiba-boards/generic/dump_tx4925.c
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2001 Toshiba Corporation
 *
 * $Id: dump_tx4925.c,v 1.1.1.1 2004/04/07 08:36:50 louistsai Exp $
 */
#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/pci.h>
#include <asm/tx4925.h>

void tx4925_dump_pcic_settings(void)
{
	int i;
	unsigned long *preg = (unsigned long *)tx4925_pcicptr;

	printk("tx4925 pcic settings:");
	for (i = 0; i < sizeof(struct tx4925_pcic_reg); i += 4) {
		if (i % 32 == 0)
			printk("\n%04x:", i);
		/* skip registers with side-effects */
		if (preg == &tx4925_pcicptr->g2pintack
		    || preg == &tx4925_pcicptr->g2pspc
		    || preg == &tx4925_pcicptr->g2pcfgdata
		    || preg == &tx4925_pcicptr->g2piddata
		    || preg == &tx4925_pcicptr->g2pidcmd
			) {
			printk(" XXXXXXXX");
			preg++;
			continue;
		}
		printk(" %08lx", *preg++);
	}
	printk("\n");
}

void tx4925_dump_irc_settings(void)
{
	int i;

	printk("tx4925 irc settings:\n");
	printk("cer:\t%08lx\n", tx4925_ircptr->cer);
	for (i = 0; i < 2; i++)
		printk("cr%d:\t%08lx\n", i, tx4925_ircptr->cr[i]);
	for (i = 0; i < 8; i++)
		printk("ilr%d:\t%08lx\n", i, tx4925_ircptr->ilr[i]);
	printk("imr:\t%08lx\n", tx4925_ircptr->cer);
	printk("scr:\t%08lx\n", tx4925_ircptr->scr);
	printk("ssr:\t%08lx\n", tx4925_ircptr->ssr);
	printk("csr:\t%08lx\n", tx4925_ircptr->csr);
}

void tx4925_dump_dmac_settings(int dmach)
{
	printk("tx4925 dmac[%d] settings:\n", dmach);
	printk("cha:\t%08lx\n", tx4925_dmaptr->ch[dmach].cha);
	printk("sar:\t%08lx\n", tx4925_dmaptr->ch[dmach].sar);
	printk("dar:\t%08lx\n", tx4925_dmaptr->ch[dmach].dar);
	printk("cntr:\t%08lx\tsair:\t%08lx\tdair:\t%08lx\n",
	       tx4925_dmaptr->ch[dmach].cntr,
	       tx4925_dmaptr->ch[dmach].sair,
	       tx4925_dmaptr->ch[dmach].dair);
	printk("ccr:\t%08lx\tcsr:\t%08lx\n",
	       tx4925_dmaptr->ch[dmach].ccr,
	       tx4925_dmaptr->ch[dmach].csr);
}

void tx4925_dump_dmac_settings_all(void)
{
	int i;

	printk("tx4925 dmac settings:\n");
	printk("mcr:\t%08lx\n", tx4925_dmaptr->mcr);
	for (i = 0; i < 4; i++)
		tx4925_dump_dmac_settings(i);
}

void tx4925_report_pcic_status(void)
{
	unsigned short pcistatus = (unsigned short)(tx4925_pcicptr->pcistatus >> 16);
	unsigned long g2pstatus = tx4925_pcicptr->g2pstatus;
	unsigned long pcicstatus = tx4925_pcicptr->pcicstatus;
	printk("pcistat:%04x(", pcistatus);
	if (pcistatus & PCI_STATUS_DETECTED_PARITY)
		printk("DetectedParityError ");
	if (pcistatus & PCI_STATUS_SIG_SYSTEM_ERROR)
		printk("SignaledSystemError ");
	if (pcistatus & PCI_STATUS_REC_MASTER_ABORT)
		printk("ReceivedMasterAbort ");
	if (pcistatus & PCI_STATUS_REC_TARGET_ABORT)
		printk("ReceivedTargetAbort ");
	if (pcistatus & PCI_STATUS_SIG_SYSTEM_ERROR)
		printk("SignaledSystemError ");
	if (pcistatus & PCI_STATUS_PARITY)
		printk("MasterParityError ");
	printk("), g2pstatus:%08lx(", g2pstatus);
	if (g2pstatus & TX4925_PCIC_G2PSTATUS_MDFE)
		printk("MDFE ");
	if (g2pstatus & TX4925_PCIC_G2PSTATUS_MDPE)
		printk("MDPE ");
	if (g2pstatus & TX4925_PCIC_G2PSTATUS_IDICC)
		printk("IDICC ");
	if (g2pstatus & TX4925_PCIC_G2PSTATUS_MIDPE)
		printk("MIDPE ");
	if (g2pstatus & TX4925_PCIC_G2PSTATUS_MIDFE)
		printk("MIDFE ");
	if (g2pstatus & TX4925_PCIC_G2PSTATUS_IDTTOE)
		printk("IDTTOE ");
	if (g2pstatus & TX4925_PCIC_G2PSTATUS_IDRTOE)
		printk("IDRTOE ");
	printk("), pcicstatus:%08lx(", pcicstatus);
	if (pcicstatus & TX4925_PCIC_PCICSTATUS_SERR)
		printk("SERR ");
	printk(")\n");
}
