/*
 *  linux/arch/mips/toshiba-boards/generic/dump_tx4927.c
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2001 Toshiba Corporation
 *
 * $Id: dump_tx4927.c,v 1.1.1.1 2004/04/07 08:36:50 louistsai Exp $
 */
#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/pci.h>
#include <asm/tx4927.h>

static inline void printk_ll(const char *fmt, unsigned long long val)
{
	printk(fmt, (unsigned long)(val >> 32), (unsigned long)val);
}

void tx4927_dump_pcic_settings(void)
{
	int i;
	unsigned long *preg = (unsigned long *)tx4927_pcicptr;

	printk("tx4927 pcic settings:");
	for (i = 0; i < sizeof(struct tx4927_pcic_reg); i += 4) {
		if (i % 32 == 0)
			printk("\n%04x:", i);
		/* skip registers with side-effects */
		if (preg == &tx4927_pcicptr->g2pintack
		    || preg == &tx4927_pcicptr->g2pspc
		    || preg == &tx4927_pcicptr->g2pcfgadrs
		    || preg == &tx4927_pcicptr->g2pcfgdata
			) {
			printk(" XXXXXXXX");
			preg++;
			continue;
		}
		printk(" %08lx", *preg++);
	}
	printk("\n");
}

void tx4927_dump_irc_settings(void)
{
	int i;

	printk("tx4927 irc settings:\n");
	printk("cer:\t%08lx\n", tx4927_ircptr->cer);
	for (i = 0; i < 2; i++)
		printk("cr%d:\t%08lx\n", i, tx4927_ircptr->cr[i]);
	for (i = 0; i < 8; i++)
		printk("ilr%d:\t%08lx\n", i, tx4927_ircptr->ilr[i]);
	printk("imr:\t%08lx\n", tx4927_ircptr->cer);
	printk("scr:\t%08lx\n", tx4927_ircptr->scr);
	printk("ssr:\t%08lx\n", tx4927_ircptr->ssr);
	printk("csr:\t%08lx\n", tx4927_ircptr->csr);
}

void tx4927_dump_dmac_settings(int dmach)
{
	printk("tx4927 dmac[%d] settings:\n", dmach);
	printk_ll("cha:\t%08lx_%08lx\n", tx4927_dmaptr->ch[dmach].cha);
	printk_ll("sar:\t%08lx_%08lx\n", tx4927_dmaptr->ch[dmach].sar);
	printk_ll("dar:\t%08lx_%08lx\n", tx4927_dmaptr->ch[dmach].dar);
	printk("cntr:\t%08lx\tsair:\t%08lx\tdair:\t%08lx\n",
	       tx4927_dmaptr->ch[dmach].cntr,
	       tx4927_dmaptr->ch[dmach].sair,
	       tx4927_dmaptr->ch[dmach].dair);
	printk("ccr:\t%08lx\tcsr:\t%08lx\n",
	       tx4927_dmaptr->ch[dmach].ccr,
	       tx4927_dmaptr->ch[dmach].csr);
}

void tx4927_dump_dmac_settings_all(void)
{
	int i;

	printk("tx4927 dmac settings:\n");
	printk("mcr:\t%08lx\n", tx4927_dmaptr->mcr);
	for (i = 0; i < 4; i++)
		tx4927_dump_dmac_settings(i);
}

void tx4927_report_pcic_status(void)
{
	unsigned short pcistatus = (unsigned short)(tx4927_pcicptr->pcistatus >> 16);
	unsigned long g2pstatus = tx4927_pcicptr->g2pstatus;
	unsigned long pcicstatus = tx4927_pcicptr->pcicstatus;
	printk("pcistat:%04x(", pcistatus);
	if (pcistatus & PCI_STATUS_DETECTED_PARITY)
		printk("DetectedParityError ");
	if (pcistatus & PCI_STATUS_SIG_SYSTEM_ERROR)
		printk("SignaledSystemError ");
	if (pcistatus & PCI_STATUS_REC_MASTER_ABORT)
		printk("ReceivedMasterAbort ");
	if (pcistatus & PCI_STATUS_REC_TARGET_ABORT)
		printk("ReceivedTargetAbort ");
	if (pcistatus & PCI_STATUS_SIG_SYSTEM_ERROR)
		printk("SignaledSystemError ");
	if (pcistatus & PCI_STATUS_PARITY)
		printk("MasterParityError ");
	printk("), g2pstatus:%08lx(", g2pstatus);
	if (g2pstatus & TX4927_PCIC_G2PSTATUS_TTOE)
		printk("TIOE ");
	if (g2pstatus & TX4927_PCIC_G2PSTATUS_RTOE)
		printk("RTOE ");
	printk("), pcicstatus:%08lx(", pcicstatus);
	if (pcicstatus & TX4927_PCIC_PCICSTATUS_PMESID)
		printk("PMESID ");
	if (pcicstatus & TX4927_PCIC_PCICSTATUS_TLBD)
		printk("TLBD ");
	if (pcicstatus & TX4927_PCIC_PCICSTATUS_NIBD)
		printk("NIBD ");
	if (pcicstatus & TX4927_PCIC_PCICSTATUS_ZIBD)
		printk("ZIBD ");
	if (pcicstatus & TX4927_PCIC_PCICSTATUS_PERRO)
		printk("PERRO ");
	if (pcicstatus & TX4927_PCIC_PCICSTATUS_SERRO)
		printk("SERRO ");
	if (pcicstatus & TX4927_PCIC_PCICSTATUS_GBED)
		printk("GBED ");
	if (pcicstatus & TX4927_PCIC_PCICSTATUS_IAA)
		printk("IAA ");
	if (pcicstatus & TX4927_PCIC_PCICSTATUS_IWB)
		printk("IWB ");
	printk(")\n");
}
