/*
 *  linux/arch/mips/toshiba-boards/generic/int-handler.S
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2001 Toshiba Corporation
 *
 * $Id: int-handler.S,v 1.1.1.1 2004/04/07 08:36:50 louistsai Exp $
 */

#include <asm/asm.h>
#include <asm/mipsregs.h>
#include <asm/regdef.h>
#include <asm/stackframe.h>

	/* A lot of complication here is taken away because:
	 *
	 * 1) We handle one interrupt and return, sitting in a loop
	 *    and moving across all the pending IRQ bits in the cause
	 *    register is _NOT_ the answer, the common case is one
	 *    pending IRQ so optimize in that direction.
	 *
	 * 2) We need not check against bits in the status register
	 *    IRQ mask, that would make this routine slow as hell.
	 *
	 * 3) Linux only thinks in terms of all IRQs on or all IRQs
	 *    off, nothing in between like BSD spl() brain-damage.
	 *
	 */

	.text
	.set	noreorder
	.set	noat
	.align	5
	NESTED(toshibaboards_IRQ, PT_SIZE, sp)
	SAVE_ALL
	CLI
	.set	at
	lw	t0, toshibaboards_irqdispatch
	jalr	t0
	 move	a0, sp
	bltz	v0,1f
	 nop
	j	ret_from_irq
	 nop
1:
	j	spurious_interrupt
	 nop
	END(toshibaboards_IRQ)
#if 0 /* EXCEPTION_DEBUG */
/* XXX debug buggy CPU... (see irq.c also) */
#define EXCEPTION_LOG_EPC	0
#if defined(CONFIG_CPU_TX49XX)
#define EXCEPTION_LOG_COUNT	4
#endif
#ifdef CONFIG_CPU_TX39XX
#define EXCEPTION_LOG_TIMER	4
#define EXCEPTION_LOG_TIMER_ADDR	0xfffef0f0 /* TX3927 timer */
#endif
#define EXCEPTION_LOG_CAUSE	8
#define EXCEPTION_LOG_BADV	12
#undef EXCEPTION_LOG_STATUS	12
#define EXCEPTION_LOG_MAX	16
	.align	5
EXPORT(exclog)
	.word	0 :	EXCEPTION_LOG_MAX*4+1
	.align	5
last_random_reg:
	.word	0
	.set	noat
	.set	noreorder
	NESTED(excdbg_vec0_handler, 0, sp)
	la	k0, exclog
	li	k1, KSEG1
	or	k0, k1
	lw	k1, (EXCEPTION_LOG_MAX*16)(k0)	/* load logcount */
	addiu	k1, 1
	andi	k1, EXCEPTION_LOG_MAX-1
	sw	k1, (EXCEPTION_LOG_MAX*16)(k0)	/* save logcount */
	sll	k1, k1, 4
	addu	k0, k1
#ifdef EXCEPTION_LOG_EPC
	mfc0	k1, CP0_EPC
	sw	k1, EXCEPTION_LOG_EPC(k0)
#endif
#ifdef EXCEPTION_LOG_COUNT
	mfc0	k1, CP0_COUNT
	sw	k1, EXCEPTION_LOG_COUNT(k0)
#endif
#ifdef EXCEPTION_LOG_TIMER
	lw	k1, EXCEPTION_LOG_TIMER_ADDR
	sw	k1, EXCEPTION_LOG_TIMER(k0)
#endif
#ifdef EXCEPTION_LOG_CAUSE
	mfc0	k1, CP0_CAUSE
	ori	k1, 1
	sw	k1, EXCEPTION_LOG_CAUSE(k0)
#endif
#ifdef EXCEPTION_LOG_BADV
	mfc0	k1, CP0_BADVADDR
	sw	k1, EXCEPTION_LOG_BADV(k0)
#endif
#ifdef EXCEPTION_LOG_STATUS
	mfc0	k1, CP0_STATUS
	sw	k1, EXCEPTION_LOG_STATUS(k0)
#endif
	/* If the number of TLB refill code is multiple of TLB entries,
	 * The Random Register may be same value forever. */
	lw	k0, last_random_reg
1:
	mfc0	k1, CP0_RANDOM
	beq	k0, k1, 1b
	 nop
	la	k0, last_random_reg
	sw	k1, (k0)
#if defined(CONFIG_CPU_TX49XX)
	j	except_vec0_r4000
#endif
#if defined(CONFIG_CPU_TX39XX)
	j	except_vec0_r2300
#endif
	nop
	END(excdbg_vec0_handler)
	NESTED(excdbg_vec3_handler, 0, sp)
	la	k0, exclog
	li	k1, KSEG1
	or	k0, k1
	lw	k1, (EXCEPTION_LOG_MAX*16)(k0)	/* load logcount */
	addiu	k1, 1
	andi	k1, EXCEPTION_LOG_MAX-1
	sw	k1, (EXCEPTION_LOG_MAX*16)(k0)	/* save logcount */
	sll	k1, k1, 4
	addu	k0, k1
#ifdef EXCEPTION_LOG_EPC
	mfc0	k1, CP0_EPC
	sw	k1, EXCEPTION_LOG_EPC(k0)
#endif
#ifdef EXCEPTION_LOG_COUNT
	mfc0	k1, CP0_COUNT
	sw	k1, EXCEPTION_LOG_COUNT(k0)
#endif
#ifdef EXCEPTION_LOG_TIMER
	lw	k1, EXCEPTION_LOG_TIMER_ADDR
	sw	k1, EXCEPTION_LOG_TIMER(k0)
#endif
#ifdef EXCEPTION_LOG_CAUSE
	mfc0	k1, CP0_CAUSE
	sw	k1, EXCEPTION_LOG_CAUSE(k0)
#endif
#ifdef EXCEPTION_LOG_BADV
	mfc0	k1, CP0_BADVADDR
	sw	k1, EXCEPTION_LOG_BADV(k0)
#endif
#ifdef EXCEPTION_LOG_STATUS
	mfc0	k1, CP0_STATUS
	sw	k1, EXCEPTION_LOG_STATUS(k0)
#endif
	j	except_vec3_generic
	nop
	END(excdbg_vec3_handler)
	.set	at
	.set	noreorder
#endif /* EXCEPTION_DEBUG */
