/* $Id: kbd-jmi39io2.c,v 1.1.1.1 2004/04/07 08:36:50 louistsai Exp $
 *
 * Based on arch/mips/lib/kbd-std.c
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Routines for standard PC style keyboards accessible via I/O ports.
 *
 * Copyright (C) 2000-2001 Toshiba Corporation
 */
#include <linux/config.h>
#include <linux/init.h>
#include <linux/ioport.h>
#include <linux/sched.h>
#include <linux/pc_keyb.h>
#include <asm/keyboard.h>
#include <asm/io.h>
#include <asm/toshiba-boards/jmi39io2.h>

static unsigned long jmi39io2_kbd_port;
static int jmi39io2_kbd_irq;
static int jmi39io2_aux_irq;

#define JMI39IO2_KBD_DATA_REG	jmi39io2_kbd_port
#define JMI39IO2_KBD_STATUS_REG	(jmi39io2_kbd_port+4)
#define JMI39IO2_KBD_CNTL_REG	(jmi39io2_kbd_port+4)

static void jmi39io2_kbd_request_region(void)
{
	request_region(jmi39io2_kbd_port, 16, "keyboard");
}

static int jmi39io2_kbd_request_irq(void (*handler)(int, void *, struct pt_regs *))
{
	return request_irq(jmi39io2_kbd_irq, handler, 0, "keyboard", NULL);
}

static int jmi39io2_aux_request_irq(void (*handler)(int, void *, struct pt_regs *))
{
	return request_irq(jmi39io2_aux_irq, handler, 0, "PS/2 Mouse", NULL);
}

static void jmi39io2_aux_free_irq(void)
{
	free_irq(jmi39io2_aux_irq, NULL);
}

static unsigned char jmi39io2_kbd_read_input(void)
{
	return inb(JMI39IO2_KBD_DATA_REG);
}

static void jmi39io2_kbd_write_output(unsigned char val)
{
	int status;

	do {
		status = inb(JMI39IO2_KBD_CNTL_REG);
	} while (status & KBD_STAT_IBF);
	outb(val, JMI39IO2_KBD_DATA_REG);
	wbflush();
}

static void jmi39io2_kbd_write_command(unsigned char val)
{
	int status;

	do {
		status = inb(JMI39IO2_KBD_CNTL_REG);
	} while (status & KBD_STAT_IBF);
	outb(val, JMI39IO2_KBD_CNTL_REG);
	wbflush();
}

static unsigned char jmi39io2_kbd_read_status(void)
{
	return inb(JMI39IO2_KBD_STATUS_REG);
}

struct kbd_ops jmi39io2_kbd_ops = {
	jmi39io2_kbd_request_region,
	jmi39io2_kbd_request_irq,

	jmi39io2_aux_request_irq,
	jmi39io2_aux_free_irq,

	jmi39io2_kbd_read_input,
	jmi39io2_kbd_write_output,
	jmi39io2_kbd_write_command,
	jmi39io2_kbd_read_status
};

void __init jmi39io2_kbd_init(void)
{
	jmi39io2_kbd_port = JMI39IO2_KBD_ADDR(jmi39io2_iob_base) - mips_io_port_base;
	jmi39io2_kbd_irq = jmi39io2_isac_irq_base + JMI39IO2_ISAC_INTB_IRQKB;
	jmi39io2_aux_irq = jmi39io2_isac_irq_base + JMI39IO2_ISAC_INTB_IRQMOUSE;
	kbd_ops = &jmi39io2_kbd_ops;
}
