#include <linux/config.h>
#include <asm/delay.h>
#include <asm/mconfig.h>

#define sdelay()        udelay(2)
#define ldelay()        udelay(200) 

#if defined(CONFIG_MCT_SG100)

#define SWITCH_SMI_REG	0xb4000000
#define SWITCH_SMI_MDIO	0x01
#define SWITCH_SMI_MDC	0x02

#define SMI_CL_DL()	*(volatile unsigned char *) SWITCH_SMI_REG = 0x00
#define SMI_CL_DH()	*(volatile unsigned char *) SWITCH_SMI_REG = SWITCH_SMI_MDIO
#define SMI_CH_DL()	*(volatile unsigned char *) SWITCH_SMI_REG = SWITCH_SMI_MDC
#define SMI_CH_DH()	*(volatile unsigned char *) SWITCH_SMI_REG = SWITCH_SMI_MDC | SWITCH_SMI_MDIO

#define SMI_DATA()	(*(volatile unsigned char *) SWITCH_SMI_REG) & SWITCH_SMI_MDIO

#elif defined(CONFIG_MCT_SA100)
#include <asm/tx3927.h>

#define CPU_GPIO_SCK_BIT	0x00002000
#define CPU_GPIO_SDA_BIT	0x00001000

#define SMI_CL_DL()	tx3927_pioptr->dout = tx3927_pioptr->din & ~(CPU_GPIO_SCK_BIT|CPU_GPIO_SDA_BIT)
#define SMI_CL_DH()	tx3927_pioptr->dout = (tx3927_pioptr->din & ~(CPU_GPIO_SCK_BIT)) | CPU_GPIO_SDA_BIT
#define SMI_CH_DL()	tx3927_pioptr->dout = (tx3927_pioptr->din & ~(CPU_GPIO_SDA_BIT)) | CPU_GPIO_SCK_BIT
#define SMI_CH_DH()	tx3927_pioptr->dout = tx3927_pioptr->din | (CPU_GPIO_SCK_BIT|CPU_GPIO_SDA_BIT)

#define SMI_DATA()	tx3927_pioptr->din & CPU_GPIO_SDA_BIT

#elif defined(CONFIG_MCT_SG4100) || defined(CONFIG_MCT_SA200)
#include <asm/tx4925.h>

#define CPU_GPIO_SCK_BIT	0x00001000
#define CPU_GPIO_SDA_BIT	0x00002000

#define SMI_CL_DL()	tx4925_pioptr->dout = tx4925_pioptr->din & ~(CPU_GPIO_SCK_BIT|CPU_GPIO_SDA_BIT)
#define SMI_CL_DH()	tx4925_pioptr->dout = (tx4925_pioptr->din & ~(CPU_GPIO_SCK_BIT)) | CPU_GPIO_SDA_BIT
#define SMI_CH_DL()	tx4925_pioptr->dout = (tx4925_pioptr->din & ~(CPU_GPIO_SDA_BIT)) | CPU_GPIO_SCK_BIT
#define SMI_CH_DH()	tx4925_pioptr->dout = tx4925_pioptr->din | (CPU_GPIO_SCK_BIT|CPU_GPIO_SDA_BIT)

#define SMI_DATA()	tx4925_pioptr->din & CPU_GPIO_SDA_BIT

#endif

//#define SMI_ADDR(phy, reg)	((phy<<5) | reg)

static void send_smi(unsigned int val, int count)
{
	int		i;
	unsigned int	mask;

	mask = 0x80000000;
	for (i = 0; i < count; i++, mask>>=1) {
		if ( val & mask ) {
			sdelay();
			//outb(SMI_MDIO, CPLD_SMI_REG);
			SMI_CL_DH();
			sdelay();
			//outb(SMI_MDC|SMI_MDIO, CPLD_SMI_REG);
			SMI_CH_DH();
		} else {
			sdelay();
			//outb(0x00, CPLD_SMI_REG);
			SMI_CL_DL();
			sdelay();
			//outb(SMI_MDC, CPLD_SMI_REG);
			SMI_CH_DL();
		}
	}
}

static unsigned short smi_read_data(void)
{
	unsigned short val;
	int		i, signal;

	val = 0;
	for (i = 0; i < 16; i++) {
		sdelay();
		//outb(SMI_MDIO, CPLD_SMI_REG);
		SMI_CL_DH();
		sdelay();
		//outb(SMI_MDC|SMI_MDIO, CPLD_SMI_REG);
		SMI_CH_DH();
		sdelay();
		//signal = inb(CPLD_SMI_REG) & SMI_MDIO;
		signal = SMI_DATA();
		if ( signal ) {
			val = (val << 1) | 0x01;
		} else {
			val <<= 1;
		}
	}

	return val;
}

static void smi_write_data(unsigned short val)
{
	int	i;
	unsigned short mask;

	for (i = 0, mask=0x8000; i < 16; i++, mask>>=1) {
		if ( val & mask ) {
			//outb(SMI_MDIO, CPLD_SMI_REG);
			SMI_CL_DH();
			sdelay();
			//outb(SMI_MDC|SMI_MDIO, CPLD_SMI_REG);
			SMI_CH_DH();
			sdelay();
		} else {
			//outb(SMI_MDIO, CPLD_SMI_REG);
			SMI_CL_DH();
			sdelay();
			//outb(SMI_MDC, CPLD_SMI_REG);
			SMI_CH_DL();
			sdelay();
		}
	}
}

static unsigned short smi_read(unsigned int addr)
{
	unsigned short	val;

	/* send preamble sequence */
	send_smi(0xffffffff, 32);
	send_smi(0x60000000, 4);	/* Start bit and OP code for read operation */
	send_smi(addr<<22, 10);
	send_smi(0xc0000000, 1);	/* Turn around cycle */
	val = smi_read_data();

	/* place both MDC and MDIO signal in high impedance state */
	sdelay();
	//outb(SMI_MDC|SMI_MDIO, CPLD_SMI_REG);
	SMI_CH_DH();

	return val;
}

static void smi_write(unsigned int addr, unsigned short val)
{
	/* send preamble sequence */
	send_smi(0xffffffff, 32);
	send_smi(0x50000000, 4);	/* Start bit and OP code for write operation */
	send_smi(addr<<22, 10);
	send_smi(0x80000000, 2);	/* Turn around cycle */
	smi_write_data(val);

	sdelay();
	//outb(SMI_MDC|SMI_MDIO, CPLD_SMI_REG);
	SMI_CH_DH();
}

void get_switch_status(SWITCH_STATUS *status)
{
	unsigned short	phy;
	unsigned short	phy_ctrl, phy_status;

	for (phy = 0; phy < 4; phy++) {
        	phy_ctrl = smi_read((phy << 5) | 0x00);
		status->speed[phy] = (phy_ctrl & 0x2000) ? 100 : 10;
		status->full_duplex[phy] = (phy_ctrl & 0x0100) ? 1 : 0;
	}

	for (phy = 0; phy < 4; phy++) {
        	phy_status = smi_read((phy << 5) | 0x01);
		status->linkup[phy] = (phy_status & 0x0004) ? 1 : 0;
	}
}

