/*
 * Setup the right wbflush routine for TOSHIBA TX-RISC.
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2001 Toshiba Corporation
 */

#include <linux/init.h>
#include <asm/addrspace.h>
#include <asm/bootinfo.h>
#include <asm/cpu.h>
#include <asm/mipsregs.h>
#include <asm/system.h>

void (*__wbflush) (void);

static void wbflush_generic(void)
{
	*(volatile int *)KSEG1;
}

static void wbflush_tx39(void)
{
        /*
         * The status of the writeback buffer is available
         * via the Coprocessor 0 condition
         */
	__asm__ __volatile__(
		".set    push\n\t"
		".set    noreorder\n\t"
		"1: bc0f    1b\n\t"
		"nop\n\t"
		".set pop"
	);
}
static void wbflush_tx49(void)
{
	__asm__ __volatile__(
		".set    push\n\t"
		".set    mips2\n\t"
		"sync\n\t"
		".set pop"
	);
}


void __init wbflush_setup(void)
{
	switch(mips_cpu.cputype) {
	case CPU_TX3912:
	case CPU_TX3922:
	case CPU_TX3927:
	case CPU_TX39XX:
		if ((mips_cpu.processor_id & 0xffff) == (PRID_IMP_TX39 | 0x0050))
			__wbflush = wbflush_tx49; /* TX39H3 */
		else
			__wbflush = wbflush_tx39;
		break;
	case CPU_TX49XX:
		__wbflush = wbflush_tx49;
		break;
	default:
		__wbflush = wbflush_generic;
	}
}

