
#include <linux/kernel.h>
#include <linux/interrupt.h>
#include <linux/sched.h>
#include <linux/signal.h>
#include <linux/init.h>
#include <linux/reboot.h>
#include <asm/tx4925.h>
#include <linux/mount.h>
#include <asm/reboot.h>

/*static*/ DECLARE_WAIT_QUEUE_HEAD(shutdown_wq);
int shutdown_type = LINUX_REBOOT_CMD_POWER_OFF;


static char task_name[][16] = {
	"smbd", "nmbd", "nfsd", "atalkd", "ftpd"
};

#define MAX_SERVICES	256

typedef struct {
	struct list_head list;
	int	pid;
	char	*task_name;
} SERVICE;

SERVICE service[MAX_SERVICES];

static LIST_HEAD(service_list);

extern struct list_head vfsmntlist;
extern int do_umount(struct vfsmount *mnt, int flags);

static int shutdown_thread(void *dummy)
{
	int	i, nservices;
	struct list_head *slist;
	SERVICE	*pservice;

	struct task_struct *p;
        struct task_struct *tsk = current;
	DECLARE_WAITQUEUE(wait, tsk);
	struct list_head *pmnt;
	struct vfsmount *vfsmnt;

        tsk->session = 1;
        tsk->pgrp = 1;
        tsk->flags |= PF_MEMALLOC;
        strcpy(tsk->comm, "shutdownd");
        tsk->tty = NULL;
        spin_lock_irq(&tsk->sigmask_lock);
        sigfillset(&tsk->blocked);
        recalc_sigpending(tsk);
        spin_unlock_irq(&tsk->sigmask_lock);

	add_wait_queue(&shutdown_wq, &wait);
	set_current_state(TASK_INTERRUPTIBLE);
	schedule();

	nservices = 0;
	for (i = 0; i < sizeof(task_name) / sizeof(task_name[0]); i++) {
		for_each_task(p) {
			if ( nservices >= MAX_SERVICES )
				break;
			if ( strcmp(task_name[i], p->comm) == 0 ) {
				list_add_tail(&service[nservices].list, &service_list);
				service[nservices].pid = p->pid;
				service[nservices].task_name = task_name[i];
				nservices++;
				printk("Sending termination signal to %s(%d)\n", p->comm, p->pid);
				force_sig(SIGTERM, p);
			}
		}
	}
		
        while ( 1 ) {
		struct list_head *slist_next;
		for (slist = service_list.next; slist != &service_list; ) {
			pservice = (SERVICE *) list_entry(slist, SERVICE, list);
			for_each_task(p) {
				if ( strcmp(pservice->task_name, p->comm) == 0 && pservice->pid == p->pid )
					break;
			}

			slist_next = slist->next;
			if ( p == &init_task ) {
				printk("Shutdown %s(%d)\tOK\n", pservice->task_name, pservice->pid);
				list_del(slist);
			}
			slist = slist_next;
		}

		if ( list_empty(&service_list) )
			break;
		schedule_timeout(HZ);
	}

#if 1
	list_for_each(pmnt, &vfsmntlist) {
		vfsmnt = list_entry(pmnt, struct vfsmount, mnt_list);	
		//printk("devname = %s\n", vfsmnt->mnt_devname);
		if ( strcmp("/dev/hda1", vfsmnt->mnt_devname) == 0 ) {
			printk("trying umount /dev/hda1\n");
			do_umount(vfsmnt, 0);
			break;
		}
	}
#else
	printk("Umount file system\n");
	sys_umount("/dev/hda1", 0);
#endif

	sys_sync();
	sys_reboot(LINUX_REBOOT_MAGIC1, LINUX_REBOOT_MAGIC2, shutdown_type, NULL);

        return 0;
}

static void power_interrupt(int irq, void *dev_id, struct pt_regs *pregs)
{
	printk("Power: power button pressed\n");
	
	// clear edge interrupt
	tx4925_ircptr->scr = 0x105;

	free_irq(31, NULL);
	
	wake_up_interruptible(&shutdown_wq);
}

static int __init power_init(void)
{
	int	result;

	// set falling edge trigger
	tx4925_ircptr->cr[0] = (tx4925_ircptr->cr[0] & 0xffff3fff) | 0x00008000;
	kernel_thread(shutdown_thread, NULL, CLONE_FS|CLONE_FILES|CLONE_SIGHAND);

	result = request_irq(31, power_interrupt, SA_INTERRUPT, "power", NULL);
	if ( result ) {
		printk("Power: fail to request power interrupt.\n");
		return result;
	}

	printk("Power: function of power button was initialised\n");

	return 0;
}
__initcall(power_init);
