/*
 * linux/arch/mips/toshiba-boards/rbtx4925/setup.c
 * $Id: setup.c,v 1.1.1.1 2004/04/07 08:36:50 louistsai Exp $
 *
 * Setup pointers to hardware-dependent routines.
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2001 Toshiba Corporation
 */

#include <linux/config.h>
#include <linux/init.h>
#include <linux/types.h>
#include <linux/ioport.h>
#include <linux/kdev_t.h>
#include <linux/pci.h>
#include <linux/delay.h>
#include <asm/system.h>
#include <asm/reboot.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/mct-boards/pmon.h>
#include <asm/mct-boards/pci.h>
#include <asm/mct-boards/rbtx4925.h>
#include <asm/mct-boards/jmi39io2.h>
#include <asm/bootinfo.h>
#include <asm/cpu.h>
#include <asm/pci.h>
#include <asm/time.h>
#include <asm/mipsregs.h>
#include <asm/ptrace.h>
#if defined(CONFIG_SERIAL_TXX927)
#include <asm/serial_txx927.h>
#endif

/*static*/ int rbtx4925_ccfg_toeon = 1;
/*static*/ int rbtx4925_pcic_trdyto = 0;	/* default: disabled */

extern struct pci_ops rbtx4925_pci_ops;
extern int rbtx4925_pci_map_irq(struct pci_dev *dev, u8 slot, u8 pin);
extern void rbtx4925_irq_setup(void) __init;
extern void rbtx4925_time_init(void) __init;
extern void rbtx4925_timer_setup(struct irqaction *irq) __init;

#ifdef CONFIG_REMOTE_DEBUG
extern int __init early_serial_txx927_kgdb_setup(int line, unsigned long base, int irq, int baud_base);
extern void breakpoint(void);
#define TOMON(s) printk(s); breakpoint(); pmon_halt()
#else
#define TOMON(s) pmon_printf(s); pmon_halt()
#endif
extern void wait_for_keypress(void);

static void rbtx4925_machine_restart(char *command)
{
	unsigned long addr = 0xbfc00000;

	cli();

	__asm__ __volatile__(
		"j %0\n"
		:
		: "r" (addr)
		);
}

#if defined(CONFIG_MCT_SA200)
static void sa200_machine_halt(void)
{
        tx4925_pioptr->dout = 0xffffffff;
}
#endif

static void rbtx4925_machine_halt(void)
{
	cli();
	printk("Press any key to reboot.\n");
	wait_for_keypress();
	*rbtx4925_softresetlock_ptr = 1;
	*rbtx4925_softreset_ptr = 1;
	wbflush();
	while(1);
}

static void rbtx4925_machine_power_off(void)
{
	cli();
	printk("Press any key to reboot.\n");
	wait_for_keypress();
	*rbtx4925_softresetlock_ptr = 1;
	*rbtx4925_softreset_ptr = 1;
	wbflush();
	while(1);
}

extern void (*ibe_board_handler)(struct pt_regs *regs);
extern void (*dbe_board_handler)(struct pt_regs *regs);
static void rbtx4925_be_board_handler(struct pt_regs *regs)
{
	extern void tx4925_report_pcic_status(void);
	printk("%cBE exception at 0x%08lx\n",
	       (regs->cp0_cause & (1<<2)) ? 'D' : 'I', regs->cp0_epc);
	printk("ccfg:%08lx, toea:%08lx\n",
	       tx4925_ccfgptr->ccfg, tx4925_ccfgptr->toea);
	tx4925_report_pcic_status();
	show_regs(regs);
	TOMON("BusError!\n");
	while(1);
}
void __init rbtx4925_setup_be_board_handler(void)
{
	ibe_board_handler = rbtx4925_be_board_handler;
	dbe_board_handler = rbtx4925_be_board_handler;
}

static int rbtx4925_cpu_clock;

unsigned long rbtx4925_ce_base[8];
static unsigned long rbtx4925_ce_size[8];

static unsigned long __init
rbtx4925_find_free_region(int n,
			  unsigned long *bases,
			  unsigned long *sizes,
			  unsigned long begin,
			  unsigned long end,
			  unsigned long *size)
{
	unsigned long base;
	unsigned long sz = *size;
	int i;

	for (; sz; sz /= 2) {
		for (base = begin / sz * sz; base < end; base += sz) {
			for (i = 0; i < n; i++) {
				if (sizes[i] &&
				    base <= bases[i] + (sizes[i] - 1) &&
				    base + (sz - 1) >= bases[i])
					break;
			}
			if (i == n) {
				*size = sz;
				return base;
			}
		}
	}
	return 0;
}

#ifdef CONFIG_PCI
/* setup rbtx4925_pci_{mem,io}_{base,size} */
static unsigned long rbtx4925_pci_mem_base;
static unsigned long rbtx4925_pci_mem_size = 0x08000000; /* MAX 128M */
static unsigned long rbtx4925_pci_io_base;
static unsigned long rbtx4925_pci_io_size = 0x01000000;	/* MAX 16M */

static void __init rbtx4925_setup_pci_regions(void)
{
	unsigned long base[4+8+1];
	unsigned long size[4+8+1];
	unsigned long mbegin, mend;
	int i;

	if (rbtx4925_pci_mem_base || rbtx4925_pci_io_base)
		return;	/* done */

	for (i = 0; i < sizeof(base) / sizeof(base[0]); i++)
		base[i] = size[i] = 0;
	for (i = 0; i < 4; i++) {
		if (!(tx4925_sdramcptr->cr[i] & 0x00000200))
			continue;	/* disabled */
		base[i] = tx4925_sdramcptr->cr[i] & 0xffe00000;
		size[i] = ((tx4925_sdramcptr->cr[i] >> 10) + 1) << 21;
	}
	for (i = 0; i < 8; i++) {
		if (!(tx4925_ebuscptr->ch[i].cr & 0x8))
			continue;	/* disabled */
		base[i+4] = rbtx4925_ce_base[i];
		size[i+4] = rbtx4925_ce_size[i];
	}
	mbegin = base[0] + size[0];	/* end of SDRAM ch 0 */
	mend = base[4];	/* begin of CE0 */

	rbtx4925_pci_mem_base =
		rbtx4925_find_free_region(sizeof(base) / sizeof(base[0]),
					  base, size, mbegin, mend,
					  &rbtx4925_pci_mem_size);
	base[4+8] = rbtx4925_pci_mem_base;
	size[4+8] = rbtx4925_pci_mem_size;

	rbtx4925_pci_io_base =
		rbtx4925_find_free_region(sizeof(base) / sizeof(base[0]),
					  base, size, mbegin, mend,
					  &rbtx4925_pci_io_size);
}

static void __init rbtx4925_pci_setup(void)
{
	unsigned long sdram_size;

	/* SDRAMC are configured by PROM */
	sdram_size = 1;
	while (sdram_size + KSEG0 < toshibaboards_memory_upper)
		sdram_size <<= 1;

	printk("TX4925 PCIC -- DID:%04x VID:%04x RID:%02x Arbiter:%s\n",
	       (unsigned short)(tx4925_pcicptr->pciid >> 16),
	       (unsigned short)(tx4925_pcicptr->pciid & 0xffff),
	       (unsigned short)(tx4925_pcicptr->pciccrev & 0xff),
	       (tx4925_ccfgptr->ccfg & TX4925_CCFG_PCIARB) ? "External" : "Internal");

	/* GB->PCI mappings */
	tx4925_pcicptr->g2pcfg = 0 /* | TX4925_PCIC_G2PCFG_IRBER */;
#ifdef __BIG_ENDIAN
	tx4925_pcicptr->g2pcfg |=
		TX4925_PCIC_G2PCFG_BSWAPM0 |
		TX4925_PCIC_G2PCFG_BSWAPM1 |
		TX4925_PCIC_G2PCFG_BSWAPM2 |
		TX4925_PCIC_G2PCFG_BSWAPIO |
		TX4925_PCIC_G2PCFG_BSWAPI;
#endif
	tx4925_pcicptr->g2piomask = rbtx4925_pci_io_size - 1;
	tx4925_pcicptr->g2piogbase = rbtx4925_pci_io_base;
	tx4925_pcicptr->g2piopbase = 0;
	tx4925_pcicptr->g2pmmask[0] = rbtx4925_pci_mem_size - 1;
	tx4925_pcicptr->g2pm0gbase = rbtx4925_pci_mem_base;
	tx4925_pcicptr->g2pm0pbase = rbtx4925_pci_mem_base;
	tx4925_pcicptr->g2pmmask[1] = 0;
	tx4925_pcicptr->g2pm1gbase = 0;
	tx4925_pcicptr->g2pm1pbase = 0;
	tx4925_pcicptr->g2pmmask[2] = 0;
	tx4925_pcicptr->g2pm2gbase = 0;
	tx4925_pcicptr->g2pm2pbase = 0;
	/* PCI->GB mappings (I/O disable) */
	tx4925_pcicptr->p2gioctr = 0;
	/* PCI->GB mappings (MEM) */
	tx4925_pcicptr->p2gm0plbase = 0;
	tx4925_pcicptr->p2gm0gbase = 0;
	tx4925_pcicptr->p2gm0ctr =
		((sdram_size - 1) & TX4925_PCIC_P2GMnCTR_AM) |
		TX4925_PCIC_P2GMnCTR_TPRBL_8DW |
		TX4925_PCIC_P2GMnCTR_TMCE |
		TX4925_PCIC_P2GMnCTR_PE |
#ifdef __BIG_ENDIAN
		TX4925_PCIC_P2GMnCTR_BSWAP |
#endif
		TX4925_PCIC_P2GMnCTR_EN;
	tx4925_pcicptr->p2gm1ctr = 0;
	tx4925_pcicptr->p2gm2ctr = 0;

	/* Enable Initiator Memory Space */
	if (rbtx4925_pci_mem_base)
		tx4925_pcicptr->g2pcfg |= TX4925_PCIC_G2PCFG_G2PM0EN;
	if (rbtx4925_pci_io_base)
		tx4925_pcicptr->g2pcfg |= TX4925_PCIC_G2PCFG_G2PIOEN;
	/* Enable Target access */
	tx4925_pcicptr->pciccfg &= TX4925_PCIC_PCICCFG_GBWC_MASK;
	tx4925_pcicptr->pciccfg |=
		TX4925_PCIC_PCICCFG_TCAR;

	/* Do not use MEMMUL, MEMINF: YMFPCI card causes M_ABORT. */
	tx4925_pcicptr->pcicfg1 = 0;

	if (rbtx4925_pcic_trdyto >= 0) {
		tx4925_pcicptr->g2ptocnt &= ~0xff;
		tx4925_pcicptr->g2ptocnt |= (rbtx4925_pcic_trdyto & 0xff);
		printk(KERN_DEBUG "TX4925 PCIC -- TRDYTO:%02lx\n",
		       tx4925_pcicptr->g2ptocnt & 0xff);
	}

	/* Clear All Local Bus Status */
	tx4925_pcicptr->pcicstatus = TX4925_PCIC_PCICSTATUS_ALL;
	/* Enable All Local Bus Interrupts */
	tx4925_pcicptr->pcicmask = TX4925_PCIC_PCICSTATUS_ALL;
	/* Clear All Initiator Status */
	tx4925_pcicptr->g2pstatus = TX4925_PCIC_G2PSTATUS_ALL;
	/* Enable All Initiator Interrupts */
	tx4925_pcicptr->g2pmask = TX4925_PCIC_G2PSTATUS_ALL;
#if 1
	/* PCI configuration access, IO port probing cause MDFE. ignore it. */
	tx4925_pcicptr->g2pmask &= ~TX4925_PCIC_G2PSTATUS_MDFE;
#endif
	/* Clear All PCI Status Error */
	tx4925_pcicptr->pcistatus =
		(tx4925_pcicptr->pcistatus & 0x0000ffff) |
		(TX4925_PCIC_PCISTATUS_ALL << 16);
	/* Enable All PCI Status Error Interrupts */
	tx4925_pcicptr->pcimask = TX4925_PCIC_PCISTATUS_ALL;

	/* PCIC Int => IRC IRQ16 */
	tx4925_pcicptr->pcicfg2 =
		(tx4925_pcicptr->pcicfg2 & 0xffffff00) |
		TX4925_IR_PCIC;

	if (tx4925_ccfgptr->ccfg & TX4925_CCFG_PCIARB) {
		/* XXX */
	} else {
		/* Reset Bus Arbiter */
		tx4925_pcicptr->pbacfg = TX4925_PCIC_PBACFG_RPBA;
		/*
		 * swap reqBP and reqXP (raise priority of PCI-ISA bridge).
		 * SLC90E66(PCI-ISA bridge) are connected to REQ2 on
		 * PCI Backplane board.
		 */
		tx4925_pcicptr->pbareqport = 0x72543610;
		tx4925_pcicptr->pbabm = 0;
		/* Use Fixed ParkMaster (required by PCI-ISA bridge) */
		tx4925_pcicptr->pbacfg = TX4925_PCIC_PBACFG_FIXPA;
		/* Enable Bus Arbiter */
		tx4925_pcicptr->pbacfg |= TX4925_PCIC_PBACFG_PBAEN;
	}

	tx4925_pcicptr->pcistatus = PCI_COMMAND_MASTER |
		PCI_COMMAND_MEMORY |
		PCI_COMMAND_PARITY | PCI_COMMAND_SERR;
}
#endif /* CONFIG_PCI */

#if 0
/* use CE5,6,7 for PCMCIA (ATTR,MEM:64MB, IO:1MB) */
static void __init rbtx4925_pcmcia_setup(void)
{
	unsigned long sp = (tx4925_ccfgptr->ccfg >> 6) & 3; /* SYSSP */
	unsigned long pcm[] = { 3 /*ATTR*/, 1 /*MEM*/, 2 /*IO*/ };
	unsigned long pcm_ce[] = { 7, 6, 5 };
	unsigned long pcm_size[] = { 0x4000000, 0x4000000, 0x100000 };
	/* use high memory address for ATTR, MEM */
	unsigned long pcm_begin[] = { 0xf0000000, 0xf0000000, 0x10000000 };
	unsigned long pcm_end[] = { 0xff000000, 0xff000000, 0x1c000000 };
	int i;

	for (i = 0; i < sizeof(pcm) / sizeof(pcm[0]); i++) {
		if (rbtx4925_ce_base[pcm_ce[i]])
			return;
	}
	for (i = 0; i < sizeof(pcm) / sizeof(pcm[0]); i++) {
		/* find free regions */
		unsigned long ce_base, ce_size;
		ce_size = pcm_size[i];
		ce_base = rbtx4925_find_free_region(8,
						    rbtx4925_ce_base,
						    rbtx4925_ce_size,
						    pcm_begin[i], pcm_end[i],
						    &ce_size);
		if (ce_base && ce_size == pcm_size[i]) {
			int cs = 0;
			while ((0x100000 << cs) < ce_size)
				cs++;
			tx4925_ebuscptr->ch[pcm_ce[i]].bar = ce_base;
				/* 16bit width, SYSCLK speed */
				/* FIXME: tune PWT,WT,SHWT */
			tx4925_ebuscptr->ch[pcm_ce[i]].cr =
				0x0063f04f |
				(pcm[i] << 24) | (cs << 8) | (sp << 4);
			rbtx4925_ce_base[pcm_ce[i]] = ce_base;
			rbtx4925_ce_size[pcm_ce[i]] = ce_size;
		}
	}
}
#endif

static void __init tx4925_setup(void)
{
	int i;

	/* SDRAMC,EBUSC are configured by PROM */
	for (i = 0; i < 8; i++) {
		if (!(tx4925_ebuscptr->ch[i].cr & 0x8))
			continue;	/* disabled */
		rbtx4925_ce_base[i] = tx4925_ebuscptr->ch[i].bar;
		rbtx4925_ce_size[i] = 0x00100000 << ((tx4925_ebuscptr->ch[i].cr >> 8) & 0xf);
	}

#if 0
	/* use CE5,6,7 for PCMCIA (ATTR,MEM:64MB, IO:1MB) */
	if (!(tx4925_ccfgptr->ccfg & TX4925_CCFG_PCTRCE) &&
	    (tx4925_ccfgptr->pcfg & TX4925_PCFG_SELCARD(0))) {
		rbtx4925_pcmcia_setup();
	}
#endif

	rbtx4925_cpu_clock = RBTX4925_MASTER_CLOCK * 4 * 5 / 2;
	switch (tx4925_ccfgptr->ccfg & TX4925_CCFG_RF_MASK) {
	case TX4925_CCFG_RF_DIV2:	rbtx4925_cpu_clock /= 2; break;
	case TX4925_CCFG_RF_DIV4:	rbtx4925_cpu_clock /= 4; break;
	case TX4925_CCFG_RF_DIV8:	rbtx4925_cpu_clock /= 8; break;
	}

	/* CCFG */
	/* enable Timeout BusError */
	if (rbtx4925_ccfg_toeon)
		tx4925_ccfgptr->ccfg |= TX4925_CCFG_TOE;

	/* clear BusErrorOnWrite flag */
	tx4925_ccfgptr->ccfg &= ~TX4925_CCFG_BEOW;

	/* DMA selection */
	tx4925_ccfgptr->drqctr = 0;

	printk("TX4925 -- %dMHz(M%dMHz) REVID:%08lx CCFG:%08lx PCFG:%08lx\n",
	       rbtx4925_cpu_clock / 1000000, RBTX4925_MASTER_CLOCK / 1000000,
	       tx4925_ccfgptr->revid,
	       tx4925_ccfgptr->ccfg, tx4925_ccfgptr->pcfg);

	printk("TX4925 SDRAMC --");
	for (i = 0; i < 4; i++) {
		if (!(tx4925_sdramcptr->cr[i] & 0x00000200))
			continue;	/* disabled */
		printk(" CR%d:%08lx", i, tx4925_sdramcptr->cr[i]);
	}
	printk(" TR:%08lx\n", tx4925_sdramcptr->tr);

	/* IRC */
	/* disable interrupt control */
	tx4925_ircptr->cer = 0;
	/* mask all IRC interrupts */
	tx4925_ircptr->imr = 0;
	for (i = 0; i < TX4925_NUM_IR / 4; i++) {
		tx4925_ircptr->ilr[i] = 0;
	}
	/* setup IRC interrupt mode (Low Active) */
	for (i = 0; i < TX4925_NUM_IR / 16; i++) {
		tx4925_ircptr->cr[i] = 0;
	}

	/* TMR */
	/* disable all timers */
	for (i = 0; i < TX4925_NR_TMR; i++) {
		tx4925_tmrptr(i)->tcr = TXx927_TMTCR_CRE;
		tx4925_tmrptr(i)->tisr = 0;
		tx4925_tmrptr(i)->cpra = 0xffffffff;
		tx4925_tmrptr(i)->itmr = 0;
		tx4925_tmrptr(i)->ccdr = 0;
		tx4925_tmrptr(i)->pgmr = 0;
	}

	/* DMA */
	tx4925_dmaptr->mcr = 0;
	for (i = 0; i < sizeof(tx4925_dmaptr->ch) / sizeof(tx4925_dmaptr->ch[0]); i++) {
		/* reset channel */
		tx4925_dmaptr->ch[i].ccr = TX4925_DMA_CCR_CHRST;
#ifdef __BIG_ENDIAN
		tx4925_dmaptr->ch[i].ccr = 0;
#else
		tx4925_dmaptr->ch[i].ccr = TX4925_DMA_CCR_LE;
#endif
	}
	/* enable DMA */
	tx4925_dmaptr->mcr = TX4925_DMA_MCR_MSTEN;

	/* PCIC */
#ifdef CONFIG_PCI
	rbtx4925_setup_pci_regions();

#if 0
	if (*rbtx4925_fpga_rev_ptr == 0x1f) {
		/* PCI is not supported on FPGA Ver 1f */
		/* Reset PCIC */
		tx4925_ccfgptr->clkctr &= ~TX4925_CLKCTR_PCIRSTI;
	} else {
		/* Reset PCI Bus */
		*rbtx4925_pcireset_ptr = 1;
		/* Reset PCIC */
		tx4925_ccfgptr->clkctr &= ~TX4925_CLKCTR_PCIRSTI;
		udelay(10000);
		/* clear PCIC reset */
		tx4925_ccfgptr->clkctr |= TX4925_CLKCTR_PCIRSTI;
		*rbtx4925_pcireset_ptr = 0;
	}
#endif
	rbtx4925_pci_setup();
#endif

	/* PIO */
#if 0
	/* PIO[2,0]: DIPSW , PIO[3,1]: LEDs */
	tx4925_pioptr->dir = 0x0000000a;
	tx4925_pioptr->maskcpu = 0;
	tx4925_pioptr->maskext = 0;
#endif
}

#if 0
#define JMI_CE	3

static int rbtx4925_check_iob(void)
{
	unsigned char idt;
	unsigned long flags;
	unsigned long romcr;
	save_and_cli(flags);
	romcr = tx4925_ebuscptr->ch[JMI_CE].cr;
	tx4925_ebuscptr->ch[JMI_CE].cr = romcr & ~0x40001000ull;	/* do not wait infinitely */
	idt = jmi39io2_isac_reg_in(JMI39IO2_ISAC_REV_ADDR(RBTX4925_IOB_BASE))
		& JMI39IO2_IDT_MASK;
	tx4925_ebuscptr->ch[JMI_CE].cr = romcr;
	restore_flags(flags);
	return idt == JMI39IO2_ISAC_IDT;
}
#endif

static struct resource rbtx4925_ebus_resources[8] = {
	{ "EBUS0", 0, 0, IORESOURCE_MEM },
	{ "EBUS1", 0, 0, IORESOURCE_MEM },
	{ "EBUS2", 0, 0, IORESOURCE_MEM },
	{ "EBUS3", 0, 0, IORESOURCE_MEM },
	{ "EBUS4", 0, 0, IORESOURCE_MEM },
	{ "EBUS5", 0, 0, IORESOURCE_MEM },
	{ "EBUS6", 0, 0, IORESOURCE_MEM },
	{ "EBUS7", 0, 0, IORESOURCE_MEM },
};
static struct resource tx4925_reg_resource = {
	"TX4925", TX4925_REG_BASE, TX4925_REG_BASE+TX4925_REG_SIZE, IORESOURCE_MEM
};

static struct resource rbtx4925_fpga_resource;
static struct resource rbtx4925_pcmcia_resource;

void __init sg4x00_setup(void)
{
	int i;
	unsigned long pcfg;

	tx4925_setup();

	board_time_init = rbtx4925_time_init;
	board_timer_setup = rbtx4925_timer_setup;
	irq_setup = rbtx4925_irq_setup;
	/* map ioport 0 to PCI I/O space address 0 */
	set_io_port_base(KSEG1ADDR(rbtx4925_pci_io_base));

	/* setup PCI area */
	toshibaboards_pci_io_resource.start = 0;
	toshibaboards_pci_io_resource.end = rbtx4925_pci_io_size - 1;
	toshibaboards_pci_mem_resource.start = rbtx4925_pci_mem_base;
	toshibaboards_pci_mem_resource.end =
		rbtx4925_pci_mem_base + rbtx4925_pci_mem_size - 1;

	/* TX4925 internal registers */
	iomem_resource.end = 0xffffffff;	/* 4GB */
	request_resource(&iomem_resource, &tx4925_reg_resource);
	/* reserve EBUS area */
	for (i = 0; i < 8; i++) {
		rbtx4925_ebus_resources[i].start = rbtx4925_ce_base[i];
		rbtx4925_ebus_resources[i].end =
			rbtx4925_ce_base[i] + rbtx4925_ce_size[i] - 1;
		if (rbtx4925_ebus_resources[i].start) {
			request_resource(&iomem_resource,
					 &rbtx4925_ebus_resources[i]);
		}
	}
#if 0
	rbtx4925_fpga_resource.name = "FPGA Registers";
	rbtx4925_fpga_resource.start =
		virt_to_bus((void *)RBTX4925_FPGA_REG_ADDR);
	rbtx4925_fpga_resource.end =
		virt_to_bus((void *)RBTX4925_FPGA_REG_ADDR) + 0xffff;
	rbtx4925_fpga_resource.flags = IORESOURCE_MEM | IORESOURCE_BUSY;
	request_resource(&rbtx4925_ebus_resources[2], &rbtx4925_fpga_resource);

	rbtx4925_pcmcia_resource.name = "PCMCIA Interface";
	rbtx4925_pcmcia_resource.start =
		virt_to_bus((void *)RBTX4925_PCMCIA_BASE);
	rbtx4925_pcmcia_resource.end =
		virt_to_bus((void *)RBTX4925_PCMCIA_BASE) + 0x48;
	rbtx4925_pcmcia_resource.flags = IORESOURCE_MEM | IORESOURCE_BUSY;
	request_resource(&rbtx4925_ebus_resources[2], &rbtx4925_pcmcia_resource);

	/* disable all OnBoard I/O interrupts */
	*rbtx4925_imask_ptr = 0;
	*rbtx4925_imask2_ptr = 0;
#endif

#if defined(CONFIG_MCT_SA200)
	_machine_restart = rbtx4925_machine_restart;
	_machine_halt = sa200_machine_halt;
	_machine_power_off = sa200_machine_halt;
#else
	_machine_restart = rbtx4925_machine_restart;
	_machine_halt = rbtx4925_machine_halt;
	_machine_power_off = rbtx4925_machine_power_off;
#endif
	toshibaboards_pci_ops = &rbtx4925_pci_ops;
	toshibaboards_pci_map_irq = rbtx4925_pci_map_irq;

	/* TX4925-SIO0 DTR on */
	*rbtx4925_siodtr_ptr = 0;
	/* setting PIOSEL by PCFG */
	pcfg = tx4925_ccfgptr->pcfg;
	*rbtx4925_piosel_ptr |= RBTX4925_PIOSEL_SIO(0);	/* always use SIO0 */
	*rbtx4925_piosel_ptr |= RBTX4925_PIOSEL_NOPCTOE;
#if 0
	if (pcfg & TX4925_PCFG_SELACLC) {
		/* disable SIO1, NAND */
		*rbtx4925_piosel_ptr &= ~RBTX4925_PIOSEL_SIO(1);
		*rbtx4925_piosel_ptr |= RBTX4925_PIOSEL_NOSMART;
		/* Enable ACLC */
		*rbtx4925_piosel_ptr &= ~RBTX4925_PIOSEL_NOACLINK;
	} else {
		/* disable ACLC */
		*rbtx4925_piosel_ptr |= RBTX4925_PIOSEL_NOACLINK;
		if (pcfg & TX4925_PCFG_SELNAND) {
			/* disable SIO1 */
			*rbtx4925_piosel_ptr &= ~RBTX4925_PIOSEL_SIO(1);
			/* enable NAND */
			*rbtx4925_piosel_ptr &= ~RBTX4925_PIOSEL_NOSMART;
		} else {
			/* disable NAND */
			*rbtx4925_piosel_ptr |= RBTX4925_PIOSEL_NOSMART;
			if (pcfg & TX4925_PCFG_SELSIO(1)) {
				/* enable SIO1 */
				*rbtx4925_piosel_ptr |= RBTX4925_PIOSEL_SIO(1);
			} else {
				/* disable SIO1 */
				*rbtx4925_piosel_ptr &= ~RBTX4925_PIOSEL_SIO(1);
			}
		}
	}
	if (!(tx4925_ccfgptr->ccfg & TX4925_CCFG_PCTRCE) &&
	    (pcfg & TX4925_PCFG_SELCARD(0))) {
		/* enable PCMCIA */
		*rbtx4925_piosel_ptr &= ~RBTX4925_PIOSEL_NOPCMCIA;
	} else {
		/* disable PCMCIA */
		*rbtx4925_piosel_ptr |= RBTX4925_PIOSEL_NOPCMCIA;
	}

	*rbtx4925_led_ptr = 0xff;
	printk("TOSHIBA RBTX4925 (Rev %02x) --- FPGA(Rev %02x)",
	       *rbtx4925_board_rev_ptr, *rbtx4925_fpga_rev_ptr);
	printk(" DIPSW:%02x PIOSEL:%02x\n",
	       *rbtx4925_dipsw_ptr, *rbtx4925_piosel_ptr);

	if (*rbtx4925_fpga_rev_ptr == 0x1f) {
		/* PCI is not supported on FPGA Ver 1f */
		toshibaboards_pci_ops = NULL;
	}

	if (rbtx4925_check_iob())
		jmi39io2_init(RBTX4925_IOB_BASE, RBTX4925_IRQ_ISAC);
	if (have_jmi39io2()) {
		/* XXX JMI39IO2 pulls down INT0.  So we can not use
                   IOC interrupt (including PCI interrupt). */
		toshibaboards_pci_ops = NULL;
		jmi39io2_kbd_init();
#ifdef CONFIG_BLK_DEV_IDE
		/* overrides PCI-IDE */
		jmi39io2_ide_init();
#endif
	}
#endif

#if defined(CONFIG_SERIAL_TXX927)
	for(i = 0; i < 2; i++) {
		if (i == 1) {
			/* disable SIO1 by PCFG setting */
			if ((pcfg & TX4925_PCFG_SELACLC) ||
			    (pcfg & TX4925_PCFG_SELNAND) ||
			    !(pcfg & TX4925_PCFG_SELSIO(1)))
				continue;
		}
		/* use Pre-scaler T0 (1/2) */
		early_serial_txx927_setup(i,
					  TX4925_SIO_REG(i),
					  RBTX4925_IRQ_IRC_SIO(i),
					  RBTX4925_IMCLK / 2 / 16,
					  0);
#ifdef CONFIG_REMOTE_DEBUG
		early_serial_txx927_kgdb_setup(i,
					       TX4925_SIO_REG(i),
					       RBTX4925_IRQ_IRC_SIO(i),
					       RBTX4925_IMCLK / 2 / 16);
#endif
	}
#endif

#if 0
#ifdef CONFIG_JMI39IO2_NET
	if (have_jmi39io2()) {
		early_jmi39io2_ether_setup(JMI39IO2_ETHER_ADDR(RBTX4925_IOB_BASE) - mips_io_port_base,
					   RBTX4925_IRQ_IRC_INT(JMI39IO2_INT_ETHER));
	}
#endif
#ifdef CONFIG_FB_E1355
	if (have_jmi39io2()) {
		early_e1355_setup(JMI39IO2_LCDVGA_REG_BASE(RBTX4925_IOB_BASE),
				  JMI39IO2_LCDVGA_MEM_BASE(RBTX4925_IOB_BASE));
	}
#endif
	if (!(*rbtx4925_piosel_ptr & RBTX4925_PIOSEL_NOPCMCIA)) {
		printk("PC Card Interface (ID %02x %02x %02x %02x)\n",
		       L1121_inb(L1121_IDR1),
		       L1121_inb(L1121_IDR2),
		       L1121_inb(L1121_IDR3),
		       L1121_inb(L1121_IDR4));
		/* do soft reset */
		L1121_outb(L1121_CR1_RESET, L1121_CR1);
		L1121_outb(0, L1121_CR1);

		/* disable all interrupt */
		L1121_outb(0, L1121_IER);
		/* edge trigger */
		L1121_outb(0xff, L1121_ITSR);
		/* clear pending interrupt */
		L1121_outb(0xff, L1121_ECLR);
	}
#endif
}
