/*
 *  linux/arch/mips/toshiba-boards/rbtx4925/time.c
 *
 * Copyright (C) 2001 Toshiba Corporation
 *
 * $Id: time.c,v 1.1.1.1 2004/04/07 08:36:50 louistsai Exp $
 */
#include <linux/errno.h>
#include <linux/init.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/param.h>
#include <linux/string.h>
#include <linux/mm.h>
#include <linux/interrupt.h>

#include <asm/bootinfo.h>
#include <asm/mipsregs.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/time.h>

#include <asm/toshiba-boards/rbtx4925.h>
extern void s3511a_init(void);
/* ne use onchip r4k counter or TMR timer as our system wide timer interrupt running at 100HZ. */
int rbtx4925_use_r4k_timer;
#define rbtx4925_tmrptr		tx4925_tmrptr(0)	/* TMR0 */

/* Tick Timer divider */
#define RBTX4925_TIMER_CCD	0	/* 1/2 */
#define RBTX4925_TIMER_CLK	(RBTX4925_IMCLK / (2 << RBTX4925_TIMER_CCD))

static void
rbtx4925_timer_interrupt(int irq, void *dev_id, struct pt_regs *regs)
{
	rbtx4925_tmrptr->tisr = 0;	/* ack interrupt */
	timer_interrupt(irq, dev_id, regs);
}

void __init rbtx4925_time_init(void)
{
	unsigned int ct0;
	int i;

	s3511a_init();
	if (tx4925_ccfgptr->ccfg & TX4925_CCFG_TINTDIS) {
		printk("Tick timer: use TX4925 timer0 interrupt.\n");
		rbtx4925_use_r4k_timer = 0;
	} else {
		printk("Tick timer: use r4k counter interrupt.\n");
		rbtx4925_use_r4k_timer = 1;
	}

	printk("calculating counter_frequency... ");

	rbtx4925_tmrptr->cpra = RBTX4925_TIMER_CLK / HZ;
	rbtx4925_tmrptr->itmr = TXx927_TMTITMR_TIIE | TXx927_TMTITMR_TZCE;
	rbtx4925_tmrptr->ccdr = RBTX4925_TIMER_CCD;
	rbtx4925_tmrptr->tcr =
		TXx927_TMTCR_TCE | TXx927_TMTCR_CCDE | TXx927_TMTCR_TMODE_ITVL;

	/* clear interval timer Int. */
	rbtx4925_tmrptr->tisr = 0;
	/* waiting for a new tick. */
	while (!(rbtx4925_tmrptr->tisr & TXx927_TMTISR_TIIS))
		;
	ct0 = read_32bit_cp0_register(CP0_COUNT);
	for (i = 0; i < 16; i++) {
		/* clear interval timer Int. */
		rbtx4925_tmrptr->tisr = 0;
		/* waiting for a next tick. */
		while (!(rbtx4925_tmrptr->tisr & TXx927_TMTISR_TIIS))
			;
	}
	mips_counter_frequency =
		(read_32bit_cp0_register(CP0_COUNT) - ct0) / 16 * HZ;
}

extern int setup_irq(unsigned int irq, struct irqaction *irqaction);
void __init rbtx4925_timer_setup(struct irqaction *irq)
{
	if (rbtx4925_use_r4k_timer) {
		unsigned int count;

		/* we are using the cpu counter for timer interrupts */
		setup_irq(RBTX4925_IRQ_LOCAL_TIMER, irq);

		/* to generate the first timer interrupt */
		count = read_32bit_cp0_register(CP0_COUNT);
		write_32bit_cp0_register(CP0_COMPARE, count + mips_counter_frequency / HZ);
	} else {
		/* wrap default timer interupt handler */
		irq->handler = rbtx4925_timer_interrupt;
#if 0	/* disabled by TINTDIS */
		/* disable counter interrupt(IM7) */
		set_cp0_status(STATUSF_IP7, 0);
#endif
		/* enable timer interrupt */
		setup_irq(RBTX4925_IRQ_IRC_TMR(0), irq);
	}
	printk("%08x(%d)\n", mips_counter_frequency, mips_counter_frequency);
}
