
#include <linux/init.h>
#include <linux/sched.h>
#include <linux/interrupt.h>
#include <asm/ptrace.h>		// for struct pt_regs

#include <asm/mct-boards/jmr3927.h>

#define watchdog_tmrptr	tx3927_tmrptr(2)
#define WATCHDOG_IRQ	JMR3927_IRQ_IRC_TMR(2)

#define WATCHDOG_TIMER_CCD	0	// 1/2
#define WATCHDOG_TIMER_CLK	(JMR3927_IMCLK / (2 << WATCHDOG_TIMER_CCD))

static struct timer_list	wdog_timer;

static void wdog_callback(unsigned long dummy)
{
	watchdog_tmrptr->wtmr |= TXx927_TMTWTMR_TWC;
	
	init_timer(&wdog_timer);
	wdog_timer.function = wdog_callback;
	wdog_timer.expires = jiffies + HZ/2;
	add_timer(&wdog_timer);
}

#if 0
void enable_watchdog(void)
{
	watchdog_tmrptr->tcr = TXx927_TMTCR_TCE | TXx927_TMTCR_CCDE | TXx927_TMTCR_TMODE_WDOG;

	init_timer(&wdog_timer);
	wdog_timer.function = wdog_callback;
	wdog_timer.expires = jiffies + HZ/2;
	add_timer(&wdog_timer);
}

void disable_watchdog(void)
{
	// WDIS  = 1
	watchdog_tmrptr->wtmr = TXx927_TMTWTMR_WDIS | TXx927_TMTWTMR_TWC;
	// TCE = 0
	watchdog_tmrptr->tcr = TXx927_TMTCR_TMODE_WDOG;

	del_timer(&wdog_timer);
}
#endif

/* Notice that the watchdog timer interrupt request is connected to the internal Reset circuit.
 * This setting was completed during system boot(setup.c).
 */
void __init watchdog_init(void)
{
	watchdog_tmrptr->cpra = WATCHDOG_TIMER_CLK;
	watchdog_tmrptr->wtmr = TXx927_TMTWTMR_TWIE | TXx927_TMTWTMR_TWC;
	watchdog_tmrptr->ccdr = WATCHDOG_TIMER_CCD;
	watchdog_tmrptr->tcr = TXx927_TMTCR_TCE | TXx927_TMTCR_CCDE | TXx927_TMTCR_TMODE_WDOG;

	init_timer(&wdog_timer);
	wdog_timer.function = wdog_callback;
	wdog_timer.expires = jiffies + HZ/2;
	add_timer(&wdog_timer);
}

