/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * IDE routines for typical pc-like standard configurations.
 *
 * Copyright (C) 2000-2001 Toshiba Corporation
 */
#include <linux/sched.h>
#include <linux/ioport.h>
#include <linux/hdreg.h>
#include <linux/ide.h>
#include <asm/ptrace.h>
#include <asm/toshiba-boards/jmi39io2.h>

extern struct ide_ops std_ide_ops;
static unsigned long jmi39io2_ide_port;
static int jmi39io2_ide_irq;

static int jmi39io2_ide_default_irq(ide_ioreg_t base)
{
	if (base == jmi39io2_ide_port)
		return jmi39io2_ide_irq;
	return std_ide_ops.ide_default_irq(base);
}

static ide_ioreg_t jmi39io2_ide_default_io_base(int index)
{
	if (index == 0)
		return jmi39io2_ide_port;
	return std_ide_ops.ide_default_io_base(index);
}

static void jmi39io2_ide_init_hwif_ports(hw_regs_t *hw,
				    ide_ioreg_t data_port,
				    ide_ioreg_t ctrl_port,
				    int *irq)
{
	std_ide_ops.ide_init_hwif_ports(hw, data_port, ctrl_port, irq);
	if (data_port == jmi39io2_ide_port) {
		if (!ctrl_port)
			hw->io_ports[IDE_CONTROL_OFFSET] += 0x00100000;
		if (irq)
			*irq = jmi39io2_ide_irq;
	}
}

static struct ide_ops jmi39io2_ide_ops;

void __init jmi39io2_ide_init(void)
{
	jmi39io2_ide_port = JMI39IO2_IDE_ADDR(jmi39io2_iob_base) - mips_io_port_base;
	/* irq_jmi39io2isac maps ISA irqs automagically... */
	jmi39io2_ide_irq = 12;
	/* jmi39io2_ide_irq = jmi39io2_isac_irq_base + JMI39IO2_ISAC_INTB_IRQ12; */

	jmi39io2_ide_ops = std_ide_ops;
	/* override */
	jmi39io2_ide_ops.ide_default_irq = jmi39io2_ide_default_irq,
	jmi39io2_ide_ops.ide_default_io_base = jmi39io2_ide_default_io_base,
	jmi39io2_ide_ops.ide_init_hwif_ports = jmi39io2_ide_init_hwif_ports,
	ide_ops = &jmi39io2_ide_ops;
}
